/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(OFFLINE_WEB_APPLICATIONS)

#include "JSDOMApplicationCache.h"

#include <wtf/GetPtr.h>

#include "DOMApplicationCache.h"
#include "DOMStringList.h"
#include "Event.h"
#include "EventListener.h"
#include "Frame.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMStringList.h"
#include "JSEvent.h"
#include "JSEventListener.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDOMApplicationCache)

/* Hash table */

static const HashTableValue JSDOMApplicationCacheTableValues[10] =
{
    { "status", DontDelete|ReadOnly, (intptr_t)jsDOMApplicationCacheStatus, (intptr_t)0 },
    { "items", DontDelete|ReadOnly, (intptr_t)jsDOMApplicationCacheItems, (intptr_t)0 },
    { "onchecking", DontDelete, (intptr_t)jsDOMApplicationCacheOnchecking, (intptr_t)setJSDOMApplicationCacheOnchecking },
    { "onerror", DontDelete, (intptr_t)jsDOMApplicationCacheOnerror, (intptr_t)setJSDOMApplicationCacheOnerror },
    { "onnoupdate", DontDelete, (intptr_t)jsDOMApplicationCacheOnnoupdate, (intptr_t)setJSDOMApplicationCacheOnnoupdate },
    { "ondownloading", DontDelete, (intptr_t)jsDOMApplicationCacheOndownloading, (intptr_t)setJSDOMApplicationCacheOndownloading },
    { "onprogress", DontDelete, (intptr_t)jsDOMApplicationCacheOnprogress, (intptr_t)setJSDOMApplicationCacheOnprogress },
    { "onupdateready", DontDelete, (intptr_t)jsDOMApplicationCacheOnupdateready, (intptr_t)setJSDOMApplicationCacheOnupdateready },
    { "oncached", DontDelete, (intptr_t)jsDOMApplicationCacheOncached, (intptr_t)setJSDOMApplicationCacheOncached },
    { 0, 0, 0, 0 }
};

static const HashTable JSDOMApplicationCacheTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 63, JSDOMApplicationCacheTableValues, 0 };
#else
    { 33, 31, JSDOMApplicationCacheTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSDOMApplicationCachePrototypeTableValues[14] =
{
    { "UNCACHED", DontDelete|ReadOnly, (intptr_t)jsDOMApplicationCacheUNCACHED, (intptr_t)0 },
    { "IDLE", DontDelete|ReadOnly, (intptr_t)jsDOMApplicationCacheIDLE, (intptr_t)0 },
    { "CHECKING", DontDelete|ReadOnly, (intptr_t)jsDOMApplicationCacheCHECKING, (intptr_t)0 },
    { "DOWNLOADING", DontDelete|ReadOnly, (intptr_t)jsDOMApplicationCacheDOWNLOADING, (intptr_t)0 },
    { "UPDATEREADY", DontDelete|ReadOnly, (intptr_t)jsDOMApplicationCacheUPDATEREADY, (intptr_t)0 },
    { "update", DontDelete|Function, (intptr_t)jsDOMApplicationCachePrototypeFunctionUpdate, (intptr_t)0 },
    { "swapCache", DontDelete|Function, (intptr_t)jsDOMApplicationCachePrototypeFunctionSwapCache, (intptr_t)0 },
    { "hasItem", DontDelete|Function, (intptr_t)jsDOMApplicationCachePrototypeFunctionHasItem, (intptr_t)1 },
    { "add", DontDelete|Function, (intptr_t)jsDOMApplicationCachePrototypeFunctionAdd, (intptr_t)1 },
    { "remove", DontDelete|Function, (intptr_t)jsDOMApplicationCachePrototypeFunctionRemove, (intptr_t)1 },
    { "addEventListener", DontDelete|Function, (intptr_t)jsDOMApplicationCachePrototypeFunctionAddEventListener, (intptr_t)3 },
    { "removeEventListener", DontDelete|Function, (intptr_t)jsDOMApplicationCachePrototypeFunctionRemoveEventListener, (intptr_t)3 },
    { "dispatchEvent", DontDelete|Function, (intptr_t)jsDOMApplicationCachePrototypeFunctionDispatchEvent, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSDOMApplicationCachePrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 255, JSDOMApplicationCachePrototypeTableValues, 0 };
#else
    { 35, 31, JSDOMApplicationCachePrototypeTableValues, 0 };
#endif

const ClassInfo JSDOMApplicationCachePrototype::s_info = { "DOMApplicationCachePrototype", 0, &JSDOMApplicationCachePrototypeTable, 0 };

JSObject* JSDOMApplicationCachePrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSDOMApplicationCache>(exec);
}

bool JSDOMApplicationCachePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSDOMApplicationCachePrototype, JSObject>(exec, &JSDOMApplicationCachePrototypeTable, this, propertyName, slot);
}

const ClassInfo JSDOMApplicationCache::s_info = { "DOMApplicationCache", 0, &JSDOMApplicationCacheTable, 0 };

JSDOMApplicationCache::JSDOMApplicationCache(PassRefPtr<Structure> structure, PassRefPtr<DOMApplicationCache> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSDOMApplicationCache::~JSDOMApplicationCache()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSDOMApplicationCache::createPrototype(ExecState* exec)
{
    return new (exec) JSDOMApplicationCachePrototype(JSDOMApplicationCachePrototype::createStructure(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSDOMApplicationCache::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMApplicationCache, Base>(exec, &JSDOMApplicationCacheTable, this, propertyName, slot);
}

JSValuePtr jsDOMApplicationCacheStatus(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMApplicationCache* imp = static_cast<DOMApplicationCache*>(static_cast<JSDOMApplicationCache*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->status());
}

JSValuePtr jsDOMApplicationCacheItems(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMApplicationCache* imp = static_cast<DOMApplicationCache*>(static_cast<JSDOMApplicationCache*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->items()));
}

JSValuePtr jsDOMApplicationCacheOnchecking(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMApplicationCache* imp = static_cast<DOMApplicationCache*>(static_cast<JSDOMApplicationCache*>(asObject(slot.slotBase()))->impl());
    if (JSUnprotectedEventListener* listener = static_cast<JSUnprotectedEventListener*>(imp->onchecking())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsDOMApplicationCacheOnerror(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMApplicationCache* imp = static_cast<DOMApplicationCache*>(static_cast<JSDOMApplicationCache*>(asObject(slot.slotBase()))->impl());
    if (JSUnprotectedEventListener* listener = static_cast<JSUnprotectedEventListener*>(imp->onerror())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsDOMApplicationCacheOnnoupdate(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMApplicationCache* imp = static_cast<DOMApplicationCache*>(static_cast<JSDOMApplicationCache*>(asObject(slot.slotBase()))->impl());
    if (JSUnprotectedEventListener* listener = static_cast<JSUnprotectedEventListener*>(imp->onnoupdate())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsDOMApplicationCacheOndownloading(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMApplicationCache* imp = static_cast<DOMApplicationCache*>(static_cast<JSDOMApplicationCache*>(asObject(slot.slotBase()))->impl());
    if (JSUnprotectedEventListener* listener = static_cast<JSUnprotectedEventListener*>(imp->ondownloading())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsDOMApplicationCacheOnprogress(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMApplicationCache* imp = static_cast<DOMApplicationCache*>(static_cast<JSDOMApplicationCache*>(asObject(slot.slotBase()))->impl());
    if (JSUnprotectedEventListener* listener = static_cast<JSUnprotectedEventListener*>(imp->onprogress())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsDOMApplicationCacheOnupdateready(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMApplicationCache* imp = static_cast<DOMApplicationCache*>(static_cast<JSDOMApplicationCache*>(asObject(slot.slotBase()))->impl());
    if (JSUnprotectedEventListener* listener = static_cast<JSUnprotectedEventListener*>(imp->onupdateready())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsDOMApplicationCacheOncached(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMApplicationCache* imp = static_cast<DOMApplicationCache*>(static_cast<JSDOMApplicationCache*>(asObject(slot.slotBase()))->impl());
    if (JSUnprotectedEventListener* listener = static_cast<JSUnprotectedEventListener*>(imp->oncached())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

void JSDOMApplicationCache::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSDOMApplicationCache, Base>(exec, propertyName, value, &JSDOMApplicationCacheTable, this, slot);
}

void setJSDOMApplicationCacheOnchecking(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    DOMApplicationCache* imp = static_cast<DOMApplicationCache*>(static_cast<JSDOMApplicationCache*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnchecking(globalObject->findOrCreateJSUnprotectedEventListener(exec, value, true));
}

void setJSDOMApplicationCacheOnerror(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    DOMApplicationCache* imp = static_cast<DOMApplicationCache*>(static_cast<JSDOMApplicationCache*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnerror(globalObject->findOrCreateJSUnprotectedEventListener(exec, value, true));
}

void setJSDOMApplicationCacheOnnoupdate(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    DOMApplicationCache* imp = static_cast<DOMApplicationCache*>(static_cast<JSDOMApplicationCache*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnnoupdate(globalObject->findOrCreateJSUnprotectedEventListener(exec, value, true));
}

void setJSDOMApplicationCacheOndownloading(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    DOMApplicationCache* imp = static_cast<DOMApplicationCache*>(static_cast<JSDOMApplicationCache*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOndownloading(globalObject->findOrCreateJSUnprotectedEventListener(exec, value, true));
}

void setJSDOMApplicationCacheOnprogress(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    DOMApplicationCache* imp = static_cast<DOMApplicationCache*>(static_cast<JSDOMApplicationCache*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnprogress(globalObject->findOrCreateJSUnprotectedEventListener(exec, value, true));
}

void setJSDOMApplicationCacheOnupdateready(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    DOMApplicationCache* imp = static_cast<DOMApplicationCache*>(static_cast<JSDOMApplicationCache*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnupdateready(globalObject->findOrCreateJSUnprotectedEventListener(exec, value, true));
}

void setJSDOMApplicationCacheOncached(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    DOMApplicationCache* imp = static_cast<DOMApplicationCache*>(static_cast<JSDOMApplicationCache*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOncached(globalObject->findOrCreateJSUnprotectedEventListener(exec, value, true));
}

JSValuePtr jsDOMApplicationCachePrototypeFunctionUpdate(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMApplicationCache::s_info))
        return throwError(exec, TypeError);
    JSDOMApplicationCache* castedThisObj = static_cast<JSDOMApplicationCache*>(asObject(thisValue));
    DOMApplicationCache* imp = static_cast<DOMApplicationCache*>(castedThisObj->impl());
    ExceptionCode ec = 0;

    imp->update(ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValuePtr jsDOMApplicationCachePrototypeFunctionSwapCache(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMApplicationCache::s_info))
        return throwError(exec, TypeError);
    JSDOMApplicationCache* castedThisObj = static_cast<JSDOMApplicationCache*>(asObject(thisValue));
    DOMApplicationCache* imp = static_cast<DOMApplicationCache*>(castedThisObj->impl());
    ExceptionCode ec = 0;

    imp->swapCache(ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValuePtr jsDOMApplicationCachePrototypeFunctionHasItem(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMApplicationCache::s_info))
        return throwError(exec, TypeError);
    JSDOMApplicationCache* castedThisObj = static_cast<JSDOMApplicationCache*>(asObject(thisValue));
    return castedThisObj->hasItem(exec, args);
}

JSValuePtr jsDOMApplicationCachePrototypeFunctionAdd(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMApplicationCache::s_info))
        return throwError(exec, TypeError);
    JSDOMApplicationCache* castedThisObj = static_cast<JSDOMApplicationCache*>(asObject(thisValue));
    return castedThisObj->add(exec, args);
}

JSValuePtr jsDOMApplicationCachePrototypeFunctionRemove(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMApplicationCache::s_info))
        return throwError(exec, TypeError);
    JSDOMApplicationCache* castedThisObj = static_cast<JSDOMApplicationCache*>(asObject(thisValue));
    return castedThisObj->remove(exec, args);
}

JSValuePtr jsDOMApplicationCachePrototypeFunctionAddEventListener(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMApplicationCache::s_info))
        return throwError(exec, TypeError);
    JSDOMApplicationCache* castedThisObj = static_cast<JSDOMApplicationCache*>(asObject(thisValue));
    return castedThisObj->addEventListener(exec, args);
}

JSValuePtr jsDOMApplicationCachePrototypeFunctionRemoveEventListener(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMApplicationCache::s_info))
        return throwError(exec, TypeError);
    JSDOMApplicationCache* castedThisObj = static_cast<JSDOMApplicationCache*>(asObject(thisValue));
    return castedThisObj->removeEventListener(exec, args);
}

JSValuePtr jsDOMApplicationCachePrototypeFunctionDispatchEvent(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMApplicationCache::s_info))
        return throwError(exec, TypeError);
    JSDOMApplicationCache* castedThisObj = static_cast<JSDOMApplicationCache*>(asObject(thisValue));
    DOMApplicationCache* imp = static_cast<DOMApplicationCache*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Event* evt = toEvent(args.at(exec, 0));


    JSC::JSValuePtr result = jsBoolean(imp->dispatchEvent(evt, ec));
    setDOMException(exec, ec);
    return result;
}

// Constant getters

JSValuePtr jsDOMApplicationCacheUNCACHED(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValuePtr jsDOMApplicationCacheIDLE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValuePtr jsDOMApplicationCacheCHECKING(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValuePtr jsDOMApplicationCacheDOWNLOADING(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(3));
}

JSValuePtr jsDOMApplicationCacheUPDATEREADY(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(4));
}

JSC::JSValuePtr toJS(JSC::ExecState* exec, DOMApplicationCache* object)
{
    return getDOMObjectWrapper<JSDOMApplicationCache>(exec, object);
}
DOMApplicationCache* toDOMApplicationCache(JSC::JSValuePtr value)
{
    return value->isObject(&JSDOMApplicationCache::s_info) ? static_cast<JSDOMApplicationCache*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(OFFLINE_WEB_APPLICATIONS)
