/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the demonstration applications of the Qt Toolkit.
**
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file.  Please review the following information
** to ensure GNU General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
** exception, Nokia gives you certain additional rights. These rights
** are described in the Nokia Qt GPL Exception version 1.3, included in
** the file GPL_EXCEPTION.txt in this package.
**
** Qt for Windows(R) Licensees
** As a special exception, Nokia, as the sole copyright holder for Qt
** Designer, grants users of the Qt/Eclipse Integration plug-in the
** right for the Qt/Eclipse Integration to link to functionality
** provided by Qt Designer and its related libraries.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
****************************************************************************/

#ifndef GLSHADERS_H
#define GLSHADERS_H

//#include <GL/glew.h>
#include "glextensions.h"

#include <QtGui>
#include <QtOpenGL>

#include "vector.h"

class GLShader
{
public:
    friend class GLProgram;
    virtual ~GLShader();
    bool failed() const {return m_failed;}
    QString log();
protected:
    GLShader(const char *data, int size, GLenum shaderType);
    GLShader(const QString& fileName, GLenum shaderType);

    GLhandleARB m_shader;
    bool m_compileError;
    bool m_failed;
};

class GLVertexShader : public GLShader
{
public:
    GLVertexShader(const char *data, int size);
    GLVertexShader(const QString& fileName);
};

class GLFragmentShader : public GLShader
{
public:
    GLFragmentShader(const char *data, int size);
    GLFragmentShader(const QString& fileName);
};

class GLProgram
{
public:
    GLProgram();
    ~GLProgram();
    void attach(const GLShader &shader);
    void detach(const GLShader &shader);
    void bind();
    void unbind();
    bool failed();
    QString log();
    bool hasParameter(const QString& name);
    // use program before setting values
    void setInt(const QString& name, int value);
    void setFloat(const QString& name, float value);
    void setColor(const QString& name, QRgb value);
    void setMatrix(const QString& name, const gfx::Matrix4x4f &mat);
    // TODO: add a bunch of set-functions for different types.
private:
    GLhandleARB m_program;
    bool m_linked;
    bool m_linkError;
    bool m_failed;
};

#endif
