/****************************************************************************
**
** Copyright (C) 2008 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the QtXMLPatterns module of the Qt Toolkit.
**
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file.  Please review the following information
** to ensure GNU General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
** exception, Nokia gives you certain additional rights. These rights
** are described in the Nokia Qt GPL Exception version 1.3, included in
** the file GPL_EXCEPTION.txt in this package.
**
** Qt for Windows(R) Licensees
** As a special exception, Nokia, as the sole copyright holder for Qt
** Designer, grants users of the Qt/Eclipse Integration plug-in the
** right for the Qt/Eclipse Integration to link to functionality
** provided by Qt Designer and its related libraries.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
****************************************************************************/

#include <QtDebug>

#include "qaxisstep_p.h"
#include "qcommonsequencetypes_p.h"
#include "qcommonvalues_p.h"
#include "qitemmappingiterator_p.h"
#include "qsequencemappingiterator_p.h"
#include "qpatternistlocale_p.h"

#include "qapplytemplate_p.h"

QT_BEGIN_NAMESPACE

using namespace QPatternist;

ApplyTemplate::ApplyTemplate(const TemplateMode::Ptr &mode,
                             const WithParam::Hash &withParams) : TemplateInvoker(withParams)
                                                                , m_mode(mode)
{
    Q_ASSERT(m_mode);
}

Item ApplyTemplate::mapToItem(const QXmlNodeModelIndex &node,
                              const DynamicContext::Ptr &) const
{
    return Item(node);
}

Item::Iterator::Ptr ApplyTemplate::mapToSequence(const Item &item,
                                                 const DynamicContext::Ptr &context) const
{
    Q_UNUSED(item);
    return evaluateSequence(context);
}

Template::Ptr ApplyTemplate::findTemplate(const DynamicContext::Ptr &context) const
{
    const int count = m_mode->templatePatterns.count();
    Template::Ptr result;
    PatternPriority priority;
    TemplatePattern::ID id;

    /* Possible optimization: detecting ambiguous rule matches could be forked off to a
     * low prioirity thread. */
    for(int i = 0; i < count; ++i)
    {
        const TemplatePattern::Ptr &candidate = m_mode->templatePatterns.at(i);
        if(candidate->matchPattern()->evaluateEBV(context))
        {
            if(result)
            {
                if(   candidate->id() != id
                   && candidate->priority() == priority
                   && candidate->templateTarget()->importPrecedence ==
                                                        result->importPrecedence)
                {
                    context->error(QtXmlPatterns::tr("Ambiguous rule match."),
                                   ReportContext::XTRE0540, this);
                }
                else
                    break;
            }
            else
            {
                result = candidate->templateTarget();
                priority = candidate->priority();
                id = candidate->id();
            }
        }
    }

    return result;
}

Item::Iterator::Ptr ApplyTemplate::evaluateSequence(const DynamicContext::Ptr &context) const
{
    const Template::Ptr &templateMatch = findTemplate(context);

    if(templateMatch)
        return templateMatch->body->evaluateSequence(templateMatch->bindParameters(this, context, false));
    else
    {
        /* None of our templates matched. Proceed with a built-in. */
        const Item current(context->contextItem());
        // TODO it can be an atomic value?
        const QXmlNodeModelIndex::NodeKind kind(current.asNode().kind());

        if(kind == QXmlNodeModelIndex::Element || kind == QXmlNodeModelIndex::Document)
        {
            pDebug() << "No template match, using builtin template for element() | document-node()";

            const Item::Iterator::Ptr focusIterator(makeItemMappingIterator<Item>(ConstPtr(this),
                                                                                  current.asNode().iterate(QXmlNodeModelIndex::AxisChild),
                                                                                  context));

            const DynamicContext::Ptr focus(context->createFocus());
            focus->setFocusIterator(focusIterator);
            return makeSequenceMappingIterator<Item>(ConstPtr(this), focusIterator, focus);
        }
        else
            return CommonValues::emptyIterator;
    }
}

SequenceType::List ApplyTemplate::expectedOperandTypes() const
{
    // TODO if the template count for this mode is zero, we can warn and rewrite to empty sequence.
    // Maybe also print what what the available modes are(levensthein)?

    SequenceType::List result;
    result.append(CommonSequenceTypes::ZeroOrMoreItems);

    return result;
}

SequenceType::Ptr ApplyTemplate::staticType() const
{
    return CommonSequenceTypes::ZeroOrMoreItems;
}

ExpressionVisitorResult::Ptr ApplyTemplate::accept(const ExpressionVisitor::Ptr &visitor) const
{
    return visitor->visit(this);
}

Expression::Properties ApplyTemplate::properties() const
{
    return RequiresFocus | DisableElimination;
}

QT_END_NAMESPACE
