/****************************************************************************
**
** Copyright (C) 2008 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file.  Please review the following information
** to ensure GNU General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
** exception, Nokia gives you certain additional rights. These rights
** are described in the Nokia Qt GPL Exception version 1.3, included in
** the file GPL_EXCEPTION.txt in this package.
**
** Qt for Windows(R) Licensees
** As a special exception, Nokia, as the sole copyright holder for Qt
** Designer, grants users of the Qt/Eclipse Integration plug-in the
** right for the Qt/Eclipse Integration to link to functionality
** provided by Qt Designer and its related libraries.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
****************************************************************************/

#ifndef QVECTORPATH_P_H
#define QVECTORPATH_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <QtGui/qpaintengine.h>

#include "qpaintengine_p.h"
#include "qstroker_p.h"
#include "qpainter_p.h"


QT_BEGIN_HEADER

QT_BEGIN_NAMESPACE

QT_MODULE(Gui)


#define QVECTORPATH_NO_CACHE

struct QRealRect {
    qreal x1, y1, x2, y2;
};

class Q_GUI_EXPORT QVectorPath
{
public:
    enum Hint {
        // Basic shapes...
        LinesHint               = 0x0001, // Just plain lines...
        RectangleHint           = 0x0002,
        ConvexPolygonHint       = 0x0003, // Convex polygon...
        NonISectPolygonHint     = 0x0004, // concave polygon, but not intersecting..
        NonCurvedShapeHint      = 0x0005, // Generic polygon, possibly self-intersecting...
        CurvedShapeHint         = 0x0006, // Generic vector path..
        EllipseHint             = 0x0007,
        ShapeHintMask           = 0x000f,

        // Other hints
        CacheHint               = 0x0100,
        ControlPointRect        = 0x0200, // Set if the control point rect has been calculated...

        // Shape rendering specifiers...
        OddEvenFill             = 0x1000,
        WindingFill             = 0x2000,
        ImplicitClose           = 0x4000,
    };

    // ### Falcon: introduca a struct XY for points so lars is not so confused...
    QVectorPath(const qreal *points,
                int count,
                const QPainterPath::ElementType *elements = 0,
                uint hints = CurvedShapeHint)
        : m_elements(elements),
          m_points(points),
          m_count(count),
          m_hints(hints)
#ifndef QVECTORPATH_NO_CACHE
        , m_cache(0)
#endif
    {
    }

    const QRealRect &controlPointRect() const;

    inline Hint shape() const { return (Hint) (m_hints & ShapeHintMask); }

    inline bool hasCacheHint() const { return m_hints & CacheHint; }
    inline bool hasImplicitClose() const { return m_hints & ImplicitClose; }
    inline bool hasWindingFill() const { return m_hints & WindingFill; }

    inline uint hints() const { return m_hints; }

    inline const QPainterPath::ElementType *elements() const { return m_elements; }
    inline const qreal *points() const { return m_points; }
    inline bool isEmpty() const { return m_points == 0; }

    inline int elementCount() const { return m_count; }

    static inline uint polygonFlags(QPaintEngine::PolygonDrawMode mode);

private:
    Q_DISABLE_COPY(QVectorPath)

#ifndef QVECTORPATH_NO_CACHE
    struct CacheEntry {
        void *engine;
        int id;
        void *extra;
        CacheEntry *next;
    };

    void addCacheData(CacheEntry *d) {
        d->next = m_cache;
        m_cache = d;
    }

    CacheEntry *m_cache;
#endif

    const QPainterPath::ElementType *m_elements;
    const qreal *m_points;
    const int m_count;

    mutable uint m_hints;
    mutable QRealRect m_cp_rect;
};

Q_GUI_EXPORT const QVectorPath &qtVectorPathForPath(const QPainterPath &path);

QT_END_NAMESPACE

QT_END_HEADER

#endif
