/****************************************************************************
**
** Copyright (C) 2008 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file.  Please review the following information
** to ensure GNU General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
** exception, Nokia gives you certain additional rights. These rights
** are described in the Nokia Qt GPL Exception version 1.3, included in
** the file GPL_EXCEPTION.txt in this package.
**
** Qt for Windows(R) Licensees
** As a special exception, Nokia, as the sole copyright holder for Qt
** Designer, grants users of the Qt/Eclipse Integration plug-in the
** right for the Qt/Eclipse Integration to link to functionality
** provided by Qt Designer and its related libraries.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
****************************************************************************/

#include <qglobal.h>

// ### Qt 5: eliminate this file

/*
    This is evil. MSVC doesn't let us remove private symbols, nor change their
    visibility; yet there are some symbols we really needed to make public, e.g.,
    ~QColorDialog(), and then there were some totally needless symbols in our
    header files, e.g., setSelectedAlpha(). So we define a new version of
    QColorDialog & Co. with only the private symbols that we removed from the
    public header files. The friends are there only to prevent potential compiler
    warnings.

    It would have been nicer to export the missing symbols as mangled "C" symbols
    instead but unfortunately MSVC uses out-of-reach characters like @ and . in
    their mangled C++ symbols.
*/

#if QT_VERSION < 0x050000 && defined(Q_CC_MSVC)

QT_BEGIN_NAMESPACE

#include <QtGui/QColor>
#include <QtGui/QFont>

class QColorDialogPrivate;
class QFontDialogPrivate;
class QInputDialogPrivate;
class QWidget;

class Q_GUI_EXPORT QColorDialog
{
private:
    explicit QColorDialog(QWidget *, bool);
    ~QColorDialog();

    void setColor(const QColor &);
    QColor color() const;
    bool selectColor(const QColor &);
    void setSelectedAlpha(int);
    int selectedAlpha() const;

    friend class QColorDialogPrivate;
};

QColorDialog::QColorDialog(QWidget *, bool) {}
QColorDialog::~QColorDialog() {}
void QColorDialog::setColor(const QColor &) {}
QColor QColorDialog::color() const { return QColor(); }
bool QColorDialog::selectColor(const QColor &) { return false; }
void QColorDialog::setSelectedAlpha(int) {}
int QColorDialog::selectedAlpha() const { return 0; }

class Q_GUI_EXPORT QFontDialog
{
private:
    explicit QFontDialog(QWidget *, bool, Qt::WindowFlags);
    ~QFontDialog();

    QFont font() const;
    void setFont(const QFont &);
    void updateFamilies();
    void updateStyles();
    void updateSizes();

    static QFont getFont(bool *, const QFont *, QWidget *);

    friend class QFontDialogPrivate;
};

QFontDialog::QFontDialog(QWidget *, bool, Qt::WindowFlags) {}
QFontDialog::~QFontDialog() {}
QFont QFontDialog::font() const { return QFont(); }
void QFontDialog::setFont(const QFont &) { }
void QFontDialog::updateFamilies() {}
void QFontDialog::updateStyles() {}
void QFontDialog::updateSizes() {}
QFont QFontDialog::getFont(bool *, const QFont *, QWidget *) { return QFont(); }

class Q_GUI_EXPORT QInputDialog
{
private:
    enum Type { LineEdit, SpinBox, DoubleSpinBox, ComboBox, EditableComboBox };

    QInputDialog(const QString &, QWidget *, Type, Qt::WindowFlags);
    QInputDialog(const QString &, const QString &, QWidget *, QWidget *, Qt::WindowFlags);
    ~QInputDialog();
};

QInputDialog::QInputDialog(const QString &, QWidget *, Type, Qt::WindowFlags) {}
QInputDialog::QInputDialog(const QString &, const QString &, QWidget *, QWidget *, Qt::WindowFlags) {}
QInputDialog::~QInputDialog() {}

QT_END_NAMESPACE

#endif
