/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG) && ENABLE(SVG_FILTERS)

#include "SVGElement.h"
#include "JSSVGFEGaussianBlurElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedNumber.h"
#include "JSSVGAnimatedString.h"
#include "SVGFEGaussianBlurElement.h"

#include <runtime/Error.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGFEGaussianBlurElement)

/* Hash table */

static const HashTableValue JSSVGFEGaussianBlurElementTableValues[11] =
{
    { "in1", DontDelete|ReadOnly, (intptr_t)jsSVGFEGaussianBlurElementIn1, (intptr_t)0 },
    { "stdDeviationX", DontDelete|ReadOnly, (intptr_t)jsSVGFEGaussianBlurElementStdDeviationX, (intptr_t)0 },
    { "stdDeviationY", DontDelete|ReadOnly, (intptr_t)jsSVGFEGaussianBlurElementStdDeviationY, (intptr_t)0 },
    { "x", DontDelete|ReadOnly, (intptr_t)jsSVGFEGaussianBlurElementX, (intptr_t)0 },
    { "y", DontDelete|ReadOnly, (intptr_t)jsSVGFEGaussianBlurElementY, (intptr_t)0 },
    { "width", DontDelete|ReadOnly, (intptr_t)jsSVGFEGaussianBlurElementWidth, (intptr_t)0 },
    { "height", DontDelete|ReadOnly, (intptr_t)jsSVGFEGaussianBlurElementHeight, (intptr_t)0 },
    { "result", DontDelete|ReadOnly, (intptr_t)jsSVGFEGaussianBlurElementResult, (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)jsSVGFEGaussianBlurElementClassName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsSVGFEGaussianBlurElementStyle, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGFEGaussianBlurElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 255, JSSVGFEGaussianBlurElementTableValues, 0 };
#else
    { 34, 31, JSSVGFEGaussianBlurElementTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGFEGaussianBlurElementPrototypeTableValues[3] =
{
    { "setStdDeviation", DontDelete|Function, (intptr_t)jsSVGFEGaussianBlurElementPrototypeFunctionSetStdDeviation, (intptr_t)2 },
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)jsSVGFEGaussianBlurElementPrototypeFunctionGetPresentationAttribute, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGFEGaussianBlurElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 1, JSSVGFEGaussianBlurElementPrototypeTableValues, 0 };
#else
    { 4, 3, JSSVGFEGaussianBlurElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGFEGaussianBlurElementPrototype::s_info = { "SVGFEGaussianBlurElementPrototype", 0, &JSSVGFEGaussianBlurElementPrototypeTable, 0 };

JSObject* JSSVGFEGaussianBlurElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSVGFEGaussianBlurElement>(exec);
}

bool JSSVGFEGaussianBlurElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGFEGaussianBlurElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGFEGaussianBlurElement::s_info = { "SVGFEGaussianBlurElement", &JSSVGElement::s_info, &JSSVGFEGaussianBlurElementTable, 0 };

JSSVGFEGaussianBlurElement::JSSVGFEGaussianBlurElement(PassRefPtr<Structure> structure, PassRefPtr<SVGFEGaussianBlurElement> impl)
    : JSSVGElement(structure, impl)
{
}

JSObject* JSSVGFEGaussianBlurElement::createPrototype(ExecState* exec)
{
    return new (exec) JSSVGFEGaussianBlurElementPrototype(JSSVGFEGaussianBlurElementPrototype::createStructure(JSSVGElementPrototype::self(exec)));
}

bool JSSVGFEGaussianBlurElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEGaussianBlurElement, Base>(exec, &JSSVGFEGaussianBlurElementTable, this, propertyName, slot);
}

JSValue* jsSVGFEGaussianBlurElementIn1(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEGaussianBlurElement* imp = static_cast<SVGFEGaussianBlurElement*>(static_cast<JSSVGFEGaussianBlurElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedString> obj = imp->in1Animated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEGaussianBlurElementStdDeviationX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEGaussianBlurElement* imp = static_cast<SVGFEGaussianBlurElement*>(static_cast<JSSVGFEGaussianBlurElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedNumber> obj = imp->stdDeviationXAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEGaussianBlurElementStdDeviationY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEGaussianBlurElement* imp = static_cast<SVGFEGaussianBlurElement*>(static_cast<JSSVGFEGaussianBlurElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedNumber> obj = imp->stdDeviationYAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEGaussianBlurElementX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEGaussianBlurElement* imp = static_cast<SVGFEGaussianBlurElement*>(static_cast<JSSVGFEGaussianBlurElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEGaussianBlurElementY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEGaussianBlurElement* imp = static_cast<SVGFEGaussianBlurElement*>(static_cast<JSSVGFEGaussianBlurElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEGaussianBlurElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEGaussianBlurElement* imp = static_cast<SVGFEGaussianBlurElement*>(static_cast<JSSVGFEGaussianBlurElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEGaussianBlurElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEGaussianBlurElement* imp = static_cast<SVGFEGaussianBlurElement*>(static_cast<JSSVGFEGaussianBlurElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEGaussianBlurElementResult(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEGaussianBlurElement* imp = static_cast<SVGFEGaussianBlurElement*>(static_cast<JSSVGFEGaussianBlurElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedString> obj = imp->resultAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEGaussianBlurElementClassName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEGaussianBlurElement* imp = static_cast<SVGFEGaussianBlurElement*>(static_cast<JSSVGFEGaussianBlurElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFEGaussianBlurElementStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEGaussianBlurElement* imp = static_cast<SVGFEGaussianBlurElement*>(static_cast<JSSVGFEGaussianBlurElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->style()));
}

JSValue* jsSVGFEGaussianBlurElementPrototypeFunctionSetStdDeviation(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGFEGaussianBlurElement::s_info))
        return throwError(exec, TypeError);
    JSSVGFEGaussianBlurElement* castedThisObj = static_cast<JSSVGFEGaussianBlurElement*>(asObject(thisValue));
    SVGFEGaussianBlurElement* imp = static_cast<SVGFEGaussianBlurElement*>(castedThisObj->impl());
    float stdDeviationX = args.at(exec, 0)->toFloat(exec);
    float stdDeviationY = args.at(exec, 1)->toFloat(exec);

    imp->setStdDeviation(stdDeviationX, stdDeviationY);
    return jsUndefined();
}

JSValue* jsSVGFEGaussianBlurElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGFEGaussianBlurElement::s_info))
        return throwError(exec, TypeError);
    JSSVGFEGaussianBlurElement* castedThisObj = static_cast<JSSVGFEGaussianBlurElement*>(asObject(thisValue));
    SVGFEGaussianBlurElement* imp = static_cast<SVGFEGaussianBlurElement*>(castedThisObj->impl());
    const UString& name = args.at(exec, 0)->toString(exec);


    JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}


}

#endif // ENABLE(SVG) && ENABLE(SVG_FILTERS)
