/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSPositionOptions.h"

#include <wtf/GetPtr.h>

#include "PositionOptions.h"

#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSPositionOptions)

/* Hash table */

static const HashTableValue JSPositionOptionsTableValues[4] =
{
    { "enableHighAccuracy", DontDelete, (intptr_t)jsPositionOptionsEnableHighAccuracy, (intptr_t)setJSPositionOptionsEnableHighAccuracy },
    { "timeout", DontDelete, (intptr_t)jsPositionOptionsTimeout, (intptr_t)setJSPositionOptionsTimeout },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsPositionOptionsConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSPositionOptionsTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSPositionOptionsTableValues, 0 };
#else
    { 8, 7, JSPositionOptionsTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSPositionOptionsConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSPositionOptionsConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSPositionOptionsConstructorTableValues, 0 };
#else
    { 1, 0, JSPositionOptionsConstructorTableValues, 0 };
#endif

class JSPositionOptionsConstructor : public DOMObject {
public:
    JSPositionOptionsConstructor(ExecState* exec)
        : DOMObject(JSPositionOptionsConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSPositionOptionsPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue* proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSPositionOptionsConstructor::s_info = { "PositionOptionsConstructor", 0, &JSPositionOptionsConstructorTable, 0 };

bool JSPositionOptionsConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSPositionOptionsConstructor, DOMObject>(exec, &JSPositionOptionsConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSPositionOptionsPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSPositionOptionsPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSPositionOptionsPrototypeTableValues, 0 };
#else
    { 1, 0, JSPositionOptionsPrototypeTableValues, 0 };
#endif

const ClassInfo JSPositionOptionsPrototype::s_info = { "PositionOptionsPrototype", 0, &JSPositionOptionsPrototypeTable, 0 };

JSObject* JSPositionOptionsPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSPositionOptions>(exec);
}

const ClassInfo JSPositionOptions::s_info = { "PositionOptions", 0, &JSPositionOptionsTable, 0 };

JSPositionOptions::JSPositionOptions(PassRefPtr<Structure> structure, PassRefPtr<PositionOptions> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSPositionOptions::~JSPositionOptions()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSPositionOptions::createPrototype(ExecState* exec)
{
    return new (exec) JSPositionOptionsPrototype(JSPositionOptionsPrototype::createStructure(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSPositionOptions::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSPositionOptions, Base>(exec, &JSPositionOptionsTable, this, propertyName, slot);
}

JSValue* jsPositionOptionsEnableHighAccuracy(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    PositionOptions* imp = static_cast<PositionOptions*>(static_cast<JSPositionOptions*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->enableHighAccuracy());
}

JSValue* jsPositionOptionsTimeout(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    PositionOptions* imp = static_cast<PositionOptions*>(static_cast<JSPositionOptions*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->timeout());
}

JSValue* jsPositionOptionsConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSPositionOptions*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSPositionOptions::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSPositionOptions, Base>(exec, propertyName, value, &JSPositionOptionsTable, this, slot);
}

void setJSPositionOptionsEnableHighAccuracy(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    PositionOptions* imp = static_cast<PositionOptions*>(static_cast<JSPositionOptions*>(thisObject)->impl());
    imp->setEnableHighAccuracy(value->toBoolean(exec));
}

void setJSPositionOptionsTimeout(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    PositionOptions* imp = static_cast<PositionOptions*>(static_cast<JSPositionOptions*>(thisObject)->impl());
    imp->setTimeout(value->toInt32(exec));
}

JSValue* JSPositionOptions::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSPositionOptionsConstructor>(exec);
}

JSC::JSValue* toJS(JSC::ExecState* exec, PositionOptions* object)
{
    return getDOMObjectWrapper<JSPositionOptions>(exec, object);
}
PositionOptions* toPositionOptions(JSC::JSValue* value)
{
    return value->isObject(&JSPositionOptions::s_info) ? static_cast<JSPositionOptions*>(asObject(value))->impl() : 0;
}

}
