/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLTableElement.h"

#include <wtf/GetPtr.h>

#include "HTMLCollection.h"
#include "HTMLElement.h"
#include "HTMLTableCaptionElement.h"
#include "HTMLTableElement.h"
#include "HTMLTableSectionElement.h"
#include "JSHTMLCollection.h"
#include "JSHTMLElement.h"
#include "JSHTMLTableCaptionElement.h"
#include "JSHTMLTableSectionElement.h"
#include "KURL.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLTableElement)

/* Hash table */

static const HashTableValue JSHTMLTableElementTableValues[16] =
{
    { "caption", DontDelete, (intptr_t)jsHTMLTableElementCaption, (intptr_t)setJSHTMLTableElementCaption },
    { "tHead", DontDelete, (intptr_t)jsHTMLTableElementTHead, (intptr_t)setJSHTMLTableElementTHead },
    { "tFoot", DontDelete, (intptr_t)jsHTMLTableElementTFoot, (intptr_t)setJSHTMLTableElementTFoot },
    { "rows", DontDelete|ReadOnly, (intptr_t)jsHTMLTableElementRows, (intptr_t)0 },
    { "tBodies", DontDelete|ReadOnly, (intptr_t)jsHTMLTableElementTBodies, (intptr_t)0 },
    { "align", DontDelete, (intptr_t)jsHTMLTableElementAlign, (intptr_t)setJSHTMLTableElementAlign },
    { "bgColor", DontDelete, (intptr_t)jsHTMLTableElementBgColor, (intptr_t)setJSHTMLTableElementBgColor },
    { "border", DontDelete, (intptr_t)jsHTMLTableElementBorder, (intptr_t)setJSHTMLTableElementBorder },
    { "cellPadding", DontDelete, (intptr_t)jsHTMLTableElementCellPadding, (intptr_t)setJSHTMLTableElementCellPadding },
    { "cellSpacing", DontDelete, (intptr_t)jsHTMLTableElementCellSpacing, (intptr_t)setJSHTMLTableElementCellSpacing },
    { "frame", DontDelete, (intptr_t)jsHTMLTableElementFrame, (intptr_t)setJSHTMLTableElementFrame },
    { "rules", DontDelete, (intptr_t)jsHTMLTableElementRules, (intptr_t)setJSHTMLTableElementRules },
    { "summary", DontDelete, (intptr_t)jsHTMLTableElementSummary, (intptr_t)setJSHTMLTableElementSummary },
    { "width", DontDelete, (intptr_t)jsHTMLTableElementWidth, (intptr_t)setJSHTMLTableElementWidth },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLTableElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLTableElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSHTMLTableElementTableValues, 0 };
#else
    { 35, 31, JSHTMLTableElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLTableElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLTableElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLTableElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLTableElementConstructorTableValues, 0 };
#endif

class JSHTMLTableElementConstructor : public DOMObject {
public:
    JSHTMLTableElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLTableElementConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLTableElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue* proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLTableElementConstructor::s_info = { "HTMLTableElementConstructor", 0, &JSHTMLTableElementConstructorTable, 0 };

bool JSHTMLTableElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTableElementConstructor, DOMObject>(exec, &JSHTMLTableElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLTableElementPrototypeTableValues[9] =
{
    { "createTHead", DontDelete|Function, (intptr_t)jsHTMLTableElementPrototypeFunctionCreateTHead, (intptr_t)0 },
    { "deleteTHead", DontDelete|Function, (intptr_t)jsHTMLTableElementPrototypeFunctionDeleteTHead, (intptr_t)0 },
    { "createTFoot", DontDelete|Function, (intptr_t)jsHTMLTableElementPrototypeFunctionCreateTFoot, (intptr_t)0 },
    { "deleteTFoot", DontDelete|Function, (intptr_t)jsHTMLTableElementPrototypeFunctionDeleteTFoot, (intptr_t)0 },
    { "createCaption", DontDelete|Function, (intptr_t)jsHTMLTableElementPrototypeFunctionCreateCaption, (intptr_t)0 },
    { "deleteCaption", DontDelete|Function, (intptr_t)jsHTMLTableElementPrototypeFunctionDeleteCaption, (intptr_t)0 },
    { "insertRow", DontDelete|Function, (intptr_t)jsHTMLTableElementPrototypeFunctionInsertRow, (intptr_t)1 },
    { "deleteRow", DontDelete|Function, (intptr_t)jsHTMLTableElementPrototypeFunctionDeleteRow, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLTableElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSHTMLTableElementPrototypeTableValues, 0 };
#else
    { 19, 15, JSHTMLTableElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLTableElementPrototype::s_info = { "HTMLTableElementPrototype", 0, &JSHTMLTableElementPrototypeTable, 0 };

JSObject* JSHTMLTableElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSHTMLTableElement>(exec);
}

bool JSHTMLTableElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLTableElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSHTMLTableElement::s_info = { "HTMLTableElement", &JSHTMLElement::s_info, &JSHTMLTableElementTable, 0 };

JSHTMLTableElement::JSHTMLTableElement(PassRefPtr<Structure> structure, PassRefPtr<HTMLTableElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLTableElement::createPrototype(ExecState* exec)
{
    return new (exec) JSHTMLTableElementPrototype(JSHTMLTableElementPrototype::createStructure(JSHTMLElementPrototype::self(exec)));
}

bool JSHTMLTableElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTableElement, Base>(exec, &JSHTMLTableElementTable, this, propertyName, slot);
}

JSValue* jsHTMLTableElementCaption(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(static_cast<JSHTMLTableElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->caption()));
}

JSValue* jsHTMLTableElementTHead(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(static_cast<JSHTMLTableElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->tHead()));
}

JSValue* jsHTMLTableElementTFoot(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(static_cast<JSHTMLTableElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->tFoot()));
}

JSValue* jsHTMLTableElementRows(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(static_cast<JSHTMLTableElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->rows()));
}

JSValue* jsHTMLTableElementTBodies(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(static_cast<JSHTMLTableElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->tBodies()));
}

JSValue* jsHTMLTableElementAlign(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(static_cast<JSHTMLTableElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->align());
}

JSValue* jsHTMLTableElementBgColor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(static_cast<JSHTMLTableElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->bgColor());
}

JSValue* jsHTMLTableElementBorder(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(static_cast<JSHTMLTableElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->border());
}

JSValue* jsHTMLTableElementCellPadding(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(static_cast<JSHTMLTableElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->cellPadding());
}

JSValue* jsHTMLTableElementCellSpacing(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(static_cast<JSHTMLTableElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->cellSpacing());
}

JSValue* jsHTMLTableElementFrame(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(static_cast<JSHTMLTableElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->frame());
}

JSValue* jsHTMLTableElementRules(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(static_cast<JSHTMLTableElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->rules());
}

JSValue* jsHTMLTableElementSummary(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(static_cast<JSHTMLTableElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->summary());
}

JSValue* jsHTMLTableElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(static_cast<JSHTMLTableElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->width());
}

JSValue* jsHTMLTableElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLTableElement*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSHTMLTableElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLTableElement, Base>(exec, propertyName, value, &JSHTMLTableElementTable, this, slot);
}

void setJSHTMLTableElementCaption(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(static_cast<JSHTMLTableElement*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setCaption(toHTMLTableCaptionElement(value), ec);
    setDOMException(exec, ec);
}

void setJSHTMLTableElementTHead(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(static_cast<JSHTMLTableElement*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setTHead(toHTMLTableSectionElement(value), ec);
    setDOMException(exec, ec);
}

void setJSHTMLTableElementTFoot(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(static_cast<JSHTMLTableElement*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setTFoot(toHTMLTableSectionElement(value), ec);
    setDOMException(exec, ec);
}

void setJSHTMLTableElementAlign(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(static_cast<JSHTMLTableElement*>(thisObject)->impl());
    imp->setAlign(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableElementBgColor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(static_cast<JSHTMLTableElement*>(thisObject)->impl());
    imp->setBgColor(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableElementBorder(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(static_cast<JSHTMLTableElement*>(thisObject)->impl());
    imp->setBorder(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableElementCellPadding(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(static_cast<JSHTMLTableElement*>(thisObject)->impl());
    imp->setCellPadding(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableElementCellSpacing(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(static_cast<JSHTMLTableElement*>(thisObject)->impl());
    imp->setCellSpacing(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableElementFrame(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(static_cast<JSHTMLTableElement*>(thisObject)->impl());
    imp->setFrame(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableElementRules(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(static_cast<JSHTMLTableElement*>(thisObject)->impl());
    imp->setRules(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableElementSummary(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(static_cast<JSHTMLTableElement*>(thisObject)->impl());
    imp->setSummary(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableElementWidth(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(static_cast<JSHTMLTableElement*>(thisObject)->impl());
    imp->setWidth(valueToStringWithNullCheck(exec, value));
}

JSValue* JSHTMLTableElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLTableElementConstructor>(exec);
}

JSValue* jsHTMLTableElementPrototypeFunctionCreateTHead(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLTableElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLTableElement* castedThisObj = static_cast<JSHTMLTableElement*>(asObject(thisValue));
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(castedThisObj->impl());


    JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->createTHead()));
    return result;
}

JSValue* jsHTMLTableElementPrototypeFunctionDeleteTHead(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLTableElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLTableElement* castedThisObj = static_cast<JSHTMLTableElement*>(asObject(thisValue));
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(castedThisObj->impl());

    imp->deleteTHead();
    return jsUndefined();
}

JSValue* jsHTMLTableElementPrototypeFunctionCreateTFoot(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLTableElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLTableElement* castedThisObj = static_cast<JSHTMLTableElement*>(asObject(thisValue));
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(castedThisObj->impl());


    JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->createTFoot()));
    return result;
}

JSValue* jsHTMLTableElementPrototypeFunctionDeleteTFoot(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLTableElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLTableElement* castedThisObj = static_cast<JSHTMLTableElement*>(asObject(thisValue));
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(castedThisObj->impl());

    imp->deleteTFoot();
    return jsUndefined();
}

JSValue* jsHTMLTableElementPrototypeFunctionCreateCaption(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLTableElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLTableElement* castedThisObj = static_cast<JSHTMLTableElement*>(asObject(thisValue));
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(castedThisObj->impl());


    JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->createCaption()));
    return result;
}

JSValue* jsHTMLTableElementPrototypeFunctionDeleteCaption(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLTableElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLTableElement* castedThisObj = static_cast<JSHTMLTableElement*>(asObject(thisValue));
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(castedThisObj->impl());

    imp->deleteCaption();
    return jsUndefined();
}

JSValue* jsHTMLTableElementPrototypeFunctionInsertRow(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLTableElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLTableElement* castedThisObj = static_cast<JSHTMLTableElement*>(asObject(thisValue));
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    int index = args.at(exec, 0)->toInt32(exec);


    JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->insertRow(index, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsHTMLTableElementPrototypeFunctionDeleteRow(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLTableElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLTableElement* castedThisObj = static_cast<JSHTMLTableElement*>(asObject(thisValue));
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    int index = args.at(exec, 0)->toInt32(exec);

    imp->deleteRow(index, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}


}
