/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSEntity.h"

#include <wtf/GetPtr.h>

#include "Entity.h"
#include "KURL.h"

#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSEntity)

/* Hash table */

static const HashTableValue JSEntityTableValues[5] =
{
    { "publicId", DontDelete|ReadOnly, (intptr_t)jsEntityPublicId, (intptr_t)0 },
    { "systemId", DontDelete|ReadOnly, (intptr_t)jsEntitySystemId, (intptr_t)0 },
    { "notationName", DontDelete|ReadOnly, (intptr_t)jsEntityNotationName, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsEntityConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSEntityTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSEntityTableValues, 0 };
#else
    { 10, 7, JSEntityTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSEntityConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSEntityConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSEntityConstructorTableValues, 0 };
#else
    { 1, 0, JSEntityConstructorTableValues, 0 };
#endif

class JSEntityConstructor : public DOMObject {
public:
    JSEntityConstructor(ExecState* exec)
        : DOMObject(JSEntityConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSEntityPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue* proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSEntityConstructor::s_info = { "EntityConstructor", 0, &JSEntityConstructorTable, 0 };

bool JSEntityConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSEntityConstructor, DOMObject>(exec, &JSEntityConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSEntityPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSEntityPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSEntityPrototypeTableValues, 0 };
#else
    { 1, 0, JSEntityPrototypeTableValues, 0 };
#endif

const ClassInfo JSEntityPrototype::s_info = { "EntityPrototype", 0, &JSEntityPrototypeTable, 0 };

JSObject* JSEntityPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSEntity>(exec);
}

const ClassInfo JSEntity::s_info = { "Entity", &JSNode::s_info, &JSEntityTable, 0 };

JSEntity::JSEntity(PassRefPtr<Structure> structure, PassRefPtr<Entity> impl)
    : JSNode(structure, impl)
{
}

JSObject* JSEntity::createPrototype(ExecState* exec)
{
    return new (exec) JSEntityPrototype(JSEntityPrototype::createStructure(JSNodePrototype::self(exec)));
}

bool JSEntity::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSEntity, Base>(exec, &JSEntityTable, this, propertyName, slot);
}

JSValue* jsEntityPublicId(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Entity* imp = static_cast<Entity*>(static_cast<JSEntity*>(asObject(slot.slotBase()))->impl());
    return jsStringOrNull(exec, imp->publicId());
}

JSValue* jsEntitySystemId(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Entity* imp = static_cast<Entity*>(static_cast<JSEntity*>(asObject(slot.slotBase()))->impl());
    return jsStringOrNull(exec, imp->systemId());
}

JSValue* jsEntityNotationName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Entity* imp = static_cast<Entity*>(static_cast<JSEntity*>(asObject(slot.slotBase()))->impl());
    return jsStringOrNull(exec, imp->notationName());
}

JSValue* jsEntityConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSEntity*>(asObject(slot.slotBase()))->getConstructor(exec);
}
JSValue* JSEntity::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSEntityConstructor>(exec);
}


}
