/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSDOMWindow_h
#define JSDOMWindow_h

#include "JSDOMWindowBase.h"
#include "DOMWindow.h"
namespace WebCore {

class DOMWindow;

class JSDOMWindowShell;

class JSDOMWindow : public JSDOMWindowBase {
    typedef JSDOMWindowBase Base;
public:
    JSDOMWindow(PassRefPtr<JSC::Structure>, PassRefPtr<DOMWindow>, JSDOMWindowShell*);
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertySlot&);
    bool customGetOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual void put(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::JSValue*, JSC::PutPropertySlot&);
    bool customPut(JSC::ExecState*, const JSC::Identifier&, JSC::JSValue*, JSC::PutPropertySlot&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;

    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue* prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, JSC::ImplementsHasInstance | JSC::NeedsThisConversion));
    }

    virtual void mark();

    virtual bool deleteProperty(JSC::ExecState*, const JSC::Identifier&);
    virtual void getPropertyNames(JSC::ExecState*, JSC::PropertyNameArray&);
    bool customGetPropertyNames(JSC::ExecState*, JSC::PropertyNameArray&);
    virtual bool getPropertyAttributes(JSC::ExecState*, const JSC::Identifier&, unsigned& attributes) const;
    virtual void defineGetter(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::JSObject* getterFunction);
    virtual void defineSetter(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::JSObject* setterFunction);
    virtual JSC::JSValue* lookupGetter(JSC::ExecState*, const JSC::Identifier& propertyName);
    virtual JSC::JSValue* lookupSetter(JSC::ExecState*, const JSC::Identifier& propertyName);

    // Custom attributes
    void setLocation(JSC::ExecState*, JSC::JSValue*);

    // Custom functions
    JSC::JSValue* postMessage(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* setTimeout(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* clearTimeout(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* setInterval(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* clearInterval(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* atob(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* btoa(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* addEventListener(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* removeEventListener(JSC::ExecState*, const JSC::ArgList&);
    DOMWindow* impl() const
    {
        return static_cast<DOMWindow*>(Base::impl());
    }
};

DOMWindow* toDOMWindow(JSC::JSValue*);

class JSDOMWindowPrototype : public JSC::JSObject {
public:
    void* operator new(size_t);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue* prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType));
    }
    JSDOMWindowPrototype(PassRefPtr<JSC::Structure> structure) : JSC::JSObject(structure) { }
};

// Functions

JSC::JSValue* jsDOMWindowPrototypeFunctionGetSelection(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionFocus(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionBlur(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionClose(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionPrint(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionStop(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionAlert(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionConfirm(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionPrompt(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionFind(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionScrollBy(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionScrollTo(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionScroll(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionMoveBy(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionMoveTo(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionResizeBy(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionResizeTo(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionGetComputedStyle(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionGetMatchedCSSRules(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionOpenDatabase(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionPostMessage(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionSetTimeout(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionClearTimeout(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionSetInterval(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionClearInterval(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionAtob(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionBtoa(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionAddEventListener(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsDOMWindowPrototypeFunctionRemoveEventListener(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
// Attributes

JSC::JSValue* jsDOMWindowScreen(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsDOMWindowHistory(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsDOMWindowLocationbar(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowLocationbar(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowMenubar(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowMenubar(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowPersonalbar(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowPersonalbar(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowScrollbars(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowScrollbars(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowStatusbar(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowStatusbar(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowToolbar(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowToolbar(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowNavigator(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowNavigator(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowClientInformation(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowClientInformation(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowLocation(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowLocation(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowFrameElement(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsDOMWindowOffscreenBuffering(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOffscreenBuffering(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOuterHeight(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOuterHeight(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOuterWidth(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOuterWidth(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowInnerHeight(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowInnerHeight(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowInnerWidth(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowInnerWidth(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowScreenX(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowScreenX(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowScreenY(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowScreenY(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowScreenLeft(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowScreenLeft(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowScreenTop(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowScreenTop(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowScrollX(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowScrollX(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowScrollY(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowScrollY(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowPageXOffset(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsDOMWindowPageYOffset(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsDOMWindowClosed(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsDOMWindowLength(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowLength(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowName(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowName(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowStatus(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowStatus(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowDefaultStatus(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDefaultStatus(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowDefaultstatus(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDefaultstatus(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowSelf(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSelf(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowWindow(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsDOMWindowFrames(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowFrames(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOpener(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOpener(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowParent(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowParent(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowTop(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowTop(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowDocument(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsDOMWindowDevicePixelRatio(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDevicePixelRatio(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowApplicationCache(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsDOMWindowSessionStorage(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsDOMWindowLocalStorage(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsDOMWindowConsole(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowConsole(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnabort(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnabort(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnblur(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnblur(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnchange(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnchange(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnclick(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnclick(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOndblclick(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOndblclick(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnerror(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnerror(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnfocus(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnfocus(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnkeydown(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnkeydown(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnkeypress(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnkeypress(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnkeyup(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnkeyup(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnload(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnload(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnmousedown(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnmousedown(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnmousemove(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnmousemove(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnmouseout(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnmouseout(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnmouseover(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnmouseover(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnmouseup(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnmouseup(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnmousewheel(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnmousewheel(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnreset(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnreset(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnresize(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnresize(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnscroll(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnscroll(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnsearch(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnsearch(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnselect(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnselect(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnsubmit(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnsubmit(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnunload(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnunload(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnbeforeunload(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnbeforeunload(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnwebkitanimationstart(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnwebkitanimationstart(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnwebkitanimationiteration(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnwebkitanimationiteration(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnwebkitanimationend(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnwebkitanimationend(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOnwebkittransitionend(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnwebkittransitionend(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowStyleSheetConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowStyleSheetConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowCSSStyleSheetConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSStyleSheetConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowCSSValueConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSValueConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowCSSPrimitiveValueConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSPrimitiveValueConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowCSSValueListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSValueListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowCSSRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowCSSCharsetRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSCharsetRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowCSSFontFaceRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSFontFaceRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowCSSImportRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSImportRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowCSSMediaRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSMediaRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowCSSPageRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSPageRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowCSSStyleRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSStyleRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowCSSVariablesRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSVariablesRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowCSSVariablesDeclarationConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSVariablesDeclarationConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowCSSStyleDeclarationConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSStyleDeclarationConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowMediaListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowMediaListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowCounterConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCounterConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowCSSRuleListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSRuleListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowRectConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowRectConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowStyleSheetListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowStyleSheetListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowDOMExceptionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDOMExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowDOMImplementationConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDOMImplementationConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowDocumentFragmentConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDocumentFragmentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowDocumentConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDocumentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowNodeConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowNodeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowNodeListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowNodeListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowNamedNodeMapConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowNamedNodeMapConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowCharacterDataConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCharacterDataConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowAttrConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowAttrConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowTextConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowTextConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowCommentConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCommentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowCDATASectionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCDATASectionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowDocumentTypeConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDocumentTypeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowNotationConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowNotationConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowEntityConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowEntityConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowEntityReferenceConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowEntityReferenceConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowProcessingInstructionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowProcessingInstructionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLDocumentConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLDocumentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLAnchorElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLAnchorElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLAppletElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLAppletElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLAreaElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLAreaElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLBRElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLBRElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLBaseElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLBaseElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLBaseFontElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLBaseFontElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLBlockquoteElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLBlockquoteElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLBodyElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLBodyElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLButtonElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLButtonElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLCanvasElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLCanvasElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLDListElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLDListElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLDirectoryElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLDirectoryElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLDivElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLDivElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLEmbedElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLEmbedElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLFieldSetElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLFieldSetElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLFontElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLFontElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLFormElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLFormElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLFrameElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLFrameElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLFrameSetElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLFrameSetElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLHRElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLHRElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLHeadElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLHeadElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLHeadingElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLHeadingElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLHtmlElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLHtmlElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLIFrameElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLIFrameElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLImageElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLImageElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLInputElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLInputElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLIsIndexElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLIsIndexElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLLIElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLLIElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLLabelElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLLabelElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLLegendElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLLegendElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLLinkElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLLinkElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLMapElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLMapElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLMarqueeElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLMarqueeElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLMenuElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLMenuElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLMetaElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLMetaElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLModElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLModElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLOListElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLOListElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLObjectElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLObjectElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLOptGroupElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLOptGroupElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLOptionElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLOptionElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLParagraphElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLParagraphElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLParamElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLParamElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLPreElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLPreElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLQuoteElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLQuoteElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLScriptElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLScriptElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLSelectElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLSelectElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLStyleElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLStyleElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLTableCaptionElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLTableCaptionElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLTableCellElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLTableCellElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLTableColElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLTableColElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLTableElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLTableElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLTableRowElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLTableRowElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLTableSectionElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLTableSectionElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLTextAreaElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLTextAreaElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLTitleElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLTitleElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLUListElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLUListElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLCollectionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLCollectionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowCanvasRenderingContext2DConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCanvasRenderingContext2DConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowTextMetricsConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowTextMetricsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowKeyboardEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowKeyboardEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowMouseEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowMouseEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowMutationEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowMutationEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowOverflowEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOverflowEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowProgressEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowProgressEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowTextEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowTextEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowUIEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowUIEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowWheelEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowWheelEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowMessageEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowMessageEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowEventExceptionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowEventExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowClipboardConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowClipboardConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowFileConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowFileConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowFileListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowFileListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowNodeFilterConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowNodeFilterConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowRangeConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowRangeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowRangeExceptionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowRangeExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowXMLDocumentConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowXMLDocumentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowDOMParserConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDOMParserConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowXMLSerializerConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowXMLSerializerConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowXMLHttpRequestUploadConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowXMLHttpRequestUploadConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowXMLHttpRequestExceptionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowXMLHttpRequestExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowPluginConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowPluginConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowPluginArrayConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowPluginArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowMimeTypeConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowMimeTypeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowMimeTypeArrayConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowMimeTypeArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowStorageConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowStorageConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowStorageEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowStorageEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLAudioElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLAudioElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLMediaElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLMediaElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowHTMLVideoElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLVideoElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowMediaErrorConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowMediaErrorConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowXPathEvaluatorConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowXPathEvaluatorConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowXPathResultConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowXPathResultConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowXPathExceptionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowXPathExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowSVGAngleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGAngleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowSVGColorConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGColorConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowSVGExceptionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowSVGGradientElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGGradientElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowSVGLengthConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGLengthConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowSVGMarkerElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGMarkerElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowSVGPaintConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPaintConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowSVGPathSegConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPathSegConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowSVGPreserveAspectRatioConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPreserveAspectRatioConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowSVGRenderingIntentConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGRenderingIntentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowSVGTextContentElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGTextContentElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowSVGTextPathElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGTextPathElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowSVGTransformConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGTransformConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsDOMWindowSVGUnitTypesConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGUnitTypesConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);

} // namespace WebCore

#endif
