/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSCSSRuleList.h"

#include <wtf/GetPtr.h>

#include <runtime/PropertyNameArray.h>
#include "CSSRule.h"
#include "CSSRuleList.h"
#include "JSCSSRule.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSCSSRuleList)

/* Hash table */

static const HashTableValue JSCSSRuleListTableValues[3] =
{
    { "length", DontDelete|ReadOnly, (intptr_t)jsCSSRuleListLength, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsCSSRuleListConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSRuleListTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSCSSRuleListTableValues, 0 };
#else
    { 5, 3, JSCSSRuleListTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSCSSRuleListConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSRuleListConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSCSSRuleListConstructorTableValues, 0 };
#else
    { 1, 0, JSCSSRuleListConstructorTableValues, 0 };
#endif

class JSCSSRuleListConstructor : public DOMObject {
public:
    JSCSSRuleListConstructor(ExecState* exec)
        : DOMObject(JSCSSRuleListConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSCSSRuleListPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue* proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSCSSRuleListConstructor::s_info = { "CSSRuleListConstructor", 0, &JSCSSRuleListConstructorTable, 0 };

bool JSCSSRuleListConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSRuleListConstructor, DOMObject>(exec, &JSCSSRuleListConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSCSSRuleListPrototypeTableValues[2] =
{
    { "item", DontDelete|Function, (intptr_t)jsCSSRuleListPrototypeFunctionItem, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSRuleListPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSCSSRuleListPrototypeTableValues, 0 };
#else
    { 2, 1, JSCSSRuleListPrototypeTableValues, 0 };
#endif

const ClassInfo JSCSSRuleListPrototype::s_info = { "CSSRuleListPrototype", 0, &JSCSSRuleListPrototypeTable, 0 };

JSObject* JSCSSRuleListPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSCSSRuleList>(exec);
}

bool JSCSSRuleListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSCSSRuleListPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSCSSRuleList::s_info = { "CSSRuleList", 0, &JSCSSRuleListTable, 0 };

JSCSSRuleList::JSCSSRuleList(PassRefPtr<Structure> structure, PassRefPtr<CSSRuleList> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSCSSRuleList::~JSCSSRuleList()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSCSSRuleList::createPrototype(ExecState* exec)
{
    return new (exec) JSCSSRuleListPrototype(JSCSSRuleListPrototype::createStructure(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSCSSRuleList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = JSCSSRuleListTable.entry(exec, propertyName);
    if (entry) {
        slot.setCustom(this, entry->propertyGetter());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<CSSRuleList*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSCSSRuleList, Base>(exec, &JSCSSRuleListTable, this, propertyName, slot);
}

bool JSCSSRuleList::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<CSSRuleList*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValue* jsCSSRuleListLength(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CSSRuleList* imp = static_cast<CSSRuleList*>(static_cast<JSCSSRuleList*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->length());
}

JSValue* jsCSSRuleListConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSCSSRuleList*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSCSSRuleList::getPropertyNames(ExecState* exec, PropertyNameArray& propertyNames)
{
    for (unsigned i = 0; i < static_cast<CSSRuleList*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getPropertyNames(exec, propertyNames);
}

JSValue* JSCSSRuleList::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSCSSRuleListConstructor>(exec);
}

JSValue* jsCSSRuleListPrototypeFunctionItem(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSRuleList::s_info))
        return throwError(exec, TypeError);
    JSCSSRuleList* castedThisObj = static_cast<JSCSSRuleList*>(asObject(thisValue));
    CSSRuleList* imp = static_cast<CSSRuleList*>(castedThisObj->impl());
    unsigned index = args.at(exec, 0)->toInt32(exec);


    JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->item(index)));
    return result;
}


JSValue* JSCSSRuleList::indexGetter(ExecState* exec, const Identifier& propertyName, const PropertySlot& slot)
{
    JSCSSRuleList* thisObj = static_cast<JSCSSRuleList*>(asObject(slot.slotBase()));
    return toJS(exec, static_cast<CSSRuleList*>(thisObj->impl())->item(slot.index()));
}
JSC::JSValue* toJS(JSC::ExecState* exec, CSSRuleList* object)
{
    return getDOMObjectWrapper<JSCSSRuleList>(exec, object);
}
CSSRuleList* toCSSRuleList(JSC::JSValue* value)
{
    return value->isObject(&JSCSSRuleList::s_info) ? static_cast<JSCSSRuleList*>(asObject(value))->impl() : 0;
}

}
