/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSCSSPageRule.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSPageRule.h"
#include "CSSStyleDeclaration.h"
#include "JSCSSStyleDeclaration.h"
#include "KURL.h"

#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSCSSPageRule)

/* Hash table */

static const HashTableValue JSCSSPageRuleTableValues[4] =
{
    { "selectorText", DontDelete, (intptr_t)jsCSSPageRuleSelectorText, (intptr_t)setJSCSSPageRuleSelectorText },
    { "style", DontDelete|ReadOnly, (intptr_t)jsCSSPageRuleStyle, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsCSSPageRuleConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSPageRuleTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSCSSPageRuleTableValues, 0 };
#else
    { 8, 7, JSCSSPageRuleTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSCSSPageRuleConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSPageRuleConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSCSSPageRuleConstructorTableValues, 0 };
#else
    { 1, 0, JSCSSPageRuleConstructorTableValues, 0 };
#endif

class JSCSSPageRuleConstructor : public DOMObject {
public:
    JSCSSPageRuleConstructor(ExecState* exec)
        : DOMObject(JSCSSPageRuleConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSCSSPageRulePrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue* proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSCSSPageRuleConstructor::s_info = { "CSSPageRuleConstructor", 0, &JSCSSPageRuleConstructorTable, 0 };

bool JSCSSPageRuleConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSPageRuleConstructor, DOMObject>(exec, &JSCSSPageRuleConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSCSSPageRulePrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSPageRulePrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSCSSPageRulePrototypeTableValues, 0 };
#else
    { 1, 0, JSCSSPageRulePrototypeTableValues, 0 };
#endif

const ClassInfo JSCSSPageRulePrototype::s_info = { "CSSPageRulePrototype", 0, &JSCSSPageRulePrototypeTable, 0 };

JSObject* JSCSSPageRulePrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSCSSPageRule>(exec);
}

const ClassInfo JSCSSPageRule::s_info = { "CSSPageRule", &JSCSSRule::s_info, &JSCSSPageRuleTable, 0 };

JSCSSPageRule::JSCSSPageRule(PassRefPtr<Structure> structure, PassRefPtr<CSSPageRule> impl)
    : JSCSSRule(structure, impl)
{
}

JSObject* JSCSSPageRule::createPrototype(ExecState* exec)
{
    return new (exec) JSCSSPageRulePrototype(JSCSSPageRulePrototype::createStructure(JSCSSRulePrototype::self(exec)));
}

bool JSCSSPageRule::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSPageRule, Base>(exec, &JSCSSPageRuleTable, this, propertyName, slot);
}

JSValue* jsCSSPageRuleSelectorText(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CSSPageRule* imp = static_cast<CSSPageRule*>(static_cast<JSCSSPageRule*>(asObject(slot.slotBase()))->impl());
    return jsStringOrNull(exec, imp->selectorText());
}

JSValue* jsCSSPageRuleStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CSSPageRule* imp = static_cast<CSSPageRule*>(static_cast<JSCSSPageRule*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->style()));
}

JSValue* jsCSSPageRuleConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSCSSPageRule*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSCSSPageRule::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSCSSPageRule, Base>(exec, propertyName, value, &JSCSSPageRuleTable, this, slot);
}

void setJSCSSPageRuleSelectorText(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    CSSPageRule* imp = static_cast<CSSPageRule*>(static_cast<JSCSSPageRule*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setSelectorText(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}

JSValue* JSCSSPageRule::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSCSSPageRuleConstructor>(exec);
}


}
