/****************************************************************************
**
** Copyright (C) 1992-2008 Trolltech ASA. All rights reserved.
**
** This file is part of the tools applications of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License versions 2.0 or 3.0 as published by the Free Software
** Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file.  Alternatively you may (at
** your option) use any later version of the GNU General Public
** License if such license has been publicly approved by Trolltech ASA
** (or its successors, if any) and the KDE Free Qt Foundation.
**
** Please review the following information to ensure GNU General
** Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/. If
** you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** In addition, as a special exception, Trolltech, as the sole
** copyright holder for Qt Designer, grants users of the Qt/Eclipse
** Integration plug-in the right for the Qt/Eclipse Integration to
** link to functionality provided by Qt Designer and its related
** libraries.
**
** This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
** INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
** granted herein.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

/*
  uncompressor.cpp
*/

#include "uncompressor.h"

QT_BEGIN_NAMESPACE

QList<Uncompressor *> Uncompressor::uncompressors;


/*!
  \class Uncompressor
  
  \brief The Uncompressor class is a base class for classes that
  know how to uncompress a certain kind of compressed file.

  The uncompressor contains a list of the filename extensions
  of the file types that the uncompressor knows how to uncompress.

  It maintains a static list of all the instances of Uncompressor
  that have been created. It also has a static function for searching
  that list to find the uncompressor to use for uncompressing a file
  with a certain extension.
 */

/*!
  The constructor takes a list of filename extensions, which it
  copies and saves internally. This uncompressor is prepended
  to the stack list.
 */
Uncompressor::Uncompressor( const QStringList& extensions )
    : fileExts( extensions )
{
    uncompressors.prepend( this );
}

/*!
  The destructor deletes all the filename extensions.
 */
Uncompressor::~Uncompressor()
{
    uncompressors.removeAll( this );
}

/*!
  This function searches the static list of uncompressors to find the
  first one that can handle \a fileName. If it finds an acceptable
  uncompressor, it returns a pointer to it. Otherwise it returns null.
*/
Uncompressor*
Uncompressor::uncompressorForFileName( const QString& fileName )
{
    int dot = -1;
    while ( (dot = fileName.indexOf(".", dot + 1)) != -1 ) {
        QString ext = fileName.mid( dot + 1 );
        QList<Uncompressor *>::ConstIterator u = uncompressors.begin();
        while ( u != uncompressors.end() ) {
            if ( (*u)->fileExtensions().contains(ext) )
                return *u;
            ++u;
        }
    }
    return 0;
}

QT_END_NAMESPACE
