/****************************************************************************
**
** Copyright (C) 2006-2008 Trolltech ASA. All rights reserved.
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License versions 2.0 or 3.0 as published by the Free Software
** Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file.  Alternatively you may (at
** your option) use any later version of the GNU General Public
** License if such license has been publicly approved by Trolltech ASA
** (or its successors, if any) and the KDE Free Qt Foundation.
**
** Please review the following information to ensure GNU General
** Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/. If
** you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** In addition, as a special exception, Trolltech, as the sole
** copyright holder for Qt Designer, grants users of the Qt/Eclipse
** Integration plug-in the right for the Qt/Eclipse Integration to
** link to functionality provided by Qt Designer and its related
** libraries.
**
** This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
** INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
** granted herein.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifdef Q_OS_WINCE

#include "qguifunctions_wince.h"

#include "sip.h"

# if defined(WIN32_PLATFORM_PSPC) && (WIN32_PLATFORM_PSPC < 310)
#  define SHFS_SHOWTASKBAR            0x0001
#  define SHFS_SHOWSIPBUTTON          0x0004
   extern "C" BOOL __stdcall SHFullScreen(HWND hwndRequester, DWORD dwState);
# else
#  include <aygshell.h>
# endif

QT_BEGIN_NAMESPACE

const QString qt_reg_winclass(QWidget *w);                // defined in qapplication_win.cpp
extern "C" LRESULT CALLBACK QtWndProc(HWND, UINT, WPARAM, LPARAM);

//#define TABLET_DEBUG
#define PACKETDATA  (PK_X | PK_Y | PK_BUTTONS | PK_NORMAL_PRESSURE | PK_TANGENT_PRESSURE \
                     | PK_ORIENTATION | PK_CURSOR | PK_Z)
#define PACKETMODE  0

typedef HCTX        (API *PtrWTOpen)(HWND, LPLOGCONTEXT, BOOL);
typedef BOOL        (API *PtrWTClose)(HCTX);
typedef UINT        (API *PtrWTInfo)(UINT, UINT, LPVOID);
typedef BOOL        (API *PtrWTEnable)(HCTX, BOOL);
typedef BOOL        (API *PtrWTOverlap)(HCTX, BOOL);
typedef int        (API *PtrWTPacketsGet)(HCTX, int, LPVOID);
typedef BOOL        (API *PtrWTGet)(HCTX, LPLOGCONTEXT);
typedef int     (API *PtrWTQueueSizeGet)(HCTX);
typedef BOOL    (API *PtrWTQueueSizeSet)(HCTX, int);

static void qt_tablet_init_wce();
static void qt_tablet_cleanup_wce();

static void qt_tablet_init_wce() {
    static bool firstTime = true;
    if (!firstTime)
        return;
    firstTime = false;
    qt_tablet_widget = new QWidget(0);
    qt_tablet_widget->createWinId();
    qt_tablet_widget->setObjectName(QLatin1String("Qt internal tablet widget"));
    LOGCONTEXT lcMine;
    qAddPostRoutine(qt_tablet_cleanup_wce);
    struct tagAXIS tpOri[3];
    if (ptrWTInfo && ptrWTOpen && ptrWTQueueSizeGet && ptrWTQueueSizeSet) {
        // make sure we have WinTab
        if (!ptrWTInfo(0, 0, NULL)) {
#ifdef TABLET_DEBUG
            qWarning("QWidget: Wintab services not available");
#endif
            return;
        }

        // some tablets don't support tilt, check if it is possible,
        qt_tablet_tilt_support = ptrWTInfo(WTI_DEVICES, DVC_ORIENTATION, &tpOri);
        if (qt_tablet_tilt_support) {
            // check for azimuth and altitude
            qt_tablet_tilt_support = tpOri[0].axResolution && tpOri[1].axResolution;
        }
        // build our context from the default context
        ptrWTInfo(WTI_DEFSYSCTX, 0, &lcMine);
        // Go for the raw coordinates, the tablet event will return good stuff
        lcMine.lcOptions |= CXO_MESSAGES | CXO_CSRMESSAGES;
        lcMine.lcPktData = PACKETDATA;
        lcMine.lcPktMode = PACKETMODE;
        lcMine.lcMoveMask = PACKETDATA;
        lcMine.lcOutOrgX = 0;
        lcMine.lcOutExtX = lcMine.lcInExtX;
        lcMine.lcOutOrgY = 0;
        lcMine.lcOutExtY = -lcMine.lcInExtY;
        qt_tablet_context = ptrWTOpen(qt_tablet_widget->winId(), &lcMine, true);
#ifdef TABLET_DEBUG
        qDebug("Tablet is %p", qt_tablet_context);
#endif
        if (!qt_tablet_context) {
#ifdef TABLET_DEBUG
            qWarning("QWidget: Failed to open the tablet");
#endif
            return;
        }
        // Set the size of the Packet Queue to the correct size...
        int currSize = ptrWTQueueSizeGet(qt_tablet_context);
        if (!ptrWTQueueSizeSet(qt_tablet_context, QT_TABLET_NPACKETQSIZE)) {
            // Ideally one might want to use a smaller
            // multiple, but for now, since we managed to destroy
            // the existing Q with the previous call, set it back
            // to the other size, which should work.  If not,
            // there will be trouble.
            if (!ptrWTQueueSizeSet(qt_tablet_context, currSize)) {
                Q_ASSERT_X(0, "Qt::Internal", "There is no packet queue for"
                         " the tablet. The tablet will not work");
            }
        }
    }
}

static void qt_tablet_cleanup_wce() {
    if (ptrWTClose)
        ptrWTClose(qt_tablet_context);
    delete qt_tablet_widget;
    qt_tablet_widget = 0;
}


// The internal qWinRequestConfig, defined in qapplication_win.cpp, stores move,
// resize and setGeometry requests for a widget that is already
// processing a config event. The purpose is to avoid recursion.
//
void qWinRequestConfig(WId, int, int, int, int, int);

void QWidgetPrivate::create_sys(WId window, bool initializeWindow, bool destroyOldWindow) {
    Q_Q(QWidget);
    static int sw = -1, sh = -1;

    Qt::WindowType type = q->windowType();
    Qt::WindowFlags flags = data.window_flags;

    bool topLevel = (flags & Qt::Window);
    bool popup = (type == Qt::Popup);
    bool dialog = (type == Qt::Dialog
                   || type == Qt::Sheet
                   || (flags & Qt::MSWindowsFixedSizeDialogHint));
    bool desktop = (type == Qt::Desktop);
    bool tool = (type == Qt::Tool || type == Qt::Drawer);

    HINSTANCE appinst  = qWinAppInst();
    HWND parentw, destroyw = 0;
    WId id;

    QString windowClassName = qt_reg_winclass(q);

    if (!window)                                // always initialize
        initializeWindow = true;

    if (popup)
        flags |= Qt::WindowStaysOnTopHint; // a popup stays on top

    if (flags & (Qt::WindowSystemMenuHint | Qt::WindowMinMaxButtonsHint | Qt::WindowContextHelpButtonHint)) {
        flags |= Qt::WindowSystemMenuHint;
        flags |= Qt::WindowTitleHint;
        flags &= ~Qt::FramelessWindowHint;
    }

    if (sw < 0) {                                // get the (primary) screen size
        sw = GetSystemMetrics(SM_CXSCREEN);
        sh = GetSystemMetrics(SM_CYSCREEN);
    }

    if (desktop) {                                // desktop widget
        popup = false;                                // force this flags off
        data.crect.setRect(0, 0, GetSystemMetrics(SM_CXSCREEN), GetSystemMetrics(SM_CYSCREEN));
    }

    parentw = q->parentWidget() ? q->parentWidget()->effectiveWinId() : 0;

#ifdef UNICODE
    QString title;
    const TCHAR *ttitle = 0;
#endif
    QByteArray title95;
    int style = WS_CHILD;
    int exsty = WS_EX_NOPARENTNOTIFY;

    if (topLevel) {
        if (!(flags & Qt::FramelessWindowHint) && !tool)
          style = (WS_OVERLAPPED) | WS_SYSMENU;
        else
          style = WS_POPUP;
        if ((type == Qt::ToolTip) || (type == Qt::SplashScreen)) {
            style = WS_POPUP;
            exsty |= WS_EX_NOANIMATION;
        } else {
            if (flags & Qt::WindowTitleHint)
                style |= WS_CAPTION;
            if (flags & Qt::WindowSystemMenuHint)
                style |= WS_SYSMENU;
            if (flags & Qt::WindowContextHelpButtonHint)
                exsty |= WS_EX_CONTEXTHELP;
            if (tool)
                exsty |= WS_EX_TOOLWINDOW;
        }
    }
    if (dialog) {
        style = WS_BORDER | WS_POPUP | WS_CAPTION;
        if (flags & Qt::WindowOkButtonHint)
            exsty |= WS_EX_CAPTIONOKBTN;
        if (flags & Qt::WindowCancelButtonHint || flags & Qt::WA_DeleteOnClose)
            style |= WS_SYSMENU;
        if (flags & Qt::WindowContextHelpButtonHint)
            exsty |= WS_EX_CONTEXTHELP;
    }
    if (popup) {
        style = WS_POPUP;
        exsty |= WS_EX_NOANIMATION;
    }

    if (flags & Qt::WindowTitleHint) {
        QT_WA({
            title = q->isWindow() ? qAppName() : q->objectName();
            ttitle = (TCHAR*)title.utf16();
        } , {
            title95 = q->isWindow() ? qAppName().toLocal8Bit() : q->objectName().toLatin1();
        });
    }

    // The Qt::WA_WState_Created flag is checked by translateConfigEvent() in
    // qapplication_win.cpp. We switch it off temporarily to avoid move
    // and resize events during creationt
    q->setAttribute(Qt::WA_WState_Created, false);

    if (window) {                                // override the old window
        if (destroyOldWindow)
            destroyw = data.winid;
        id = window;
        setWinId(window);
        LONG res = SetWindowLongA(window, GWL_STYLE, style);
        if (!res)
            qErrnoWarning("QWidget::create: Failed to set window style");

        res = SetWindowLongA( window, GWL_WNDPROC, (LONG)QtWndProc );

        if (!res)
            qErrnoWarning("QWidget::create: Failed to set window procedure");
    } else if (desktop) {                        // desktop widget
        id = GetDesktopWindow();
        if (!id) { //Create a dummy desktop
            RECT r;
            SystemParametersInfo(SPI_GETWORKAREA, 0, &r, 0);
            const TCHAR *cname = reinterpret_cast<const TCHAR *> (windowClassName.utf16());
            id = CreateWindow(cname, ttitle, style,
                                r.left, r.top, r.right - r.left, r.bottom - r.top, 
                                0, 0, appinst, 0);
        }
        setWinId(id);
    } else if (topLevel) {                       // create top-level widget
        const bool wasMoved = q->testAttribute(Qt::WA_Moved);
        
        int x, y;
        if (qt_wince_is_mobile()) {
            x = wasMoved ? data.crect.left() : CW_USEDEFAULT;
            y = wasMoved ? data.crect.top() : CW_USEDEFAULT;
        } else {
            x = wasMoved ? data.crect.left() : 100;
            y = wasMoved ? data.crect.top() : 100;
        }
        
        int w = CW_USEDEFAULT;
        int h = CW_USEDEFAULT;

        // Adjust for framestrut when needed
        RECT rect = {0,0,0,0};
        if (AdjustWindowRectEx(&rect, style, FALSE, exsty)) {
            QTLWExtra *td = maybeTopData();
            if (wasMoved && (td && !td->posFromMove)) {
                x = data.crect.x() + rect.left;
                y = data.crect.y() + rect.top;
            }

            if (q->testAttribute(Qt::WA_Resized)) {
                w = data.crect.width() + (rect.right - rect.left);
                h = data.crect.height() + (rect.bottom - rect.top);
            }
        }

        const TCHAR *cname = reinterpret_cast<const TCHAR *> (windowClassName.utf16());
        id = CreateWindowEx(exsty, cname, ttitle, style,
                            x, y, w, h,
                            0, 0, appinst, 0);

        if (!id)
            qErrnoWarning("QWidget::create: Failed to create window");
        setWinId(id);
        if ((flags & Qt::WindowStaysOnTopHint) || (type == Qt::ToolTip))
            SetWindowPos(id, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOSIZE);
    } else if (q->testAttribute(Qt::WA_NativeWindow) || paintOnScreen()) { // create child widget
        QT_WA({
            const TCHAR *cname = (TCHAR*)windowClassName.utf16();
            id = CreateWindowEx(exsty, cname, ttitle, style,
                                data.crect.left(), data.crect.top(), data.crect.width(), data.crect.height(),
                            parentw, NULL, appinst, NULL);
        } , {
            id = CreateWindowExA(exsty, windowClassName.toLatin1(), title95, style,
                                 data.crect.left(), data.crect.top(), data.crect.width(), data.crect.height(),
                            parentw, NULL, appinst, NULL);
        });
        if (!id)
            qErrnoWarning("QWidget::create: Failed to create window");
        SetWindowPos(id, HWND_TOP, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
        setWinId(id);
    }

    if (desktop) {
        q->setAttribute(Qt::WA_WState_Visible);
    } else if (topLevel) {
        RECT  cr;
        GetClientRect(id, &cr);
        // one cannot trust cr.left and cr.top, use a correction POINT instead
        POINT pt;
        pt.x = 0;
        pt.y = 0;
        ClientToScreen(id, &pt);
        data.crect = QRect(QPoint(pt.x, pt.y),
                            QPoint(pt.x + cr.right - 1, pt.y + cr.bottom - 1));

        if (data.fstrut_dirty) {
            // be nice to activeqt
            updateFrameStrut();
        }
    }

    q->setAttribute(Qt::WA_WState_Created);                // accept move/resize events
    hd = 0;                                        // no display context

    if (window) {                                // got window from outside
        if (IsWindowVisible(window))
            q->setAttribute(Qt::WA_WState_Visible);
        else
            q->setAttribute(Qt::WA_WState_Visible, false);
    }

    if (extra && !extra->mask.isEmpty())
        setMask_sys(extra->mask);

#if defined(QT_NON_COMMERCIAL)
    QT_NC_WIDGET_CREATE
#endif

    if (q->hasFocus() && q->testAttribute(Qt::WA_InputMethodEnabled))
        q->inputContext()->setFocusWidget(q);

    if (destroyw) {
        DestroyWindow(destroyw);
    }
    
    if (q != qt_tablet_widget && QWidgetPrivate::mapper)
        qt_tablet_init_wce();

    if (q->testAttribute(Qt::WA_DropSiteRegistered))
        registerDropSite(true);

    if (maybeTopData() && maybeTopData()->opacity != 255)
        q->setWindowOpacity(maybeTopData()->opacity/255.);

    if (!topLevel && q->testAttribute(Qt::WA_NativeWindow) && q->testAttribute(Qt::WA_Mapped)) {
        Q_ASSERT(q->internalWinId());
        ShowWindow(q->internalWinId(), SW_SHOW);
    }
}

/*
  \internal
  Platform-specific part of QWidget::show().
*/
void QWidgetPrivate::show_sys() {
    Q_Q(QWidget);
#if defined(QT_NON_COMMERCIAL)
    QT_NC_SHOW_WINDOW
#endif
    if (q->testAttribute(Qt::WA_OutsideWSRange))
        return;

    q->setAttribute(Qt::WA_Mapped);

    Q_ASSERT(q->testAttribute(Qt::WA_WState_Created));
    
    if (q->testAttribute(Qt::WA_DontShowOnScreen)) {
        invalidateBuffer(q->rect());
        return;
    }


    int sm = SW_SHOW;
    if (q->isWindow()) {
        if (q->isHidden())
            sm = SW_HIDE;
    }
    if ((q->windowType() == Qt::Popup) || (q->windowType() == Qt::ToolTip) || (q->windowType() == Qt::Tool))
        sm = SW_SHOWNOACTIVATE;

    if (!(data.window_state & Qt::WindowMinimized))
        ShowWindow(q->internalWinId(), sm);

    if (q->isMaximized() && q->isWindow())
        qt_wince_maximize(q);

    if (q->isWindow() && sm == SW_SHOW)
        SetForegroundWindow(q->internalWinId());

    invalidateBuffer(q->rect());
}

void QWidget::setWindowState(Qt::WindowStates newstate)
{
    Q_D(QWidget);
    Qt::WindowStates oldstate = windowState();
    if (oldstate == newstate)
        return;

    int max = SW_SHOWNORMAL;
    int min = SW_SHOWNOACTIVATE;
    
    int normal = SW_SHOWNOACTIVATE;

    if ((oldstate & Qt::WindowMinimized) && !(newstate & Qt::WindowMinimized))
       newstate |= Qt::WindowActive;
    if (newstate & Qt::WindowActive) {
        max = SW_SHOWNORMAL;
        min = SW_SHOWNORMAL;
        normal = SW_SHOWNORMAL;
    }
    if (isWindow()) {
        createWinId();
        Q_ASSERT(testAttribute(Qt::WA_WState_Created));
        data->window_state_internal = newstate;
        // Ensure the initial size is valid, since we store it as normalGeometry below.
        if ((!testAttribute(Qt::WA_Resized) && !isVisible()))
            adjustSize();
        if (!d->topData()->normalGeometry.isValid()) {
            if (newstate & Qt::WindowMaximized && !(oldstate & Qt::WindowFullScreen))
                d->topData()->normalGeometry = geometry();
            if (newstate & Qt::WindowMinimized && !(oldstate & Qt::WindowFullScreen))
                d->topData()->normalGeometry = geometry();
        }
        if ((oldstate & Qt::WindowMaximized) != (newstate & Qt::WindowMaximized)) {
             if (!(newstate & Qt::WindowMaximized)) {
                int style = GetWindowLongW(internalWinId(), GWL_STYLE) | WS_BORDER | WS_POPUP | WS_CAPTION;
                SetWindowLong(internalWinId(), GWL_STYLE, style);
                SetWindowLong(internalWinId(), GWL_EXSTYLE, GetWindowLong (internalWinId(), GWL_EXSTYLE) & ~ WS_EX_NODRAG);
            }
             if (isVisible() && newstate & Qt::WindowMaximized)
                    qt_wince_maximize(this);
            if (isVisible() && !(newstate & Qt::WindowMinimized)) {
                ShowWindow(internalWinId(), (newstate & Qt::WindowMaximized) ? max : normal);
                if (!(newstate & Qt::WindowFullScreen)) {
                    QRect r = d->topData()->normalGeometry;
                    if (!(newstate & Qt::WindowMaximized) && r.width() >= 0) {
                        if (pos() != r.topLeft() || size() !=r.size()) {
                            d->topData()->normalGeometry = QRect(0,0,-1,-1);
                            setGeometry(r);
                        }
                    }
                } else {
                    d->updateFrameStrut();
                }
            }
        }
        if ((oldstate & Qt::WindowFullScreen) != (newstate & Qt::WindowFullScreen)) {
            if (newstate & Qt::WindowFullScreen) {
                if (d->topData()->normalGeometry.width() < 0 && !(oldstate & Qt::WindowMaximized))
                    d->topData()->normalGeometry = geometry();
                d->topData()->savedFlags = GetWindowLongA(internalWinId(), GWL_STYLE);
                UINT style = WS_CLIPCHILDREN | WS_CLIPSIBLINGS | WS_POPUP;
                if (isVisible())
                    style |= WS_VISIBLE;
                SetWindowLongA(internalWinId(), GWL_STYLE, style);
                QRect r = qApp->desktop()->screenGeometry(this);
                UINT swpf = SWP_FRAMECHANGED;
                if (newstate & Qt::WindowActive)
                    swpf |= SWP_NOACTIVATE;
                qt_wince_full_screen(internalWinId(), true, swpf);
                d->updateFrameStrut();
            } else {
                UINT style = d->topData()->savedFlags;
                if (isVisible())
                    style |= WS_VISIBLE;
                SetWindowLongA(internalWinId(), GWL_STYLE, style);
                UINT swpf = SWP_FRAMECHANGED | SWP_NOZORDER | SWP_NOSIZE | SWP_NOMOVE;
                if (newstate & Qt::WindowActive)
                    swpf |= SWP_NOACTIVATE;
                qt_wince_full_screen(internalWinId(), false, swpf);
                d->updateFrameStrut();

                // preserve maximized state
                if (isVisible()) {
                    ShowWindow(internalWinId(), (newstate & Qt::WindowMaximized) ? max : normal);
                    if (newstate & Qt::WindowMaximized)
                        qt_wince_maximize(this);
                }
                if (!(newstate & Qt::WindowMaximized)) {
                    QRect r = d->topData()->normalGeometry;
                    d->topData()->normalGeometry = QRect(0,0,-1,-1);
                    if (r.isValid())
                        setGeometry(r);
                }
            }
        }
        if ((oldstate & Qt::WindowMinimized) != (newstate & Qt::WindowMinimized)) {
            if (isVisible()) {
                ShowWindow(internalWinId(), (newstate & Qt::WindowMinimized) ? min :
                    (newstate & Qt::WindowMaximized) ? max : normal);
            if (newstate & Qt::WindowMaximized)
                qt_wince_maximize(this);
            if (newstate & Qt::WindowMinimized)
                qt_wince_minimize(internalWinId());
            }
        }
        if ((newstate & Qt::WindowMaximized) && !(newstate & Qt::WindowFullScreen)) {
            QRect r = d->topData()->normalGeometry;
#ifdef Q_OS_WINCE_WM
            if (!inherits("QDialog") && !inherits("QMdiArea") && !isVisible()) {
                d->data.crect.setRect(0, 0, -1, -1);
            }
#else
            qt_wince_maximize(this);
#endif
        }
    }
    data->window_state = newstate;
    data->window_state_internal = newstate;
    QWindowStateChangeEvent e(oldstate);
    QApplication::sendEvent(this, &e);
}


void QWidgetPrivate::createSysExtra() {
#ifndef QT_NO_DRAGANDDROP
    extra->dropTarget = 0;
#endif
}

void QWidgetPrivate::deleteSysExtra()
{
    Q_Q(QWidget);
    if (!qt_wince_is_mobile() && q->isFullScreen()) {
        HWND handle = FindWindow(L"HHTaskBar", L"");        
        if (handle) {
            ShowWindow(handle, 1);        
            EnableWindow(handle, true);
        }
    }
}

void QWidgetPrivate::setWindowOpacity_sys(qreal level) {
    Q_UNUSED(level);
    return;
}

// The procedure does nothing, but is required for mousegrabbing to work
LRESULT CALLBACK qJournalRecordProc(int nCode, WPARAM wParam, LPARAM lParam) {
    Q_UNUSED(nCode);
    Q_UNUSED(wParam);
    Q_UNUSED(lParam);
    return 0;
}

void QWidget::grabMouse() {
    if (!qt_nograb()) {
        if (mouseGrb)
            mouseGrb->releaseMouse();
        Q_ASSERT(testAttribute(Qt::WA_WState_Created));
        SetCapture(internalWinId());
        mouseGrb = this;
    }
}

#ifndef QT_NO_CURSOR
void QWidget::grabMouse(const QCursor &cursor) {
    if (!qt_nograb()) {
        if (mouseGrb)
            mouseGrb->releaseMouse();
        Q_ASSERT(testAttribute(Qt::WA_WState_Created));
        SetCapture(internalWinId());
        mouseGrbCur = new QCursor(cursor);
        SetCursor(mouseGrbCur->handle());
        mouseGrb = this;
    }
}
#endif

void QWidget::releaseMouse() {
    if (!qt_nograb() && mouseGrb == this) {
        ReleaseCapture();
        if (journalRec) {
            journalRec = 0;
        }
        if (mouseGrbCur) {
            delete mouseGrbCur;
            mouseGrbCur = 0;
        }
        mouseGrb = 0;
    }
}

void QWidget::show()
{
    Qt::WindowFlags flags = windowFlags() & 0xff;
    int threshold = qApp->autoMaximizeThreshold();
    if ((threshold < 0) || (windowState() & Qt::WindowFullScreen) || (windowState() & Qt::WindowMaximized)) {
        setVisible(true);
        return;
    }
    int height = sizeHint().height();
    int screenHeight = (qreal(threshold) / 100.0f * qApp->desktop()->screenGeometry(this).height());    
    bool maximize  = height > screenHeight;    
    if (!maximize) {
        // If we do not maximize yet we check the widget and its child widgets whether they are 
        //vertically expanding. If one of the widgets is expanding we maximize.
        QList<QWidget *> list = findChildren<QWidget *>();
        bool expandingChild = sizePolicy().verticalPolicy () == QSizePolicy::Expanding;
        for (int i = 0; (i < list.size()) && !expandingChild; ++i) {
            expandingChild = list.at(i)->sizePolicy().verticalPolicy () == QSizePolicy::Expanding;
        }
        maximize = expandingChild;
    }
    if ((minimumSizeHint().height() > qApp->desktop()->screenGeometry(this).height()) || (minimumSizeHint().width() > qApp->desktop()->screenGeometry(this).width()))
        maximize = false;
    
    if ((flags == Qt::Window || flags == Qt::Dialog) && maximize) {
        setWindowState((windowState() & ~(Qt::WindowMinimized | Qt::WindowFullScreen))
            | Qt::WindowMaximized);
        setVisible(true);
    }      
    else {
        setVisible(true);
    }
}

QT_END_NAMESPACE

#endif Q_OS_WINCE
