/****************************************************************************
**
** Copyright (C) 1992-2008 Trolltech ASA. All rights reserved.
**
** This file is part of the QtScript module of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License versions 2.0 or 3.0 as published by the Free Software
** Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file.  Alternatively you may (at
** your option) use any later version of the GNU General Public
** License if such license has been publicly approved by Trolltech ASA
** (or its successors, if any) and the KDE Free Qt Foundation.
**
** Please review the following information to ensure GNU General
** Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/. If
** you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** In addition, as a special exception, Trolltech, as the sole
** copyright holder for Qt Designer, grants users of the Qt/Eclipse
** Integration plug-in the right for the Qt/Eclipse Integration to
** link to functionality provided by Qt Designer and its related
** libraries.
**
** This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
** INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
** granted herein.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "qscriptgrammar_p.h"

#ifndef QT_NO_SCRIPT

QT_BEGIN_NAMESPACE

const char *const QScriptGrammar::spell [] = {
  "end of file", "&", "&&", "&=", "break", "case", "catch", ":", ";", "continue", 
  "default", "delete", "/", "/=", "do", ".", "else", "=", "==", "===", 
  "finally", "for", "function", ">=", ">", ">>", ">>=", ">>>", ">>>=", "identifier", 
  "if", "in", "instanceof", "{", "[", "<=", "(", "<", "<<", "<<=", 
  "-", "-=", "--", "new", "!", "!=", "!==", "numeric literal", "|", "|=", 
  "||", "+", "+=", "++", "?", "}", "]", "%", "%=", "return", 
  ")", ";", 0, "*", "*=", "string literal", "switch", "this", "throw", "~", 
  "try", "typeof", "var", "void", "while", "with", "^", "^=", "null", "true", 
  "false", "const", "reserved word", 
#ifndef QLALR_NO_QSCRIPTGRAMMAR_DEBUG_INFO
"Program", "PrimaryExpression", "ElisionOpt", "ElementList", "PropertyNameAndValueListOpt", "Expression", "AssignmentExpression", 
  "Elision", "PropertyNameAndValueList", "PropertyName", "MemberExpression", "FunctionExpression", "ExtraIdentifiersMarker", "Arguments", "NewExpression", "CallExpression", "ArgumentList", 
  "LeftHandSideExpression", "PostfixExpression", "UnaryExpression", "MultiplicativeExpression", "AdditiveExpression", "ShiftExpression", "RelationalExpression", "RelationalExpressionNotIn", "EqualityExpression", "EqualityExpressionNotIn", 
  "BitwiseANDExpression", "BitwiseANDExpressionNotIn", "BitwiseXORExpression", "BitwiseXORExpressionNotIn", "BitwiseORExpression", "BitwiseORExpressionNotIn", "LogicalANDExpression", "LogicalANDExpressionNotIn", "LogicalORExpression", "LogicalORExpressionNotIn", 
  "ConditionalExpression", "ConditionalExpressionNotIn", "AssignmentExpressionNotIn", "AssignmentOperator", "ExpressionOpt", "ExpressionNotIn", "ExpressionNotInOpt", "Statement", "Block", "VariableStatement", 
  "EmptyStatement", "ExpressionStatement", "IfStatement", "IterationStatement", "ContinueStatement", "BreakStatement", "ReturnStatement", "WithStatement", "LabelledStatement", "SwitchStatement", 
  "ThrowStatement", "TryStatement", "StatementListOpt", "StatementList", "VariableDeclarationKind", "VariableDeclarationList", "VariableDeclaration", "VariableDeclarationListNotIn", "VariableDeclarationNotIn", "InitialiserOpt", 
  "InitialiserNotInOpt", "Initialiser", "InitialiserNotIn", "CaseBlock", "CaseClausesOpt", "DefaultClause", "CaseClauses", "CaseClause", "Catch", "Finally", 
  "FunctionDeclaration", "FormalParameterListOpt", "FunctionBodyOpt", "IdentifierOpt", "FormalParameterList", "FunctionBody", "SourceElements", "SourceElement", "$accept"
#endif // QLALR_NO_QSCRIPTGRAMMAR_DEBUG_INFO
};

const int QScriptGrammar::lhs [] = {
  84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 
  84, 84, 84, 84, 86, 86, 90, 90, 85, 85, 
  91, 91, 92, 92, 92, 93, 93, 93, 93, 95, 
  93, 97, 97, 98, 98, 98, 98, 96, 96, 99, 
  99, 100, 100, 101, 101, 101, 102, 102, 102, 102, 
  102, 102, 102, 102, 102, 102, 103, 103, 103, 103, 
  104, 104, 104, 105, 105, 105, 105, 106, 106, 106, 
  106, 106, 106, 106, 107, 107, 107, 107, 107, 107, 
  108, 108, 108, 108, 108, 109, 109, 109, 109, 109, 
  110, 110, 111, 111, 112, 112, 113, 113, 114, 114, 
  115, 115, 116, 116, 117, 117, 118, 118, 119, 119, 
  120, 120, 121, 121, 89, 89, 122, 122, 123, 123, 
  123, 123, 123, 123, 123, 123, 123, 123, 123, 123, 
  88, 88, 124, 124, 125, 125, 126, 126, 127, 127, 
  127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 
  127, 127, 128, 143, 143, 142, 142, 129, 129, 144, 
  144, 145, 145, 147, 147, 146, 148, 151, 149, 149, 
  152, 150, 150, 130, 131, 131, 132, 132, 133, 133, 
  133, 133, 133, 133, 133, 134, 134, 134, 134, 135, 
  135, 135, 135, 136, 136, 137, 139, 153, 153, 156, 
  156, 154, 154, 157, 155, 138, 140, 140, 141, 141, 
  141, 158, 159, 160, 94, 164, 164, 161, 161, 162, 
  162, 165, 83, 166, 166, 167, 167, 163, 163, 87, 
  87, 168};

const int QScriptGrammar:: rhs[] = {
  1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 
  3, 5, 3, 3, 2, 4, 1, 2, 0, 1, 
  3, 5, 1, 1, 1, 1, 1, 4, 4, 0, 
  3, 1, 2, 2, 2, 4, 3, 2, 3, 1, 
  3, 1, 1, 1, 2, 2, 1, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 1, 3, 3, 3, 
  1, 3, 3, 1, 3, 3, 3, 1, 3, 3, 
  3, 3, 3, 3, 1, 3, 3, 3, 3, 3, 
  1, 3, 3, 3, 3, 1, 3, 3, 3, 3, 
  1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 
  1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 
  1, 5, 1, 5, 1, 3, 1, 3, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 3, 0, 1, 1, 3, 0, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 3, 1, 2, 0, 1, 3, 3, 1, 
  1, 1, 3, 1, 3, 2, 2, 2, 0, 1, 
  2, 0, 1, 1, 2, 2, 7, 5, 7, 7, 
  5, 9, 10, 7, 8, 2, 2, 3, 3, 2, 
  2, 3, 3, 3, 3, 5, 5, 3, 5, 1, 
  2, 0, 1, 4, 3, 3, 3, 3, 3, 3, 
  4, 5, 2, 8, 8, 1, 3, 0, 1, 0, 
  1, 1, 1, 1, 2, 1, 1, 0, 1, 0, 
  1, 2};


#ifndef QLALR_NO_QSCRIPTGRAMMAR_DEBUG_INFO
const int QScriptGrammar::rule_info [] = {
    84, 67
  , 84, 29
  , 84, 78
  , 84, 79
  , 84, 80
  , 84, 47
  , 84, 65
  , 84, 12
  , 84, 13
  , 84, 34, 85, 56
  , 84, 34, 86, 56
  , 84, 34, 86, 8, 85, 56
  , 84, 33, 87, 55
  , 84, 36, 88, 60
  , 86, 85, 89
  , 86, 86, 8, 85, 89
  , 90, 8
  , 90, 90, 8
  , 85
  , 85, 90
  , 91, 92, 7, 89
  , 91, 91, 8, 92, 7, 89
  , 92, 29
  , 92, 65
  , 92, 47
  , 93, 84
  , 93, 94
  , 93, 93, 34, 88, 56
  , 93, 93, 15, 95, 29
  , 95
  , 93, 43, 93, 96
  , 97, 93
  , 97, 43, 97
  , 98, 93, 96
  , 98, 98, 96
  , 98, 98, 34, 88, 56
  , 98, 98, 15, 29
  , 96, 36, 60
  , 96, 36, 99, 60
  , 99, 89
  , 99, 99, 8, 89
  , 100, 97
  , 100, 98
  , 101, 100
  , 101, 100, 53
  , 101, 100, 42
  , 102, 101
  , 102, 11, 102
  , 102, 73, 102
  , 102, 71, 102
  , 102, 53, 102
  , 102, 42, 102
  , 102, 51, 102
  , 102, 40, 102
  , 102, 69, 102
  , 102, 44, 102
  , 103, 102
  , 103, 103, 63, 102
  , 103, 103, 12, 102
  , 103, 103, 57, 102
  , 104, 103
  , 104, 104, 51, 103
  , 104, 104, 40, 103
  , 105, 104
  , 105, 105, 38, 104
  , 105, 105, 25, 104
  , 105, 105, 27, 104
  , 106, 105
  , 106, 106, 37, 105
  , 106, 106, 24, 105
  , 106, 106, 35, 105
  , 106, 106, 23, 105
  , 106, 106, 32, 105
  , 106, 106, 31, 105
  , 107, 105
  , 107, 107, 37, 105
  , 107, 107, 24, 105
  , 107, 107, 35, 105
  , 107, 107, 23, 105
  , 107, 107, 32, 105
  , 108, 106
  , 108, 108, 18, 106
  , 108, 108, 45, 106
  , 108, 108, 19, 106
  , 108, 108, 46, 106
  , 109, 107
  , 109, 109, 18, 107
  , 109, 109, 45, 107
  , 109, 109, 19, 107
  , 109, 109, 46, 107
  , 110, 108
  , 110, 110, 1, 108
  , 111, 109
  , 111, 111, 1, 109
  , 112, 110
  , 112, 112, 76, 110
  , 113, 111
  , 113, 113, 76, 111
  , 114, 112
  , 114, 114, 48, 112
  , 115, 113
  , 115, 115, 48, 113
  , 116, 114
  , 116, 116, 2, 114
  , 117, 115
  , 117, 117, 2, 115
  , 118, 116
  , 118, 118, 50, 116
  , 119, 117
  , 119, 119, 50, 117
  , 120, 118
  , 120, 118, 54, 89, 7, 89
  , 121, 119
  , 121, 119, 54, 122, 7, 122
  , 89, 120
  , 89, 100, 123, 89
  , 122, 121
  , 122, 100, 123, 122
  , 123, 17
  , 123, 64
  , 123, 13
  , 123, 58
  , 123, 52
  , 123, 41
  , 123, 39
  , 123, 26
  , 123, 28
  , 123, 3
  , 123, 77
  , 123, 49
  , 88, 89
  , 88, 88, 8, 89
  , 124
  , 124, 88
  , 125, 122
  , 125, 125, 8, 122
  , 126
  , 126, 125
  , 127, 128
  , 127, 129
  , 127, 130
  , 127, 131
  , 127, 132
  , 127, 133
  , 127, 134
  , 127, 135
  , 127, 136
  , 127, 137
  , 127, 138
  , 127, 139
  , 127, 140
  , 127, 141
  , 128, 33, 142, 55
  , 143, 127
  , 143, 143, 127
  , 142
  , 142, 143
  , 129, 144, 145, 62
  , 129, 144, 145, 61
  , 144, 81
  , 144, 72
  , 145, 146
  , 145, 145, 8, 146
  , 147, 148
  , 147, 147, 8, 148
  , 146, 29, 149
  , 148, 29, 150
  , 151, 17, 89
  , 149
  , 149, 151
  , 152, 17, 122
  , 150
  , 150, 152
  , 130, 61
  , 131, 88, 62
  , 131, 88, 61
  , 132, 30, 36, 88, 60, 127, 16, 127
  , 132, 30, 36, 88, 60, 127
  , 133, 14, 127, 74, 36, 88, 60, 62
  , 133, 14, 127, 74, 36, 88, 60, 61
  , 133, 74, 36, 88, 60, 127
  , 133, 21, 36, 126, 61, 124, 61, 124, 60, 127
  , 133, 21, 36, 72, 147, 61, 124, 61, 124, 60, 127
  , 133, 21, 36, 100, 31, 88, 60, 127
  , 133, 21, 36, 72, 148, 31, 88, 60, 127
  , 134, 9, 62
  , 134, 9, 61
  , 134, 9, 29, 62
  , 134, 9, 29, 61
  , 135, 4, 62
  , 135, 4, 61
  , 135, 4, 29, 62
  , 135, 4, 29, 61
  , 136, 59, 124, 62
  , 136, 59, 124, 61
  , 137, 75, 36, 88, 60, 127
  , 139, 66, 36, 88, 60, 153
  , 153, 33, 154, 55
  , 153, 33, 154, 155, 154, 55
  , 156, 157
  , 156, 156, 157
  , 154
  , 154, 156
  , 157, 5, 88, 7, 142
  , 155, 10, 7, 142
  , 138, 29, 7, 127
  , 140, 68, 88, 62
  , 140, 68, 88, 61
  , 141, 70, 128, 158
  , 141, 70, 128, 159
  , 141, 70, 128, 158, 159
  , 158, 6, 36, 29, 60, 128
  , 159, 20, 128
  , 160, 22, 29, 36, 161, 60, 33, 162, 55
  , 94, 22, 163, 36, 161, 60, 33, 162, 55
  , 164, 29
  , 164, 164, 8, 29
  , 161
  , 161, 164
  , 162
  , 162, 165
  , 165, 166
  , 83, 166
  , 166, 167
  , 166, 166, 167
  , 167, 127
  , 167, 160
  , 163
  , 163, 29
  , 87
  , 87, 91
  , 168, 83, 0};

const int QScriptGrammar::rule_index [] = {
  0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 
  22, 26, 32, 36, 40, 43, 48, 50, 53, 54, 
  56, 60, 66, 68, 70, 72, 74, 76, 81, 86, 
  87, 91, 93, 96, 99, 102, 107, 111, 114, 118, 
  120, 124, 126, 128, 130, 133, 136, 138, 141, 144, 
  147, 150, 153, 156, 159, 162, 165, 167, 171, 175, 
  179, 181, 185, 189, 191, 195, 199, 203, 205, 209, 
  213, 217, 221, 225, 229, 231, 235, 239, 243, 247, 
  251, 253, 257, 261, 265, 269, 271, 275, 279, 283, 
  287, 289, 293, 295, 299, 301, 305, 307, 311, 313, 
  317, 319, 323, 325, 329, 331, 335, 337, 341, 343, 
  347, 349, 355, 357, 363, 365, 369, 371, 375, 377, 
  379, 381, 383, 385, 387, 389, 391, 393, 395, 397, 
  399, 401, 405, 406, 408, 410, 414, 415, 417, 419, 
  421, 423, 425, 427, 429, 431, 433, 435, 437, 439, 
  441, 443, 445, 449, 451, 454, 455, 457, 461, 465, 
  467, 469, 471, 475, 477, 481, 484, 487, 490, 491, 
  493, 496, 497, 499, 501, 504, 507, 515, 521, 529, 
  537, 543, 553, 564, 572, 581, 584, 587, 591, 595, 
  598, 601, 605, 609, 613, 617, 623, 629, 633, 639, 
  641, 644, 645, 647, 652, 656, 660, 664, 668, 672, 
  676, 681, 687, 690, 699, 708, 710, 714, 715, 717, 
  718, 720, 722, 724, 726, 729, 731, 733, 734, 736, 
  737, 739};
#endif // QLALR_NO_QSCRIPTGRAMMAR_DEBUG_INFO

const int QScriptGrammar::action_default [] = {
  0, 64, 131, 95, 103, 99, 139, 146, 43, 115, 
  145, 141, 91, 0, 142, 227, 27, 143, 144, 149, 
  44, 107, 111, 32, 61, 42, 47, 26, 0, 81, 
  147, 68, 224, 223, 226, 150, 0, 160, 0, 0, 
  8, 9, 0, 5, 0, 228, 2, 0, 230, 19, 
  0, 0, 0, 0, 0, 3, 6, 0, 0, 133, 
  174, 7, 0, 1, 0, 0, 4, 0, 0, 161, 
  0, 0, 0, 151, 152, 57, 0, 140, 148, 0, 
  0, 44, 63, 228, 2, 230, 46, 45, 0, 0, 
  0, 59, 60, 58, 0, 229, 218, 219, 0, 216, 
  0, 217, 0, 220, 221, 0, 222, 215, 225, 0, 
  231, 0, 23, 25, 24, 0, 21, 0, 0, 0, 
  22, 13, 62, 0, 92, 0, 0, 0, 0, 82, 
  0, 0, 0, 0, 0, 0, 72, 0, 0, 0, 
  66, 67, 65, 70, 74, 73, 71, 69, 84, 83, 
  85, 0, 100, 0, 96, 35, 0, 0, 0, 37, 
  0, 0, 36, 132, 0, 40, 38, 0, 39, 41, 
  175, 176, 0, 128, 121, 119, 126, 127, 125, 124, 
  130, 123, 122, 120, 129, 116, 0, 104, 0, 0, 
  108, 0, 0, 112, 34, 30, 0, 0, 29, 0, 
  28, 232, 190, 0, 191, 192, 193, 186, 0, 187, 
  188, 189, 48, 0, 0, 0, 0, 0, 179, 180, 
  137, 135, 97, 105, 101, 117, 93, 138, 0, 44, 
  109, 113, 86, 75, 0, 0, 94, 0, 0, 0, 
  0, 87, 0, 0, 0, 0, 0, 79, 77, 80, 
  78, 76, 89, 88, 90, 0, 102, 0, 98, 0, 
  136, 44, 0, 118, 133, 134, 0, 133, 0, 0, 
  182, 0, 0, 0, 184, 0, 106, 0, 0, 110, 
  0, 0, 114, 172, 0, 164, 173, 167, 0, 171, 
  0, 133, 165, 0, 133, 0, 0, 183, 0, 0, 
  0, 185, 229, 218, 0, 0, 220, 0, 214, 0, 
  206, 0, 0, 0, 178, 0, 177, 154, 157, 0, 
  2, 6, 7, 155, 153, 0, 20, 0, 17, 19, 
  11, 0, 16, 12, 18, 15, 10, 0, 14, 54, 
  52, 32, 33, 31, 56, 53, 51, 0, 194, 195, 
  0, 0, 0, 197, 202, 200, 203, 0, 0, 201, 
  202, 0, 198, 0, 199, 156, 205, 0, 156, 204, 
  0, 207, 208, 55, 0, 156, 209, 210, 0, 0, 
  211, 0, 0, 0, 212, 213, 50, 49, 0, 0, 
  0, 181, 0, 0, 0, 196, 169, 162, 0, 170, 
  166, 0, 168, 158, 0, 159, 163};

const int QScriptGrammar::goto_default [] = {
  28, 27, 327, 325, 111, 13, 2, 326, 110, 109, 
  23, 16, 197, 155, 25, 8, 164, 20, 26, 75, 
  24, 1, 31, 29, 232, 12, 226, 3, 222, 5, 
  224, 4, 223, 21, 230, 22, 231, 9, 225, 221, 
  262, 347, 227, 228, 34, 6, 77, 11, 14, 17, 
  18, 10, 7, 30, 78, 19, 35, 73, 74, 319, 
  318, 76, 398, 397, 284, 285, 400, 287, 399, 286, 
  353, 357, 360, 356, 355, 376, 377, 15, 98, 105, 
  94, 97, 104, 106, 32, 0};

const int QScriptGrammar::action_index [] = {
  947, 72, -83, 40, 6, -29, -83, -83, 135, -83, 
  -83, -83, 210, 116, -83, -83, -83, -83, -83, -83, 
  429, 35, 84, 131, 147, -83, -83, -83, 51, 349, 
  -83, 158, -83, 947, -83, -83, 150, -83, 127, 501, 
  -83, -83, 868, -83, 20, 23, 46, 19, 1026, 41, 
  501, 501, 501, 297, 501, -83, -83, 501, 501, 501, 
  -83, -83, -5, -83, 501, 501, -83, -4, 501, -83, 
  501, 2, 4, -83, -83, -83, 14, -83, -83, 501, 
  501, 47, 129, 13, -83, 137, -83, -83, 501, 501, 
  501, -83, -83, -83, 3, -83, 1, 62, 26, -83, 
  49, -83, 36, 947, -83, 22, 947, -83, -83, 64, 
  66, 24, -83, -83, -83, 501, -83, 134, 68, 501, 
  -83, -83, 146, 501, 289, 501, 501, 501, 501, 349, 
  501, 501, 501, 501, 501, 501, 170, 501, 501, 501, 
  65, 69, 63, 155, 180, 122, 90, 130, 349, 349, 
  281, 501, -9, 501, 61, -83, 39, 501, 573, -83, 
  89, 501, -83, -83, 93, -83, -83, 501, -83, -83, 
  -83, -83, 501, -83, -83, -83, -83, -83, -83, -83, 
  -83, -83, -83, -83, -83, -83, 501, -43, 501, 501, 
  25, 18, 501, -83, -83, -83, 501, -16, -83, 96, 
  -83, -83, -83, 37, -83, -83, -83, -83, 70, -83, 
  -83, -83, -83, -72, -32, 501, 94, 60, -83, -83, 
  645, -83, -1, -33, -57, -83, 222, 9, -52, 357, 
  8, 76, 266, 196, -18, 501, 217, 501, 501, 501, 
  501, 246, 501, 501, 501, 501, 501, 192, 188, 149, 
  200, 195, 250, 229, 256, 501, -48, 501, 81, 501, 
  -83, 429, 501, -83, 501, -7, -55, 501, -39, 868, 
  -83, 501, 77, 868, -83, 501, -40, 501, 501, 10, 
  7, 501, -83, 5, 87, -15, -83, -83, 501, -83, 
  -22, 501, -83, -58, 501, -42, 868, -83, 501, 80, 
  868, -83, -12, -3, -37, -13, 947, 11, -83, 868, 
  -83, 501, 75, 868, 57, 868, -83, -83, 868, 21, 
  58, 52, 54, -83, -83, 88, 56, 789, -83, 55, 
  -83, 717, -83, -83, -83, -83, -83, 83, -83, -83, 
  -83, 224, -83, -83, -83, -83, -83, 32, -83, -83, 
  501, 156, 27, -83, 53, -83, 67, 74, 501, -83, 
  30, 50, -83, -19, -83, 868, -83, 73, 868, -83, 
  100, -83, -83, -83, 86, 868, 12, -83, -2, 0, 
  -83, 15, -14, 17, -83, -83, -83, -83, 501, 79, 
  868, -83, 501, 82, 868, -83, 31, -83, 111, -83, 
  -83, 501, -83, -83, 16, -83, -83, 

  -80, -86, -86, -86, -86, -86, -86, -86, -86, -86, 
  -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, 
  -23, -86, -86, 18, -86, -86, -86, -86, -86, -86, 
  -86, -86, -86, -78, -86, -86, -86, -86, -86, 102, 
  -86, -86, -33, -86, -86, -86, -86, -86, -39, -86, 
  -1, 124, 123, 121, 120, -86, -86, 144, 113, 46, 
  -86, -86, -86, -86, 47, 89, -86, -5, 110, -86, 
  92, -86, -86, -86, -86, -86, -86, -86, -86, 116, 
  96, -86, -86, -86, -86, -86, -86, -86, 39, 43, 
  69, -86, -86, -86, -86, -86, -86, -86, -86, -86, 
  -86, -86, -86, -86, -86, -86, -51, -86, -86, -86, 
  -86, -86, -86, -86, -86, 38, -86, 41, -86, 37, 
  -86, -86, -86, 80, -86, 84, 79, 87, 49, -86, 
  76, 52, 128, 95, 103, 78, -86, 97, 107, 105, 
  -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, 
  -86, 48, -86, 44, -86, -86, -86, 22, 16, -86, 
  -86, 19, -86, -86, -86, -86, -86, 20, -86, -86, 
  -86, -86, -6, -86, -86, -86, -86, -86, -86, -86, 
  -86, -86, -86, -86, -86, -86, 53, -86, 42, 12, 
  -86, -86, 26, -86, -86, -86, 23, -86, -86, -86, 
  -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, 
  -86, -86, -86, -86, -86, 3, -86, -86, -86, -86, 
  51, -86, -86, -86, -86, -86, -86, -86, -86, -86, 
  -86, -86, -86, -86, -86, 167, -86, 177, 150, 156, 
  173, -86, 72, 68, 59, 61, 65, -86, -86, -86, 
  -86, -86, -86, -86, -86, 130, -86, 137, -86, 129, 
  -86, -86, 140, -86, 62, -86, -86, 74, -86, 2, 
  -86, 34, -86, 5, -86, 159, -86, 149, 153, -86, 
  -86, 147, -86, -86, -86, -86, -86, -86, 213, -86, 
  -18, 50, -86, -86, 58, -86, 9, -86, 40, -86, 
  4, -86, -86, -44, -86, -86, -43, -86, -86, -7, 
  -86, 33, -86, -3, -86, -2, -86, -86, -9, -86, 
  -86, -86, -86, -86, -86, -86, -86, 24, -86, 0, 
  -86, 1, -86, -86, -86, -86, -86, -86, -86, -86, 
  -86, -4, -86, -86, -86, -86, -86, -86, -86, -86, 
  7, -86, -86, -86, -86, -86, -73, -86, 75, -86, 
  -58, -86, -86, -86, -86, 90, -86, -86, 94, -86, 
  -86, -86, -86, -86, -86, -21, -52, -86, -86, -30, 
  -86, -86, -86, -24, -86, -86, -86, -86, 15, -86, 
  -25, -86, 11, -86, -15, -86, -86, -86, -86, -86, 
  -86, 8, -86, -86, -53, -86, -86};

const int QScriptGrammar::action_info [] = {
  235, 161, 214, 294, 215, 151, 267, 283, 255, 264, 
  275, 283, 275, 198, 281, 255, 298, 259, 296, 257, 
  306, 269, 288, 305, 303, 192, 99, 186, 257, 375, 
  99, 350, 379, 375, 381, 358, 364, 186, 388, 96, 
  392, 123, 95, 396, 382, 396, 383, 153, 401, 328, 
  375, 201, 302, 309, 151, 311, 220, 365, 358, -25, 
  354, -24, 123, 328, 334, 309, 308, 153, 159, 103, 
  100, 115, 358, 315, 117, 119, 324, 107, 101, 121, 
  368, 161, 235, 161, 361, 161, 102, 161, 161, 86, 
  161, 161, 378, 349, 348, 290, 329, 161, 206, 205, 
  87, 167, 161, 79, 161, 79, 379, 0, 161, 79, 
  0, 0, 79, 0, 80, 137, 80, 138, 0, 404, 
  80, 219, 218, 80, 161, 0, 277, 0, 139, 362, 
  278, 211, 210, 0, 188, 313, 0, 273, 189, 390, 
  300, 88, 394, 338, 330, 162, 195, 137, 291, 138, 
  156, 0, 200, 168, 217, 137, 208, 138, 88, 88, 
  139, 372, 371, 112, 161, 196, 112, 158, 139, 157, 
  0, 158, 405, 403, 137, 0, 138, 171, 170, 203, 
  137, 113, 138, 137, 113, 138, 89, 139, 209, 207, 
  0, 0, 90, 139, 0, 137, 139, 138, 0, 114, 
  0, 0, 114, 89, 89, 137, 0, 138, 139, 90, 
  90, 204, 202, 137, 0, 138, 352, 137, 139, 138, 
  137, 137, 138, 138, 0, 137, 139, 138, 125, 126, 
  139, 0, 0, 139, 139, 237, 238, 0, 139, 195, 
  237, 238, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 242, 243, 0, 127, 128, 0, 196, 0, 
  158, 244, 239, 240, 245, 0, 246, 239, 240, 242, 
  243, 0, 0, 242, 243, 0, 0, 0, 244, 242, 
  243, 245, 244, 246, 0, 245, 0, 246, 244, 242, 
  243, 245, 0, 246, 0, 0, 0, 0, 244, 0, 
  0, 245, 0, 246, 130, 131, 0, 125, 126, 40, 
  41, 0, 132, 133, 0, 0, 134, 0, 135, 83, 
  0, 0, 0, 0, 0, 0, 84, 0, 0, 0, 
  85, 49, 0, 50, 127, 128, 0, 0, 0, 0, 
  53, 0, 0, 0, 56, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  173, 0, 61, 0, 63, 0, 0, 0, 0, 0, 
  174, 0, 130, 131, 175, 55, 66, 43, 0, 0, 
  132, 133, 0, 176, 134, 177, 135, 0, 271, 0, 
  0, 0, 0, 0, 0, 0, 178, 0, 179, 86, 
  0, 0, 0, 0, 0, 0, 180, 0, 0, 181, 
  87, 0, 0, 0, 0, 182, 0, 0, 0, 0, 
  0, 183, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 173, 0, 184, 0, 0, 0, 0, 0, 
  0, 0, 174, 0, 0, 0, 175, 0, 0, 0, 
  0, 0, 0, 0, 0, 176, 0, 177, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 178, 0, 
  179, 86, 0, 0, 0, 0, 0, 0, 180, 0, 
  0, 181, 87, 0, 0, 0, 0, 182, 0, 0, 
  0, 0, 0, 183, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 184, 0, 0, 0, 
  0, 0, 39, 40, 41, 0, 0, 0, 0, 0, 
  0, 0, 0, 83, 0, 0, 0, 0, 0, 0, 
  84, 0, 0, 0, 85, 49, 0, 50, 0, 0, 
  0, 51, 0, 52, 53, 54, 0, 0, 56, 0, 
  0, 0, 57, 0, 58, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 61, 0, 63, 0, 
  65, 0, 68, 0, 70, 0, 0, 0, 0, 55, 
  66, 43, 0, 0, 39, 40, 41, 0, 0, 0, 
  0, 0, 0, 0, 0, 83, 0, 0, 0, 0, 
  0, 0, 84, 0, 0, 0, 85, 49, 0, 50, 
  0, 0, 0, 51, 0, 52, 53, 54, 0, 0, 
  56, 0, 0, 0, 57, 0, 58, 0, 0, 0, 
  0, 0, 0, 166, 0, 0, 0, 0, 61, 0, 
  63, 0, 65, 0, 68, 0, 70, 0, 0, 0, 
  0, 55, 66, 43, 0, 0, 39, 40, 41, 0, 
  0, 0, 0, 0, 0, 0, 0, 83, 0, 0, 
  0, 0, 0, 0, 84, 0, 0, 0, 85, 49, 
  0, 50, 0, 0, 0, 51, 0, 52, 53, 54, 
  0, 0, 56, 0, 0, 0, 57, 0, 58, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  61, 0, 63, 0, 65, 0, 68, 234, 70, 0, 
  0, 0, 0, 55, 66, 43, 0, 0, 39, 40, 
  41, 0, 0, 0, 0, 0, 0, 0, 0, 83, 
  0, 0, 0, 0, 0, 0, 84, 0, 0, 0, 
  85, 49, 0, 50, 0, 0, 0, 51, 0, 52, 
  53, 54, 0, 0, 56, 0, 0, 0, 57, 0, 
  58, 0, 0, 333, 0, 0, 0, 0, 0, 0, 
  0, 0, 61, 0, 63, 0, 65, 0, 68, 0, 
  70, 0, 0, 0, 0, 55, 66, 43, 0, 0, 
  39, 40, 41, 0, 0, 0, 0, 0, 0, 0, 
  0, 83, 0, 0, 0, 0, 0, 0, 84, 0, 
  0, 0, 85, 49, 0, 50, 0, 0, 0, 51, 
  0, 52, 53, 54, 0, 0, 56, 0, 0, 0, 
  57, 0, 58, 0, 0, 336, 0, 0, 0, 0, 
  0, 0, 0, 0, 61, 0, 63, 0, 65, 0, 
  68, 0, 70, 0, 0, 0, 0, 55, 66, 43, 
  0, 0, 36, 0, 0, 0, 0, 38, 0, 39, 
  40, 41, 42, 0, 0, 0, 0, 0, 0, 44, 
  83, 0, 0, 0, 0, 0, 0, 46, 47, 0, 
  0, 48, 49, 0, 50, 0, 0, 0, 51, 0, 
  52, 53, 54, 0, 0, 56, 0, 0, 0, 57, 
  0, 58, 0, 0, 0, 0, 0, 59, 0, 60, 
  0, 0, 0, 61, 62, 63, 64, 65, 67, 68, 
  69, 70, 71, 72, 0, 0, 55, 66, 43, 37, 
  0, 36, 0, 0, 0, 0, 38, 0, 39, 40, 
  41, 42, 0, 0, 0, 0, 0, 0, 44, 45, 
  0, 0, 0, 0, 0, 0, 46, 47, 0, 0, 
  48, 49, 0, 50, 0, 0, 0, 51, 0, 52, 
  53, 54, 0, 0, 56, 0, 0, 0, 57, 0, 
  58, 0, 0, 0, 0, 0, 59, 0, 60, 0, 
  0, 0, 61, 62, 63, 64, 65, 67, 68, 69, 
  70, 71, 72, 0, 0, 55, 66, 43, 37, 0, 
  36, 0, 0, 0, 0, 38, 0, 39, 40, 41, 
  42, 0, 0, 0, 0, 0, 0, 44, 83, 0, 
  0, 0, 0, 0, 0, 320, 47, 0, 0, 48, 
  49, 0, 50, 0, 0, 0, 51, 0, 52, 53, 
  54, 0, 0, 321, 0, 0, 0, 57, 0, 58, 
  0, -156, 0, 0, 0, 59, 0, 60, 0, 0, 
  0, 322, 62, 63, 64, 65, 67, 68, 69, 70, 
  71, 72, 0, 0, 55, 66, 43, 37, 0, 

  185, 359, 331, 33, 337, 317, 108, 332, 216, 343, 
  406, 213, 351, 363, 402, 385, 393, 172, 191, 391, 
  389, 384, 165, 317, 380, 163, 169, 160, 199, 395, 
  335, 194, 193, 108, 304, 323, 307, 310, 312, 272, 
  374, 314, 316, 120, 116, 299, 270, 292, 301, 274, 
  118, 265, 370, 297, 0, 265, 81, 0, 91, 81, 
  81, 81, 92, 265, 0, 81, 81, 265, 229, 81, 
  81, 154, 150, 233, 143, 190, 81, 152, 81, 265, 
  367, 249, 81, 250, 187, 81, 81, 251, 93, 81, 
  248, 293, 0, 81, 247, 81, 81, 81, 136, 295, 
  147, 81, 148, 266, 81, 124, 81, 129, 373, 81, 
  149, 387, 81, 81, 81, 268, 122, 145, 140, 81, 
  81, 212, 81, 0, 81, 146, 142, 81, 141, 386, 
  81, 341, 346, 81, 317, 342, 82, 81, 317, 344, 
  81, 81, 340, 339, 0, 81, 261, 81, 0, 366, 
  144, 233, 233, 369, 81, 0, 0, 261, 0, 233, 
  256, 81, 233, 345, 261, 258, 81, 81, 260, 233, 
  261, 233, 233, 81, 252, 233, 81, 0, 233, 263, 
  253, 233, 0, 279, 81, 0, 282, 0, 0, 233, 
  81, 276, 280, 236, 81, 233, 0, 254, 0, 233, 
  0, 241, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  261, 0, 0, 0, 0, 233, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 289, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0};

const int QScriptGrammar::action_check [] = {
  1, 8, 74, 61, 36, 48, 61, 29, 48, 61, 
  2, 29, 2, 29, 7, 48, 31, 8, 60, 76, 
  33, 60, 17, 60, 36, 7, 29, 2, 76, 33, 
  29, 36, 20, 33, 36, 5, 55, 2, 36, 36, 
  36, 1, 29, 29, 29, 29, 60, 76, 17, 8, 
  33, 0, 29, 7, 48, 36, 36, 7, 5, 7, 
  33, 7, 1, 8, 8, 7, 55, 76, 29, 33, 
  8, 7, 5, 16, 8, 7, 55, 55, 29, 55, 
  7, 8, 1, 8, 10, 8, 60, 8, 8, 42, 
  8, 8, 6, 61, 62, 8, 8, 8, 61, 62, 
  53, 8, 8, 40, 8, 40, 20, -1, 8, 40, 
  -1, -1, 40, -1, 51, 25, 51, 27, -1, 8, 
  51, 61, 62, 51, 8, -1, 50, -1, 38, 55, 
  54, 61, 62, -1, 50, 60, -1, 60, 54, 60, 
  60, 12, 60, 60, 56, 56, 15, 25, 61, 27, 
  15, -1, 56, 60, 60, 25, 29, 27, 12, 12, 
  38, 61, 62, 29, 8, 34, 29, 36, 38, 34, 
  -1, 36, 61, 62, 25, -1, 27, 61, 62, 29, 
  25, 47, 27, 25, 47, 27, 57, 38, 61, 62, 
  -1, -1, 63, 38, -1, 25, 38, 27, -1, 65, 
  -1, -1, 65, 57, 57, 25, -1, 27, 38, 63, 
  63, 61, 62, 25, -1, 27, 60, 25, 38, 27, 
  25, 25, 27, 27, -1, 25, 38, 27, 18, 19, 
  38, -1, -1, 38, 38, 18, 19, -1, 38, 15, 
  18, 19, -1, -1, -1, -1, -1, -1, -1, -1, 
  -1, -1, 23, 24, -1, 45, 46, -1, 34, -1, 
  36, 32, 45, 46, 35, -1, 37, 45, 46, 23, 
  24, -1, -1, 23, 24, -1, -1, -1, 32, 23, 
  24, 35, 32, 37, -1, 35, -1, 37, 32, 23, 
  24, 35, -1, 37, -1, -1, -1, -1, 32, -1, 
  -1, 35, -1, 37, 23, 24, -1, 18, 19, 12, 
  13, -1, 31, 32, -1, -1, 35, -1, 37, 22, 
  -1, -1, -1, -1, -1, -1, 29, -1, -1, -1, 
  33, 34, -1, 36, 45, 46, -1, -1, -1, -1, 
  43, -1, -1, -1, 47, -1, -1, -1, -1, -1, 
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
  3, -1, 65, -1, 67, -1, -1, -1, -1, -1, 
  13, -1, 23, 24, 17, 78, 79, 80, -1, -1, 
  31, 32, -1, 26, 35, 28, 37, -1, 31, -1, 
  -1, -1, -1, -1, -1, -1, 39, -1, 41, 42, 
  -1, -1, -1, -1, -1, -1, 49, -1, -1, 52, 
  53, -1, -1, -1, -1, 58, -1, -1, -1, -1, 
  -1, 64, -1, -1, -1, -1, -1, -1, -1, -1, 
  -1, -1, 3, -1, 77, -1, -1, -1, -1, -1, 
  -1, -1, 13, -1, -1, -1, 17, -1, -1, -1, 
  -1, -1, -1, -1, -1, 26, -1, 28, -1, -1, 
  -1, -1, -1, -1, -1, -1, -1, -1, 39, -1, 
  41, 42, -1, -1, -1, -1, -1, -1, 49, -1, 
  -1, 52, 53, -1, -1, -1, -1, 58, -1, -1, 
  -1, -1, -1, 64, -1, -1, -1, -1, -1, -1, 
  -1, -1, -1, -1, -1, -1, 77, -1, -1, -1, 
  -1, -1, 11, 12, 13, -1, -1, -1, -1, -1, 
  -1, -1, -1, 22, -1, -1, -1, -1, -1, -1, 
  29, -1, -1, -1, 33, 34, -1, 36, -1, -1, 
  -1, 40, -1, 42, 43, 44, -1, -1, 47, -1, 
  -1, -1, 51, -1, 53, -1, -1, -1, -1, -1, 
  -1, -1, -1, -1, -1, -1, 65, -1, 67, -1, 
  69, -1, 71, -1, 73, -1, -1, -1, -1, 78, 
  79, 80, -1, -1, 11, 12, 13, -1, -1, -1, 
  -1, -1, -1, -1, -1, 22, -1, -1, -1, -1, 
  -1, -1, 29, -1, -1, -1, 33, 34, -1, 36, 
  -1, -1, -1, 40, -1, 42, 43, 44, -1, -1, 
  47, -1, -1, -1, 51, -1, 53, -1, -1, -1, 
  -1, -1, -1, 60, -1, -1, -1, -1, 65, -1, 
  67, -1, 69, -1, 71, -1, 73, -1, -1, -1, 
  -1, 78, 79, 80, -1, -1, 11, 12, 13, -1, 
  -1, -1, -1, -1, -1, -1, -1, 22, -1, -1, 
  -1, -1, -1, -1, 29, -1, -1, -1, 33, 34, 
  -1, 36, -1, -1, -1, 40, -1, 42, 43, 44, 
  -1, -1, 47, -1, -1, -1, 51, -1, 53, -1, 
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
  65, -1, 67, -1, 69, -1, 71, 72, 73, -1, 
  -1, -1, -1, 78, 79, 80, -1, -1, 11, 12, 
  13, -1, -1, -1, -1, -1, -1, -1, -1, 22, 
  -1, -1, -1, -1, -1, -1, 29, -1, -1, -1, 
  33, 34, -1, 36, -1, -1, -1, 40, -1, 42, 
  43, 44, -1, -1, 47, -1, -1, -1, 51, -1, 
  53, -1, -1, 56, -1, -1, -1, -1, -1, -1, 
  -1, -1, 65, -1, 67, -1, 69, -1, 71, -1, 
  73, -1, -1, -1, -1, 78, 79, 80, -1, -1, 
  11, 12, 13, -1, -1, -1, -1, -1, -1, -1, 
  -1, 22, -1, -1, -1, -1, -1, -1, 29, -1, 
  -1, -1, 33, 34, -1, 36, -1, -1, -1, 40, 
  -1, 42, 43, 44, -1, -1, 47, -1, -1, -1, 
  51, -1, 53, -1, -1, 56, -1, -1, -1, -1, 
  -1, -1, -1, -1, 65, -1, 67, -1, 69, -1, 
  71, -1, 73, -1, -1, -1, -1, 78, 79, 80, 
  -1, -1, 4, -1, -1, -1, -1, 9, -1, 11, 
  12, 13, 14, -1, -1, -1, -1, -1, -1, 21, 
  22, -1, -1, -1, -1, -1, -1, 29, 30, -1, 
  -1, 33, 34, -1, 36, -1, -1, -1, 40, -1, 
  42, 43, 44, -1, -1, 47, -1, -1, -1, 51, 
  -1, 53, -1, -1, -1, -1, -1, 59, -1, 61, 
  -1, -1, -1, 65, 66, 67, 68, 69, 70, 71, 
  72, 73, 74, 75, -1, -1, 78, 79, 80, 81, 
  -1, 4, -1, -1, -1, -1, 9, -1, 11, 12, 
  13, 14, -1, -1, -1, -1, -1, -1, 21, 22, 
  -1, -1, -1, -1, -1, -1, 29, 30, -1, -1, 
  33, 34, -1, 36, -1, -1, -1, 40, -1, 42, 
  43, 44, -1, -1, 47, -1, -1, -1, 51, -1, 
  53, -1, -1, -1, -1, -1, 59, -1, 61, -1, 
  -1, -1, 65, 66, 67, 68, 69, 70, 71, 72, 
  73, 74, 75, -1, -1, 78, 79, 80, 81, -1, 
  4, -1, -1, -1, -1, 9, -1, 11, 12, 13, 
  14, -1, -1, -1, -1, -1, -1, 21, 22, -1, 
  -1, -1, -1, -1, -1, 29, 30, -1, -1, 33, 
  34, -1, 36, -1, -1, -1, 40, -1, 42, 43, 
  44, -1, -1, 47, -1, -1, -1, 51, -1, 53, 
  -1, 55, -1, -1, -1, 59, -1, 61, -1, -1, 
  -1, 65, 66, 67, 68, 69, 70, 71, 72, 73, 
  74, 75, -1, -1, 78, 79, 80, 81, -1, 

  6, 74, 2, 83, 5, 44, 84, 6, 5, 13, 
  63, 44, 5, 71, 6, 45, 5, 40, 6, 44, 
  5, 45, 6, 44, 76, 6, 6, 5, 5, 44, 
  6, 13, 6, 84, 78, 44, 79, 44, 5, 5, 
  45, 44, 44, 6, 6, 5, 44, 65, 44, 44, 
  9, 5, 5, 44, -1, 5, 17, -1, 19, 17, 
  17, 17, 19, 5, -1, 17, 17, 5, 17, 17, 
  17, 27, 23, 22, 22, 33, 17, 29, 17, 5, 
  5, 22, 17, 22, 31, 17, 17, 22, 19, 17, 
  22, 41, -1, 17, 22, 17, 17, 17, 22, 41, 
  22, 17, 23, 41, 17, 25, 17, 23, 19, 17, 
  23, 19, 17, 17, 17, 41, 20, 22, 21, 17, 
  17, 19, 17, -1, 17, 22, 21, 17, 21, 19, 
  17, 10, 19, 17, 44, 14, 20, 17, 44, 19, 
  17, 17, 19, 19, -1, 17, 17, 17, -1, 59, 
  22, 22, 22, 59, 17, -1, -1, 17, -1, 22, 
  30, 17, 22, 19, 17, 28, 17, 17, 39, 22, 
  17, 22, 22, 17, 24, 22, 17, -1, 22, 39, 
  24, 22, -1, 34, 17, -1, 39, -1, -1, 22, 
  17, 32, 39, 26, 17, 22, -1, 24, -1, 22, 
  -1, 24, -1, -1, -1, -1, -1, -1, -1, -1, 
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
  17, -1, -1, -1, -1, 22, -1, -1, -1, -1, 
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
  -1, -1, 39, -1, -1, -1, -1, -1, -1, -1, 
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
  -1, -1, -1, -1, -1, -1, -1, -1, -1};

QT_END_NAMESPACE

#endif // QT_NO_SCRIPT
