/****************************************************************************
**
** Copyright (C) 2008-2008 Trolltech ASA. All rights reserved.
**
** This file is part of the demonstration applications of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License versions 2.0 or 3.0 as published by the Free Software
** Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file.  Alternatively you may (at
** your option) use any later version of the GNU General Public
** License if such license has been publicly approved by Trolltech ASA
** (or its successors, if any) and the KDE Free Qt Foundation.
**
** Please review the following information to ensure GNU General
** Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/. If
** you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** In addition, as a special exception, Trolltech, as the sole
** copyright holder for Qt Designer, grants users of the Qt/Eclipse
** Integration plug-in the right for the Qt/Eclipse Integration to
** link to functionality provided by Qt Designer and its related
** libraries.
**
** This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
** INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
** granted herein.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/
#include <QApplication>
#include <QString>
#include <QFile>

#include "stylewidget.h"



StyleWidget::StyleWidget(QWidget *parent)
 : QFrame(parent)
{
	m_ui.setupUi(this);
}


void StyleWidget::on_close_clicked()
{
    close();
}

void StyleWidget::on_blueStyle_clicked()
{
    QFile styleSheet(":/files/blue.qss");

    if (!styleSheet.open(QIODevice::ReadOnly)) {
        qWarning("Unable to open :/files/blue.qss");
        return;
    }

    qApp->setStyleSheet(styleSheet.readAll());
}

void StyleWidget::on_khakiStyle_clicked()
{
    QFile styleSheet(":/files/khaki.qss");

    if (!styleSheet.open(QIODevice::ReadOnly)) {
        qWarning("Unable to open :/files/khaki.qss");
        return;
    }

    qApp->setStyleSheet(styleSheet.readAll());
}


void StyleWidget::on_noStyle_clicked()
{
    QFile styleSheet(":/files/nostyle.qss");

    if (!styleSheet.open(QIODevice::ReadOnly)) {
        qWarning("Unable to open :/files/nostyle.qss");
        return;
    }

    qApp->setStyleSheet(styleSheet.readAll());
}


void StyleWidget::on_transparentStyle_clicked()
{
    QFile styleSheet(":/files/transparent.qss");

    if (!styleSheet.open(QIODevice::ReadOnly)) {
        qWarning("Unable to open :/files/transparent.qss");
        return;
    }

    qApp->setStyleSheet(styleSheet.readAll());
}



