/****************************************************************************
**
** Copyright (C) 2007-2008 Trolltech ASA. All rights reserved.
**
** This file is part of the Qt Assistant of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License versions 2.0 or 3.0 as published by the Free Software
** Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file.  Alternatively you may (at
** your option) use any later version of the GNU General Public
** License if such license has been publicly approved by Trolltech ASA
** (or its successors, if any) and the KDE Free Qt Foundation. 
**
** Please review the following information to ensure GNU General
** Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/. If
** you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** In addition, as a special exception, Trolltech, as the sole
** copyright holder for Qt Designer, grants users of the Qt/Eclipse
** Integration plug-in the right for the Qt/Eclipse Integration to
** link to functionality provided by Qt Designer and its related
** libraries.
**
** This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
** INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
** granted herein.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef BOOKMARKWIDGET_H
#define BOOKMARKWIDGET_H

#include <QtCore/QUrl>
#include <QtCore/QString>
#include <QtCore/QObject>
#include <QtCore/QStringList>

#include <QtGui/QTreeWidget>

QT_BEGIN_NAMESPACE

class QEvent;
class QTreeWidgetItem;

class BookmarkWidget : public QTreeWidget
{
    Q_OBJECT

public:
    BookmarkWidget(QWidget *parent = 0, bool custom = true);
    ~BookmarkWidget();

    QByteArray bookmarks() const;
    QStringList bookmarkFolders() const;
    void setBookmarks(const QByteArray &bookmarks);

signals:
    void requestShowLink(const QUrl& url);
    void saveBookmarks(const QByteArray& bookmarks);
    void currentItemChanged(const QString& title);

public slots:
    void removeBookmarkOrFolder();
    void selectBookmarkFolder(const QString &title);
    void itemChanged(QTreeWidgetItem *item, int column);
    void addNewFolder(const QString &title);
    void addNewBookmark(const QString& title, const QString &url);
    void currentItemChanged(QTreeWidgetItem *current, QTreeWidgetItem *previous);

private slots:
    void showContextMenu(const QPoint &point);
    void itemActivated(QTreeWidgetItem* item, int column);

private:
    QTreeWidgetItem* itemIfNotDirectory();
    bool eventFilter(QObject *object, QEvent *e);
    void readBookmarkFolderRecursive(const QTreeWidgetItem *item, 
        QDataStream &stream, const qint32 depth) const;

private:
    bool m_custom;
};

QT_END_NAMESPACE

#endif  // BOOKMARK_WIDGET_H
