/****************************************************************************
**
** Copyright (C) 2006-2008 Trolltech ASA. All rights reserved.
**
** This file is part of the QtXMLPatterns module of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License versions 2.0 or 3.0 as published by the Free Software
** Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file.  Alternatively you may (at
** your option) use any later version of the GNU General Public
** License if such license has been publicly approved by Trolltech ASA
** (or its successors, if any) and the KDE Free Qt Foundation. 
**
** Please review the following information to ensure GNU General
** Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/. If
** you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** In addition, as a special exception, Trolltech, as the sole
** copyright holder for Qt Designer, grants users of the Qt/Eclipse
** Integration plug-in the right for the Qt/Eclipse Integration to
** link to functionality provided by Qt Designer and its related
** libraries.
**
** This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
** INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
** granted herein.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.

#ifndef Patternist_Duration_H
#define Patternist_Duration_H

#include "qabstractduration_p.h"

QT_BEGIN_HEADER

QT_BEGIN_NAMESPACE

namespace QPatternist
{
    /**
     * @short Implements the value instance of the @c xs:duration type.
     *
     * @author Frans Englich <fenglich@trolltech.com>
     * @ingroup Patternist_xdm
     */
    class Duration : public AbstractDuration
    {
    public:
        typedef AtomicValue::Ptr Ptr;

        /**
         * Creates an instance from the lexical representation @p string.
         */
        static Duration::Ptr fromLexical(const QString &string);
        static Duration::Ptr fromComponents(const bool isPositive,
                                            const YearProperty years,
                                            const MonthProperty months,
                                            const DayCountProperty days,
                                            const HourProperty hours,
                                            const MinuteProperty minutes,
                                            const SecondProperty seconds,
                                            const MSecondProperty mseconds);

        virtual ItemType::Ptr type() const;
        virtual QString stringValue() const;

        /**
         * Always results in an assert crash. Calling this function makes no
         * sense due to that the value space of xs:duration is not well defined.
         */
        virtual Value value() const;

        /**
         * Always results in an assert crash. Calling this function makes no
         * sense due to that the value space of xs:duration is not well defined.
         */
        virtual Item fromValue(const Value val) const;

        virtual YearProperty years() const;
        virtual MonthProperty months() const;
        virtual DayCountProperty days() const;
        virtual HourProperty hours() const;
        virtual MinuteProperty minutes() const;
        virtual SecondProperty seconds() const;
        virtual MSecondProperty mseconds() const;

    protected:
        friend class CommonValues;

        Duration(const bool isPositive,
                 const YearProperty years,
                 const MonthProperty months,
                 const DayCountProperty days,
                 const HourProperty hours,
                 const MinuteProperty minutes,
                 const SecondProperty seconds,
                 const MSecondProperty mseconds);
    private:
        const YearProperty      m_years;
        const MonthProperty     m_months;
        const DayCountProperty  m_days;
        const HourProperty      m_hours;
        const MinuteProperty    m_minutes;
        const SecondProperty    m_seconds;
        const MSecondProperty   m_mseconds;
    };
}

QT_END_NAMESPACE

QT_END_HEADER

#endif
