/****************************************************************************
**
** Copyright (C) 1992-2008 Trolltech ASA. All rights reserved.
**
** This file is part of the QtScript module of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License versions 2.0 or 3.0 as published by the Free Software
** Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file.  Alternatively you may (at
** your option) use any later version of the GNU General Public
** License if such license has been publicly approved by Trolltech ASA
** (or its successors, if any) and the KDE Free Qt Foundation. 
**
** Please review the following information to ensure GNU General
** Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/. If
** you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** In addition, as a special exception, Trolltech, as the sole
** copyright holder for Qt Designer, grants users of the Qt/Eclipse
** Integration plug-in the right for the Qt/Eclipse Integration to
** link to functionality provided by Qt Designer and its related
** libraries.
**
** This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
** INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
** granted herein.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "qscriptgrammar_p.h"

#ifndef QT_NO_SCRIPT

QT_BEGIN_NAMESPACE

const char *const QScriptGrammar::spell [] = {
  "end of file", "&", "&&", "&=", "break", "case", "catch", ":", ";", "continue",
  "default", "delete", "/", "/=", "do", ".", "else", "=", "==", "===",
  "finally", "for", "function", ">=", ">", ">>", ">>=", ">>>", ">>>=", "identifier",
  "if", "in", "instanceof", "{", "[", "<=", "(", "<", "<<", "<<=",
  "-", "-=", "--", "new", "!", "!=", "!==", "numeric literal", "|", "|=",
  "||", "+", "+=", "++", "?", "}", "]", "%", "%=", "return",
  ")", ";", 0, "*", "*=", "string literal", "switch", "this", "throw", "~",
  "try", "typeof", "var", "void", "while", "with", "^", "^=", "null", "true",
  "false", "const", "reserved word",
#ifndef QLALR_NO_QSCRIPTGRAMMAR_DEBUG_INFO
"Program", "PrimaryExpression", "ElisionOpt", "ElementList", "PropertyNameAndValueListOpt", "Expression", "AssignmentExpression",
  "Elision", "PropertyNameAndValueList", "PropertyName", "MemberExpression", "FunctionExpression", "ExtraIdentifiersMarker", "Arguments", "NewExpression", "CallExpression", "ArgumentList",
  "LeftHandSideExpression", "PostfixExpression", "UnaryExpression", "MultiplicativeExpression", "AdditiveExpression", "ShiftExpression", "RelationalExpression", "RelationalExpressionNotIn", "EqualityExpression", "EqualityExpressionNotIn",
  "BitwiseANDExpression", "BitwiseANDExpressionNotIn", "BitwiseXORExpression", "BitwiseXORExpressionNotIn", "BitwiseORExpression", "BitwiseORExpressionNotIn", "LogicalANDExpression", "LogicalANDExpressionNotIn", "LogicalORExpression", "LogicalORExpressionNotIn",
  "ConditionalExpression", "ConditionalExpressionNotIn", "AssignmentExpressionNotIn", "AssignmentOperator", "ExpressionOpt", "ExpressionNotIn", "ExpressionNotInOpt", "Statement", "Block", "VariableStatement",
  "EmptyStatement", "ExpressionStatement", "IfStatement", "IterationStatement", "ContinueStatement", "BreakStatement", "ReturnStatement", "WithStatement", "LabelledStatement", "SwitchStatement",
  "ThrowStatement", "TryStatement", "StatementListOpt", "StatementList", "VariableDeclarationKind", "VariableDeclarationList", "VariableDeclaration", "VariableDeclarationListNotIn", "VariableDeclarationNotIn", "InitialiserOpt",
  "InitialiserNotInOpt", "Initialiser", "InitialiserNotIn", "CaseBlock", "CaseClausesOpt", "DefaultClause", "CaseClauses", "CaseClause", "Catch", "Finally",
  "FunctionDeclaration", "FormalParameterListOpt", "FunctionBodyOpt", "IdentifierOpt", "FormalParameterList", "FunctionBody", "SourceElements", "SourceElement", "$accept"
#endif // QLALR_NO_QSCRIPTGRAMMAR_DEBUG_INFO
};

const int QScriptGrammar::lhs [] = {
  84, 84, 84, 84, 84, 84, 84, 84, 84, 84,
  84, 84, 84, 86, 86, 90, 90, 85, 85, 91,
  91, 92, 92, 92, 93, 93, 93, 93, 95, 93,
  97, 97, 98, 98, 98, 98, 96, 96, 99, 99,
  100, 100, 101, 101, 101, 102, 102, 102, 102, 102,
  102, 102, 102, 102, 102, 103, 103, 103, 103, 104,
  104, 104, 105, 105, 105, 105, 106, 106, 106, 106,
  106, 106, 106, 107, 107, 107, 107, 107, 107, 108,
  108, 108, 108, 108, 109, 109, 109, 109, 109, 110,
  110, 111, 111, 112, 112, 113, 113, 114, 114, 115,
  115, 116, 116, 117, 117, 118, 118, 119, 119, 120,
  120, 121, 121, 89, 89, 122, 122, 123, 123, 123,
  123, 123, 123, 123, 123, 123, 123, 123, 123, 88,
  88, 124, 124, 125, 125, 126, 126, 127, 127, 127,
  127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
  127, 128, 143, 143, 142, 142, 129, 129, 144, 144,
  145, 145, 147, 147, 146, 148, 151, 149, 149, 152,
  150, 150, 130, 131, 131, 132, 132, 133, 133, 133,
  133, 133, 133, 133, 134, 134, 134, 134, 135, 135,
  135, 135, 136, 136, 137, 139, 153, 153, 156, 156,
  154, 154, 157, 155, 138, 140, 140, 141, 141, 141,
  158, 159, 160, 94, 164, 164, 161, 161, 162, 162,
  165, 83, 166, 166, 167, 167, 163, 163, 87, 87,
  168};

const int QScriptGrammar:: rhs[] = {
  1, 1, 1, 1, 1, 1, 1, 1, 3, 3,
  5, 3, 3, 2, 4, 1, 2, 0, 1, 3,
  5, 1, 1, 1, 1, 1, 4, 4, 0, 3,
  1, 2, 2, 2, 4, 3, 2, 3, 1, 3,
  1, 1, 1, 2, 2, 1, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 1, 3, 3, 3, 1,
  3, 3, 1, 3, 3, 3, 1, 3, 3, 3,
  3, 3, 3, 1, 3, 3, 3, 3, 3, 1,
  3, 3, 3, 3, 1, 3, 3, 3, 3, 1,
  3, 1, 3, 1, 3, 1, 3, 1, 3, 1,
  3, 1, 3, 1, 3, 1, 3, 1, 3, 1,
  5, 1, 5, 1, 3, 1, 3, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  3, 0, 1, 1, 3, 0, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 3, 1, 2, 0, 1, 3, 3, 1, 1,
  1, 3, 1, 3, 2, 2, 2, 0, 1, 2,
  0, 1, 1, 2, 2, 7, 5, 7, 7, 5,
  9, 10, 7, 8, 2, 2, 3, 3, 2, 2,
  3, 3, 3, 3, 5, 5, 3, 5, 1, 2,
  0, 1, 4, 3, 3, 3, 3, 3, 3, 4,
  5, 2, 8, 8, 1, 3, 0, 1, 0, 1,
  1, 1, 1, 2, 1, 1, 0, 1, 0, 1,
  2};


#ifndef QLALR_NO_QSCRIPTGRAMMAR_DEBUG_INFO
const int QScriptGrammar::rule_info [] = {
    84, 67
  , 84, 29
  , 84, 78
  , 84, 79
  , 84, 80
  , 84, 47
  , 84, 65
  , 84, 12
  , 84, 34, 85, 56
  , 84, 34, 86, 56
  , 84, 34, 86, 8, 85, 56
  , 84, 33, 87, 55
  , 84, 36, 88, 60
  , 86, 85, 89
  , 86, 86, 8, 85, 89
  , 90, 8
  , 90, 90, 8
  , 85
  , 85, 90
  , 91, 92, 7, 89
  , 91, 91, 8, 92, 7, 89
  , 92, 29
  , 92, 65
  , 92, 47
  , 93, 84
  , 93, 94
  , 93, 93, 34, 88, 56
  , 93, 93, 15, 95, 29
  , 95
  , 93, 43, 93, 96
  , 97, 93
  , 97, 43, 97
  , 98, 93, 96
  , 98, 98, 96
  , 98, 98, 34, 88, 56
  , 98, 98, 15, 29
  , 96, 36, 60
  , 96, 36, 99, 60
  , 99, 89
  , 99, 99, 8, 89
  , 100, 97
  , 100, 98
  , 101, 100
  , 101, 100, 53
  , 101, 100, 42
  , 102, 101
  , 102, 11, 102
  , 102, 73, 102
  , 102, 71, 102
  , 102, 53, 102
  , 102, 42, 102
  , 102, 51, 102
  , 102, 40, 102
  , 102, 69, 102
  , 102, 44, 102
  , 103, 102
  , 103, 103, 63, 102
  , 103, 103, 12, 102
  , 103, 103, 57, 102
  , 104, 103
  , 104, 104, 51, 103
  , 104, 104, 40, 103
  , 105, 104
  , 105, 105, 38, 104
  , 105, 105, 25, 104
  , 105, 105, 27, 104
  , 106, 105
  , 106, 106, 37, 105
  , 106, 106, 24, 105
  , 106, 106, 35, 105
  , 106, 106, 23, 105
  , 106, 106, 32, 105
  , 106, 106, 31, 105
  , 107, 105
  , 107, 107, 37, 105
  , 107, 107, 24, 105
  , 107, 107, 35, 105
  , 107, 107, 23, 105
  , 107, 107, 32, 105
  , 108, 106
  , 108, 108, 18, 106
  , 108, 108, 45, 106
  , 108, 108, 19, 106
  , 108, 108, 46, 106
  , 109, 107
  , 109, 109, 18, 107
  , 109, 109, 45, 107
  , 109, 109, 19, 107
  , 109, 109, 46, 107
  , 110, 108
  , 110, 110, 1, 108
  , 111, 109
  , 111, 111, 1, 109
  , 112, 110
  , 112, 112, 76, 110
  , 113, 111
  , 113, 113, 76, 111
  , 114, 112
  , 114, 114, 48, 112
  , 115, 113
  , 115, 115, 48, 113
  , 116, 114
  , 116, 116, 2, 114
  , 117, 115
  , 117, 117, 2, 115
  , 118, 116
  , 118, 118, 50, 116
  , 119, 117
  , 119, 119, 50, 117
  , 120, 118
  , 120, 118, 54, 89, 7, 89
  , 121, 119
  , 121, 119, 54, 122, 7, 122
  , 89, 120
  , 89, 100, 123, 89
  , 122, 121
  , 122, 100, 123, 122
  , 123, 17
  , 123, 64
  , 123, 13
  , 123, 58
  , 123, 52
  , 123, 41
  , 123, 39
  , 123, 26
  , 123, 28
  , 123, 3
  , 123, 77
  , 123, 49
  , 88, 89
  , 88, 88, 8, 89
  , 124
  , 124, 88
  , 125, 122
  , 125, 125, 8, 122
  , 126
  , 126, 125
  , 127, 128
  , 127, 129
  , 127, 130
  , 127, 131
  , 127, 132
  , 127, 133
  , 127, 134
  , 127, 135
  , 127, 136
  , 127, 137
  , 127, 138
  , 127, 139
  , 127, 140
  , 127, 141
  , 128, 33, 142, 55
  , 143, 127
  , 143, 143, 127
  , 142
  , 142, 143
  , 129, 144, 145, 62
  , 129, 144, 145, 61
  , 144, 81
  , 144, 72
  , 145, 146
  , 145, 145, 8, 146
  , 147, 148
  , 147, 147, 8, 148
  , 146, 29, 149
  , 148, 29, 150
  , 151, 17, 89
  , 149
  , 149, 151
  , 152, 17, 122
  , 150
  , 150, 152
  , 130, 61
  , 131, 88, 62
  , 131, 88, 61
  , 132, 30, 36, 88, 60, 127, 16, 127
  , 132, 30, 36, 88, 60, 127
  , 133, 14, 127, 74, 36, 88, 60, 62
  , 133, 14, 127, 74, 36, 88, 60, 61
  , 133, 74, 36, 88, 60, 127
  , 133, 21, 36, 126, 61, 124, 61, 124, 60, 127
  , 133, 21, 36, 72, 147, 61, 124, 61, 124, 60, 127
  , 133, 21, 36, 100, 31, 88, 60, 127
  , 133, 21, 36, 72, 148, 31, 88, 60, 127
  , 134, 9, 62
  , 134, 9, 61
  , 134, 9, 29, 62
  , 134, 9, 29, 61
  , 135, 4, 62
  , 135, 4, 61
  , 135, 4, 29, 62
  , 135, 4, 29, 61
  , 136, 59, 124, 62
  , 136, 59, 124, 61
  , 137, 75, 36, 88, 60, 127
  , 139, 66, 36, 88, 60, 153
  , 153, 33, 154, 55
  , 153, 33, 154, 155, 154, 55
  , 156, 157
  , 156, 156, 157
  , 154
  , 154, 156
  , 157, 5, 88, 7, 142
  , 155, 10, 7, 142
  , 138, 29, 7, 127
  , 140, 68, 88, 62
  , 140, 68, 88, 61
  , 141, 70, 128, 158
  , 141, 70, 128, 159
  , 141, 70, 128, 158, 159
  , 158, 6, 36, 29, 60, 128
  , 159, 20, 128
  , 160, 22, 29, 36, 161, 60, 33, 162, 55
  , 94, 22, 163, 36, 161, 60, 33, 162, 55
  , 164, 29
  , 164, 164, 8, 29
  , 161
  , 161, 164
  , 162
  , 162, 165
  , 165, 166
  , 83, 166
  , 166, 167
  , 166, 166, 167
  , 167, 127
  , 167, 160
  , 163
  , 163, 29
  , 87
  , 87, 91
  , 168, 83, 0};

const int QScriptGrammar::rule_index [] = {
  0, 2, 4, 6, 8, 10, 12, 14, 16, 20,
  24, 30, 34, 38, 41, 46, 48, 51, 52, 54,
  58, 64, 66, 68, 70, 72, 74, 79, 84, 85,
  89, 91, 94, 97, 100, 105, 109, 112, 116, 118,
  122, 124, 126, 128, 131, 134, 136, 139, 142, 145,
  148, 151, 154, 157, 160, 163, 165, 169, 173, 177,
  179, 183, 187, 189, 193, 197, 201, 203, 207, 211,
  215, 219, 223, 227, 229, 233, 237, 241, 245, 249,
  251, 255, 259, 263, 267, 269, 273, 277, 281, 285,
  287, 291, 293, 297, 299, 303, 305, 309, 311, 315,
  317, 321, 323, 327, 329, 333, 335, 339, 341, 345,
  347, 353, 355, 361, 363, 367, 369, 373, 375, 377,
  379, 381, 383, 385, 387, 389, 391, 393, 395, 397,
  399, 403, 404, 406, 408, 412, 413, 415, 417, 419,
  421, 423, 425, 427, 429, 431, 433, 435, 437, 439,
  441, 443, 447, 449, 452, 453, 455, 459, 463, 465,
  467, 469, 473, 475, 479, 482, 485, 488, 489, 491,
  494, 495, 497, 499, 502, 505, 513, 519, 527, 535,
  541, 551, 562, 570, 579, 582, 585, 589, 593, 596,
  599, 603, 607, 611, 615, 621, 627, 631, 637, 639,
  642, 643, 645, 650, 654, 658, 662, 666, 670, 674,
  679, 685, 688, 697, 706, 708, 712, 713, 715, 716,
  718, 720, 722, 724, 727, 729, 731, 732, 734, 735,
  737};
#endif // QLALR_NO_QSCRIPTGRAMMAR_DEBUG_INFO

const int QScriptGrammar::action_default [] = {
  0, 63, 130, 94, 102, 98, 138, 145, 42, 114,
  144, 140, 90, 0, 141, 226, 26, 142, 143, 148,
  43, 106, 110, 31, 60, 41, 46, 25, 0, 80,
  146, 67, 223, 222, 225, 149, 0, 159, 0, 0,
  8, 0, 5, 0, 227, 2, 0, 229, 18, 0,
  0, 0, 0, 0, 3, 6, 0, 0, 132, 173,
  7, 0, 1, 0, 0, 4, 0, 0, 160, 0,
  0, 0, 150, 151, 56, 0, 139, 147, 0, 0,
  43, 62, 227, 2, 229, 45, 44, 0, 0, 0,
  58, 59, 57, 0, 228, 217, 218, 0, 215, 0,
  216, 0, 219, 220, 0, 221, 214, 224, 0, 230,
  0, 22, 24, 23, 0, 20, 0, 0, 0, 21,
  12, 61, 0, 91, 0, 0, 0, 0, 81, 0,
  0, 0, 0, 0, 0, 71, 0, 0, 0, 65,
  66, 64, 69, 73, 72, 70, 68, 83, 82, 84,
  0, 99, 0, 95, 34, 0, 0, 0, 36, 0,
  0, 35, 131, 0, 39, 37, 0, 38, 40, 174,
  175, 0, 127, 120, 118, 125, 126, 124, 123, 129,
  122, 121, 119, 128, 115, 0, 103, 0, 0, 107,
  0, 0, 111, 33, 29, 0, 0, 28, 0, 27,
  231, 189, 0, 190, 191, 192, 185, 0, 186, 187,
  188, 47, 0, 0, 0, 0, 0, 178, 179, 136,
  134, 96, 104, 100, 116, 92, 137, 0, 43, 108,
  112, 85, 74, 0, 0, 93, 0, 0, 0, 0,
  86, 0, 0, 0, 0, 0, 78, 76, 79, 77,
  75, 88, 87, 89, 0, 101, 0, 97, 0, 135,
  43, 0, 117, 132, 133, 0, 132, 0, 0, 181,
  0, 0, 0, 183, 0, 105, 0, 0, 109, 0,
  0, 113, 171, 0, 163, 172, 166, 0, 170, 0,
  132, 164, 0, 132, 0, 0, 182, 0, 0, 0,
  184, 228, 217, 0, 0, 219, 0, 213, 0, 205,
  0, 0, 0, 177, 0, 176, 153, 156, 0, 2,
  6, 7, 154, 152, 0, 19, 0, 16, 18, 10,
  0, 15, 11, 17, 14, 9, 0, 13, 53, 51,
  31, 32, 30, 55, 52, 50, 0, 193, 194, 0,
  0, 0, 196, 201, 199, 202, 0, 0, 200, 201,
  0, 197, 0, 198, 155, 204, 0, 155, 203, 0,
  206, 207, 54, 0, 155, 208, 209, 0, 0, 210,
  0, 0, 0, 211, 212, 49, 48, 0, 0, 0,
  180, 0, 0, 0, 195, 168, 161, 0, 169, 165,
  0, 167, 157, 0, 158, 162};

const int QScriptGrammar::goto_default [] = {
  28, 27, 326, 324, 110, 13, 2, 325, 109, 108,
  23, 16, 196, 154, 25, 8, 163, 20, 26, 74,
  24, 1, 31, 29, 231, 12, 225, 3, 221, 5,
  223, 4, 222, 21, 229, 22, 230, 9, 224, 220,
  261, 346, 226, 227, 34, 6, 76, 11, 14, 17,
  18, 10, 7, 30, 77, 19, 35, 72, 73, 318,
  317, 75, 397, 396, 283, 284, 399, 286, 398, 285,
  352, 356, 359, 355, 354, 375, 376, 15, 97, 104,
  93, 96, 103, 105, 32, 0};

const int QScriptGrammar::action_index [] = {
  944, 59, -83, 48, 8, -14, -83, -83, 115, -83,
  -83, -83, 213, 131, -83, -83, -83, -83, -83, -83,
  426, 35, 66, 140, 221, -83, -83, -83, 20, 346,
  -83, 200, -83, 944, -83, -83, 95, -83, 133, 498,
  -83, 865, -83, -29, -21, 5, -22, 1023, 28, 498,
  498, 498, 294, 498, -83, -83, 498, 498, 498, -83,
  -83, -35, -83, 498, 498, -83, -23, 498, -83, 498,
  32, 39, -83, -83, -83, 40, -83, -83, 498, 498,
  69, 141, 23, -83, 118, -83, -83, 498, 498, 498,
  -83, -83, -83, 29, -83, 31, 45, 3, -83, 21,
  -83, 44, 944, -83, 33, 944, -83, -83, 60, 58,
  9, -83, -83, -83, 498, -83, 119, 65, 498, -83,
  -83, 128, 498, 286, 498, 498, 498, 498, 346, 498,
  498, 498, 498, 498, 498, 104, 498, 498, 498, 46,
  61, 55, 134, 182, 197, 196, 190, 346, 278, 346,
  498, -15, 498, 56, -83, 26, 498, 786, -83, 72,
  498, -83, -83, 90, -83, -83, 498, -83, -83, -83,
  -83, 498, -83, -83, -83, -83, -83, -83, -83, -83,
  -83, -83, -83, -83, -83, 498, 42, 498, 498, 71,
  67, 498, -83, -83, -83, 498, 41, -83, 88, -83,
  -83, -83, 47, -83, -83, -83, -83, 57, -83, -83,
  -83, -83, -56, -19, 498, 92, 52, -83, -83, 570,
  -83, 75, -42, -53, -83, 211, 13, -20, 354, 36,
  53, 259, 96, 17, 498, 218, 498, 498, 498, 498,
  263, 498, 498, 498, 498, 498, 174, 181, 175, 100,
  178, 216, 237, 244, 498, -45, 498, 75, 498, -83,
  426, 498, -83, 498, 19, -28, 498, -30, 865, -83,
  498, 150, 865, -83, 498, -13, 498, 498, 24, 22,
  498, -83, 15, 84, -3, -83, -83, 498, -83, -4,
  498, -83, -16, 498, -18, 865, -83, 498, 77, 865,
  -83, -34, -25, -51, -17, 944, -40, -83, 865, -83,
  498, 94, 865, -5, 865, -83, -83, 865, -52, -7,
  12, 27, -83, -83, 79, 16, 642, -83, 14, -83,
  714, -83, -83, -83, -83, -83, 83, -83, -83, -83,
  154, -83, -83, -83, -83, -83, 43, -83, -83, 498,
  86, 7, -83, 38, -83, 34, 105, 498, -83, 0,
  6, -83, -11, -83, 865, -83, 74, 865, -83, 109,
  -83, -83, -83, 73, 865, 51, -83, 11, 18, -83,
  30, -12, 25, -83, -83, -83, -83, 498, 81, 865,
  -83, 498, 76, 865, -83, 37, -83, 125, -83, -83,
  498, -83, -83, 49, -83, -83,

  -77, -86, -86, -86, -86, -86, -86, -86, -86, -86,
  -86, -86, -86, -86, -86, -86, -86, -86, -86, -86,
  -9, -86, -86, 11, -86, -86, -86, -86, -86, -86,
  -86, -86, -86, -80, -86, -86, -86, -86, -86, 97,
  -86, -41, -86, -86, -86, -86, -86, -42, -86, 5,
  124, 112, 114, 119, -86, -86, 44, 77, 22, -86,
  -86, -86, -86, 48, 81, -86, 7, 101, -86, 90,
  -86, -86, -86, -86, -86, -86, -86, -86, 113, 115,
  -86, -86, -86, -86, -86, -86, -86, 39, 43, 53,
  -86, -86, -86, -86, -86, -86, -86, -86, -86, -86,
  -86, -86, -86, -86, -86, -51, -86, -86, -86, -86,
  -86, -86, -86, -86, 36, -86, 40, -86, 38, -86,
  -86, -86, 109, -86, 123, 89, 88, 100, -86, 37,
  148, 122, 58, 91, 80, -86, 56, 98, 104, -86,
  -86, -86, -86, -86, -86, -86, -86, -86, -86, -86,
  47, -86, 51, -86, -86, -86, 18, 16, -86, -86,
  10, -86, -86, -86, -86, -86, 14, -86, -86, -86,
  -86, 13, -86, -86, -86, -86, -86, -86, -86, -86,
  -86, -86, -86, -86, -86, 54, -86, 49, 24, -86,
  -86, 19, -86, -86, -86, 21, -86, -86, -86, -86,
  -86, -86, -86, -86, -86, -86, -86, -86, -86, -86,
  -86, -86, -86, -86, 79, -86, -86, -86, -86, 82,
  -86, -86, -86, -86, -86, -86, -86, -86, -86, -86,
  -86, -86, -86, -86, 159, -86, 144, 217, 158, 170,
  -86, 73, 70, 57, 64, 66, -86, -86, -86, -86,
  -86, -86, -86, -86, 128, -86, 131, -86, 130, -86,
  -86, 132, -86, 60, -86, -86, 62, -86, 3, -86,
  34, -86, 4, -86, 161, -86, 150, 140, -86, -86,
  138, -86, -86, -86, -86, -86, -86, 134, -86, -20,
  52, -86, -86, 50, -86, 6, -86, 35, -86, 2,
  -86, -86, -44, -86, -86, -43, -86, -86, -6, -86,
  30, -86, -3, -86, -1, -86, -86, -7, -86, -86,
  -86, -86, -86, -86, -86, -86, 45, -86, -2, -86,
  1, -86, -86, -86, -86, -86, -86, -86, -86, -86,
  -5, -86, -86, -86, -86, -86, -86, -86, -86, -4,
  -86, -86, -86, -86, -86, -65, -86, 0, -86, -59,
  -86, -86, -86, -86, 83, -86, -86, 78, -86, -86,
  -86, -86, -86, -86, -33, -47, -86, -86, -13, -86,
  -86, -86, -17, -86, -86, -86, -86, 9, -86, -29,
  -86, 8, -86, -26, -86, -86, -86, -86, -86, -86,
  15, -86, -86, -46, -86, -86};

const int QScriptGrammar::action_info [] = {
  308, 349, 302, 323, 98, 357, 254, 219, 301, 304,
  374, 314, 308, 364, 310, 307, 305, 214, 213, -24,
  200, 258, 327, 256, 333, 282, 274, 160, 297, 280,
  268, 256, 287, 266, -23, 254, 327, 185, 274, 357,
  353, 263, 295, 357, 363, 293, 282, 380, 382, 122,
  100, 374, 94, 99, 400, 158, 150, 122, 374, 381,
  98, 152, 152, 101, 120, 95, 116, 114, 387, 395,
  197, 378, 118, 185, 191, 391, 234, 102, 395, 377,
  160, 367, 160, 0, 160, 160, 78, 328, 106, 160,
  150, 160, 289, 378, 160, 78, 160, 79, 166, 78,
  160, 78, 160, 276, 348, 347, 79, 277, 205, 204,
  79, 85, 79, 218, 217, 360, 187, 160, 210, 209,
  188, 136, 86, 137, 202, 136, 0, 137, 161, 136,
  155, 137, 0, 403, 138, 329, 393, 299, 138, 160,
  87, 389, 138, 337, 199, 290, 351, 111, 111, 156,
  167, 157, 216, 87, 312, 194, 203, 201, 160, 136,
  361, 137, 207, 0, 0, 112, 112, 0, 0, 194,
  371, 370, 138, 0, 195, 0, 157, 0, 0, 0,
  0, 0, 0, 113, 113, 88, 404, 402, 195, 0,
  157, 89, 170, 169, 208, 206, 0, 0, 88, 136,
  136, 137, 137, 136, 89, 137, 136, 136, 137, 137,
  272, 0, 138, 138, 0, 136, 138, 137, 0, 138,
  138, 136, 136, 137, 137, 136, 0, 137, 138, 236,
  237, 124, 125, 87, 138, 138, 236, 237, 138, 241,
  242, 0, 0, 0, 0, 0, 0, 0, 243, 0,
  0, 244, 0, 245, 0, 0, 238, 239, 126, 127,
  241, 242, 0, 238, 239, 0, 0, 241, 242, 243,
  0, 0, 244, 0, 245, 0, 243, 0, 88, 244,
  0, 245, 241, 242, 89, 0, 241, 242, 0, 0,
  0, 243, 0, 0, 244, 243, 245, 0, 244, 0,
  245, 129, 130, 0, 124, 125, 40, 0, 0, 131,
  132, 0, 0, 133, 0, 134, 82, 0, 0, 0,
  0, 0, 0, 83, 0, 0, 0, 84, 48, 0,
  49, 126, 127, 0, 0, 0, 0, 52, 0, 0,
  0, 55, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 172, 0, 60,
  0, 62, 0, 0, 0, 0, 0, 173, 0, 129,
  130, 174, 54, 65, 42, 0, 0, 131, 132, 0,
  175, 133, 176, 134, 0, 270, 0, 0, 0, 0,
  0, 0, 0, 177, 0, 178, 85, 0, 0, 0,
  0, 0, 0, 179, 0, 0, 180, 86, 0, 0,
  0, 0, 181, 0, 0, 0, 0, 0, 182, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 172,
  0, 183, 0, 0, 0, 0, 0, 0, 0, 173,
  0, 0, 0, 174, 0, 0, 0, 0, 0, 0,
  0, 0, 175, 0, 176, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 177, 0, 178, 85, 0,
  0, 0, 0, 0, 0, 179, 0, 0, 180, 86,
  0, 0, 0, 0, 181, 0, 0, 0, 0, 0,
  182, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 183, 0, 0, 0, 0, 0, 39,
  40, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  82, 0, 0, 0, 0, 0, 0, 83, 0, 0,
  0, 84, 48, 0, 49, 0, 0, 0, 50, 0,
  51, 52, 53, 0, 0, 55, 0, 0, 0, 56,
  0, 57, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 60, 0, 62, 0, 64, 0, 67,
  0, 69, 0, 0, 0, 0, 54, 65, 42, 0,
  0, 39, 40, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 82, 0, 0, 0, 0, 0, 0, 83,
  0, 0, 0, 84, 48, 0, 49, 0, 0, 0,
  50, 0, 51, 52, 53, 0, 0, 55, 0, 0,
  0, 56, 0, 57, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 60, 0, 62, 0, 64,
  0, 67, 233, 69, 0, 0, 0, 0, 54, 65,
  42, 0, 0, 39, 40, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 82, 0, 0, 0, 0, 0,
  0, 83, 0, 0, 0, 84, 48, 0, 49, 0,
  0, 0, 50, 0, 51, 52, 53, 0, 0, 55,
  0, 0, 0, 56, 0, 57, 0, 0, 335, 0,
  0, 0, 0, 0, 0, 0, 0, 60, 0, 62,
  0, 64, 0, 67, 0, 69, 0, 0, 0, 0,
  54, 65, 42, 0, 0, 39, 40, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 82, 0, 0, 0,
  0, 0, 0, 83, 0, 0, 0, 84, 48, 0,
  49, 0, 0, 0, 50, 0, 51, 52, 53, 0,
  0, 55, 0, 0, 0, 56, 0, 57, 0, 0,
  332, 0, 0, 0, 0, 0, 0, 0, 0, 60,
  0, 62, 0, 64, 0, 67, 0, 69, 0, 0,
  0, 0, 54, 65, 42, 0, 0, 39, 40, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 82, 0,
  0, 0, 0, 0, 0, 83, 0, 0, 0, 84,
  48, 0, 49, 0, 0, 0, 50, 0, 51, 52,
  53, 0, 0, 55, 0, 0, 0, 56, 0, 57,
  0, 0, 0, 0, 0, 0, 165, 0, 0, 0,
  0, 60, 0, 62, 0, 64, 0, 67, 0, 69,
  0, 0, 0, 0, 54, 65, 42, 0, 0, 36,
  0, 0, 0, 0, 38, 0, 39, 40, 0, 41,
  0, 0, 0, 0, 0, 0, 43, 82, 0, 0,
  0, 0, 0, 0, 45, 46, 0, 0, 47, 48,
  0, 49, 0, 0, 0, 50, 0, 51, 52, 53,
  0, 0, 55, 0, 0, 0, 56, 0, 57, 0,
  0, 0, 0, 0, 58, 0, 59, 0, 0, 0,
  60, 61, 62, 63, 64, 66, 67, 68, 69, 70,
  71, 0, 0, 54, 65, 42, 37, 0, 36, 0,
  0, 0, 0, 38, 0, 39, 40, 0, 41, 0,
  0, 0, 0, 0, 0, 43, 44, 0, 0, 0,
  0, 0, 0, 45, 46, 0, 0, 47, 48, 0,
  49, 0, 0, 0, 50, 0, 51, 52, 53, 0,
  0, 55, 0, 0, 0, 56, 0, 57, 0, 0,
  0, 0, 0, 58, 0, 59, 0, 0, 0, 60,
  61, 62, 63, 64, 66, 67, 68, 69, 70, 71,
  0, 0, 54, 65, 42, 37, 0, 36, 0, 0,
  0, 0, 38, 0, 39, 40, 0, 41, 0, 0,
  0, 0, 0, 0, 43, 82, 0, 0, 0, 0,
  0, 0, 319, 46, 0, 0, 47, 48, 0, 49,
  0, 0, 0, 50, 0, 51, 52, 53, 0, 0,
  320, 0, 0, 0, 56, 0, 57, 0, -155, 0,
  0, 0, 58, 0, 59, 0, 0, 0, 321, 61,
  62, 63, 64, 66, 67, 68, 69, 70, 71, 0,
  0, 54, 65, 42, 37, 0,

  330, 350, 316, 212, 107, 366, 33, 331, 342, 358,
  336, 316, 362, 392, 388, 390, 162, 405, 394, 184,
  168, 401, 164, 159, 193, 192, 198, 264, 383, 379,
  190, 171, 384, 107, 303, 311, 306, 322, 309, 271,
  298, 313, 115, 315, 119, 291, 300, 269, 273, 117,
  296, 334, 373, 369, 80, 264, 80, 264, 90, 135,
  80, 80, 91, 344, 80, 264, 80, 264, 80, 0,
  80, 80, 92, 80, 80, 80, 151, 139, 153, 248,
  144, 80, 189, 80, 215, 186, 249, 80, 250, 0,
  80, 294, 247, 292, 80, 246, 345, 80, 80, 228,
  372, 265, 146, 267, 232, 80, 80, 80, 80, 386,
  0, 148, 147, 145, 80, 80, 211, 80, 80, 140,
  385, 80, 316, 149, 340, 141, 80, 316, 341, 80,
  80, 339, 80, 81, 123, 121, 80, 368, 343, 80,
  80, 80, 365, 338, 143, 80, 128, 260, 80, 260,
  232, 260, 232, 232, 232, 260, 232, 260, 255, 257,
  232, 80, 232, 0, 0, 80, 232, 80, 240, 259,
  142, 262, 232, 288, 0, 80, 80, 281, 80, 279,
  232, 232, 252, 232, 278, 235, 0, 80, 0, 0,
  0, 0, 232, 275, 253, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 80, 0, 0, 0, 0, 232,
  0, 251, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0};

const int QScriptGrammar::action_check [] = {
  7, 36, 36, 55, 29, 5, 48, 36, 29, 60,
  33, 16, 7, 7, 36, 55, 33, 36, 74, 7,
  0, 8, 8, 76, 8, 29, 2, 8, 31, 7,
  60, 76, 17, 61, 7, 48, 8, 2, 2, 5,
  33, 61, 60, 5, 55, 61, 29, 36, 60, 1,
  29, 33, 29, 8, 17, 29, 48, 1, 33, 29,
  29, 76, 76, 60, 55, 36, 8, 7, 36, 29,
  29, 20, 7, 2, 7, 36, 1, 33, 29, 6,
  8, 7, 8, -1, 8, 8, 40, 8, 55, 8,
  48, 8, 8, 20, 8, 40, 8, 51, 8, 40,
  8, 40, 8, 50, 61, 62, 51, 54, 61, 62,
  51, 42, 51, 61, 62, 10, 50, 8, 61, 62,
  54, 25, 53, 27, 29, 25, -1, 27, 56, 25,
  15, 27, -1, 8, 38, 56, 60, 60, 38, 8,
  12, 60, 38, 60, 56, 61, 60, 29, 29, 34,
  60, 36, 60, 12, 60, 15, 61, 62, 8, 25,
  55, 27, 29, -1, -1, 47, 47, -1, -1, 15,
  61, 62, 38, -1, 34, -1, 36, -1, -1, -1,
  -1, -1, -1, 65, 65, 57, 61, 62, 34, -1,
  36, 63, 61, 62, 61, 62, -1, -1, 57, 25,
  25, 27, 27, 25, 63, 27, 25, 25, 27, 27,
  60, -1, 38, 38, -1, 25, 38, 27, -1, 38,
  38, 25, 25, 27, 27, 25, -1, 27, 38, 18,
  19, 18, 19, 12, 38, 38, 18, 19, 38, 23,
  24, -1, -1, -1, -1, -1, -1, -1, 32, -1,
  -1, 35, -1, 37, -1, -1, 45, 46, 45, 46,
  23, 24, -1, 45, 46, -1, -1, 23, 24, 32,
  -1, -1, 35, -1, 37, -1, 32, -1, 57, 35,
  -1, 37, 23, 24, 63, -1, 23, 24, -1, -1,
  -1, 32, -1, -1, 35, 32, 37, -1, 35, -1,
  37, 23, 24, -1, 18, 19, 12, -1, -1, 31,
  32, -1, -1, 35, -1, 37, 22, -1, -1, -1,
  -1, -1, -1, 29, -1, -1, -1, 33, 34, -1,
  36, 45, 46, -1, -1, -1, -1, 43, -1, -1,
  -1, 47, -1, -1, -1, -1, -1, -1, -1, -1,
  -1, -1, -1, -1, -1, -1, -1, 3, -1, 65,
  -1, 67, -1, -1, -1, -1, -1, 13, -1, 23,
  24, 17, 78, 79, 80, -1, -1, 31, 32, -1,
  26, 35, 28, 37, -1, 31, -1, -1, -1, -1,
  -1, -1, -1, 39, -1, 41, 42, -1, -1, -1,
  -1, -1, -1, 49, -1, -1, 52, 53, -1, -1,
  -1, -1, 58, -1, -1, -1, -1, -1, 64, -1,
  -1, -1, -1, -1, -1, -1, -1, -1, -1, 3,
  -1, 77, -1, -1, -1, -1, -1, -1, -1, 13,
  -1, -1, -1, 17, -1, -1, -1, -1, -1, -1,
  -1, -1, 26, -1, 28, -1, -1, -1, -1, -1,
  -1, -1, -1, -1, -1, 39, -1, 41, 42, -1,
  -1, -1, -1, -1, -1, 49, -1, -1, 52, 53,
  -1, -1, -1, -1, 58, -1, -1, -1, -1, -1,
  64, -1, -1, -1, -1, -1, -1, -1, -1, -1,
  -1, -1, -1, 77, -1, -1, -1, -1, -1, 11,
  12, -1, -1, -1, -1, -1, -1, -1, -1, -1,
  22, -1, -1, -1, -1, -1, -1, 29, -1, -1,
  -1, 33, 34, -1, 36, -1, -1, -1, 40, -1,
  42, 43, 44, -1, -1, 47, -1, -1, -1, 51,
  -1, 53, -1, -1, -1, -1, -1, -1, -1, -1,
  -1, -1, -1, 65, -1, 67, -1, 69, -1, 71,
  -1, 73, -1, -1, -1, -1, 78, 79, 80, -1,
  -1, 11, 12, -1, -1, -1, -1, -1, -1, -1,
  -1, -1, 22, -1, -1, -1, -1, -1, -1, 29,
  -1, -1, -1, 33, 34, -1, 36, -1, -1, -1,
  40, -1, 42, 43, 44, -1, -1, 47, -1, -1,
  -1, 51, -1, 53, -1, -1, -1, -1, -1, -1,
  -1, -1, -1, -1, -1, 65, -1, 67, -1, 69,
  -1, 71, 72, 73, -1, -1, -1, -1, 78, 79,
  80, -1, -1, 11, 12, -1, -1, -1, -1, -1,
  -1, -1, -1, -1, 22, -1, -1, -1, -1, -1,
  -1, 29, -1, -1, -1, 33, 34, -1, 36, -1,
  -1, -1, 40, -1, 42, 43, 44, -1, -1, 47,
  -1, -1, -1, 51, -1, 53, -1, -1, 56, -1,
  -1, -1, -1, -1, -1, -1, -1, 65, -1, 67,
  -1, 69, -1, 71, -1, 73, -1, -1, -1, -1,
  78, 79, 80, -1, -1, 11, 12, -1, -1, -1,
  -1, -1, -1, -1, -1, -1, 22, -1, -1, -1,
  -1, -1, -1, 29, -1, -1, -1, 33, 34, -1,
  36, -1, -1, -1, 40, -1, 42, 43, 44, -1,
  -1, 47, -1, -1, -1, 51, -1, 53, -1, -1,
  56, -1, -1, -1, -1, -1, -1, -1, -1, 65,
  -1, 67, -1, 69, -1, 71, -1, 73, -1, -1,
  -1, -1, 78, 79, 80, -1, -1, 11, 12, -1,
  -1, -1, -1, -1, -1, -1, -1, -1, 22, -1,
  -1, -1, -1, -1, -1, 29, -1, -1, -1, 33,
  34, -1, 36, -1, -1, -1, 40, -1, 42, 43,
  44, -1, -1, 47, -1, -1, -1, 51, -1, 53,
  -1, -1, -1, -1, -1, -1, 60, -1, -1, -1,
  -1, 65, -1, 67, -1, 69, -1, 71, -1, 73,
  -1, -1, -1, -1, 78, 79, 80, -1, -1, 4,
  -1, -1, -1, -1, 9, -1, 11, 12, -1, 14,
  -1, -1, -1, -1, -1, -1, 21, 22, -1, -1,
  -1, -1, -1, -1, 29, 30, -1, -1, 33, 34,
  -1, 36, -1, -1, -1, 40, -1, 42, 43, 44,
  -1, -1, 47, -1, -1, -1, 51, -1, 53, -1,
  -1, -1, -1, -1, 59, -1, 61, -1, -1, -1,
  65, 66, 67, 68, 69, 70, 71, 72, 73, 74,
  75, -1, -1, 78, 79, 80, 81, -1, 4, -1,
  -1, -1, -1, 9, -1, 11, 12, -1, 14, -1,
  -1, -1, -1, -1, -1, 21, 22, -1, -1, -1,
  -1, -1, -1, 29, 30, -1, -1, 33, 34, -1,
  36, -1, -1, -1, 40, -1, 42, 43, 44, -1,
  -1, 47, -1, -1, -1, 51, -1, 53, -1, -1,
  -1, -1, -1, 59, -1, 61, -1, -1, -1, 65,
  66, 67, 68, 69, 70, 71, 72, 73, 74, 75,
  -1, -1, 78, 79, 80, 81, -1, 4, -1, -1,
  -1, -1, 9, -1, 11, 12, -1, 14, -1, -1,
  -1, -1, -1, -1, 21, 22, -1, -1, -1, -1,
  -1, -1, 29, 30, -1, -1, 33, 34, -1, 36,
  -1, -1, -1, 40, -1, 42, 43, 44, -1, -1,
  47, -1, -1, -1, 51, -1, 53, -1, 55, -1,
  -1, -1, 59, -1, 61, -1, -1, -1, 65, 66,
  67, 68, 69, 70, 71, 72, 73, 74, 75, -1,
  -1, 78, 79, 80, 81, -1,

  2, 5, 44, 44, 84, 5, 83, 6, 13, 74,
  5, 44, 71, 5, 5, 44, 6, 63, 44, 6,
  6, 6, 6, 5, 13, 6, 5, 5, 45, 76,
  6, 40, 45, 84, 78, 5, 79, 44, 44, 5,
  5, 44, 6, 44, 6, 65, 44, 44, 44, 9,
  44, 6, 45, 5, 17, 5, 17, 5, 19, 22,
  17, 17, 19, 19, 17, 5, 17, 5, 17, -1,
  17, 17, 19, 17, 17, 17, 29, 21, 27, 22,
  22, 17, 33, 17, 5, 31, 22, 17, 22, -1,
  17, 41, 22, 41, 17, 22, 19, 17, 17, 17,
  19, 41, 22, 41, 22, 17, 17, 17, 17, 19,
  -1, 23, 23, 22, 17, 17, 19, 17, 17, 21,
  19, 17, 44, 23, 10, 21, 17, 44, 14, 17,
  17, 19, 17, 20, 25, 20, 17, 59, 19, 17,
  17, 17, 59, 19, 22, 17, 23, 17, 17, 17,
  22, 17, 22, 22, 22, 17, 22, 17, 30, 28,
  22, 17, 22, -1, -1, 17, 22, 17, 24, 39,
  22, 39, 22, 39, -1, 17, 17, 39, 17, 39,
  22, 22, 24, 22, 34, 26, -1, 17, -1, -1,
  -1, -1, 22, 32, 24, -1, -1, -1, -1, -1,
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
  -1, -1, -1, -1, 17, -1, -1, -1, -1, 22,
  -1, 24, -1, -1, -1, -1, -1, -1, -1, -1,
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
  -1, -1, -1};

QT_END_NAMESPACE

#endif // QT_NO_SCRIPT
