/****************************************************************************
**
** Copyright (C) 1992-2006 TROLLTECH ASA. All rights reserved.
**
** This file is part of the Phone Edition of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** In addition, as a special exception, Trolltech gives you certain
** additional rights. These rights are described in the Trolltech GPL
** Exception version 1.0, which can be found at
** http://www.trolltech.com/products/qt/gplexception/ and in the file
** GPL_EXCEPTION.txt in this package.
**
** In addition, as a special exception, Trolltech, as the sole copyright
** holder for Qt Designer, grants users of the Qt/Eclipse Integration
** plug-in the right for the Qt/Eclipse Integration to link to
** functionality provided by Qt Designer and its related libraries.
**
** Trolltech reserves all rights not expressly granted herein.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef X11KEYFAKER_H
#define X11KEYFAKER_H

#include <QObject>
#include <QX11Info>
#include <qnamespace.h>

QT_BEGIN_NAMESPACE

class X11KeyFaker : public QObject
{
    Q_OBJECT
public:
    X11KeyFaker(const QString& displayName, QObject *parent = 0);
    ~X11KeyFaker();

    bool isConnected() const { return dpy != 0; }

    void sendKeyEvent(int qtCode, bool isPress);

private slots:
    void connect();
    void readyRead();

signals:
    void connected();
    void couldNotConnect();

private:
    QString displayName;
    Display *dpy;
    int retryCount;
    int shiftKeycode;
    int modeSwitchKeycode;
    int modifiers;
};

QT_END_NAMESPACE

#endif
