/****************************************************************************
**
** Copyright (C) 1992-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the tools applications of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** In addition, as a special exception, Trolltech gives you certain
** additional rights. These rights are described in the Trolltech GPL
** Exception version 1.0, which can be found at
** http://www.trolltech.com/products/qt/gplexception/ and in the file
** GPL_EXCEPTION.txt in this package.
**
** In addition, as a special exception, Trolltech, as the sole copyright
** holder for Qt Designer, grants users of the Qt/Eclipse Integration
** plug-in the right for the Qt/Eclipse Integration to link to
** functionality provided by Qt Designer and its related libraries.
**
** Trolltech reserves all rights not expressly granted herein.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/
#include <QApplication>
#include <QDebug>
#include <QFile>

#include "codegenerator.h"
using namespace CodeGenerator;

const Item argument = "arg" + Counter();
const Item argumentRef = "&arg" + Counter();
const Item argumentType  = "Arg" + Counter();
const Item constArgumentType  = "const Arg" + Counter();
const Item parameterType  = "Param" + Counter();

Group argumentTypes(argumentType);          // expands to ",Arg1, Arg2, ..."
Group argumentTypesNoPrefix(argumentType);  // expands to "Arg1, Arg2, ..."
Group arguments(argument);                  // expands to ",arg1, arg2, ..."
Group argumentsNoPrefix(argument);          // expands to "arg1, arg2, ..."
Group parameterTypes(parameterType);        // expands to ",Param1, Param2, ..."
Group parameterTypesNoPrefix(parameterType); // expands to "Param1, Param2, ..."
Group typenameTypes("typename " + parameterType + ", typename " + argumentType); // expands to " ,typename Param1, typename Arg1, ..."
Group types(parameterType + ", " + argumentType); // expands to ", Param1, Arg1, ..."
Group functionParameters(constArgumentType + " " + argumentRef);
Group functionParametersNoPrefix(constArgumentType + " " + argumentRef);
Group typenameArgumentTypes("typename " + argumentType);

Group initializers(argument + "(" + argument + ")");
Group classData(argumentType +" "  + argument + ";");
Group arglist(argument);
Group typeList(argumentTypes);

void init()
{
    argumentTypes.setPrefix(", ");
    arguments.setPrefix(", ");
    parameterTypes.setPrefix(", ");
    typenameTypes.setPrefix(", ");
    types.setPrefix(", ");
    functionParameters.setPrefix(", ");
    typenameArgumentTypes.setPrefix(", ");

    initializers.setPrefix(", ");
    classData.setSeparator(" ");
    arglist.setPrefix(", ");
    typeList.setPrefix(", ");
}


Item Line(Item item)
{
    return item + "\n";
}

Item generateFunctors(Item structName, Item callLine)
{
    return 
    Line("template <typename T, typename FunctionPointer" +  typenameArgumentTypes + ">") +
    Line("struct " + structName +  Counter()) +
    Line("{") +
    Line("    typedef T result_type;") +
    Line("    inline " + structName + Counter() + "(FunctionPointer function)") +
    Line("      : function(function) {}") +
    Line("    inline " + callLine + "function(" + argumentsNoPrefix + "); }") +
    Line("    FunctionPointer function;") +
    Line("};") +
    Line("");
}


Item generateFunctorSelector(Item classNameBase)
{
    return 
    Line("template <typename T, typename FunctionPointer" + typenameArgumentTypes + ">") +
    Line("struct Select" + classNameBase + Counter()) +
    Line("{") +
    Line("    typedef typename SelectSpecialization<T>::template ") +
    Line("        Type<" + classNameBase + Counter() + "    <T, FunctionPointer" + argumentTypes + ">,") +
    Line("             Void" + classNameBase + Counter() + "<T, FunctionPointer" + argumentTypes + "> >::type type;") +
    Line("};") +
    Line("");
}

Item generateCreateFunctor()
{
    return 
    Line("template <typename T" + typenameArgumentTypes  + ">") +
    Line("inline typename SelectFunctor" + Counter() + "<T, T(*)(" + argumentTypesNoPrefix + ")" + argumentTypes + ">::type createFunctor(T (*fn)(" + argumentTypesNoPrefix + "))") +
    Line("{") + 
    Line("    return QT_TYPENAME SelectFunctor" + Counter() + "<T, T(*)(" + argumentTypesNoPrefix + ")" + argumentTypes + ">::type(fn);") + 
    Line("}") + 
    Line("");
}

Item generateMemberFunctors(Item structName, Item object, Item function, Item callLine)
{
    return 
    Line("template <typename T, typename Class" +  typenameArgumentTypes + ">") +
    Line("struct " + structName +  Counter()) +
    Line("{") +
    Line("    typedef T result_type;") +
    Line("    inline " + structName + Counter() + "(" + object + ", " + function + ")") +
    Line("      : object(object), fn(fn) {}") +
    Line("    inline " + callLine + ";") +
    Line("    " + object +";") +
    Line("    " + function + ";") +
    Line("};") +
    Line("");
}

Item generateMemberFunctorSelector(Item classNameBase)
{
    return 
    Line("template <typename T, typename Class" + typenameArgumentTypes + ">") +
    Line("struct Select" + classNameBase + Counter()) +
    Line("{") +
    Line("    typedef typename SelectSpecialization<T>::template ") +
    Line("        Type<" + classNameBase + Counter() + "    <T, Class" + argumentTypes + ">,") +
    Line("             Void" + classNameBase + Counter() + "<T, Class" + argumentTypes + "> >::type type;") +
    Line("};") +
    Line("");
}

Item generateCreateFunctorMemberFunctions(Item classNameBase, Item object, Item function /*Item constFunction, Item objectArgument, Item objectMember, Item callLine*/)
{

    return
    // member functions by pointer
    Line("template <typename T, typename Class" + typenameArgumentTypes + ">") +
    Line("inline typename Select" + classNameBase + Counter() + "<T, Class" + argumentTypes + ">::type createFunctor("+ object + ", " + function + ")") +  
    Line("{") +
    Line("    return QT_TYPENAME Select"+ classNameBase + Counter() + "<T, Class" + argumentTypes + ">::type(object, fn);") +
    Line("}");
}

Item generateCreateFunctor(int repeats)
{
    Repeater main =

    generateFunctors(Item("Functor"), Item("T operator()("+ functionParametersNoPrefix +") { return ")) +
    generateFunctors(Item("VoidFunctor"), Item("void operator()("+ functionParametersNoPrefix +") { ")) +
    generateFunctorSelector("Functor") +
    generateCreateFunctor() +

    generateMemberFunctors(Item("MemberFunctor"),     Item("Class *object"), Item("T (Class::*fn)(" + argumentTypesNoPrefix + ")"), Item("T operator()("+ functionParametersNoPrefix +") { return (object->*fn)(" + argumentsNoPrefix + "); }")) +
    generateMemberFunctors(Item("VoidMemberFunctor"), Item("Class *object"), Item("T (Class::*fn)(" + argumentTypesNoPrefix + ")"), Item("void operator()("+ functionParametersNoPrefix +") { (object->*fn)(" + argumentsNoPrefix + "); }")) +
    generateMemberFunctorSelector("MemberFunctor") +
    generateCreateFunctorMemberFunctions(Item("MemberFunctor"), Item("Class *object"), Item("T (Class::*fn)(" + argumentTypesNoPrefix + ")"));
    main.setRepeatCount(repeats);
    return main;
}

void writeFile(QString fileName, QByteArray contents)
{
    QFile runFile(fileName);
    if (runFile.open(QIODevice::WriteOnly) == false) {
        qDebug() << "Write to" << fileName << "failed";
        return;
    }

    runFile.write(contents);
    runFile.close();
    qDebug() << "Write to" << fileName << "Ok";
}

int main()
{
    const int repeats = 5;
    init();

    Item run =  (
                       Line("// Generated code, do not edit! Use generator at tools/qtconcurrent/generatecreatefunctor/") +
                       Line("#ifndef QTCONCURRENT_CREATEFUNCTOR_H") +
                       Line("#define QTCONCURRENT_CREATEFUNCTOR_H") +
                       Line("") +
                       Line("#include <QtCore/qtconcurrentcompilertest.h>") +
                       Line("#include <QtCore/qtconcurrentrunbase.h>") +
                       Line("") +
                       Line("QT_BEGIN_HEADER") +
                       Line("QT_BEGIN_NAMESPACE") +
                       Line("") +
                       Line("QT_MODULE(Core)") +
                       Line("") +
                       Line("namespace QtConcurrent {") +
                       Line("") +
                       generateCreateFunctor(repeats) +
                       Line("} //namespace QtConcurrent") +
                       Line("") +
                       Line("QT_END_NAMESPACE") +
                       Line("QT_END_HEADER") +
                       Line("") +
                       Line("#endif")
                      );

    writeFile("../../../src/corelib/concurrent/qtconcurrentcreatefunctor.h", run.generate());
}


