/****************************************************************************
**
** Copyright (C) 2007-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the Qt Assistant of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** In addition, as a special exception, Trolltech gives you certain
** additional rights. These rights are described in the Trolltech GPL
** Exception version 1.0, which can be found at
** http://www.trolltech.com/products/qt/gplexception/ and in the file
** GPL_EXCEPTION.txt in this package.
**
** In addition, as a special exception, Trolltech, as the sole copyright
** holder for Qt Designer, grants users of the Qt/Eclipse Integration
** plug-in the right for the Qt/Eclipse Integration to link to
** functionality provided by Qt Designer and its related libraries.
**
** Trolltech reserves all rights not expressly granted herein.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "bookmarkdialog.h"
#include "bookmarkwidget.h"

#include <QtGui/QFrame>
#include <QtGui/QLabel>
#include <QtGui/QLayout>
#include <QtGui/QLineEdit>
#include <QtGui/QComboBox>
#include <QtGui/QToolButton>
#include <QtGui/QPushButton>
#include <QtGui/QDialogButtonBox>

#include <QtHelp/QHelpEngine>

QT_BEGIN_NAMESPACE

BookmarkDialog::BookmarkDialog(QHelpEngine *engine, const QString &title, 
                               const QString &url, QWidget *parent)
    : QDialog(parent)
    , m_url(url)
    , m_title(title)
    , helpEngine(engine)
    , bookmarkWidget(0)
{
    bookmarkWidget = new BookmarkWidget(this, true);
    bookmarkWidget->setBookmarks(engine->customValue(QLatin1String("Bookmarks")).toByteArray());
    bookmarkWidget->setVisible(false);

    setWindowTitle(tr("Add Bookmark"));

#ifdef Q_OS_MAC
    QSize size(500, 154);
#else
    QSize size(500, 125);
#endif
    size = size.expandedTo(minimumSizeHint());
    setMinimumSize(size);
    resize(size);

    QVBoxLayout *vboxLayout = new QVBoxLayout(this);

    QGridLayout *gridLayout = new QGridLayout();
    QLabel *label = new QLabel(this);
    label->setText(tr("Bookmark:"));
    gridLayout->addWidget(label, 0, 0);
    bookmarkEdit = new QLineEdit(this);
    bookmarkEdit->setText(title);
    gridLayout->addWidget(bookmarkEdit, 0, 1);
    connect(bookmarkEdit, SIGNAL(textChanged(const QString&)), 
        this, SLOT(textChanged(const QString&)));

    label = new QLabel(this);
    label->setText(tr("Add in Folder:"));
    gridLayout->addWidget(label, 1, 0);
    bookmarkFolders = new QComboBox(this);
    bookmarkFolders->addItems(bookmarkWidget->bookmarkFolders());
    gridLayout->addWidget(bookmarkFolders, 1, 1);
    connect(bookmarkFolders, SIGNAL(currentIndexChanged(const QString&)), 
        bookmarkWidget, SLOT(selectBookmarkFolder(const QString&)));
    vboxLayout->addLayout(gridLayout);

    QHBoxLayout *hboxLayout = new QHBoxLayout();
    toolButton = new QToolButton(this);
    toolButton->setText(QLatin1String("+"));
    toolButton->setMinimumSize(25, 20);
    hboxLayout->addWidget(toolButton);
    QFrame *line = new QFrame(this);
    line->setFrameStyle(QFrame::HLine);
    hboxLayout->addWidget(line);

    connect(toolButton, SIGNAL(clicked()), this, SLOT(toolButtonClicked()));

    vboxLayout->addLayout(hboxLayout);
    vboxLayout->addWidget(bookmarkWidget);

    hboxLayout = new QHBoxLayout();

    newFolderButton = new QPushButton(tr("New Folder"), this);
    hboxLayout->addWidget(newFolderButton);
    newFolderButton->hide();
    connect(newFolderButton, SIGNAL(clicked()), this, SLOT(addNewFolder()));

    QSpacerItem *spacer = new QSpacerItem(40, 20, QSizePolicy::Expanding, QSizePolicy::Minimum);
    hboxLayout->addItem(spacer);

    buttonBox = new QDialogButtonBox(this);
    buttonBox->setOrientation(Qt::Horizontal);
    buttonBox->setStandardButtons(QDialogButtonBox::Cancel|QDialogButtonBox::Ok);
    buttonBox->button(QDialogButtonBox::Ok)->setEnabled(!title.isEmpty());
    buttonBox->button(QDialogButtonBox::Ok)->setDefault(true);
    hboxLayout->addWidget(buttonBox);

    connect(buttonBox, SIGNAL(accepted()), this, SLOT(addAccepted()));
    connect(buttonBox, SIGNAL(rejected()), this, SLOT(reject()));

    vboxLayout->addLayout(hboxLayout);

    connect(bookmarkWidget, SIGNAL(currentItemChanged(const QString&)),
        this, SLOT(currentItemChanged(const QString&)));
}

BookmarkDialog::~BookmarkDialog()
{
    // nothing todo
}

void BookmarkDialog::addAccepted()
{
    bookmarkWidget->addNewBookmark(bookmarkEdit->text(), m_url);
    helpEngine->setCustomValue(QLatin1String("Bookmarks"), bookmarkWidget->bookmarks());
    accept();
}

void BookmarkDialog::addNewFolder()
{
    bookmarkWidget->addNewFolder(QLatin1String(""));
}

void BookmarkDialog::toolButtonClicked()
{
    if (bookmarkWidget->isHidden()) {
        bookmarkWidget->show();
        newFolderButton->show();
        resize(QSize(width(), 400));
        toolButton->setText(QLatin1String("-"));
    } else {
        bookmarkWidget->hide();
        newFolderButton->hide();
        resize(width(), minimumHeight());
        toolButton->setText(QLatin1String("+"));
    }
    buttonBox->button(QDialogButtonBox::Ok)->setDefault(true);
}

void BookmarkDialog::textChanged(const QString &text)
{
    buttonBox->button(QDialogButtonBox::Ok)->setEnabled(!text.isEmpty());
}

void BookmarkDialog::currentItemChanged(const QString &title)
{
    QString name = title;
    if (name.isEmpty())
        name = tr("Bookmarks");

    QString current = bookmarkFolders->currentText();
    QStringList list = bookmarkWidget->bookmarkFolders();
    if (list.contains(name) && name != current) {
        bookmarkFolders->clear();
        bookmarkFolders->addItems(list);
        bookmarkFolders->setCurrentIndex(bookmarkFolders->findText(name));
    }
}

QT_END_NAMESPACE
