/****************************************************************************
**
** Copyright (C) 2005-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the QtCore module of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** In addition, as a special exception, Trolltech gives you certain
** additional rights. These rights are described in the Trolltech GPL
** Exception version 1.0, which can be found at
** http://www.trolltech.com/products/qt/gplexception/ and in the file
** GPL_EXCEPTION.txt in this package.
**
** In addition, as a special exception, Trolltech, as the sole copyright
** holder for Qt Designer, grants users of the Qt/Eclipse Integration
** plug-in the right for the Qt/Eclipse Integration to link to
** functionality provided by Qt Designer and its related libraries.
**
** Trolltech reserves all rights not expressly granted herein.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "qtconcurrentexception.h"

#ifndef QT_NO_CONCURRENT
#ifndef QT_NO_EXCEPTIONS

QT_BEGIN_NAMESPACE

namespace QtConcurrent
{

void Exception::raise() const
{
    Exception e = *this;
    throw e;
}

Exception *Exception::clone() const
{
    return new Exception(*this);
}

void UnhandledException::raise() const
{
    UnhandledException e = *this;
    throw e;
}

Exception *UnhandledException::clone() const
{
    return new UnhandledException(*this);
}

namespace internal {

class Base
{
public:
    Base(Exception *exception)
    : exception(exception), refCount(1), hasThrown(false) { }
    ~Base() { delete exception; }

    Exception *exception;
    QAtomicInt refCount;
    bool hasThrown;
};

ExceptionHolder::ExceptionHolder(Exception *exception)
: base(new Base(exception)) {}

ExceptionHolder::ExceptionHolder(const ExceptionHolder &other)
: base(other.base)
{
    base->refCount.ref();
}

void ExceptionHolder::operator=(const ExceptionHolder &other)
{
    if (base == other.base)
        return;

    if (base->refCount.deref() == false)
        delete base;

    base = other.base;
    base->refCount.ref();
}

ExceptionHolder::~ExceptionHolder()
{
    if (base->refCount.deref() == 0)
        delete base;
}

Exception *ExceptionHolder::exception() const
{
    return base->exception;
}

void ExceptionStore::setException(const Exception &e)
{
    if (hasException() == false)
        exceptionHolder = ExceptionHolder(e.clone());
}

bool ExceptionStore::hasException() const
{
    return (exceptionHolder.exception() != 0);
}

ExceptionHolder ExceptionStore::exception()
{
    return exceptionHolder;
}

void ExceptionStore::throwPossibleException()
{
    if (hasException() && std::uncaught_exception() == false) {
        exceptionHolder.base->hasThrown = true;
        exceptionHolder.exception()->raise();
    }
}

bool ExceptionStore::hasThrown() const { return exceptionHolder.base->hasThrown; }

} // namespace internal
} // namespace QtConcurrent

QT_END_NAMESPACE

#endif // QT_NO_EXCEPTIONS
#endif // QT_NO_CONCURRENT
