/*
 * This file is part of the DOM implementation for KDE.
 *
 * Copyright (C) 2003 Lars Knoll (knoll@kde.org)
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

/* This file is mostly data generated by flex. Unfortunately flex
   can't handle 16bit strings directly, so we just copy the part of
   the code we need and modify it to our needs.

   Most of the defines below are to make sure we can easily use the
   flex generated code, using as little editing as possible.

   The flex syntax to generate the lexer are more or less directly
   copied from the CSS2.1 specs, with some fixes for comments and
   the important symbol.

   To regenerate, run flex on tokenizer.flex. After this, copy the
   data tables and the YY_DECL method over to this file. Remove the
   init code from YY_DECL and change the YY_END_OF_BUFFER to only call
   yyterminate().

*/

// --------- begin generated code -------------------


#include "CSSGrammar.h"

#define INITIAL 0
#define mediaquery 1

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L
#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t;
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */
#define YY_NUM_RULES 57
#define YY_END_OF_BUFFER 58
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[368] =
    {   0,
        0,    0,    0,    0,   58,   56,    2,    2,   56,   56,
       56,   56,   56,   56,   56,   56,   56,   46,   56,   56,
       56,   56,   14,   14,   14,   56,   56,   55,   14,   14,
       14,   54,    2,    0,    0,    0,   13,    0,    0,    0,
        0,   16,   16,    8,    0,    0,    9,    0,    0,   14,
       47,    0,   45,    0,    0,   46,    0,   44,   44,   44,
       44,   44,   44,   44,   44,   44,   44,   44,   44,   41,
        0,    0,    0,    0,    0,    0,    0,    0,   14,   14,
        7,   51,   14,    0,   14,    0,   14,    6,    5,   14,
       14,   14,    0,    0,    0,   13,    0,    0,    0,   16,

       16,   16,    0,   16,    0,    0,   13,    0,    0,    4,
        0,    0,   44,   44,   44,    0,   44,   32,   44,   28,
       30,   44,   42,   34,   44,   33,   40,   36,   35,   31,
       44,    0,    0,    0,    0,    0,    0,    0,    0,   14,
       14,   14,   14,   52,   52,   14,   12,   10,   14,    0,
        0,    0,   15,   16,   16,   16,   15,    0,    0,    0,
        1,   44,   44,   44,   44,   37,   44,   43,   38,    3,
        0,    0,    0,    0,    0,    0,    0,   14,   14,   48,
        0,   52,   52,   52,   51,   11,    0,    0,    0,   16,
       16,   16,    0,    0,    0,   44,   44,   44,   39,    0,

        0,    0,    0,    0,    0,   18,   14,   14,   53,   52,
       52,   52,   52,    0,    0,    0,    0,   50,    0,    0,
        0,    0,   16,   16,   16,    0,   44,   44,   29,    0,
        0,    0,    0,   19,    0,   14,   14,   53,   52,   52,
       52,   52,   52,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   50,    0,    0,    0,    0,   15,   16,   16,
       15,    0,   44,   44,    0,    0,    0,   17,    0,   14,
       14,   53,   52,   52,   52,   52,   52,   52,    0,   49,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,   16,   16,    0,   44,   44,    0,   21,

        0,    0,   14,   53,   52,   52,   52,   52,   52,   52,
       52,    0,   49,    0,    0,    0,   49,    0,    0,    0,
        0,   16,   44,    0,    0,    0,   53,    0,    0,    0,
       27,    0,    0,    0,    0,   20,   22,   53,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,   23,    0,   24,    0,
       25,    0,    0,    0,    0,   26,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    4,    5,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    6,    7,    8,    9,   10,   11,   12,   13,   14,
       15,   16,   17,   12,   18,   19,   20,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   12,   22,   23,
       24,   25,   26,   27,   31,   32,   33,   34,   35,   36,
       37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
       47,   48,   49,   50,   51,   52,   53,   54,   55,   56,
       12,   28,   12,   29,   30,   12,   31,   32,   33,   34,

       35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
       45,   46,   47,   48,   49,   50,   51,   52,   53,   54,
       55,   56,   57,   58,   12,   59,    1,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,

       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60
    } ;

static yyconst flex_int32_t yy_meta[61] =
    {   0,
        1,    2,    3,    3,    3,    4,    4,    4,    4,    4,
        4,    4,    4,    5,    4,    4,    4,    6,    4,    4,
        7,    4,    4,    4,    4,    8,    4,    9,    4,    9,
       10,   10,   10,   10,   10,   10,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    4,    4,    4,    9
    } ;

static yyconst flex_int16_t yy_base[398] =
    {   0,
        0,    0,   39,   41,  906, 1814,   62,   71,   76,   61,
       69,  881,   78,  880,   81,  878,  882,  105,  890,   74,
      141,  871,   80,  150,  152,  864,  863, 1814,  153,  154,
      157, 1814,  125,  184,  843,  104, 1814,  222,   93,  171,
      177,  857,  200, 1814,  106,  257, 1814,  859,  248,  156,
       74,  861,  862,  844,  850,    0,  265,  163,  842,  151,
      187,  186,  135,  188,  219,  210,  223,  274,   94,  833,
      841,  805,  819,  811,  793,  800,  803,  783,  259,  327,
     1814, 1814,  280,  282,  292,  318,  281, 1814, 1814,  291,
      307,  298,  767,  319,  209,  211,  362,  397,  353,  784,

      432,  781,  388,  423,  239,  236,  343,  467,  502, 1814,
      792,  225,  779,  537,  778,  458,  218,  764,   34,  763,
      762,  240,  742,  741,  248,  740,  737,  736,  735,  734,
      309,  730,  712,  712,  698,  694,  698,  687,  691,  493,
      363,  572,  364,  320,  701,  389,  398,  399,  432,  681,
      433,  528,  563,  579,  697,  614,  605,  434,  621,  695,
     1814,  630,  682,  665,  341,  667,  345,  657,  656, 1814,
      651,  634,  631,  633,  637,  640,  639,  656,  672, 1814,
      681,  354,  647,  646,  716,  468,  584,  702,  718,  724,
      740,  746,  762,  615,  388,  768,  784,  469,  602,  587,

      578,  583,  543,  559,  539, 1814,  790,  806,  812,  388,
      559,  530,  529,  847,  861,  503,  504, 1814,  888,  504,
      847,  879,  896,  904,  912,  920,  928,  936,  525,  512,
      515,  486,  471, 1814,  474,  944,  952,  960,  389,  493,
      492,  490,  487,  542,  558,  577,  995,  539, 1030, 1009,
     1042, 1069, 1083, 1110, 1145,  479, 1069, 1814, 1101, 1136,
      481, 1153, 1161, 1169,  458,  436,  454, 1814,  453, 1177,
     1185, 1193,  422,  457,  455,  452,  451,  450,  619, 1814,
      738,  581, 1228, 1255, 1290,  630,  574, 1236, 1325, 1360,
     1234,  431, 1281,  782, 1316, 1351,  826, 1368,  456, 1814,

      419,  418, 1376, 1384,  432, 1814, 1814, 1814, 1814, 1814,
     1814, 1269,  651,  652, 1392, 1427,  616,  681, 1413, 1429,
      399, 1124, 1276, 1423,  410,  408, 1446, 1452, 1468, 1474,
     1814,  407,  404,  365,  380, 1814, 1814, 1814, 1490, 1496,
     1512,  377,  348,  339,  333, 1518, 1534, 1540,  303,  297,
      299,  260, 1556, 1562,  261,  246, 1814,  240, 1814,  227,
     1814,  169,  183,  148,   33, 1814, 1814, 1597, 1602, 1611,
     1616, 1623, 1629, 1638, 1645, 1650, 1659, 1669, 1671, 1678,
     1683, 1690, 1697, 1707, 1714, 1719, 1729, 1734, 1743, 1748,
     1757, 1766, 1775, 1780, 1789, 1798, 1803

    } ;

static yyconst flex_int16_t yy_def[398] =
    {   0,
      367,    1,    1,    1,  367,  367,  367,  367,  367,  368,
      369,  367,  370,  367,  371,  367,  367,  367,  367,  367,
      372,  367,  373,  373,  373,  367,  367,  367,  373,  373,
      373,  367,  367,  367,  367,  368,  367,  374,  369,  367,
      375,  376,  376,  367,  370,  377,  367,  367,  372,  373,
       18,  378,  367,  379,  367,   18,  380,  381,  381,  381,
      381,  381,  381,  381,  381,  381,  381,  381,  381,  381,
      367,  367,  367,  367,  367,  367,  367,  367,  373,  373,
      367,  367,  373,  382,  373,  367,  373,  367,  367,  373,
      373,  373,  367,  368,  368,  368,  368,  374,  367,  376,

       43,  376,  383,   43,  370,  370,  370,  370,  377,  367,
      378,  384,  381,  381,  381,  385,  381,  381,  381,  381,
      381,  381,  381,  381,  381,  381,  381,  381,  381,  381,
      381,  367,  367,  367,  367,  367,  367,  367,  367,   80,
      373,   80,  373,  386,  367,  373,  373,  373,  373,  367,
      368,   97,  367,  101,  376,  101,   43,  370,  108,  387,
      367,  114,  381,  114,  381,  381,  381,  381,  381,  367,
      367,  367,  367,  367,  367,  367,  367,   80,  142,  367,
      367,  388,  367,  367,  389,  373,  367,   97,  367,  101,
      156,   43,  108,  387,  384,  114,  164,  381,  381,  367,

      367,  367,  367,  367,  367,  367,   80,  142,  367,  390,
      367,  367,  367,  389,  389,  391,  392,  367,  393,  367,
       97,  367,  101,  156,   43,  108,  114,  164,  381,  367,
      367,  367,  367,  367,  367,   80,  142,  367,  394,  367,
      367,  367,  367,  367,  391,  367,  395,  392,  396,  389,
      389,  389,  389,  389,  393,  367,   97,  367,  101,  156,
      376,  108,  114,  164,  367,  367,  367,  367,  367,   80,
      142,  367,  397,  367,  367,  367,  367,  367,  367,  367,
      391,  391,  391,  391,  395,  392,  392,  392,  392,  396,
      254,  367,   97,  376,  156,  108,  381,  164,  367,  367,

      367,  367,  142,  367,  367,  367,  367,  367,  367,  367,
      367,  391,  391,  391,  284,  392,  392,  392,  289,  254,
      367,  376,  381,  367,  367,  367,  367,  284,  289,  254,
      367,  367,  367,  367,  367,  367,  367,  367,  284,  289,
      254,  367,  367,  367,  367,  284,  289,  254,  367,  367,
      367,  367,  284,  289,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,    0,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367

    } ;

static yyconst flex_int16_t yy_nxt[1875] =
    {   0,
        6,    7,    8,    7,    7,    7,    9,   10,   11,   12,
        6,    6,   13,    6,    6,   14,    6,   15,   16,   17,
       18,    6,   19,    6,    6,    6,   20,   21,   22,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
       23,   23,   23,   24,   23,   23,   23,   23,   23,   23,
       25,   23,   23,   23,   23,   23,    6,   26,   27,   23,
       28,  116,   28,   33,   33,   33,   33,   33,   37,   29,
      166,   29,   33,   33,   33,   33,   33,   34,   34,   34,
       34,   34,   30,   31,   30,   31,   39,  366,   38,   40,
       37,   72,  367,   82,   51,   32,   41,   32,   48,   43,

       43,   43,   43,   43,   43,   46,   73,   84,   49,   74,
      367,   37,   75,  367,   35,   53,   76,   77,   37,   78,
       41,  116,   54,   55,  131,   56,   33,   33,   33,   33,
       33,   38,   57,   46,   58,   59,   59,   60,   61,   62,
       59,   63,   64,   65,   59,   66,   59,   67,   59,   59,
       68,   59,   69,   70,   59,   59,   59,   59,   59,   59,
       59,   80,  116,   82,   59,   82,   82,   82,   86,   82,
       82,   80,   80,   80,   80,   80,   80,   84,  116,   84,
       84,   84,  122,   84,   84,   34,   34,   34,   34,   34,
      116,   99,  117,  118,   85,  365,   90,  101,   91,   87,

       92,   99,   99,   99,   99,   99,   99,  101,  101,  101,
      101,  101,  101,  116,  116,  116,   37,  364,   37,  363,
      104,  119,   35,   36,   36,   36,   94,  103,  120,   96,
      104,  104,  104,  104,  104,  104,   38,  116,   38,  121,
      112,   45,   97,  123,  161,  116,  116,  125,   37,   98,
      116,   37,   97,   97,   97,   97,   97,   97,   45,   45,
       45,  105,  124,   46,  165,  126,   46,  116,   80,  107,
      167,  127,   82,  362,  361,  116,  360,  108,   80,   80,
       80,   80,   80,   80,  109,  114,   84,  108,  108,  108,
      108,  108,  108,   82,   82,  114,  114,  114,  114,  114,

      114,  116,  142,  168,   82,   82,  128,   84,   84,  359,
      358,   82,  142,  142,  142,  142,  142,  142,   84,   84,
       82,   36,  146,  129,  147,   84,   37,  130,   79,   79,
       79,   79,   79,  357,   84,  356,  116,  181,  144,  149,
       82,  143,  169,  145,  355,  183,   38,  140,  144,  144,
      144,  144,  144,  144,   84,   37,  148,  140,  140,  140,
      140,  140,  140,   95,  151,  151,  151,   95,  116,   37,
       46,  181,  116,  153,  352,  198,   82,  180,  199,  211,
      351,  350,  152,  153,  153,  153,  153,  153,  153,   38,
       84,   84,  152,  152,  152,  152,  152,  152,   36,   36,

       36,   94,  185,  195,   96,  181,  181,  161,  156,  349,
      345,   82,  180,  240,  274,  344,   84,   97,  156,  156,
      156,  156,  156,  156,   98,   84,   84,   97,   97,   97,
       97,   97,   97,  100,  100,  100,  100,  100,  343,  181,
       37,  342,  337,  157,  336,   82,   37,  306,  331,  181,
      326,  325,  154,  157,  157,  157,  157,  157,  157,   84,
       38,   46,  154,  154,  154,  154,  154,  154,  106,  158,
      158,  158,  106,  324,  321,  311,  310,  309,  164,   37,
      308,   82,  307,  302,  301,  300,  186,  159,  164,  164,
      164,  164,  164,  164,   46,   84,  116,  159,  159,  159,

      159,  159,  159,   45,   45,   45,  105,  299,  103,  292,
      246,  229,  278,  178,  107,  277,  246,  276,  275,  269,
      268,  267,  108,  178,  178,  178,  178,  178,  178,  109,
      247,  249,  108,  108,  108,  108,  108,  108,  113,  113,
      113,  113,  113,  244,  244,  244,  244,  244,  188,  266,
      265,  246,  116,  256,  243,  242,  218,  162,  188,  188,
      188,  188,  188,  188,  116,  246,  249,  162,  162,  162,
      162,  162,  162,  141,  141,  141,  141,  141,  279,  279,
      279,  279,  279,  189,  241,  247,  246,  235,  246,  234,
      233,  280,  179,  189,  189,  189,  189,  189,  189,  190,

      232,  249,  179,  179,  179,  179,  179,  179,  247,  190,
      190,  190,  190,  190,  190,  155,  155,  155,  155,  155,
      279,  279,  279,  279,  279,  192,  231,  230,  246,  116,
      195,  220,  248,  280,  191,  192,  192,  192,  192,  192,
      192,  193,  246,  249,  191,  191,  191,  191,  191,  191,
      196,  193,  193,  193,  193,  193,  193,  249,  246,  246,
      196,  196,  196,  196,  196,  196,  163,  163,  163,  163,
      163,  213,  212,  206,  205,  204,  207,  203,  247,  247,
      202,  201,  200,  116,  116,  197,  207,  207,  207,  207,
      207,  207,  208,  246,  116,  197,  197,  197,  197,  197,

      197,  209,  208,  208,  208,  208,  208,  208,  249,  116,
      195,  209,  209,  209,  209,  209,  209,  214,  214,  214,
      214,  214,  221,  216,  103,  187,  184,  177,  217,  176,
      218,  175,  221,  221,  221,  221,  221,  221,  222,  174,
      245,  173,  172,  219,  223,  246,  171,  170,  222,  222,
      222,  222,  222,  222,  223,  223,  223,  223,  223,  223,
      224,  116,  116,  116,  116,  247,  225,  116,  116,  116,
      224,  224,  224,  224,  224,  224,  225,  225,  225,  225,
      225,  225,  226,  100,  100,  100,  100,  100,  227,  116,
      116,  116,  226,  226,  226,  226,  226,  226,  227,  227,

      227,  227,  227,  227,  228,  116,  116,  112,  103,  103,
      236,  103,  150,  139,  228,  228,  228,  228,  228,  228,
      236,  236,  236,  236,  236,  236,  237,  113,  113,  113,
      113,  113,  238,  138,  137,  136,  237,  237,  237,  237,
      237,  237,  238,  238,  238,  238,  238,  238,  214,  214,
      214,  214,  214,  116,  216,  135,  134,  133,  132,  217,
      116,  218,  244,  244,  244,  244,  244,  257,  367,  116,
       51,   57,   53,  367,  219,  218,  112,  257,  257,  257,
      257,  257,  257,  110,  103,   93,   89,   88,  219,  244,
      244,  244,  244,  250,   81,  252,   71,   52,   51,  258,

      252,  252,  253,   47,   44,  367,  367,  367,  254,  258,
      258,  258,  258,  258,  258,  255,  259,  367,  254,  254,
      254,  254,  254,  254,  260,  367,  259,  259,  259,  259,
      259,  259,  261,  367,  260,  260,  260,  260,  260,  260,
      262,  367,  261,  261,  261,  261,  261,  261,  263,  367,
      262,  262,  262,  262,  262,  262,  264,  367,  263,  263,
      263,  263,  263,  263,  270,  367,  264,  264,  264,  264,
      264,  264,  271,  367,  270,  270,  270,  270,  270,  270,
      272,  367,  271,  271,  271,  271,  271,  271,  367,  367,
      272,  272,  272,  272,  272,  272,  245,  245,  245,  281,

      367,  367,  283,  367,  367,  367,  367,  367,  367,  367,
      244,  244,  244,  244,  244,  284,  367,  367,  367,  367,
      367,  367,  285,  218,  367,  284,  284,  284,  284,  284,
      284,  248,  248,  248,  286,  367,  219,  367,  367,  367,
      367,  367,  288,  244,  244,  244,  244,  244,  367,  367,
      289,  367,  367,  367,  367,  367,  218,  290,  367,  367,
      289,  289,  289,  289,  289,  289,  367,  367,  367,  219,
      244,  244,  244,  244,  244,  367,  367,  367,  367,  367,
      367,  367,  367,  218,  244,  244,  244,  244,  244,  293,
      367,  367,  367,  367,  367,  367,  219,  218,  367,  293,

      293,  293,  293,  293,  293,  367,  367,  367,  367,  367,
      219,  250,  250,  250,  250,  250,  367,  367,  367,  367,
      367,  294,  367,  367,  218,  155,  155,  155,  155,  155,
      291,  294,  294,  294,  294,  294,  294,  219,  367,  367,
      291,  291,  291,  291,  291,  291,  244,  244,  244,  244,
      250,  103,  252,  367,  367,  367,  295,  252,  252,  253,
      367,  367,  367,  367,  367,  254,  295,  295,  295,  295,
      295,  295,  255,  296,  367,  254,  254,  254,  254,  254,
      254,  297,  367,  296,  296,  296,  296,  296,  296,  298,
      367,  297,  297,  297,  297,  297,  297,   83,  367,  298,

      298,  298,  298,  298,  298,  303,  367,   83,   83,   83,
       83,   83,   83,  304,  367,  303,  303,  303,  303,  303,
      303,  367,  367,  304,  304,  304,  304,  304,  304,  312,
      279,  279,  279,  312,  367,  246,  367,  316,  279,  279,
      279,  316,  313,  367,  367,  367,  367,  367,  246,  367,
      317,  367,  367,  367,  320,  247,  282,  314,  314,  314,
      282,  367,  246,  249,  320,  320,  320,  320,  320,  320,
      312,  279,  279,  279,  312,  315,  246,  163,  163,  163,
      163,  163,  247,  313,  367,  315,  315,  315,  315,  315,
      315,  245,  245,  245,  281,  367,  247,  283,  367,  367,

      367,   36,  367,  116,  367,  367,  367,  367,  367,  367,
      284,   36,   36,   36,   36,   36,   36,  285,  367,  367,
      284,  284,  284,  284,  284,  284,  287,  318,  318,  318,
      287,  367,  367,  367,  367,  367,  322,  246,  367,  367,
      367,  367,  367,  367,  367,  319,  322,  322,  322,  322,
      322,  322,  249,  367,  367,  319,  319,  319,  319,  319,
      319,  248,  248,  248,  286,  367,  367,  367,  367,  367,
      367,   45,  288,  367,  367,  367,  367,  367,  367,  367,
      289,   45,   45,   45,   45,   45,   45,  290,  323,  367,
      289,  289,  289,  289,  289,  289,   83,  367,  323,  323,

      323,  323,  323,  323,  327,  367,   83,   83,   83,   83,
       83,   83,  328,  367,  327,  327,  327,  327,  327,  327,
      367,  367,  328,  328,  328,  328,  328,  328,  316,  279,
      279,  279,  316,  329,  367,  367,  367,  367,  367,  246,
      367,  317,  367,  329,  329,  329,  329,  329,  329,  330,
      367,  367,  367,  367,  249,  367,  332,  367,  367,  330,
      330,  330,  330,  330,  330,  333,  338,  367,  367,  367,
      334,  367,  339,  367,  335,  367,  338,  338,  338,  338,
      338,  338,  339,  339,  339,  339,  339,  339,  340,  367,
      367,  367,  367,  367,  341,  367,  367,  367,  340,  340,

      340,  340,  340,  340,  341,  341,  341,  341,  341,  341,
      346,  367,  367,  367,  367,  367,  347,  367,  367,  367,
      346,  346,  346,  346,  346,  346,  347,  347,  347,  347,
      347,  347,  348,  367,  367,  367,  367,  367,  353,  367,
      367,  367,  348,  348,  348,  348,  348,  348,  353,  353,
      353,  353,  353,  353,  354,  367,  367,  367,  367,  367,
      215,  367,  367,  367,  354,  354,  354,  354,  354,  354,
      215,  215,  215,  215,  215,  215,  245,  367,  367,  367,
      367,  367,  248,  367,  367,  367,  245,  245,  245,  245,
      245,  245,  248,  248,  248,  248,  248,  248,   36,  367,

       36,   36,   36,   36,   36,   36,   36,   42,   42,  367,
       42,   42,   45,  367,   45,   45,   45,   45,   45,   45,
       45,   50,  367,  367,   50,   50,   79,   79,   79,   79,
       79,   79,   79,   83,   83,   83,  367,   83,   83,   95,
       95,   95,   95,   95,   95,   95,   95,   95,  100,  100,
      100,  100,  100,  100,  100,  102,  102,  367,  102,  102,
      106,  106,  106,  106,  106,  106,  106,  106,  106,  111,
      111,  111,  111,  111,  111,  111,  111,  111,  111,   59,
       59,  113,  113,  113,  113,  113,  113,  113,  115,  115,
      367,  115,  115,  141,  141,  141,  141,  141,  141,  141,

      155,  155,  155,  155,  155,  155,  155,  160,  160,  160,
      160,  160,  160,  160,  160,  160,  160,  163,  163,  163,
      163,  163,  163,  163,  182,  182,  182,  367,  182,  194,
      194,  194,  194,  194,  194,  194,  194,  194,  194,  210,
      210,  210,  367,  210,  215,  215,  215,  367,  215,  215,
      215,  215,  215,  239,  239,  239,  367,  239,  245,  367,
      245,  245,  245,  245,  245,  245,  245,  248,  367,  248,
      248,  248,  248,  248,  248,  248,  251,  251,  251,  251,
      251,  251,  251,  251,  251,  273,  273,  273,  367,  273,
      282,  282,  282,  282,  282,  282,  282,  282,  282,  287,

      287,  287,  287,  287,  287,  287,  287,  287,  305,  305,
      305,  367,  305,    5,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367
    } ;

static yyconst flex_int16_t yy_chk[1875] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        3,  119,    4,    7,    7,    7,    7,    7,   10,    3,
      119,    4,    8,    8,    8,    8,    8,    9,    9,    9,
        9,    9,    3,    3,    4,    4,   11,  365,   10,   11,
       13,   20,   51,   23,   51,    3,   11,    4,   15,   11,

       11,   11,   11,   11,   11,   13,   20,   23,   15,   20,
       39,   36,   20,   39,    9,   18,   20,   20,   45,   20,
       39,   69,   18,   18,   69,   18,   33,   33,   33,   33,
       33,   36,   18,   45,   18,   18,   18,   18,   18,   18,
       18,   18,   18,   18,   18,   18,   18,   18,   18,   18,
       18,   18,   18,   18,   18,   18,   18,   18,   18,   18,
       18,   21,   63,   24,   18,   25,   29,   30,   25,   50,
       31,   21,   21,   21,   21,   21,   21,   24,   60,   25,
       29,   30,   63,   50,   31,   34,   34,   34,   34,   34,
       58,   40,   58,   60,   24,  364,   29,   41,   30,   25,

       31,   40,   40,   40,   40,   40,   40,   41,   41,   41,
       41,   41,   41,   62,   61,   64,   95,  363,   96,  362,
       43,   61,   34,   38,   38,   38,   38,   43,   62,   38,
       43,   43,   43,   43,   43,   43,   95,   66,   96,   62,
      112,  105,   38,   64,  112,  117,   65,   66,  106,   38,
       67,  105,   38,   38,   38,   38,   38,   38,   46,   46,
       46,   46,   65,  106,  117,   67,  105,  122,   49,   46,
      122,   67,   79,  360,  358,  125,  356,   46,   49,   49,
       49,   49,   49,   49,   46,   57,   79,   46,   46,   46,
       46,   46,   46,   83,   87,   57,   57,   57,   57,   57,

       57,   68,   84,  125,   90,   85,   68,   83,   87,  355,
      352,   92,   84,   84,   84,   84,   84,   84,   90,   85,
       91,   94,   87,   68,   90,   92,   94,   68,   80,   80,
       80,   80,   80,  351,   91,  350,  131,  144,   86,   92,
       80,   85,  131,   86,  349,  144,   94,   80,   86,   86,
       86,   86,   86,   86,   80,  107,   91,   80,   80,   80,
       80,   80,   80,   97,   97,   97,   97,   97,  165,   97,
      107,  182,  167,   99,  345,  165,  141,  143,  167,  182,
      344,  343,   97,   99,   99,   99,   99,   99,   99,   97,
      141,  143,   97,   97,   97,   97,   97,   97,   98,   98,

       98,   98,  146,  195,   98,  210,  239,  195,  103,  342,
      335,  147,  148,  210,  239,  334,  146,   98,  103,  103,
      103,  103,  103,  103,   98,  147,  148,   98,   98,   98,
       98,   98,   98,  101,  101,  101,  101,  101,  333,  273,
      151,  332,  326,  104,  325,  149,  158,  273,  321,  305,
      302,  301,  101,  104,  104,  104,  104,  104,  104,  149,
      151,  158,  101,  101,  101,  101,  101,  101,  108,  108,
      108,  108,  108,  299,  292,  278,  277,  276,  116,  108,
      275,  186,  274,  269,  267,  266,  149,  108,  116,  116,
      116,  116,  116,  116,  108,  186,  198,  108,  108,  108,

      108,  108,  108,  109,  109,  109,  109,  265,  261,  256,
      216,  198,  243,  140,  109,  242,  217,  241,  240,  235,
      233,  232,  109,  140,  140,  140,  140,  140,  140,  109,
      216,  217,  109,  109,  109,  109,  109,  109,  114,  114,
      114,  114,  114,  244,  244,  244,  244,  244,  152,  231,
      230,  248,  229,  220,  213,  212,  244,  114,  152,  152,
      152,  152,  152,  152,  114,  245,  248,  114,  114,  114,
      114,  114,  114,  142,  142,  142,  142,  142,  246,  246,
      246,  246,  246,  153,  211,  245,  287,  205,  282,  204,
      203,  246,  142,  153,  153,  153,  153,  153,  153,  154,

      202,  287,  142,  142,  142,  142,  142,  142,  282,  154,
      154,  154,  154,  154,  154,  156,  156,  156,  156,  156,
      279,  279,  279,  279,  279,  157,  201,  200,  317,  199,
      194,  187,  286,  279,  156,  157,  157,  157,  157,  157,
      157,  159,  286,  317,  156,  156,  156,  156,  156,  156,
      162,  159,  159,  159,  159,  159,  159,  286,  313,  314,
      162,  162,  162,  162,  162,  162,  164,  164,  164,  164,
      164,  184,  183,  177,  176,  175,  178,  174,  313,  314,
      173,  172,  171,  169,  168,  164,  178,  178,  178,  178,
      178,  178,  179,  318,  166,  164,  164,  164,  164,  164,

      164,  181,  179,  179,  179,  179,  179,  179,  318,  163,
      160,  181,  181,  181,  181,  181,  181,  185,  185,  185,
      185,  185,  188,  185,  155,  150,  145,  139,  185,  138,
      185,  137,  188,  188,  188,  188,  188,  188,  189,  136,
      281,  135,  134,  185,  190,  281,  133,  132,  189,  189,
      189,  189,  189,  189,  190,  190,  190,  190,  190,  190,
      191,  130,  129,  128,  127,  281,  192,  126,  124,  123,
      191,  191,  191,  191,  191,  191,  192,  192,  192,  192,
      192,  192,  193,  294,  294,  294,  294,  294,  196,  121,
      120,  118,  193,  193,  193,  193,  193,  193,  196,  196,

      196,  196,  196,  196,  197,  115,  113,  111,  102,  294,
      207,  100,   93,   78,  197,  197,  197,  197,  197,  197,
      207,  207,  207,  207,  207,  207,  208,  297,  297,  297,
      297,  297,  209,   77,   76,   75,  208,  208,  208,  208,
      208,  208,  209,  209,  209,  209,  209,  209,  214,  214,
      214,  214,  214,  297,  214,   74,   73,   72,   71,  214,
       70,  214,  215,  215,  215,  215,  215,  221,  215,   59,
       55,   54,   53,  215,  214,  215,   52,  221,  221,  221,
      221,  221,  221,   48,   42,   35,   27,   26,  215,  219,
      219,  219,  219,  219,   22,  219,   19,   17,   16,  222,

      219,  219,  219,   14,   12,    5,    0,    0,  219,  222,
      222,  222,  222,  222,  222,  219,  223,    0,  219,  219,
      219,  219,  219,  219,  224,    0,  223,  223,  223,  223,
      223,  223,  225,    0,  224,  224,  224,  224,  224,  224,
      226,    0,  225,  225,  225,  225,  225,  225,  227,    0,
      226,  226,  226,  226,  226,  226,  228,    0,  227,  227,
      227,  227,  227,  227,  236,    0,  228,  228,  228,  228,
      228,  228,  237,    0,  236,  236,  236,  236,  236,  236,
      238,    0,  237,  237,  237,  237,  237,  237,    0,    0,
      238,  238,  238,  238,  238,  238,  247,  247,  247,  247,

        0,    0,  247,    0,    0,    0,    0,    0,    0,    0,
      250,  250,  250,  250,  250,  247,  250,    0,    0,    0,
        0,  250,  247,  250,    0,  247,  247,  247,  247,  247,
      247,  249,  249,  249,  249,    0,  250,    0,    0,    0,
        0,    0,  249,  251,  251,  251,  251,  251,    0,  251,
      249,    0,    0,    0,  251,    0,  251,  249,    0,    0,
      249,  249,  249,  249,  249,  249,    0,    0,    0,  251,
      252,  252,  252,  252,  252,    0,  252,    0,    0,    0,
        0,  252,    0,  252,  253,  253,  253,  253,  253,  257,
      253,    0,    0,    0,    0,  253,  252,  253,    0,  257,

      257,  257,  257,  257,  257,    0,    0,    0,    0,    0,
      253,  254,  254,  254,  254,  254,    0,  254,    0,    0,
        0,  259,  254,    0,  254,  322,  322,  322,  322,  322,
      254,  259,  259,  259,  259,  259,  259,  254,    0,    0,
      254,  254,  254,  254,  254,  254,  255,  255,  255,  255,
      255,  322,  255,    0,    0,    0,  260,  255,  255,  255,
        0,    0,    0,    0,    0,  255,  260,  260,  260,  260,
      260,  260,  255,  262,    0,  255,  255,  255,  255,  255,
      255,  263,    0,  262,  262,  262,  262,  262,  262,  264,
        0,  263,  263,  263,  263,  263,  263,  270,    0,  264,

      264,  264,  264,  264,  264,  271,    0,  270,  270,  270,
      270,  270,  270,  272,    0,  271,  271,  271,  271,  271,
      271,    0,    0,  272,  272,  272,  272,  272,  272,  283,
      283,  283,  283,  283,    0,  283,    0,  288,  288,  288,
      288,  288,  283,    0,    0,    0,    0,    0,  288,    0,
      288,    0,    0,    0,  291,  283,  284,  284,  284,  284,
      284,    0,  284,  288,  291,  291,  291,  291,  291,  291,
      312,  312,  312,  312,  312,  284,  312,  323,  323,  323,
      323,  323,  284,  312,    0,  284,  284,  284,  284,  284,
      284,  285,  285,  285,  285,    0,  312,  285,    0,    0,

        0,  293,    0,  323,    0,    0,    0,    0,    0,    0,
      285,  293,  293,  293,  293,  293,  293,  285,    0,    0,
      285,  285,  285,  285,  285,  285,  289,  289,  289,  289,
      289,    0,    0,    0,    0,    0,  295,  289,    0,    0,
        0,    0,    0,    0,    0,  289,  295,  295,  295,  295,
      295,  295,  289,    0,    0,  289,  289,  289,  289,  289,
      289,  290,  290,  290,  290,    0,    0,    0,    0,    0,
        0,  296,  290,    0,    0,    0,    0,    0,    0,    0,
      290,  296,  296,  296,  296,  296,  296,  290,  298,    0,
      290,  290,  290,  290,  290,  290,  303,    0,  298,  298,

      298,  298,  298,  298,  304,    0,  303,  303,  303,  303,
      303,  303,  315,    0,  304,  304,  304,  304,  304,  304,
        0,    0,  315,  315,  315,  315,  315,  315,  316,  316,
      316,  316,  316,  319,    0,    0,    0,    0,    0,  316,
        0,  316,    0,  319,  319,  319,  319,  319,  319,  320,
        0,    0,    0,    0,  316,    0,  324,    0,    0,  320,
      320,  320,  320,  320,  320,  324,  327,    0,    0,    0,
      324,    0,  328,    0,  324,    0,  327,  327,  327,  327,
      327,  327,  328,  328,  328,  328,  328,  328,  329,    0,
        0,    0,    0,    0,  330,    0,    0,    0,  329,  329,

      329,  329,  329,  329,  330,  330,  330,  330,  330,  330,
      339,    0,    0,    0,    0,    0,  340,    0,    0,    0,
      339,  339,  339,  339,  339,  339,  340,  340,  340,  340,
      340,  340,  341,    0,    0,    0,    0,    0,  346,    0,
        0,    0,  341,  341,  341,  341,  341,  341,  346,  346,
      346,  346,  346,  346,  347,    0,    0,    0,    0,    0,
      348,    0,    0,    0,  347,  347,  347,  347,  347,  347,
      348,  348,  348,  348,  348,  348,  353,    0,    0,    0,
        0,    0,  354,    0,    0,    0,  353,  353,  353,  353,
      353,  353,  354,  354,  354,  354,  354,  354,  368,    0,

      368,  368,  368,  368,  368,  368,  368,  369,  369,    0,
      369,  369,  370,    0,  370,  370,  370,  370,  370,  370,
      370,  371,    0,    0,  371,  371,  372,  372,  372,  372,
      372,  372,  372,  373,  373,  373,    0,  373,  373,  374,
      374,  374,  374,  374,  374,  374,  374,  374,  375,  375,
      375,  375,  375,  375,  375,  376,  376,    0,  376,  376,
      377,  377,  377,  377,  377,  377,  377,  377,  377,  378,
      378,  378,  378,  378,  378,  378,  378,  378,  378,  379,
      379,  380,  380,  380,  380,  380,  380,  380,  381,  381,
        0,  381,  381,  382,  382,  382,  382,  382,  382,  382,

      383,  383,  383,  383,  383,  383,  383,  384,  384,  384,
      384,  384,  384,  384,  384,  384,  384,  385,  385,  385,
      385,  385,  385,  385,  386,  386,  386,    0,  386,  387,
      387,  387,  387,  387,  387,  387,  387,  387,  387,  388,
      388,  388,    0,  388,  389,  389,  389,    0,  389,  389,
      389,  389,  389,  390,  390,  390,    0,  390,  391,    0,
      391,  391,  391,  391,  391,  391,  391,  392,    0,  392,
      392,  392,  392,  392,  392,  392,  393,  393,  393,  393,
      393,  393,  393,  393,  393,  394,  394,  394,    0,  394,
      395,  395,  395,  395,  395,  395,  395,  395,  395,  396,

      396,  396,  396,  396,  396,  396,  396,  396,  397,  397,
      397,    0,  397,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367
    } ;

#line 1 "<stdin>"
YY_DECL
{
	register yy_state_type yy_current_state;
	register UChar *yy_cp, *yy_bp;
	register int yy_act;
	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 368 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 1814 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 29 "<stdin>"
/* ignore comments */
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 31 "<stdin>"
{yyTok = WHITESPACE; return yyTok;}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 33 "<stdin>"
{yyTok = SGML_CD; return yyTok;}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 34 "<stdin>"
{yyTok = SGML_CD; return yyTok;}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 35 "<stdin>"
{yyTok = INCLUDES; return yyTok;}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 36 "<stdin>"
{yyTok = DASHMATCH; return yyTok;}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 37 "<stdin>"
{yyTok = BEGINSWITH; return yyTok;}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 38 "<stdin>"
{yyTok = ENDSWITH; return yyTok;}
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 39 "<stdin>"
{yyTok = CONTAINS; return yyTok;}
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 40 "<stdin>"
{yyTok = MEDIA_NOT; return yyTok;}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 41 "<stdin>"
{yyTok = MEDIA_ONLY; return yyTok;}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 42 "<stdin>"
{yyTok = MEDIA_AND; return yyTok;}
	YY_BREAK
case 13:
/* rule 13 can match eol */
YY_RULE_SETUP
#line 44 "<stdin>"
{yyTok = STRING; return yyTok;}
	YY_BREAK
case 14:
/* rule 14 can match eol */
YY_RULE_SETUP
#line 46 "<stdin>"
{yyTok = IDENT; return yyTok;}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 48 "<stdin>"
{yyTok = HEX; return yyTok;}
	YY_BREAK
case 16:
/* rule 16 can match eol */
YY_RULE_SETUP
#line 49 "<stdin>"
{yyTok = IDSEL; return yyTok;}
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 51 "<stdin>"
{BEGIN(mediaquery); yyTok = IMPORT_SYM; return yyTok;}
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 52 "<stdin>"
{yyTok = PAGE_SYM; return yyTok;}
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 53 "<stdin>"
{BEGIN(mediaquery); yyTok = MEDIA_SYM; return yyTok;}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 54 "<stdin>"
{yyTok = FONT_FACE_SYM; return yyTok;}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 55 "<stdin>"
{yyTok = CHARSET_SYM; return yyTok;}
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 56 "<stdin>"
{yyTok = NAMESPACE_SYM; return yyTok; }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 57 "<stdin>"
{yyTok = WEBKIT_RULE_SYM; return yyTok; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 58 "<stdin>"
{yyTok = WEBKIT_DECLS_SYM; return yyTok; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 59 "<stdin>"
{yyTok = WEBKIT_VALUE_SYM; return yyTok; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 60 "<stdin>"
{BEGIN(mediaquery); yyTok = WEBKIT_MEDIAQUERY_SYM; return yyTok; }
	YY_BREAK
case 27:
/* rule 27 can match eol */
YY_RULE_SETUP
#line 62 "<stdin>"
{yyTok = IMPORTANT_SYM; return yyTok;}
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 64 "<stdin>"
{yyTok = EMS; return yyTok;}
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 65 "<stdin>"
{yyTok = QEMS; return yyTok;} /* quirky ems */
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 66 "<stdin>"
{yyTok = EXS; return yyTok;}
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 67 "<stdin>"
{yyTok = PXS; return yyTok;}
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 68 "<stdin>"
{yyTok = CMS; return yyTok;}
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 69 "<stdin>"
{yyTok = MMS; return yyTok;}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 70 "<stdin>"
{yyTok = INS; return yyTok;}
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 71 "<stdin>"
{yyTok = PTS; return yyTok;}
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 72 "<stdin>"
{yyTok = PCS; return yyTok;}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 73 "<stdin>"
{yyTok = DEGS; return yyTok;}
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 74 "<stdin>"
{yyTok = RADS; return yyTok;}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 75 "<stdin>"
{yyTok = GRADS; return yyTok;}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 76 "<stdin>"
{yyTok = MSECS; return yyTok;}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 77 "<stdin>"
{yyTok = SECS; return yyTok;}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 78 "<stdin>"
{yyTok = HERZ; return yyTok;}
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 79 "<stdin>"
{yyTok = KHERZ; return yyTok;}
	YY_BREAK
case 44:
/* rule 44 can match eol */
YY_RULE_SETUP
#line 80 "<stdin>"
{yyTok = DIMEN; return yyTok;}
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 81 "<stdin>"
{yyTok = PERCENTAGE; return yyTok;}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 82 "<stdin>"
{yyTok = INTEGER; return yyTok;}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 83 "<stdin>"
{yyTok = FLOATTOKEN; return yyTok;}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 85 "<stdin>"
{yyTok = NOTFUNCTION; return yyTok;}
	YY_BREAK
case 49:
/* rule 49 can match eol */
YY_RULE_SETUP
#line 86 "<stdin>"
{yyTok = URI; return yyTok;}
	YY_BREAK
case 50:
/* rule 50 can match eol */
YY_RULE_SETUP
#line 87 "<stdin>"
{yyTok = URI; return yyTok;}
	YY_BREAK
case 51:
/* rule 51 can match eol */
YY_RULE_SETUP
#line 88 "<stdin>"
{yyTok = FUNCTION; return yyTok;}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 90 "<stdin>"
{yyTok = UNICODERANGE; return yyTok;}
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 91 "<stdin>"
{yyTok = UNICODERANGE; return yyTok;}
	YY_BREAK
case 54:
#line 94 "<stdin>"
case 55:
YY_RULE_SETUP
#line 94 "<stdin>"
{BEGIN(INITIAL); yyTok = *yytext; return yyTok; }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 95 "<stdin>"
{yyTok = *yytext; return yyTok;}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 97 "<stdin>"
ECHO;
	YY_BREAK
#line 1539 "<stdout>"
case YY_STATE_EOF(INITIAL):
case YY_END_OF_BUFFER:
case YY_STATE_EOF(mediaquery):
	yyterminate();

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of yylex */
