#include <QDebug>
#include <QThread>
#include <QString>
#include <qtconcurrentrun.h>

#ifndef QT_NO_CONCURRENT

using namespace QtConcurrent;

void hello(QString name)
{
    qDebug() << "Hello" << name << "from" << QThread::currentThread();
}

int main()
{
    QFuture<void> f1 = run(hello, QString("Alice"));
    QFuture<void> f2 = run(hello, QString("Bob"));
    f1.waitForFinished();
    f2.waitForFinished();
}

#else

int main()
{
	qDebug() << "Qt Concurrent is not yet supported on this platform";
}

#endif