#ifndef MEDIALAYER_H
#define MEDIAPLAYER_H

#include <QtGui/QWidget>
#include <QtGui/QApplication>
#include <QtCore/QTimerEvent>
#include <QtGui/QShowEvent>

#include <phonon/mediaobject.h>
#include <phonon/audiooutput.h>
#include <phonon/mediasource.h>
#include <phonon/videowidget.h>
#include <phonon/seekslider.h>

class QThread;
class QPushButton;
class QLabel;
class QSlider;
class QTextEdit;
class QMenu;

class MediaPlayer :
            public QWidget
{
    Q_OBJECT
public:
    MediaPlayer(const QString &);
public slots:
    void openFile();
    void pause();
    void play();
    void rewind();
    void setVolume(int);
    void dragEnterEvent(QDragEnterEvent *e);
    void dropEvent(QDropEvent *e);
    void setFile(const QString &text);
    void initVideoWindow();
    void updateInfo();
    void finished();
    void handleVideoChanged(bool);

private slots:
    void setSaturation(int);
    void setContrast(int);
    void setHue(int);
    void setBrightness(int);
    void stateChanged(Phonon::State newstate, Phonon::State oldstate);
    void showSettingsDialog();
    void showContextMenu(const QPoint &);

private:
    QMenu *fileMenu;
    QPushButton *pauseButton;
    QPushButton *playButton;
    QPushButton *rewindButton;
    Phonon::SeekSlider *slider;
    QSlider *volume;
    QSlider *m_hueSlider;
    QSlider *m_satSlider;
    QSlider *m_contSlider;
    QTextEdit *info;
    long duration;
    
    QWidget m_videoWindow;
    Phonon::MediaObject m_MediaObject;
    Phonon::AudioOutput m_AudioOutput;
    Phonon::VideoWidget m_videoWidget;

};

#endif //MEDIAPLAYER_H
