/****************************************************************************
**
** Copyright (C) 2007-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the demonstration applications of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** In addition, as a special exception, Trolltech gives you certain
** additional rights. These rights are described in the Trolltech GPL
** Exception version 1.0, which can be found at
** http://www.trolltech.com/products/qt/gplexception/ and in the file
** GPL_EXCEPTION.txt in this package.
**
** In addition, as a special exception, Trolltech, as the sole copyright
** holder for Qt Designer, grants users of the Qt/Eclipse Integration
** plug-in the right for the Qt/Eclipse Integration to link to
** functionality provided by Qt Designer and its related libraries.
**
** Trolltech reserves all rights not expressly granted herein.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include <QtCore/QObject>
#include <QtCore/QPointer>

#include <QtWebKit/QWebPage>

class QAction;
class QSignalMapper;

class BrowserMainWindow;
class BrowserTab;

/**
 * This class will proxy between the current BrowserTab and the
 * MainWindow.
 *
 * This is the most complex and error prone part of the Browser
 */
class BrowserTabProxy : public QObject {
    Q_OBJECT
public:
    BrowserTabProxy(BrowserMainWindow* mainWindow);

    void setTab(BrowserTab* newTab);
    void updateAction(int index, BrowserTab* tab);

Q_SIGNALS:
    void linkHovered(const QString&);

private Q_SLOTS:
    void slotUpdateAction(int index);

private:
    void disconnect(BrowserTab* oldTab);
    void connect(BrowserTab* newTab);
    void update(BrowserTab* newTab);

private:
    QPointer<BrowserTab> m_currentTab;
    BrowserMainWindow* m_mainWindow;
    QSignalMapper* m_mapper;

    struct WebActionConnection {
        WebActionConnection(const char* _slot = 0, QAction** _action = 0, QWebPage::WebAction _webAction = QWebPage::WebActionCount);

        const char* slot;
        QAction** action;
        QWebPage::WebAction webAction;
    };

    QVector<WebActionConnection> m_webActionConnections;
};

