/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGSVGElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "FloatRect.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSNodeList.h"
#include "JSSVGAngle.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedPreserveAspectRatio.h"
#include "JSSVGAnimatedRect.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGElement.h"
#include "JSSVGLength.h"
#include "JSSVGMatrix.h"
#include "JSSVGNumber.h"
#include "JSSVGPoint.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "JSSVGTransform.h"
#include "KURL.h"
#include "NameNodeList.h"
#include "NodeList.h"
#include "SVGAngle.h"
#include "SVGElement.h"
#include "SVGLength.h"
#include "SVGSVGElement.h"
#include "SVGStringList.h"
#include "SVGTransform.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGSVGElement)

/* Hash table */

static const HashTableValue JSSVGSVGElementTableValues[28] =
{
    { "x", DontDelete|ReadOnly, (intptr_t)jsSVGSVGElementX, (intptr_t)0 },
    { "y", DontDelete|ReadOnly, (intptr_t)jsSVGSVGElementY, (intptr_t)0 },
    { "width", DontDelete|ReadOnly, (intptr_t)jsSVGSVGElementWidth, (intptr_t)0 },
    { "height", DontDelete|ReadOnly, (intptr_t)jsSVGSVGElementHeight, (intptr_t)0 },
    { "contentScriptType", DontDelete, (intptr_t)jsSVGSVGElementContentScriptType, (intptr_t)setJSSVGSVGElementContentScriptType },
    { "contentStyleType", DontDelete, (intptr_t)jsSVGSVGElementContentStyleType, (intptr_t)setJSSVGSVGElementContentStyleType },
    { "viewport", DontDelete|ReadOnly, (intptr_t)jsSVGSVGElementViewport, (intptr_t)0 },
    { "pixelUnitToMillimeterX", DontDelete|ReadOnly, (intptr_t)jsSVGSVGElementPixelUnitToMillimeterX, (intptr_t)0 },
    { "pixelUnitToMillimeterY", DontDelete|ReadOnly, (intptr_t)jsSVGSVGElementPixelUnitToMillimeterY, (intptr_t)0 },
    { "screenPixelToMillimeterX", DontDelete|ReadOnly, (intptr_t)jsSVGSVGElementScreenPixelToMillimeterX, (intptr_t)0 },
    { "screenPixelToMillimeterY", DontDelete|ReadOnly, (intptr_t)jsSVGSVGElementScreenPixelToMillimeterY, (intptr_t)0 },
    { "useCurrentView", DontDelete, (intptr_t)jsSVGSVGElementUseCurrentView, (intptr_t)setJSSVGSVGElementUseCurrentView },
    { "currentScale", DontDelete, (intptr_t)jsSVGSVGElementCurrentScale, (intptr_t)setJSSVGSVGElementCurrentScale },
    { "currentTranslate", DontDelete|ReadOnly, (intptr_t)jsSVGSVGElementCurrentTranslate, (intptr_t)0 },
    { "requiredFeatures", DontDelete|ReadOnly, (intptr_t)jsSVGSVGElementRequiredFeatures, (intptr_t)0 },
    { "requiredExtensions", DontDelete|ReadOnly, (intptr_t)jsSVGSVGElementRequiredExtensions, (intptr_t)0 },
    { "systemLanguage", DontDelete|ReadOnly, (intptr_t)jsSVGSVGElementSystemLanguage, (intptr_t)0 },
    { "xmllang", DontDelete, (intptr_t)jsSVGSVGElementXmllang, (intptr_t)setJSSVGSVGElementXmllang },
    { "xmlspace", DontDelete, (intptr_t)jsSVGSVGElementXmlspace, (intptr_t)setJSSVGSVGElementXmlspace },
    { "externalResourcesRequired", DontDelete|ReadOnly, (intptr_t)jsSVGSVGElementExternalResourcesRequired, (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)jsSVGSVGElementClassName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsSVGSVGElementStyle, (intptr_t)0 },
    { "nearestViewportElement", DontDelete|ReadOnly, (intptr_t)jsSVGSVGElementNearestViewportElement, (intptr_t)0 },
    { "farthestViewportElement", DontDelete|ReadOnly, (intptr_t)jsSVGSVGElementFarthestViewportElement, (intptr_t)0 },
    { "viewBox", DontDelete|ReadOnly, (intptr_t)jsSVGSVGElementViewBox, (intptr_t)0 },
    { "preserveAspectRatio", DontDelete|ReadOnly, (intptr_t)jsSVGSVGElementPreserveAspectRatio, (intptr_t)0 },
    { "zoomAndPan", DontDelete, (intptr_t)jsSVGSVGElementZoomAndPan, (intptr_t)setJSSVGSVGElementZoomAndPan },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGSVGElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 1023, JSSVGSVGElementTableValues, 0 };
#else
    { 70, 63, JSSVGSVGElementTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGSVGElementPrototypeTableValues[32] =
{
    { "SVG_ZOOMANDPAN_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGSVGElementSVG_ZOOMANDPAN_UNKNOWN, (intptr_t)0 },
    { "SVG_ZOOMANDPAN_DISABLE", DontDelete|ReadOnly, (intptr_t)jsSVGSVGElementSVG_ZOOMANDPAN_DISABLE, (intptr_t)0 },
    { "SVG_ZOOMANDPAN_MAGNIFY", DontDelete|ReadOnly, (intptr_t)jsSVGSVGElementSVG_ZOOMANDPAN_MAGNIFY, (intptr_t)0 },
    { "suspendRedraw", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionSuspendRedraw, (intptr_t)1 },
    { "unsuspendRedraw", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionUnsuspendRedraw, (intptr_t)1 },
    { "unsuspendRedrawAll", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionUnsuspendRedrawAll, (intptr_t)0 },
    { "forceRedraw", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionForceRedraw, (intptr_t)0 },
    { "pauseAnimations", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionPauseAnimations, (intptr_t)0 },
    { "unpauseAnimations", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionUnpauseAnimations, (intptr_t)0 },
    { "animationsPaused", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionAnimationsPaused, (intptr_t)0 },
    { "getCurrentTime", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionGetCurrentTime, (intptr_t)0 },
    { "setCurrentTime", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionSetCurrentTime, (intptr_t)1 },
    { "getIntersectionList", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionGetIntersectionList, (intptr_t)2 },
    { "getEnclosureList", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionGetEnclosureList, (intptr_t)2 },
    { "checkIntersection", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionCheckIntersection, (intptr_t)2 },
    { "checkEnclosure", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionCheckEnclosure, (intptr_t)2 },
    { "deselectAll", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionDeselectAll, (intptr_t)0 },
    { "createSVGNumber", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionCreateSVGNumber, (intptr_t)0 },
    { "createSVGLength", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionCreateSVGLength, (intptr_t)0 },
    { "createSVGAngle", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionCreateSVGAngle, (intptr_t)0 },
    { "createSVGPoint", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionCreateSVGPoint, (intptr_t)0 },
    { "createSVGMatrix", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionCreateSVGMatrix, (intptr_t)0 },
    { "createSVGRect", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionCreateSVGRect, (intptr_t)0 },
    { "createSVGTransform", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionCreateSVGTransform, (intptr_t)0 },
    { "createSVGTransformFromMatrix", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionCreateSVGTransformFromMatrix, (intptr_t)1 },
    { "hasExtension", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionHasExtension, (intptr_t)1 },
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionGetPresentationAttribute, (intptr_t)1 },
    { "getBBox", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionGetBBox, (intptr_t)0 },
    { "getCTM", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionGetCTM, (intptr_t)0 },
    { "getScreenCTM", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionGetScreenCTM, (intptr_t)0 },
    { "getTransformToElement", DontDelete|Function, (intptr_t)jsSVGSVGElementPrototypeFunctionGetTransformToElement, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGSVGElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 2047, JSSVGSVGElementPrototypeTableValues, 0 };
#else
    { 71, 63, JSSVGSVGElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGSVGElementPrototype::s_info = { "SVGSVGElementPrototype", 0, &JSSVGSVGElementPrototypeTable, 0 };

JSObject* JSSVGSVGElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSVGSVGElement>(exec);
}

bool JSSVGSVGElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSSVGSVGElementPrototype, JSObject>(exec, &JSSVGSVGElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGSVGElement::s_info = { "SVGSVGElement", &JSSVGElement::s_info, &JSSVGSVGElementTable, 0 };

JSSVGSVGElement::JSSVGSVGElement(PassRefPtr<Structure> structure, PassRefPtr<SVGSVGElement> impl)
    : JSSVGElement(structure, impl)
{
}

JSObject* JSSVGSVGElement::createPrototype(ExecState* exec)
{
    return new (exec) JSSVGSVGElementPrototype(JSSVGSVGElementPrototype::createStructure(JSSVGElementPrototype::self(exec)));
}

bool JSSVGSVGElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGSVGElement, Base>(exec, &JSSVGSVGElementTable, this, propertyName, slot);
}

JSValuePtr jsSVGSVGElementX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGSVGElementY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGSVGElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGSVGElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGSVGElementContentScriptType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->contentScriptType());
}

JSValuePtr jsSVGSVGElementContentStyleType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->contentStyleType());
}

JSValuePtr jsSVGSVGElementViewport(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, JSSVGStaticPODTypeWrapper<FloatRect>::create(imp->viewport()).get(), imp);
}

JSValuePtr jsSVGSVGElementPixelUnitToMillimeterX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->pixelUnitToMillimeterX());
}

JSValuePtr jsSVGSVGElementPixelUnitToMillimeterY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->pixelUnitToMillimeterY());
}

JSValuePtr jsSVGSVGElementScreenPixelToMillimeterX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->screenPixelToMillimeterX());
}

JSValuePtr jsSVGSVGElementScreenPixelToMillimeterY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->screenPixelToMillimeterY());
}

JSValuePtr jsSVGSVGElementUseCurrentView(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->useCurrentView());
}

JSValuePtr jsSVGSVGElementCurrentScale(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->currentScale());
}

JSValuePtr jsSVGSVGElementCurrentTranslate(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, JSSVGStaticPODTypeWrapperWithParent<FloatPoint, SVGSVGElement>::create(imp, &SVGSVGElement::currentTranslate, &SVGSVGElement::setCurrentTranslate).get(), imp);
}

JSValuePtr jsSVGSVGElementRequiredFeatures(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->requiredFeatures()), imp);
}

JSValuePtr jsSVGSVGElementRequiredExtensions(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->requiredExtensions()), imp);
}

JSValuePtr jsSVGSVGElementSystemLanguage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->systemLanguage()), imp);
}

JSValuePtr jsSVGSVGElementXmllang(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->xmllang());
}

JSValuePtr jsSVGSVGElementXmlspace(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->xmlspace());
}

JSValuePtr jsSVGSVGElementExternalResourcesRequired(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGSVGElementClassName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGSVGElementStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->style()));
}

JSValuePtr jsSVGSVGElementNearestViewportElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->nearestViewportElement()));
}

JSValuePtr jsSVGSVGElementFarthestViewportElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->farthestViewportElement()));
}

JSValuePtr jsSVGSVGElementViewBox(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedRect> obj = imp->viewBoxAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGSVGElementPreserveAspectRatio(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedPreserveAspectRatio> obj = imp->preserveAspectRatioAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGSVGElementZoomAndPan(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->zoomAndPan());
}

void JSSVGSVGElement::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSSVGSVGElement, Base>(exec, propertyName, value, &JSSVGSVGElementTable, this, slot);
}

void setJSSVGSVGElementContentScriptType(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(thisObject)->impl());
    imp->setContentScriptType(value->toString(exec));
}

void setJSSVGSVGElementContentStyleType(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(thisObject)->impl());
    imp->setContentStyleType(value->toString(exec));
}

void setJSSVGSVGElementUseCurrentView(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(thisObject)->impl());
    imp->setUseCurrentView(value->toBoolean(exec));
}

void setJSSVGSVGElementCurrentScale(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(thisObject)->impl());
    imp->setCurrentScale(value->toFloat(exec));
}

void setJSSVGSVGElementXmllang(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(thisObject)->impl());
    imp->setXmllang(value->toString(exec));
}

void setJSSVGSVGElementXmlspace(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(thisObject)->impl());
    imp->setXmlspace(value->toString(exec));
}

void setJSSVGSVGElementZoomAndPan(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(static_cast<JSSVGSVGElement*>(thisObject)->impl());
    imp->setZoomAndPan(value->toInt32(exec));
}

JSValuePtr jsSVGSVGElementPrototypeFunctionSuspendRedraw(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());
    unsigned maxWaitMilliseconds = args.at(exec, 0)->toInt32(exec);


    JSC::JSValuePtr result = jsNumber(exec, imp->suspendRedraw(maxWaitMilliseconds));
    return result;
}

JSValuePtr jsSVGSVGElementPrototypeFunctionUnsuspendRedraw(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    unsigned suspendHandleId = args.at(exec, 0)->toInt32(exec);

    imp->unsuspendRedraw(suspendHandleId, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValuePtr jsSVGSVGElementPrototypeFunctionUnsuspendRedrawAll(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());

    imp->unsuspendRedrawAll();
    return jsUndefined();
}

JSValuePtr jsSVGSVGElementPrototypeFunctionForceRedraw(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());

    imp->forceRedraw();
    return jsUndefined();
}

JSValuePtr jsSVGSVGElementPrototypeFunctionPauseAnimations(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());

    imp->pauseAnimations();
    return jsUndefined();
}

JSValuePtr jsSVGSVGElementPrototypeFunctionUnpauseAnimations(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());

    imp->unpauseAnimations();
    return jsUndefined();
}

JSValuePtr jsSVGSVGElementPrototypeFunctionAnimationsPaused(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());


    JSC::JSValuePtr result = jsBoolean(imp->animationsPaused());
    return result;
}

JSValuePtr jsSVGSVGElementPrototypeFunctionGetCurrentTime(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());


    JSC::JSValuePtr result = jsNumber(exec, imp->getCurrentTime());
    return result;
}

JSValuePtr jsSVGSVGElementPrototypeFunctionSetCurrentTime(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());
    float seconds = args.at(exec, 0)->toFloat(exec);

    imp->setCurrentTime(seconds);
    return jsUndefined();
}

JSValuePtr jsSVGSVGElementPrototypeFunctionGetIntersectionList(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());
    FloatRect rect = toSVGRect(args.at(exec, 0));
    SVGElement* referenceElement = toSVGElement(args.at(exec, 1));


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->getIntersectionList(rect, referenceElement)));
    return result;
}

JSValuePtr jsSVGSVGElementPrototypeFunctionGetEnclosureList(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());
    FloatRect rect = toSVGRect(args.at(exec, 0));
    SVGElement* referenceElement = toSVGElement(args.at(exec, 1));


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->getEnclosureList(rect, referenceElement)));
    return result;
}

JSValuePtr jsSVGSVGElementPrototypeFunctionCheckIntersection(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());
    SVGElement* element = toSVGElement(args.at(exec, 0));
    FloatRect rect = toSVGRect(args.at(exec, 1));


    JSC::JSValuePtr result = jsBoolean(imp->checkIntersection(element, rect));
    return result;
}

JSValuePtr jsSVGSVGElementPrototypeFunctionCheckEnclosure(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());
    SVGElement* element = toSVGElement(args.at(exec, 0));
    FloatRect rect = toSVGRect(args.at(exec, 1));


    JSC::JSValuePtr result = jsBoolean(imp->checkEnclosure(element, rect));
    return result;
}

JSValuePtr jsSVGSVGElementPrototypeFunctionDeselectAll(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());

    imp->deselectAll();
    return jsUndefined();
}

JSValuePtr jsSVGSVGElementPrototypeFunctionCreateSVGNumber(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<float>::create(imp->createSVGNumber()).get(), imp);
    return result;
}

JSValuePtr jsSVGSVGElementPrototypeFunctionCreateSVGLength(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<SVGLength>::create(imp->createSVGLength()).get(), imp);
    return result;
}

JSValuePtr jsSVGSVGElementPrototypeFunctionCreateSVGAngle(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createSVGAngle()), imp);
    return result;
}

JSValuePtr jsSVGSVGElementPrototypeFunctionCreateSVGPoint(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<FloatPoint>::create(imp->createSVGPoint()).get(), imp);
    return result;
}

JSValuePtr jsSVGSVGElementPrototypeFunctionCreateSVGMatrix(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->createSVGMatrix()).get(), imp);
    return result;
}

JSValuePtr jsSVGSVGElementPrototypeFunctionCreateSVGRect(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<FloatRect>::create(imp->createSVGRect()).get(), imp);
    return result;
}

JSValuePtr jsSVGSVGElementPrototypeFunctionCreateSVGTransform(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<SVGTransform>::create(imp->createSVGTransform()).get(), imp);
    return result;
}

JSValuePtr jsSVGSVGElementPrototypeFunctionCreateSVGTransformFromMatrix(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());
    TransformationMatrix matrix = toSVGMatrix(args.at(exec, 0));


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<SVGTransform>::create(imp->createSVGTransformFromMatrix(matrix)).get(), imp);
    return result;
}

JSValuePtr jsSVGSVGElementPrototypeFunctionHasExtension(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());
    const UString& extension = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = jsBoolean(imp->hasExtension(extension));
    return result;
}

JSValuePtr jsSVGSVGElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());
    const UString& name = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}

JSValuePtr jsSVGSVGElementPrototypeFunctionGetBBox(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<FloatRect>::create(imp->getBBox()).get(), imp);
    return result;
}

JSValuePtr jsSVGSVGElementPrototypeFunctionGetCTM(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getCTM()).get(), imp);
    return result;
}

JSValuePtr jsSVGSVGElementPrototypeFunctionGetScreenCTM(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getScreenCTM()).get(), imp);
    return result;
}

JSValuePtr jsSVGSVGElementPrototypeFunctionGetTransformToElement(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGSVGElement::s_info))
        return throwError(exec, TypeError);
    JSSVGSVGElement* castedThisObj = static_cast<JSSVGSVGElement*>(asObject(thisValue));
    SVGSVGElement* imp = static_cast<SVGSVGElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    SVGElement* element = toSVGElement(args.at(exec, 0));


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getTransformToElement(element, ec)).get(), imp);
    setDOMException(exec, ec);
    return result;
}

// Constant getters

JSValuePtr jsSVGSVGElementSVG_ZOOMANDPAN_UNKNOWN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValuePtr jsSVGSVGElementSVG_ZOOMANDPAN_DISABLE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValuePtr jsSVGSVGElementSVG_ZOOMANDPAN_MAGNIFY(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}


}

#endif // ENABLE(SVG)
