/****************************************************************************
**
** Copyright (C) 2008 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the tools applications of the Qt Toolkit.
**
** No Commercial Usage
** This file contains pre-release code and may only be used for
** evaluation and testing purposes.  It may not be used for commercial
** development.  You may use this file in accordance with the terms and
** conditions contained in the either Technology Preview License
** Agreement or the Beta Release License Agreement.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file.  Please review the following information
** to ensure GNU General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
** exception, Nokia gives you certain additional rights. These rights
** are described in the Nokia Qt GPL Exception version 1.3, included in
** the file GPL_EXCEPTION.txt in this package.
**
** Qt for Windows(R) Licensees
** As a special exception, Nokia, as the sole copyright holder for Qt
** Designer, grants users of the Qt/Eclipse Integration plug-in the
** right for the Qt/Eclipse Integration to link to functionality
** provided by Qt Designer and its related libraries.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
****************************************************************************/

/*
  uncompressor.cpp
*/

#include "uncompressor.h"

QT_BEGIN_NAMESPACE

QList<Uncompressor *> Uncompressor::uncompressors;


/*!
  \class Uncompressor
  
  \brief The Uncompressor class is a base class for classes that
  know how to uncompress a certain kind of compressed file.

  The uncompressor contains a list of the filename extensions
  of the file types that the uncompressor knows how to uncompress.

  It maintains a static list of all the instances of Uncompressor
  that have been created. It also has a static function for searching
  that list to find the uncompressor to use for uncompressing a file
  with a certain extension.
 */

/*!
  The constructor takes a list of filename extensions, which it
  copies and saves internally. This uncompressor is prepended
  to the stack list.
 */
Uncompressor::Uncompressor( const QStringList& extensions )
    : fileExts( extensions )
{
    uncompressors.prepend( this );
}

/*!
  The destructor deletes all the filename extensions.
 */
Uncompressor::~Uncompressor()
{
    uncompressors.removeAll( this );
}

/*!
  This function searches the static list of uncompressors to find the
  first one that can handle \a fileName. If it finds an acceptable
  uncompressor, it returns a pointer to it. Otherwise it returns null.
*/
Uncompressor*
Uncompressor::uncompressorForFileName( const QString& fileName )
{
    int dot = -1;
    while ( (dot = fileName.indexOf(".", dot + 1)) != -1 ) {
        QString ext = fileName.mid( dot + 1 );
        QList<Uncompressor *>::ConstIterator u = uncompressors.begin();
        while ( u != uncompressors.end() ) {
            if ( (*u)->fileExtensions().contains(ext) )
                return *u;
            ++u;
        }
    }
    return 0;
}

QT_END_NAMESPACE
