name = "up";

group = "stack";

shortDescription = "Select and print the stack frame above the current one";

longDescription = "";

seeAlso = [ "down", "frame" ];

function execute() {
    scheduleGetContextCount();
    state = 1;
}

function handleResponse(resp) {
    if (state == 1) {
        var count = resp.result;
        var idx = getCurrentFrameIndex() + 1;
        if (idx == count) {
            warning("Already at top (outermost) frame.");
            return;
        }
        setCurrentFrameIndex(idx);
        scheduleGetBacktrace();
        state = 2;
    } else if (state == 2) {
        var idx = getCurrentFrameIndex();
        message("#" + idx + "  " + resp.result[idx]);
    }
}
