/****************************************************************************
**
** Copyright (C) 2008 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the QtScriptTools module of the Qt Toolkit.
**
** No Commercial Usage
** This file contains pre-release code and may only be used for
** evaluation and testing purposes.  It may not be used for commercial
** development.  You may use this file in accordance with the terms and
** conditions contained in the either Technology Preview License
** Agreement or the Beta Release License Agreement.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file.  Please review the following information
** to ensure GNU General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
** exception, Nokia gives you certain additional rights. These rights
** are described in the Nokia Qt GPL Exception version 1.3, included in
** the file GPL_EXCEPTION.txt in this package.
**
** Qt for Windows(R) Licensees
** As a special exception, Nokia, as the sole copyright holder for Qt
** Designer, grants users of the Qt/Eclipse Integration plug-in the
** right for the Qt/Eclipse Integration to link to functionality
** provided by Qt Designer and its related libraries.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
****************************************************************************/

#ifndef QSCRIPTDEBUGGERBACKEND_P_H
#define QSCRIPTDEBUGGERBACKEND_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <QtCore/qobjectdefs.h>

#include <QtCore/qpair.h>

#include "qscriptbreakpointdata_p.h"
#include "qscriptscriptdata_p.h"

QT_BEGIN_NAMESPACE

class QScriptContext;
class QScriptEngine;
class QScriptDebuggerCommandExecutor;
class QScriptDebuggerEvent;
class QScriptValue;
class QScriptValueIterator;
class QScriptObjectSnapshot;
class QStringList;

typedef QPair<QList<qint64>, QList<qint64> > QScriptScriptsDelta;
typedef QPair<QList<qint64>, QList<qint64> > QScriptContextsDelta;

class QScriptDebuggerBackendPrivate;
class Q_AUTOTEST_EXPORT QScriptDebuggerBackend
{
public:
    QScriptDebuggerBackend();
    virtual ~QScriptDebuggerBackend();

    void attachTo(QScriptEngine *engine);
    void detach();

    QScriptEngine *engine() const;

    void stepInto(int count = 1);
    void stepOver(int count = 1);
    void stepOut();
    void continueEvalution();
    void interruptEvaluation();
    void runToLocation(const QString &fileName, int lineNumber);
    void runToLocation(qint64 scriptId, int lineNumber);
    void returnToCaller(int contextIndex, const QScriptValue &value);
    void evaluate(int contextIndex, const QString &program,
                  const QString &fileName, int lineNumber);

    int setBreakpoint(const QScriptBreakpointData &data);
    bool deleteBreakpoint(int id);
    void deleteAllBreakpoints();
    QScriptBreakpointData breakpointData(int id) const;
    bool setBreakpointData(int id, const QScriptBreakpointData &data);
    QScriptBreakpointMap breakpoints() const;

    QScriptScriptMap scripts() const;
    QScriptScriptData scriptData(qint64 id) const;
    void scriptsCheckpoint();
    QScriptScriptsDelta scriptsDelta() const;
    qint64 resolveScript(const QString &fileName) const;

    int contextCount() const;
    QScriptContext *context(int index) const;
    QStringList backtrace() const;
    QList<qint64> contextIds() const;
    QScriptContextsDelta contextsCheckpoint();

    int newScriptObjectSnapshot();
    QScriptObjectSnapshot *scriptObjectSnapshot(int id) const;
    void deleteScriptObjectSnapshot(int id);

    int newScriptValueIterator(const QScriptValue &object);
    QScriptValueIterator *scriptValueIterator(int id) const;
    void deleteScriptValueIterator(int id);

    QScriptValue traceFunction() const;
    QScriptValue assertFunction() const;
    QScriptValue fileNameFunction() const;
    QScriptValue lineNumberFunction() const;

    void doPendingEvaluate(bool postEvent);

    bool ignoreExceptions() const;
    void setIgnoreExceptions(bool ignore);

    // ### do we need these here?
    QScriptDebuggerCommandExecutor *commandExecutor() const;
    void setCommandExecutor(QScriptDebuggerCommandExecutor *executor);

protected:
    // ### should be a separate interface?
    // e.g. QScriptDebuggerBackendClient
    virtual void event(const QScriptDebuggerEvent &event) = 0;
    virtual void resume() = 0;

protected:
    QScriptDebuggerBackend(QScriptDebuggerBackendPrivate &dd);
    QScriptDebuggerBackendPrivate *d_ptr;

private:
    Q_DECLARE_PRIVATE(QScriptDebuggerBackend)
    Q_DISABLE_COPY(QScriptDebuggerBackend)
};

QT_END_NAMESPACE

#endif
