
#include <private/qcocoamenudelegate_mac_p.h>
#include <qmenu.h>
#include <qaction.h>

extern int qt_mac_menus_open_count; // qmenu_mac.mm
@implementation QCocoaMenuDelegate

- (id)init;
{
    self = [super init];
    if (self) {
        nsmenuToQMenuHash = new QHash<NSMenu *, QMenu *>();
    }
    return self;
}

- (void)dealloc;
{
    delete nsmenuToQMenuHash;
    [super dealloc];
}

- (void)insertIntoHashNSMenu:(NSMenu *)nsmenu qtmenu:(QMenu *)qmenu;
{
    nsmenuToQMenuHash->insert(nsmenu, qmenu);
}

- (void)menu:(NSMenu*)menu willHighlightItem:(NSMenuItem*)item;
{
    Q_UNUSED(menu);

    if (!item) {
        // ### According to the docs everything will be highlighted. Not sure what we should do in
        // Qt, so just return.
        return;
    }

    if (QAction *action = reinterpret_cast<QAction *>([item tag]))
        action->activate(QAction::Hover);
}

- (void)menuWillOpen:(NSMenu*)menu;
{
    if (QMenu *qmenu = nsmenuToQMenuHash->value(menu)) {
        qt_mac_emit_menuSignals(qmenu, true);
    }
}

- (void)menuWillClose:(NSMenu*)menu;
{
    if (QMenu *qmenu = nsmenuToQMenuHash->value(menu)) {
        qt_mac_emit_menuSignals(qmenu, false);
    }
}
@end

void qt_mac_emit_menuSignals(QMenu *menu, bool show)
{
    int delta;
    if (show) {
        emit menu->aboutToShow();
        delta = 1;
    } else {
        emit menu->aboutToHide();
        delta = -1;
    }
    qt_mac_menus_open_count += delta;
}
