//
//  QCocoaApplication.mm
//  QtGui
//
//  Created by Trenton Schulz on 4/29/08.
//  Copyright 2008 Trolltech. All rights reserved.
//

#include <qglobal.h>
#include <private/qcocoaapplication_mac_p.h>
#include <private/qcocoaapplicationdelegate_mac_p.h>
#include <private/qt_cocoa_helpers_mac_p.h>

@implementation NSApplication (QApplicationIntegration)

- (void)qt_setDockMenu:(NSMenu *)newMenu
{
    [[QCocoaApplicationDelegate sharedDelegate] setDockMenu:newMenu];
}

- (QApplicationPrivate *)qt_qappPrivate
{
    return [[QCocoaApplicationDelegate sharedDelegate] qAppPrivate];
}

- (QCocoaMenuLoader *)qt_qcocoamenuLoader
{
    return [[QCocoaApplicationDelegate sharedDelegate] menuLoader];
}

- (int)qt_validModesForFontPanel:(NSFontPanel *)fontPanel
{
    Q_UNUSED(fontPanel);
    // only display those things that QFont can handle
    return NSFontPanelFaceModeMask
            | NSFontPanelSizeModeMask
            | NSFontPanelCollectionModeMask
            | NSFontPanelUnderlineEffectModeMask
            | NSFontPanelStrikethroughEffectModeMask;
}

@end
