/****************************************************************************
**
** Copyright (C) 2008 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** No Commercial Usage
** This file contains pre-release code and may only be used for
** evaluation and testing purposes.  It may not be used for commercial
** development.  You may use this file in accordance with the terms and
** conditions contained in the either Technology Preview License
** Agreement or the Beta Release License Agreement.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file.  Please review the following information
** to ensure GNU General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
** exception, Nokia gives you certain additional rights. These rights
** are described in the Nokia Qt GPL Exception version 1.3, included in
** the file GPL_EXCEPTION.txt in this package.
**
** Qt for Windows(R) Licensees
** As a special exception, Nokia, as the sole copyright holder for Qt
** Designer, grants users of the Qt/Eclipse Integration plug-in the
** right for the Qt/Eclipse Integration to link to functionality
** provided by Qt Designer and its related libraries.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
****************************************************************************/

#include <qdialogbuttonbox.h>
#if defined(Q_WS_MAC)
#include <private/qt_mac_p.h>
#import <AppKit/AppKit.h>
#import <Foundation/Foundation.h>
#import <objc/objc-class.h>

QT_BEGIN_NAMESPACE
static QWidget *currentWindow = 0;
QT_END_NAMESPACE

QT_USE_NAMESPACE

@class QNSPanelProxy;

@interface QNSPanelProxy : NSWindow {
}
- (id)initWithContentRect:(NSRect)contentRect styleMask:(NSUInteger)windowStyle
    backing:(NSBackingStoreType)bufferingType defer:(BOOL)deferCreation;
- (id)initWithContentRect:(NSRect)contentRect styleMask:(NSUInteger)windowStyle
    backing:(NSBackingStoreType)bufferingType defer:(BOOL)deferCreation screen:(NSScreen *)screen;
- (id)qt_fakeInitWithContentRect:(NSRect)contentRect styleMask:(NSUInteger)windowStyle
    backing:(NSBackingStoreType)bufferingType defer:(BOOL)deferCreation;
- (id)qt_fakeInitWithContentRect:(NSRect)contentRect styleMask:(NSUInteger)windowStyle
    backing:(NSBackingStoreType)bufferingType defer:(BOOL)deferCreation screen:(NSScreen *)screen;
@end

@implementation QNSPanelProxy
- (id)initWithContentRect:(NSRect)contentRect styleMask:(NSUInteger)windowStyle
      backing:(NSBackingStoreType)bufferingType defer:(BOOL)deferCreation
{
    // remove evil flag
    windowStyle &= ~NSUtilityWindowMask;
	self = [self qt_fakeInitWithContentRect:contentRect styleMask:windowStyle
	                                backing:bufferingType defer:deferCreation];
    return self;
}

- (id)initWithContentRect:(NSRect)contentRect styleMask:(NSUInteger)windowStyle
      backing:(NSBackingStoreType)bufferingType defer:(BOOL)deferCreation screen:(NSScreen *)screen
{
    // remove evil flag
    windowStyle &= ~NSUtilityWindowMask;
	return [self qt_fakeInitWithContentRect:contentRect styleMask:windowStyle
	                                backing:bufferingType defer:deferCreation screen:screen];
}

- (id)qt_fakeInitWithContentRect:(NSRect)contentRect styleMask:(NSUInteger)windowStyle
    backing:(NSBackingStoreType)bufferingType defer:(BOOL)deferCreation
{
    Q_UNUSED(contentRect);
    Q_UNUSED(windowStyle);
    Q_UNUSED(bufferingType);
    Q_UNUSED(deferCreation);
    return nil;
}

- (id)qt_fakeInitWithContentRect:(NSRect)contentRect styleMask:(NSUInteger)windowStyle
    backing:(NSBackingStoreType)bufferingType defer:(BOOL)deferCreation screen:(NSScreen *)screen
{
    Q_UNUSED(contentRect);
    Q_UNUSED(windowStyle);
    Q_UNUSED(bufferingType);
    Q_UNUSED(deferCreation);
    Q_UNUSED(screen);
    return nil;
}
@end

@class QNSWindowProxy;

@interface QNSWindowProxy : NSWindow {
}
- (void)setTitle:(NSString *)title;
- (void)qt_fakeSetTitle:(NSString *)title;
@end

@implementation QNSWindowProxy
- (void)setTitle:(NSString *)title
{
    QCFString cftitle(currentWindow->windowTitle());

    // evil reverse engineering
    if ([title isEqualToString:@"Print"]
            || [title isEqualToString:@"Page Setup"]
            || [[self className] isEqualToString:@"PMPrintingWindow"])
        title = (NSString *)(static_cast<CFStringRef>(cftitle));
    return [self qt_fakeSetTitle:title];
}

- (void)qt_fakeSetTitle:(NSString *)title
{
    Q_UNUSED(title);
}
@end

QT_BEGIN_NAMESPACE

void macStartIntercept(SEL originalSel, SEL fakeSel, Class baseClass, Class proxyClass)
{
#ifndef QT_MAC_USE_COCOA
    if (QSysInfo::MacintoshVersion >= QSysInfo::MV_10_5)
#endif
    {
#if MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_5
        Method originalMethod = class_getInstanceMethod(baseClass, originalSel);
        Method newMethod = class_getInstanceMethod(proxyClass, originalSel);
        Method fakeMethod = class_getInstanceMethod(proxyClass, fakeSel);

        IMP originalCtorImp = method_setImplementation(originalMethod,
                                                       method_getImplementation(newMethod));
        class_addMethod(baseClass, fakeSel, originalCtorImp,
                        method_getTypeEncoding(fakeMethod));
#endif
    }
}

void macStopIntercept(SEL originalSel, SEL fakeSel, Class baseClass, Class /* proxyClass */)
{
#ifndef QT_MAC_USE_COCOA
    if (QSysInfo::MacintoshVersion >= QSysInfo::MV_10_5)
#endif
    {
#if MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_5
        Method originalMethod = class_getInstanceMethod(baseClass, originalSel);
        Method fakeMethodInBaseClass = class_getInstanceMethod(baseClass, fakeSel);
        method_setImplementation(originalMethod, method_getImplementation(fakeMethodInBaseClass));
#endif
    }
}

/*
    Intercept the NSColorPanel constructor if the shared
    color panel doesn't exist yet. What's going on here is
    quite wacky, because we want to override the NSPanel
    constructor and at the same time call the old NSPanel
    constructor. So what we do is we effectively rename the
    old NSPanel constructor qt_fakeInitWithContentRect:...
    and have the new one call the old one.
*/
void macStartInterceptNSPanelCtor()
{
    macStartIntercept(@selector(initWithContentRect:styleMask:backing:defer:),
                      @selector(qt_fakeInitWithContentRect:styleMask:backing:defer:),
                      [NSPanel class], [QNSPanelProxy class]);
    macStartIntercept(@selector(initWithContentRect:styleMask:backing:defer:screen:),
                      @selector(qt_fakeInitWithContentRect:styleMask:backing:defer:screen:),
                      [NSPanel class], [QNSPanelProxy class]);
}

/*
    Restore things as they were.
*/
void macStopInterceptNSPanelCtor()
{
    macStopIntercept(@selector(initWithContentRect:styleMask:backing:defer:screen:),
                     @selector(qt_fakeInitWithContentRect:styleMask:backing:defer:screen:),
                     [NSPanel class], [QNSPanelProxy class]);
    macStopIntercept(@selector(initWithContentRect:styleMask:backing:defer:),
                     @selector(qt_fakeInitWithContentRect:styleMask:backing:defer:),
                     [NSPanel class], [QNSPanelProxy class]);
}

/*
    Intercept the NSPrintPanel and NSPageLayout setTitle: calls. The
    hack is similar as for NSColorPanel above.
*/
void macStartInterceptWindowTitle(QWidget *window)
{
    currentWindow = window;
    macStartIntercept(@selector(setTitle:), @selector(qt_fakeSetTitle:),
                      [NSWindow class], [QNSWindowProxy class]);
}

/*
    Restore things as they were.
*/
void macStopInterceptWindowTitle()
{
    currentWindow = 0;
    macStopIntercept(@selector(setTitle:), @selector(qt_fakeSetTitle:),
                     [NSWindow class], [QNSWindowProxy class]);
}

/*
    Doesn't really belong in here.
*/
NSButton *macCreateButton(const char *text, NSView *superview)
{
    static const NSRect buttonFrameRect = { { 0.0, 0.0 }, { 0.0, 0.0 } };

    NSButton *button = [[NSButton alloc] initWithFrame:buttonFrameRect];
    [button setButtonType:NSMomentaryLightButton];
    [button setBezelStyle:NSRoundedBezelStyle];
    [button setTitle:(NSString*)(CFStringRef)QCFString(QDialogButtonBox::tr(text)
                                                       .remove(QLatin1Char('&')))];
    [[button cell] setFont:[NSFont systemFontOfSize:
            [NSFont systemFontSizeForControlSize:NSRegularControlSize]]];
    [superview addSubview:button];
    return button;
}

QT_END_NAMESPACE

#endif
