/****************************************************************************
**
** Copyright (C) 2008 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the QtCore module of the Qt Toolkit.
**
** No Commercial Usage
** This file contains pre-release code and may only be used for
** evaluation and testing purposes.  It may not be used for commercial
** development.  You may use this file in accordance with the terms and
** conditions contained in the either Technology Preview License
** Agreement or the Beta Release License Agreement.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file.  Please review the following information
** to ensure GNU General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
** exception, Nokia gives you certain additional rights. These rights
** are described in the Nokia Qt GPL Exception version 1.3, included in
** the file GPL_EXCEPTION.txt in this package.
**
** Qt for Windows(R) Licensees
** As a special exception, Nokia, as the sole copyright holder for Qt
** Designer, grants users of the Qt/Eclipse Integration plug-in the
** right for the Qt/Eclipse Integration to link to functionality
** provided by Qt Designer and its related libraries.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
****************************************************************************/

#ifndef QLOCALE_DATA_P_H
#define QLOCALE_DATA_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of qapplication_*.cpp, qwidget*.cpp and qfiledialog.cpp.  This header
// file may change from version to version without notice, or even be removed.
//
// We mean it.
//

QT_BEGIN_NAMESPACE

/* This part of the file isn't generated, but written by hand since
 * Unicode CLDR doesn't contain measurement system information.
 */
struct CountryLanguage
{
    quint32 languageId;
    quint32 countryId;
};
static const CountryLanguage ImperialMeasurementSystems[] = {
    { 31, 225 },
    { 31, 226 },
    { 111, 225 },
    { 163, 225 }
};
static const int ImperialMeasurementSystemsCount =
    sizeof(ImperialMeasurementSystems)/sizeof(ImperialMeasurementSystems[0]);

/*
    This part of the file was generated on 2008-08-07 from the
    Common Locale Data Repository v1.6.1

    http://www.unicode.org/cldr/

    Do not change it, instead edit $QTDIR/util/locale_database/locale.xml and run
    qlocalexml2cpp.py.
*/


static const QChar locale_lang119_terr100_am[] = { QChar(0xc2a), QChar(0xc42), QChar(0xc30), QChar(0xc4d), QChar(0xc35), QChar(0xc3e), QChar(0xc39), QChar(0xc4d), QChar(0xc28), QChar(0xc02) };
static const QChar locale_lang119_terr100_pm[] = { QChar(0xc05), QChar(0xc2a), QChar(0xc30), QChar(0xc3e), QChar(0xc39), QChar(0xc4d), QChar(0xc28), QChar(0xc02) };
static const QChar locale_lang106_terr198_am[] = { QChar(0xdb4), QChar(0xdd9), QChar(0x2e), QChar(0xdc0), QChar(0x2e) };
static const QChar locale_lang106_terr198_pm[] = { QChar(0xdb4), QChar(0x2e), QChar(0xdc0), QChar(0x2e) };
static const QChar locale_lang36_terr73_am[] = { QChar(0x61), QChar(0x70), QChar(0x2e) };
static const QChar locale_lang36_terr73_pm[] = { QChar(0x69), QChar(0x70), QChar(0x2e) };
static const QChar locale_lang46_terr100_am[] = { QChar(0xaaa), QChar(0xac2), QChar(0xab0), QChar(0xacd), QChar(0xab5), QChar(0xa0), QChar(0xaae), QChar(0xaa7), QChar(0xacd), QChar(0xaaf), QChar(0xabe), QChar(0xab9), QChar(0xacd), QChar(0xaa8) };
static const QChar locale_lang46_terr100_pm[] = { QChar(0xa89), QChar(0xaa4), QChar(0xacd), QChar(0xaa4), QChar(0xab0), QChar(0xa0), QChar(0xaae), QChar(0xaa7), QChar(0xacd), QChar(0xaaf), QChar(0xabe), QChar(0xab9), QChar(0xacd), QChar(0xaa8) };
static const QChar locale_lang31_terr240_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang31_terr240_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang100_terr238_am[] = { QChar(0x43f), QChar(0x440), QChar(0x435), QChar(0x43f), QChar(0x43e), QChar(0x434), QChar(0x43d), QChar(0x435) };
static const QChar locale_lang100_terr238_pm[] = { QChar(0x43f), QChar(0x43e), QChar(0x43f), QChar(0x43e), QChar(0x434), QChar(0x43d), QChar(0x435) };
static const QChar locale_lang42_terr82_am[] = { QChar(0x76), QChar(0x6f), QChar(0x72), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang42_terr82_pm[] = { QChar(0x6e), QChar(0x61), QChar(0x63), QChar(0x68), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang37_terr142_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang37_terr142_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang111_terr139_am[] = { QChar(0x61), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang111_terr139_pm[] = { QChar(0x70), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang110_terr111_am[] = { QChar(0x73), QChar(0x6e) };
static const QChar locale_lang110_terr111_pm[] = { QChar(0x67), QChar(0x6e) };
static const QChar locale_lang31_terr195_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang31_terr195_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang5_terr195_am[] = { QChar(0x76), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang5_terr195_pm[] = { QChar(0x6e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang111_terr90_am[] = { QChar(0x61), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang111_terr90_pm[] = { QChar(0x70), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang80_terr100_am[] = { QChar(0x92e), QChar(0x2e), QChar(0x92a), QChar(0x942), QChar(0x2e) };
static const QChar locale_lang80_terr100_pm[] = { QChar(0x92e), QChar(0x2e), QChar(0x928), QChar(0x902), QChar(0x2e) };
static const QChar locale_lang78_terr133_am[] = { QChar(0x51), QChar(0x4e) };
static const QChar locale_lang78_terr133_pm[] = { QChar(0x57), QChar(0x4e) };
static const QChar locale_lang111_terr10_am[] = { QChar(0x61), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang111_terr10_pm[] = { QChar(0x70), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang101_terr238_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang101_terr238_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang111_terr52_am[] = { QChar(0x61), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang111_terr52_pm[] = { QChar(0x70), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang31_terr22_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang31_terr22_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang111_terr227_am[] = { QChar(0x61), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang111_terr227_pm[] = { QChar(0x70), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang15_terr18_am[] = { QChar(0x9aa), QChar(0x9c2), QChar(0x9b0), QChar(0x9cd), QChar(0x9ac), QChar(0x9be), QChar(0x9b9), QChar(0x9cd), QChar(0x9a3) };
static const QChar locale_lang15_terr18_pm[] = { QChar(0x985), QChar(0x9aa), QChar(0x9b0), QChar(0x9be), QChar(0x9b9), QChar(0x9cd), QChar(0x9a3) };
static const QChar locale_lang37_terr38_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang37_terr38_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang96_terr178_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang96_terr178_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang73_terr124_am[] = { QChar(0x70), QChar(0x72), QChar(0x69), QChar(0x65), QChar(0x161), QChar(0x70), QChar(0x69), QChar(0x65), QChar(0x74) };
static const QChar locale_lang73_terr124_pm[] = { QChar(0x70), QChar(0x6f), QChar(0x70), QChar(0x69), QChar(0x65), QChar(0x74) };
static const QChar locale_lang129_terr222_am[] = { QChar(0x434), QChar(0x43f) };
static const QChar locale_lang129_terr222_pm[] = { QChar(0x43f), QChar(0x43f) };
static const QChar locale_lang58_terr206_am[] = { QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang58_terr206_pm[] = { QChar(0x70), QChar(0x2e) };
static const QChar locale_lang47_terr201_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang47_terr201_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang8_terr145_am[] = { QChar(0x635) };
static const QChar locale_lang8_terr145_pm[] = { QChar(0x645) };
static const QChar locale_lang31_terr21_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang31_terr21_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang90_terr172_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang90_terr172_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang8_terr175_am[] = { QChar(0x635) };
static const QChar locale_lang8_terr175_pm[] = { QChar(0x645) };
static const QChar locale_lang31_terr38_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang31_terr38_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang111_terr197_am[] = { QChar(0x61), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang111_terr197_pm[] = { QChar(0x70), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang8_terr162_am[] = { QChar(0x635) };
static const QChar locale_lang8_terr162_pm[] = { QChar(0x645) };
static const QChar locale_lang66_terr114_am[] = { QChar(0xc624), QChar(0xc804) };
static const QChar locale_lang66_terr114_pm[] = { QChar(0xc624), QChar(0xd6c4) };
static const QChar locale_lang147_terr100_am[] = { QChar(0x92e), QChar(0x2e), QChar(0x92a), QChar(0x942), QChar(0x2e) };
static const QChar locale_lang147_terr100_pm[] = { QChar(0x92e), QChar(0x2e), QChar(0x928), QChar(0x902), QChar(0x2e) };
static const QChar locale_lang25_terr44_am[] = { QChar(0x4e0a), QChar(0x5348) };
static const QChar locale_lang25_terr44_pm[] = { QChar(0x4e0b), QChar(0x5348) };
static const QChar locale_lang111_terr47_am[] = { QChar(0x61), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang111_terr47_pm[] = { QChar(0x70), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang5_terr148_am[] = { QChar(0x76), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang5_terr148_pm[] = { QChar(0x6e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang31_terr13_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang31_terr13_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang31_terr89_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang31_terr89_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang31_terr148_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang31_terr148_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang138_terr157_am[] = { QChar(0xe0), QChar(0xe1), QChar(0x72), QChar(0x1ecd), QChar(0x300) };
static const QChar locale_lang138_terr157_pm[] = { QChar(0x1ecd), QChar(0x300), QChar(0x73), QChar(0xe1), QChar(0x6e) };
static const QChar locale_lang59_terr108_am[] = { QChar(0x5348), QChar(0x524d) };
static const QChar locale_lang59_terr108_pm[] = { QChar(0x5348), QChar(0x5f8c) };
static const QChar locale_lang122_terr69_am[] = { QChar(0x1295), QChar(0x1309), QChar(0x1206), QChar(0x20), QChar(0x1230), QChar(0x12d3), QChar(0x1270) };
static const QChar locale_lang122_terr69_pm[] = { QChar(0x12f5), QChar(0x1215), QChar(0x122d), QChar(0x20), QChar(0x1230), QChar(0x12d3), QChar(0x1275) };
static const QChar locale_lang100_terr27_am[] = { QChar(0x43f), QChar(0x440), QChar(0x435), QChar(0x43f), QChar(0x43e), QChar(0x434), QChar(0x43d), QChar(0x435) };
static const QChar locale_lang100_terr27_pm[] = { QChar(0x43f), QChar(0x43e), QChar(0x43f), QChar(0x43e), QChar(0x434), QChar(0x43d), QChar(0x435) };
static const QChar locale_lang91_terr30_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang91_terr30_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang61_terr100_am[] = { QChar(0xcaa), QChar(0xcc2), QChar(0xcb0), QChar(0xccd), QChar(0xcb5), QChar(0xcbe), QChar(0xcb9), QChar(0xccd), QChar(0xca8) };
static const QChar locale_lang61_terr100_pm[] = { QChar(0xc85), QChar(0xcaa), QChar(0xcb0), QChar(0xcbe), QChar(0xcb9), QChar(0xccd), QChar(0xca8) };
static const QChar locale_lang31_terr160_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang31_terr160_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang111_terr65_am[] = { QChar(0x61), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang111_terr65_pm[] = { QChar(0x70), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang110_terr59_am[] = { QChar(0x73), QChar(0x6e) };
static const QChar locale_lang110_terr59_pm[] = { QChar(0x67), QChar(0x6e) };
static const QChar locale_lang42_terr21_am[] = { QChar(0x76), QChar(0x6f), QChar(0x72), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang42_terr21_pm[] = { QChar(0x6e), QChar(0x61), QChar(0x63), QChar(0x68), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang43_terr85_am[] = { QChar(0x3c0), QChar(0x2e), QChar(0x3bc), QChar(0x2e) };
static const QChar locale_lang43_terr85_pm[] = { QChar(0x3bc), QChar(0x2e), QChar(0x3bc), QChar(0x2e) };
static const QChar locale_lang42_terr125_am[] = { QChar(0x76), QChar(0x6f), QChar(0x72), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang42_terr125_pm[] = { QChar(0x6e), QChar(0x61), QChar(0x63), QChar(0x68), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang37_terr125_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang37_terr125_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang27_terr54_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang27_terr54_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang37_terr74_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang37_terr74_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang110_terr69_am[] = { QChar(0x73), QChar(0x6e) };
static const QChar locale_lang110_terr69_pm[] = { QChar(0x67), QChar(0x6e) };
static const QChar locale_lang50_terr98_am[] = { QChar(0x64), QChar(0x65), QChar(0x2e) };
static const QChar locale_lang50_terr98_pm[] = { QChar(0x64), QChar(0x75), QChar(0x2e) };
static const QChar locale_lang31_terr4_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang31_terr4_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang122_terr67_am[] = { QChar(0x1295), QChar(0x1309), QChar(0x1206), QChar(0x20), QChar(0x1230), QChar(0x12d3), QChar(0x1270) };
static const QChar locale_lang122_terr67_pm[] = { QChar(0x12f5), QChar(0x1215), QChar(0x122d), QChar(0x20), QChar(0x1230), QChar(0x12d3), QChar(0x1275) };
static const QChar locale_lang111_terr169_am[] = { QChar(0x61), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang111_terr169_pm[] = { QChar(0x70), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang111_terr225_am[] = { QChar(0x61), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang111_terr225_pm[] = { QChar(0x70), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang37_terr206_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang37_terr206_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang88_terr1_am[] = { QChar(0x63a), QChar(0x2e), QChar(0x645), QChar(0x2e) };
static const QChar locale_lang88_terr1_pm[] = { QChar(0x63a), QChar(0x2e), QChar(0x648), QChar(0x2e) };
static const QChar locale_lang42_terr206_am[] = { QChar(0x76), QChar(0x6f), QChar(0x72), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang42_terr206_pm[] = { QChar(0x6e), QChar(0x61), QChar(0x63), QChar(0x68), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang114_terr73_am[] = { QChar(0x66), QChar(0x6d) };
static const QChar locale_lang114_terr73_pm[] = { QChar(0x65), QChar(0x6d) };
static const QChar locale_lang1_terr0_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang1_terr0_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang8_terr3_am[] = { QChar(0x635) };
static const QChar locale_lang8_terr3_pm[] = { QChar(0x645) };
static const QChar locale_lang92_terr100_am[] = { QChar(0xa38), QChar(0xa35), QChar(0xa47), QChar(0xa30), QChar(0xa47) };
static const QChar locale_lang92_terr100_pm[] = { QChar(0xa38), QChar(0xa3c), QChar(0xa3e), QChar(0xa2e) };
static const QChar locale_lang20_terr33_am[] = { QChar(0x43f), QChar(0x440), QChar(0x2e), QChar(0x20), QChar(0x43e), QChar(0x431), QChar(0x2e) };
static const QChar locale_lang20_terr33_pm[] = { QChar(0x441), QChar(0x43b), QChar(0x2e), QChar(0x20), QChar(0x43e), QChar(0x431), QChar(0x2e) };
static const QChar locale_lang92_terr163_am[] = { QChar(0xa38), QChar(0xa35), QChar(0xa47), QChar(0xa30), QChar(0xa47) };
static const QChar locale_lang92_terr163_pm[] = { QChar(0xa38), QChar(0xa3c), QChar(0xa3e), QChar(0xa2e) };
static const QChar locale_lang91_terr173_am[] = { QChar(0x41), QChar(0x6e), QChar(0x74), QChar(0x65), QChar(0x73), QChar(0x20), QChar(0x64), QChar(0x6f), QChar(0x20), QChar(0x6d), QChar(0x65), QChar(0x69), QChar(0x6f), QChar(0x2d), QChar(0x64), QChar(0x69), QChar(0x61) };
static const QChar locale_lang91_terr173_pm[] = { QChar(0x44), QChar(0x65), QChar(0x70), QChar(0x6f), QChar(0x69), QChar(0x73), QChar(0x20), QChar(0x64), QChar(0x6f), QChar(0x20), QChar(0x6d), QChar(0x65), QChar(0x69), QChar(0x6f), QChar(0x2d), QChar(0x64), QChar(0x69), QChar(0x61) };
static const QChar locale_lang111_terr166_am[] = { QChar(0x61), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang111_terr166_pm[] = { QChar(0x70), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang47_terr157_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang47_terr157_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang58_terr106_am[] = { QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang58_terr106_pm[] = { QChar(0x70), QChar(0x2e) };
static const QChar locale_lang47_terr83_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang47_terr83_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang31_terr190_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang31_terr190_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang101_terr27_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang101_terr27_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang31_terr154_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang31_terr154_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang15_terr100_am[] = { QChar(0x9aa), QChar(0x9c2), QChar(0x9b0), QChar(0x9cd), QChar(0x9ac), QChar(0x9be), QChar(0x9b9), QChar(0x9cd), QChar(0x9a3) };
static const QChar locale_lang15_terr100_pm[] = { QChar(0x985), QChar(0x9aa), QChar(0x9b0), QChar(0x9be), QChar(0x9b9), QChar(0x9cd), QChar(0x9a3) };
static const QChar locale_lang6_terr2_am[] = { QChar(0x50), QChar(0x44) };
static const QChar locale_lang6_terr2_pm[] = { QChar(0x4d), QChar(0x44) };
static const QChar locale_lang111_terr168_am[] = { QChar(0x61), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang111_terr168_pm[] = { QChar(0x70), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang31_terr226_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang31_terr226_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang43_terr56_am[] = { QChar(0x3c0), QChar(0x2e), QChar(0x3bc), QChar(0x2e) };
static const QChar locale_lang43_terr56_pm[] = { QChar(0x3bc), QChar(0x2e), QChar(0x3bc), QChar(0x2e) };
static const QChar locale_lang29_terr58_am[] = { QChar(0x66), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang29_terr58_pm[] = { QChar(0x65), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang23_terr36_am[] = { QChar(0x1796), QChar(0x17d2), QChar(0x179a), QChar(0x17b9), QChar(0x1780) };
static const QChar locale_lang23_terr36_pm[] = { QChar(0x179b), QChar(0x17d2), QChar(0x1784), QChar(0x17b6), QChar(0x1785) };
static const QChar locale_lang22_terr20_am[] = { QChar(0x434), QChar(0x430), QChar(0x20), QChar(0x43f), QChar(0x430), QChar(0x43b), QChar(0x443), QChar(0x434), QChar(0x43d), QChar(0x44f) };
static const QChar locale_lang22_terr20_pm[] = { QChar(0x43f), QChar(0x430), QChar(0x441), QChar(0x43b), QChar(0x44f), QChar(0x20), QChar(0x43f), QChar(0x430), QChar(0x43b), QChar(0x443), QChar(0x434), QChar(0x43d), QChar(0x44f) };
static const QChar locale_lang10_terr100_am[] = { QChar(0x9aa), QChar(0x9c2), QChar(0x9f0), QChar(0x9cd), QChar(0x9ac), QChar(0x9be) };
static const QChar locale_lang10_terr100_pm[] = { QChar(0x985), QChar(0x9aa) };
static const QChar locale_lang132_terr232_am[] = { QChar(0x53), QChar(0x41) };
static const QChar locale_lang132_terr232_pm[] = { QChar(0x43), QChar(0x48) };
static const QChar locale_lang28_terr57_am[] = { QChar(0x64), QChar(0x6f), QChar(0x70), QChar(0x2e) };
static const QChar locale_lang28_terr57_pm[] = { QChar(0x6f), QChar(0x64), QChar(0x70), QChar(0x2e) };
static const QChar locale_lang100_terr241_am[] = { QChar(0x43f), QChar(0x440), QChar(0x435), QChar(0x43f), QChar(0x43e), QChar(0x434), QChar(0x43d), QChar(0x435) };
static const QChar locale_lang100_terr241_pm[] = { QChar(0x43f), QChar(0x43e), QChar(0x43f), QChar(0x43e), QChar(0x434), QChar(0x43d), QChar(0x435) };
static const QChar locale_lang111_terr43_am[] = { QChar(0x61), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang111_terr43_pm[] = { QChar(0x70), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang9_terr11_am[] = { QChar(0x531), QChar(0x57c), QChar(0x2024) };
static const QChar locale_lang9_terr11_pm[] = { QChar(0x535), QChar(0x580), QChar(0x2024) };
static const QChar locale_lang25_terr97_am[] = { QChar(0x4e0a), QChar(0x5348) };
static const QChar locale_lang25_terr97_pm[] = { QChar(0x4e0b), QChar(0x5348) };
static const QChar locale_lang85_terr161_am[] = { QChar(0x66), QChar(0x6f), QChar(0x72), QChar(0x6d), QChar(0x69), QChar(0x64), QChar(0x64), QChar(0x61), QChar(0x67) };
static const QChar locale_lang85_terr161_pm[] = { QChar(0x65), QChar(0x74), QChar(0x74), QChar(0x65), QChar(0x72), QChar(0x6d), QChar(0x69), QChar(0x64), QChar(0x64), QChar(0x61), QChar(0x67) };
static const QChar locale_lang111_terr155_am[] = { QChar(0x61), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang111_terr155_pm[] = { QChar(0x70), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang145_terr224_am[] = { QChar(0x61), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang145_terr224_pm[] = { QChar(0x70), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang31_terr170_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang31_terr170_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang31_terr104_am[] = { QChar(0x61), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang31_terr104_pm[] = { QChar(0x70), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang114_terr205_am[] = { QChar(0x66), QChar(0x6d) };
static const QChar locale_lang114_terr205_pm[] = { QChar(0x65), QChar(0x6d) };
static const QChar locale_lang111_terr63_am[] = { QChar(0x61), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang111_terr63_pm[] = { QChar(0x70), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang111_terr61_am[] = { QChar(0x61), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang111_terr61_pm[] = { QChar(0x70), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang8_terr216_am[] = { QChar(0x635) };
static const QChar locale_lang8_terr216_pm[] = { QChar(0x645) };
static const QChar locale_lang8_terr109_am[] = { QChar(0x635) };
static const QChar locale_lang8_terr109_pm[] = { QChar(0x645) };
static const QChar locale_lang101_terr241_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang101_terr241_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang8_terr115_am[] = { QChar(0x635) };
static const QChar locale_lang8_terr115_pm[] = { QChar(0x645) };
static const QChar locale_lang42_terr14_am[] = { QChar(0x76), QChar(0x6f), QChar(0x72), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang42_terr14_pm[] = { QChar(0x6e), QChar(0x61), QChar(0x63), QChar(0x68), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang37_terr21_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang37_terr21_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang31_terr225_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang31_terr225_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang8_terr186_am[] = { QChar(0x635) };
static const QChar locale_lang8_terr186_pm[] = { QChar(0x645) };
static const QChar locale_lang8_terr207_am[] = { QChar(0x635) };
static const QChar locale_lang8_terr207_pm[] = { QChar(0x645) };
static const QChar locale_lang141_terr161_am[] = { QChar(0x66), QChar(0x6f), QChar(0x72), QChar(0x6d), QChar(0x69), QChar(0x64), QChar(0x64), QChar(0x61), QChar(0x67) };
static const QChar locale_lang141_terr161_pm[] = { QChar(0x65), QChar(0x74), QChar(0x74), QChar(0x65), QChar(0x72), QChar(0x6d), QChar(0x69), QChar(0x64), QChar(0x64), QChar(0x61), QChar(0x67) };
static const QChar locale_lang31_terr134_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang31_terr134_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang25_terr190_am[] = { QChar(0x4e0a), QChar(0x5348) };
static const QChar locale_lang25_terr190_pm[] = { QChar(0x4e0b), QChar(0x5348) };
static const QChar locale_lang48_terr105_am[] = { QChar(0x5dc), QChar(0x5e4), QChar(0x5e0), QChar(0x5d4), QChar(0x22), QChar(0x5e6) };
static const QChar locale_lang48_terr105_pm[] = { QChar(0x5d0), QChar(0x5d7), QChar(0x5d4), QChar(0x22), QChar(0x5e6) };
static const QChar locale_lang111_terr96_am[] = { QChar(0x61), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang111_terr96_pm[] = { QChar(0x70), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang47_terr156_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang47_terr156_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang111_terr231_am[] = { QChar(0x61), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang111_terr231_pm[] = { QChar(0x70), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang57_terr104_am[] = { QChar(0x61), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang57_terr104_pm[] = { QChar(0x70), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang120_terr211_am[] = { QChar(0xe01), QChar(0xe48), QChar(0xe2d), QChar(0xe19), QChar(0xe40), QChar(0xe17), QChar(0xe35), QChar(0xe48), QChar(0xe22), QChar(0xe07) };
static const QChar locale_lang120_terr211_pm[] = { QChar(0xe2b), QChar(0xe25), QChar(0xe31), QChar(0xe07), QChar(0xe40), QChar(0xe17), QChar(0xe35), QChar(0xe48), QChar(0xe22), QChar(0xe07) };
static const QChar locale_lang31_terr133_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang31_terr133_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang8_terr223_am[] = { QChar(0x635) };
static const QChar locale_lang8_terr223_pm[] = { QChar(0x645) };
static const QChar locale_lang144_terr224_am[] = { QChar(0x61), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang144_terr224_pm[] = { QChar(0x70), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang8_terr103_am[] = { QChar(0x635) };
static const QChar locale_lang8_terr103_pm[] = { QChar(0x645) };
static const QChar locale_lang37_terr187_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang37_terr187_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang31_terr163_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang31_terr163_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang8_terr122_am[] = { QChar(0x635) };
static const QChar locale_lang8_terr122_pm[] = { QChar(0x645) };
static const QChar locale_lang31_terr97_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang31_terr97_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang25_terr208_am[] = { QChar(0x4e0a), QChar(0x5348) };
static const QChar locale_lang25_terr208_pm[] = { QChar(0x4e0b), QChar(0x5348) };
static const QChar locale_lang25_terr126_am[] = { QChar(0x4e0a), QChar(0x5348) };
static const QChar locale_lang25_terr126_pm[] = { QChar(0x4e0b), QChar(0x5348) };
static const QChar locale_lang8_terr64_am[] = { QChar(0x635) };
static const QChar locale_lang8_terr64_pm[] = { QChar(0x645) };
static const QChar locale_lang89_terr102_am[] = { QChar(0x642), QChar(0x628), QChar(0x644), QChar(0x20), QChar(0x627), QChar(0x632), QChar(0x20), QChar(0x638), QChar(0x647), QChar(0x631) };
static const QChar locale_lang89_terr102_pm[] = { QChar(0x628), QChar(0x639), QChar(0x62f), QChar(0x20), QChar(0x627), QChar(0x632), QChar(0x20), QChar(0x638), QChar(0x647), QChar(0x631) };
static const QChar locale_lang8_terr201_am[] = { QChar(0x635) };
static const QChar locale_lang8_terr201_pm[] = { QChar(0x645) };
static const QChar locale_lang117_terr100_am[] = { QChar(0xb95), QChar(0xbbe), QChar(0xbb2), QChar(0xbc8) };
static const QChar locale_lang117_terr100_pm[] = { QChar(0xbae), QChar(0xbbe), QChar(0xbb2), QChar(0xbc8) };
static const QChar locale_lang95_terr141_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang95_terr141_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang31_terr215_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang31_terr215_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang96_terr222_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang96_terr222_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang8_terr17_am[] = { QChar(0x635) };
static const QChar locale_lang8_terr17_pm[] = { QChar(0x645) };
static const QChar locale_lang111_terr174_am[] = { QChar(0x61), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang111_terr174_pm[] = { QChar(0x70), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang31_terr224_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang31_terr224_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang49_terr100_am[] = { QChar(0x92a), QChar(0x942), QChar(0x930), QChar(0x94d), QChar(0x935), QChar(0x93e), QChar(0x939), QChar(0x94d), QChar(0x928) };
static const QChar locale_lang49_terr100_pm[] = { QChar(0x905), QChar(0x92a), QChar(0x930), QChar(0x93e), QChar(0x939), QChar(0x94d), QChar(0x928) };
static const QChar locale_lang31_terr28_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang31_terr28_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang31_terr107_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang31_terr107_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang8_terr237_am[] = { QChar(0x635) };
static const QChar locale_lang8_terr237_pm[] = { QChar(0x645) };
static const QChar locale_lang8_terr119_am[] = { QChar(0x635) };
static const QChar locale_lang8_terr119_pm[] = { QChar(0x645) };
static const QChar locale_lang31_terr100_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang31_terr100_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang95_terr177_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang95_terr177_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang42_terr123_am[] = { QChar(0x76), QChar(0x6f), QChar(0x72), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang42_terr123_pm[] = { QChar(0x6e), QChar(0x61), QChar(0x63), QChar(0x68), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang111_terr26_am[] = { QChar(0x61), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang111_terr26_pm[] = { QChar(0x70), QChar(0x2e), QChar(0x6d), QChar(0x2e) };
static const QChar locale_lang125_terr217_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang125_terr217_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang110_terr194_am[] = { QChar(0x73), QChar(0x6e) };
static const QChar locale_lang110_terr194_pm[] = { QChar(0x67), QChar(0x6e) };
static const QChar locale_lang31_terr234_am[] = { QChar(0x41), QChar(0x4d) };
static const QChar locale_lang31_terr234_pm[] = { QChar(0x50), QChar(0x4d) };
static const QChar locale_lang89_terr1_am[] = { QChar(0x642), QChar(0x628), QChar(0x644), QChar(0x20), QChar(0x627), QChar(0x632), QChar(0x20), QChar(0x638), QChar(0x647), QChar(0x631) };
static const QChar locale_lang89_terr1_pm[] = { QChar(0x628), QChar(0x639), QChar(0x62f), QChar(0x20), QChar(0x627), QChar(0x632), QChar(0x20), QChar(0x638), QChar(0x647), QChar(0x631) };

static const uint locale_index[] = {
     0, // unused
     0, // C
     0, // Abkhazian
     1, // Afan
     3, // Afar
     6, // Afrikaans
     8, // Albanian
     9, // Amharic
    10, // Arabic
    27, // Armenian
    28, // Assamese
     0, // Aymara
    29, // Azerbaijani
     0, // Bashkir
    30, // Basque
    31, // Bengali
    33, // Bhutani
     0, // Bihari
     0, // Bislama
     0, // Breton
    34, // Bulgarian
    35, // Burmese
    36, // Byelorussian
    37, // Cambodian
    38, // Catalan
    39, // Chinese
     0, // Corsican
    44, // Croatian
    45, // Czech
    46, // Danish
    47, // Dutch
    49, // English
     0, // Esperanto
    75, // Estonian
    76, // Faroese
     0, // Fiji
    77, // Finnish
    78, // French
     0, // Frisian
     0, // Gaelic
    85, // Galician
    86, // Georgian
    87, // German
    93, // Greek
    95, // Greenlandic
     0, // Guarani
    96, // Gujarati
    97, // Hausa
   101, // Hebrew
   102, // Hindi
   103, // Hungarian
   104, // Icelandic
   105, // Indonesian
     0, // Interlingua
     0, // Interlingue
     0, // Inuktitut
     0, // Inupiak
   106, // Irish
   107, // Italian
   109, // Japanese
     0, // Javanese
   110, // Kannada
     0, // Kashmiri
   111, // Kazakh
   112, // Kinyarwanda
   113, // Kirghiz
   114, // Korean
   115, // Kurdish
     0, // Kurundi
   116, // Laothian
     0, // Latin
   117, // Latvian
   118, // Lingala
   120, // Lithuanian
   121, // Macedonian
     0, // Malagasy
   122, // Malay
   124, // Malayalam
   125, // Maltese
     0, // Maori
   126, // Marathi
     0, // Moldavian
   127, // Mongolian
     0, // Nauru
   129, // Nepali
   131, // Norwegian
     0, // Occitan
   132, // Oriya
   133, // Pashto
   134, // Persian
   136, // Polish
   137, // Portuguese
   139, // Punjabi
     0, // Quechua
     0, // RhaetoRomance
   141, // Romanian
   143, // Russian
     0, // Samoan
     0, // Sangho
   145, // Sanskrit
   146, // Serbian
   149, // SerboCroatian
   152, // Sesotho
   154, // Setswana
     0, // Shona
     0, // Sindhi
   155, // Singhalese
   156, // Siswati
   158, // Slovak
   159, // Slovenian
   160, // Somali
   164, // Spanish
     0, // Sundanese
   184, // Swahili
   186, // Swedish
     0, // Tagalog
   188, // Tajik
   189, // Tamil
   190, // Tatar
   191, // Telugu
   192, // Thai
     0, // Tibetan
   193, // Tigrinya
   195, // Tonga
   196, // Tsonga
   197, // Turkish
     0, // Turkmen
     0, // Twi
   198, // Uigur
   199, // Ukrainian
   200, // Urdu
   202, // Uzbek
   204, // Vietnamese
     0, // Volapuk
   205, // Welsh
   206, // Wolof
   207, // Xhosa
     0, // Yiddish
   208, // Yoruba
     0, // Zhuang
   209, // Zulu
   210, // Nynorsk
   211, // Bosnian
   212, // Divehi
   213, // Manx
   214, // Cornish
   215, // Akan
   216, // Konkani
   217, // Ga
   218, // Igbo
   219, // Kamba
   220, // Syriac
   221, // Blin
   222, // Geez
   224, // Koro
   225, // Sidamo
   226, // Atsam
   227, // Tigre
   228, // Jju
   229, // Friulian
   230, // Venda
   231, // Ewe
     0, // Walamo
   233, // Hawaiian
   234, // Tyap
   235, // Chewa
     0 // trailing 0
};

static const QLocalePrivate locale_data[] = {
//      lang   terr    dec  group   list  prcnt   zero  minus  plus    exp sDtFmt lDtFmt sTmFmt lTmFmt ssMonth slMonth  sMonth lMonth  sDays  lDays  am,len      pm,len
    {      1,     0,    46,    44,    59,    37,    48,    45,    43,   101,     0,    11,     0,     9,     0,    49,   136,     0,    49,   136,     0,    29,    87,     0,    29,   102,locale_lang1_terr0_am,2,locale_lang1_terr0_pm,2 }, // C/AnyCountry
    {      3,    69,    46,    44,    59,    37,    48,    45,    43,   101,    29,    38,    20,    28,   161,   161,   136,   164,   213,   325,   117,   117,    87,   125,   154,   117,NULL,0,NULL,0 }, // Afan/Ethiopia
    {      3,   111,    46,    44,    59,    37,    48,    45,    43,   101,    29,    38,    20,    28,   161,   161,   136,   164,   213,   325,   117,   117,    87,   125,   154,   117,NULL,0,NULL,0 }, // Afan/Kenya
    {      4,    59,    46,    44,    59,    37,    48,    45,    43,   101,    29,    57,    20,    28,   161,   161,   174,   338,   387,   325,   117,   117,   210,   225,   254,   117,NULL,0,NULL,0 }, // Afar/Djibouti
    {      4,    67,    46,    44,    59,    37,    48,    45,    43,   101,    29,    57,    20,    28,   161,   161,   174,   338,   517,   325,   117,   117,   210,   225,   254,   117,NULL,0,NULL,0 }, // Afar/Eritrea
    {      4,    69,    46,    44,    59,    37,    48,    45,    43,   101,    29,    57,    20,    28,   161,   161,   174,   338,   517,   325,   117,   117,   210,   225,   254,   117,NULL,0,NULL,0 }, // Afar/Ethiopia
    {      5,   195,    44,   160,    59,    37,    48,    45,    43,   101,    77,    88,    20,    28,   161,   161,   199,   636,   685,   325,   117,   117,   307,   322,   344,   117,locale_lang5_terr195_am,3,locale_lang5_terr195_pm,3 }, // Afrikaans/SouthAfrica
    {      5,   148,    44,   160,    59,    37,    48,    45,    43,   101,   106,   117,    40,    46,   161,   161,   199,   636,   685,   325,   117,   117,   307,   322,   344,   117,locale_lang5_terr148_am,3,locale_lang5_terr148_pm,3 }, // Afrikaans/Namibia
    {      6,     2,    44,    46,    59,    37,    48,    45,    43,   101,   134,   143,    56,    64,   161,   161,   227,   778,   828,   325,   117,   117,   403,   418,   449,   117,locale_lang6_terr2_am,2,locale_lang6_terr2_pm,2 }, // Albanian/Albania
    {      7,    69,    46,    44,    59,    37,    48,    45,    43,   101,    29,   162,    20,    76,   161,   161,   252,   908,  1023,   325,   117,   117,   514,   543,   611,   117,NULL,0,NULL,0 }, // Amharic/Ethiopia
    {      8,   186,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,   192,   207,    20,    89,   161,   161,   301,  1186,  1186,   325,   682,   117,   752,   774,   774,   117,locale_lang8_terr186_am,1,locale_lang8_terr186_pm,1 }, // Arabic/SaudiArabia
    {      8,     3,  1643,  1644,  1563,  1642,    48,    45,    43,   101,   192,   207,    20,    89,   161,   161,   301,  1186,  1186,   325,   682,   117,   752,   752,   774,   117,locale_lang8_terr3_am,1,locale_lang8_terr3_pm,1 }, // Arabic/Algeria
    {      8,    17,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,   192,   207,    20,    89,   161,   161,   301,  1186,  1186,   325,   682,   117,   752,   752,   774,   117,locale_lang8_terr17_am,1,locale_lang8_terr17_pm,1 }, // Arabic/Bahrain
    {      8,    64,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,   192,   207,    20,    89,   161,   161,   301,  1186,  1186,   325,   682,   117,   752,   752,   774,   117,locale_lang8_terr64_am,1,locale_lang8_terr64_pm,1 }, // Arabic/Egypt
    {      8,   103,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,   192,   207,    20,    89,   161,   161,   301,  1186,  1186,   325,   682,   117,   752,   752,   774,   117,locale_lang8_terr103_am,1,locale_lang8_terr103_pm,1 }, // Arabic/Iraq
    {      8,   109,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,   192,   207,    20,    89,   161,   161,   301,  1325,  1325,   325,   682,   117,   752,   774,   774,   117,locale_lang8_terr109_am,1,locale_lang8_terr109_pm,1 }, // Arabic/Jordan
    {      8,   115,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,   192,   207,    20,    89,   161,   161,   301,  1186,  1186,   325,   682,   117,   752,   752,   774,   117,locale_lang8_terr115_am,1,locale_lang8_terr115_pm,1 }, // Arabic/Kuwait
    {      8,   119,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,   192,   207,    20,    89,   161,   161,   301,  1494,  1494,   325,   682,   117,   752,   774,   774,   117,locale_lang8_terr119_am,1,locale_lang8_terr119_pm,1 }, // Arabic/Lebanon
    {      8,   122,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,   192,   207,    20,    89,   161,   161,   301,  1186,  1186,   325,   682,   117,   752,   752,   774,   117,locale_lang8_terr122_am,1,locale_lang8_terr122_pm,1 }, // Arabic/LibyanArabJamahiriya
    {      8,   145,  1643,  1644,  1563,  1642,    48,    45,    43,   101,   192,   207,    20,    89,   161,   161,   301,  1186,  1186,   325,   682,   117,   752,   752,   774,   117,locale_lang8_terr145_am,1,locale_lang8_terr145_pm,1 }, // Arabic/Morocco
    {      8,   162,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,   192,   207,    20,    89,   161,   161,   301,  1186,  1186,   325,   682,   117,   752,   752,   774,   117,locale_lang8_terr162_am,1,locale_lang8_terr162_pm,1 }, // Arabic/Oman
    {      8,   175,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,   192,   207,    20,    89,   161,   161,   301,  1186,  1186,   325,   682,   117,   752,   774,   774,   117,locale_lang8_terr175_am,1,locale_lang8_terr175_pm,1 }, // Arabic/Qatar
    {      8,   201,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,   192,   207,    20,    89,   161,   161,   301,  1186,  1186,   325,   682,   117,   752,   752,   774,   117,locale_lang8_terr201_am,1,locale_lang8_terr201_pm,1 }, // Arabic/Sudan
    {      8,   207,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,   192,   207,    20,    89,   161,   161,   301,  1494,  1494,   325,   682,   117,   752,   774,   774,   117,locale_lang8_terr207_am,1,locale_lang8_terr207_pm,1 }, // Arabic/SyrianArabRepublic
    {      8,   216,  1643,  1644,  1563,  1642,    48,    45,    43,   101,   192,   207,    20,    89,   161,   161,   301,  1186,  1186,   325,   682,   117,   752,   774,   774,   117,locale_lang8_terr216_am,1,locale_lang8_terr216_pm,1 }, // Arabic/Tunisia
    {      8,   223,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,   192,   207,    20,    89,   161,   161,   301,  1186,  1186,   325,   682,   117,   752,   752,   774,   117,locale_lang8_terr223_am,1,locale_lang8_terr223_pm,1 }, // Arabic/UnitedArabEmirates
    {      8,   237,  1643,  1644,  1563,  1642,  1632,    45,    43,   101,   192,   207,    20,    89,   161,   161,   301,  1186,  1186,   325,   682,   117,   752,   774,   774,   117,locale_lang8_terr237_am,1,locale_lang8_terr237_pm,1 }, // Arabic/Yemen
    {      9,    11,    44,    46,    59,    37,    48,    45,    43,   101,   228,    38,    40,    46,   161,   161,   199,  1663,  1748,   325,   117,   117,   307,   872,   922,   117,locale_lang9_terr11_am,3,locale_lang9_terr11_pm,3 }, // Armenian/Armenia
    {     10,   100,    46,    44,    59,    37,    48,    45,    43,   101,   237,   246,   101,   110,   161,   161,   199,  1929,  2092,   325,   117,   117,   307,  1040,  1138,   117,locale_lang10_terr100_am,6,locale_lang10_terr100_pm,2 }, // Assamese/India
    {     12,    15,    44,    46,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199,  2339,  2388,   325,   117,   117,   102,  1299,  1329,   117,NULL,0,NULL,0 }, // Azerbaijani/Azerbaijan
    {     14,   197,    44,    46,    59,    37,    48,    45,    43,   101,   134,   293,    40,    46,   161,   161,   199,  2468,  2517,   325,   117,   117,   307,  1419,  1441,   117,NULL,0,NULL,0 }, // Basque/Spain
    {     15,    18,    46,    44,    59,    37,  2534,    45,    43,   101,   325,   246,    20,    28,   161,   161,   338,  2611,  2611,   325,   117,   117,  1510,  1551,  1649,   117,locale_lang15_terr18_am,9,locale_lang15_terr18_pm,7 }, // Bengali/Bangladesh
    {     15,   100,    46,    44,    59,    37,  2534,    45,    43,   101,   325,   246,    20,    28,   161,   161,   338,  2611,  2611,   325,   117,   117,  1510,  1551,  1649,   117,locale_lang15_terr100_am,9,locale_lang15_terr100_pm,7 }, // Bengali/India
    {     16,    25,    46,    44,    59,    37,  3872,    45,    43,   101,   332,   391,   122,   171,   161,   161,   199,  2858,  3036,   325,   117,   117,   307,  1810,  1899,   117,NULL,0,NULL,0 }, // Bhutani/Bhutan
    {     20,    33,    44,   160,    59,    37,    48,    45,    43,   101,   451,   460,    40,    46,   161,   161,   414,  3628,  3727,   325,   117,   117,  2123,  2145,  2181,   117,locale_lang20_terr33_am,7,locale_lang20_terr33_pm,7 }, // Bulgarian/Bulgaria
    {     21,   147,    46,    44,  4170,    37,  4160,    45,    43,   101,   265,   274,    40,    46,   161,   161,   451,  3880,  3986,   325,   117,   117,  2285,  2314,  2376,   117,NULL,0,NULL,0 }, // Burmese/Myanmar
    {     22,    20,    44,   160,    59,    37,    48,    45,    43,   101,   479,    11,   246,   252,   500,   519,   546,  4227,  4312,  4491,   117,   117,  2525,  2547,  2583,   117,locale_lang22_terr20_am,10,locale_lang22_terr20_pm,13 }, // Byelorussian/Belarus
    {     23,    36,    44,    46,    59,    37,    48,    45,    43,   101,   486,   495,   262,   267,   161,   161,   199,  4506,  4564,   325,   117,   117,   307,  2689,  2733,   117,locale_lang23_terr36_am,5,locale_lang23_terr36_pm,5 }, // Cambodian/Cambodia
    {     24,   197,    44,    46,    59,    37,    48,    45,    43,   101,    29,   549,   262,   323,   161,   161,   583,  4754,  4816,   325,  2948,   117,  2970,  2985,  3014,   117,NULL,0,NULL,0 }, // Catalan/Spain
    {     25,    44,    46,    44,    59,    37,    48,    45,    43,   101,   576,   583,   332,   339,   608,   608,   699,  4900,  4900,   325,   117,   117,  3075,  3104,  3154,   117,locale_lang25_terr44_am,2,locale_lang25_terr44_pm,2 }, // Chinese/China
    {     25,    97,    46, 65292, 65307,    37,    48,    45,    43,   101,   603,   583,   332,   339,   608,   608,   699,  4900,  4900,   325,   117,   117,  3075,  3104,  3154,   117,locale_lang25_terr97_am,2,locale_lang25_terr97_pm,2 }, // Chinese/HongKong
    {     25,   126,    46,    44,    59,    37,    48,    45,    43,   101,   603,   617,   332,   339,   608,   608,   699,  4900,  4900,   325,   117,   117,  3075,  3104,  3154,   117,locale_lang25_terr126_am,2,locale_lang25_terr126_pm,2 }, // Chinese/Macau
    {     25,   190,    46,    44,    59,    37,    48,    45,    43,   101,    29,   583,   357,   339,   608,   608,   699,  4900,  4900,   325,   117,   117,  3075,  3104,  3154,   117,locale_lang25_terr190_am,2,locale_lang25_terr190_pm,2 }, // Chinese/Singapore
    {     25,   208,    46,    44,    59,    37,    48,    45,    43,   101,   576,   583,   332,   339,   608,   608,   699,  4900,  4900,   325,   117,   117,  3075,  3104,  3154,   117,locale_lang25_terr208_am,2,locale_lang25_terr208_pm,2 }, // Chinese/Taiwan
    {     27,    54,    44,    46,    59,    37,    48,    45,    43,   101,   639,   651,    40,    46,   161,   763,   861,  4964,  5014,   325,   117,   117,  3225,  3241,  3271,   117,locale_lang27_terr54_am,2,locale_lang27_terr54_pm,2 }, // Croatian/Croatia
    {     28,    57,    44,   160,    59,    37,    48,    45,    43,   101,   479,   671,   262,    46,   886,   926,  1019,   136,  5116,   325,   117,   117,  3331,  3348,  3373,   117,locale_lang28_terr57_am,4,locale_lang28_terr57_pm,4 }, // Czech/CzechRepublic
    {     29,    58,    44,    46,    44,    37,    48,    45,    43,   101,    29,   690,   246,   252,   161,   161,   136,  5211,  5260,   325,   117,   117,  3431,  3446,  3477,   117,locale_lang29_terr58_am,4,locale_lang29_terr58_pm,4 }, // Danish/Denmark
    {     30,   151,    44,    46,    59,    37,    48,    45,    43,   101,   714,   117,    40,    46,   161,   161,   136,  5345,  5394,   325,   117,   117,  3531,  3546,  3568,   117,NULL,0,NULL,0 }, // Dutch/Netherlands
    {     30,    21,    44,    46,    59,    37,    48,    45,    43,   101,   723,   117,    40,    46,   161,   161,   136,  5345,  5394,   325,   117,   117,  3531,  3546,  3568,   117,NULL,0,NULL,0 }, // Dutch/Belgium
    {     31,   225,    46,    44,    59,    37,    48,    45,    43,   101,   731,    38,    20,    28,   161,   161,   136,     0,    49,   325,   117,   117,    87,     0,    29,   117,locale_lang31_terr225_am,2,locale_lang31_terr225_pm,2 }, // English/UnitedStates
    {     31,     4,    46,    44,    59,    37,    48,    45,    43,   101,   731,    38,    20,    28,   161,   161,   136,     0,    49,   325,   117,   117,    87,     0,    29,   117,locale_lang31_terr4_am,2,locale_lang31_terr4_pm,2 }, // English/AmericanSamoa
    {     31,    13,    46,    44,    59,    37,    48,    45,    43,   101,   723,    11,    20,    28,   161,   161,   136,     0,    49,   325,   117,   117,    87,     0,    29,   117,locale_lang31_terr13_am,2,locale_lang31_terr13_pm,2 }, // English/Australia
    {     31,    21,    44,    46,    59,    37,    48,    45,    43,   101,    29,   117,    40,   365,   161,   161,   136,     0,    49,   325,   117,   117,    87,     0,    29,   117,locale_lang31_terr21_am,2,locale_lang31_terr21_pm,2 }, // English/Belgium
    {     31,    22,    46,    44,    59,    37,    48,    45,    43,   101,    29,   738,    40,    46,   161,   161,   136,     0,    49,   325,   117,   117,    87,     0,    29,   117,locale_lang31_terr22_am,2,locale_lang31_terr22_pm,2 }, // English/Belize
    {     31,    28,    46,    44,    59,    37,    48,    45,    43,   101,    29,    88,    20,    28,   161,   161,   136,     0,    49,   325,   117,   117,    87,     0,    29,   117,locale_lang31_terr28_am,2,locale_lang31_terr28_pm,2 }, // English/Botswana
    {     31,    38,    46,    44,    59,    37,    48,    45,    43,   101,   134,    38,    20,    28,   161,   161,   136,     0,    49,   325,   117,   117,    87,     0,    29,   117,locale_lang31_terr38_am,2,locale_lang31_terr38_pm,2 }, // English/Canada
    {     31,    89,    46,    44,    59,    37,    48,    45,    43,   101,   731,    38,    20,    28,   161,   161,   136,     0,    49,   325,   117,   117,    87,     0,    29,   117,locale_lang31_terr89_am,2,locale_lang31_terr89_pm,2 }, // English/Guam
    {     31,    97,    46,    44,    59,    37,    48,    45,    43,   101,   751,    11,    20,    28,   161,   161,   136,     0,    49,   325,   117,   117,    87,     0,    29,   117,locale_lang31_terr97_am,2,locale_lang31_terr97_pm,2 }, // English/HongKong
    {     31,   100,    46,    44,    59,    37,    48,    45,    43,   101,    29,   117,    20,    28,   161,   161,   136,     0,    49,   325,   117,   117,    87,     0,    29,   117,locale_lang31_terr100_am,2,locale_lang31_terr100_pm,2 }, // English/India
    {     31,   104,    46,    44,    59,    37,    48,    45,    43,   101,   751,   117,    40,    46,   161,   161,   136,     0,    49,   325,   117,   117,    87,     0,    29,   117,locale_lang31_terr104_am,4,locale_lang31_terr104_pm,4 }, // English/Ireland
    {     31,   107,    46,    44,    59,    37,    48,    45,    43,   101,   731,    38,    20,    28,   161,   161,   136,     0,    49,   325,   117,   117,    87,     0,    29,   117,locale_lang31_terr107_am,2,locale_lang31_terr107_pm,2 }, // English/Jamaica
    {     31,   133,    46,    44,    59,    37,    48,    45,    43,   101,   751,    11,    40,    46,   161,   161,   136,     0,    49,   325,   117,   117,    87,     0,    29,   117,locale_lang31_terr133_am,2,locale_lang31_terr133_pm,2 }, // English/Malta
    {     31,   134,    46,    44,    59,    37,    48,    45,    43,   101,   731,    38,    20,    28,   161,   161,   136,     0,    49,   325,   117,   117,    87,     0,    29,   117,locale_lang31_terr134_am,2,locale_lang31_terr134_pm,2 }, // English/MarshallIslands
    {     31,   148,    46,    44,    59,    37,    48,    45,    43,   101,   731,    38,    20,    28,   161,   161,   136,     0,    49,   325,   117,   117,    87,     0,    29,   117,locale_lang31_terr148_am,2,locale_lang31_terr148_pm,2 }, // English/Namibia
    {     31,   154,    46,    44,    59,    37,    48,    45,    43,   101,   723,    11,    20,    28,   161,   161,   136,     0,    49,   325,   117,   117,    87,     0,    29,   117,locale_lang31_terr154_am,2,locale_lang31_terr154_pm,2 }, // English/NewZealand
    {     31,   160,    46,    44,    59,    37,    48,    45,    43,   101,   731,    38,    20,    28,   161,   161,   136,     0,    49,   325,   117,   117,    87,     0,    29,   117,locale_lang31_terr160_am,2,locale_lang31_terr160_pm,2 }, // English/NorthernMarianaIslands
    {     31,   163,    46,    44,    59,    37,    48,    45,    43,   101,    29,   117,    20,    28,   161,   161,   136,     0,    49,   325,   117,   117,    87,     0,    29,   117,locale_lang31_terr163_am,2,locale_lang31_terr163_pm,2 }, // English/Pakistan
    {     31,   170,    46,    44,    59,    37,    48,    45,    43,   101,   731,    38,    20,    28,   161,   161,   136,     0,    49,   325,   117,   117,    87,     0,    29,   117,locale_lang31_terr170_am,2,locale_lang31_terr170_pm,2 }, // English/Philippines
    {     31,   190,    46,    44,    59,    37,    48,    45,    43,   101,    29,   143,   389,   398,   161,   161,   136,     0,    49,   325,   117,   117,    87,     0,    29,   117,locale_lang31_terr190_am,2,locale_lang31_terr190_pm,2 }, // English/Singapore
    {     31,   195,    44,   160,    59,    37,    48,    45,    43,   101,    77,    88,    20,    28,   161,   161,   136,     0,    49,   325,   117,   117,    87,     0,    29,   117,locale_lang31_terr195_am,2,locale_lang31_terr195_pm,2 }, // English/SouthAfrica
    {     31,   215,    46,    44,    59,    37,    48,    45,    43,   101,   731,    38,    20,    28,   161,   161,   136,     0,    49,   325,   117,   117,    87,     0,    29,   117,locale_lang31_terr215_am,2,locale_lang31_terr215_pm,2 }, // English/TrinidadAndTobago
    {     31,   224,    46,    44,    59,    37,    48,    45,    43,   101,   751,    11,    40,    46,   161,   161,   136,     0,    49,   325,   117,   117,    87,     0,    29,   117,locale_lang31_terr224_am,2,locale_lang31_terr224_pm,2 }, // English/UnitedKingdom
    {     31,   226,    46,    44,    59,    37,    48,    45,    43,   101,   731,    38,    20,    28,   161,   161,   136,     0,    49,   325,   117,   117,    87,     0,    29,   117,locale_lang31_terr226_am,2,locale_lang31_terr226_pm,2 }, // English/UnitedStatesMinorOutlyingIslands
    {     31,   234,    46,    44,    59,    37,    48,    45,    43,   101,   731,    38,    20,    28,   161,   161,   136,     0,    49,   325,   117,   117,    87,     0,    29,   117,locale_lang31_terr234_am,2,locale_lang31_terr234_pm,2 }, // English/USVirginIslands
    {     31,   240,    46,    44,    59,    37,    48,    45,    43,   101,   486,    88,    20,    28,   161,   161,   136,     0,    49,   325,   117,   117,    87,     0,    29,   117,locale_lang31_terr240_am,2,locale_lang31_terr240_pm,2 }, // English/Zimbabwe
    {     33,    68,    44,   160,    59,    37,    48,    45,    43,   101,   451,   762,   262,   323,   161,   161,   199,  5483,  5544,   325,   117,   117,   307,  3628,  3643,   117,NULL,0,NULL,0 }, // Estonian/Estonia
    {     34,    71,    44,    46,    59,    37,    48,  8722,    43,   101,   714,    88,    40,    46,   161,   161,   199,  5637,  5686,   325,   117,   117,   307,  3714,  3747,   117,NULL,0,NULL,0 }, // Faroese/FaroeIslands
    {     36,    73,    44,   160,    59,    37,    48,    45,    43,   101,   781,   790,   411,   416,   161,   161,  1048,  5771,  5843,   325,   117,   117,  3826,  3841,  3863,   117,locale_lang36_terr73_am,3,locale_lang36_terr73_pm,3 }, // Finnish/Finland
    {     37,    74,    44,   160,    59,    37,    48,    45,    43,   101,    29,   117,    40,    46,   161,   161,   136,  5975,  6042,   325,   117,   117,  3945,  3960,  3996,   117,locale_lang37_terr74_am,2,locale_lang37_terr74_pm,2 }, // French/France
    {     37,    21,    44,    46,    59,    37,    48,    45,    43,   101,   723,   117,    40,   425,   161,   161,   136,  5975,  6042,   325,   117,   117,  3945,  3960,  3996,   117,locale_lang37_terr21_am,2,locale_lang37_terr21_pm,2 }, // French/Belgium
    {     37,    38,    44,   160,    59,    37,    48,    45,    43,   101,   134,   117,    40,   365,   161,   161,   136,  5975,  6042,   325,   117,   117,  3945,  3960,  3996,   117,locale_lang37_terr38_am,2,locale_lang37_terr38_pm,2 }, // French/Canada
    {     37,   125,    44,    46,    59,    37,    48,    45,    43,   101,    29,   117,    40,    46,   161,   161,   136,  5975,  6042,   325,   117,   117,  3945,  3960,  3996,   117,locale_lang37_terr125_am,2,locale_lang37_terr125_pm,2 }, // French/Luxembourg
    {     37,   142,    44,   160,    59,    37,    48,    45,    43,   101,    29,   117,    40,    46,   161,   161,   136,  5975,  6042,   325,   117,   117,  3945,  3960,  3996,   117,locale_lang37_terr142_am,2,locale_lang37_terr142_pm,2 }, // French/Monaco
    {     37,   187,    44,   160,    59,    37,    48,    45,    43,   101,    29,   117,    40,    46,   161,   161,   136,  5975,  6042,   325,   117,   117,  3945,  3960,  3996,   117,locale_lang37_terr187_am,2,locale_lang37_terr187_pm,2 }, // French/Senegal
    {     37,   206,    46,    39,    59,    37,    48,    45,    43,   101,   451,    11,    40,   448,   161,   161,   136,  5975,  6042,   325,   117,   117,  3945,  3960,  3996,   117,locale_lang37_terr206_am,2,locale_lang37_terr206_pm,2 }, // French/Switzerland
    {     40,   197,    44,    46,    59,    37,    48,    45,    43,   101,    29,    88,    40,    46,   161,   161,  1073,  6131,  6181,   325,   117,   117,  4049,  4064,  4095,   117,NULL,0,NULL,0 }, // Galician/Spain
    {     41,    81,    44,    46,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,  1098,  6270,  6391,   325,   117,   117,  4147,  4176,  4247,   117,NULL,0,NULL,0 }, // Georgian/Georgia
    {     42,    82,    44,    46,    59,    37,    48,    45,    43,   101,   451,   671,    40,    46,  1147,   161,   136,  6665,  6714,   325,   117,   117,  4420,  4435,  4464,   117,locale_lang42_terr82_am,5,locale_lang42_terr82_pm,6 }, // German/Germany
    {     42,    14,    44,    46,    59,    37,    48,    45,    43,   101,   451,   808,    40,    46,  1147,   161,   136,  6799,  6850,   325,   117,   117,  4420,  4435,  4464,   117,locale_lang42_terr14_am,5,locale_lang42_terr14_pm,6 }, // German/Austria
    {     42,    21,    44,    46,    59,    37,    48,    45,    43,   101,   723,   117,    40,   365,  1147,   161,   136,  6936,  6714,   325,   117,   117,  4420,  4525,  4464,   117,locale_lang42_terr21_am,5,locale_lang42_terr21_pm,6 }, // German/Belgium
    {     42,   123,    46,    39,    59,    37,    48,    45,    43,   101,   451,   671,    40,    46,  1147,   161,   136,  6665,  6714,   325,   117,   117,  4420,  4435,  4464,   117,locale_lang42_terr123_am,5,locale_lang42_terr123_pm,6 }, // German/Liechtenstein
    {     42,   125,    44,    46,    59,    37,    48,    45,    43,   101,   451,   671,    40,    46,  1147,   161,   136,  6665,  6714,   325,   117,   117,  4420,  4435,  4464,   117,locale_lang42_terr125_am,5,locale_lang42_terr125_pm,6 }, // German/Luxembourg
    {     42,   206,    46,    39,    59,    37,    48,    45,    43,   101,   451,   671,    40,    46,  1147,   161,   136,  6665,  6714,   325,   117,   117,  4420,  4435,  4464,   117,locale_lang42_terr206_am,5,locale_lang42_terr206_pm,6 }, // German/Switzerland
    {     43,    85,    44,    46,    59,    37,    48,    45,    43,   101,   751,   143,    20,    28,   161,  1182,  1401,  6986,  7075,   325,   117,   117,  4554,  4576,  4626,   117,locale_lang43_terr85_am,4,locale_lang43_terr85_pm,4 }, // Greek/Greece
    {     43,    56,    44,    46,    59,    37,    48,    45,    43,   101,   751,   143,    20,    28,   161,  1182,  1401,  6986,  7075,   325,   117,   117,  4554,  4576,  4626,   117,locale_lang43_terr56_am,4,locale_lang43_terr56_pm,4 }, // Greek/Cyprus
    {     44,    86,    44,    46,    59,    37,    48,    45,    43,   101,    29,    88,    20,    28,   161,   161,   199,  5211,  7294,   325,   117,   117,   307,  4730,  4759,   117,NULL,0,NULL,0 }, // Greenlandic/Greenland
    {     46,   100,    46,    44,    59,    37,  2790,    45,    43,   101,   828,   117,   462,    76,   161,   161,   199,  7391,  7569,   325,   117,   117,   307,  4858,  4941,   117,locale_lang46_terr100_am,14,locale_lang46_terr100_pm,14 }, // Gujarati/India
    {     47,    83,    46,    44,    59,    37,    48,    45,    43,   101,   325,   246,    40,    46,   161,   161,  1438,  7807,  7856,   325,   117,   117,  5087,  5102,  5131,   117,locale_lang47_terr83_am,2,locale_lang47_terr83_pm,2 }, // Hausa/Ghana
    {     47,   156,    46,    44,    59,    37,    48,    45,    43,   101,   325,   246,    40,    46,   161,   161,  1438,  7807,  7856,   325,   117,   117,  5087,  5102,  5131,   117,locale_lang47_terr156_am,2,locale_lang47_terr156_pm,2 }, // Hausa/Niger
    {     47,   157,    46,    44,    59,    37,    48,    45,    43,   101,   325,   246,    40,    46,   161,   161,  1438,  7807,  7856,   325,   117,   117,  5087,  5102,  5131,   117,locale_lang47_terr157_am,2,locale_lang47_terr157_pm,2 }, // Hausa/Nigeria
    {     47,   201,    46,    44,    59,    37,    48,    45,    43,   101,   325,   246,    40,    46,   161,   161,  1438,  7807,  7856,   325,   117,   117,  5087,  5102,  5131,   117,locale_lang47_terr201_am,2,locale_lang47_terr201_pm,2 }, // Hausa/Sudan
    {     48,   105,    46,    44,    59,    37,    48,    45,    43,   101,    29,   117,    40,    46,  1463,  1463,   199,  7941,  8026,   325,   117,   117,  5183,  5183,  5205,   117,locale_lang48_terr105_am,6,locale_lang48_terr105_pm,5 }, // Hebrew/Israel
    {     49,   100,    46,    44,    59,    37,  2406,    45,    43,   101,   836,   117,    20,    28,   161,   161,   199,  8159,  8159,   325,   117,   117,  5315,  5342,  5425,   117,locale_lang49_terr100_am,9,locale_lang49_terr100_pm,7 }, // Hindi/India
    {     50,    98,    44,   160,    59,    37,    48,    45,    43,   101,   843,   855,   262,   323,   161,   161,  1482,  8361,  8431,   325,   117,   117,  5571,  5586,  5606,   117,locale_lang50_terr98_am,3,locale_lang50_terr98_pm,3 }, // Hungarian/Hungary
    {     51,    99,    44,    46,    59,    37,    48,  8722,    43,   101,   781,   671,    40,    46,   161,   161,  1508,  8538,  8593,   325,   117,   117,  5666,  5682,  5715,   117,NULL,0,NULL,0 }, // Icelandic/Iceland
    {     52,   101,    44,    46,    59,    37,    48,    45,    43,   101,    29,    88,   262,   323,   161,   161,   199,  8688,  8737,   325,   117,   117,   307,  5802,  5831,   117,NULL,0,NULL,0 }, // Indonesian/Indonesia
    {     57,   104,    46,    44,    59,    37,    48,    45,    43,   101,   751,   117,    40,    46,   161,   161,  1534,  8825,  8893,   325,   117,   117,  5875,  5890,  5931,   117,locale_lang57_terr104_am,4,locale_lang57_terr104_pm,4 }, // Irish/Ireland
    {     58,   106,    44,    46,    59,    37,    48,    45,    43,   101,    29,   117,   246,   252,   161,  1559,  1616,  9009,  9058,   325,   117,  6016,  6079,  6094,  6123,   117,locale_lang58_terr106_am,2,locale_lang58_terr106_pm,2 }, // Italian/Italy
    {     58,   206,    46,    39,    59,    37,    48,    45,    43,   101,   451,    11,   246,   448,   161,  1559,  1616,  9009,  9058,   325,   117,  6016,  6079,  6094,  6123,   117,locale_lang58_terr206_am,2,locale_lang58_terr206_pm,2 }, // Italian/Switzerland
    {     59,   108,    46,    44,    59,    37,    48,    45,    43,   101,   265,   583,   262,   471,   699,   161,   199,  4900,  4900,   325,   117,   117,  6186,  6186,  6215,   117,locale_lang59_terr108_am,2,locale_lang59_terr108_pm,2 }, // Japanese/Japan
    {     61,   100,    46,    44,    59,    37,    48,    45,    43,   101,   836,   117,   462,    76,   161,   161,   199,  9153,  9153,   325,   117,   117,   307,  6286,  6343,   117,locale_lang61_terr100_am,9,locale_lang61_terr100_pm,7 }, // Kannada/India
    {     63,   110,    44,   160,    59,    37,    48,    45,    43,   101,   451,   869,    40,    46,   161,   161,   199,  9388,  9487,   325,   117,   117,   307,  6489,  6532,   117,NULL,0,NULL,0 }, // Kazakh/Kazakhstan
    {     64,   179,    44,    46,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199,  9642,  9703,   325,   117,   117,   307,  6634,  6670,   117,NULL,0,NULL,0 }, // Kinyarwanda/Rwanda
    {     65,   116,    44,   160,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199,   136,   136,   325,   117,   117,   307,   307,   307,   117,NULL,0,NULL,0 }, // Kirghiz/Kyrgyzstan
    {     66,   114,    46,    44,    59,    37,    48,    45,    43,   101,   893,   903,   486,   494,  1641,  1641,  1641,  9805,  9805,   325,   117,   117,  6755,  6755,  6784,   117,locale_lang66_terr114_am,2,locale_lang66_terr114_pm,2 }, // Korean/RepublicOfKorea
    {     67,   217,    46,    44,    59,    37,    48,    45,    43,   101,   106,   274,    40,    46,   161,   161,   199,   325,   136,   325,   117,   117,   307,   117,   307,   117,NULL,0,NULL,0 }, // Kurdish/Turkey
    {     69,   117,    46,    44,    59,    37,    48,    45,    43,   101,   486,   926,   262,   516,   161,   161,   199,  9869,  9985,   325,   117,   117,   307,  6855,  6900,   117,NULL,0,NULL,0 }, // Laothian/Lao
    {     71,   118,    44,   160,    59,    37,    48,    45,    43,   101,   952,   959,    40,    46,   161,   161,   136, 10187, 10238,   325,  7058,   117,  7078,  7093,  7110,   117,NULL,0,NULL,0 }, // Latvian/Latvia
    {     72,    49,    46,    44,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199, 10345, 10385,   325,   117,   117,   307,  7185,  7209,   117,NULL,0,NULL,0 }, // Lingala/DemocraticRepublicOfCongo
    {     72,    50,    46,    44,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199, 10345, 10385,   325,   117,   117,   307,  7185,  7209,   117,NULL,0,NULL,0 }, // Lingala/PeoplesRepublicOfCongo
    {     73,   124,    44,    46,    59,    37,    48,  8722,    43,   101,   106,   986,    40,    46,   161,  1705,  1807, 10631, 10680,   325,   117,   117,  7330,  7346,  7369,   117,locale_lang73_terr124_am,9,locale_lang73_terr124_pm,6 }, // Lithuanian/Lithuania
    {     74,   127,    44,    46,    59,    37,    48,    45,    43,   101,  1013,   143,    40,    46,   161,   161,  1832, 10788, 10892, 11051,   117,   117,  2123,  7462,  7517,   117,NULL,0,NULL,0 }, // Macedonian/Macedonia
    {     76,   130,    46,    44,    59,    37,    48,    45,    43,   101,   751,  1021,   563,    28,   161,   161,   199, 11068, 11118,   325,   117,   117,   307,  7619,  7648,   117,NULL,0,NULL,0 }, // Malay/Malaysia
    {     76,    32,    44,    46,    59,    37,    48,    45,    43,   101,   751,   738,   262,   568,   161,   161,   199, 11068, 11118,   325,   117,   117,   307,  7619,  7648,   117,NULL,0,NULL,0 }, // Malay/BruneiDarussalam
    {     77,   100,    46,    44,    59,    37,    48,    45,    43,   101,   714,  1038,    20,    28,   161,   161,  1869, 11201, 11376,   325,   117,  7692,  7730,  7759,  7812,  7940,NULL,0,NULL,0 }, // Malayalam/India
    {     78,   133,    46,    44,    59,    37,    48,    45,    43,   101,   751,  1057,    40,    46,   161,   161,  1936, 11656, 11707,   325,   117,   117,  7954,  7972,  8004,   117,locale_lang78_terr133_am,2,locale_lang78_terr133_pm,2 }, // Maltese/Malta
    {     80,   100,    46,    44,    59,    37,    48,    45,    43,   101,   836,   117,    20,    28,   161,   161,   199, 11795, 11795,   325,   117,   117,   307,  8073,  8156,   117,locale_lang80_terr100_am,5,locale_lang80_terr100_pm,5 }, // Marathi/India
    {     82,    44,    44,   160,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199, 12033, 12118,   325,   117,   117,   307,  8302,  8338,   117,NULL,0,NULL,0 }, // Mongolian/China
    {     82,   143,    44,   160,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199, 12033, 12118,   325,   117,   117,   307,  8302,  8338,   117,NULL,0,NULL,0 }, // Mongolian/Mongolia
    {     84,   100,    46,    44,    59,    37,  2406,    45,    43,   101,   265,   274,    40,    46,   161,   161,  1962, 12239, 12384,   325,   117,   117,  8418,  8447,  8533,   117,NULL,0,NULL,0 }, // Nepali/India
    {     84,   150,    46,    44,    59,    37,  2406,    45,    43,   101,   265,   274,    40,    46,   161,   161,  1962, 12239, 12384,   325,   117,   117,  8418,  8447,  8533,   117,NULL,0,NULL,0 }, // Nepali/Nepal
    {     85,   161,    44,   160,    59,    37,    48,    45,    43,   101,   451,   790,   246,   582,   161,   161,   136, 12616, 12676,   325,   117,   117,  3431,  8682,  3477,   117,locale_lang85_terr161_am,9,locale_lang85_terr161_pm,11 }, // Norwegian/Norway
    {     87,   100,    46,    44,    59,    37,  2918,    45,    43,   101,   714,  1083,    20,    28,   161,   161,   199, 12760, 12760,   325,   117,   117,   307,  8720,  8806,   117,NULL,0,NULL,0 }, // Oriya/India
    {     88,     1,  1643,  1644,    59,  1642,  1776,  8722,    43,   101,  1101,  1110,   262,   598,   161,   161,   199, 13004, 13042,   325,   117,   117,   307,   307,  8955,   117,locale_lang88_terr1_am,4,locale_lang88_terr1_pm,4 }, // Pashto/Afghanistan
    {     89,   102,  1643,  1644,  1563,  1642,  1776,  8722,    43,   101,  1133,  1140,   262,   598,   161,  2020,  2149, 13167, 13167,   325,   117,   117,  9048,  8955,  8955,   117,locale_lang89_terr102_am,10,locale_lang89_terr102_pm,10 }, // Persian/Iran
    {     89,     1,  1643,  1644,  1563,  1642,  1776,  8722,    43,   101,  1133,  1140,   262,   598,   161,  2020,  2186, 13304, 13419,   325,   117,   117,  9048,  8955,  8955,   117,locale_lang89_terr1_am,10,locale_lang89_terr1_pm,10 }, // Persian/Afghanistan
    {     90,   172,    44,   160,    59,    37,    48,    45,    43,   101,   134,    11,    40,    46,   161,  2223,  2327, 13544, 13594,   325,   117,   117,  9070,  9086,  9122,   117,locale_lang90_terr172_am,2,locale_lang90_terr172_pm,2 }, // Polish/Poland
    {     91,   173,    44,   160,    59,    37,    48,    45,    43,   101,   265,  1162,    40,   609,   161,   161,   136, 13696, 13745,   325,   117,   117,  9185,  9200,  9230,   117,locale_lang91_terr173_am,17,locale_lang91_terr173_pm,18 }, // Portuguese/Portugal
    {     91,    30,    44,    46,    59,    37,    48,    45,    43,   101,    29,  1162,    40,   626,   161,   161,   136, 13836, 13885,   325,   117,   117,  9185,  9200,  9230,   117,locale_lang91_terr30_am,2,locale_lang91_terr30_pm,2 }, // Portuguese/Brazil
    {     92,   100,    46,    44,    59,    37,  2662,    45,    43,   101,  1190,   143,    40,    46,   161,   161,  2352, 13976, 13976,   325,   117,   117,  9312,  9368,  9455,   117,locale_lang92_terr100_am,5,locale_lang92_terr100_pm,4 }, // Punjabi/India
    {     92,   163,    46,    44,    59,    37,  2662,    45,    43,   101,  1190,   143,    40,    46,   161,   161,  2352, 13976, 13976,   325,   117,   117,  9312,  9368,  9455,   117,locale_lang92_terr163_am,5,locale_lang92_terr163_pm,4 }, // Punjabi/Pakistan
    {     95,   141,    44,    46,    59,    37,    48,    45,    43,   101,  1200,    11,    40,    46,   161,   161,  2410, 14157, 14218,   325,   117,  9607,  3945,  9625,  9642,   117,locale_lang95_terr141_am,2,locale_lang95_terr141_pm,2 }, // Romanian/Moldova
    {     95,   177,    44,    46,    59,    37,    48,    45,    43,   101,  1200,    11,    40,    46,   161,   161,  2410, 14157, 14218,   325,   117,  9607,  3945,  9625,  9642,   117,locale_lang95_terr177_am,2,locale_lang95_terr177_pm,2 }, // Romanian/Romania
    {     96,   178,    44,   160,    59,    37,    48,    45,    43,   101,   451,  1211,   262,   323,  2435,  2540,  2689, 14317, 14424,   325,   117,  9696,  9814,  9836,  9872,   117,locale_lang96_terr178_am,2,locale_lang96_terr178_pm,2 }, // Russian/RussianFederation
    {     96,   222,    44,   160,    59,    37,    48,    45,    43,   101,   451,  1211,    40,    46,  2435,  2540,  2689, 14317, 14424,   325,   117,  9696,  9814,  9836,  9872,   117,locale_lang96_terr222_am,2,locale_lang96_terr222_pm,2 }, // Russian/Ukraine
    {     99,   100,    46,    44,    59,    37,  2406,    45,    43,   101,   828,   117,   462,    76,   161,   161,   199,   136,   136,   325,   117,   117,   307,   307,   307,   117,NULL,0,NULL,0 }, // Sanskrit/India
    {    100,   241,    44,    46,    59,    37,    48,    45,    43,  1077,  1235,  1243,   246,   252,   161,   161,  1832, 14577, 14662,   325,   117,   117,  9990, 10012, 10062,   117,locale_lang100_terr241_am,8,locale_lang100_terr241_pm,7 }, // Serbian/SerbiaAndMontenegro
    {    100,    27,    44,    46,    59,    37,    48,    45,    43,  1077,   134,  1243,    40,   645,   161,   161,  1832, 14577, 14813,   325,   117,   117,  9990, 10160, 10210,   117,locale_lang100_terr27_am,8,locale_lang100_terr27_pm,7 }, // Serbian/BosniaAndHerzegowina
    {    100,   238,    44,    46,    59,    37,    48,    45,    43,  1077,  1235,  1243,   246,   252,   161,   161,  1832, 14577, 14662,   325,   117,   117,  9990, 10012, 10062,   117,locale_lang100_terr238_am,8,locale_lang100_terr238_pm,7 }, // Serbian/Yugoslavia
    {    101,   241,    46,    44,    59,    37,    48,    45,    43,   101,   106,   274,    40,    46,   161,   161,  2726, 14968, 15017,   325,   117,   117,  3225, 10312, 10342,   117,locale_lang101_terr241_am,2,locale_lang101_terr241_pm,2 }, // SerboCroatian/SerbiaAndMontenegro
    {    101,    27,    46,    44,    59,    37,    48,    45,    43,   101,   106,   274,    40,    46,   161,   161,  2726, 14968, 15017,   325,   117,   117,  3225, 10312, 10342,   117,locale_lang101_terr27_am,2,locale_lang101_terr27_pm,2 }, // SerboCroatian/BosniaAndHerzegowina
    {    101,   238,    46,    44,    59,    37,    48,    45,    43,   101,   106,   274,    40,    46,   161,   161,  2726, 14968, 15017,   325,   117,   117,  3225, 10312, 10342,   117,locale_lang101_terr238_am,2,locale_lang101_terr238_pm,2 }, // SerboCroatian/Yugoslavia
    {    102,   120,    44,   160,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199, 15099, 15148,   325,   117,   117,   307, 10398, 10426,   117,NULL,0,NULL,0 }, // Sesotho/Lesotho
    {    102,   195,    44,   160,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199, 15099, 15148,   325,   117,   117,   307, 10398, 10426,   117,NULL,0,NULL,0 }, // Sesotho/SouthAfrica
    {    103,   195,    44,   160,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199, 15254, 15303,   325,   117,   117,   307, 10488, 10516,   117,NULL,0,NULL,0 }, // Setswana/SouthAfrica
    {    106,   198,    46,    44,    59,    37,    48,    45,    43,   101,    77,  1264,    20,    28,   161,   161,  2751, 15421, 15560,   325,   117,   117, 10581, 10625, 10702,   117,locale_lang106_terr198_am,5,locale_lang106_terr198_pm,4 }, // Singhalese/SriLanka
    {    107,   195,    44,   160,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199, 15813, 15862,   325,   117,   117,   307, 10875, 10903,   117,NULL,0,NULL,0 }, // Siswati/SouthAfrica
    {    107,   204,    44,   160,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199, 15813, 15862,   325,   117,   117,   307, 10875, 10903,   117,NULL,0,NULL,0 }, // Siswati/Swaziland
    {    108,   191,    44,   160,    59,    37,    48,    45,    43,   101,   781,   671,   262,   323,   161,   161,  2726, 15977, 16029,   325,   117,   117, 10972, 10988, 11011,   117,NULL,0,NULL,0 }, // Slovak/Slovakia
    {    109,   192,    44,    46,    59,    37,    48,    45,    43,   101,   479,   808,   262,   323,   161,   161,  2726, 14968, 16119,   325,   117,   117, 11066, 11082, 11112,   117,NULL,0,NULL,0 }, // Slovenian/Slovenia
    {    110,   194,    46,    44,    59,    37,    48,    45,    43,   101,    29,    57,    20,    28,   161,   161,  2824, 16206, 16255,   325,   117,   117, 11166, 11181, 11210,   117,locale_lang110_terr194_am,2,locale_lang110_terr194_pm,2 }, // Somali/Somalia
    {    110,    59,    46,    44,    59,    37,    48,    45,    43,   101,    29,    57,    20,    28,   161,   161,  2824, 16206, 16255,   325,   117,   117, 11166, 11181, 11210,   117,locale_lang110_terr59_am,2,locale_lang110_terr59_pm,2 }, // Somali/Djibouti
    {    110,    69,    46,    44,    59,    37,    48,    45,    43,   101,    29,    57,    20,    28,   161,   161,  2824, 16206, 16255,   325,   117,   117, 11166, 11181, 11210,   117,locale_lang110_terr69_am,2,locale_lang110_terr69_pm,2 }, // Somali/Ethiopia
    {    110,   111,    46,    44,    59,    37,    48,    45,    43,   101,    29,    57,    20,    28,   161,   161,  2824, 16206, 16255,   325,   117,   117, 11166, 11181, 11210,   117,locale_lang110_terr111_am,2,locale_lang110_terr111_pm,2 }, // Somali/Kenya
    {    111,   197,    44,    46,    59,    37,    48,    45,    43,   101,    29,   549,    40,    76,   161,   161,  2849, 16445, 16494,   325,   117,   117,  3945, 11258, 11289,   117,locale_lang111_terr197_am,4,locale_lang111_terr197_pm,4 }, // Spanish/Spain
    {    111,    10,    44,    46,    59,    37,    48,    45,    43,   101,    29,   549,    40,   704,   161,   161,  2849, 16445, 16494,   325,   117,   117,  3945, 11258, 11289,   117,locale_lang111_terr10_am,4,locale_lang111_terr10_pm,4 }, // Spanish/Argentina
    {    111,    26,    44,    46,    59,    37,    48,    45,    43,   101,    29,   549,    40,    76,   161,   161,  2849, 16445, 16494,   325,   117,   117,  3945, 11258, 11289,   117,locale_lang111_terr26_am,4,locale_lang111_terr26_pm,4 }, // Spanish/Bolivia
    {    111,    43,    44,    46,    59,    37,    48,    45,    43,   101,   714,   549,   262,    46,   161,   161,  2849, 16445, 16494,   325,   117,   117,  3945, 11258, 11289,   117,locale_lang111_terr43_am,4,locale_lang111_terr43_pm,4 }, // Spanish/Chile
    {    111,    47,    44,    46,    59,    37,    48,    45,    43,   101,   723,   549,   262,    46,   161,   161,  2849, 16445, 16494,   325,   117,   117,  3945, 11258, 11289,   117,locale_lang111_terr47_am,4,locale_lang111_terr47_pm,4 }, // Spanish/Colombia
    {    111,    52,    44,    46,    59,    37,    48,    45,    43,   101,    29,   549,    40,    76,   161,   161,  2849, 16445, 16494,   325,   117,   117,  3945, 11258, 11289,   117,locale_lang111_terr52_am,4,locale_lang111_terr52_pm,4 }, // Spanish/CostaRica
    {    111,    61,    46,    44,    59,    37,    48,    45,    43,   101,    29,   549,    40,    76,   161,   161,  2849, 16445, 16494,   325,   117,   117,  3945, 11258, 11289,   117,locale_lang111_terr61_am,4,locale_lang111_terr61_pm,4 }, // Spanish/DominicanRepublic
    {    111,    63,    44,    46,    59,    37,    48,    45,    43,   101,    29,   549,   262,    46,   161,   161,  2849, 16445, 16494,   325,   117,   117,  3945, 11258, 11289,   117,locale_lang111_terr63_am,4,locale_lang111_terr63_pm,4 }, // Spanish/Ecuador
    {    111,    65,    46,    44,    59,    37,    48,    45,    43,   101,    29,   549,    40,    76,   161,   161,  2849, 16445, 16494,   325,   117,   117,  3945, 11258, 11289,   117,locale_lang111_terr65_am,4,locale_lang111_terr65_pm,4 }, // Spanish/ElSalvador
    {    111,    90,    46,    44,    59,    37,    48,    45,    43,   101,   723,   549,    40,    76,   161,   161,  2849, 16445, 16494,   325,   117,   117,  3945, 11258, 11289,   117,locale_lang111_terr90_am,4,locale_lang111_terr90_pm,4 }, // Spanish/Guatemala
    {    111,    96,    46,    44,    59,    37,    48,    45,    43,   101,    29,  1282,    40,    76,   161,   161,  2849, 16445, 16494,   325,   117,   117,  3945, 11258, 11289,   117,locale_lang111_terr96_am,4,locale_lang111_terr96_pm,4 }, // Spanish/Honduras
    {    111,   139,    46,    44,    59,    37,    48,    45,    43,   101,    29,   549,    40,    76,   161,   161,  2849, 16445, 16494,   325,   117,   117,  3945, 11258, 11289,   117,locale_lang111_terr139_am,4,locale_lang111_terr139_pm,4 }, // Spanish/Mexico
    {    111,   155,    46,    44,    59,    37,    48,    45,    43,   101,    29,   549,    40,    76,   161,   161,  2849, 16445, 16494,   325,   117,   117,  3945, 11258, 11289,   117,locale_lang111_terr155_am,4,locale_lang111_terr155_pm,4 }, // Spanish/Nicaragua
    {    111,   166,    46,    44,    59,    37,    48,    45,    43,   101,   228,   549,    40,    76,   161,   161,  2849, 16445, 16494,   325,   117,   117,  3945, 11258, 11289,   117,locale_lang111_terr166_am,4,locale_lang111_terr166_pm,4 }, // Spanish/Panama
    {    111,   168,    44,    46,    59,    37,    48,    45,    43,   101,    29,   549,    40,    76,   161,   161,  2849, 16445, 16494,   325,   117,   117,  3945, 11258, 11289,   117,locale_lang111_terr168_am,4,locale_lang111_terr168_pm,4 }, // Spanish/Paraguay
    {    111,   169,    46,    44,    59,    37,    48,    45,    43,   101,   723,   549,    40,   718,   161,   161,  2849, 16445, 16494,   325,   117,   117,  3945, 11258, 11289,   117,locale_lang111_terr169_am,4,locale_lang111_terr169_pm,4 }, // Spanish/Peru
    {    111,   174,    46,    44,    59,    37,    48,    45,    43,   101,   228,   549,    40,    76,   161,   161,  2849, 16445, 16494,   325,   117,   117,  3945, 11258, 11289,   117,locale_lang111_terr174_am,4,locale_lang111_terr174_pm,4 }, // Spanish/PuertoRico
    {    111,   225,    46,    44,    59,    37,    48,    45,    43,   101,   731,   549,    20,    28,   161,   161,  2849, 16445, 16494,   325,   117,   117,  3945, 11258, 11289,   117,locale_lang111_terr225_am,4,locale_lang111_terr225_pm,4 }, // Spanish/UnitedStates
    {    111,   227,    44,    46,    59,    37,    48,    45,    43,   101,    29,   549,    40,    76,   161,   161,  2849, 16445, 16494,   325,   117,   117,  3945, 11258, 11289,   117,locale_lang111_terr227_am,4,locale_lang111_terr227_pm,4 }, // Spanish/Uruguay
    {    111,   231,    44,    46,    59,    37,    48,    45,    43,   101,    29,   549,    40,    76,   161,   161,  2849, 16445, 16494,   325,   117,   117,  3945, 11258, 11289,   117,locale_lang111_terr231_am,4,locale_lang111_terr231_pm,4 }, // Spanish/Venezuela
    {    113,   111,    46,    44,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199, 16584, 16633,   325,   117,   117,   307, 11345, 11374,   117,NULL,0,NULL,0 }, // Swahili/Kenya
    {    113,   210,    46,    44,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199, 16584, 16633,   325,   117,   117,   307, 11345, 11374,   117,NULL,0,NULL,0 }, // Swahili/Tanzania
    {    114,   205,    44,   160,    59,    37,    48,  8722,    43,   101,   106,  1310,   246,   582,   161,   161,   136,  5211, 16718,   325,   117,   117,  3431, 11435, 11468,   117,locale_lang114_terr205_am,2,locale_lang114_terr205_pm,2 }, // Swedish/Sweden
    {    114,    73,    44,   160,    59,    37,    48,  8722,    43,   101,   106,  1310,   246,   582,   161,   161,   136,  5211, 16718,   325,   117,   117,  3431, 11435, 11468,   117,locale_lang114_terr73_am,2,locale_lang114_terr73_pm,2 }, // Swedish/Finland
    {    116,   209,    46,    44,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199, 16805, 16890,   325,   117,   117,   307, 11522, 11572,   117,NULL,0,NULL,0 }, // Tajik/Tajikistan
    {    117,   100,    46,    44,    59,    37,    48,    45,    43,   101,   836,   117,    20,    28,   161,   161,   199, 17021, 17154,   325,   117,   117,   307, 11676, 11723,   117,locale_lang117_terr100_am,4,locale_lang117_terr100_pm,4 }, // Tamil/India
    {    118,   178,    44,   160,    59,    37,    48,    45,    43,   101,  1200,  1333,   262,    28,   161,   161,   199,   136,   136,   325,   117,   117,   307,   307,   307,   117,NULL,0,NULL,0 }, // Tatar/RussianFederation
    {    119,   100,    46,    44,    59,    37,  3174,    45,    43,   101,   714,   117,    20,    28,   161,   161,  2874, 17389, 17389,   325,   117,   117, 11857, 11896, 11979,   117,locale_lang119_terr100_am,10,locale_lang119_terr100_pm,8 }, // Telugu/India
    {    120,   211,    46,    44,    59,    37,    48,    45,    43,   101,   486,  1345,   262,   733,   161,   161,  2941, 17624, 17742,   325,   117,   117, 12146, 12175, 12217, 12408,locale_lang120_terr211_am,10,locale_lang120_terr211_pm,10 }, // Thai/Thailand
    {    122,    67,    46,    44,    59,    37,    48,    45,    43,   101,    29,  1373,    20,    28,   161,   161,   252, 18013, 18128,   325,   117,   117, 12422, 12451, 12522,   117,locale_lang122_terr67_am,7,locale_lang122_terr67_pm,7 }, // Tigrinya/Eritrea
    {    122,    69,    46,    44,    59,    37,    48,    45,    43,   101,    29,  1409,    20,    28,   161,   161,   252,   908,  1023,   325,   117,   117, 12422, 12596, 12667,   117,locale_lang122_terr69_am,7,locale_lang122_terr69_pm,7 }, // Tigrinya/Ethiopia
    {    123,   214,    46,    44,    59,    37,    48,    45,    43,   101,  1445,   117,    40,    46,   161,   161,  3059, 18267, 18328,   325,   117,   117, 12741, 12756, 12789,   117,NULL,0,NULL,0 }, // Tonga/Tonga
    {    124,   195,    44,   160,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199, 18425, 18474,   325,   117,   117,   307, 12853, 12881,   117,NULL,0,NULL,0 }, // Tsonga/SouthAfrica
    {    125,   217,    44,    46,    59,    37,    48,    45,    43,   101,  1200,  1456,    40,    46,   161,   161,  3084, 18597, 18648,   325,   117,   117, 12954, 12970, 13000,   117,locale_lang125_terr217_am,2,locale_lang125_terr217_pm,2 }, // Turkish/Turkey
    {    128,    44,    46,    44,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199,   136,   136,   325,   117,   117,   307,   307,   307,   117,NULL,0,NULL,0 }, // Uigur/China
    {    129,   222,    44,   160,    59,    37,    48,    45,    43,   101,   451,  1474,    40,    46,  3110,  3195,  3374, 18730, 18841,   325,   117,   117, 13059, 13081, 13117,   117,locale_lang129_terr222_am,2,locale_lang129_terr222_pm,2 }, // Ukrainian/Ukraine
    {    130,   100,    46,    44,    59,    37,    48,    45,    43,  1602,   325,   762,    20,    28,   161,   161,  2186,   325, 19004,   325,   117,   117,   307,   117, 13223, 13289,NULL,0,NULL,0 }, // Urdu/India
    {    130,   163,    46,    44,    59,    37,    48,    45,    43,  1602,   325,   762,    20,    28,   161,   161,  2186,   325, 19004,   325,   117,   117,   307,   117, 13223, 13289,NULL,0,NULL,0 }, // Urdu/Pakistan
    {    131,   228,    44,   160,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,  2689, 16805, 19126,   325,   117,   117, 13311, 13333, 13383,   117,NULL,0,NULL,0 }, // Uzbek/Uzbekistan
    {    131,     1,    44,   160,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,  2689, 16805, 19126,   325,   117,   117, 13311, 13333, 13383,   117,NULL,0,NULL,0 }, // Uzbek/Afghanistan
    {    132,   232,    44,    46,    59,    37,    48,    45,    43,   101,   751,  1498,    40,    46,   161,   161,   199, 19339, 19415,   325,   117,   117,   307, 13483, 13517,   117,locale_lang132_terr232_am,2,locale_lang132_terr232_pm,2 }, // Vietnamese/VietNam
    {    134,   224,    46,    44,    59,    37,    48,    45,    43,   101,   751,   143,    20,    28,  3411,  3437,  3460, 19578, 19641,   325, 13594,   117, 13605, 13620, 13651,   117,NULL,0,NULL,0 }, // Welsh/UnitedKingdom
    {    135,   187,    46,    44,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199,   136,   136,   325,   117,   117,   307,   307,   307,   117,NULL,0,NULL,0 }, // Wolof/Senegal
    {    136,   195,    44,   160,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199, 19728, 19777,   325,   117,   117,   307, 13729, 13758,   117,NULL,0,NULL,0 }, // Xhosa/SouthAfrica
    {    138,   157,    46,    44,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199, 19869, 19986,   325,   117,   117,   307, 13820, 13906,   117,locale_lang138_terr157_am,5,locale_lang138_terr157_pm,5 }, // Yoruba/Nigeria
    {    140,   195,    44,   160,    59,    37,    48,    45,    43,   101,   106,    88,    20,    28,   161,  3485,   136, 20187, 20236,   325,   117,   117, 14052, 14067, 14096,   117,NULL,0,NULL,0 }, // Zulu/SouthAfrica
    {    141,   161,    44,   160,    59,    37,    48,  8722,    43,   101,   451,   790,   246,   582,   161,   161,   136,  5637, 12676,   325, 14165,   117,  3431, 14180, 14205,   117,locale_lang141_terr161_am,9,locale_lang141_terr161_pm,11 }, // Nynorsk/Norway
    {    142,    27,    44,    46,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199, 20327, 20376,   325,   117,   117,   307, 14259, 14289,   117,NULL,0,NULL,0 }, // Bosnian/BosniaAndHerzegowina
    {    143,   131,    46,    44,  1548,    37,  1632,    45,    43,   101,   836,   117,   462,    76,   161,   161,   199,   136,   136,   325,   117,   117,   307,   307,   307,   117,NULL,0,NULL,0 }, // Divehi/Maldives
    {    144,   224,    46,    44,    59,    37,    48,    45,    43,   101,    29,    88,    40,    46,   161,   161,   199, 20460, 20563,   325,   117,   117,   307, 14349, 14380,   117,locale_lang144_terr224_am,4,locale_lang144_terr224_pm,4 }, // Manx/UnitedKingdom
    {    145,   224,    46,    44,    59,    37,    48,    45,    43,   101,   751,   117,    40,    46,   161,   161,   199, 20704, 20751,   325,   117,   117,   307, 14438, 14467,   117,locale_lang145_terr224_am,4,locale_lang145_terr224_pm,4 }, // Cornish/UnitedKingdom
    {    146,    83,    46,    44,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199, 20876, 20933,   325,   117,   117, 14528, 14543, 14572,   117,NULL,0,NULL,0 }, // Akan/Ghana
    {    147,   100,    46,    44,    59,    37,    48,    45,    43,   101,   836,   117,    20,    28,   161,   161,   199, 21148, 11795,   325,   117,   117,   307,  8073, 14622,   117,locale_lang147_terr100_am,5,locale_lang147_terr100_pm,5 }, // Konkani/India
    {    148,    83,    46,    44,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199, 21380, 21429,   325,   117,   117,   307, 14774, 14801,   117,NULL,0,NULL,0 }, // Ga/Ghana
    {    149,   157,    46,    44,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199, 21524, 21579,   325,   117,   117,   307, 14836, 14876,   117,NULL,0,NULL,0 }, // Igbo/Nigeria
    {    150,   111,    46,    44,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199, 21686, 21686,   325,   117,   117,   307, 14950, 14979,   117,NULL,0,NULL,0 }, // Kamba/Kenya
    {    151,   207,    46,    44,    59,    37,    48,    45,    43,   101,   751,  1532,   563,    28,   161,   161,   199, 21876, 21995,   325,   117,   117,   307,   307,   307,   117,NULL,0,NULL,0 }, // Syriac/SyrianArabRepublic
    {    152,    67,    46,    44,    59,    37,    48,    45,    43,   101,    29,  1546,    20,    28,   161,   161,  3590, 22110, 22224,   325,   117,   117, 15039, 15068, 15129,   117,NULL,0,NULL,0 }, // Blin/Eritrea
    {    153,    67,    46,  4808,    59,    37,    48,    45,    43,   101,    29,  1579,    20,    28,   161,   161,  3639, 22424, 22545,   325,   117,   117, 15237, 15266, 15337,   117,NULL,0,NULL,0 }, // Geez/Eritrea
    {    153,    69,    46,  4808,    59,    37,    48,    45,    43,   101,    29,  1579,    20,    28,   161,   161,  3639, 22424, 22545,   325,   117,   117, 15237, 15266, 15337,   117,NULL,0,NULL,0 }, // Geez/Ethiopia
    {    154,    53,    46,    44,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199, 22669, 22718,   325,   117,   117,   307, 15411, 15440,   117,NULL,0,NULL,0 }, // Koro/IvoryCoast
    {    155,    69,    46,    44,    59,    37,    48,    45,    43,   101,    29,    57,    20,    28,   161,   161,   136,     0,    49,   325,   117,   117, 15495, 15510, 15539,   117,NULL,0,NULL,0 }, // Sidamo/Ethiopia
    {    156,   157,    46,    44,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199, 22843, 22903,   325,   117,   117,   307, 15591, 15627,   117,NULL,0,NULL,0 }, // Atsam/Nigeria
    {    157,    67,    46,    44,    59,    37,    48,    45,    43,   101,    29,  1615,    20,    28,   161,   161,   252,   908,  1023,   325,   117,   117, 15715, 15744, 15808,   117,NULL,0,NULL,0 }, // Tigre/Eritrea
    {    158,   157,    46,    44,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199, 23033, 23100,   325,   117,   117,   307, 15914, 15943,   117,NULL,0,NULL,0 }, // Jju/Nigeria
    {    159,   106,    46,    44,    59,    37,    48,    45,    43,   101,   723,  1645,    40,    46,   161,   161,  3688, 23290, 23339,   325,   117,   117,  3945, 15988, 16017,   117,NULL,0,NULL,0 }, // Friulian/Italy
    {    160,   195,    44,   160,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199, 23421, 23476,   325,   117,   117,   307, 16068, 16100,   117,NULL,0,NULL,0 }, // Venda/SouthAfrica
    {    161,    83,    46,    44,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,  3713, 23594, 23644,   325,   117,   117, 16183, 16198, 16234,   117,NULL,0,NULL,0 }, // Ewe/Ghana
    {    161,   212,    46,    44,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,  3713, 23594, 23644,   325,   117,   117, 16183, 16198, 16234,   117,NULL,0,NULL,0 }, // Ewe/Togo
    {    163,   225,    46,    44,    59,    37,    48,    45,    43,   101,   325,    11,    20,    28,   161,   161,   199, 23739, 23802,   325,   117,   117,   307, 16287, 16309,   117,NULL,0,NULL,0 }, // Hawaiian/UnitedStates
    {    164,   157,    46,    44,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199, 23901, 23950,   325,   117,   117,   307, 16375, 16404,   117,NULL,0,NULL,0 }, // Tyap/Nigeria
    {    165,   129,    46,    44,    59,    37,    48,    45,    43,   101,   265,   274,    40,    46,   161,   161,   199, 24104, 24153,   325,   117,   117,   307, 16447, 16476,   117,NULL,0,NULL,0 }, // Chewa/Malawi
    {      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    0,    0,    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 }  // trailing 0s
};

static const char date_format_data[] =
"d MMM yyyy\0"
"dddd, d MMMM yyyy\0"
"dd/MM/yy\0"
"dddd, MMMM d, yyyy\0"
"dddd, MMMM dd, yyyy\0"
"yyyy/MM/dd\0"
"dddd dd MMMM yyyy\0"
"yyyy-MM-dd\0"
"dddd d MMMM yyyy\0"
"yy-MM-dd\0"
"dddd, dd MMMM yyyy\0"
"dddd\xe1\x8d\xa3 dd MMMM \xe1\x89\x80\xe1\x8a\x95 yyyy G\0"
"d\xe2\x80\x8f/M\xe2\x80\x8f/yyyy\0"
"dddd\xd8\x8c d MMMM\xd8\x8c yyyy\0"
"MM/dd/yy\0"
"d-M-yyyy\0"
"dddd, d MMMM, yyyy\0"
"yy/MM/dd\0"
"dddd, yyyy MMMM dd\0"
"dddd, yyyy'eko' MMMM'ren' dd'a'\0"
"d/M/yy\0"
"\xe0\xbd\xa6\xe0\xbe\xa4\xe0\xbe\xb1\xe0\xbd\xb2\xe0\xbc\x8b\xe0\xbd\xa3\xe0\xbd\xbc"
"\xe0\xbc\x8b yyyy \xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbc\x8b MM \xe0\xbd\x9a\xe0\xbd\xba"
"\xe0\xbd\xa6\xe0\xbc\x8b dd\0"
"\xe0\xbd\xa6\xe0\xbe\xa4\xe0\xbe\xb1\xe0\xbd\xb2\xe0\xbc\x8b\xe0\xbd\xa3\xe0\xbd\xbc"
"\xe0\xbc\x8byyyy \xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbc\x8b MMMM \xe0\xbd\x9a\xe0\xbd\xba"
"\xe0\xbd\xa6\xe0\xbc\x8b dd\0"
"dd.MM.yy\0"
"dd MMMM yyyy, dddd\0"
"d.M.yy\0"
"d/M/yyyy\0"
"dddd \xe1\x9e\x90\xe1\x9f\x92\xe1\x9e\x84\xe1\x9f\x83 d \xe1\x9e\x81\xe1\x9f\x82 "
"MMMM \xe1\x9e\x86\xe1\x9f\x92\xe1\x9e\x93\xe1\x9e\xb6\xe1\x9f\x86  yyyy\0"
"dddd d 'de' MMMM 'de' yyyy\0"
"yy-M-d\0"
"yyyy\xe5\xb9\xb4M\xe6\x9c\x88\x64\xe6\x97\xa5\x64\x64\x64\x64\0"
"yy\xe5\xb9\xb4M\xe6\x9c\x88\x64\xe6\x97\xa5\0"
"yyyy\xe5\xb9\xb4MM\xe6\x9c\x88\x64\x64\xe6\x97\xa5\x64\x64\x64\x64\0"
"dd.MM.yyyy.\0"
"dddd, d. MMMM yyyy.\0"
"dddd, d. MMMM yyyy\0"
"dddd 'den' d. MMMM yyyy\0"
"dd-MM-yy\0"
"d/MM/yy\0"
"M/d/yy\0"
"dd MMMM yyyy\0"
"dd/MM/yyyy\0"
"dddd, d, MMMM yyyy\0"
"d.M.yyyy\0"
"dddd d. MMMM yyyy\0"
"dddd, dd. MMMM yyyy\0"
"d-MM-yy\0"
"d-M-yy\0"
"yyyy.MM.dd.\0"
"yyyy. MMMM d.\0"
"dddd, d MMMM yyyy '\xd0\xb6'.\0"
"yy. M. d.\0"
"yyyy\xeb\x85\x84 M\xec\x9b\x94 d\xec\x9d\xbc dddd\0"
"dddd\xe0\xba\x97\xe0\xba\xb5  d MMMM G yyyy\0"
"yy.d.M\0"
"dddd, yyyy. 'gada' d. MMMM\0"
"yyyy 'm'. MMMM d 'd'.,dddd\0"
"dd.M.yy\0"
"dddd dd MMM yyyy\0"
"yyyy, MMMM d, dddd\0"
"dddd, d 'ta'\xe2\x80\x99 MMMM yyyy\0"
"MMMM d,dddd, yyyy\0"
"yyyy/M/d\0"
"dddd \xd8\xaf yyyy \xd8\xaf MMMM d\0"
"yy/M/d\0"
"dddd d MMMM yyyy GGGG\0"
"dddd, d 'de' MMMM 'de' yyyy\0"
"dd/MM/yyy\0"
"dd.MM.yyyy\0"
"dddd, d MMMM yyyy '\xd0\xb3'.\0"
"d.M.yy.\0"
"dddd, dd. MMMM yyyy.\0"
"dddd, yyyy MMMM d\0"
"dddd dd 'de' MMMM 'de' yyyy\0"
"dddd 'den' d MMMM yyyy\0"
"d MMMM yyyy\0"
"dddd\xe0\xb8\x97\xe0\xb8\xb5\xe0\xb9\x88 d MMMM G yyyy\0"
"dddd\xe1\x8d\xa1 dd MMMM \xe1\x88\x98\xe1\x8b\x93\xe1\x88\x8d\xe1\x89\xb2 yyyy G\0"
"dddd\xe1\x8d\xa3 dd MMMM \xe1\x88\x98\xe1\x8b\x93\xe1\x88\x8d\xe1\x89\xb2 yyyy G\0"
"dd-MM-yyyy\0"
"dd MMMM yyyy dddd\0"
"dddd, d MMMM yyyy '\xd1\x80'.\0"
"dddd, 'ng\xc3\xa0y' dd MMMM 'n\xc4\x83m' yyyy\0"
"dd MMMM, yyyy\0"
"dddd\xe1\x8d\xa1 dd MMMM \xe1\x8c\x8d\xe1\x88\xad\xe1\x8c\x8b yyyy G\0"
"dddd\xe1\x8d\xa5 dd MMMM \xe1\x88\x98\xe1\x8b\x93\xe1\x88\x8d\xe1\x89\xb5 yyyy G\0"
"dddd\xe1\x8d\xa1 dd MMMM \xe1\x8b\xae\xe1\x88\x9d yyyy G\0"
"dddd d 'di' MMMM 'dal' yyyy\0"
;

static const char time_format_data[] =
"HH:mm:ss\0"
"HH:mm:ss t\0"
"h:mm AP\0"
"h:mm:ss AP \0"
"HH:mm\0"
"HH:mm:ss \0"
"h.mm.AP\0"
"h.mm.ss.AP \0"
"hh:mm:ss AP \0"
" h:mm:ss AP\0"
"h.mm. AP\0"
"h.mm.ss AP \0"
"\xe0\xbd\x86\xe0\xbd\xb4\xe0\xbc\x8b\xe0\xbd\x9a\xe0\xbd\xbc\xe0\xbd\x91\xe0\xbc\x8b"
" h \xe0\xbd\xa6\xe0\xbe\x90\xe0\xbd\xa2\xe0\xbc\x8b\xe0\xbd\x98\xe0\xbc\x8b mm AP"
"\0"
"\xe0\xbd\x86\xe0\xbd\xb4\xe0\xbc\x8b\xe0\xbd\x9a\xe0\xbd\xbc\xe0\xbd\x91\xe0\xbc\x8b"
" h \xe0\xbd\xa6\xe0\xbe\x90\xe0\xbd\xa2\xe0\xbc\x8b\xe0\xbd\x98\xe0\xbc\x8b mm \xe0"
"\xbd\xa6\xe0\xbe\x90\xe0\xbd\xa2\xe0\xbc\x8b\xe0\xbd\x86\xe0\xbd\xb1\xe0\xbc\x8b "
"ss AP \0"
"HH.mm\0"
"HH.mm.ss \0"
"H:mm\0"
"H \xe1\x9e\x98\xe1\x9f\x89\xe1\x9f\x84\xe1\x9e\x84 m \xe1\x9e\x93\xe1\x9e\xb6\xe1"
"\x9e\x91\xe1\x9e\xb8 ss \xe1\x9e\x9c\xe1\x9e\xb7\xe1\x9e\x93\xe1\x9e\xb6\xe1\x9e\x91"
"\xe1\x9e\xb8\xe2\x80\x8b \0"
"H:mm:ss \0"
"APh:mm\0"
"APhh\xe6\x97\xb6mm\xe5\x88\x86ss\xe7\xa7\x92\0"
"APhh:mm\0"
"HH 'h' mm 'min' ss 's' \0"
"AP hh:mm\0"
"AP hh:mm:ss \0"
"H.mm\0"
"H.mm.ss \0"
"H 'h' mm 'min' ss 's' \0"
"HH.mm:ss 'h' \0"
"hh:mm AP\0"
"H\xe6\x99\x82mm\xe5\x88\x86ss\xe7\xa7\x92\0"
"AP h:mm\0"
"AP hh\xec\x8b\x9c mm\xeb\xb6\x84 ss\xec\xb4\x88 \0"
"H\xe0\xbb\x82\xe0\xba\xa1\xe0\xba\x87 m\xe0\xba\x99\xe0\xba\xb2\xe0\xba\x97\xe0\xba"
"\xb5 ss \xe0\xba\xa7\xe0\xba\xb4\xe0\xba\x99\xe0\xba\xb2\xe0\xba\x97\xe0\xba\xb5\0"
"h:mm\0"
"h:mm:ss APAP \0"
"'kl'. HH.mm.ss \0"
"H:mm:ss ()\0"
"HH'H'mm'm'ss's' \0"
"HH'h'mm'min'ss's' \0"
"HH '\xd1\x87\xd0\xb0\xd1\x81\xd0\xbe\xd0\xb2\xd0\xb0', mm '\xd0\xbc\xd0\xb8\xd0\xbd"
"\xd1\x83\xd1\x82\xd0\xb0', ss '\xd1\x81\xd0\xb5\xd0\xba\xd1\x83\xd0\xbd\xd0\xb4\xd0"
"\xb8' \0"
"HH'h'''mm:ss \0"
"HH'H'mm''ss\" \0"
"H \xe0\xb8\x99\xe0\xb8\xb2\xe0\xb8\xac\xe0\xb8\xb4\xe0\xb8\x81\xe0\xb8\xb2 m \xe0"
"\xb8\x99\xe0\xb8\xb2\xe0\xb8\x97\xe0\xb8\xb5 ss \xe0\xb8\xa7\xe0\xb8\xb4\xe0\xb8\x99"
"\xe0\xb8\xb2\xe0\xb8\x97\xe0\xb8\xb5 \0"
;

static const char months_data[] =
"Jan;Feb;Mar;Apr;May;Jun;Jul;Aug;Sep;Oct;Nov;Dec;\0"
"January;February;March;April;May;June;July;August;September;October;November;Dece"
"mber;\0"
"1;2;3;4;5;6;7;8;9;10;11;12;\0"
"Ama;Gur;Bit;Elb;Cam;Wax;Ado;Hag;Ful;Onk;Sad;Mud;\0"
"Amajjii;Guraandhala;Bitooteessa;Elba;Caamsa;Waxabajjii;Adooleessa;Hagayya;Fuulban"
"a;Onkololeessa;Sadaasa;Muddee;\0"
";;;;;;;;;;;;\0"
"Qun;Nah;Cig;Agd;Cax;Qas;Qad;Leq;Way;Dit;Xim;Kax;\0"
"Qunxa Garablu;Naharsi Kudo;Ciggilta Kudo;Agda Baxisso;Caxah Alsa;Qasa Dirri;Qado "
"Dirri;Leqeeni;Waysu;Diteli;Ximoli;Kaxxa Garablu;\0"
"Qunxa Garablu;Kudo;Ciggilta Kudo;Agda Baxis;Caxah Alsa;Qasa Dirri;Qado Dirri;Liiq"
"en;Waysu;Diteli;Ximoli;Kaxxa Garablu;\0"
"Jan;Feb;Mar;Apr;Mei;Jun;Jul;Aug;Sep;Okt;Nov;Des;\0"
"Januarie;Februarie;Maart;April;Mei;Junie;Julie;Augustus;September;Oktober;Novembe"
"r;Desember;\0"
"Jan;Shk;Mar;Pri;Maj;Qer;Kor;Gsh;Sht;Tet;N\xc3\xabn;Dhj;\0"
"janar;shkurt;mars;prill;maj;qershor;korrik;gusht;shtator;tetor;n\xc3\xabntor;dhje"
"tor;\0"
"\xe1\x8c\x83\xe1\x8a\x95\xe1\x8b\xa9;\xe1\x8d\x8c\xe1\x89\xa5\xe1\x88\xa9;\xe1\x88"
"\x9b\xe1\x88\xad\xe1\x89\xbd;\xe1\x8a\xa4\xe1\x8d\x95\xe1\x88\xa8;\xe1\x88\x9c\xe1"
"\x8b\xad;\xe1\x8c\x81\xe1\x8a\x95;\xe1\x8c\x81\xe1\x88\x8b\xe1\x8b\xad;\xe1\x8a\xa6"
"\xe1\x8c\x88\xe1\x88\xb5;\xe1\x88\xb4\xe1\x8d\x95\xe1\x89\xb4;\xe1\x8a\xa6\xe1\x8a"
"\xad\xe1\x89\xb0;\xe1\x8a\x96\xe1\x89\xac\xe1\x88\x9d;\xe1\x8b\xb2\xe1\x88\xb4\xe1"
"\x88\x9d;\0"
"\xe1\x8c\x83\xe1\x8a\x95\xe1\x8b\xa9\xe1\x8b\x88\xe1\x88\xaa;\xe1\x8d\x8c\xe1\x89"
"\xa5\xe1\x88\xa9\xe1\x8b\x88\xe1\x88\xaa;\xe1\x88\x9b\xe1\x88\xad\xe1\x89\xbd;\xe1"
"\x8a\xa4\xe1\x8d\x95\xe1\x88\xa8\xe1\x88\x8d;\xe1\x88\x9c\xe1\x8b\xad;\xe1\x8c\x81"
"\xe1\x8a\x95;\xe1\x8c\x81\xe1\x88\x8b\xe1\x8b\xad;\xe1\x8a\xa6\xe1\x8c\x88\xe1\x88"
"\xb5\xe1\x89\xb5;\xe1\x88\xb4\xe1\x8d\x95\xe1\x89\xb4\xe1\x88\x9d\xe1\x89\xa0\xe1"
"\x88\xad;\xe1\x8a\xa6\xe1\x8a\xad\xe1\x89\xb0\xe1\x8b\x8d\xe1\x89\xa0\xe1\x88\xad"
";\xe1\x8a\x96\xe1\x89\xac\xe1\x88\x9d\xe1\x89\xa0\xe1\x88\xad;\xe1\x8b\xb2\xe1\x88"
"\xb4\xe1\x88\x9d\xe1\x89\xa0\xe1\x88\xad;\0"
"\xd9\x8a\xd9\x86\xd8\xa7\xd9\x8a\xd8\xb1;\xd9\x81\xd8\xa8\xd8\xb1\xd8\xa7\xd9\x8a"
"\xd8\xb1;\xd9\x85\xd8\xa7\xd8\xb1\xd8\xb3;\xd8\xa3\xd8\xa8\xd8\xb1\xd9\x8a\xd9\x84"
";\xd9\x85\xd8\xa7\xd9\x8a\xd9\x88;\xd9\x8a\xd9\x88\xd9\x86\xd9\x8a\xd9\x88;\xd9\x8a"
"\xd9\x88\xd9\x84\xd9\x8a\xd9\x88;\xd8\xa3\xd8\xba\xd8\xb3\xd8\xb7\xd8\xb3;\xd8\xb3"
"\xd8\xa8\xd8\xaa\xd9\x85\xd8\xa8\xd8\xb1;\xd8\xa3\xd9\x83\xd8\xaa\xd9\x88\xd8\xa8"
"\xd8\xb1;\xd9\x86\xd9\x88\xd9\x81\xd9\x85\xd8\xa8\xd8\xb1;\xd8\xaf\xd9\x8a\xd8\xb3"
"\xd9\x85\xd8\xa8\xd8\xb1;\0"
"\xd9\x83\xd8\xa7\xd9\x86\xd9\x88\xd9\x86 \xd8\xa7\xd9\x84\xd8\xab\xd8\xa7\xd9\x86"
"\xd9\x8a;\xd8\xb4\xd8\xa8\xd8\xa7\xd8\xb7;\xd8\xa2\xd8\xb0\xd8\xa7\xd8\xb1;\xd9\x86"
"\xd9\x8a\xd8\xb3\xd8\xa7\xd9\x86;\xd8\xa3\xd9\x8a\xd8\xa7\xd8\xb1;\xd8\xad\xd8\xb2"
"\xd9\x8a\xd8\xb1\xd8\xa7\xd9\x86;\xd8\xaa\xd9\x85\xd9\x88\xd8\xb2;\xd8\xa2\xd8\xa8"
";\xd8\xa3\xd9\x8a\xd9\x84\xd9\x88\xd9\x84;\xd8\xaa\xd8\xb4\xd8\xb1\xd9\x8a\xd9\x86"
" \xd8\xa7\xd9\x84\xd8\xa3\xd9\x88\xd9\x84;\xd8\xaa\xd8\xb4\xd8\xb1\xd9\x8a\xd9\x86"
" \xd8\xa7\xd9\x84\xd8\xab\xd8\xa7\xd9\x86\xd9\x8a;\xd9\x83\xd8\xa7\xd9\x86\xd9\x88"
"\xd9\x86 \xd8\xa7\xd9\x84\xd8\xa3\xd9\x88\xd9\x84;\0"
"\xd9\x83\xd8\xa7\xd9\x86\xd9\x88\xd9\x86 \xd8\xa7\xd9\x84\xd8\xab\xd8\xa7\xd9\x86"
"\xd9\x8a;\xd8\xb4\xd8\xa8\xd8\xa7\xd8\xb7;\xd8\xa2\xd8\xb0\xd8\xa7\xd8\xb1;\xd9\x86"
"\xd9\x8a\xd8\xb3\xd8\xa7\xd9\x86;\xd9\x86\xd9\x88\xd8\xa7\xd8\xb1;\xd8\xad\xd8\xb2"
"\xd9\x8a\xd8\xb1\xd8\xa7\xd9\x86;\xd8\xaa\xd9\x85\xd9\x88\xd8\xb2;\xd8\xa2\xd8\xa8"
";\xd8\xa3\xd9\x8a\xd9\x84\xd9\x88\xd9\x84;\xd8\xaa\xd8\xb4\xd8\xb1\xd9\x8a\xd9\x86"
" \xd8\xa7\xd9\x84\xd8\xa3\xd9\x88\xd9\x84;\xd8\xaa\xd8\xb4\xd8\xb1\xd9\x8a\xd9\x86"
" \xd8\xa7\xd9\x84\xd8\xab\xd8\xa7\xd9\x86\xd9\x8a;\xd9\x83\xd8\xa7\xd9\x86\xd9\x88"
"\xd9\x86 \xd8\xa7\xd9\x84\xd8\xa3\xd9\x88\xd9\x84;\0"
"\xd5\x85\xd5\xb6\xd6\x80;\xd5\x93\xd5\xbf\xd6\x80;\xd5\x84\xd6\x80\xd5\xbf;\xd4\xb1"
"\xd5\xba\xd6\x80;\xd5\x84\xd5\xb5\xd5\xbd;\xd5\x85\xd5\xb6\xd5\xbd;\xd5\x85\xd5\xac"
"\xd5\xbd;\xd5\x95\xd5\xa3\xd5\xbd;\xd5\x8d\xd5\xa5\xd5\xba;\xd5\x80\xd5\xb8\xd5\xaf"
";\xd5\x86\xd5\xb8\xd5\xb5;\xd4\xb4\xd5\xa5\xd5\xaf;\0"
"\xd5\x85\xd5\xb8\xd6\x82\xd5\xb6\xd5\xb8\xd6\x82\xd5\xa1\xd6\x80;\xd5\x93\xd5\xa5"
"\xd5\xbf\xd6\x80\xd5\xb8\xd6\x82\xd5\xa1\xd6\x80;\xd5\x84\xd5\xa1\xd6\x80\xd5\xbf"
";\xd4\xb1\xd5\xba\xd6\x80\xd5\xab\xd5\xac;\xd5\x84\xd5\xa1\xd5\xb5\xd5\xab\xd5\xbd"
";\xd5\x85\xd5\xb8\xd6\x82\xd5\xb6\xd5\xab\xd5\xbd;\xd5\x85\xd5\xb8\xd6\x82\xd5\xac"
"\xd5\xab\xd5\xbd;\xd5\x95\xd5\xa3\xd5\xb8\xd5\xbd\xd5\xbf\xd5\xb8\xd5\xbd;\xd5\x8d"
"\xd5\xa5\xd5\xba\xd5\xbf\xd5\xa5\xd5\xb4\xd5\xa2\xd5\xa5\xd6\x80;\xd5\x80\xd5\xb8"
"\xd5\xaf\xd5\xbf\xd5\xa5\xd5\xb4\xd5\xa2\xd5\xa5\xd6\x80;\xd5\x86\xd5\xb8\xd5\xb5"
"\xd5\xa5\xd5\xb4\xd5\xa2\xd5\xa5\xd6\x80;\xd4\xb4\xd5\xa5\xd5\xaf\xd5\xbf\xd5\xa5"
"\xd5\xb4\xd5\xa2\xd5\xa5\xd6\x80;\0"
"\xe0\xa6\x9c\xe0\xa6\xbe\xe0\xa6\xa8\xe0\xa7\x81;\xe0\xa6\xab\xe0\xa7\x87\xe0\xa6"
"\xac\xe0\xa7\x8d\xe0\xa7\xb0\xe0\xa7\x81;\xe0\xa6\xae\xe0\xa6\xbe\xe0\xa7\xb0\xe0"
"\xa7\x8d\xe0\xa6\x9a;\xe0\xa6\x8f\xe0\xa6\xaa\xe0\xa7\x8d\xe0\xa7\xb0\xe0\xa6\xbf"
"\xe0\xa6\xb2;\xe0\xa6\xae\xe0\xa7\x87;\xe0\xa6\x9c\xe0\xa7\x81\xe0\xa6\xa8;\xe0\xa6"
"\x9c\xe0\xa7\x81\xe0\xa6\xb2\xe0\xa6\xbe\xe0\xa6\x87;\xe0\xa6\x86\xe0\xa6\x97;\xe0"
"\xa6\xb8\xe0\xa7\x87\xe0\xa6\xaa\xe0\xa7\x8d\xe0\xa6\x9f;\xe0\xa6\x85\xe0\xa6\x95"
"\xe0\xa7\x8d\xe0\xa6\x9f\xe0\xa7\x8b;\xe0\xa6\xa8\xe0\xa6\xad\xe0\xa7\x87;\xe0\xa6"
"\xa1\xe0\xa6\xbf\xe0\xa6\xb8\xe0\xa7\x87;\0"
"\xe0\xa6\x9c\xe0\xa6\xbe\xe0\xa6\xa8\xe0\xa7\x81\xe0\xa6\xaf\xe0\xa6\xbc\xe0\xa6\xbe"
"\xe0\xa7\xb0\xe0\xa7\x80;\xe0\xa6\xab\xe0\xa7\x87\xe0\xa6\xac\xe0\xa7\x8d\xe0\xa7"
"\xb0\xe0\xa7\x81\xe0\xa6\xaf\xe0\xa6\xbc\xe0\xa6\xbe\xe0\xa7\xb0\xe0\xa7\x80;\xe0"
"\xa6\xae\xe0\xa6\xbe\xe0\xa7\xb0\xe0\xa7\x8d\xe0\xa6\x9a;\xe0\xa6\x8f\xe0\xa6\xaa"
"\xe0\xa7\x8d\xe0\xa7\xb0\xe0\xa6\xbf\xe0\xa6\xb2;\xe0\xa6\xae\xe0\xa7\x87;\xe0\xa6"
"\x9c\xe0\xa7\x81\xe0\xa6\xa8;\xe0\xa6\x9c\xe0\xa7\x81\xe0\xa6\xb2\xe0\xa6\xbe\xe0"
"\xa6\x87;\xe0\xa6\x86\xe0\xa6\x97\xe0\xa6\xb7\xe0\xa7\x8d\xe0\xa6\x9f;\xe0\xa6\xb8"
"\xe0\xa7\x87\xe0\xa6\xaa\xe0\xa7\x8d\xe0\xa6\x9f\xe0\xa7\x87\xe0\xa6\xae\xe0\xa7\x8d"
"\xe0\xa6\xac\xe0\xa7\xb0;\xe0\xa6\x85\xe0\xa6\x95\xe0\xa7\x8d\xe0\xa6\x9f\xe0\xa7"
"\x8b\xe0\xa6\xac\xe0\xa7\xb0;\xe0\xa6\xa8\xe0\xa6\xad\xe0\xa7\x87\xe0\xa6\xae\xe0"
"\xa7\x8d\xe0\xa6\xac\xe0\xa7\xb0;\xe0\xa6\xa1\xe0\xa6\xbf\xe0\xa6\xb8\xe0\xa7\x87"
"\xe0\xa6\xae\xe0\xa7\x8d\xe0\xa6\xac\xe0\xa7\xb0;\0"
"yan;fev;mar;apr;may;iyn;iyl;avq;sen;okt;noy;dek;\0"
"Yanvar;Fevral;Mart;Aprel;May;\xc4\xb0yun;\xc4\xb0yul;Avqust;Sentyabr;Oktyabr;Noya"
"br;Dekabr;\0"
"urt;ots;mar;api;mai;eka;uzt;abu;ira;urr;aza;abe;\0"
"urtarrila;otsaila;martxoa;apirila;maiatza;ekaina;uztaila;abuztua;iraila;urria;aza"
"roa;abendua;\0"
"\xe0\xa6\x9c\xe0\xa6\xbe\xe0\xa6\xa8\xe0\xa7\x81\xe0\xa6\xaf\xe0\xa6\xbc\xe0\xa6\xbe"
"\xe0\xa6\xb0\xe0\xa7\x80;\xe0\xa6\xab\xe0\xa7\x87\xe0\xa6\xac\xe0\xa7\x8d\xe0\xa6"
"\xb0\xe0\xa7\x81\xe0\xa6\xaf\xe0\xa6\xbc\xe0\xa6\xbe\xe0\xa6\xb0\xe0\xa7\x80;\xe0"
"\xa6\xae\xe0\xa6\xbe\xe0\xa6\xb0\xe0\xa7\x8d\xe0\xa6\x9a;\xe0\xa6\x8f\xe0\xa6\xaa"
"\xe0\xa7\x8d\xe0\xa6\xb0\xe0\xa6\xbf\xe0\xa6\xb2;\xe0\xa6\xae\xe0\xa7\x87;\xe0\xa6"
"\x9c\xe0\xa7\x81\xe0\xa6\xa8;\xe0\xa6\x9c\xe0\xa7\x81\xe0\xa6\xb2\xe0\xa6\xbe\xe0"
"\xa6\x87;\xe0\xa6\x86\xe0\xa6\x97\xe0\xa6\xb8\xe0\xa7\x8d\xe0\xa6\x9f;\xe0\xa6\xb8"
"\xe0\xa7\x87\xe0\xa6\xaa\xe0\xa7\x8d\xe0\xa6\x9f\xe0\xa7\x87\xe0\xa6\xae\xe0\xa7\x8d"
"\xe0\xa6\xac\xe0\xa6\xb0;\xe0\xa6\x85\xe0\xa6\x95\xe0\xa7\x8d\xe0\xa6\x9f\xe0\xa7"
"\x8b\xe0\xa6\xac\xe0\xa6\xb0;\xe0\xa6\xa8\xe0\xa6\xad\xe0\xa7\x87\xe0\xa6\xae\xe0"
"\xa7\x8d\xe0\xa6\xac\xe0\xa6\xb0;\xe0\xa6\xa1\xe0\xa6\xbf\xe0\xa6\xb8\xe0\xa7\x87"
"\xe0\xa6\xae\xe0\xa7\x8d\xe0\xa6\xac\xe0\xa6\xb0;\0"
"\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbc\x8b \xe0\xbc\xa1;\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbc"
"\x8b \xe0\xbc\xa2;\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbc\x8b \xe0\xbc\xa3;\xe0\xbd\x9f\xe0"
"\xbe\xb3\xe0\xbc\x8b \xe0\xbc\xa4;\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbc\x8b \xe0\xbc\xa5"
";\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbc\x8b \xe0\xbc\xa6;\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbc"
"\x8b \xe0\xbc\xa7;\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbc\x8b \xe0\xbc\xa8;\xe0\xbd\x9f\xe0"
"\xbe\xb3\xe0\xbc\x8b \xe0\xbc\xa9;\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbc\x8b \xe0\xbc\xa1"
"\xe0\xbc\xa0;\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbc\x8b \xe0\xbc\xa1\xe0\xbc\xa1;\xe0\xbd"
"\x9f\xe0\xbe\xb3\xe0\xbc\x8b \xe0\xbc\xa1\xe0\xbc\xa2;\0"
"\xe0\xbd\xa6\xe0\xbe\xa4\xe0\xbe\xb1\xe0\xbd\xb2\xe0\xbc\x8b\xe0\xbd\x9f\xe0\xbe\xb3"
"\xe0\xbd\x9d\xe0\xbc\x8b\xe0\xbd\x91\xe0\xbd\x84\xe0\xbd\x94\xe0\xbc\x8b;\xe0\xbd"
"\xa6\xe0\xbe\xa4\xe0\xbe\xb1\xe0\xbd\xb2\xe0\xbc\x8b\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbd"
"\x9d\xe0\xbc\x8b\xe0\xbd\x82\xe0\xbd\x89\xe0\xbd\xb2\xe0\xbd\xa6\xe0\xbc\x8b\xe0\xbd"
"\x94\xe0\xbc\x8b;\xe0\xbd\xa6\xe0\xbe\xa4\xe0\xbe\xb1\xe0\xbd\xb2\xe0\xbc\x8b\xe0"
"\xbd\x9f\xe0\xbe\xb3\xe0\xbd\x9d\xe0\xbc\x8b\xe0\xbd\x82\xe0\xbd\xa6\xe0\xbd\xb4\xe0"
"\xbd\x98\xe0\xbc\x8b\xe0\xbd\x94\xe0\xbc\x8b;\xe0\xbd\xa6\xe0\xbe\xa4\xe0\xbe\xb1"
"\xe0\xbd\xb2\xe0\xbc\x8b\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbd\x9d\xe0\xbc\x8b\xe0\xbd\x96"
"\xe0\xbd\x9e\xe0\xbd\xb2\xe0\xbc\x8b\xe0\xbd\x94\xe0\xbc\x8b;\xe0\xbd\xa6\xe0\xbe"
"\xa4\xe0\xbe\xb1\xe0\xbd\xb2\xe0\xbc\x8b\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbd\x9d\xe0\xbc"
"\x8b\xe0\xbd\xa3\xe0\xbe\x94\xe0\xbc\x8b\xe0\xbd\x94\xe0\xbc\x8b;\xe0\xbd\xa6\xe0"
"\xbe\xa4\xe0\xbe\xb1\xe0\xbd\xb2\xe0\xbc\x8b\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbd\x9d\xe0"
"\xbc\x8b\xe0\xbd\x91\xe0\xbe\xb2\xe0\xbd\xb4\xe0\xbd\x82\xe0\xbc\x8b\xe0\xbd\x94\xe0"
"\xbc\x8b;\xe0\xbd\xa6\xe0\xbe\xa4\xe0\xbe\xb1\xe0\xbd\xb2\xe0\xbc\x8b\xe0\xbd\x9f"
"\xe0\xbe\xb3\xe0\xbd\x9d\xe0\xbc\x8b\xe0\xbd\x96\xe0\xbd\x91\xe0\xbd\xb4\xe0\xbd\x93"
"\xe0\xbc\x8b\xe0\xbd\x94\xe0\xbc\x8b;\xe0\xbd\xa6\xe0\xbe\xa4\xe0\xbe\xb1\xe0\xbd"
"\xb2\xe0\xbc\x8b\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbd\x9d\xe0\xbc\x8b\xe0\xbd\x96\xe0\xbd"
"\xa2\xe0\xbe\x92\xe0\xbe\xb1\xe0\xbd\x91\xe0\xbc\x8b\xe0\xbd\x94\xe0\xbc\x8b;\xe0"
"\xbd\xa6\xe0\xbe\xa4\xe0\xbe\xb1\xe0\xbd\xb2\xe0\xbc\x8b\xe0\xbd\x9f\xe0\xbe\xb3\xe0"
"\xbd\x9d\xe0\xbc\x8b\xe0\xbd\x91\xe0\xbd\x82\xe0\xbd\xb4\xe0\xbc\x8b\xe0\xbd\x94\xe0"
"\xbc\x8b;\xe0\xbd\xa6\xe0\xbe\xa4\xe0\xbe\xb1\xe0\xbd\xb2\xe0\xbc\x8b\xe0\xbd\x9f"
"\xe0\xbe\xb3\xe0\xbd\x9d\xe0\xbc\x8b\xe0\xbd\x96\xe0\xbd\x85\xe0\xbd\xb4\xe0\xbc\x8b"
"\xe0\xbd\x94\xe0\xbc\x8b;\xe0\xbd\xa6\xe0\xbe\xa4\xe0\xbe\xb1\xe0\xbd\xb2\xe0\xbc"
"\x8b\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbd\x9d\xe0\xbc\x8b\xe0\xbd\x96\xe0\xbd\x85\xe0\xbd"
"\xb4\xe0\xbc\x8b\xe0\xbd\x82\xe0\xbd\x85\xe0\xbd\xb2\xe0\xbd\x82\xe0\xbc\x8b\xe0\xbd"
"\x94\xe0\xbc\x8b;\xe0\xbd\xa6\xe0\xbe\xa4\xe0\xbe\xb1\xe0\xbd\xb2\xe0\xbc\x8b\xe0"
"\xbd\x9f\xe0\xbe\xb3\xe0\xbd\x9d\xe0\xbc\x8b\xe0\xbd\x96\xe0\xbd\x85\xe0\xbd\xb4\xe0"
"\xbc\x8b\xe0\xbd\x82\xe0\xbd\x89\xe0\xbd\xb2\xe0\xbd\xa6\xe0\xbc\x8b\xe0\xbd\x94\xe0"
"\xbc\x8b;\0"
"\xd1\x8f\xd0\xbd.;\xd1\x84\xd0\xb5\xd0\xb2\xd1\x80.;\xd0\xbc\xd0\xb0\xd1\x80\xd1\x82"
";\xd0\xb0\xd0\xbf\xd1\x80.;\xd0\xbc\xd0\xb0\xd0\xb9;\xd1\x8e\xd0\xbd\xd0\xb8;\xd1"
"\x8e\xd0\xbb\xd0\xb8;\xd0\xb0\xd0\xb2\xd0\xb3.;\xd1\x81\xd0\xb5\xd0\xbf\xd1\x82.;"
"\xd0\xbe\xd0\xba\xd1\x82.;\xd0\xbd\xd0\xbe\xd0\xb5\xd0\xbc.;\xd0\xb4\xd0\xb5\xd0\xba"
".;\0"
"\xd1\x8f\xd0\xbd\xd1\x83\xd0\xb0\xd1\x80\xd0\xb8;\xd1\x84\xd0\xb5\xd0\xb2\xd1\x80"
"\xd1\x83\xd0\xb0\xd1\x80\xd0\xb8;\xd0\xbc\xd0\xb0\xd1\x80\xd1\x82;\xd0\xb0\xd0\xbf"
"\xd1\x80\xd0\xb8\xd0\xbb;\xd0\xbc\xd0\xb0\xd0\xb9;\xd1\x8e\xd0\xbd\xd0\xb8;\xd1\x8e"
"\xd0\xbb\xd0\xb8;\xd0\xb0\xd0\xb2\xd0\xb3\xd1\x83\xd1\x81\xd1\x82;\xd1\x81\xd0\xb5"
"\xd0\xbf\xd1\x82\xd0\xb5\xd0\xbc\xd0\xb2\xd1\x80\xd0\xb8;\xd0\xbe\xd0\xba\xd1\x82"
"\xd0\xbe\xd0\xbc\xd0\xb2\xd1\x80\xd0\xb8;\xd0\xbd\xd0\xbe\xd0\xb5\xd0\xbc\xd0\xb2"
"\xd1\x80\xd0\xb8;\xd0\xb4\xd0\xb5\xd0\xba\xd0\xb5\xd0\xbc\xd0\xb2\xd1\x80\xd0\xb8"
";\0"
"\xe1\x80\x87\xe1\x80\x94\xe1\x80\xba;\xe1\x80\x96\xe1\x80\xb1;\xe1\x80\x99\xe1\x80"
"\x90\xe1\x80\xba;\xe1\x80\xa7;\xe1\x80\x99\xe1\x80\xb1;\xe1\x80\x87\xe1\x80\xbd\xe1"
"\x80\x94\xe1\x80\xba;\xe1\x80\x87\xe1\x80\xb0;\xe1\x80\xa9;\xe1\x80\x85\xe1\x80\x80"
"\xe1\x80\xba;\xe1\x80\xa1\xe1\x80\xb1\xe1\x80\xac\xe1\x80\x80\xe1\x80\xba;\xe1\x80"
"\x94\xe1\x80\xad\xe1\x80\xaf;\xe1\x80\x92\xe1\x80\xae;\0"
"\xe1\x80\x87\xe1\x80\x94\xe1\x80\xba\xe1\x80\x94\xe1\x80\x9d\xe1\x80\xab\xe1\x80\x9b"
"\xe1\x80\xae;\xe1\x80\x96\xe1\x80\xb1\xe1\x80\x96\xe1\x80\xb1\xe1\x80\xac\xe1\x80"
"\xba\xe1\x80\x9d\xe1\x80\xab\xe1\x80\x9b\xe1\x80\xae;\xe1\x80\x99\xe1\x80\x90\xe1"
"\x80\xba;\xe1\x80\xa7\xe1\x80\x95\xe1\x80\xbc\xe1\x80\xae;\xe1\x80\x99\xe1\x80\xb1"
";\xe1\x80\x87\xe1\x80\xbd\xe1\x80\x94\xe1\x80\xba;\xe1\x80\x87\xe1\x80\xb0\xe1\x80"
"\x9c\xe1\x80\xad\xe1\x80\xaf\xe1\x80\x84\xe1\x80\xba;\xe1\x80\xa9\xe1\x80\x82\xe1"
"\x80\xaf\xe1\x80\x90\xe1\x80\xba;\xe1\x80\x85\xe1\x80\x80\xe1\x80\xba\xe1\x80\x90"
"\xe1\x80\x84\xe1\x80\xba\xe1\x80\x98\xe1\x80\xac;\xe1\x80\xa1\xe1\x80\xb1\xe1\x80"
"\xac\xe1\x80\x80\xe1\x80\xba\xe1\x80\x90\xe1\x80\xad\xe1\x80\xaf\xe1\x80\x98\xe1\x80"
"\xac;\xe1\x80\x94\xe1\x80\xad\xe1\x80\xaf\xe1\x80\x9d\xe1\x80\x84\xe1\x80\xba\xe1"
"\x80\x98\xe1\x80\xac;\xe1\x80\x92\xe1\x80\xae\xe1\x80\x87\xe1\x80\x84\xe1\x80\xba"
"\xe1\x80\x98\xe1\x80\xac;\0"
"\xd1\x81\xd1\x82\xd1\x83;\xd0\xbb\xd1\x8e\xd1\x82;\xd1\x81\xd0\xb0\xd0\xba;\xd0\xba"
"\xd1\x80\xd0\xb0;\xd0\xbc\xd0\xb0\xd0\xb9;\xd1\x87\xd1\x8d\xd1\x80;\xd0\xbb\xd1\x96"
"\xd0\xbf;\xd0\xb6\xd0\xbd\xd1\x96;\xd0\xb2\xd0\xb5\xd1\x80;\xd0\xba\xd0\xb0\xd1\x81"
";\xd0\xbb\xd1\x96\xd1\x81;\xd1\x81\xd0\xbd\xd0\xb5;\0"
"\xd1\x81\xd1\x82\xd1\x83\xd0\xb4\xd0\xb7\xd0\xb5\xd0\xbd\xd1\x8c;\xd0\xbb\xd1\x8e"
"\xd1\x82\xd1\x8b;\xd1\x81\xd0\xb0\xd0\xba\xd0\xb0\xd0\xb2\xd1\x96\xd0\xba;\xd0\xba"
"\xd1\x80\xd0\xb0\xd1\x81\xd0\xb0\xd0\xb2\xd1\x96\xd0\xba;\xd0\xbc\xd0\xb0\xd0\xb9"
";\xd1\x87\xd1\x8d\xd1\x80\xd0\xb2\xd0\xb5\xd0\xbd\xd1\x8c;\xd0\xbb\xd1\x96\xd0\xbf"
"\xd0\xb5\xd0\xbd\xd1\x8c;\xd0\xb6\xd0\xbd\xd1\x96\xd0\xb2\xd0\xb5\xd0\xbd\xd1\x8c"
";\xd0\xb2\xd0\xb5\xd1\x80\xd0\xb0\xd1\x81\xd0\xb5\xd0\xbd\xd1\x8c;\xd0\xba\xd0\xb0"
"\xd1\x81\xd1\x82\xd1\x80\xd1\x8b\xd1\x87\xd0\xbd\xd1\x96\xd0\xba;\xd0\xbb\xd1\x96"
"\xd1\x81\xd1\x82\xd0\xb0\xd0\xbf\xd0\xb0\xd0\xb4;\xd1\x81\xd0\xbd\xd0\xb5\xd0\xb6"
"\xd0\xb0\xd0\xbd\xd1\x8c;\0"
";;;;\xd1\x82;;;;;;;;\0"
"\xe1\x9f\xa1;\xe1\x9f\xa2;\xe1\x9f\xa3;\xe1\x9f\xa4;\xe1\x9f\xa5;\xe1\x9f\xa6;\xe1"
"\x9f\xa7;\xe1\x9f\xa8;\xe1\x9f\xa9;\xe1\x9f\xa1\xe1\x9f\xa0;\xe1\x9f\xa1\xe1\x9f\xa1"
";\xe1\x9f\xa1\xe1\x9f\xa2;\0"
"\xe1\x9e\x98\xe1\x9e\x80\xe1\x9e\x9a\xe1\x9e\xb6;\xe1\x9e\x80\xe1\x9e\xbb\xe1\x9e"
"\x98\xe1\x9f\x92\xe1\x9e\x97\xe1\x9f\x88;\xe1\x9e\x98\xe1\x9e\xb7\xe1\x9e\x93\xe1"
"\x9e\xb6;\xe1\x9e\x98\xe1\x9f\x81\xe1\x9e\x9f\xe1\x9e\xb6;\xe1\x9e\xa7\xe1\x9e\x9f"
"\xe1\x9e\x97\xe1\x9e\xb6;\xe1\x9e\x98\xe1\x9e\xb7\xe1\x9e\x90\xe1\x9e\xbb\xe1\x9e"
"\x93\xe1\x9e\xb6;\xe1\x9e\x80\xe1\x9e\x80\xe1\x9f\x92\xe1\x9e\x80\xe1\x9e\x8a\xe1"
"\x9e\xb6;\xe1\x9e\x9f\xe1\x9e\xb8\xe1\x9e\xa0\xe1\x9e\xb6;\xe1\x9e\x80\xe1\x9e\x89"
"\xe1\x9f\x92\xe1\x9e\x89\xe1\x9e\xb6;\xe1\x9e\x8f\xe1\x9e\xbb\xe1\x9e\x9b\xe1\x9e"
"\xb6;\xe1\x9e\x9c\xe1\x9e\xb7\xe1\x9e\x85\xe1\x9f\x92\xe1\x9e\x86\xe1\x9e\xb7\xe1"
"\x9e\x80\xe1\x9e\xb6;\xe1\x9e\x92\xe1\x9f\x92\xe1\x9e\x93\xe1\x9e\xbc;\0"
"gen.;febr.;mar\xc3\xa7;abr.;maig;juny;jul.;ag.;set.;oct.;nov.;des.;\0"
"gener;febrer;mar\xc3\xa7;abril;maig;juny;juliol;agost;setembre;octubre;novembre;d"
"esembre;\0"
"1\xe6\x9c\x88;2\xe6\x9c\x88;3\xe6\x9c\x88;4\xe6\x9c\x88;5\xe6\x9c\x88;6\xe6\x9c\x88"
";7\xe6\x9c\x88;8\xe6\x9c\x88;9\xe6\x9c\x88;10\xe6\x9c\x88;11\xe6\x9c\x88;12\xe6\x9c"
"\x88;\0"
"sij;vel;o\xc5\xbeu;tra;svi;lip;srp;kol;ruj;lis;stu;pro;\0"
"sije\xc4\x8dnja;velja\xc4\x8d\x65;o\xc5\xbeujka;travnja;svibnja;lipnja;srpnja;kol"
"ovoza;rujna;listopada;studenoga;prosinca;\0"
"ledna;\xc3\xbanora;b\xc5\x99\x65zna;dubna;kv\xc4\x9btna;\xc4\x8d\x65rvna;\xc4\x8d"
"\x65rvence;srpna;z\xc3\xa1\xc5\x99\xc3\xad;\xc5\x99\xc3\xadjna;listopadu;prosince"
";\0"
"jan;feb;mar;apr;maj;jun;jul;aug;sep;okt;nov;dec;\0"
"januar;februar;marts;april;maj;juni;juli;august;september;oktober;november;decemb"
"er;\0"
"jan;feb;mrt;apr;mei;jun;jul;aug;sep;okt;nov;dec;\0"
"januari;februari;maart;april;mei;juni;juli;augustus;september;oktober;november;de"
"cember;\0"
"jaan;veebr;m\xc3\xa4rts;apr;mai;juuni;juuli;aug;sept;okt;nov;dets;\0"
"jaanuar;veebruar;m\xc3\xa4rts;aprill;mai;juuni;juuli;august;september;oktoober;no"
"vember;detsember;\0"
"jan;feb;mar;apr;mai;jun;jul;aug;sep;okt;nov;des;\0"
"januar;februar;mars;apr\xc3\xadl;mai;juni;juli;august;september;oktober;november;"
"desember;\0"
"tammi;helmi;maalis;huhti;touko;kes\xc3\xa4;hein\xc3\xa4;elo;syys;loka;marras;joul"
"u;\0"
"tammikuuta;helmikuuta;maaliskuuta;huhtikuuta;toukokuuta;kes\xc3\xa4kuuta;hein\xc3"
"\xa4kuuta;elokuuta;syyskuuta;lokakuuta;marraskuuta;joulukuuta;\0"
"janv.;f\xc3\xa9vr.;mars;avr.;mai;juin;juil.;ao\xc3\xbbt;sept.;oct.;nov.;d\xc3\xa9"
"\x63.;\0"
"janvier;f\xc3\xa9vrier;mars;avril;mai;juin;juillet;ao\xc3\xbbt;septembre;octobre;"
"novembre;d\xc3\xa9\x63\x65mbre;\0"
"Xan;Feb;Mar;Abr;Mai;Xu\xc3\xb1;Xul;Ago;Set;Out;Nov;Dec;\0"
"Xaneiro;Febreiro;Marzo;Abril;Maio;Xu\xc3\xb1o;Xullo;Agosto;Setembro;Outubro;Novem"
"bro;Decembro;\0"
"\xe1\x83\x98\xe1\x83\x90\xe1\x83\x9c;\xe1\x83\x97\xe1\x83\x94\xe1\x83\x91;\xe1\x83"
"\x9b\xe1\x83\x90\xe1\x83\xa0;\xe1\x83\x90\xe1\x83\x9e\xe1\x83\xa0;\xe1\x83\x9b\xe1"
"\x83\x90\xe1\x83\x98;\xe1\x83\x98\xe1\x83\x95\xe1\x83\x9c;\xe1\x83\x98\xe1\x83\x95"
"\xe1\x83\x9a;\xe1\x83\x90\xe1\x83\x92\xe1\x83\x95;\xe1\x83\xa1\xe1\x83\x94\xe1\x83"
"\xa5;\xe1\x83\x9d\xe1\x83\xa5\xe1\x83\xa2;\xe1\x83\x9c\xe1\x83\x9d\xe1\x83\x94;\xe1"
"\x83\x93\xe1\x83\x94\xe1\x83\x99;\0"
"\xe1\x83\x98\xe1\x83\x90\xe1\x83\x9c\xe1\x83\x95\xe1\x83\x90\xe1\x83\xa0\xe1\x83\x98"
";\xe1\x83\x97\xe1\x83\x94\xe1\x83\x91\xe1\x83\x94\xe1\x83\xa0\xe1\x83\x95\xe1\x83"
"\x90\xe1\x83\x9a\xe1\x83\x98;\xe1\x83\x9b\xe1\x83\x90\xe1\x83\xa0\xe1\x83\xa2\xe1"
"\x83\x98;\xe1\x83\x90\xe1\x83\x9e\xe1\x83\xa0\xe1\x83\x98\xe1\x83\x9a\xe1\x83\x98"
";\xe1\x83\x9b\xe1\x83\x90\xe1\x83\x98\xe1\x83\xa1\xe1\x83\x98;\xe1\x83\x98\xe1\x83"
"\x95\xe1\x83\x9c\xe1\x83\x98\xe1\x83\xa1\xe1\x83\x98;\xe1\x83\x98\xe1\x83\x95\xe1"
"\x83\x9a\xe1\x83\x98\xe1\x83\xa1\xe1\x83\x98;\xe1\x83\x90\xe1\x83\x92\xe1\x83\x95"
"\xe1\x83\x98\xe1\x83\xa1\xe1\x83\xa2\xe1\x83\x9d;\xe1\x83\xa1\xe1\x83\x94\xe1\x83"
"\xa5\xe1\x83\xa2\xe1\x83\x94\xe1\x83\x9b\xe1\x83\x91\xe1\x83\x94\xe1\x83\xa0\xe1\x83"
"\x98;\xe1\x83\x9d\xe1\x83\xa5\xe1\x83\xa2\xe1\x83\x9d\xe1\x83\x9b\xe1\x83\x91\xe1"
"\x83\x94\xe1\x83\xa0\xe1\x83\x98;\xe1\x83\x9c\xe1\x83\x9d\xe1\x83\x94\xe1\x83\x9b"
"\xe1\x83\x91\xe1\x83\x94\xe1\x83\xa0\xe1\x83\x98;\xe1\x83\x93\xe1\x83\x94\xe1\x83"
"\x99\xe1\x83\x94\xe1\x83\x9b\xe1\x83\x91\xe1\x83\x94\xe1\x83\xa0\xe1\x83\x98;\0"
"Jan;Feb;Mrz;Apr;Mai;Jun;Jul;Aug;Sep;Okt;Nov;Dez;\0"
"Januar;Februar;M\xc3\xa4rz;April;Mai;Juni;Juli;August;September;Oktober;November;"
"Dezember;\0"
"J\xc3\xa4n;Feb;M\xc3\xa4r;Apr;Mai;Jun;Jul;Aug;Sep;Okt;Nov;Dez;\0"
"J\xc3\xa4nner;Februar;M\xc3\xa4rz;April;Mai;Juni;Juli;August;September;Oktober;No"
"vember;Dezember;\0"
"Jan;Feb;M\xc3\xa4r;Apr;Mai;Jun;Jul;Aug;Sep;Okt;Nov;Dez;\0"
"\xce\x99\xce\xb1\xce\xbd;\xce\xa6\xce\xb5\xce\xb2;\xce\x9c\xce\xb1\xcf\x81;\xce\x91"
"\xcf\x80\xcf\x81;\xce\x9c\xce\xb1\xcf\x8a;\xce\x99\xce\xbf\xcf\x85\xce\xbd;\xce\x99"
"\xce\xbf\xcf\x85\xce\xbb;\xce\x91\xcf\x85\xce\xb3;\xce\xa3\xce\xb5\xcf\x80;\xce\x9f"
"\xce\xba\xcf\x84;\xce\x9d\xce\xbf\xce\xb5;\xce\x94\xce\xb5\xce\xba;\0"
"\xce\x99\xce\xb1\xce\xbd\xce\xbf\xcf\x85\xce\xb1\xcf\x81\xce\xaf\xce\xbf\xcf\x85;"
"\xce\xa6\xce\xb5\xce\xb2\xcf\x81\xce\xbf\xcf\x85\xce\xb1\xcf\x81\xce\xaf\xce\xbf\xcf"
"\x85;\xce\x9c\xce\xb1\xcf\x81\xcf\x84\xce\xaf\xce\xbf\xcf\x85;\xce\x91\xcf\x80\xcf"
"\x81\xce\xb9\xce\xbb\xce\xaf\xce\xbf\xcf\x85;\xce\x9c\xce\xb1\xce\x90\xce\xbf\xcf"
"\x85;\xce\x99\xce\xbf\xcf\x85\xce\xbd\xce\xaf\xce\xbf\xcf\x85;\xce\x99\xce\xbf\xcf"
"\x85\xce\xbb\xce\xaf\xce\xbf\xcf\x85;\xce\x91\xcf\x85\xce\xb3\xce\xbf\xcf\x8d\xcf"
"\x83\xcf\x84\xce\xbf\xcf\x85;\xce\xa3\xce\xb5\xcf\x80\xcf\x84\xce\xb5\xce\xbc\xce"
"\xb2\xcf\x81\xce\xaf\xce\xbf\xcf\x85;\xce\x9f\xce\xba\xcf\x84\xcf\x89\xce\xb2\xcf"
"\x81\xce\xaf\xce\xbf\xcf\x85;\xce\x9d\xce\xbf\xce\xb5\xce\xbc\xce\xb2\xcf\x81\xce"
"\xaf\xce\xbf\xcf\x85;\xce\x94\xce\xb5\xce\xba\xce\xb5\xce\xbc\xce\xb2\xcf\x81\xce"
"\xaf\xce\xbf\xcf\x85;\0"
"januari;februari;martsi;aprili;maji;juni;juli;augustusi;septemberi;oktoberi;novem"
"beri;decemberi;\0"
"\xe0\xaa\x9c\xe0\xaa\xbe\xe0\xaa\xa8\xe0\xab\x8d\xe0\xaa\xaf\xe0\xab\x81;\xe0\xaa"
"\xab\xe0\xab\x87\xe0\xaa\xac\xe0\xab\x8d\xe0\xaa\xb0\xe0\xab\x81;\xe0\xaa\xae\xe0"
"\xaa\xbe\xe0\xaa\xb0\xe0\xab\x8d\xe0\xaa\x9a;\xe0\xaa\x8f\xe0\xaa\xaa\xe0\xab\x8d"
"\xe0\xaa\xb0\xe0\xaa\xbf\xe0\xaa\xb2;\xe0\xaa\xae\xe0\xab\x87;\xe0\xaa\x9c\xe0\xab"
"\x82\xe0\xaa\xa8;\xe0\xaa\x9c\xe0\xab\x81\xe0\xaa\xb2\xe0\xaa\xbe\xe0\xaa\x88;\xe0"
"\xaa\x91\xe0\xaa\x97\xe0\xaa\xb8\xe0\xab\x8d\xe0\xaa\x9f;\xe0\xaa\xb8\xe0\xaa\xaa"
"\xe0\xab\x8d\xe0\xaa\x9f\xe0\xab\x87;\xe0\xaa\x91\xe0\xaa\x95\xe0\xab\x8d\xe0\xaa"
"\x9f\xe0\xab\x8b;\xe0\xaa\xa8\xe0\xaa\xb5\xe0\xab\x87;\xe0\xaa\xa1\xe0\xaa\xbf\xe0"
"\xaa\xb8\xe0\xab\x87;\0"
"\xe0\xaa\x9c\xe0\xaa\xbe\xe0\xaa\xa8\xe0\xab\x8d\xe0\xaa\xaf\xe0\xab\x81\xe0\xaa\x86"
"\xe0\xaa\xb0\xe0\xab\x80;\xe0\xaa\xab\xe0\xab\x87\xe0\xaa\xac\xe0\xab\x8d\xe0\xaa"
"\xb0\xe0\xab\x81\xe0\xaa\x86\xe0\xaa\xb0\xe0\xab\x80;\xe0\xaa\xae\xe0\xaa\xbe\xe0"
"\xaa\xb0\xe0\xab\x8d\xe0\xaa\x9a;\xe0\xaa\x8f\xe0\xaa\xaa\xe0\xab\x8d\xe0\xaa\xb0"
"\xe0\xaa\xbf\xe0\xaa\xb2;\xe0\xaa\xae\xe0\xab\x87;\xe0\xaa\x9c\xe0\xab\x82\xe0\xaa"
"\xa8;\xe0\xaa\x9c\xe0\xab\x81\xe0\xaa\xb2\xe0\xaa\xbe\xe0\xaa\x88;\xe0\xaa\x91\xe0"
"\xaa\x97\xe0\xaa\xb8\xe0\xab\x8d\xe0\xaa\x9f;\xe0\xaa\xb8\xe0\xaa\xaa\xe0\xab\x8d"
"\xe0\xaa\x9f\xe0\xab\x87\xe0\xaa\xae\xe0\xab\x8d\xe0\xaa\xac\xe0\xaa\xb0;\xe0\xaa"
"\x91\xe0\xaa\x95\xe0\xab\x8d\xe0\xaa\x9f\xe0\xab\x8d\xe0\xaa\xac\xe0\xaa\xb0;\xe0"
"\xaa\xa8\xe0\xaa\xb5\xe0\xab\x87\xe0\xaa\xae\xe0\xab\x8d\xe0\xaa\xac\xe0\xaa\xb0;"
"\xe0\xaa\xa1\xe0\xaa\xbf\xe0\xaa\xb8\xe0\xab\x87\xe0\xaa\xae\xe0\xab\x8d\xe0\xaa\xac"
"\xe0\xaa\xb0;\0"
"Jan;Fab;Mar;Afr;May;Yun;Yul;Aug;Sat;Okt;Nuw;Dis;\0"
"Janairu;Fabrairu;Maris;Afrilu;Mayu;Yuni;Yuli;Augusta;Satumba;Oktoba;Nuwamba;Disam"
"ba;\0"
"\xd7\x99\xd7\xa0\xd7\x95;\xd7\xa4\xd7\x91\xd7\xa8;\xd7\x9e\xd7\xa8\xd7\xa5;\xd7\x90"
"\xd7\xa4\xd7\xa8;\xd7\x9e\xd7\x90\xd7\x99;\xd7\x99\xd7\x95\xd7\xa0;\xd7\x99\xd7\x95"
"\xd7\x9c;\xd7\x90\xd7\x95\xd7\x92;\xd7\xa1\xd7\xa4\xd7\x98;\xd7\x90\xd7\x95\xd7\xa7"
";\xd7\xa0\xd7\x95\xd7\x91;\xd7\x93\xd7\xa6\xd7\x9e;\0"
"\xd7\x99\xd7\xa0\xd7\x95\xd7\x90\xd7\xa8;\xd7\xa4\xd7\x91\xd7\xa8\xd7\x95\xd7\x90"
"\xd7\xa8;\xd7\x9e\xd7\xa8\xd7\xa5;\xd7\x90\xd7\xa4\xd7\xa8\xd7\x99\xd7\x9c;\xd7\x9e"
"\xd7\x90\xd7\x99;\xd7\x99\xd7\x95\xd7\xa0\xd7\x99;\xd7\x99\xd7\x95\xd7\x9c\xd7\x99"
";\xd7\x90\xd7\x95\xd7\x92\xd7\x95\xd7\xa1\xd7\x98;\xd7\xa1\xd7\xa4\xd7\x98\xd7\x9e"
"\xd7\x91\xd7\xa8;\xd7\x90\xd7\x95\xd7\xa7\xd7\x98\xd7\x95\xd7\x91\xd7\xa8;\xd7\xa0"
"\xd7\x95\xd7\x91\xd7\x9e\xd7\x91\xd7\xa8;\xd7\x93\xd7\xa6\xd7\x9e\xd7\x91\xd7\xa8"
";\0"
"\xe0\xa4\x9c\xe0\xa4\xa8\xe0\xa4\xb5\xe0\xa4\xb0\xe0\xa5\x80;\xe0\xa4\xab\xe0\xa4"
"\xb0\xe0\xa4\xb5\xe0\xa4\xb0\xe0\xa5\x80;\xe0\xa4\xae\xe0\xa4\xbe\xe0\xa4\xb0\xe0"
"\xa5\x8d\xe0\xa4\x9a;\xe0\xa4\x85\xe0\xa4\xaa\xe0\xa5\x8d\xe0\xa4\xb0\xe0\xa5\x88"
"\xe0\xa4\xb2;\xe0\xa4\xae\xe0\xa4\x88;\xe0\xa4\x9c\xe0\xa5\x82\xe0\xa4\xa8;\xe0\xa4"
"\x9c\xe0\xa5\x81\xe0\xa4\xb2\xe0\xa4\xbe\xe0\xa4\x88;\xe0\xa4\x85\xe0\xa4\x97\xe0"
"\xa4\xb8\xe0\xa5\x8d\xe0\xa4\xa4;\xe0\xa4\xb8\xe0\xa4\xbf\xe0\xa4\xa4\xe0\xa4\xae"
"\xe0\xa5\x8d\xe0\xa4\xac\xe0\xa4\xb0;\xe0\xa4\x85\xe0\xa4\x95\xe0\xa5\x8d\xe0\xa4"
"\xa4\xe0\xa5\x82\xe0\xa4\xac\xe0\xa4\xb0;\xe0\xa4\xa8\xe0\xa4\xb5\xe0\xa4\xae\xe0"
"\xa5\x8d\xe0\xa4\xac\xe0\xa4\xb0;\xe0\xa4\xa6\xe0\xa4\xbf\xe0\xa4\xb8\xe0\xa4\xae"
"\xe0\xa5\x8d\xe0\xa4\xac\xe0\xa4\xb0;\0"
"jan.;febr.;m\xc3\xa1rc.;\xc3\xa1pr.;m\xc3\xa1j.;j\xc3\xban.;j\xc3\xbal.;aug.;szep"
"t.;okt.;nov.;dec.;\0"
"janu\xc3\xa1r;febru\xc3\xa1r;m\xc3\xa1rcius;\xc3\xa1prilis;m\xc3\xa1jus;j\xc3\xba"
"nius;j\xc3\xbalius;augusztus;szeptember;okt\xc3\xb3\x62\x65r;november;december;\0"
"jan;feb;mar;apr;ma\xc3\xad;j\xc3\xban;j\xc3\xbal;\xc3\xa1g\xc3\xba;sep;okt;n\xc3\xb3"
"v;des;\0"
"jan\xc3\xba\x61r;febr\xc3\xba\x61r;mars;apr\xc3\xadl;ma\xc3\xad;j\xc3\xban\xc3\xad"
";j\xc3\xbal\xc3\xad;\xc3\xa1g\xc3\xbast;september;okt\xc3\xb3\x62\x65r;n\xc3\xb3v"
"ember;desember;\0"
"Jan;Feb;Mar;Apr;Mei;Jun;Jul;Agu;Sep;Okt;Nov;Des;\0"
"Januari;Februari;Maret;April;Mei;Juni;Juli;Agustus;September;Oktober;November;Des"
"ember;\0"
"Ean;Feabh;M\xc3\xa1rta;Aib;Beal;Meith;I\xc3\xbail;L\xc3\xban;MF\xc3\xb3mh;DF\xc3\xb3"
"mh;Samh;Noll;\0"
"Ean\xc3\xa1ir;Feabhra;M\xc3\xa1rta;Aibre\xc3\xa1n;Bealtaine;Meitheamh;I\xc3\xbail"
";L\xc3\xbanasa;Me\xc3\xa1n F\xc3\xb3mhair;Deireadh F\xc3\xb3mhair;Samhain;Nollaig"
";\0"
"gen;feb;mar;apr;mag;giu;lug;ago;set;ott;nov;dic;\0"
"gennaio;febbraio;marzo;aprile;maggio;giugno;Luglio;agosto;settembre;ottobre;novem"
"bre;dicembre;\0"
"\xe0\xb2\x9c\xe0\xb2\xa8\xe0\xb2\xb5\xe0\xb2\xb0\xe0\xb3\x80;\xe0\xb2\xab\xe0\xb3"
"\x86\xe0\xb2\xac\xe0\xb3\x8d\xe0\xb2\xb0\xe0\xb2\xb5\xe0\xb2\xb0\xe0\xb3\x80;\xe0"
"\xb2\xae\xe0\xb2\xbe\xe0\xb2\xb0\xe0\xb3\x8d\xe0\xb2\x9a\xe0\xb3\x8d;\xe0\xb2\x8e"
"\xe0\xb2\xaa\xe0\xb3\x8d\xe0\xb2\xb0\xe0\xb2\xbf\xe0\xb2\xb2\xe0\xb3\x8d;\xe0\xb2"
"\xae\xe0\xb3\x86;\xe0\xb2\x9c\xe0\xb3\x82\xe0\xb2\xa8\xe0\xb3\x8d;\xe0\xb2\x9c\xe0"
"\xb3\x81\xe0\xb2\xb2\xe0\xb3\x88;\xe0\xb2\x86\xe0\xb2\x97\xe0\xb2\xb8\xe0\xb3\x8d"
"\xe0\xb2\x9f\xe0\xb3\x8d;\xe0\xb2\xb8\xe0\xb2\xaa\xe0\xb3\x8d\xe0\xb2\x9f\xe0\xb3"
"\x86\xe0\xb2\x82\xe0\xb2\xac\xe0\xb2\xb0\xe0\xb3\x8d;\xe0\xb2\x85\xe0\xb2\x95\xe0"
"\xb3\x8d\xe0\xb2\x9f\xe0\xb3\x8b\xe0\xb2\xac\xe0\xb2\xb0\xe0\xb3\x8d;\xe0\xb2\xa8"
"\xe0\xb2\xb5\xe0\xb3\x86\xe0\xb2\x82\xe0\xb2\xac\xe0\xb2\xb0\xe0\xb3\x8d;\xe0\xb2"
"\xa1\xe0\xb2\xbf\xe0\xb2\xb8\xe0\xb3\x86\xe0\xb2\x82\xe0\xb2\xac\xe0\xb2\xb0\xe0\xb3"
"\x8d;\0"
"\xd2\x9b\xd0\xb0\xd2\xa3.;\xd0\xb0\xd2\x9b\xd0\xbf.;\xd0\xbd\xd0\xb0\xd1\x83.;\xd1"
"\x81\xd3\x99\xd1\x83.;\xd0\xbc\xd0\xb0\xd0\xbc.;\xd0\xbc\xd0\xb0\xd1\x83.;\xd1\x88"
"\xd1\x96\xd0\xbb.;\xd1\x82\xd0\xb0\xd0\xbc.;\xd2\x9b\xd1\x8b\xd1\x80.;\xd2\x9b\xd0"
"\xb0\xd0\xb7.;\xd2\x9b\xd0\xb0\xd1\x80.;\xd0\xb6\xd0\xb5\xd0\xbb\xd1\x82.;\0"
"\xd2\x9b\xd0\xb0\xd2\xa3\xd1\x82\xd0\xb0\xd1\x80;\xd0\xb0\xd2\x9b\xd0\xbf\xd0\xb0"
"\xd0\xbd;\xd0\xbd\xd0\xb0\xd1\x83\xd1\x80\xd1\x8b\xd0\xb7;\xd1\x81\xd3\x99\xd1\x83"
"\xd1\x96\xd1\x80;\xd0\xbc\xd0\xb0\xd0\xbc\xd1\x8b\xd1\x80;\xd0\xbc\xd0\xb0\xd1\x83"
"\xd1\x81\xd1\x8b\xd0\xbc;\xd1\x88\xd1\x96\xd0\xbb\xd0\xb4\xd0\xb5;\xd1\x82\xd0\xb0"
"\xd0\xbc\xd1\x8b\xd0\xb7;\xd2\x9b\xd1\x8b\xd1\x80\xd0\xba\xd2\xaf\xd0\xb9\xd0\xb5"
"\xd0\xba;\xd2\x9b\xd0\xb0\xd0\xb7\xd0\xb0\xd0\xbd;\xd2\x9b\xd0\xb0\xd1\x80\xd0\xb0"
"\xd1\x88\xd0\xb0;\xd0\xb6\xd0\xb5\xd0\xbb\xd1\x82\xd0\xbe\xd2\x9b\xd1\x81\xd0\xb0"
"\xd0\xbd;\0"
"mut.;gas.;wer.;mat.;gic.;kam.;nya.;kan.;nze.;ukw.;ugu.;uku.;\0"
"Mutarama;Gashyantare;Werurwe;Mata;Gicuransi;Kamena;Nyakanga;Kanama;Nzeli;Ukwakira"
";Ugushyingo;Ukuboza;\0"
"1\xec\x9b\x94;2\xec\x9b\x94;3\xec\x9b\x94;4\xec\x9b\x94;5\xec\x9b\x94;6\xec\x9b\x94"
";7\xec\x9b\x94;8\xec\x9b\x94;9\xec\x9b\x94;10\xec\x9b\x94;11\xec\x9b\x94;12\xec\x9b"
"\x94;\0"
"\xe0\xba\xa1.\xe0\xba\x81.;\xe0\xba\x81.\xe0\xba\x9e.;\xe0\xba\xa1\xe0\xba\xb5.\xe0"
"\xba\x99.;\xe0\xba\xa1.\xe0\xba\xaa..;\xe0\xba\x9e.\xe0\xba\x9e.;\xe0\xba\xa1\xe0"
"\xba\xb4.\xe0\xba\x96.;\xe0\xba\x81.\xe0\xba\xa5.;\xe0\xba\xaa.\xe0\xba\xab.;\xe0"
"\xba\x81.\xe0\xba\x8d.;\xe0\xba\x95.\xe0\xba\xa5.;\xe0\xba\x9e.\xe0\xba\x88.;\xe0"
"\xba\x97.\xe0\xba\xa7.;\0"
"\xe0\xba\xa1\xe0\xba\xb1\xe0\xba\x87\xe0\xba\x81\xe0\xba\xad\xe0\xba\x99;\xe0\xba"
"\x81\xe0\xba\xb8\xe0\xba\xa1\xe0\xba\x9e\xe0\xba\xb2;\xe0\xba\xa1\xe0\xba\xb5\xe0"
"\xba\x99\xe0\xba\xb2;\xe0\xbb\x80\xe0\xba\xa1\xe0\xba\xaa\xe0\xba\xb2;\xe0\xba\x9e"
"\xe0\xba\xb6\xe0\xba\x94\xe0\xba\xaa\xe0\xba\xb0\xe0\xba\x9e\xe0\xba\xb2;\xe0\xba"
"\xa1\xe0\xba\xb4\xe0\xba\x96\xe0\xba\xb8\xe0\xba\x99\xe0\xba\xb2;\xe0\xba\x81\xe0"
"\xbb\x8d\xe0\xba\xa5\xe0\xba\xb0\xe0\xba\x81\xe0\xba\xbb\xe0\xba\x94;\xe0\xba\xaa"
"\xe0\xba\xb4\xe0\xba\x87\xe0\xba\xab\xe0\xba\xb2;\xe0\xba\x81\xe0\xba\xb1\xe0\xba"
"\x99\xe0\xba\x8d\xe0\xba\xb2;\xe0\xba\x95\xe0\xba\xb8\xe0\xba\xa5\xe0\xba\xb2;\xe0"
"\xba\x9e\xe0\xba\xb0\xe0\xba\x88\xe0\xba\xb4\xe0\xba\x81;\xe0\xba\x97\xe0\xba\xb1"
"\xe0\xba\x99\xe0\xba\xa7\xe0\xba\xb2;\0"
"Jan;Feb;Mar;Apr;Mai;J\xc5\xabn;J\xc5\xabl;Aug;Sep;Okt;Nov;Dec;\0"
"janv\xc4\x81ris;febru\xc4\x81ris;marts;apr\xc4\xablis;maijs;j\xc5\xabnijs;j\xc5\xab"
"lijs;augusts;septembris;oktobris;novembris;decembris;\0"
"s1;s2;s3;s4;s5;s6;s7;s8;s9;s10;s11;s12;\0"
"s\xc3\xa1nz\xc3\xa1 ya yambo;s\xc3\xa1nz\xc3\xa1 ya m\xc3\xad\x62\x61l\xc3\xa9;s\xc3"
"\xa1nz\xc3\xa1 ya m\xc3\xads\xc3\xa1to;s\xc3\xa1nz\xc3\xa1 ya m\xc3\xadnei;s\xc3\xa1"
"nz\xc3\xa1 ya m\xc3\xadt\xc3\xa1no;s\xc3\xa1nz\xc3\xa1 ya mot\xc3\xb3\x62\xc3\xa1"
";s\xc3\xa1nz\xc3\xa1 ya nsambo;s\xc3\xa1nz\xc3\xa1 ya mwambe;s\xc3\xa1nz\xc3\xa1 "
"ya libwa;s\xc3\xa1nz\xc3\xa1 ya z\xc3\xb3mi;s\xc3\xa1nz\xc3\xa1 ya z\xc3\xb3mi na"
" m\xc9\x94\xcc\x8ck\xc9\x94\xcc\x81;s\xc3\xa1nz\xc3\xa1 ya z\xc3\xb3mi na m\xc3\xad"
"\x62\x61l\xc3\xa9;\0"
"Sau;Vas;Kov;Bal;Geg;Bir;Lie;Rgp;Rgs;Spl;Lap;Grd;\0"
"sausio;vasario;kovo;baland\xc5\xbeio;gegu\xc5\xbe\xc4\x97s;bir\xc5\xbe\x65lio;lie"
"pos;rugpj\xc5\xab\xc4\x8dio;rugs\xc4\x97jo;spalio;lapkri\xc4\x8dio;gruod\xc5\xbei"
"o;\0"
"\xd1\x98\xd0\xb0\xd0\xbd.;\xd1\x84\xd0\xb5\xd0\xb2.;\xd0\xbc\xd0\xb0\xd1\x80.;\xd0"
"\xb0\xd0\xbf\xd1\x80.;\xd0\xbc\xd0\xb0\xd1\x98;\xd1\x98\xd1\x83\xd0\xbd.;\xd1\x98"
"\xd1\x83\xd0\xbb.;\xd0\xb0\xd0\xb2\xd0\xb3.;\xd1\x81\xd0\xb5\xd0\xbf\xd1\x82.;\xd0"
"\xbe\xd0\xba\xd1\x82.;\xd0\xbd\xd0\xbe\xd0\xb5\xd0\xbc.;\xd0\xb4\xd0\xb5\xd0\xba\xd0"
"\xb5\xd0\xbc.;\0"
"\xd1\x98\xd0\xb0\xd0\xbd\xd1\x83\xd0\xb0\xd1\x80\xd0\xb8;\xd1\x84\xd0\xb5\xd0\xb2"
"\xd1\x80\xd1\x83\xd0\xb0\xd1\x80\xd0\xb8;\xd0\xbc\xd0\xb0\xd1\x80\xd1\x82;\xd0\xb0"
"\xd0\xbf\xd1\x80\xd0\xb8\xd0\xbb;\xd0\xbc\xd0\xb0\xd1\x98;\xd1\x98\xd1\x83\xd0\xbd"
"\xd0\xb8;\xd1\x98\xd1\x83\xd0\xbb\xd0\xb8;\xd0\xb0\xd0\xb2\xd0\xb3\xd1\x83\xd1\x81"
"\xd1\x82;\xd1\x81\xd0\xb5\xd0\xbf\xd1\x82\xd0\xb5\xd0\xbc\xd0\xb2\xd1\x80\xd0\xb8"
";\xd0\xbe\xd0\xba\xd1\x82\xd0\xbe\xd0\xbc\xd0\xb2\xd1\x80\xd0\xb8;\xd0\xbd\xd0\xbe"
"\xd0\xb5\xd0\xbc\xd0\xb2\xd1\x80\xd0\xb8;\xd0\xb4\xd0\xb5\xd0\xba\xd0\xb5\xd0\xbc"
"\xd0\xb2\xd1\x80\xd0\xb8;\0"
";;;;;;;;\xd1\x81;;\xd0\xbd;;\0"
"Jan;Feb;Mac;Apr;Mei;Jun;Jul;Ogos;Sep;Okt;Nov;Dis;\0"
"Januari;Februari;Mac;April;Mei;Jun;Julai;Ogos;September;Oktober;November;Disember"
";\0"
"\xe0\xb4\x9c\xe0\xb4\xa8\xe0\xb5\x81;\xe0\xb4\xab\xe0\xb5\x86\xe0\xb4\xac\xe0\xb5"
"\x8d\xe0\xb4\xb0\xe0\xb5\x81;\xe0\xb4\xae\xe0\xb4\xbe\xe0\xb4\xb0\xe0\xb5\x8d\xe2"
"\x80\x8d;\xe0\xb4\x8f\xe0\xb4\xaa\xe0\xb5\x8d\xe0\xb4\xb0\xe0\xb4\xbf;\xe0\xb4\xae"
"\xe0\xb5\x87\xe0\xb4\xaf\xe0\xb5\x8d;\xe0\xb4\x9c\xe0\xb5\x82\xe0\xb4\xa3\xe0\xb5"
"\x8d\xe2\x80\x8d;\xe0\xb4\x9c\xe0\xb5\x82\xe0\xb4\xb2\xe0\xb5\x88;\xe0\xb4\x86\xe0"
"\xb4\x97;\xe0\xb4\xb8\xe0\xb5\x86\xe0\xb4\xaa\xe0\xb5\x8d\xe0\xb4\xb1\xe0\xb5\x8d"
"\xe0\xb4\xb1\xe0\xb4\x82;\xe0\xb4\x92\xe0\xb4\x95\xe0\xb5\x8d\xe0\xb4\x9f\xe0\xb5"
"\x8b;\xe0\xb4\xa8\xe0\xb4\xb5\xe0\xb4\x82;\xe0\xb4\xa1\xe0\xb4\xbf\xe0\xb4\xb8\xe0"
"\xb4\x82;\0"
"\xe0\xb4\x9c\xe0\xb4\xa8\xe0\xb5\x81\xe0\xb4\xb5\xe0\xb4\xb0\xe0\xb4\xbf;\xe0\xb4"
"\xab\xe0\xb5\x86\xe0\xb4\xac\xe0\xb5\x8d\xe0\xb4\xb0\xe0\xb5\x81\xe0\xb4\xb5\xe0\xb4"
"\xb0\xe0\xb4\xbf;\xe0\xb4\xae\xe0\xb4\xbe\xe0\xb4\xb0\xe0\xb5\x8d\xe2\x80\x8d\xe0"
"\xb4\x9a\xe0\xb5\x8d\xe0\xb4\x9a\xe0\xb5\x8d;\xe0\xb4\x8f\xe0\xb4\xaa\xe0\xb5\x8d"
"\xe0\xb4\xb0\xe0\xb4\xbf\xe0\xb4\xb2\xe0\xb5\x8d\xe2\x80\x8d;\xe0\xb4\xae\xe0\xb5"
"\x87\xe0\xb4\xaf\xe0\xb5\x8d;\xe0\xb4\x9c\xe0\xb5\x82\xe0\xb4\xa3\xe0\xb5\x8d\xe2"
"\x80\x8d;\xe0\xb4\x9c\xe0\xb5\x82\xe0\xb4\xb2\xe0\xb5\x88;\xe0\xb4\x93\xe0\xb4\x97"
"\xe0\xb4\xb8\xe0\xb5\x8d\xe0\xb4\xb1\xe0\xb5\x8d\xe0\xb4\xb1\xe0\xb5\x8d;\xe0\xb4"
"\xb8\xe0\xb5\x86\xe0\xb4\xaa\xe0\xb5\x8d\xe0\xb4\xb1\xe0\xb5\x8d\xe0\xb4\xb1\xe0\xb4"
"\x82\xe0\xb4\xac\xe0\xb4\xb0\xe0\xb5\x8d\xe2\x80\x8d;\xe0\xb4\x92\xe0\xb4\x95\xe0"
"\xb5\x8d\xe0\xb4\x9f\xe0\xb5\x8b\xe0\xb4\xac\xe0\xb4\xb0\xe0\xb5\x8d\xe2\x80\x8d;"
"\xe0\xb4\xa8\xe0\xb4\xb5\xe0\xb4\x82\xe0\xb4\xac\xe0\xb4\xb0\xe0\xb5\x8d\xe2\x80\x8d"
";\xe0\xb4\xa1\xe0\xb4\xbf\xe0\xb4\xb8\xe0\xb4\x82\xe0\xb4\xac\xe0\xb4\xb0\xe0\xb5"
"\x8d\xe2\x80\x8d;\0"
"Jan;Fra;Mar;Apr;Mej;\xc4\xa0un;Lul;Awi;Set;Ott;Nov;Di\xc4\x8b;\0"
"Jannar;Frar;Marzu;April;Mejju;\xc4\xa0unju;Lulju;Awissu;Settembru;Ottubru;Novembr"
"u;Di\xc4\x8b\x65mbru;\0"
"\xe0\xa4\x9c\xe0\xa4\xbe\xe0\xa4\xa8\xe0\xa5\x87\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0"
"\xe0\xa5\x80;\xe0\xa4\xab\xe0\xa5\x87\xe0\xa4\xac\xe0\xa5\x8d\xe0\xa4\xb0\xe0\xa5"
"\x81\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0\xe0\xa5\x80;\xe0\xa4\xae\xe0\xa4\xbe\xe0"
"\xa4\xb0\xe0\xa5\x8d\xe0\xa4\x9a;\xe0\xa4\x8f\xe0\xa4\xaa\xe0\xa5\x8d\xe0\xa4\xb0"
"\xe0\xa4\xbf\xe0\xa4\xb2;\xe0\xa4\xae\xe0\xa5\x87;\xe0\xa4\x9c\xe0\xa5\x82\xe0\xa4"
"\xa8;\xe0\xa4\x9c\xe0\xa5\x81\xe0\xa4\xb2\xe0\xa5\x88;\xe0\xa4\x93\xe0\xa4\x97\xe0"
"\xa4\xb8\xe0\xa5\x8d\xe0\xa4\x9f;\xe0\xa4\xb8\xe0\xa5\x87\xe0\xa4\xaa\xe0\xa5\x8d"
"\xe0\xa4\x9f\xe0\xa5\x87\xe0\xa4\x82\xe0\xa4\xac\xe0\xa4\xb0;\xe0\xa4\x93\xe0\xa4"
"\x95\xe0\xa5\x8d\xe0\xa4\x9f\xe0\xa5\x8b\xe0\xa4\xac\xe0\xa4\xb0;\xe0\xa4\xa8\xe0"
"\xa5\x8b\xe0\xa4\xb5\xe0\xa5\x8d\xe0\xa4\xb9\xe0\xa5\x87\xe0\xa4\x82\xe0\xa4\xac\xe0"
"\xa4\xb0;\xe0\xa4\xa1\xe0\xa4\xbf\xe0\xa4\xb8\xe0\xa5\x87\xe0\xa4\x82\xe0\xa4\xac"
"\xe0\xa4\xb0;\0"
"\xd1\x85\xd1\x83\xd0\xbb;\xd2\xaf\xd1\x85\xd1\x8d;\xd0\xb1\xd0\xb0\xd1\x80;\xd1\x82"
"\xd1\x83\xd1\x83;\xd0\xbb\xd1\x83\xd1\x83;\xd0\xbc\xd0\xbe\xd0\xb3;\xd0\xbc\xd0\xbe"
"\xd1\x80;\xd1\x85\xd0\xbe\xd0\xbd;\xd0\xb1\xd0\xb8\xd1\x87;\xd1\x82\xd0\xb0\xd1\x85"
";\xd0\xbd\xd0\xbe\xd1\x85;\xd0\xb3\xd0\xb0\xd1\x85;\0"
"\xd0\xa5\xd1\x83\xd0\xbb\xd0\xb3\xd0\xb0\xd0\xbd\xd0\xb0;\xd2\xae\xd1\x85\xd1\x8d"
"\xd1\x80;\xd0\x91\xd0\xb0\xd1\x80;\xd0\xa2\xd1\x83\xd1\x83\xd0\xbb\xd0\xb0\xd0\xb9"
";\xd0\x9b\xd1\x83\xd1\x83;\xd0\x9c\xd0\xbe\xd0\xb3\xd0\xbe\xd0\xb9;\xd0\x9c\xd0\xbe"
"\xd1\x80\xd1\x8c;\xd0\xa5\xd0\xbe\xd0\xbd\xd1\x8c;\xd0\x91\xd0\xb8\xd1\x87;\xd0\xa2"
"\xd0\xb0\xd1\x85\xd0\xb8\xd0\xb0;\xd0\x9d\xd0\xbe\xd1\x85\xd0\xbe\xd0\xb9;\xd0\x93"
"\xd0\xb0\xd1\x85\xd0\xb0\xd0\xb9;\0"
"\xe0\xa4\x9c\xe0\xa4\xa8;\xe0\xa4\xab\xe0\xa5\x87\xe0\xa4\xac;\xe0\xa4\xae\xe0\xa4"
"\xbe\xe0\xa4\xb0\xe0\xa5\x8d\xe0\xa4\x9a;\xe0\xa4\x85\xe0\xa4\xaa\xe0\xa5\x8d\xe0"
"\xa4\xb0\xe0\xa4\xbf;\xe0\xa4\xae\xe0\xa5\x87;\xe0\xa4\x9c\xe0\xa5\x81\xe0\xa4\xa8"
";\xe0\xa4\x9c\xe0\xa5\x81\xe0\xa4\xb2\xe0\xa4\xbe;\xe0\xa4\x85\xe0\xa4\x97;\xe0\xa4"
"\xb8\xe0\xa5\x87\xe0\xa4\xaa\xe0\xa5\x8d\xe0\xa4\x9f;\xe0\xa4\x85\xe0\xa4\x95\xe0"
"\xa5\x8d\xe0\xa4\x9f\xe0\xa5\x8b;\xe0\xa4\xa8\xe0\xa5\x8b\xe0\xa4\xad\xe0\xa5\x87"
";\xe0\xa4\xa1\xe0\xa4\xbf\xe0\xa4\xb8\xe0\xa5\x87;\0"
"\xe0\xa4\x9c\xe0\xa4\xa8\xe0\xa4\xb5\xe0\xa4\xb0\xe0\xa5\x80;\xe0\xa4\xab\xe0\xa5"
"\x87\xe0\xa4\xac\xe0\xa5\x8d\xe0\xa4\xb0\xe0\xa5\x81\xe0\xa4\x85\xe0\xa4\xb0\xe0\xa5"
"\x80;\xe0\xa4\xae\xe0\xa4\xbe\xe0\xa4\xb0\xe0\xa5\x8d\xe0\xa4\x9a;\xe0\xa4\x85\xe0"
"\xa4\xaa\xe0\xa5\x8d\xe0\xa4\xb0\xe0\xa4\xbf\xe0\xa4\xb2;\xe0\xa4\xae\xe0\xa5\x87"
";\xe0\xa4\x9c\xe0\xa5\x81\xe0\xa4\xa8;\xe0\xa4\x9c\xe0\xa5\x81\xe0\xa4\xb2\xe0\xa4"
"\xbe\xe0\xa4\x88;\xe0\xa4\x85\xe0\xa4\x97\xe0\xa4\xb8\xe0\xa5\x8d\xe0\xa4\xa4;\xe0"
"\xa4\xb8\xe0\xa5\x87\xe0\xa4\xaa\xe0\xa5\x8d\xe0\xa4\x9f\xe0\xa5\x87\xe0\xa4\xae\xe0"
"\xa5\x8d\xe0\xa4\xac\xe0\xa4\xb0;\xe0\xa4\x85\xe0\xa4\x95\xe0\xa5\x8d\xe0\xa4\x9f"
"\xe0\xa5\x8b\xe0\xa4\xac\xe0\xa4\xb0;\xe0\xa4\xa8\xe0\xa5\x8b\xe0\xa4\xad\xe0\xa5"
"\x87\xe0\xa4\xae\xe0\xa5\x8d\xe0\xa4\xac\xe0\xa4\xb0;\xe0\xa4\xa1\xe0\xa4\xbf\xe0"
"\xa4\xb8\xe0\xa5\x87\xe0\xa4\xae\xe0\xa5\x8d\xe0\xa4\xac\xe0\xa4\xb0;\0"
"jan.;feb.;mars;apr.;mai;juni;juli;aug.;sep.;okt.;nov.;des.;\0"
"januar;februar;mars;april;mai;juni;juli;august;september;oktober;november;desembe"
"r;\0"
"\xe0\xac\x9c\xe0\xac\xbe\xe0\xac\xa8\xe0\xad\x81\xe0\xac\x86\xe0\xac\xb0\xe0\xad\x80"
";\xe0\xac\xab\xe0\xad\x87\xe0\xac\xac\xe0\xad\x8d\xe0\xac\xb0\xe0\xad\x81\xe0\xad"
"\x9f\xe0\xac\xbe\xe0\xac\xb0\xe0\xad\x80;\xe0\xac\xae\xe0\xac\xbe\xe0\xac\xb0\xe0"
"\xad\x8d\xe0\xac\x9a\xe0\xad\x8d\xe0\xac\x9a;\xe0\xac\x85\xe0\xac\xaa\xe0\xad\x8d"
"\xe0\xac\xb0\xe0\xad\x87\xe0\xac\xb2;\xe0\xac\xae\xe0\xad\x87;\xe0\xac\x9c\xe0\xad"
"\x81\xe0\xac\xa8;\xe0\xac\x9c\xe0\xad\x81\xe0\xac\xb2\xe0\xac\xbe\xe0\xac\x87;\xe0"
"\xac\x85\xe0\xac\x97\xe0\xac\xb7\xe0\xad\x8d\xe0\xac\x9f;\xe0\xac\xb8\xe0\xad\x87"
"\xe0\xac\xaa\xe0\xad\x8d\xe0\xac\x9f\xe0\xad\x87\xe0\xac\xae\xe0\xad\x8d\xe0\xac\xac"
"\xe0\xac\xb0;\xe0\xac\x85\xe0\xac\x95\xe0\xad\x8d\xe0\xac\x9f\xe0\xad\x8b\xe0\xac"
"\xac\xe0\xac\xb0;\xe0\xac\xa8\xe0\xac\xad\xe0\xad\x87\xe0\xac\xae\xe0\xad\x8d\xe0"
"\xac\xac\xe0\xac\xb0;\xe0\xac\xa1\xe0\xac\xbf\xe0\xac\xb8\xe0\xad\x87\xe0\xac\xae"
"\xe0\xad\x8d\xe0\xac\xac\xe0\xac\xb0;\0"
"1;2;3;4;\xd9\x85\xd9\x80\xdb\x8c;\xd8\xac\xd9\x88\xd9\x86;7;8;9;10;11;12;\0"
"\xd8\xac\xd9\x86\xd9\x88\xd8\xb1\xd9\x8a;\xd9\x81\xd8\xa8\xd8\xb1\xd9\x88\xd8\xb1"
"\xd9\x8a;\xd9\x85\xd8\xa7\xd8\xb1\xda\x86;\xd8\xa7\xd9\xbe\xd8\xb1\xdb\x8c\xd9\x84"
";\xd9\x85\xdb\x8c;\xd8\xac\xd9\x88\xd9\x86;\xd8\xac\xd9\x88\xd9\x84\xd8\xa7\xdb\x8c"
";\xd8\xa7\xda\xab\xd8\xb3\xd8\xaa;\xd8\xb3\xd9\xbe\xd8\xaa\xd9\x85\xd8\xa8\xd8\xb1"
";\xd8\xa7\xda\xa9\xd8\xaa\xd9\x88\xd8\xa8\xd8\xb1;\xd9\x86\xd9\x88\xd9\x85\xd8\xa8"
"\xd8\xb1;\xd8\xaf\xd8\xb3\xd9\x85\xd8\xa8\xd8\xb1;\0"
"\xda\x98\xd8\xa7\xd9\x86\xd9\x88\xdb\x8c\xd9\x87\xd9\x94;\xd9\x81\xd9\x88\xd8\xb1"
"\xdb\x8c\xd9\x87\xd9\x94;\xd9\x85\xd8\xa7\xd8\xb1\xd8\xb3;\xd8\xa2\xd9\x88\xd8\xb1"
"\xdb\x8c\xd9\x84;\xd9\x85\xd9\x87\xd9\x94;\xda\x98\xd9\x88\xd8\xa6\xd9\x86;\xda\x98"
"\xd9\x88\xd8\xa6\xdb\x8c\xd9\x87\xd9\x94;\xd8\xa7\xd9\x88\xd8\xaa;\xd8\xb3\xd9\xbe"
"\xd8\xaa\xd8\xa7\xd9\x85\xd8\xa8\xd8\xb1;\xd8\xa7\xda\xa9\xd8\xaa\xd8\xa8\xd8\xb1"
";\xd9\x86\xd9\x88\xd8\xa7\xd9\x85\xd8\xa8\xd8\xb1;\xd8\xaf\xd8\xb3\xd8\xa7\xd9\x85"
"\xd8\xa8\xd8\xb1;\0"
"\xd8\xac\xd9\x86\xd9\x88;\xd9\x81\xd9\x88\xd8\xb1\xdb\x8c\xd9\x87\xd9\x94;\xd9\x85"
"\xd8\xa7\xd8\xb1\xd8\xb3;\xd8\xa2\xd9\x88\xd8\xb1\xdb\x8c\xd9\x84;\xd9\x85\xd9\x80"
"\xdb\x8c;\xd8\xac\xd9\x88\xd9\x86;\xd8\xac\xd9\x88\xd9\x84;\xd8\xa7\xd9\x88\xd8\xaa"
";\xd8\xb3\xd9\xbe\xd8\xaa\xd8\xa7\xd9\x85\xd8\xa8\xd8\xb1;\xd8\xa7\xda\xa9\xd8\xaa"
"\xd8\xa8\xd8\xb1;\xd9\x86\xd9\x88\xd8\xa7\xd9\x85\xd8\xa8\xd8\xb1;\xd8\xaf\xd8\xb3"
"\xd9\x85;\0"
"\xd8\xac\xd9\x86\xd9\x88\xd8\xb1\xdb\x8c;\xd9\x81\xd8\xa8\xd8\xb1\xd9\x88\xd8\xb1"
"\xdb\x8c;\xd9\x85\xd8\xa7\xd8\xb1\xda\x86;\xd8\xa7\xd9\xbe\xd8\xb1\xdb\x8c\xd9\x84"
";\xd9\x85\xdb\x8c;\xd8\xac\xd9\x88\xd9\x86;\xd8\xac\xd9\x88\xd9\x84\xd8\xa7\xdb\x8c"
";\xd8\xa7\xda\xaf\xd8\xb3\xd8\xaa;\xd8\xb3\xd9\xbe\xd8\xaa\xd9\x85\xd8\xa8\xd8\xb1"
";\xd8\xa7\xda\xa9\xd8\xaa\xd9\x88\xd8\xa8\xd8\xb1;\xd9\x86\xd9\x88\xd9\x85\xd8\xa8"
"\xd8\xb1;\xd8\xaf\xd8\xb3\xd9\x85\xd8\xa8\xd8\xb1;\0"
"sty;lut;mar;kwi;maj;cze;lip;sie;wrz;pa\xc5\xba;lis;gru;\0"
"stycznia;lutego;marca;kwietnia;maja;czerwca;lipca;sierpnia;wrze\xc5\x9bnia;pa\xc5"
"\xba\x64ziernika;listopada;grudnia;\0"
"Jan;Fev;Mar;Abr;Mai;Jun;Jul;Ago;Set;Out;Nov;Dez;\0"
"Janeiro;Fevereiro;Mar\xc3\xa7o;Abril;Maio;Junho;Julho;Agosto;Setembro;Outubro;Nov"
"embro;Dezembro;\0"
"jan;fev;mar;abr;mai;jun;jul;ago;set;out;nov;dez;\0"
"janeiro;fevereiro;mar\xc3\xa7o;abril;maio;junho;julho;agosto;setembro;outubro;nov"
"embro;dezembro;\0"
"\xe0\xa8\x9c\xe0\xa8\xa8\xe0\xa8\xb5\xe0\xa8\xb0\xe0\xa9\x80;\xe0\xa8\xab\xe0\xa8"
"\xbc\xe0\xa8\xb0\xe0\xa8\xb5\xe0\xa8\xb0\xe0\xa9\x80;\xe0\xa8\xae\xe0\xa8\xbe\xe0"
"\xa8\xb0\xe0\xa8\x9a;\xe0\xa8\x85\xe0\xa8\xaa\xe0\xa9\x8d\xe0\xa8\xb0\xe0\xa9\x88"
"\xe0\xa8\xb2;\xe0\xa8\xae\xe0\xa8\x88;\xe0\xa8\x9c\xe0\xa9\x82\xe0\xa8\xa8;\xe0\xa8"
"\x9c\xe0\xa9\x81\xe0\xa8\xb2\xe0\xa8\xbe\xe0\xa8\x88;\xe0\xa8\x85\xe0\xa8\x97\xe0"
"\xa8\xb8\xe0\xa8\xa4;\xe0\xa8\xb8\xe0\xa8\xa4\xe0\xa9\xb0\xe0\xa8\xac\xe0\xa8\xb0"
";\xe0\xa8\x85\xe0\xa8\x95\xe0\xa8\xa4\xe0\xa9\x82\xe0\xa8\xac\xe0\xa8\xb0;\xe0\xa8"
"\xa8\xe0\xa8\xb5\xe0\xa9\xb0\xe0\xa8\xac\xe0\xa8\xb0;\xe0\xa8\xa6\xe0\xa8\xb8\xe0"
"\xa9\xb0\xe0\xa8\xac\xe0\xa8\xb0;\0"
"ian.;feb.;mar.;apr.;mai;iun.;iul.;aug.;sept.;oct.;nov.;dec.;\0"
"ianuarie;februarie;martie;aprilie;mai;iunie;iulie;august;septembrie;octombrie;noi"
"embrie;decembrie;\0"
"\xd1\x8f\xd0\xbd\xd0\xb2.;\xd1\x84\xd0\xb5\xd0\xb2\xd1\x80.;\xd0\xbc\xd0\xb0\xd1\x80"
"\xd1\x82\xd0\xb0;\xd0\xb0\xd0\xbf\xd1\x80.;\xd0\xbc\xd0\xb0\xd1\x8f;\xd0\xb8\xd1\x8e"
"\xd0\xbd\xd1\x8f;\xd0\xb8\xd1\x8e\xd0\xbb\xd1\x8f;\xd0\xb0\xd0\xb2\xd0\xb3.;\xd1\x81"
"\xd0\xb5\xd0\xbd\xd1\x82.;\xd0\xbe\xd0\xba\xd1\x82.;\xd0\xbd\xd0\xbe\xd1\x8f\xd0\xb1"
".;\xd0\xb4\xd0\xb5\xd0\xba.;\0"
"\xd1\x8f\xd0\xbd\xd0\xb2\xd0\xb0\xd1\x80\xd1\x8f;\xd1\x84\xd0\xb5\xd0\xb2\xd1\x80"
"\xd0\xb0\xd0\xbb\xd1\x8f;\xd0\xbc\xd0\xb0\xd1\x80\xd1\x82\xd0\xb0;\xd0\xb0\xd0\xbf"
"\xd1\x80\xd0\xb5\xd0\xbb\xd1\x8f;\xd0\xbc\xd0\xb0\xd1\x8f;\xd0\xb8\xd1\x8e\xd0\xbd"
"\xd1\x8f;\xd0\xb8\xd1\x8e\xd0\xbb\xd1\x8f;\xd0\xb0\xd0\xb2\xd0\xb3\xd1\x83\xd1\x81"
"\xd1\x82\xd0\xb0;\xd1\x81\xd0\xb5\xd0\xbd\xd1\x82\xd1\x8f\xd0\xb1\xd1\x80\xd1\x8f"
";\xd0\xbe\xd0\xba\xd1\x82\xd1\x8f\xd0\xb1\xd1\x80\xd1\x8f;\xd0\xbd\xd0\xbe\xd1\x8f"
"\xd0\xb1\xd1\x80\xd1\x8f;\xd0\xb4\xd0\xb5\xd0\xba\xd0\xb0\xd0\xb1\xd1\x80\xd1\x8f"
";\0"
"\xd1\x98\xd0\xb0\xd0\xbd;\xd1\x84\xd0\xb5\xd0\xb1;\xd0\xbc\xd0\xb0\xd1\x80;\xd0\xb0"
"\xd0\xbf\xd1\x80;\xd0\xbc\xd0\xb0\xd1\x98;\xd1\x98\xd1\x83\xd0\xbd;\xd1\x98\xd1\x83"
"\xd0\xbb;\xd0\xb0\xd0\xb2\xd0\xb3;\xd1\x81\xd0\xb5\xd0\xbf;\xd0\xbe\xd0\xba\xd1\x82"
";\xd0\xbd\xd0\xbe\xd0\xb2;\xd0\xb4\xd0\xb5\xd1\x86;\0"
"\xd1\x98\xd0\xb0\xd0\xbd\xd1\x83\xd0\xb0\xd1\x80;\xd1\x84\xd0\xb5\xd0\xb1\xd1\x80"
"\xd1\x83\xd0\xb0\xd1\x80;\xd0\xbc\xd0\xb0\xd1\x80\xd1\x82;\xd0\xb0\xd0\xbf\xd1\x80"
"\xd0\xb8\xd0\xbb;\xd0\xbc\xd0\xb0\xd1\x98;\xd1\x98\xd1\x83\xd0\xbd;\xd1\x98\xd1\x83"
"\xd0\xbb;\xd0\xb0\xd0\xb2\xd0\xb3\xd1\x83\xd1\x81\xd1\x82;\xd1\x81\xd0\xb5\xd0\xbf"
"\xd1\x82\xd0\xb5\xd0\xbc\xd0\xb1\xd0\xb0\xd1\x80;\xd0\xbe\xd0\xba\xd1\x82\xd0\xbe"
"\xd0\xb1\xd0\xb0\xd1\x80;\xd0\xbd\xd0\xbe\xd0\xb2\xd0\xb5\xd0\xbc\xd0\xb1\xd0\xb0"
"\xd1\x80;\xd0\xb4\xd0\xb5\xd1\x86\xd0\xb5\xd0\xbc\xd0\xb1\xd0\xb0\xd1\x80;\0"
"\xd1\x98\xd0\xb0\xd0\xbd\xd1\x83\xd0\xb0\xd1\x80;\xd1\x84\xd0\xb5\xd0\xb1\xd1\x80"
"\xd1\x83\xd0\xb0\xd1\x80;\xd0\xbc\xd0\xb0\xd1\x80\xd1\x82;\xd0\xb0\xd0\xbf\xd1\x80"
"\xd0\xb8\xd0\xbb;\xd0\xbc\xd0\xb0\xd1\x98;\xd1\x98\xd1\x83\xd0\xbd\xd0\xb8;\xd1\x98"
"\xd1\x83\xd0\xbb\xd0\xb8;\xd0\xb0\xd0\xb2\xd0\xb3\xd1\x83\xd1\x81\xd1\x82;\xd1\x81"
"\xd0\xb5\xd0\xbf\xd1\x82\xd0\xb5\xd0\xbc\xd0\xb1\xd0\xb0\xd1\x80;\xd0\xbe\xd0\xba"
"\xd1\x82\xd0\xbe\xd0\xb1\xd0\xb0\xd1\x80;\xd0\xbd\xd0\xbe\xd0\xb2\xd0\xb5\xd0\xbc"
"\xd0\xb1\xd0\xb0\xd1\x80;\xd0\xb4\xd0\xb5\xd1\x86\xd0\xb5\xd0\xbc\xd0\xb1\xd0\xb0"
"\xd1\x80;\0"
"jan;feb;mar;apr;maj;jun;jul;avg;sep;okt;nov;dec;\0"
"januar;februar;mart;april;maj;jun;jul;avgust;septembar;oktobar;novembar;decembar;"
"\0"
"Phe;Kol;Ube;Mme;Mot;Jan;Upu;Pha;Leo;Mph;Pun;Tsh;\0"
"Phesekgong;Hlakola;Hlakubele;Mmese;Motsheanong;Phupjane;Phupu;Phata;Leotshe;Mphal"
"ane;Pundungwane;Tshitwe;\0"
"Fer;Tlh;Mop;Mor;Mot;See;Phu;Pha;Lwe;Dip;Ngw;Sed;\0"
"Ferikgong;Tlhakole;Mopitlo;Moranang;Motsheganang;Seetebosigo;Phukwi;Phatwe;Lwetse"
";Diphalane;Ngwanatsele;Sedimonthole;\0"
"\xe0\xb6\xa2\xe0\xb6\xb1;\xe0\xb6\xb4\xe0\xb7\x99\xe0\xb6\xb6;\xe0\xb6\xb8\xe0\xb7"
"\x8f\xe0\xb6\xbb\xe0\xb7\x8a\xe0\xb6\xad;\xe0\xb6\x85\xe0\xb6\xb4\xe0\xb7\x8a\xe2"
"\x80\x8d\xe0\xb6\xbb\xe0\xb7\x9a\xe0\xb6\xbd;\xe0\xb6\xb8\xe0\xb7\x90\xe0\xb6\xba"
";\xe0\xb6\xa2\xe0\xb7\x96\xe0\xb6\xb1;\xe0\xb6\xa2\xe0\xb7\x96\xe0\xb6\xbd;\xe0\xb6"
"\x85\xe0\xb6\x9c\xe0\xb7\x9d;\xe0\xb7\x83\xe0\xb7\x90\xe0\xb6\xb4;\xe0\xb6\x94\xe0"
"\xb6\x9a;\xe0\xb6\xb1\xe0\xb7\x9c\xe0\xb7\x80\xe0\xb7\x90;\xe0\xb6\xaf\xe0\xb7\x99"
"\xe0\xb7\x83\xe0\xb7\x90;\0"
"\xe0\xb6\xa2\xe0\xb6\xb1\xe0\xb7\x80\xe0\xb7\x8f\xe0\xb6\xbb;\xe0\xb6\xb4\xe0\xb7"
"\x99\xe0\xb6\xb6\xe0\xb6\xbb\xe0\xb7\x80\xe0\xb7\x8f\xe0\xb6\xbb;\xe0\xb6\xb8\xe0"
"\xb7\x8f\xe0\xb6\xbb\xe0\xb7\x8a\xe0\xb6\xad;\xe0\xb6\x85\xe0\xb6\xb4\xe0\xb7\x8a"
"\xe2\x80\x8d\xe0\xb6\xbb\xe0\xb7\x9a\xe0\xb6\xbd\xe0\xb7\x8a;\xe0\xb6\xb8\xe0\xb7"
"\x90\xe0\xb6\xba\xe0\xb7\x92;\xe0\xb6\xa2\xe0\xb7\x96\xe0\xb6\xb1;\xe0\xb6\xa2\xe0"
"\xb7\x96\xe0\xb6\xbd\xe0\xb7\x92;\xe0\xb6\x85\xe0\xb6\x9c\xe0\xb7\x9d\xe0\xb7\x83"
"\xe0\xb7\x8a\xe0\xb6\xad\xe0\xb7\x94;\xe0\xb7\x83\xe0\xb7\x90\xe0\xb6\xb4\xe0\xb7"
"\x8a\xe0\xb6\xad\xe0\xb7\x90\xe0\xb6\xb8\xe0\xb7\x8a\xe0\xb6\xb6\xe0\xb6\xbb\xe0\xb7"
"\x8a;\xe0\xb6\x94\xe0\xb6\x9a\xe0\xb7\x8a\xe0\xb6\xad\xe0\xb7\x9d\xe0\xb6\xb6\xe0"
"\xb6\xbb\xe0\xb7\x8a;\xe0\xb6\xb1\xe0\xb7\x9c\xe0\xb7\x80\xe0\xb7\x90\xe0\xb6\xb8"
"\xe0\xb7\x8a\xe0\xb6\xb6\xe0\xb6\xbb\xe0\xb7\x8a;\xe0\xb6\xaf\xe0\xb7\x99\xe0\xb7"
"\x83\xe0\xb7\x90\xe0\xb6\xb8\xe0\xb7\x8a\xe0\xb6\xb6\xe0\xb6\xbb\xe0\xb7\x8a;\0"
"Bhi;Van;Vol;Mab;Nkh;Nhl;Kho;Ngc;Nyo;Mph;Lwe;Ngo;\0"
"Bhimbidvwane;iNdlovana;iNdlovu-lenkhulu;Mabasa;iNkhwekhweti;iNhlaba;Kholwane;iNgc"
"i;iNyoni;iMphala;Lweti;iNgongoni;\0"
"jan;feb;mar;apr;m\xc3\xa1j;j\xc3\xban;j\xc3\xbal;aug;sep;okt;nov;dec;\0"
"janu\xc3\xa1r;febru\xc3\xa1r;marec;apr\xc3\xadl;m\xc3\xa1j;j\xc3\xban;j\xc3\xbal;"
"august;september;okt\xc3\xb3\x62\x65r;november;december;\0"
"januar;februar;marec;april;maj;junij;julij;avgust;september;oktober;november;dece"
"mber;\0"
"Kob;Lab;Sad;Afr;Sha;Lix;Tod;Sid;Sag;Tob;KIT;LIT;\0"
"Bisha Koobaad;Bisha Labaad;Bisha Saddexaad;Bisha Afraad;Bisha Shanaad;Bisha Lixaa"
"d;Bisha Todobaad;Bisha Sideedaad;Bisha Sagaalaad;Bisha Tobnaad;Bisha Kow iyo Tobn"
"aad;Bisha Laba iyo Tobnaad;\0"
"ene;feb;mar;abr;may;jun;jul;ago;sep;oct;nov;dic;\0"
"enero;febrero;marzo;abril;mayo;junio;julio;agosto;septiembre;octubre;noviembre;di"
"ciembre;\0"
"Jan;Feb;Mac;Apr;Mei;Jun;Jul;Ago;Sep;Okt;Nov;Des;\0"
"Januari;Februari;Machi;Aprili;Mei;Juni;Julai;Agosti;Septemba;Oktoba;Novemba;Desem"
"ba;\0"
"januari;februari;mars;april;maj;juni;juli;augusti;september;oktober;november;dece"
"mber;\0"
"\xd0\xaf\xd0\xbd\xd0\xb2;\xd0\xa4\xd0\xb5\xd0\xb2;\xd0\x9c\xd0\xb0\xd1\x80;\xd0\x90"
"\xd0\xbf\xd1\x80;\xd0\x9c\xd0\xb0\xd0\xb9;\xd0\x98\xd1\x8e\xd0\xbd;\xd0\x98\xd1\x8e"
"\xd0\xbb;\xd0\x90\xd0\xb2\xd0\xb3;\xd0\xa1\xd0\xb5\xd0\xbd;\xd0\x9e\xd0\xba\xd1\x82"
";\xd0\x9d\xd0\xbe\xd1\x8f;\xd0\x94\xd0\xb5\xd0\xba;\0"
"\xd0\xaf\xd0\xbd\xd0\xb2\xd0\xb0\xd1\x80;\xd0\xa4\xd0\xb5\xd0\xb2\xd1\x80\xd0\xb0"
"\xd0\xbb;\xd0\x9c\xd0\xb0\xd1\x80\xd1\x82;\xd0\x90\xd0\xbf\xd1\x80\xd0\xb5\xd0\xbb"
";\xd0\x9c\xd0\xb0\xd0\xb9;\xd0\x98\xd1\x8e\xd0\xbd;\xd0\x98\xd1\x8e\xd0\xbb;\xd0\x90"
"\xd0\xb2\xd0\xb3\xd1\x83\xd1\x81\xd1\x82;\xd0\xa1\xd0\xb5\xd0\xbd\xd1\x82\xd1\x8f"
"\xd0\xb1\xd1\x80;\xd0\x9e\xd0\xba\xd1\x82\xd1\x8f\xd0\xb1\xd1\x80;\xd0\x9d\xd0\xbe"
"\xd1\x8f\xd0\xb1\xd1\x80;\xd0\x94\xd0\xb5\xd0\xba\xd0\xb0\xd0\xb1\xd1\x80;\0"
"\xe0\xae\x9c\xe0\xae\xa9.;\xe0\xae\xaa\xe0\xae\xbf\xe0\xae\xaa\xe0\xaf\x8d.;\xe0\xae"
"\xae\xe0\xae\xbe\xe0\xae\xb0\xe0\xaf\x8d.;\xe0\xae\x8f\xe0\xae\xaa\xe0\xaf\x8d.;\xe0"
"\xae\xae\xe0\xaf\x87;\xe0\xae\x9c\xe0\xaf\x82\xe0\xae\xa9\xe0\xaf\x8d;\xe0\xae\x9c"
"\xe0\xaf\x82\xe0\xae\xb2\xe0\xaf\x88;\xe0\xae\x86\xe0\xae\x95.;\xe0\xae\x9a\xe0\xaf"
"\x86\xe0\xae\xaa\xe0\xaf\x8d.;\xe0\xae\x85\xe0\xae\x95\xe0\xaf\x8d.;\xe0\xae\xa8\xe0"
"\xae\xb5.;\xe0\xae\x9f\xe0\xae\xbf\xe0\xae\x9a.;\0"
"\xe0\xae\x9c\xe0\xae\xa9\xe0\xae\xb5\xe0\xae\xb0\xe0\xae\xbf;\xe0\xae\xaa\xe0\xae"
"\xbf\xe0\xae\xaa\xe0\xaf\x8d\xe0\xae\xb0\xe0\xae\xb5\xe0\xae\xb0\xe0\xae\xbf;\xe0"
"\xae\xae\xe0\xae\xbe\xe0\xae\xb0\xe0\xaf\x8d\xe0\xae\x9a\xe0\xaf\x8d;\xe0\xae\x8f"
"\xe0\xae\xaa\xe0\xaf\x8d\xe0\xae\xb0\xe0\xae\xb2\xe0\xaf\x8d;\xe0\xae\xae\xe0\xaf"
"\x87;\xe0\xae\x9c\xe0\xaf\x82\xe0\xae\xa9\xe0\xaf\x8d;\xe0\xae\x9c\xe0\xaf\x82\xe0"
"\xae\xb2\xe0\xaf\x88;\xe0\xae\x86\xe0\xae\x95\xe0\xae\xb8\xe0\xaf\x8d\xe0\xae\x9f"
"\xe0\xaf\x8d;\xe0\xae\x9a\xe0\xaf\x86\xe0\xae\xaa\xe0\xaf\x8d\xe0\xae\x9f\xe0\xae"
"\xae\xe0\xaf\x8d\xe0\xae\xaa\xe0\xae\xb0\xe0\xaf\x8d;\xe0\xae\x85\xe0\xae\x95\xe0"
"\xaf\x8d\xe0\xae\x9f\xe0\xaf\x8b\xe0\xae\xaa\xe0\xae\xb0\xe0\xaf\x8d;\xe0\xae\xa8"
"\xe0\xae\xb5\xe0\xae\xae\xe0\xaf\x8d\xe0\xae\xaa\xe0\xae\xb0\xe0\xaf\x8d;\xe0\xae"
"\x9f\xe0\xae\xbf\xe0\xae\x9a\xe0\xae\xae\xe0\xaf\x8d\xe0\xae\xaa\xe0\xae\xb0\xe0\xaf"
"\x8d;\0"
"\xe0\xb0\x9c\xe0\xb0\xa8\xe0\xb0\xb5\xe0\xb0\xb0\xe0\xb0\xbf;\xe0\xb0\xab\xe0\xb0"
"\xbf\xe0\xb0\xac\xe0\xb1\x8d\xe0\xb0\xb0\xe0\xb0\xb5\xe0\xb0\xb0\xe0\xb0\xbf;\xe0"
"\xb0\xae\xe0\xb0\xbe\xe0\xb0\xb0\xe0\xb1\x8d\xe0\xb0\x9a\xe0\xb0\xbf;\xe0\xb0\x8f"
"\xe0\xb0\xaa\xe0\xb1\x8d\xe0\xb0\xb0\xe0\xb0\xbf\xe0\xb0\xb2\xe0\xb1\x8d;\xe0\xb0"
"\xae\xe0\xb1\x87;\xe0\xb0\x9c\xe0\xb1\x82\xe0\xb0\xa8\xe0\xb1\x8d;\xe0\xb0\x9c\xe0"
"\xb1\x82\xe0\xb0\xb2\xe0\xb1\x88;\xe0\xb0\x86\xe0\xb0\x97\xe0\xb0\xb8\xe0\xb1\x8d"
"\xe0\xb0\x9f\xe0\xb1\x81;\xe0\xb0\xb8\xe0\xb1\x86\xe0\xb0\xaa\xe0\xb1\x8d\xe0\xb0"
"\x9f\xe0\xb1\x86\xe0\xb0\x82\xe0\xb0\xac\xe0\xb0\xb0\xe0\xb1\x8d;\xe0\xb0\x85\xe0"
"\xb0\x95\xe0\xb1\x8d\xe0\xb0\x9f\xe0\xb1\x8b\xe0\xb0\xac\xe0\xb0\xb0\xe0\xb1\x8d;"
"\xe0\xb0\xa8\xe0\xb0\xb5\xe0\xb0\x82\xe0\xb0\xac\xe0\xb0\xb0\xe0\xb1\x8d;\xe0\xb0"
"\xa1\xe0\xb0\xbf\xe0\xb0\xb8\xe0\xb1\x86\xe0\xb0\x82\xe0\xb0\xac\xe0\xb0\xb0\xe0\xb1"
"\x8d;\0"
"\xe0\xb8\xa1.\xe0\xb8\x84.;\xe0\xb8\x81.\xe0\xb8\x9e.;\xe0\xb8\xa1\xe0\xb8\xb5.\xe0"
"\xb8\x84.;\xe0\xb9\x80\xe0\xb8\xa1.\xe0\xb8\xa2.;\xe0\xb8\x9e.\xe0\xb8\x84.;\xe0\xb8"
"\xa1\xe0\xb8\xb4.\xe0\xb8\xa2.;\xe0\xb8\x81.\xe0\xb8\x84.;\xe0\xb8\xaa.\xe0\xb8\x84"
".;\xe0\xb8\x81.\xe0\xb8\xa2.;\xe0\xb8\x95.\xe0\xb8\x84.;\xe0\xb8\x9e.\xe0\xb8\xa2"
".;\xe0\xb8\x98.\xe0\xb8\x84.;\0"
"\xe0\xb8\xa1\xe0\xb8\x81\xe0\xb8\xa3\xe0\xb8\xb2\xe0\xb8\x84\xe0\xb8\xa1;\xe0\xb8"
"\x81\xe0\xb8\xb8\xe0\xb8\xa1\xe0\xb8\xa0\xe0\xb8\xb2\xe0\xb8\x9e\xe0\xb8\xb1\xe0\xb8"
"\x99\xe0\xb8\x98\xe0\xb9\x8c;\xe0\xb8\xa1\xe0\xb8\xb5\xe0\xb8\x99\xe0\xb8\xb2\xe0"
"\xb8\x84\xe0\xb8\xa1;\xe0\xb9\x80\xe0\xb8\xa1\xe0\xb8\xa9\xe0\xb8\xb2\xe0\xb8\xa2"
"\xe0\xb8\x99;\xe0\xb8\x9e\xe0\xb8\xa4\xe0\xb8\xa9\xe0\xb8\xa0\xe0\xb8\xb2\xe0\xb8"
"\x84\xe0\xb8\xa1;\xe0\xb8\xa1\xe0\xb8\xb4\xe0\xb8\x96\xe0\xb8\xb8\xe0\xb8\x99\xe0"
"\xb8\xb2\xe0\xb8\xa2\xe0\xb8\x99;\xe0\xb8\x81\xe0\xb8\xa3\xe0\xb8\x81\xe0\xb8\x8e"
"\xe0\xb8\xb2\xe0\xb8\x84\xe0\xb8\xa1;\xe0\xb8\xaa\xe0\xb8\xb4\xe0\xb8\x87\xe0\xb8"
"\xab\xe0\xb8\xb2\xe0\xb8\x84\xe0\xb8\xa1;\xe0\xb8\x81\xe0\xb8\xb1\xe0\xb8\x99\xe0"
"\xb8\xa2\xe0\xb8\xb2\xe0\xb8\xa2\xe0\xb8\x99;\xe0\xb8\x95\xe0\xb8\xb8\xe0\xb8\xa5"
"\xe0\xb8\xb2\xe0\xb8\x84\xe0\xb8\xa1;\xe0\xb8\x9e\xe0\xb8\xa4\xe0\xb8\xa8\xe0\xb8"
"\x88\xe0\xb8\xb4\xe0\xb8\x81\xe0\xb8\xb2\xe0\xb8\xa2\xe0\xb8\x99;\xe0\xb8\x98\xe0"
"\xb8\xb1\xe0\xb8\x99\xe0\xb8\xa7\xe0\xb8\xb2\xe0\xb8\x84\xe0\xb8\xa1;\0"
"\xe1\x8c\xa5\xe1\x88\xaa;\xe1\x88\x88\xe1\x8a\xab\xe1\x89\xb2;\xe1\x88\x98\xe1\x8c"
"\x8b\xe1\x89\xa2;\xe1\x88\x9a\xe1\x8b\xab\xe1\x8b\x9d;\xe1\x8c\x8d\xe1\x8a\x95\xe1"
"\x89\xa6;\xe1\x88\xb0\xe1\x8a\x90;\xe1\x88\x93\xe1\x88\x9d\xe1\x88\x88;\xe1\x8a\x90"
"\xe1\x88\x93\xe1\x88\xb0;\xe1\x88\x98\xe1\x88\xb5\xe1\x8a\xa8;\xe1\x8c\xa5\xe1\x89"
"\x85\xe1\x88\x9d;\xe1\x88\x95\xe1\x8b\xb3\xe1\x88\xad;\xe1\x89\xb3\xe1\x88\x95\xe1"
"\x88\xb3;\0"
"\xe1\x8c\xa5\xe1\x88\xaa;\xe1\x88\x88\xe1\x8a\xab\xe1\x89\xb2\xe1\x89\xb5;\xe1\x88"
"\x98\xe1\x8c\x8b\xe1\x89\xa2\xe1\x89\xb5;\xe1\x88\x9a\xe1\x8b\xab\xe1\x8b\x9d\xe1"
"\x8b\xab;\xe1\x8c\x8d\xe1\x8a\x95\xe1\x89\xa6\xe1\x89\xb5;\xe1\x88\xb0\xe1\x8a\x90"
";\xe1\x88\x93\xe1\x88\x9d\xe1\x88\x88;\xe1\x8a\x90\xe1\x88\x93\xe1\x88\xb0;\xe1\x88"
"\x98\xe1\x88\xb5\xe1\x8a\xa8\xe1\x88\xa8\xe1\x88\x9d;\xe1\x8c\xa5\xe1\x89\x85\xe1"
"\x88\x9d\xe1\x89\xb2;\xe1\x88\x95\xe1\x8b\xb3\xe1\x88\xad;\xe1\x89\xb3\xe1\x88\x95"
"\xe1\x88\xb3\xe1\x88\xb5;\0"
"S\xc4\x81n;F\xc4\x93p;Ma\xca\xbb\x61;\xca\xbb\x45pe;M\xc4\x93;Sun;Siu;\xca\xbb\x41"
"ok;S\xc4\x93p;\xca\xbbOka;N\xc5\x8dv;Tis;\0"
"S\xc4\x81nuali;F\xc4\x93pueli;Ma\xca\xbb\x61si;\xca\xbb\x45peleli;M\xc4\x93;Sune;"
"Siulai;\xca\xbb\x41okosi;S\xc4\x93pitema;\xca\xbbOkatopa;N\xc5\x8dvema;Tisema;\0"
"Sun;Yan;Kul;Dzi;Mud;Kho;Maw;Mha;Ndz;Nhl;Huk;N'w;\0"
"Sunguti;Nyenyenyani;Nyenyankulu;Dzivamisoko;Mudyaxihi;Khotavuxika;Mawuwani;Mhawur"
"i;Ndzhati;Nhlangula;Hukuri;N'wendzamhala;\0"
"Oca;\xc5\x9eub;Mar;Nis;May;Haz;Tem;A\xc4\x9fu;Eyl;Eki;Kas;Ara;\0"
"Ocak;\xc5\x9eubat;Mart;Nisan;May\xc4\xb1s;Haziran;Temmuz;A\xc4\x9fustos;Eyl\xc3\xbc"
"l;Ekim;Kas\xc4\xb1m;Aral\xc4\xb1k;\0"
"\xd1\x81\xd1\x96\xd1\x87.;\xd0\xbb\xd1\x8e\xd1\x82.;\xd0\xb1\xd0\xb5\xd1\x80.;\xd0"
"\xba\xd0\xb2\xd1\x96\xd1\x82.;\xd1\x82\xd1\x80\xd0\xb0\xd0\xb2.;\xd1\x87\xd0\xb5\xd1"
"\x80\xd0\xb2.;\xd0\xbb\xd0\xb8\xd0\xbf.;\xd1\x81\xd0\xb5\xd1\x80\xd0\xbf.;\xd0\xb2"
"\xd0\xb5\xd1\x80.;\xd0\xb6\xd0\xbe\xd0\xb2\xd1\x82.;\xd0\xbb\xd0\xb8\xd1\x81\xd1\x82"
".;\xd0\xb3\xd1\x80\xd1\x83\xd0\xb4.;\0"
"\xd1\x81\xd1\x96\xd1\x87\xd0\xbd\xd1\x8f;\xd0\xbb\xd1\x8e\xd1\x82\xd0\xbe\xd0\xb3"
"\xd0\xbe;\xd0\xb1\xd0\xb5\xd1\x80\xd0\xb5\xd0\xb7\xd0\xbd\xd1\x8f;\xd0\xba\xd0\xb2"
"\xd1\x96\xd1\x82\xd0\xbd\xd1\x8f;\xd1\x82\xd1\x80\xd0\xb0\xd0\xb2\xd0\xbd\xd1\x8f"
";\xd1\x87\xd0\xb5\xd1\x80\xd0\xb2\xd0\xbd\xd1\x8f;\xd0\xbb\xd0\xb8\xd0\xbf\xd0\xbd"
"\xd1\x8f;\xd1\x81\xd0\xb5\xd1\x80\xd0\xbf\xd0\xbd\xd1\x8f;\xd0\xb2\xd0\xb5\xd1\x80"
"\xd0\xb5\xd1\x81\xd0\xbd\xd1\x8f;\xd0\xb6\xd0\xbe\xd0\xb2\xd1\x82\xd0\xbd\xd1\x8f"
";\xd0\xbb\xd0\xb8\xd1\x81\xd1\x82\xd0\xbe\xd0\xbf\xd0\xb0\xd0\xb4\xd0\xb0;\xd0\xb3"
"\xd1\x80\xd1\x83\xd0\xb4\xd0\xbd\xd1\x8f;\0"
"\xd8\xac\xd9\x86\xd9\x88\xd8\xb1\xdb\x8c;\xd9\x81\xd8\xb1\xd9\x88\xd8\xb1\xdb\x8c"
";\xd9\x85\xd8\xa7\xd8\xb1 \xda\x86;\xd8\xa7\xd9\xbe\xd8\xb1\xd9\x8a\xd9\x84;\xd9\x85"
"\xd8\xa6;\xd8\xac\xd9\x88\xd9\x86;\xd8\xac\xd9\x88\xd9\x84\xd8\xa7\xd8\xa6;\xd8\xa7"
"\xda\xaf\xd8\xb3\xd8\xaa;\xd8\xb3\xd8\xaa\xd9\x85\xd8\xa8\xd8\xb1;\xd8\xa7\xda\xa9"
"\xd8\xaa\xd9\x88\xd8\xa8\xd8\xb1;\xd9\x86\xd9\x88\xd9\x85\xd8\xa8\xd8\xb1;\xd8\xaf"
"\xd8\xb3\xd9\x85\xd8\xa8\xd8\xb1;\0"
"\xd0\x9c\xd1\x83\xd2\xb3\xd0\xb0\xd1\x80\xd1\x80\xd0\xb0\xd0\xbc;\xd0\xa1\xd0\xb0"
"\xd1\x84\xd0\xb0\xd1\x80;\xd0\xa0\xd0\xb0\xd0\xb1\xd0\xb8\xd1\x83\xd0\xbb-\xd0\xb0"
"\xd0\xb2\xd0\xb2\xd0\xb0\xd0\xbb;\xd0\xa0\xd0\xb0\xd0\xb1\xd0\xb8\xd1\x83\xd0\xbb"
"-\xd0\xbe\xd1\x85\xd0\xb8\xd1\x80;\xd0\x96\xd1\x83\xd0\xbc\xd0\xbe\xd0\xb4\xd0\xb8"
"\xd1\x83\xd0\xbb-\xd1\x83\xd0\xbb\xd0\xbe;\xd0\x96\xd1\x83\xd0\xbc\xd0\xbe\xd0\xb4"
"\xd0\xb8\xd1\x83\xd0\xbb-\xd1\x83\xd1\x85\xd1\x80\xd0\xbe;\xd0\xa0\xd0\xb0\xd0\xb6"
"\xd0\xb0\xd0\xb1;\xd0\xa8\xd0\xb0\xd1\x8a\xd0\xb1\xd0\xbe\xd0\xbd;\xd0\xa0\xd0\xb0"
"\xd0\xbc\xd0\xb0\xd0\xb7\xd0\xbe\xd0\xbd;\xd0\xa8\xd0\xb0\xd0\xb2\xd0\xb2\xd0\xbe"
"\xd0\xbb;\xd0\x97\xd0\xb8\xd0\xbb-\xd2\x9b\xd0\xb0\xd1\x8a\xd0\xb4\xd0\xb0;\xd0\x97"
"\xd0\xb8\xd0\xbb-\xd2\xb3\xd0\xb8\xd0\xb6\xd0\xb6\xd0\xb0;\0"
"thg 1;thg 2;thg 3;thg 4;thg 5;thg 6;thg 7;thg 8;thg 9;thg 10;thg 11;thg 12;\0"
"th\xc3\xa1ng m\xe1\xbb\x99t;th\xc3\xa1ng hai;th\xc3\xa1ng ba;th\xc3\xa1ng t\xc6\xb0"
";th\xc3\xa1ng n\xc4\x83m;th\xc3\xa1ng s\xc3\xa1u;th\xc3\xa1ng b\xe1\xba\xa3y;th\xc3"
"\xa1ng t\xc3\xa1m;th\xc3\xa1ng ch\xc3\xadn;th\xc3\xa1ng m\xc6\xb0\xe1\xbb\x9di;th"
"\xc3\xa1ng m\xc6\xb0\xe1\xbb\x9di m\xe1\xbb\x99t;th\xc3\xa1ng m\xc6\xb0\xe1\xbb\x9d"
"i hai;\0"
"Ion;Chwef;Mawrth;Ebrill;Mai;Meh;Gorff;Awst;Medi;Hyd;Tach;Rhag;\0"
"Ionawr;Chwefror;Mawrth;Ebrill;Mai;Mehefin;Gorffenaf;Awst;Medi;Hydref;Tachwedd;Rha"
"gfyr;\0"
"Jan;Feb;Mat;Epr;Mey;Jun;Jul;Aga;Sep;Okt;Nov;Dis;\0"
"Janyuwari;Februwari;Matshi;Epreli;Meyi;Juni;Julayi;Agasti;Septemba;Okthoba;Novemb"
"a;Disemba;\0"
"\xe1\xb9\xa2\xe1\xba\xb9\xcc\x81r\xe1\xba\xb9\xcc\x81;\xc3\x88r\xc3\xa8l\xc3\xa8;"
"\xe1\xba\xb8r\xe1\xba\xb9\xcc\x80n\xc3\xa0;\xc3\x8cgb\xc3\xa9;\xe1\xba\xb8\xcc\x80"
"\x62ibi;\xc3\x92k\xc3\xba\x64u;Ag\xe1\xba\xb9m\xe1\xbb\x8d;\xc3\x92g\xc3\xban;Owe"
"we;\xe1\xbb\x8c\xcc\x80w\xc3\xa0r\xc3\xa0;B\xc3\xa9l\xc3\xba;\xe1\xbb\x8c\xcc\x80"
"p\xe1\xba\xb9\xcc\x80;\0"
"O\xe1\xb9\xa3\xc3\xb9 \xe1\xb9\xa2\xe1\xba\xb9\xcc\x81r\xe1\xba\xb9\xcc\x81;O\xe1"
"\xb9\xa3\xc3\xb9 \xc3\x88r\xc3\xa8l\xc3\xa8;O\xe1\xb9\xa3\xc3\xb9 \xe1\xba\xb8r\xe1"
"\xba\xb9\xcc\x80n\xc3\xa0;O\xe1\xb9\xa3\xc3\xb9 \xc3\x8cgb\xc3\xa9;O\xe1\xb9\xa3\xc3"
"\xb9 \xe1\xba\xb8\xcc\x80\x62ibi;O\xe1\xb9\xa3\xc3\xb9 \xc3\x92k\xc3\xba\x64u;O\xe1"
"\xb9\xa3\xc3\xb9 Ag\xe1\xba\xb9m\xe1\xbb\x8d;O\xe1\xb9\xa3\xc3\xb9 \xc3\x92g\xc3\xba"
"n;O\xe1\xb9\xa3\xc3\xb9 Owewe;O\xe1\xb9\xa3\xc3\xb9 \xe1\xbb\x8c\xcc\x80w\xc3\xa0"
"r\xc3\xa0;O\xe1\xb9\xa3\xc3\xb9 B\xc3\xa9l\xc3\xba;O\xe1\xb9\xa3\xc3\xb9 \xe1\xbb"
"\x8c\xcc\x80p\xe1\xba\xb9\xcc\x80;\0"
"Jan;Feb;Mas;Apr;Mey;Jun;Jul;Aga;Sep;Okt;Nov;Dis;\0"
"Januwari;Februwari;Mashi;Apreli;Meyi;Juni;Julayi;Agasti;Septhemba;Okthoba;Novemba"
";Disemba;\0"
"Jan;Feb;Mar;Apr;Maj;Jun;Jul;Avg;Sep;Okt;Nov;Dec;\0"
"Januar;Februar;Mart;April;Maj;Juni;Juli;Avgust;Septembar;Oktobar;Novembar;Decemba"
"r;\0"
"J-guer;T-arree;Mayrnt;Avrril;Boaldyn;M-souree;J-souree;Luanistyn;M-fouyir;J-fouyi"
"r;M.Houney;M.Nollick;\0"
"Jerrey-geuree;Toshiaght-arree;Mayrnt;Averil;Boaldyn;Mean-souree;Jerrey-souree;Lua"
"nistyn;Mean-fouyir;Jerrey-fouyir;Mee Houney;Mee ny Nollick;\0"
"Gen;Whe;Mer;Ebr;Me;Efn;Gor;Est;Gwn;Hed;Du;Kev;\0"
"Mys Genver;Mys Whevrel;Mys Merth;Mys Ebrel;Mys Me;Mys Efan;Mys Gortheren;Mye Est;"
"Mys Gwyngala;Mys Hedra;Mys Du;Mys Kevardhu;\0"
"S-\xc6\x86;K-\xc6\x86;E-\xc6\x86;E-O;E-K;O-A;A-K;D-\xc6\x86;F-\xc6\x90;\xc6\x86-A"
";\xc6\x86-O;M-\xc6\x86;\0"
"Sanda-\xc6\x86p\xc9\x9bp\xc9\x94n;Kwakwar-\xc6\x86gyefuo;Eb\xc9\x94w-\xc6\x86\x62"
"\x65nem;Eb\xc9\x94\x62ira-Oforisuo;Esusow Aketseaba-K\xc9\x94t\xc9\x94nimba;Obira"
"de-Ay\xc9\x9bwohomumu;Ay\xc9\x9bwoho-Kitawonsa;Difuu-\xc6\x86sandaa;Fankwa-\xc6\x90"
"\x62\xc9\x94;\xc6\x86\x62\xc9\x9bs\xc9\x9b-Ahinime;\xc6\x86\x62\x65r\xc9\x9b\x66\xc9"
"\x9bw-Obubuo;Mumu-\xc6\x86p\xc9\x9bnimba;\0"
"\xe0\xa4\x9c\xe0\xa4\xbe\xe0\xa4\xa8\xe0\xa5\x87\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0"
"\xe0\xa5\x80;\xe0\xa4\xab\xe0\xa5\x87\xe0\xa4\xac\xe0\xa5\x83\xe0\xa4\xb5\xe0\xa4"
"\xbe\xe0\xa4\xb0\xe0\xa5\x80;\xe0\xa4\xae\xe0\xa4\xbe\xe0\xa4\xb0\xe0\xa5\x8d\xe0"
"\xa4\x9a;\xe0\xa4\x8f\xe0\xa4\xaa\xe0\xa5\x8d\xe0\xa4\xb0\xe0\xa4\xbf\xe0\xa4\xb2"
";\xe0\xa4\xae\xe0\xa5\x87;\xe0\xa4\x9c\xe0\xa5\x82\xe0\xa4\xa8;\xe0\xa4\x9c\xe0\xa5"
"\x81\xe0\xa4\xb2\xe0\xa5\x88;\xe0\xa4\x93\xe0\xa4\x97\xe0\xa4\xb8\xe0\xa5\x8d\xe0"
"\xa4\x9f;\xe0\xa4\xb8\xe0\xa5\x87\xe0\xa4\xaa\xe0\xa5\x8d\xe0\xa4\x9f\xe0\xa5\x87"
"\xe0\xa4\x82\xe0\xa4\xac\xe0\xa4\xb0;\xe0\xa4\x93\xe0\xa4\x95\xe0\xa5\x8d\xe0\xa4"
"\x9f\xe0\xa5\x8b\xe0\xa4\xac\xe0\xa4\xb0;\xe0\xa4\xa8\xe0\xa5\x8b\xe0\xa4\xb5\xe0"
"\xa5\x8d\xe0\xa4\xb9\xe0\xa5\x87\xe0\xa4\x82\xe0\xa4\xac\xe0\xa4\xb0;\xe0\xa4\xa1"
"\xe0\xa4\xbf\xe0\xa4\xb8\xe0\xa5\x87\xe0\xa4\x82\xe0\xa4\xac\xe0\xa4\xb0;\0"
"Aha;Ofl;Och;Abe;Agb;Otu;Maa;Man;Gbo;Ant;Ale;Afu;\0"
"Aharabata;Oflo;Ochokrikri;Abeibee;Agbeinaa;Otukwadan;Maawe;Manyawale;Gbo;Anton;Al"
"emle;Afuabee;\0"
"Jen;Feb;Maa;Epr;Mee;Juu;Jul;\xe1\xbb\x8cg\xe1\xbb\x8d;Sep;\xe1\xbb\x8ckt;Nov;Dis;"
"\0"
"Jen\xe1\xbb\xa5war\xe1\xbb\x8b;Febr\xe1\xbb\xa5war\xe1\xbb\x8b;Maach\xe1\xbb\x8b;"
"Eprel;Mee;Juun;Jula\xe1\xbb\x8b;\xe1\xbb\x8cg\xe1\xbb\x8d\xe1\xbb\x8dst;Septemba;"
"\xe1\xbb\x8cktoba;Novemba;Disemba;\0"
"Mwei wa mbee;Mwei wa keli;Mwei wa katatu;Mwei wa kanne;Mwei wa katano;Mwei wa tha"
"nthatu;Mwei wa muonza;Mwei wa nyanya;Mwei wa kenda;Mwei wa ikumi;Mwei wa ikumi na"
" imwe;Mwei wa ikumi na ili;\0"
"\xdc\x8f\xdc\x9f\xdc\xa2\xc2\xa0\xdc\x8f\xdc\x92;\xdc\xab\xdc\x92\xdc\x9b;\xdc\x90"
"\xdc\x95\xdc\xaa;\xdc\xa2\xdc\x9d\xdc\xa3\xdc\xa2;\xdc\x90\xdc\x9d\xdc\xaa;\xdc\x9a"
"\xdc\x99\xdc\x9d\xdc\xaa\xdc\xa2;\xdc\xac\xdc\xa1\xdc\x98\xdc\x99;\xdc\x90\xdc\x92"
";\xdc\x90\xdc\x9d\xdc\xa0\xdc\x98\xdc\xa0;\xdc\x8f\xdc\xac\xdc\xab\xc2\xa0\xdc\x8f"
"\xdc\x90;\xdc\x8f\xdc\xac\xdc\xab\xc2\xa0\xdc\x8f\xdc\x92;\xdc\x8f\xdc\x9f\xdc\xa2"
"\xc2\xa0\xdc\x8f\xdc\x90;\0"
"\xdc\x8f\xdc\x9f\xdc\xa2 \xdc\x8f\xdc\x92;\xdc\xab\xdc\x92\xdc\x9b;\xdc\x90\xdc\x95"
"\xdc\xaa;\xdc\xa2\xdc\x9d\xdc\xa3\xdc\xa2;\xdc\x90\xdc\x9d\xdc\xaa;\xdc\x9a\xdc\x99"
"\xdc\x9d\xdc\xaa\xdc\xa2;\xdc\xac\xdc\xa1\xdc\x98\xdc\x99;\xdc\x90\xdc\x92;\xdc\x90"
"\xdc\x9d\xdc\xa0\xdc\x98\xdc\xa0;\xdc\x8f\xdc\xac\xdc\xab \xdc\x8f\xdc\x90;\xdc\x8f"
"\xdc\xac\xdc\xab \xdc\x8f\xdc\x92;\xdc\x8f\xdc\x9f\xdc\xa2 \xdc\x8f\xdc\x90;\0"
"\xe1\x88\x8d\xe1\x8b\xb0\xe1\x89\xb5;\xe1\x8a\xab\xe1\x89\xa5\xe1\x8a\xbd;\xe1\x8a"
"\xad\xe1\x89\xa5\xe1\x88\x8b;\xe1\x8d\x8b\xe1\x8c\x85\xe1\x8a\xba;\xe1\x8a\xad\xe1"
"\x89\xa2\xe1\x89\x85;\xe1\x88\x9d/\xe1\x89\xb5;\xe1\x8a\xb0\xe1\x88\xad;\xe1\x88\x9b"
"\xe1\x88\xad\xe1\x8b\xab;\xe1\x8b\xab\xe1\x8a\xb8\xe1\x8a\x92;\xe1\x88\x98\xe1\x89"
"\xb0\xe1\x88\x89;\xe1\x88\x9d/\xe1\x88\x9d;\xe1\x89\xb0\xe1\x88\x95\xe1\x88\xb3;\0"
"\xe1\x88\x8d\xe1\x8b\xb0\xe1\x89\xb5\xe1\x88\xaa;\xe1\x8a\xab\xe1\x89\xa5\xe1\x8a"
"\xbd\xe1\x89\xa5\xe1\x89\xb2;\xe1\x8a\xad\xe1\x89\xa5\xe1\x88\x8b;\xe1\x8d\x8b\xe1"
"\x8c\x85\xe1\x8a\xba\xe1\x88\xaa;\xe1\x8a\xad\xe1\x89\xa2\xe1\x89\x85\xe1\x88\xaa"
";\xe1\x88\x9d\xe1\x8a\xaa\xe1\x8a\xa4\xe1\x88\x8d \xe1\x89\xb5\xe1\x8c\x9f\xe1\x8a"
"\x92\xe1\x88\xaa;\xe1\x8a\xb0\xe1\x88\xad\xe1\x8a\xa9;\xe1\x88\x9b\xe1\x88\xad\xe1"
"\x8b\xab\xe1\x88\x9d \xe1\x89\xb5\xe1\x88\xaa;\xe1\x8b\xab\xe1\x8a\xb8\xe1\x8a\x92"
" \xe1\x88\x98\xe1\x88\xb3\xe1\x89\x85\xe1\x88\x88\xe1\x88\xaa;\xe1\x88\x98\xe1\x89"
"\xb0\xe1\x88\x89;\xe1\x88\x9d\xe1\x8a\xaa\xe1\x8a\xa4\xe1\x88\x8d \xe1\x88\x98\xe1"
"\x88\xbd\xe1\x8b\x88\xe1\x88\xaa;\xe1\x89\xb0\xe1\x88\x95\xe1\x88\xb3\xe1\x88\xb5"
"\xe1\x88\xaa;\0"
"\xe1\x8c\xa0\xe1\x88\x90\xe1\x88\xa8;\xe1\x8a\xa8\xe1\x89\xb0\xe1\x89\xb0;\xe1\x88"
"\x98\xe1\x8c\x88\xe1\x89\xa0;\xe1\x8a\xa0\xe1\x8a\x80\xe1\x8b\x98;\xe1\x8c\x8d\xe1"
"\x8a\x95\xe1\x89\xa3;\xe1\x88\xa0\xe1\x8a\x95\xe1\x8b\xa8;\xe1\x88\x90\xe1\x88\x98"
"\xe1\x88\x88;\xe1\x8a\x90\xe1\x88\x90\xe1\x88\xb0;\xe1\x8a\xa8\xe1\x88\xa8\xe1\x88"
"\x98;\xe1\x8c\xa0\xe1\x89\x80\xe1\x88\x98;\xe1\x8a\x80\xe1\x8b\xb0\xe1\x88\xa8;\xe1"
"\x8a\x80\xe1\x88\xa0\xe1\x88\xa0;\0"
"\xe1\x8c\xa0\xe1\x88\x90\xe1\x88\xa8;\xe1\x8a\xa8\xe1\x89\xb0\xe1\x89\xb0;\xe1\x88"
"\x98\xe1\x8c\x88\xe1\x89\xa0;\xe1\x8a\xa0\xe1\x8a\x80\xe1\x8b\x98;\xe1\x8c\x8d\xe1"
"\x8a\x95\xe1\x89\xa3\xe1\x89\xb5;\xe1\x88\xa0\xe1\x8a\x95\xe1\x8b\xa8;\xe1\x88\x90"
"\xe1\x88\x98\xe1\x88\x88;\xe1\x8a\x90\xe1\x88\x90\xe1\x88\xb0;\xe1\x8a\xa8\xe1\x88"
"\xa8\xe1\x88\x98;\xe1\x8c\xa0\xe1\x89\x80\xe1\x88\x98;\xe1\x8a\x80\xe1\x8b\xb0\xe1"
"\x88\xa8;\xe1\x8a\x80\xe1\x88\xa0\xe1\x88\xa0;\0"
"Wey;Fan;Tat;Nan;Tuy;Tso;Taf;War;Kun;Ban;Kom;Sau;\0"
"Fai Weyene;Fai Fani;Fai Tataka;Fai Nangra;Fai Tuyo;Fai Tsoyi;Fai Tafaka;Fai Warac"
"hi;Fai Kunobok;Fai Bansok;Fai Kom;Fai Sauk;\0"
"Dyon;Baa;Atat;Anas;Atyo;Achi;Atar;Awur;Shad;Shak;Naba;Nata;\0"
"Pen Dyon;Pen Ba'a;Pen Atat;Pen Anas;Pen Atyon;Pen Achirim;Pen Atariba;Pen Awurr;P"
"en Shadon;Pen Shakur;Pen Kur Naba;Pen Kur Natat;\0"
"A\xcc\xb1yr;A\xcc\xb1hw;A\xcc\xb1ta;A\xcc\xb1na;A\xcc\xb1pf;A\xcc\xb1ki;A\xcc\xb1"
"ty;A\xcc\xb1ni;A\xcc\xb1ku;Swa;Sby;Sbh;\0"
"Hywan A\xcc\xb1yrnig;Hywan A\xcc\xb1hwa;Hywan A\xcc\xb1tat;Hywan A\xcc\xb1naai;Hy"
"wan A\xcc\xb1pfwon;Hywan A\xcc\xb1kitat;Hywan A\xcc\xb1tyirin;Hywan A\xcc\xb1nina"
"i;Hywan A\xcc\xb1kumviriyin;Hywan Swak;Hywan Swak B'a\xcc\xb1yrnig;Hywan Swak B'a"
"\xcc\xb1hwa;\0"
"Zen;Fev;Mar;Avr;Mai;Jug;Lui;Avo;Set;Otu;Nov;Dic;\0"
"Zen\xc3\xa2r;Fevr\xc3\xa2r;Mar\xc3\xa7;Avr\xc3\xael;Mai;Jugn;Lui;Avost;Setembar;O"
"tubar;Novembar;Dicembar;\0"
"Pha;Luh;\xe1\xb9\xb0ha;Lam;Shu;Lwi;Lwa;\xe1\xb9\xb0ha;Khu;Tsh;\xe1\xb8\xbc\x61r;N"
"ye;\0"
"Phando;Luhuhi;\xe1\xb9\xb0hafamuhwe;Lambamai;Shundunthule;Fulwi;Fulwana;\xe1\xb9\xb0"
"hangule;Khubvumedzi;Tshimedzi;\xe1\xb8\xbc\x61ra;Nyendavhusiku;\0"
"Dzv;Dzd;Ted;Af\xc9\x94;Dam;Mas;Sia;Dea;Any;Kel;Ade;Dzm;\0"
"Dzove;Dzodze;Tedoxe;Af\xc9\x94\x66i\xc9\x9b;Dama;Masa;Siaml\xc9\x94m;Deasiamime;A"
"ny\xc9\x94ny\xc9\x94;Kele;Ade\xc9\x9bmekp\xc9\x94xe;Dzome;\0"
"Ian.;Pep.;Mal.;\xca\xbb\x41p.;Mei;Iun.;Iul.;\xca\xbb\x41u.;Kep.;\xca\xbbOk.;Now.;"
"Kek.;\0"
"Ianuali;Pepeluali;Malaki;\xca\xbb\x41pelila;Mei;Iune;Iulai;\xca\xbb\x41ukake;Kepa"
"kemapa;\xca\xbbOkakopa;Nowemapa;Kekemapa;\0"
"Juw;Swi;Tsa;Nya;Tsw;Ata;Ana;Ari;Aku;Swa;Man;Mas;\0"
"Zwat Juwung;Zwat Swiyang;Zwat Tsat;Zwat Nyai;Zwat Tswon;Zwat Ataah;Zwat Anatat;Zw"
"at Arinai;Zwat Akubunyung;Zwat Swag;Zwat Mangjuwang;Zwat Swag-Ma-Suyang;\0"
"Jan;Feb;Mal;Epu;Mei;Jun;Jul;Oga;Sep;Oku;Nov;Dis;\0"
"Januwale;Febuluwale;Malichi;Epulo;Mei;Juni;Julai;Ogasiti;Seputemba;Okutoba;Novemb"
"a;Disemba;\0"
;

static const char standalone_months_data[] =
"Jan;Feb;Mar;Apr;May;Jun;Jul;Aug;Sep;Oct;Nov;Dec;\0"
"January;February;March;April;May;June;July;August;September;October;November;Dece"
"mber;\0"
"J;F;M;A;M;J;J;A;S;O;N;D;\0"
";;;;;;;;;;;;\0"
"Q;N;C;A;C;Q;Q;L;W;D;X;K;\0"
"1;2;3;4;5;6;7;8;9;10;11;12;\0"
"J;S;M;P;M;Q;K;G;S;T;N;D;\0"
"\xe1\x8c\x83;\xe1\x8d\x8c;\xe1\x88\x9b;\xe1\x8a\xa4;\xe1\x88\x9c;\xe1\x8c\x81;\xe1"
"\x8c\x81;\xe1\x8a\xa6;\xe1\x88\xb4;\xe1\x8a\xa6;\xe1\x8a\x96;\xe1\x8b\xb2;\0"
"\xd9\x8a;\xd9\x81;\xd9\x85;\xd8\xa3;\xd9\x88;\xd9\x86;\xd9\x84;\xd8\xba;\xd8\xb3;"
"\xd9\x83;\xd8\xa8;\xd8\xaf;\0"
"\xe0\xa6\x9c\xe0\xa6\xbe;\xe0\xa6\xab\xe0\xa7\x87;\xe0\xa6\xae\xe0\xa6\xbe;\xe0\xa6"
"\x8f;\xe0\xa6\xae\xe0\xa7\x87;\xe0\xa6\x9c\xe0\xa7\x81\xe0\xa6\xa8;\xe0\xa6\x9c\xe0"
"\xa7\x81;\xe0\xa6\x86;\xe0\xa6\xb8\xe0\xa7\x87;\xe0\xa6\x85;\xe0\xa6\xa8;\xe0\xa6"
"\xa1\xe0\xa6\xbf;\0"
"\xd1\x8f;\xd1\x84;\xd0\xbc;\xd0\xb0;\xd0\xbc;\xd1\x8e;\xd1\x8e;\xd0\xb0;\xd1\x81;"
"\xd0\xbe;\xd0\xbd;\xd0\xb4;\0"
"\xe1\x80\x87;\xe1\x80\x96;\xe1\x80\x99;\xe1\x80\xa7;\xe1\x80\x99;\xe1\x80\x87;\xe1"
"\x80\x87;\xe1\x80\xa9;\xe1\x80\x85;\xe1\x80\xa1;\xe1\x80\x94;\xe1\x80\x92;\0"
";;;;\xd1\x82\xd1\x80\xd0\xb0;;;;;;;;\0"
";;;;\xd1\x82\xd1\x80\xd0\xb0\xd0\xb2\xd0\xb5\xd0\xbd\xd1\x8c;;;;;;;;\0"
"\xd1\x81;\xd0\xbb;\xd1\x81;\xd0\xba;\xd0\xbc;\xd1\x87;\xd0\xbb;\xd0\xb6;\xd0\xb2;"
"\xd0\xba;\xd0\xbb;\xd1\x81;\0"
"g;f;m;a;m;j;j;a;s;o;n;d;\0"
"\xe4\xb8\x80\xe6\x9c\x88;\xe4\xba\x8c\xe6\x9c\x88;\xe4\xb8\x89\xe6\x9c\x88;\xe5\x9b"
"\x9b\xe6\x9c\x88;\xe4\xba\x94\xe6\x9c\x88;\xe5\x85\xad\xe6\x9c\x88;\xe4\xb8\x83\xe6"
"\x9c\x88;\xe5\x85\xab\xe6\x9c\x88;\xe4\xb9\x9d\xe6\x9c\x88;\xe5\x8d\x81\xe6\x9c\x88"
";\xe5\x8d\x81\xe4\xb8\x80\xe6\x9c\x88;\xe5\x8d\x81\xe4\xba\x8c\xe6\x9c\x88;\0"
"1\xe6\x9c\x88;2\xe6\x9c\x88;3\xe6\x9c\x88;4\xe6\x9c\x88;5\xe6\x9c\x88;6\xe6\x9c\x88"
";7\xe6\x9c\x88;8\xe6\x9c\x88;9\xe6\x9c\x88;10\xe6\x9c\x88;11\xe6\x9c\x88;12\xe6\x9c"
"\x88;\0"
"sije\xc4\x8d\x61nj;velja\xc4\x8d\x61;o\xc5\xbeujak;travanj;svibanj;lipanj;srpanj;"
"kolovoz;rujan;listopad;studeni;prosinac;\0"
"s;v;o;t;s;l;s;k;r;l;s;p;\0"
"1.;2.;3.;4.;5.;6.;7.;8.;9.;10.;11.;12.;\0"
"leden;\xc3\xbanor;b\xc5\x99\x65zen;duben;kv\xc4\x9bten;\xc4\x8d\x65rven;\xc4\x8d\x65"
"rvenec;srpen;z\xc3\xa1\xc5\x99\xc3\xad;\xc5\x99\xc3\xadjen;listopad;prosinec;\0"
"l;\xc3\xba;b;d;k;\xc4\x8d;\xc4\x8d;s;z;\xc5\x99;l;p;\0"
"T;H;M;H;T;K;H;E;S;L;M;J;\0"
"X;F;M;A;M;X;X;A;S;O;N;D;\0"
"\xe1\x83\x98;\xe1\x83\x97;\xe1\x83\x9b;\xe1\x83\x90;\xe1\x83\x9b;\xe1\x83\x98;\xe1"
"\x83\x98;\xe1\x83\x90;\xe1\x83\xa1;\xe1\x83\x9d;\xe1\x83\x9c;\xe1\x83\x93;\0"
";;M\xc3\xa4r;;;;Jul;Aug;Sep;Okt;Nov;Dez;\0"
"\xce\x99\xce\xb1\xce\xbd\xce\xbf\xcf\x85\xce\xac\xcf\x81\xce\xb9\xce\xbf\xcf\x82;"
"\xce\xa6\xce\xb5\xce\xb2\xcf\x81\xce\xbf\xcf\x85\xce\xac\xcf\x81\xce\xb9\xce\xbf\xcf"
"\x82;\xce\x9c\xce\xac\xcf\x81\xcf\x84\xce\xb9\xce\xbf\xcf\x82;\xce\x91\xcf\x80\xcf"
"\x81\xce\xaf\xce\xbb\xce\xb9\xce\xbf\xcf\x82;\xce\x9c\xce\xac\xce\xb9\xce\xbf\xcf"
"\x82;\xce\x99\xce\xbf\xcf\x8d\xce\xbd\xce\xb9\xce\xbf\xcf\x82;\xce\x99\xce\xbf\xcf"
"\x8d\xce\xbb\xce\xb9\xce\xbf\xcf\x82;\xce\x91\xcf\x8d\xce\xb3\xce\xbf\xcf\x85\xcf"
"\x83\xcf\x84\xce\xbf\xcf\x82;\xce\xa3\xce\xb5\xcf\x80\xcf\x84\xce\xad\xce\xbc\xce"
"\xb2\xcf\x81\xce\xb9\xce\xbf\xcf\x82;\xce\x9f\xce\xba\xcf\x84\xcf\x8e\xce\xb2\xcf"
"\x81\xce\xb9\xce\xbf\xcf\x82;\xce\x9d\xce\xbf\xce\xad\xce\xbc\xce\xb2\xcf\x81\xce"
"\xb9\xce\xbf\xcf\x82;\xce\x94\xce\xb5\xce\xba\xce\xad\xce\xbc\xce\xb2\xcf\x81\xce"
"\xb9\xce\xbf\xcf\x82;\0"
"\xce\x99;\xce\xa6;\xce\x9c;\xce\x91;\xce\x9c;\xce\x99;\xce\x99;\xce\x91;\xce\xa3;"
"\xce\x9f;\xce\x9d;\xce\x94;\0"
"J;F;M;A;M;Y;Y;A;S;O;N;D;\0"
";;\xd7\x9e\xd7\xa8\xd7\xa1;;;;;;;;;;\0"
"J;F;M;\xc3\x81;M;J;J;A;S;O;N;D;\0"
"j;f;m;a;m;j;j;\xc3\xa1;s;o;n;d;\0"
"E;F;M;A;B;M;I;L;M;D;S;N;\0"
"Gennaio;Febbraio;Marzo;Aprile;Maggio;Giugno;Luglio;;;;;;\0"
"G;F;M;A;M;G;L;A;S;O;N;D;\0"
"1\xec\x9b\x94;2\xec\x9b\x94;3\xec\x9b\x94;4\xec\x9b\x94;5\xec\x9b\x94;6\xec\x9b\x94"
";7\xec\x9b\x94;8\xec\x9b\x94;9\xec\x9b\x94;10\xec\x9b\x94;11\xec\x9b\x94;12\xec\x9b"
"\x94;\0"
"Sausis;Vasaris;Kovas;Balandis;Gegu\xc5\xbe\xc4\x97;Bir\xc5\xbe\x65lis;Liepa;Rugpj"
"\xc5\xabtis;Rugs\xc4\x97jis;Spalis;Lapkritis;Gruodis;\0"
"S;V;K;B;G;B;L;R;R;S;L;G;\0"
"\xd1\x98;\xd1\x84;\xd0\xbc;\xd0\xb0;\xd0\xbc;\xd1\x98;\xd1\x98;\xd0\xb0;\xd1\x81;"
"\xd0\xbe;\xd0\xbd;\xd0\xb4;\0"
"\xe0\xb4\x9c;\xe0\xb4\xab\xe0\xb5\x86;\xe0\xb4\xae;\xe0\xb4\x8f;\xe0\xb4\xae\xe0\xb5"
"\x87;\xe0\xb4\x9c\xe0\xb5\x82;\xe0\xb4\x9c\xe0\xb5\x82;\xe0\xb4\x86;\xe0\xb4\xb8\xe0"
"\xb5\x86;\xe0\xb4\x92;\xe0\xb4\xa8;\xe0\xb4\xa1\xe0\xb4\xbf;\0"
"J;F;M;A;M;\xc4\xa0;L;A;S;O;N;D;\0"
"\xe0\xa5\xa7;\xe0\xa5\xa8;\xe0\xa5\xa9;\xe0\xa5\xaa;\xe0\xa5\xab;\xe0\xa5\xac;\xe0"
"\xa5\xad;\xe0\xa5\xae;\xe0\xa5\xaf;\xe0\xa5\xa7\xe0\xa5\xa6;\xe0\xa5\xa7\xe0\xa5\xa7"
";\xe0\xa5\xa7\xe0\xa5\xa8;\0"
"\xda\x98\xd8\xa7\xd9\x86\xd9\x88\xdb\x8c\xd9\x87;\xd9\x81\xd9\x88\xd8\xb1\xdb\x8c"
"\xd9\x87;\xd9\x85\xd8\xa7\xd8\xb1\xd8\xb3;\xd8\xa2\xd9\x88\xd8\xb1\xdb\x8c\xd9\x84"
";\xd9\x85\xd9\x87;\xda\x98\xd9\x88\xd8\xa6\xd9\x86;\xda\x98\xd9\x88\xd8\xa6\xdb\x8c"
"\xd9\x87;\xd8\xa7\xd9\x88\xd8\xaa;\xd8\xb3\xd9\xbe\xd8\xaa\xd8\xa7\xd9\x85\xd8\xa8"
"\xd8\xb1;\xd8\xa7\xda\xa9\xd8\xaa\xd8\xa8\xd8\xb1;\xd9\x86\xd9\x88\xd8\xa7\xd9\x85"
"\xd8\xa8\xd8\xb1;\xd8\xaf\xd8\xb3\xd8\xa7\xd9\x85\xd8\xa8\xd8\xb1;\0"
"\xda\x98;\xd9\x81;\xd9\x85;\xd8\xa2;\xd9\x85;\xda\x98;\xda\x98;\xd8\xa7;\xd8\xb3;"
"\xd8\xa7;\xd9\x86;\xd8\xaf;\0"
"\xd8\xac;\xd9\x81;\xd9\x85;\xd8\xa7;\xd9\x85;\xd8\xac;\xd8\xac;\xd8\xa7;\xd8\xb3;"
"\xd8\xa7;\xd9\x86;\xd8\xaf;\0"
"stycze\xc5\x84;luty;marzec;kwiecie\xc5\x84;maj;czerwiec;lipiec;sierpie\xc5\x84;wr"
"zesie\xc5\x84;pa\xc5\xba\x64ziernik;listopad;grudzie\xc5\x84;\0"
"s;l;m;k;m;c;l;s;w;p;l;g;\0"
"\xe0\xa8\x9c;\xe0\xa8\xab;\xe0\xa8\xae\xe0\xa8\xbe;\xe0\xa8\x85;\xe0\xa8\xae;\xe0"
"\xa8\x9c\xe0\xa9\x82;\xe0\xa8\x9c\xe0\xa9\x81;\xe0\xa8\x85;\xe0\xa8\xb8;\xe0\xa8\x85"
";\xe0\xa8\xa8;\xe0\xa8\xa6;\0"
"I;F;M;A;M;I;I;A;S;O;N;D;\0"
"\xd1\x8f\xd0\xbd\xd0\xb2.;\xd1\x84\xd0\xb5\xd0\xb2\xd1\x80.;\xd0\xbc\xd0\xb0\xd1\x80"
"\xd1\x82;\xd0\xb0\xd0\xbf\xd1\x80.;\xd0\xbc\xd0\xb0\xd0\xb9;\xd0\xb8\xd1\x8e\xd0\xbd"
"\xd1\x8c;\xd0\xb8\xd1\x8e\xd0\xbb\xd1\x8c;\xd0\xb0\xd0\xb2\xd0\xb3.;\xd1\x81\xd0\xb5"
"\xd0\xbd\xd1\x82.;\xd0\xbe\xd0\xba\xd1\x82.;\xd0\xbd\xd0\xbe\xd1\x8f\xd0\xb1.;\xd0"
"\xb4\xd0\xb5\xd0\xba.;\0"
"\xd0\xaf\xd0\xbd\xd0\xb2\xd0\xb0\xd1\x80\xd1\x8c;\xd0\xa4\xd0\xb5\xd0\xb2\xd1\x80"
"\xd0\xb0\xd0\xbb\xd1\x8c;\xd0\x9c\xd0\xb0\xd1\x80\xd1\x82;\xd0\x90\xd0\xbf\xd1\x80"
"\xd0\xb5\xd0\xbb\xd1\x8c;\xd0\x9c\xd0\xb0\xd0\xb9;\xd0\x98\xd1\x8e\xd0\xbd\xd1\x8c"
";\xd0\x98\xd1\x8e\xd0\xbb\xd1\x8c;\xd0\x90\xd0\xb2\xd0\xb3\xd1\x83\xd1\x81\xd1\x82"
";\xd0\xa1\xd0\xb5\xd0\xbd\xd1\x82\xd1\x8f\xd0\xb1\xd1\x80\xd1\x8c;\xd0\x9e\xd0\xba"
"\xd1\x82\xd1\x8f\xd0\xb1\xd1\x80\xd1\x8c;\xd0\x9d\xd0\xbe\xd1\x8f\xd0\xb1\xd1\x80"
"\xd1\x8c;\xd0\x94\xd0\xb5\xd0\xba\xd0\xb0\xd0\xb1\xd1\x80\xd1\x8c;\0"
"\xd0\xaf;\xd0\xa4;\xd0\x9c;\xd0\x90;\xd0\x9c;\xd0\x98;\xd0\x98;\xd0\x90;\xd0\xa1;"
"\xd0\x9e;\xd0\x9d;\xd0\x94;\0"
"j;f;m;a;m;j;j;a;s;o;n;d;\0"
"\xe0\xb6\xa2;\xe0\xb6\xb4\xe0\xb7\x99;\xe0\xb6\xb8\xe0\xb7\x8f;\xe0\xb6\x85;\xe0\xb6"
"\xb8\xe0\xb7\x90;\xe0\xb6\xa2\xe0\xb7\x96;\xe0\xb6\xa2\xe0\xb7\x96;\xe0\xb6\x85;\xe0"
"\xb7\x83\xe0\xb7\x90;\xe0\xb6\x94;\xe0\xb6\xb1\xe0\xb7\x9c;\xe0\xb6\xaf\xe0\xb7\x99"
";\0"
"K;L;S;A;S;L;T;S;S;T;K;L;\0"
"E;F;M;A;M;J;J;A;S;O;N;D;\0"
"\xe0\xb0\x9c;\xe0\xb0\xab\xe0\xb0\xbf;\xe0\xb0\xae;\xe0\xb0\x8e;\xe0\xb0\xae\xe0\xb1"
"\x86;\xe0\xb0\x9c\xe0\xb1\x81;\xe0\xb0\x9c\xe0\xb1\x81;\xe0\xb0\x86;\xe0\xb0\xb8\xe0"
"\xb1\x86;\xe0\xb0\x85;\xe0\xb0\xa8;\xe0\xb0\xa1\xe0\xb0\xbf;\0"
"\xe0\xb8\xa1.\xe0\xb8\x84.;\xe0\xb8\x81.\xe0\xb8\x9e.;\xe0\xb8\xa1\xe0\xb8\xb5.\xe0"
"\xb8\x84.;\xe0\xb9\x80\xe0\xb8\xa1.\xe0\xb8\xa2.;\xe0\xb8\x9e.\xe0\xb8\x84.;\xe0\xb8"
"\xa1\xe0\xb8\xb4.\xe0\xb8\xa2.;\xe0\xb8\x81.\xe0\xb8\x84.;\xe0\xb8\xaa.\xe0\xb8\x84"
".;\xe0\xb8\x81.\xe0\xb8\xa2.;\xe0\xb8\x95.\xe0\xb8\x84.;\xe0\xb8\x9e.\xe0\xb8\xa2"
".;\xe0\xb8\x98.\xe0\xb8\x84.;\0"
"S;F;M;E;M;S;S;A;S;O;N;T;\0"
"O;\xc5\x9e;M;N;M;H;T;A;E;E;K;A;\0"
"\xd0\xa1\xd1\x96\xd1\x87;\xd0\x9b\xd1\x8e\xd1\x82;\xd0\x91\xd0\xb5\xd1\x80;\xd0\x9a"
"\xd0\xb2\xd1\x96;\xd0\xa2\xd1\x80\xd0\xb0;\xd0\xa7\xd0\xb5\xd1\x80;\xd0\x9b\xd0\xb8"
"\xd0\xbf;\xd0\xa1\xd0\xb5\xd1\x80;\xd0\x92\xd0\xb5\xd1\x80;\xd0\x96\xd0\xbe\xd0\xb2"
";\xd0\x9b\xd0\xb8\xd1\x81;\xd0\x93\xd1\x80\xd1\x83;\0"
"\xd0\xa1\xd1\x96\xd1\x87\xd0\xb5\xd0\xbd\xd1\x8c;\xd0\x9b\xd1\x8e\xd1\x82\xd0\xb8"
"\xd0\xb9;\xd0\x91\xd0\xb5\xd1\x80\xd0\xb5\xd0\xb7\xd0\xb5\xd0\xbd\xd1\x8c;\xd0\x9a"
"\xd0\xb2\xd1\x96\xd1\x82\xd0\xb5\xd0\xbd\xd1\x8c;\xd0\xa2\xd1\x80\xd0\xb0\xd0\xb2"
"\xd0\xb5\xd0\xbd\xd1\x8c;\xd0\xa7\xd0\xb5\xd1\x80\xd0\xb2\xd0\xb5\xd0\xbd\xd1\x8c"
";\xd0\x9b\xd0\xb8\xd0\xbf\xd0\xb5\xd0\xbd\xd1\x8c;\xd0\xa1\xd0\xb5\xd1\x80\xd0\xbf"
"\xd0\xb5\xd0\xbd\xd1\x8c;\xd0\x92\xd0\xb5\xd1\x80\xd0\xb5\xd1\x81\xd0\xb5\xd0\xbd"
"\xd1\x8c;\xd0\x96\xd0\xbe\xd0\xb2\xd1\x82\xd0\xb5\xd0\xbd\xd1\x8c;\xd0\x9b\xd0\xb8"
"\xd1\x81\xd1\x82\xd0\xbe\xd0\xbf\xd0\xb0\xd0\xb4;\xd0\x93\xd1\x80\xd1\x83\xd0\xb4"
"\xd0\xb5\xd0\xbd\xd1\x8c;\0"
"\xd0\xa1;\xd0\x9b;\xd0\x91;\xd0\x9a;\xd0\xa2;\xd0\xa7;\xd0\x9b;\xd0\xa1;\xd0\x92;"
"\xd0\x96;\xd0\x9b;\xd0\x93;\0"
";Chwe;Maw;Ebr;;;Gor;;;;;;\0"
";;;;;;Gorffennaf;;;;;;\0"
"I;C;M;E;M;M;G;A;M;H;T;R;\0"
"uJanuwari;uFebruwari;uMashi;u-Apreli;uMeyi;uJuni;uJulayi;uAgasti;uSepthemba;u-Okt"
"hoba;uNovemba;uDisemba;\0"
"\xe1\x88\x8d;\xe1\x8a\xab;\xe1\x8a\xad;\xe1\x8d\x8b;\xe1\x8a\xad;\xe1\x88\x9d;\xe1"
"\x8a\xb0;\xe1\x88\x9b;\xe1\x8b\xab;\xe1\x88\x98;\xe1\x88\x9d;\xe1\x89\xb0;\0"
"\xe1\x8c\xa0;\xe1\x8a\xa8;\xe1\x88\x98;\xe1\x8a\xa0;\xe1\x8c\x8d;\xe1\x88\xa0;\xe1"
"\x88\x90;\xe1\x8a\x90;\xe1\x8a\xa8;\xe1\x8c\xa0;\xe1\x8a\x80;\xe1\x8a\x80;\0"
"Z;F;M;A;M;J;L;A;S;O;N;D;\0"
"D;D;T;A;D;M;S;D;A;K;A;D;\0"
;

static const char days_data[] =
"Sun;Mon;Tue;Wed;Thu;Fri;Sat;\0"
"Sunday;Monday;Tuesday;Wednesday;Thursday;Friday;Saturday;\0"
"S;M;T;W;T;F;S;\0"
"7;1;2;3;4;5;6;\0"
";;;;;;;\0"
"Dil;Wix;Qib;Rob;Kam;Jim;San;\0"
"Dilbata;Wiixata;Qibxata;Roobii;Kamiisa;Jimaata;Sanbata;\0"
"A;E;T;A;K;G;S;\0"
"Aca;Etl;Tal;Arb;Kam;Gum;Sab;\0"
"Acaada;Etleeni;Talaata;Arbaqa;Kamiisi;Gumqata;Sabti;\0"
"1;2;3;4;5;6;7;\0"
"So;Ma;Di;Wo;Do;Vr;Sa;\0"
"Sondag;Maandag;Dinsdag;Woensdag;Donderdag;Vrydag;Saterdag;\0"
"D;H;M;M;E;P;S;\0"
"Die;H\xc3\xabn;Mar;M\xc3\xabr;Enj;Pre;Sht;\0"
"e diel;e h\xc3\xabn\xc3\xab;e mart\xc3\xab;e m\xc3\xabrkur\xc3\xab;e enjte;e prem"
"te;e shtun\xc3\xab;\0"
"\xe1\x8a\xa5;\xe1\x88\xb0;\xe1\x88\x9b;\xe1\x88\xa8;\xe1\x88\x90;\xe1\x8b\x93;\xe1"
"\x89\x85;\0"
"\xe1\x8a\xa5\xe1\x88\x91\xe1\x8b\xb5;\xe1\x88\xb0\xe1\x8a\x9e;\xe1\x88\x9b\xe1\x8a"
"\xad\xe1\x88\xb0;\xe1\x88\xa8\xe1\x89\xa1\xe1\x8b\x95;\xe1\x88\x90\xe1\x88\x99\xe1"
"\x88\xb5;\xe1\x8b\x93\xe1\x88\xad\xe1\x89\xa5;\xe1\x89\x85\xe1\x8b\xb3\xe1\x88\x9c"
";\0"
"\xe1\x8a\xa5\xe1\x88\x91\xe1\x8b\xb5;\xe1\x88\xb0\xe1\x8a\x9e;\xe1\x88\x9b\xe1\x8a"
"\xad\xe1\x88\xb0\xe1\x8a\x9e;\xe1\x88\xa8\xe1\x89\xa1\xe1\x8b\x95;\xe1\x88\x90\xe1"
"\x88\x99\xe1\x88\xb5;\xe1\x8b\x93\xe1\x88\xad\xe1\x89\xa5;\xe1\x89\x85\xe1\x8b\xb3"
"\xe1\x88\x9c;\0"
"\xd8\xa3\xd8\xad\xd8\xaf;\xd8\xa7\xd8\xab\xd9\x86\xd9\x8a\xd9\x86;\xd8\xab\xd9\x84"
"\xd8\xa7\xd8\xab\xd8\xa7\xd8\xa1;\xd8\xa3\xd8\xb1\xd8\xa8\xd8\xb9\xd8\xa7\xd8\xa1"
";\xd8\xae\xd9\x85\xd9\x8a\xd8\xb3;\xd8\xac\xd9\x85\xd8\xb9\xd8\xa9;\xd8\xb3\xd8\xa8"
"\xd8\xaa;\0"
"\xd8\xad;\xd9\x86;\xd8\xab;\xd8\xb1;\xd8\xae;\xd8\xac;\xd8\xb3;\0"
"\xd8\xa7\xd9\x84\xd8\xa3\xd8\xad\xd8\xaf;\xd8\xa7\xd9\x84\xd8\xa7\xd8\xab\xd9\x86"
"\xd9\x8a\xd9\x86;\xd8\xa7\xd9\x84\xd8\xab\xd9\x84\xd8\xa7\xd8\xab\xd8\xa7\xd8\xa1"
";\xd8\xa7\xd9\x84\xd8\xa3\xd8\xb1\xd8\xa8\xd8\xb9\xd8\xa7\xd8\xa1;\xd8\xa7\xd9\x84"
"\xd8\xae\xd9\x85\xd9\x8a\xd8\xb3;\xd8\xa7\xd9\x84\xd8\xac\xd9\x85\xd8\xb9\xd8\xa9"
";\xd8\xa7\xd9\x84\xd8\xb3\xd8\xa8\xd8\xaa;\0"
"\xd4\xbf\xd5\xab\xd6\x80;\xd4\xb5\xd6\x80\xd5\xaf;\xd4\xb5\xd6\x80\xd6\x84;\xd5\x89"
"\xd5\xb8\xd6\x80;\xd5\x80\xd5\xb6\xd5\xa3;\xd5\x88\xd6\x82\xd6\x80;\xd5\x87\xd5\xa1"
"\xd5\xa2;\0"
"\xd4\xbf\xd5\xab\xd6\x80\xd5\xa1\xd5\xaf\xd5\xab;\xd4\xb5\xd6\x80\xd5\xaf\xd5\xb8"
"\xd6\x82\xd5\xb7\xd5\xa1\xd5\xa2\xd5\xa9\xd5\xab;\xd4\xb5\xd6\x80\xd5\xa5\xd6\x84"
"\xd5\xb7\xd5\xa1\xd5\xa2\xd5\xa9\xd5\xab;\xd5\x89\xd5\xb8\xd6\x80\xd5\xa5\xd6\x84"
"\xd5\xb7\xd5\xa1\xd5\xa2\xd5\xa9\xd5\xab;\xd5\x80\xd5\xab\xd5\xb6\xd5\xa3\xd5\xb7"
"\xd5\xa1\xd5\xa2\xd5\xa9\xd5\xab;\xd5\x88\xd6\x82\xd6\x80\xd5\xa2\xd5\xa1\xd5\xa9"
";\xd5\x87\xd5\xa1\xd5\xa2\xd5\xa1\xd5\xa9;\0"
"\xe0\xa7\xb0\xe0\xa6\xac\xe0\xa6\xbf;\xe0\xa6\xb8\xe0\xa7\x8b\xe0\xa6\xae;\xe0\xa6"
"\xae\xe0\xa6\x99\xe0\xa7\x8d\xe0\xa6\x97\xe0\xa6\xb2;\xe0\xa6\xac\xe0\xa7\x81\xe0"
"\xa6\xa7;\xe0\xa6\xac\xe0\xa7\x83\xe0\xa6\xb9\xe0\xa6\xb7\xe0\xa7\x8d\xe0\xa6\xaa"
"\xe0\xa6\xa4\xe0\xa6\xbf;\xe0\xa6\xb6\xe0\xa7\x81\xe0\xa6\x95\xe0\xa7\x8d\xe0\xa7"
"\xb0;\xe0\xa6\xb6\xe0\xa6\xa8\xe0\xa6\xbf;\0"
"\xe0\xa6\xa6\xe0\xa7\x87\xe0\xa6\x93\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa7\xb0;\xe0\xa6"
"\xb8\xe0\xa7\x8b\xe0\xa6\xae\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa7\xb0;\xe0\xa6\xae\xe0"
"\xa6\x99\xe0\xa7\x8d\xe0\xa6\x97\xe0\xa6\xb2\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa7\xb0;"
"\xe0\xa6\xac\xe0\xa7\x81\xe0\xa6\xa7\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa7\xb0;\xe0\xa6"
"\xac\xe0\xa7\x83\xe0\xa6\xb9\xe0\xa6\xb7\xe0\xa7\x8d\xe0\xa6\xaa\xe0\xa6\xa4\xe0\xa6"
"\xbf\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa7\xb0;\xe0\xa6\xb6\xe0\xa7\x81\xe0\xa6\x95\xe0"
"\xa7\x8d\xe0\xa7\xb0\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa7\xb0;\xe0\xa6\xb6\xe0\xa6\xa8"
"\xe0\xa6\xbf\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa7\xb0;\0"
"B.;B.E.;\xc3\x87.A.;\xc3\x87.;C.A.;C;\xc5\x9e.;\0"
"bazar;bazar ert\xc9\x99si;\xc3\xa7\xc9\x99r\xc5\x9f\xc9\x99nb\xc9\x99 ax\xc5\x9f\x61"
"m\xc4\xb1;\xc3\xa7\xc9\x99r\xc5\x9f\xc9\x99nb\xc9\x99;c\xc3\xbcm\xc9\x99 ax\xc5\x9f"
"\x61m\xc4\xb1;c\xc3\xbcm\xc9\x99;\xc5\x9f\xc9\x99nb\xc9\x99;\0"
"ig;al;as;az;og;or;lr;\0"
"igandea;astelehena;asteartea;asteazkena;osteguna;ostirala;larunbata;\0"
"\xe0\xa6\xb0;\xe0\xa6\xb8\xe0\xa7\x8b;\xe0\xa6\xae;\xe0\xa6\xac\xe0\xa7\x81;\xe0\xa6"
"\xac\xe0\xa7\x83;\xe0\xa6\xb6\xe0\xa7\x81;\xe0\xa6\xb6;\0"
"\xe0\xa6\xb0\xe0\xa6\xac\xe0\xa6\xbf;\xe0\xa6\xb8\xe0\xa7\x8b\xe0\xa6\xae;\xe0\xa6"
"\xae\xe0\xa6\x99\xe0\xa7\x8d\xe0\xa6\x97\xe0\xa6\xb2;\xe0\xa6\xac\xe0\xa7\x81\xe0"
"\xa6\xa7;\xe0\xa6\xac\xe0\xa7\x83\xe0\xa6\xb9\xe0\xa6\xb8\xe0\xa7\x8d\xe0\xa6\xaa"
"\xe0\xa6\xa4\xe0\xa6\xbf;\xe0\xa6\xb6\xe0\xa7\x81\xe0\xa6\x95\xe0\xa7\x8d\xe0\xa6"
"\xb0;\xe0\xa6\xb6\xe0\xa6\xa8\xe0\xa6\xbf;\0"
"\xe0\xa6\xb0\xe0\xa6\xac\xe0\xa6\xbf\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa6\xb0;\xe0\xa6"
"\xb8\xe0\xa7\x8b\xe0\xa6\xae\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa6\xb0;\xe0\xa6\xae\xe0"
"\xa6\x99\xe0\xa7\x8d\xe0\xa6\x97\xe0\xa6\xb2\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa6\xb0;"
"\xe0\xa6\xac\xe0\xa7\x81\xe0\xa6\xa7\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa6\xb0;\xe0\xa6"
"\xac\xe0\xa7\x83\xe0\xa6\xb9\xe0\xa6\xb7\xe0\xa7\x8d\xe0\xa6\xaa\xe0\xa6\xa4\xe0\xa6"
"\xbf\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa6\xb0;\xe0\xa6\xb6\xe0\xa7\x81\xe0\xa6\x95\xe0"
"\xa7\x8d\xe0\xa6\xb0\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa6\xb0;\xe0\xa6\xb6\xe0\xa6\xa8"
"\xe0\xa6\xbf\xe0\xa6\xac\xe0\xa6\xbe\xe0\xa6\xb0;\0"
"\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbc\x8b;\xe0\xbd\x98\xe0\xbd\xb2\xe0\xbd\xa2\xe0\xbc"
"\x8b;\xe0\xbd\xa3\xe0\xbe\xb7\xe0\xbd\x82\xe0\xbc\x8b;\xe0\xbd\x95\xe0\xbd\xb4\xe0"
"\xbd\xa2\xe0\xbc\x8b;\xe0\xbd\xa6\xe0\xbd\x84\xe0\xbd\xa6\xe0\xbc\x8b;\xe0\xbd\xa6"
"\xe0\xbe\xa4\xe0\xbd\xba\xe0\xbd\x93\xe0\xbc\x8b;\xe0\xbd\x89\xe0\xbd\xb2\xe0\xbc"
"\x8b;\0"
"\xe0\xbd\x82\xe0\xbd\x9f\xe0\xbd\xa0\xe0\xbc\x8b\xe0\xbd\x9f\xe0\xbe\xb3\xe0\xbc\x8b"
"\xe0\xbd\x96\xe0\xbc\x8b;\xe0\xbd\x82\xe0\xbd\x9f\xe0\xbd\xa0\xe0\xbc\x8b\xe0\xbd"
"\x98\xe0\xbd\xb2\xe0\xbd\x82\xe0\xbc\x8b\xe0\xbd\x91\xe0\xbd\x98\xe0\xbd\xa2\xe0\xbc"
"\x8b;\xe0\xbd\x82\xe0\xbd\x9f\xe0\xbd\xa0\xe0\xbc\x8b\xe0\xbd\xa3\xe0\xbe\xb7\xe0"
"\xbd\x82\xe0\xbc\x8b\xe0\xbd\x94\xe0\xbc\x8b;\xe0\xbd\x82\xe0\xbd\x9f\xe0\xbd\xa0"
"\xe0\xbc\x8b\xe0\xbd\x95\xe0\xbd\xb4\xe0\xbd\xa2\xe0\xbc\x8b\xe0\xbd\x96\xe0\xbd\xb4"
"\xe0\xbc\x8b;\xe0\xbd\x82\xe0\xbd\x9f\xe0\xbd\xa0\xe0\xbc\x8b\xe0\xbd\x94\xe0\xbc"
"\x8b\xe0\xbd\xa6\xe0\xbd\x84\xe0\xbd\xa6\xe0\xbc\x8b;\xe0\xbd\x82\xe0\xbd\x9f\xe0"
"\xbd\xa0\xe0\xbc\x8b\xe0\xbd\xa6\xe0\xbe\xa4\xe0\xbd\xba\xe0\xbd\x93\xe0\xbc\x8b\xe0"
"\xbd\x94\xe0\xbc\x8b;\xe0\xbd\x82\xe0\xbd\x9f\xe0\xbd\xa0\xe0\xbc\x8b\xe0\xbd\x89"
"\xe0\xbd\xb2\xe0\xbc\x8b\xe0\xbd\x98\xe0\xbc\x8b;\0"
"\xd0\xbd;\xd0\xbf;\xd0\xb2;\xd1\x81;\xd1\x87;\xd0\xbf;\xd1\x81;\0"
"\xd0\xbd\xd0\xb4;\xd0\xbf\xd0\xbd;\xd0\xb2\xd1\x82;\xd1\x81\xd1\x80;\xd1\x87\xd1\x82"
";\xd0\xbf\xd1\x82;\xd1\x81\xd0\xb1;\0"
"\xd0\xbd\xd0\xb5\xd0\xb4\xd0\xb5\xd0\xbb\xd1\x8f;\xd0\xbf\xd0\xbe\xd0\xbd\xd0\xb5"
"\xd0\xb4\xd0\xb5\xd0\xbb\xd0\xbd\xd0\xb8\xd0\xba;\xd0\xb2\xd1\x82\xd0\xbe\xd1\x80"
"\xd0\xbd\xd0\xb8\xd0\xba;\xd1\x81\xd1\x80\xd1\x8f\xd0\xb4\xd0\xb0;\xd1\x87\xd0\xb5"
"\xd1\x82\xd0\xb2\xd1\x8a\xd1\x80\xd1\x82\xd1\x8a\xd0\xba;\xd0\xbf\xd0\xb5\xd1\x82"
"\xd1\x8a\xd0\xba;\xd1\x81\xd1\x8a\xd0\xb1\xd0\xbe\xd1\x82\xd0\xb0;\0"
"\xe1\x80\x90;\xe1\x80\x90;\xe1\x80\xa1;\xe1\x80\x97;\xe1\x80\x80;\xe1\x80\x9e;\xe1"
"\x80\x85;\0"
"\xe1\x80\x94\xe1\x80\xbd\xe1\x80\xb1;\xe1\x80\x9c\xe1\x80\xac;\xe1\x80\x82\xe1\x80"
"\xab;\xe1\x80\x9f\xe1\x80\xb0\xe1\x80\xb8;\xe1\x80\x90\xe1\x80\xb1\xe1\x80\xb8;\xe1"
"\x80\x80\xe1\x80\xbc\xe1\x80\xac;\xe1\x80\x94\xe1\x80\xb1;\0"
"\xe1\x80\x90\xe1\x80\x94\xe1\x80\x84\xe1\x80\xba\xe1\x80\xb9\xe1\x80\x82\xe1\x80\x94"
"\xe1\x80\xbd\xe1\x80\xb1;\xe1\x80\x90\xe1\x80\x94\xe1\x80\x84\xe1\x80\xba\xe1\x80"
"\xb9\xe1\x80\x9c\xe1\x80\xac;\xe1\x80\xa1\xe1\x80\x84\xe1\x80\xba\xe1\x80\xb9\xe1"
"\x80\x82\xe1\x80\xab;\xe1\x80\x97\xe1\x80\xaf\xe1\x80\x92\xe1\x80\xb9\xe1\x80\x93"
"\xe1\x80\x9f\xe1\x80\xb0\xe1\x80\xb8;\xe1\x80\x80\xe1\x80\xbc\xe1\x80\xac\xe1\x80"
"\x9e\xe1\x80\x95\xe1\x80\x90\xe1\x80\xb1\xe1\x80\xb8;\xe1\x80\x9e\xe1\x80\xb1\xe1"
"\x80\xac\xe1\x80\x80\xe1\x80\xbc\xe1\x80\xac;\xe1\x80\x85\xe1\x80\x94\xe1\x80\xb1"
";\0"
"\xd0\xbd;\xd0\xbf;\xd0\xb0;\xd1\x81;\xd1\x87;\xd0\xbf;\xd1\x81;\0"
"\xd0\xbd\xd0\xb4;\xd0\xbf\xd0\xbd;\xd0\xb0\xd1\x9e;\xd1\x81\xd1\x80;\xd1\x87\xd1\x86"
";\xd0\xbf\xd1\x82;\xd1\x81\xd0\xb1;\0"
"\xd0\xbd\xd1\x8f\xd0\xb4\xd0\xb7\xd0\xb5\xd0\xbb\xd1\x8f;\xd0\xbf\xd0\xb0\xd0\xbd"
"\xd1\x8f\xd0\xb4\xd0\xb7\xd0\xb5\xd0\xbb\xd0\xb0\xd0\xba;\xd0\xb0\xd1\x9e\xd1\x82"
"\xd0\xbe\xd1\x80\xd0\xb0\xd0\xba;\xd1\x81\xd0\xb5\xd1\x80\xd0\xb0\xd0\xb4\xd0\xb0"
";\xd1\x87\xd0\xb0\xd1\x86\xd0\xb2\xd0\xb5\xd1\x80;\xd0\xbf\xd1\x8f\xd1\x82\xd0\xbd"
"\xd1\x96\xd1\x86\xd0\xb0;\xd1\x81\xd1\x83\xd0\xb1\xd0\xbe\xd1\x82\xd0\xb0;\0"
"\xe1\x9e\xa2\xe1\x9e\xb6;\xe1\x9e\x85;\xe1\x9e\xa2;\xe1\x9e\x96\xe1\x9e\xbb;\xe1\x9e"
"\x96\xe1\x9f\x92\xe1\x9e\x9a;\xe1\x9e\x9f\xe1\x9e\xbb;\xe1\x9e\x9f;\0"
"\xe1\x9e\x90\xe1\x9f\x92\xe1\x9e\x84\xe1\x9f\x83\xe1\x9e\xa2\xe1\x9e\xb6\xe1\x9e\x91"
"\xe1\x9e\xb7\xe1\x9e\x8f\xe1\x9f\x92\xe1\x9e\x99;\xe2\x80\x8b\xe1\x9e\x90\xe1\x9f"
"\x92\xe1\x9e\x84\xe1\x9f\x83\xe1\x9e\x85\xe1\x9f\x90\xe1\x9e\x93\xe1\x9f\x92\xe1\x9e"
"\x91;\xe1\x9e\x90\xe1\x9f\x92\xe1\x9e\x84\xe1\x9f\x83\xe1\x9e\xa2\xe1\x9e\x84\xe1"
"\x9f\x92\xe1\x9e\x82\xe1\x9e\xb6\xe1\x9e\x9a;\xe1\x9e\x90\xe1\x9f\x92\xe1\x9e\x84"
"\xe1\x9f\x83\xe1\x9e\x96\xe1\x9e\xbb\xe1\x9e\x92;\xe1\x9e\x90\xe1\x9f\x92\xe1\x9e"
"\x84\xe1\x9f\x83\xe1\x9e\x96\xe1\x9f\x92\xe1\x9e\x9a\xe1\x9e\xa0\xe1\x9e\x9f\xe1\x9f"
"\x92\xe1\x9e\x94\xe1\x9e\x8f\xe1\x9e\xb7\xe1\x9f\x8d;\xe1\x9e\x90\xe1\x9f\x92\xe1"
"\x9e\x84\xe1\x9f\x83\xe1\x9e\x9f\xe1\x9e\xbb\xe1\x9e\x80\xe1\x9f\x92\xe1\x9e\x9a;"
"\xe1\x9e\x90\xe1\x9f\x92\xe1\x9e\x84\xe1\x9f\x83\xe1\x9e\x9f\xe1\x9f\x85\xe1\x9e\x9a"
"\xe1\x9f\x8d;\0"
"dg;dl;dt;dc;dj;dv;ds;\0"
"g;l;t;c;j;v;s;\0"
"dg.;dl.;dt.;dc.;dj.;dv.;ds.;\0"
"diumenge;dilluns;dimarts;dimecres;dijous;divendres;dissabte;\0"
"\xe6\x97\xa5;\xe4\xb8\x80;\xe4\xba\x8c;\xe4\xb8\x89;\xe5\x9b\x9b;\xe4\xba\x94;\xe5"
"\x85\xad;\0"
"\xe5\x91\xa8\xe6\x97\xa5;\xe5\x91\xa8\xe4\xb8\x80;\xe5\x91\xa8\xe4\xba\x8c;\xe5\x91"
"\xa8\xe4\xb8\x89;\xe5\x91\xa8\xe5\x9b\x9b;\xe5\x91\xa8\xe4\xba\x94;\xe5\x91\xa8\xe5"
"\x85\xad;\0"
"\xe6\x98\x9f\xe6\x9c\x9f\xe6\x97\xa5;\xe6\x98\x9f\xe6\x9c\x9f\xe4\xb8\x80;\xe6\x98"
"\x9f\xe6\x9c\x9f\xe4\xba\x8c;\xe6\x98\x9f\xe6\x9c\x9f\xe4\xb8\x89;\xe6\x98\x9f\xe6"
"\x9c\x9f\xe5\x9b\x9b;\xe6\x98\x9f\xe6\x9c\x9f\xe4\xba\x94;\xe6\x98\x9f\xe6\x9c\x9f"
"\xe5\x85\xad;\0"
"n;p;u;s;\xc4\x8d;p;s;\0"
"ned;pon;uto;sri;\xc4\x8d\x65t;pet;sub;\0"
"nedjelja;ponedjeljak;utorak;srijeda;\xc4\x8d\x65tvrtak;petak;subota;\0"
"N;P;\xc3\x9a;S;\xc4\x8c;P;S;\0"
"ne;po;\xc3\xbat;st;\xc4\x8dt;p\xc3\xa1;so;\0"
"ned\xc4\x9ble;pond\xc4\x9bl\xc3\xad;\xc3\xbater\xc3\xbd;st\xc5\x99\x65\x64\x61;\xc4"
"\x8dtvrtek;p\xc3\xa1tek;sobota;\0"
"S;M;T;O;T;F;L;\0"
"s\xc3\xb8n;man;tir;ons;tor;fre;l\xc3\xb8r;\0"
"s\xc3\xb8ndag;mandag;tirsdag;onsdag;torsdag;fredag;l\xc3\xb8rdag;\0"
"Z;M;D;W;D;V;Z;\0"
"zo;ma;di;wo;do;vr;za;\0"
"zondag;maandag;dinsdag;woensdag;donderdag;vrijdag;zaterdag;\0"
"P;E;T;K;N;R;L;\0"
"p\xc3\xbchap\xc3\xa4\x65v;esmasp\xc3\xa4\x65v;teisip\xc3\xa4\x65v;kolmap\xc3\xa4\x65"
"v;neljap\xc3\xa4\x65v;reede;laup\xc3\xa4\x65v;\0"
"sun;m\xc3\xa1n;t\xc3\xbds;mik;h\xc3\xb3s;fr\xc3\xad;ley;\0"
"sunnudagur;m\xc3\xa1nadagur;t\xc3\xbdsdagur;mikudagur;h\xc3\xb3sdagur;fr\xc3\xadg"
"gjadagur;leygardagur;\0"
"S;M;T;K;T;P;L;\0"
"su;ma;ti;ke;to;pe;la;\0"
"sunnuntaina;maanantaina;tiistaina;keskiviikkona;torstaina;perjantaina;lauantaina;"
"\0"
"D;L;M;M;J;V;S;\0"
"dim.;lun.;mar.;mer.;jeu.;ven.;sam.;\0"
"dimanche;lundi;mardi;mercredi;jeudi;vendredi;samedi;\0"
"D;L;M;M;X;V;S;\0"
"Dom;Lun;Mar;M\xc3\xa9r;Xov;Ven;S\xc3\xa1\x62;\0"
"Domingo;Luns;Martes;M\xc3\xa9rcores;Xoves;Venres;S\xc3\xa1\x62\x61\x64o;\0"
"\xe1\x83\x99;\xe1\x83\x9d;\xe1\x83\xa1;\xe1\x83\x9d;\xe1\x83\xae;\xe1\x83\x9e;\xe1"
"\x83\xa8;\0"
"\xe1\x83\x99\xe1\x83\x95\xe1\x83\x98;\xe1\x83\x9d\xe1\x83\xa0\xe1\x83\xa8;\xe1\x83"
"\xa1\xe1\x83\x90\xe1\x83\x9b;\xe1\x83\x9d\xe1\x83\x97\xe1\x83\xae;\xe1\x83\xae\xe1"
"\x83\xa3\xe1\x83\x97;\xe1\x83\x9e\xe1\x83\x90\xe1\x83\xa0;\xe1\x83\xa8\xe1\x83\x90"
"\xe1\x83\x91;\0"
"\xe1\x83\x99\xe1\x83\x95\xe1\x83\x98\xe1\x83\xa0\xe1\x83\x90;\xe1\x83\x9d\xe1\x83"
"\xa0\xe1\x83\xa8\xe1\x83\x90\xe1\x83\x91\xe1\x83\x90\xe1\x83\x97\xe1\x83\x98;\xe1"
"\x83\xa1\xe1\x83\x90\xe1\x83\x9b\xe1\x83\xa8\xe1\x83\x90\xe1\x83\x91\xe1\x83\x90\xe1"
"\x83\x97\xe1\x83\x98;\xe1\x83\x9d\xe1\x83\x97\xe1\x83\xae\xe1\x83\xa8\xe1\x83\x90"
"\xe1\x83\x91\xe1\x83\x90\xe1\x83\x97\xe1\x83\x98;\xe1\x83\xae\xe1\x83\xa3\xe1\x83"
"\x97\xe1\x83\xa8\xe1\x83\x90\xe1\x83\x91\xe1\x83\x90\xe1\x83\x97\xe1\x83\x98;\xe1"
"\x83\x9e\xe1\x83\x90\xe1\x83\xa0\xe1\x83\x90\xe1\x83\xa1\xe1\x83\x99\xe1\x83\x94\xe1"
"\x83\x95\xe1\x83\x98;\xe1\x83\xa8\xe1\x83\x90\xe1\x83\x91\xe1\x83\x90\xe1\x83\x97"
"\xe1\x83\x98;\0"
"S;M;D;M;D;F;S;\0"
"So.;Mo.;Di.;Mi.;Do.;Fr.;Sa.;\0"
"Sonntag;Montag;Dienstag;Mittwoch;Donnerstag;Freitag;Samstag;\0"
"Son;Mon;Die;Mit;Don;Fre;Sam;\0"
"\xce\x9a;\xce\x94;\xce\xa4;\xce\xa4;\xce\xa0;\xce\xa0;\xce\xa3;\0"
"\xce\x9a\xcf\x85\xcf\x81;\xce\x94\xce\xb5\xcf\x85;\xce\xa4\xcf\x81\xce\xb9;\xce\xa4"
"\xce\xb5\xcf\x84;\xce\xa0\xce\xb5\xce\xbc;\xce\xa0\xce\xb1\xcf\x81;\xce\xa3\xce\xb1"
"\xce\xb2;\0"
"\xce\x9a\xcf\x85\xcf\x81\xce\xb9\xce\xb1\xce\xba\xce\xae;\xce\x94\xce\xb5\xcf\x85"
"\xcf\x84\xce\xad\xcf\x81\xce\xb1;\xce\xa4\xcf\x81\xce\xaf\xcf\x84\xce\xb7;\xce\xa4"
"\xce\xb5\xcf\x84\xce\xac\xcf\x81\xcf\x84\xce\xb7;\xce\xa0\xce\xad\xce\xbc\xcf\x80"
"\xcf\x84\xce\xb7;\xce\xa0\xce\xb1\xcf\x81\xce\xb1\xcf\x83\xce\xba\xce\xb5\xcf\x85"
"\xce\xae;\xce\xa3\xce\xac\xce\xb2\xce\xb2\xce\xb1\xcf\x84\xce\xbf;\0"
"sab;ata;mar;pin;sis;tal;arf;\0"
"sabaat;ataasinngorneq;marlunngorneq;pingasunngorneq;sisamanngorneq;tallimanngorne"
"q;arfininngorneq;\0"
"\xe0\xaa\xb0\xe0\xaa\xb5\xe0\xaa\xbf;\xe0\xaa\xb8\xe0\xab\x8b\xe0\xaa\xae;\xe0\xaa"
"\xae\xe0\xaa\x82\xe0\xaa\x97\xe0\xaa\xb3;\xe0\xaa\xac\xe0\xab\x81\xe0\xaa\xa7;\xe0"
"\xaa\x97\xe0\xab\x81\xe0\xaa\xb0\xe0\xab\x81;\xe0\xaa\xb6\xe0\xab\x81\xe0\xaa\x95"
"\xe0\xab\x8d\xe0\xaa\xb0;\xe0\xaa\xb6\xe0\xaa\xa8\xe0\xaa\xbf;\0"
"\xe0\xaa\xb0\xe0\xaa\xb5\xe0\xaa\xbf\xe0\xaa\xb5\xe0\xaa\xbe\xe0\xaa\xb0;\xe0\xaa"
"\xb8\xe0\xab\x8b\xe0\xaa\xae\xe0\xaa\xb5\xe0\xaa\xbe\xe0\xaa\xb0;\xe0\xaa\xae\xe0"
"\xaa\x82\xe0\xaa\x97\xe0\xaa\xb3\xe0\xaa\xb5\xe0\xaa\xbe\xe0\xaa\xb0;\xe0\xaa\xac"
"\xe0\xab\x81\xe0\xaa\xa7\xe0\xaa\xb5\xe0\xaa\xbe\xe0\xaa\xb0;\xe0\xaa\x97\xe0\xab"
"\x81\xe0\xaa\xb0\xe0\xab\x81\xe0\xaa\xb5\xe0\xaa\xbe\xe0\xaa\xb0;\xe0\xaa\xb6\xe0"
"\xab\x81\xe0\xaa\x95\xe0\xab\x8d\xe0\xaa\xb0\xe0\xaa\xb5\xe0\xaa\xbe\xe0\xaa\xb0;"
"\xe0\xaa\xb6\xe0\xaa\xa8\xe0\xaa\xbf\xe0\xaa\xb5\xe0\xaa\xbe\xe0\xaa\xb0;\0"
"L;L;T;L;A;J;A;\0"
"Lah;Lit;Tal;Lar;Alh;Jum;Asa;\0"
"Lahadi;Litini;Talata;Laraba;Alhamis;Jumma'a;Asabar;\0"
"\xd7\x90;\xd7\x91;\xd7\x92;\xd7\x93;\xd7\x94;\xd7\x95;\xd7\xa9;\0"
"\xd7\x99\xd7\x95\xd7\x9d \xd7\xa8\xd7\x90\xd7\xa9\xd7\x95\xd7\x9f;\xd7\x99\xd7\x95"
"\xd7\x9d \xd7\xa9\xd7\xa0\xd7\x99;\xd7\x99\xd7\x95\xd7\x9d \xd7\xa9\xd7\x9c\xd7\x99"
"\xd7\xa9\xd7\x99;\xd7\x99\xd7\x95\xd7\x9d \xd7\xa8\xd7\x91\xd7\x99\xd7\xa2\xd7\x99"
";\xd7\x99\xd7\x95\xd7\x9d \xd7\x97\xd7\x9e\xd7\x99\xd7\xa9\xd7\x99;\xd7\x99\xd7\x95"
"\xd7\x9d \xd7\xa9\xd7\x99\xd7\xa9\xd7\x99;\xd7\xa9\xd7\x91\xd7\xaa;\0"
"\xe0\xa4\xb0;2;\xe0\xa4\xae\xe0\xa4\x82;4;\xe0\xa4\x97\xe0\xa5\x81;6;7;\0"
"\xe0\xa4\xb0\xe0\xa4\xb5\xe0\xa4\xbf;\xe0\xa4\xb8\xe0\xa5\x8b\xe0\xa4\xae;\xe0\xa4"
"\xae\xe0\xa4\x82\xe0\xa4\x97\xe0\xa4\xb2;\xe0\xa4\xac\xe0\xa5\x81\xe0\xa4\xa7;\xe0"
"\xa4\x97\xe0\xa5\x81\xe0\xa4\xb0\xe0\xa5\x81;\xe0\xa4\xb6\xe0\xa5\x81\xe0\xa4\x95"
"\xe0\xa5\x8d\xe0\xa4\xb0;\xe0\xa4\xb6\xe0\xa4\xa8\xe0\xa4\xbf;\0"
"\xe0\xa4\xb0\xe0\xa4\xb5\xe0\xa4\xbf\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4"
"\xb8\xe0\xa5\x8b\xe0\xa4\xae\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4\xae\xe0"
"\xa4\x82\xe0\xa4\x97\xe0\xa4\xb2\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4\xac"
"\xe0\xa5\x81\xe0\xa4\xa7\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4\x97\xe0\xa5"
"\x81\xe0\xa4\xb0\xe0\xa5\x81\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4\xb6\xe0"
"\xa5\x81\xe0\xa4\x95\xe0\xa5\x8d\xe0\xa4\xb0\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;"
"\xe0\xa4\xb6\xe0\xa4\xa8\xe0\xa4\xbf\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;\0"
"V;H;K;S;C;P;S;\0"
"V;H;K;Sze;Cs;P;Szo;\0"
"vas\xc3\xa1rnap;h\xc3\xa9tf\xc5\x91;kedd;szerda;cs\xc3\xbct\xc3\xb6rt\xc3\xb6k;p\xc3"
"\xa9ntek;szombat;\0"
"s;m;\xc3\xbe;m;f;f;l;\0"
"sun;m\xc3\xa1n;\xc3\xberi;mi\xc3\xb0;fim;f\xc3\xb6s;lau;\0"
"sunnudagur;m\xc3\xa1nudagur;\xc3\xberi\xc3\xb0judagur;mi\xc3\xb0vikudagur;fimmtud"
"agur;f\xc3\xb6studagur;laugardagur;\0"
"Min;Sen;Sel;Rab;Kam;Jum;Sab;\0"
"Minggu;Senin;Selasa;Rabu;Kamis;Jumat;Sabtu;\0"
"D;L;M;C;D;A;S;\0"
"Domh;Luan;M\xc3\xa1irt;C\xc3\xa9\x61\x64;D\xc3\xa9\x61r;Aoine;Sath;\0"
"D\xc3\xa9 Domhnaigh;D\xc3\xa9 Luain;D\xc3\xa9 M\xc3\xa1irt;D\xc3\xa9 C\xc3\xa9\x61"
"\x64\x61oin;D\xc3\xa9\x61rdaoin;D\xc3\xa9 hAoine;D\xc3\xa9 Sathairn;\0"
"Domenica;Luned\xc3\xac;Marted\xc3\xac;Mercoled\xc3\xac;Gioved\xc3\xac;Venerd\xc3\xac"
";Sabato;\0"
"D;L;M;M;G;V;S;\0"
"dom;lun;mar;mer;gio;ven;sab;\0"
"domenica;luned\xc3\xac;marted\xc3\xac;mercoled\xc3\xac;gioved\xc3\xac;venerd\xc3\xac"
";sabato;\0"
"\xe6\x97\xa5;\xe6\x9c\x88;\xe7\x81\xab;\xe6\xb0\xb4;\xe6\x9c\xa8;\xe9\x87\x91;\xe5"
"\x9c\x9f;\0"
"\xe6\x97\xa5\xe6\x9b\x9c\xe6\x97\xa5;\xe6\x9c\x88\xe6\x9b\x9c\xe6\x97\xa5;\xe7\x81"
"\xab\xe6\x9b\x9c\xe6\x97\xa5;\xe6\xb0\xb4\xe6\x9b\x9c\xe6\x97\xa5;\xe6\x9c\xa8\xe6"
"\x9b\x9c\xe6\x97\xa5;\xe9\x87\x91\xe6\x9b\x9c\xe6\x97\xa5;\xe5\x9c\x9f\xe6\x9b\x9c"
"\xe6\x97\xa5;\0"
"\xe0\xb2\xb0.;\xe0\xb2\xb8\xe0\xb3\x8b.;\xe0\xb2\xae\xe0\xb2\x82.;\xe0\xb2\xac\xe0"
"\xb3\x81.;\xe0\xb2\x97\xe0\xb3\x81.;\xe0\xb2\xb6\xe0\xb3\x81.;\xe0\xb2\xb6\xe0\xb2"
"\xa8\xe0\xb2\xbf.;\0"
"\xe0\xb2\xb0\xe0\xb2\xb5\xe0\xb2\xbf\xe0\xb2\xb5\xe0\xb2\xbe\xe0\xb2\xb0;\xe0\xb2"
"\xb8\xe0\xb3\x8b\xe0\xb2\xae\xe0\xb2\xb5\xe0\xb2\xbe\xe0\xb2\xb0;\xe0\xb2\xae\xe0"
"\xb2\x82\xe0\xb2\x97\xe0\xb2\xb3\xe0\xb2\xb5\xe0\xb2\xbe\xe0\xb2\xb0;\xe0\xb2\xac"
"\xe0\xb3\x81\xe0\xb2\xa7\xe0\xb2\xb5\xe0\xb2\xbe\xe0\xb2\xb0;\xe0\xb2\x97\xe0\xb3"
"\x81\xe0\xb2\xb0\xe0\xb3\x81\xe0\xb2\xb5\xe0\xb2\xbe\xe0\xb2\xb0;\xe0\xb2\xb6\xe0"
"\xb3\x81\xe0\xb2\x95\xe0\xb3\x8d\xe0\xb2\xb0\xe0\xb2\xb5\xe0\xb2\xbe\xe0\xb2\xb0;"
"\xe0\xb2\xb6\xe0\xb2\xa8\xe0\xb2\xbf\xe0\xb2\xb5\xe0\xb2\xbe\xe0\xb2\xb0;\0"
"\xd0\xb6\xd1\x81.;\xd0\xb4\xd1\x81.;\xd1\x81\xd1\x81.;\xd1\x81\xd1\x80.;\xd0\xb1\xd1"
"\x81.;\xd0\xb6\xd0\xbc.;\xd1\x81\xd2\xbb.;\0"
"\xd0\xb6\xd0\xb5\xd0\xba\xd1\x81\xd0\xb5\xd0\xbd\xd1\x96;\xd0\xb4\xd1\x83\xd0\xb9"
"\xd1\x81\xd0\xb5\xd0\xbd\xd0\xb1\xd1\x96;\xd1\x81\xd0\xb5\xd0\xb9\xd1\x81\xd0\xb5"
"\xd0\xbd\xd0\xb1\xd1\x96;\xd1\x81\xd3\x99\xd1\x80\xd0\xb5\xd0\xbd\xd0\xb1\xd1\x96"
";\xd0\xb1\xd0\xb5\xd0\xb9\xd1\x81\xd0\xb5\xd0\xbd\xd0\xb1\xd1\x96;\xd0\xb6\xd2\xb1"
"\xd0\xbc\xd0\xb0;\xd1\x81\xd0\xb5\xd0\xbd\xd0\xb1\xd1\x96;\0"
"cyu.;mbe.;kab.;gtu.;kan.;gnu.;gnd.;\0"
"Ku cyumweru;Kuwa mbere;Kuwa kabiri;Kuwa gatatu;Kuwa kane;Kuwa gatanu;Kuwa gatanda"
"tu;\0"
"\xec\x9d\xbc;\xec\x9b\x94;\xed\x99\x94;\xec\x88\x98;\xeb\xaa\xa9;\xea\xb8\x88;\xed"
"\x86\xa0;\0"
"\xec\x9d\xbc\xec\x9a\x94\xec\x9d\xbc;\xec\x9b\x94\xec\x9a\x94\xec\x9d\xbc;\xed\x99"
"\x94\xec\x9a\x94\xec\x9d\xbc;\xec\x88\x98\xec\x9a\x94\xec\x9d\xbc;\xeb\xaa\xa9\xec"
"\x9a\x94\xec\x9d\xbc;\xea\xb8\x88\xec\x9a\x94\xec\x9d\xbc;\xed\x86\xa0\xec\x9a\x94"
"\xec\x9d\xbc;\0"
"\xe0\xba\xad\xe0\xba\xb2.;\xe0\xba\x88.;\xe0\xba\xad.;\xe0\xba\x9e.;\xe0\xba\x9e\xe0"
"\xba\xab.;\xe0\xba\xaa\xe0\xba\x81.;\xe0\xba\xaa.;\0"
"\xe0\xba\xa7\xe0\xba\xb1\xe0\xba\x99\xe0\xba\xad\xe0\xba\xb2\xe0\xba\x97\xe0\xba\xb4"
"\xe0\xba\x94;\xe0\xba\xa7\xe0\xba\xb1\xe0\xba\x99\xe0\xba\x88\xe0\xba\xb1\xe0\xba"
"\x99;\xe0\xba\xa7\xe0\xba\xb1\xe0\xba\x99\xe0\xba\xad\xe0\xba\xb1\xe0\xba\x87\xe0"
"\xba\x84\xe0\xba\xb2\xe0\xba\x99;\xe0\xba\xa7\xe0\xba\xb1\xe0\xba\x99\xe0\xba\x9e"
"\xe0\xba\xb8\xe0\xba\x94;\xe0\xba\xa7\xe0\xba\xb1\xe0\xba\x99\xe0\xba\x9e\xe0\xba"
"\xb0\xe0\xba\xab\xe0\xba\xb1\xe0\xba\x94;\xe0\xba\xa7\xe0\xba\xb1\xe0\xba\x99\xe0"
"\xba\xaa\xe0\xba\xb8\xe0\xba\x81;\xe0\xba\xa7\xe0\xba\xb1\xe0\xba\x99\xe0\xbb\x80"
"\xe0\xba\xaa\xe0\xba\xbb\xe0\xba\xb2;\0"
";Pr;ot;Tr;Ce;pk;Se;\0"
"S;P;O;T;C;P;S;\0"
"Sv;P;O;T;C;Pk;S;\0"
"sv\xc4\x93tdiena;pirmdiena;otrdiena;tre\xc5\xa1\x64iena;ceturtdiena;piektdiena;se"
"stdiena;\0"
"eye;m1;m2;m3;m4;m5;mps;\0"
"eyenga;mok\xc9\x94l\xc9\x94 ya libos\xc3\xb3;mok\xc9\x94l\xc9\x94 ya m\xc3\xad\x62"
"\x61l\xc3\xa9;mok\xc9\x94l\xc9\x94 ya m\xc3\xads\xc3\xa1to;mok\xc9\x94l\xc9\x94 y"
"a m\xc3\xadn\xc3\xa9i;mok\xc9\x94l\xc9\x94 ya m\xc3\xadt\xc3\xa1no;mp\xc9\x94\xcc"
"\x81s\xc9\x94;\0"
"S;P;A;T;K;P;\xc5\xa0;\0"
"Sk;Pr;An;Tr;Kt;Pn;\xc5\xa0t;\0"
"sekmadienis;pirmadienis;antradienis;tre\xc4\x8diadienis;ketvirtadienis;penktadien"
"is;\xc5\xa1\x65\xc5\xa1tadienis;\0"
"\xd0\xbd\xd0\xb5\xd0\xb4.;\xd0\xbf\xd0\xbe\xd0\xbd.;\xd0\xb2\xd1\x82.;\xd1\x81\xd1"
"\x80\xd0\xb5.;\xd1\x87\xd0\xb5\xd1\x82.;\xd0\xbf\xd0\xb5\xd1\x82.;\xd1\x81\xd0\xb0"
"\xd0\xb1.;\0"
"\xd0\xbd\xd0\xb5\xd0\xb4\xd0\xb5\xd0\xbb\xd0\xb0;\xd0\xbf\xd0\xbe\xd0\xbd\xd0\xb5"
"\xd0\xb4\xd0\xb5\xd0\xbb\xd0\xbd\xd0\xb8\xd0\xba;\xd0\xb2\xd1\x82\xd0\xbe\xd1\x80"
"\xd0\xbd\xd0\xb8\xd0\xba;\xd1\x81\xd1\x80\xd0\xb5\xd0\xb4\xd0\xb0;\xd1\x87\xd0\xb5"
"\xd1\x82\xd0\xb2\xd1\x80\xd1\x82\xd0\xbe\xd0\xba;\xd0\xbf\xd0\xb5\xd1\x82\xd0\xbe"
"\xd0\xba;\xd1\x81\xd0\xb0\xd0\xb1\xd0\xbe\xd1\x82\xd0\xb0;\0"
"Ahd;Isn;Sel;Rab;Kha;Jum;Sab;\0"
"Ahad;Isnin;Selasa;Rabu;Khamis;Jumaat;Sabtu;\0"
";\xe0\xb4\xa4\xe0\xb4\xbf\xe0\xb4\x99\xe0\xb5\x8d\xe0\xb4\x95\xe0\xb4\xb3\xe0\xb4"
"\xbe\xe0\xb4\xb4\xe0\xb5\x8d\xe0\xb4\x9a;;;;;;\0"
"\xe0\xb4\x9e;\xe0\xb4\xa4;\xe0\xb4\x9a;\xe0\xb4\xac;\xe0\xb4\xb5;\xe0\xb4\xb5;\xe0"
"\xb4\xb6;\0"
"\xe0\xb4\x9e\xe0\xb4\xbe;\xe0\xb4\xa4\xe0\xb4\xbf;\xe0\xb4\x9a\xe0\xb5\x8a;\xe0\xb4"
"\xac\xe0\xb5\x81;\xe0\xb4\xb5\xe0\xb5\x8d\xe0\xb4\xaf\xe0\xb4\xbe;\xe0\xb4\xb5\xe0"
"\xb5\x86;\xe0\xb4\xb6;\0"
"\xe0\xb4\x9e\xe0\xb4\xbe\xe0\xb4\xaf\xe0\xb4\xb0\xe0\xb5\x8d\xe2\x80\x8d;\xe0\xb4"
"\xa4\xe0\xb4\xbf\xe0\xb4\x99\xe0\xb5\x8d\xe0\xb4\x95\xe0\xb4\xb3\xe0\xb5\x8d\xe2\x80"
"\x8d;\xe0\xb4\x9a\xe0\xb5\x8a\xe0\xb4\xb5\xe0\xb5\x8d\xe0\xb4\xb5;\xe0\xb4\xac\xe0"
"\xb5\x81\xe0\xb4\xa7\xe0\xb4\xa8\xe0\xb5\x8d\xe2\x80\x8d;\xe0\xb4\xb5\xe0\xb5\x8d"
"\xe0\xb4\xaf\xe0\xb4\xbe\xe0\xb4\xb4\xe0\xb4\x82;\xe0\xb4\xb5\xe0\xb5\x86\xe0\xb4"
"\xb3\xe0\xb5\x8d\xe0\xb4\xb3\xe0\xb4\xbf;\xe0\xb4\xb6\xe0\xb4\xa8\xe0\xb4\xbf;\0"
";;\xe0\xb4\x9a\xe0\xb5\x8a;;;;;\0"
"\xc4\xa6;T;T;E;\xc4\xa6;\xc4\xa0;S;\0"
"\xc4\xa6\x61\x64;Tne;Tli;Erb;\xc4\xa6\x61m;\xc4\xa0im;Sib;\0"
"Il-\xc4\xa6\x61\x64\x64;It-Tnejn;It-Tlieta;L-Erbg\xc4\xa7\x61;Il-\xc4\xa6\x61mis;"
"Il-\xc4\xa0img\xc4\xa7\x61;Is-Sibt;\0"
"\xe0\xa4\xb0\xe0\xa4\xb5\xe0\xa4\xbf;\xe0\xa4\xb8\xe0\xa5\x8b\xe0\xa4\xae;\xe0\xa4"
"\xae\xe0\xa4\x82\xe0\xa4\x97\xe0\xa4\xb3;\xe0\xa4\xac\xe0\xa5\x81\xe0\xa4\xa7;\xe0"
"\xa4\x97\xe0\xa5\x81\xe0\xa4\xb0\xe0\xa5\x81;\xe0\xa4\xb6\xe0\xa5\x81\xe0\xa4\x95"
"\xe0\xa5\x8d\xe0\xa4\xb0;\xe0\xa4\xb6\xe0\xa4\xa8\xe0\xa4\xbf;\0"
"\xe0\xa4\xb0\xe0\xa4\xb5\xe0\xa4\xbf\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4"
"\xb8\xe0\xa5\x8b\xe0\xa4\xae\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4\xae\xe0"
"\xa4\x82\xe0\xa4\x97\xe0\xa4\xb3\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4\xac"
"\xe0\xa5\x81\xe0\xa4\xa7\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4\x97\xe0\xa5"
"\x81\xe0\xa4\xb0\xe0\xa5\x81\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4\xb6\xe0"
"\xa5\x81\xe0\xa4\x95\xe0\xa5\x8d\xe0\xa4\xb0\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;"
"\xe0\xa4\xb6\xe0\xa4\xa8\xe0\xa4\xbf\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0;\0"
"\xd0\x9d\xd1\x8f;\xd0\x94\xd0\xb0;\xd0\x9c\xd1\x8f;\xd0\x9b\xd1\x85;\xd0\x9f\xd2\xaf"
";\xd0\x91\xd0\xb0;\xd0\x91\xd1\x8f;\0"
"\xd0\xbd\xd1\x8f\xd0\xbc;\xd0\xb4\xd0\xb0\xd0\xb2\xd0\xb0\xd0\xb0;\xd0\xbc\xd1\x8f"
"\xd0\xb3\xd0\xbc\xd0\xb0\xd1\x80;\xd0\xbb\xd1\x85\xd0\xb0\xd0\xb3\xd0\xb2\xd0\xb0"
";\xd0\xbf\xd2\xaf\xd1\x80\xd1\x8d\xd0\xb2;\xd0\xb1\xd0\xb0\xd0\xb0\xd1\x81\xd0\xb0"
"\xd0\xbd;\xd0\xb1\xd1\x8f\xd0\xbc\xd0\xb1\xd0\xb0;\0"
"\xe0\xa5\xa7;\xe0\xa5\xa8;\xe0\xa5\xa9;\xe0\xa5\xaa;\xe0\xa5\xab;\xe0\xa5\xac;\xe0"
"\xa5\xad;\0"
"\xe0\xa4\x86\xe0\xa4\x87\xe0\xa4\xa4;\xe0\xa4\xb8\xe0\xa5\x8b\xe0\xa4\xae;\xe0\xa4"
"\xae\xe0\xa4\x99\xe0\xa5\x8d\xe0\xa4\x97\xe0\xa4\xb2;\xe0\xa4\xac\xe0\xa5\x81\xe0"
"\xa4\xa7;\xe0\xa4\xac\xe0\xa4\xbf\xe0\xa4\xb9\xe0\xa5\x80;\xe0\xa4\xb6\xe0\xa5\x81"
"\xe0\xa4\x95\xe0\xa5\x8d\xe0\xa4\xb0;\xe0\xa4\xb6\xe0\xa4\xa8\xe0\xa4\xbf;\0"
"\xe0\xa4\x86\xe0\xa4\x87\xe0\xa4\xa4\xe0\xa4\xac\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4"
"\xb8\xe0\xa5\x8b\xe0\xa4\xae\xe0\xa4\xac\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4\xae\xe0"
"\xa4\x99\xe0\xa5\x8d\xe0\xa4\x97\xe0\xa4\xb2\xe0\xa4\xac\xe0\xa4\xbe\xe0\xa4\xb0;"
"\xe0\xa4\xac\xe0\xa5\x81\xe0\xa4\xa7\xe0\xa4\xac\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4"
"\xac\xe0\xa4\xbf\xe0\xa4\xb9\xe0\xa5\x80\xe0\xa4\xac\xe0\xa4\xbe\xe0\xa4\xb0;\xe0"
"\xa4\xb6\xe0\xa5\x81\xe0\xa4\x95\xe0\xa5\x8d\xe0\xa4\xb0\xe0\xa4\xac\xe0\xa4\xbe\xe0"
"\xa4\xb0;\xe0\xa4\xb6\xe0\xa4\xa8\xe0\xa4\xbf\xe0\xa4\xac\xe0\xa4\xbe\xe0\xa4\xb0"
";\0"
"s\xc3\xb8n.;man.;tir.;ons.;tor.;fre.;l\xc3\xb8r.;\0"
"\xe0\xac\xb0\xe0\xac\xac\xe0\xac\xbf;\xe0\xac\xb8\xe0\xad\x8b\xe0\xac\xae;\xe0\xac"
"\xae\xe0\xac\x99\xe0\xad\x8d\xe0\xac\x97\xe0\xac\xb3;\xe0\xac\xac\xe0\xad\x81\xe0"
"\xac\xa7;\xe0\xac\x97\xe0\xad\x81\xe0\xac\xb0\xe0\xad\x81;\xe0\xac\xb6\xe0\xad\x81"
"\xe0\xac\x95\xe0\xad\x8d\xe0\xac\xb0;\xe0\xac\xb6\xe0\xac\xa8\xe0\xac\xbf;\0"
"\xe0\xac\xb0\xe0\xac\xac\xe0\xac\xbf\xe0\xac\xac\xe0\xac\xbe\xe0\xac\xb0;\xe0\xac"
"\xb8\xe0\xad\x8b\xe0\xac\xae\xe0\xac\xac\xe0\xac\xbe\xe0\xac\xb0;\xe0\xac\xae\xe0"
"\xac\x99\xe0\xad\x8d\xe0\xac\x97\xe0\xac\xb3\xe0\xac\xac\xe0\xac\xbe\xe0\xac\xb0;"
"\xe0\xac\xac\xe0\xad\x81\xe0\xac\xa7\xe0\xac\xac\xe0\xac\xbe\xe0\xac\xb0;\xe0\xac"
"\x97\xe0\xad\x81\xe0\xac\xb0\xe0\xad\x81\xe0\xac\xac\xe0\xac\xbe\xe0\xac\xb0;\xe0"
"\xac\xb6\xe0\xad\x81\xe0\xac\x95\xe0\xad\x8d\xe0\xac\xb0\xe0\xac\xac\xe0\xac\xbe\xe0"
"\xac\xb0;\xe0\xac\xb6\xe0\xac\xa8\xe0\xac\xbf\xe0\xac\xac\xe0\xac\xbe\xe0\xac\xb0"
";\0"
"\xdb\x8c\xda\xa9\xd8\xb4\xd9\x86\xd8\xa8\xd9\x87;\xd8\xaf\xd9\x88\xd8\xb4\xd9\x86"
"\xd8\xa8\xd9\x87;\xd8\xb3\xd9\x87\xe2\x80\x8c\xd8\xb4\xd9\x86\xd8\xa8\xd9\x87;\xda"
"\x86\xd9\x87\xd8\xa7\xd8\xb1\xd8\xb4\xd9\x86\xd8\xa8\xd9\x87;\xd9\xbe\xd9\x86\xd8"
"\xac\xd8\xb4\xd9\x86\xd8\xa8\xd9\x87;\xd8\xac\xd9\x85\xd8\xb9\xd9\x87;\xd8\xb4\xd9"
"\x86\xd8\xa8\xd9\x87;\0"
"\xdb\x8c;\xd8\xaf;\xd8\xb3;\xda\x86;\xd9\xbe;\xd8\xac;\xd8\xb4;\0"
"N;P;W;\xc5\x9a;C;P;S;\0"
"niedz.;pon.;wt.;\xc5\x9br.;czw.;pt.;sob.;\0"
"niedziela;poniedzia\xc5\x82\x65k;wtorek;\xc5\x9broda;czwartek;pi\xc4\x85tek;sobot"
"a;\0"
"D;S;T;Q;Q;S;S;\0"
"dom;seg;ter;qua;qui;sex;s\xc3\xa1\x62;\0"
"domingo;segunda-feira;ter\xc3\xa7\x61-feira;quarta-feira;quinta-feira;sexta-feira"
";s\xc3\xa1\x62\x61\x64o;\0"
"\xe0\xa8\x90;\xe0\xa8\xb8\xe0\xa9\x8b;\xe0\xa8\xae\xe0\xa9\xb0;\xe0\xa8\xac\xe0\xa9"
"\x81\xe0\xa9\xb1;\xe0\xa8\xb5\xe0\xa9\x80;\xe0\xa8\xb8\xe0\xa8\xbc\xe0\xa9\x81\xe0"
"\xa9\xb1;\xe0\xa8\xb8\xe0\xa8\xbc;\0"
"\xe0\xa8\x90\xe0\xa8\xa4.;\xe0\xa8\xb8\xe0\xa9\x8b\xe0\xa8\xae.;\xe0\xa8\xae\xe0\xa9"
"\xb0\xe0\xa8\x97\xe0\xa8\xb2.;\xe0\xa8\xac\xe0\xa9\x81\xe0\xa8\xa7.;\xe0\xa8\xb5\xe0"
"\xa9\x80\xe0\xa8\xb0.;\xe0\xa8\xb8\xe0\xa8\xbc\xe0\xa9\x81\xe0\xa8\x95\xe0\xa8\xb0"
".;\xe0\xa8\xb8\xe0\xa8\xbc\xe0\xa8\xa8\xe0\xa9\x80.;\0"
"\xe0\xa8\x90\xe0\xa8\xa4\xe0\xa8\xb5\xe0\xa8\xbe\xe0\xa8\xb0;\xe0\xa8\xb8\xe0\xa9"
"\x8b\xe0\xa8\xae\xe0\xa8\xb5\xe0\xa8\xbe\xe0\xa8\xb0;\xe0\xa8\xae\xe0\xa9\xb0\xe0"
"\xa8\x97\xe0\xa8\xb2\xe0\xa8\xb5\xe0\xa8\xbe\xe0\xa8\xb0;\xe0\xa8\xac\xe0\xa9\x81"
"\xe0\xa8\xa7\xe0\xa8\xb5\xe0\xa8\xbe\xe0\xa8\xb0;\xe0\xa8\xb5\xe0\xa9\x80\xe0\xa8"
"\xb0\xe0\xa8\xb5\xe0\xa8\xbe\xe0\xa8\xb0;\xe0\xa8\xb8\xe0\xa8\xbc\xe0\xa9\x81\xe0"
"\xa9\xb1\xe0\xa8\x95\xe0\xa8\xb0\xe0\xa8\xb5\xe0\xa8\xbe\xe0\xa8\xb0;\xe0\xa8\xb8"
"\xe0\xa8\xbc\xe0\xa8\xa8\xe0\xa9\x80\xe0\xa8\x9a\xe0\xa8\xb0\xe0\xa8\xb5\xe0\xa8\xbe"
"\xe0\xa8\xb0;\0"
";;;;;;s\xc3\xa2mb\xc4\x83t\xc4\x83;\0"
"D;L;Ma;Mi;J;V;S;\0"
"duminic\xc4\x83;luni;mar\xc8\x9bi;miercuri;joi;vineri;s\xc3\xa2mb\xc4\x83t\xc4\x83"
";\0"
"\xd0\x92\xd0\xbe\xd1\x81\xd0\xba\xd1\x80\xd0\xb5\xd1\x81\xd0\xb5\xd0\xbd\xd1\x8c\xd0"
"\xb5;\xd0\x9f\xd0\xbe\xd0\xbd\xd0\xb5\xd0\xb4\xd0\xb5\xd0\xbb\xd1\x8c\xd0\xbd\xd0"
"\xb8\xd0\xba;\xd0\x92\xd1\x82\xd0\xbe\xd1\x80\xd0\xbd\xd0\xb8\xd0\xba;\xd0\xa1\xd1"
"\x80\xd0\xb5\xd0\xb4\xd0\xb0;\xd0\xa7\xd0\xb5\xd1\x82\xd0\xb2\xd0\xb5\xd1\x80\xd0"
"\xb3;\xd0\x9f\xd1\x8f\xd1\x82\xd0\xbd\xd0\xb8\xd1\x86\xd0\xb0;\xd0\xa1\xd1\x83\xd0"
"\xb1\xd0\xb1\xd0\xbe\xd1\x82\xd0\xb0;\0"
"\xd0\x92;\xd0\x9f;\xd0\x92;\xd0\xa1;\xd0\xa7;\xd0\x9f;\xd0\xa1;\0"
"\xd0\x92\xd1\x81;\xd0\x9f\xd0\xbd;\xd0\x92\xd1\x82;\xd0\xa1\xd1\x80;\xd0\xa7\xd1\x82"
";\xd0\x9f\xd1\x82;\xd0\xa1\xd0\xb1;\0"
"\xd0\xb2\xd0\xbe\xd1\x81\xd0\xba\xd1\x80\xd0\xb5\xd1\x81\xd0\xb5\xd0\xbd\xd1\x8c\xd0"
"\xb5;\xd0\xbf\xd0\xbe\xd0\xbd\xd0\xb5\xd0\xb4\xd0\xb5\xd0\xbb\xd1\x8c\xd0\xbd\xd0"
"\xb8\xd0\xba;\xd0\xb2\xd1\x82\xd0\xbe\xd1\x80\xd0\xbd\xd0\xb8\xd0\xba;\xd1\x81\xd1"
"\x80\xd0\xb5\xd0\xb4\xd0\xb0;\xd1\x87\xd0\xb5\xd1\x82\xd0\xb2\xd0\xb5\xd1\x80\xd0"
"\xb3;\xd0\xbf\xd1\x8f\xd1\x82\xd0\xbd\xd0\xb8\xd1\x86\xd0\xb0;\xd1\x81\xd1\x83\xd0"
"\xb1\xd0\xb1\xd0\xbe\xd1\x82\xd0\xb0;\0"
"\xd0\xbd;\xd0\xbf;\xd1\x83;\xd1\x81;\xd1\x87;\xd0\xbf;\xd1\x81;\0"
"\xd0\xbd\xd0\xb5\xd0\xb4;\xd0\xbf\xd0\xbe\xd0\xbd;\xd1\x83\xd1\x82\xd0\xbe;\xd1\x81"
"\xd1\x80\xd0\xb5;\xd1\x87\xd0\xb5\xd1\x82;\xd0\xbf\xd0\xb5\xd1\x82;\xd1\x81\xd1\x83"
"\xd0\xb1;\0"
"\xd0\xbd\xd0\xb5\xd0\xb4\xd0\xb5\xd1\x99\xd0\xb0;\xd0\xbf\xd0\xbe\xd0\xbd\xd0\xb5"
"\xd0\xb4\xd0\xb5\xd1\x99\xd0\xb0\xd0\xba;\xd1\x83\xd1\x82\xd0\xbe\xd1\x80\xd0\xb0"
"\xd0\xba;\xd1\x81\xd1\x80\xd0\xb5\xd0\xb4\xd0\xb0;\xd1\x87\xd0\xb5\xd1\x82\xd0\xb2"
"\xd1\x80\xd1\x82\xd0\xb0\xd0\xba;\xd0\xbf\xd0\xb5\xd1\x82\xd0\xb0\xd0\xba;\xd1\x81"
"\xd1\x83\xd0\xb1\xd0\xbe\xd1\x82\xd0\xb0;\0"
"\xd0\xbd\xd0\xb5\xd0\xb4;\xd0\xbf\xd0\xbe\xd0\xbd;\xd1\x83\xd1\x82\xd0\xbe;\xd1\x81"
"\xd1\x80\xd0\xb8;\xd1\x87\xd0\xb5\xd1\x82;\xd0\xbf\xd0\xb5\xd1\x82;\xd1\x81\xd1\x83"
"\xd0\xb1;\0"
"\xd0\xbd\xd0\xb5\xd0\xb4\xd0\xb5\xd1\x99\xd0\xb0;\xd0\xbf\xd0\xbe\xd0\xbd\xd0\xb5"
"\xd0\xb4\xd0\xb5\xd1\x99\xd0\xb0\xd0\xba;\xd1\x83\xd1\x82\xd0\xbe\xd1\x80\xd0\xb0"
"\xd0\xba;\xd1\x81\xd1\x80\xd0\xb8\xd1\x98\xd0\xb5\xd0\xb4\xd0\xb0;\xd1\x87\xd0\xb5"
"\xd1\x82\xd0\xb2\xd1\x80\xd1\x82\xd0\xb0\xd0\xba;\xd0\xbf\xd0\xb5\xd1\x82\xd0\xb0"
"\xd0\xba;\xd1\x81\xd1\x83\xd0\xb1\xd0\xbe\xd1\x82\xd0\xb0;\0"
"ned;pon;uto;sre;\xc4\x8d\x65t;pet;sub;\0"
"nedelja;ponedeljak;utorak;sreda;\xc4\x8d\x65tvrtak;petak;subota;\0"
"Son;Mma;Bed;Rar;Ne;Hla;Moq;\0"
"Sontaha;Mmantaha;Labobedi;Laboraru;Labone;Labohlane;Moqebelo;\0"
"Tsh;Mos;Bed;Rar;Ne;Tla;Mat;\0"
"Tshipi;Mosopulogo;Labobedi;Laboraro;Labone;Labotlhano;Matlhatso;\0"
"\xe0\xb6\x89;\xe0\xb7\x83;\xe0\xb6\x85;\xe0\xb6\xb6;\xe0\xb6\xb6\xe0\xb7\x8a\xe2\x80"
"\x8d\xe0\xb6\xbb;\xe0\xb7\x83\xe0\xb7\x92;\xe0\xb7\x83\xe0\xb7\x99;\0"
"\xe0\xb6\x89\xe0\xb6\xbb\xe0\xb7\x92;\xe0\xb7\x83\xe0\xb6\xb3\xe0\xb7\x94;\xe0\xb6"
"\x85\xe0\xb6\x9f;\xe0\xb6\xb6\xe0\xb6\xaf\xe0\xb7\x8f;\xe0\xb6\xb6\xe0\xb7\x8a\xe2"
"\x80\x8d\xe0\xb6\xbb\xe0\xb7\x84;\xe0\xb7\x83\xe0\xb7\x92\xe0\xb6\x9a\xe0\xb7\x94"
";\xe0\xb7\x83\xe0\xb7\x99\xe0\xb6\xb1;\0"
"\xe0\xb6\x89\xe0\xb6\xbb\xe0\xb7\x92\xe0\xb6\xaf\xe0\xb7\x8f;\xe0\xb7\x83\xe0\xb6"
"\xb3\xe0\xb7\x94\xe0\xb6\xaf\xe0\xb7\x8f;\xe0\xb6\x85\xe0\xb6\x9f\xe0\xb7\x84\xe0"
"\xb6\xbb\xe0\xb7\x94\xe0\xb7\x80\xe0\xb7\x8f\xe0\xb6\xaf\xe0\xb7\x8f;\xe0\xb6\xb6"
"\xe0\xb6\xaf\xe0\xb7\x8f\xe0\xb6\xaf\xe0\xb7\x8f;\xe0\xb6\xb6\xe0\xb7\x8a\xe2\x80"
"\x8d\xe0\xb6\xbb\xe0\xb7\x84\xe0\xb7\x83\xe0\xb7\x8a\xe0\xb6\xb4\xe0\xb6\xad\xe0\xb7"
"\x92\xe0\xb6\xb1\xe0\xb7\x8a\xe0\xb6\xaf\xe0\xb7\x8f;\xe0\xb7\x83\xe0\xb7\x92\xe0"
"\xb6\x9a\xe0\xb7\x94\xe0\xb6\xbb\xe0\xb7\x8f\xe0\xb6\xaf\xe0\xb7\x8f;\xe0\xb7\x83"
"\xe0\xb7\x99\xe0\xb6\xb1\xe0\xb7\x83\xe0\xb7\x94\xe0\xb6\xbb\xe0\xb7\x8f\xe0\xb6\xaf"
"\xe0\xb7\x8f;\0"
"Son;Mso;Bil;Tsa;Ne;Hla;Mgc;\0"
"Lisontfo;uMsombuluko;Lesibili;Lesitsatfu;Lesine;Lesihlanu;uMgcibelo;\0"
"N;P;U;S;\xc5\xa0;P;S;\0"
"Ne;Po;Ut;St;\xc5\xa0t;Pi;So;\0"
"Nede\xc4\xbe\x61;Pondelok;Utorok;Streda;\xc5\xa0tvrtok;Piatok;Sobota;\0"
"n;p;t;s;\xc4\x8d;p;s;\0"
"ned;pon;tor;sre;\xc4\x8d\x65t;pet;sob;\0"
"nedelja;ponedeljek;torek;sreda;\xc4\x8d\x65trtek;petek;sobota;\0"
"A;I;S;A;K;J;S;\0"
"Axa;Isn;Sal;Arb;Kha;Jim;Sab;\0"
"Axad;Isniin;Salaaso;Arbaco;Khamiis;Jimco;Sabti;\0"
"dom;lun;mar;mi\xc3\xa9;jue;vie;s\xc3\xa1\x62;\0"
"domingo;lunes;martes;mi\xc3\xa9rcoles;jueves;viernes;s\xc3\xa1\x62\x61\x64o;\0"
"Jpi;Jtt;Jnn;Jtn;Alh;Iju;Jmo;\0"
"Jumapili;Jumatatu;Jumanne;Jumatano;Alhamisi;Ijumaa;Jumamosi;\0"
"s\xc3\xb6n;m\xc3\xa5n;tis;ons;tors;fre;l\xc3\xb6r;\0"
"s\xc3\xb6ndag;m\xc3\xa5ndag;tisdag;onsdag;torsdag;fredag;l\xc3\xb6rdag;\0"
"\xd0\xaf\xd1\x88\xd0\xb1;\xd0\x94\xd1\x88\xd0\xb1;\xd0\xa1\xd1\x88\xd0\xb1;\xd0\xa7"
"\xd1\x88\xd0\xb1;\xd0\x9f\xd1\x88\xd0\xb1;\xd2\xb6\xd0\xbc\xd1\x8a;\xd0\xa8\xd0\xbd"
"\xd0\xb1;\0"
"\xd0\xaf\xd0\xba\xd1\x88\xd0\xb0\xd0\xbd\xd0\xb1\xd0\xb5;\xd0\x94\xd1\x83\xd1\x88"
"\xd0\xb0\xd0\xbd\xd0\xb1\xd0\xb5;\xd0\xa1\xd0\xb5\xd1\x88\xd0\xb0\xd0\xbd\xd0\xb1"
"\xd0\xb5;\xd0\xa7\xd0\xbe\xd1\x80\xd1\x88\xd0\xb0\xd0\xbd\xd0\xb1\xd0\xb5;\xd0\x9f"
"\xd0\xb0\xd0\xbd\xd2\xb7\xd1\x88\xd0\xb0\xd0\xbd\xd0\xb1\xd0\xb5;\xd2\xb6\xd1\x83"
"\xd0\xbc\xd1\x8a\xd0\xb0;\xd0\xa8\xd0\xb0\xd0\xbd\xd0\xb1\xd0\xb5;\0"
"\xe0\xae\x9e\xe0\xae\xbe;\xe0\xae\xa4\xe0\xae\xbf;\xe0\xae\x9a\xe0\xaf\x86;\xe0\xae"
"\xaa\xe0\xaf\x81;\xe0\xae\xb5\xe0\xae\xbf;\xe0\xae\xb5\xe0\xaf\x86;\xe0\xae\x9a;\0"
"\xe0\xae\x9e\xe0\xae\xbe\xe0\xae\xaf\xe0\xae\xbf\xe0\xae\xb1\xe0\xaf\x81;\xe0\xae"
"\xa4\xe0\xae\xbf\xe0\xae\x99\xe0\xaf\x8d\xe0\xae\x95\xe0\xae\xb3\xe0\xaf\x8d;\xe0"
"\xae\x9a\xe0\xaf\x86\xe0\xae\xb5\xe0\xaf\x8d\xe0\xae\xb5\xe0\xae\xbe\xe0\xae\xaf\xe0"
"\xaf\x8d;\xe0\xae\xaa\xe0\xaf\x81\xe0\xae\xa4\xe0\xae\xa9\xe0\xaf\x8d;\xe0\xae\xb5"
"\xe0\xae\xbf\xe0\xae\xaf\xe0\xae\xbe\xe0\xae\xb4\xe0\xae\xa9\xe0\xaf\x8d;\xe0\xae"
"\xb5\xe0\xaf\x86\xe0\xae\xb3\xe0\xaf\x8d\xe0\xae\xb3\xe0\xae\xbf;\xe0\xae\x9a\xe0"
"\xae\xa9\xe0\xae\xbf;\0"
"\xe0\xb0\x86;2;\xe0\xb0\xb8\xe0\xb1\x8a;\xe0\xb0\xad\xe0\xb1\x81;\xe0\xb0\x97\xe0"
"\xb1\x81;\xe0\xb0\xb6\xe0\xb1\x81;\xe0\xb0\xb6;\0"
"\xe0\xb0\x86\xe0\xb0\xa6\xe0\xb0\xbf;\xe0\xb0\xb8\xe0\xb1\x8b\xe0\xb0\xae;\xe0\xb0"
"\xae\xe0\xb0\x82\xe0\xb0\x97\xe0\xb0\xb3;\xe0\xb0\xac\xe0\xb1\x81\xe0\xb0\xa7;\xe0"
"\xb0\x97\xe0\xb1\x81\xe0\xb0\xb0\xe0\xb1\x81;\xe0\xb0\xb6\xe0\xb1\x81\xe0\xb0\x95"
"\xe0\xb1\x8d\xe0\xb0\xb0;\xe0\xb0\xb6\xe0\xb0\xa8\xe0\xb0\xbf;\0"
"\xe0\xb0\x86\xe0\xb0\xa6\xe0\xb0\xbf\xe0\xb0\xb5\xe0\xb0\xbe\xe0\xb0\xb0\xe0\xb0\x82"
";\xe0\xb0\xb8\xe0\xb1\x8b\xe0\xb0\xae\xe0\xb0\xb5\xe0\xb0\xbe\xe0\xb0\xb0\xe0\xb0"
"\x82;\xe0\xb0\xae\xe0\xb0\x82\xe0\xb0\x97\xe0\xb0\xb3\xe0\xb0\xb5\xe0\xb0\xbe\xe0"
"\xb0\xb0\xe0\xb0\x82;\xe0\xb0\xac\xe0\xb1\x81\xe0\xb0\xa7\xe0\xb0\xb5\xe0\xb0\xbe"
"\xe0\xb0\xb0\xe0\xb0\x82;\xe0\xb0\x97\xe0\xb1\x81\xe0\xb0\xb0\xe0\xb1\x81\xe0\xb0"
"\xb5\xe0\xb0\xbe\xe0\xb0\xb0\xe0\xb0\x82;\xe0\xb0\xb6\xe0\xb1\x81\xe0\xb0\x95\xe0"
"\xb1\x8d\xe0\xb0\xb0\xe0\xb0\xb5\xe0\xb0\xbe\xe0\xb0\xb0\xe0\xb0\x82;\xe0\xb0\xb6"
"\xe0\xb0\xa8\xe0\xb0\xbf\xe0\xb0\xb5\xe0\xb0\xbe\xe0\xb0\xb0\xe0\xb0\x82;\0"
"\xe0\xb8\xad;\xe0\xb8\x88;\xe0\xb8\xad;\xe0\xb8\x9e;\xe0\xb8\x9e;\xe0\xb8\xa8;\xe0"
"\xb8\xaa;\0"
"\xe0\xb8\xad\xe0\xb8\xb2.;\xe0\xb8\x88.;\xe0\xb8\xad.;\xe0\xb8\x9e.;\xe0\xb8\x9e\xe0"
"\xb8\xa4.;\xe0\xb8\xa8.;\xe0\xb8\xaa.;\0"
"\xe0\xb8\xa7\xe0\xb8\xb1\xe0\xb8\x99\xe0\xb8\xad\xe0\xb8\xb2\xe0\xb8\x97\xe0\xb8\xb4"
"\xe0\xb8\x95\xe0\xb8\xa2\xe0\xb9\x8c;\xe0\xb8\xa7\xe0\xb8\xb1\xe0\xb8\x99\xe0\xb8"
"\x88\xe0\xb8\xb1\xe0\xb8\x99\xe0\xb8\x97\xe0\xb8\xa3\xe0\xb9\x8c;\xe0\xb8\xa7\xe0"
"\xb8\xb1\xe0\xb8\x99\xe0\xb8\xad\xe0\xb8\xb1\xe0\xb8\x87\xe0\xb8\x84\xe0\xb8\xb2\xe0"
"\xb8\xa3;\xe0\xb8\xa7\xe0\xb8\xb1\xe0\xb8\x99\xe0\xb8\x9e\xe0\xb8\xb8\xe0\xb8\x98"
";\xe0\xb8\xa7\xe0\xb8\xb1\xe0\xb8\x99\xe0\xb8\x9e\xe0\xb8\xa4\xe0\xb8\xab\xe0\xb8"
"\xb1\xe0\xb8\xaa\xe0\xb8\x9a\xe0\xb8\x94\xe0\xb8\xb5;\xe0\xb8\xa7\xe0\xb8\xb1\xe0"
"\xb8\x99\xe0\xb8\xa8\xe0\xb8\xb8\xe0\xb8\x81\xe0\xb8\xa3\xe0\xb9\x8c;\xe0\xb8\xa7"
"\xe0\xb8\xb1\xe0\xb8\x99\xe0\xb9\x80\xe0\xb8\xaa\xe0\xb8\xb2\xe0\xb8\xa3\xe0\xb9\x8c"
";\0"
";;;;\xe0\xb8\x9e\xe0\xb8\xa4;;;\0"
"\xe1\x88\xb0;\xe1\x88\xb0;\xe1\x88\xa0;\xe1\x88\xa8;\xe1\x8a\x83;\xe1\x8b\x93;\xe1"
"\x89\x80;\0"
"\xe1\x88\xb0\xe1\x8a\x95\xe1\x89\xa0;\xe1\x88\xb0\xe1\x8a\x91\xe1\x8b\xad;\xe1\x88"
"\xb0\xe1\x88\x89\xe1\x88\xb5;\xe1\x88\xa8\xe1\x89\xa1\xe1\x8b\x95;\xe1\x88\x93\xe1"
"\x88\x99\xe1\x88\xb5;\xe1\x8b\x93\xe1\x88\xad\xe1\x89\xa2;\xe1\x89\x80\xe1\x8b\xb3"
"\xe1\x88\x9d;\0"
"\xe1\x88\xb0\xe1\x8a\x95\xe1\x89\xa0\xe1\x89\xb5;\xe1\x88\xb0\xe1\x8a\x91\xe1\x8b"
"\xad;\xe1\x88\xb0\xe1\x88\x89\xe1\x88\xb5;\xe1\x88\xa8\xe1\x89\xa1\xe1\x8b\x95;\xe1"
"\x88\x93\xe1\x88\x99\xe1\x88\xb5;\xe1\x8b\x93\xe1\x88\xad\xe1\x89\xa2;\xe1\x89\x80"
"\xe1\x8b\xb3\xe1\x88\x9d;\0"
"\xe1\x88\xb0\xe1\x8a\x95\xe1\x89\xa0;\xe1\x88\xb0\xe1\x8a\x91\xe1\x8b\xad;\xe1\x88"
"\xa0\xe1\x88\x89\xe1\x88\xb5;\xe1\x88\xa8\xe1\x89\xa1\xe1\x8b\x95;\xe1\x8a\x83\xe1"
"\x88\x99\xe1\x88\xb5;\xe1\x8b\x93\xe1\x88\xad\xe1\x89\xa2;\xe1\x89\x80\xe1\x8b\xb3"
"\xe1\x88\x9d;\0"
"\xe1\x88\xb0\xe1\x8a\x95\xe1\x89\xa0\xe1\x89\xb5;\xe1\x88\xb0\xe1\x8a\x91\xe1\x8b"
"\xad;\xe1\x88\xa0\xe1\x88\x89\xe1\x88\xb5;\xe1\x88\xa8\xe1\x89\xa1\xe1\x8b\x95;\xe1"
"\x8a\x83\xe1\x88\x99\xe1\x88\xb5;\xe1\x8b\x93\xe1\x88\xad\xe1\x89\xa2;\xe1\x89\x80"
"\xe1\x8b\xb3\xe1\x88\x9d;\0"
"S;M;T;P;T;F;T;\0"
"S\xc4\x81p;M\xc5\x8dn;Tus;Pul;Tu\xca\xbb\x61;Fal;Tok;\0"
"S\xc4\x81pate;M\xc5\x8dnite;Tusite;Pulelulu;Tu\xca\xbb\x61pulelulu;Falaite;Tokona"
"ki;\0"
"Son;Mus;Bir;Har;Ne;Tlh;Mug;\0"
"Sonto;Musumbhunuku;Ravumbirhi;Ravunharhu;Ravumune;Ravuntlhanu;Mugqivela;\0"
"P;P;S;\xc3\x87;P;C;C;\0"
"Paz;Pzt;Sal;\xc3\x87\x61r;Per;Cum;Cmt;\0"
"Pazar;Pazartesi;Sal\xc4\xb1;\xc3\x87\x61r\xc5\x9f\x61mba;Per\xc5\x9f\x65mbe;Cuma;"
"Cumartesi;\0"
"\xd0\x9d;\xd0\x9f;\xd0\x92;\xd0\xa1;\xd0\xa7;\xd0\x9f;\xd0\xa1;\0"
"\xd0\x9d\xd0\xb4;\xd0\x9f\xd0\xbd;\xd0\x92\xd1\x82;\xd0\xa1\xd1\x80;\xd0\xa7\xd1\x82"
";\xd0\x9f\xd1\x82;\xd0\xa1\xd0\xb1;\0"
"\xd0\x9d\xd0\xb5\xd0\xb4\xd1\x96\xd0\xbb\xd1\x8f;\xd0\x9f\xd0\xbe\xd0\xbd\xd0\xb5"
"\xd0\xb4\xd1\x96\xd0\xbb\xd0\xbe\xd0\xba;\xd0\x92\xd1\x96\xd0\xb2\xd1\x82\xd0\xbe"
"\xd1\x80\xd0\xbe\xd0\xba;\xd0\xa1\xd0\xb5\xd1\x80\xd0\xb5\xd0\xb4\xd0\xb0;\xd0\xa7"
"\xd0\xb5\xd1\x82\xd0\xb2\xd0\xb5\xd1\x80;\xd0\x9f\xca\xbc\xd1\x8f\xd1\x82\xd0\xbd"
"\xd0\xb8\xd1\x86\xd1\x8f;\xd0\xa1\xd1\x83\xd0\xb1\xd0\xbe\xd1\x82\xd0\xb0;\0"
"\xd8\xa7\xd8\xaa\xd9\x88\xd8\xa7\xd8\xb1;\xd9\xbe\xd9\x8a\xd8\xb1;\xd9\x85\xd9\x86"
"\xda\xaf\xd9\x84;\xd8\xa8\xd8\xaf\xd9\x87;\xd8\xac\xd9\x85\xd8\xb9\xd8\xb1\xd8\xa7"
"\xd8\xaa;\xd8\xac\xd9\x85\xd8\xb9\xdb\x81;\xdb\x81\xd9\x81\xd8\xaa\xdb\x81;\0"
"\xd8\xa7;\xd9\xbe;\xd9\x85;\xd8\xa8;\xd8\xac;\xd8\xac;\xdb\x81;\0"
"\xd0\xaf;\xd0\x94;\xd0\xa1;\xd0\xa7;\xd0\x9f;\xd0\x96;\xd0\xa8;\0"
"\xd0\xaf\xd0\xba\xd1\x88;\xd0\x94\xd1\x83\xd1\x88;\xd0\xa1\xd0\xb5\xd1\x88;\xd0\xa7"
"\xd0\xbe\xd1\x80;\xd0\x9f\xd0\xb0\xd0\xb9;\xd0\x96\xd1\x83\xd0\xbc;\xd0\xa8\xd0\xb0"
"\xd0\xbd;\0"
"\xd1\x8f\xd0\xba\xd1\x88\xd0\xb0\xd0\xbd\xd0\xb1\xd0\xb0;\xd0\xb4\xd1\x83\xd1\x88"
"\xd0\xb0\xd0\xbd\xd0\xb1\xd0\xb0;\xd1\x81\xd0\xb5\xd1\x88\xd0\xb0\xd0\xbd\xd0\xb1"
"\xd0\xb0;\xd1\x87\xd0\xbe\xd1\x80\xd1\x88\xd0\xb0\xd0\xbd\xd0\xb1\xd0\xb0;\xd0\xbf"
"\xd0\xb0\xd0\xb9\xd1\x88\xd0\xb0\xd0\xbd\xd0\xb1\xd0\xb0;\xd0\xb6\xd1\x83\xd0\xbc"
"\xd0\xb0;\xd1\x88\xd0\xb0\xd0\xbd\xd0\xb1\xd0\xb0;\0"
"CN;Th 2;Th 3;Th 4;Th 5;Th 6;Th 7;\0"
"Ch\xe1\xbb\xa7 nh\xe1\xba\xadt;Th\xe1\xbb\xa9 hai;Th\xe1\xbb\xa9 ba;Th\xe1\xbb\xa9"
" t\xc6\xb0;Th\xe1\xbb\xa9 n\xc4\x83m;Th\xe1\xbb\xa9 s\xc3\xa1u;Th\xe1\xbb\xa9 b\xe1"
"\xba\xa3y;\0"
";;;;;Gwe;;\0"
"S;L;M;M;I;G;S;\0"
"Sul;Llun;Maw;Mer;Iau;Gwen;Sad;\0"
"Dydd Sul;Dydd Llun;Dydd Mawrth;Dydd Mercher;Dydd Iau;Dydd Gwener;Dydd Sadwrn;\0"
"Caw;Mvu;Bin;Tha;Sin;Hla;Mgq;\0"
"Cawe;Mvulo;Lwesibini;Lwesithathu;Lwesine;Lwesihlanu;Mgqibelo;\0"
"\xc3\x80\xc3\xack\xc3\xba;Aj\xc3\xa9;\xc3\x8cs\xe1\xba\xb9\xcc\x81gun;\xe1\xbb\x8c"
"j\xe1\xbb\x8d\xcc\x81r\xc3\xba;\xc3\x80\xe1\xb9\xa3\xe1\xba\xb9\xcc\x80\xe1\xb9\xa3"
"\xe1\xba\xb9\xcc\x80\x64\xc3\xa1iy\xc3\xa9;\xe1\xba\xb8t\xc3\xac;\xc3\x80\x62\xc3"
"\xa1m\xe1\xba\xb9\xcc\x81ta;\0"
"\xe1\xbb\x8cj\xe1\xbb\x8d\xcc\x81 \xc3\x80\xc3\xack\xc3\xba;\xe1\xbb\x8cj\xe1\xbb"
"\x8d\xcc\x81 Aj\xc3\xa9;\xe1\xbb\x8cj\xe1\xbb\x8d\xcc\x81 \xc3\x8cs\xe1\xba\xb9\xcc"
"\x81gun;\xe1\xbb\x8cj\xe1\xbb\x8d\xcc\x81r\xc3\xba;\xe1\xbb\x8cj\xe1\xbb\x8d\xcc\x81"
" \xc3\x80\xe1\xb9\xa3\xe1\xba\xb9\xcc\x80\xe1\xb9\xa3\xe1\xba\xb9\xcc\x80\x64\xc3"
"\xa1iy\xc3\xa9;\xe1\xbb\x8cj\xe1\xbb\x8d\xcc\x81 \xe1\xba\xb8t\xc3\xac;\xe1\xbb\x8c"
"j\xe1\xbb\x8d\xcc\x81 \xc3\x80\x62\xc3\xa1m\xe1\xba\xb9\xcc\x81ta;\0"
"S;M;B;T;S;H;M;\0"
"Son;Mso;Bil;Tha;Sin;Hla;Mgq;\0"
"Sonto;Msombuluko;Lwesibili;Lwesithathu;uLwesine;Lwesihlanu;Mgqibelo;\0"
";m\xc3\xa5.;;;;;la.;\0"
"s\xc3\xb8.;m\xc3\xa5;ty;on;to;fr;la;\0"
"s\xc3\xb8ndag;m\xc3\xa5ndag;tysdag;onsdag;torsdag;fredag;laurdag;\0"
"Ned;Pon;Uto;Sri;\xc4\x8c\x65t;Pet;Sub;\0"
"Nedjelja;Ponedjeljak;Utorak;Srijeda;\xc4\x8c\x65tvrtak;Petak;Subota;\0"
"Jed;Jel;Jem;Jerc;Jerd;Jeh;Jes;\0"
"Jedoonee;Jelhein;Jemayrt;Jercean;Jerdein;Jeheiney;Jesarn;\0"
"Sul;Lun;Mth;Mhr;Yow;Gwe;Sad;\0"
"De Sul;De Lun;De Merth;De Merher;De Yow;De Gwener;De Sadorn;\0"
"K;D;B;W;Y;F;M;\0"
"Kwe;Dwo;Ben;Wuk;Yaw;Fia;Mem;\0"
"Kwesida;Dwowda;Benada;Wukuda;Yawda;Fida;Memeneda;\0"
"\xe0\xa4\x86\xe0\xa4\xa6\xe0\xa4\xbf\xe0\xa4\xa4\xe0\xa5\x8d\xe0\xa4\xaf\xe0\xa4\xb5"
"\xe0\xa4\xbe\xe0\xa4\xb0;\xe0\xa4\xb8\xe0\xa5\x8b\xe0\xa4\xae\xe0\xa4\xb5\xe0\xa4"
"\xbe\xe0\xa4\xb0;\xe0\xa4\xae\xe0\xa4\x82\xe0\xa4\x97\xe0\xa4\xb3\xe0\xa4\xbe\xe0"
"\xa4\xb0;\xe0\xa4\xac\xe0\xa5\x81\xe0\xa4\xa7\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4\xb0"
";\xe0\xa4\x97\xe0\xa5\x81\xe0\xa4\xb0\xe0\xa5\x81\xe0\xa4\xb5\xe0\xa4\xbe\xe0\xa4"
"\xb0;\xe0\xa4\xb6\xe0\xa5\x81\xe0\xa4\x95\xe0\xa5\x8d\xe0\xa4\xb0\xe0\xa4\xb5\xe0"
"\xa4\xbe\xe0\xa4\xb0;\xe0\xa4\xb6\xe0\xa4\xa8\xe0\xa4\xbf\xe0\xa4\xb5\xe0\xa4\xbe"
"\xe0\xa4\xb0;\0"
"Ho;Dzu;Dzf;Sho;Soo;Soh;Ho;\0"
"Hogbaa;Dzu;Dzufo;Sho;Soo;Sohaa;Ho;\0"
"\xe1\xbb\xa4ka;M\xe1\xbb\x8dn;Tiu;Wen;T\xe1\xbb\x8d\xe1\xbb\x8d;Fra\xe1\xbb\x8b;S"
"at;\0"
"Mb\xe1\xbb\x8ds\xe1\xbb\x8b \xe1\xbb\xa4ka;M\xe1\xbb\x8dnde;Tiuzdee;Wenezdee;T\xe1"
"\xbb\x8d\xe1\xbb\x8dzdee;Fra\xe1\xbb\x8b\x64\x65\x65;Sat\xe1\xbb\x8d\x64\x65\x65;"
"\0"
"Jpl;Jtt;Jnn;Jtn;Alh;Ijm;Jms;\0"
"Jumapili;Jumatatu;Jumanne;Jumatano;Alamisi;Ijumaa;Jumamosi;\0"
"\xe1\x88\xb0;\xe1\x88\xb0;\xe1\x88\xb0;\xe1\x88\x88;\xe1\x8a\xa3;\xe1\x8a\xa3;\xe1"
"\x88\xb0;\0"
"\xe1\x88\xb0/\xe1\x89\x85;\xe1\x88\xb0\xe1\x8a\x91;\xe1\x88\xb0\xe1\x88\x8a\xe1\x8c"
"\x9d;\xe1\x88\x88\xe1\x8c\x93;\xe1\x8a\xa3\xe1\x88\x9d\xe1\x8b\xb5;\xe1\x8a\xa3\xe1"
"\x88\xad\xe1\x89\xa5;\xe1\x88\xb0/\xe1\x88\xbd;\0"
"\xe1\x88\xb0\xe1\x8a\x95\xe1\x89\xa0\xe1\x88\xad \xe1\x89\x85\xe1\x8b\xb3\xe1\x8b"
"\x85;\xe1\x88\xb0\xe1\x8a\x91;\xe1\x88\xb0\xe1\x88\x8a\xe1\x8c\x9d;\xe1\x88\x88\xe1"
"\x8c\x93 \xe1\x8b\x88\xe1\x88\xaa \xe1\x88\x88\xe1\x89\xa5\xe1\x8b\x8b;\xe1\x8a\xa3"
"\xe1\x88\x9d\xe1\x8b\xb5;\xe1\x8a\xa3\xe1\x88\xad\xe1\x89\xa5;\xe1\x88\xb0\xe1\x8a"
"\x95\xe1\x89\xa0\xe1\x88\xad \xe1\x88\xbd\xe1\x8c\x93\xe1\x8b\x85;\0"
"\xe1\x8a\xa5;\xe1\x88\xb0;\xe1\x88\xa0;\xe1\x88\xab;\xe1\x88\x90;\xe1\x8b\x93;\xe1"
"\x89\x80;\0"
"\xe1\x8a\xa5\xe1\x8a\x81\xe1\x8b\xb5;\xe1\x88\xb0\xe1\x8a\x91\xe1\x8b\xad;\xe1\x88"
"\xa0\xe1\x88\x89\xe1\x88\xb5;\xe1\x88\xab\xe1\x89\xa5\xe1\x8b\x95;\xe1\x88\x90\xe1"
"\x88\x99\xe1\x88\xb5;\xe1\x8b\x93\xe1\x88\xad\xe1\x89\xa0;\xe1\x89\x80\xe1\x8b\xb3"
"\xe1\x88\x9a;\0"
"\xe1\x8a\xa5\xe1\x8a\x81\xe1\x8b\xb5;\xe1\x88\xb0\xe1\x8a\x91\xe1\x8b\xad;\xe1\x88"
"\xa0\xe1\x88\x89\xe1\x88\xb5;\xe1\x88\xab\xe1\x89\xa5\xe1\x8b\x95;\xe1\x88\x90\xe1"
"\x88\x99\xe1\x88\xb5;\xe1\x8b\x93\xe1\x88\xad\xe1\x89\xa0;\xe1\x89\x80\xe1\x8b\xb3"
"\xe1\x88\x9a\xe1\x89\xb5;\0"
"Lah;Kub;Gba;Tan;Yei;Koy;Sat;\0"
"Lahadi;Je-Kubacha;Je-Gbai;Tansati;Je-Yei;Je-Koye;Sati;\0"
"S;S;M;R;H;A;Q;\0"
"Sam;San;Mak;Row;Ham;Arb;Qid;\0"
"Sambata;Sanyo;Maakisanyo;Roowe;Hamuse;Arbe;Qidaame;\0"
"Yok;Tung;T. Tung;Tsan;Nas;Nat;Chir;\0"
"Wai Yoka Bawai;Wai Tunga;Toki Gitung;Tsam Kasuwa;Wai Na Nas;Wai Na Tiyon;Wai Na C"
"hirim;\0"
"\xe1\x88\xb0;\xe1\x88\xb0;\xe1\x89\xb3;\xe1\x8a\xa3;\xe1\x8a\xa8;\xe1\x8c\x85;\xe1"
"\x88\xb0;\0"
"\xe1\x88\xb0/\xe1\x8b\x93;\xe1\x88\xb0\xe1\x8a\x96;\xe1\x89\xb3\xe1\x88\x8b\xe1\x88"
"\xb8;\xe1\x8a\xa3\xe1\x88\xa8\xe1\x88\xad;\xe1\x8a\xa8\xe1\x88\x9a\xe1\x88\xbd;\xe1"
"\x8c\x85\xe1\x88\x9d\xe1\x8b\x93;\xe1\x88\xb0/\xe1\x8a\x95;\0"
"\xe1\x88\xb0\xe1\x8a\x95\xe1\x89\xa0\xe1\x89\xb5 \xe1\x8b\x93\xe1\x89\xa3\xe1\x8b"
"\xad;\xe1\x88\xb0\xe1\x8a\x96;\xe1\x89\xb3\xe1\x88\x8b\xe1\x88\xb8\xe1\x8a\x96;\xe1"
"\x8a\xa3\xe1\x88\xa8\xe1\x88\xad\xe1\x89\xa3\xe1\x8b\x93;\xe1\x8a\xa8\xe1\x88\x9a"
"\xe1\x88\xbd;\xe1\x8c\x85\xe1\x88\x9d\xe1\x8b\x93\xe1\x89\xb5;\xe1\x88\xb0\xe1\x8a"
"\x95\xe1\x89\xa0\xe1\x89\xb5 \xe1\x8a\x95\xe1\x8a\xa2\xe1\x88\xbd;\0"
"Lad;Lin;Tal;Lar;Lam;Jum;Asa;\0"
"Ladi;Lintani;Talata;Larba;Lamit;Juma;Asabar;\0"
"dom;lun;mar;mie;joi;vin;sab;\0"
"domenie;lunis;martars;miercus;joibe;vinars;sabide;\0"
"Swo;Mus;Vhi;Rar;\xe1\xb9\x8a\x61;\xe1\xb9\xb0\x61n;Mug;\0"
"Swondaha;Musumbuluwo;\xe1\xb8\xbc\x61vhuvhili;\xe1\xb8\xbc\x61vhuraru;\xe1\xb8\xbc"
"\x61vhu\xe1\xb9\x8b\x61;\xe1\xb8\xbc\x61vhu\xe1\xb9\xb1\x61nu;Mugivhela;\0"
"K;D;B;K;Y;F;M;\0"
"K\xc9\x94s Kwe;Dzo;Bra;Ku\xc9\x96;Yaw;Fi\xc9\x96;Mem;\0"
"K\xc9\x94si\xc9\x96\x61;Dzo\xc9\x96\x61;Bra\xc9\x96\x61;Ku\xc9\x96\x61;Yawo\xc9\x96"
"\x61;Fi\xc9\x96\x61;Memle\xc9\x96\x61;\0"
"LP;P1;P2;P3;P4;P5;P6;\0"
"L\xc4\x81pule;Po\xca\xbb\x61kahi;Po\xca\xbb\x61lua;Po\xca\xbb\x61kolu;Po\xca\xbb\x61"
"h\xc4\x81;Po\xca\xbb\x61lima;Po\xca\xbb\x61ono;\0"
"Lad;Tan;Tal;Lar;Lam;Jum;Asa;\0"
"Ladi;Tanii;Talata;Larba;Lamit;Juma;Asabat;\0"
"Mul;Lem;Wir;Tat;Nai;San;Wer;\0"
"Lamulungu;Lolemba;Lachiwiri;Lachitatu;Lachinayi;Lachisanu;Loweruka;\0"
;

static const char language_name_list[] =
"Default\0"
"C\0"
"Abkhazian\0"
"Afan\0"
"Afar\0"
"Afrikaans\0"
"Albanian\0"
"Amharic\0"
"Arabic\0"
"Armenian\0"
"Assamese\0"
"Aymara\0"
"Azerbaijani\0"
"Bashkir\0"
"Basque\0"
"Bengali\0"
"Bhutani\0"
"Bihari\0"
"Bislama\0"
"Breton\0"
"Bulgarian\0"
"Burmese\0"
"Byelorussian\0"
"Cambodian\0"
"Catalan\0"
"Chinese\0"
"Corsican\0"
"Croatian\0"
"Czech\0"
"Danish\0"
"Dutch\0"
"English\0"
"Esperanto\0"
"Estonian\0"
"Faroese\0"
"Fiji\0"
"Finnish\0"
"French\0"
"Frisian\0"
"Gaelic\0"
"Galician\0"
"Georgian\0"
"German\0"
"Greek\0"
"Greenlandic\0"
"Guarani\0"
"Gujarati\0"
"Hausa\0"
"Hebrew\0"
"Hindi\0"
"Hungarian\0"
"Icelandic\0"
"Indonesian\0"
"Interlingua\0"
"Interlingue\0"
"Inuktitut\0"
"Inupiak\0"
"Irish\0"
"Italian\0"
"Japanese\0"
"Javanese\0"
"Kannada\0"
"Kashmiri\0"
"Kazakh\0"
"Kinyarwanda\0"
"Kirghiz\0"
"Korean\0"
"Kurdish\0"
"Kurundi\0"
"Laothian\0"
"Latin\0"
"Latvian\0"
"Lingala\0"
"Lithuanian\0"
"Macedonian\0"
"Malagasy\0"
"Malay\0"
"Malayalam\0"
"Maltese\0"
"Maori\0"
"Marathi\0"
"Moldavian\0"
"Mongolian\0"
"Nauru\0"
"Nepali\0"
"Norwegian\0"
"Occitan\0"
"Oriya\0"
"Pashto\0"
"Persian\0"
"Polish\0"
"Portuguese\0"
"Punjabi\0"
"Quechua\0"
"RhaetoRomance\0"
"Romanian\0"
"Russian\0"
"Samoan\0"
"Sangho\0"
"Sanskrit\0"
"Serbian\0"
"SerboCroatian\0"
"Sesotho\0"
"Setswana\0"
"Shona\0"
"Sindhi\0"
"Singhalese\0"
"Siswati\0"
"Slovak\0"
"Slovenian\0"
"Somali\0"
"Spanish\0"
"Sundanese\0"
"Swahili\0"
"Swedish\0"
"Tagalog\0"
"Tajik\0"
"Tamil\0"
"Tatar\0"
"Telugu\0"
"Thai\0"
"Tibetan\0"
"Tigrinya\0"
"Tonga\0"
"Tsonga\0"
"Turkish\0"
"Turkmen\0"
"Twi\0"
"Uigur\0"
"Ukrainian\0"
"Urdu\0"
"Uzbek\0"
"Vietnamese\0"
"Volapuk\0"
"Welsh\0"
"Wolof\0"
"Xhosa\0"
"Yiddish\0"
"Yoruba\0"
"Zhuang\0"
"Zulu\0"
"Nynorsk\0"
"Bosnian\0"
"Divehi\0"
"Manx\0"
"Cornish\0"
"Akan\0"
"Konkani\0"
"Ga\0"
"Igbo\0"
"Kamba\0"
"Syriac\0"
"Blin\0"
"Geez\0"
"Koro\0"
"Sidamo\0"
"Atsam\0"
"Tigre\0"
"Jju\0"
"Friulian\0"
"Venda\0"
"Ewe\0"
"Walamo\0"
"Hawaiian\0"
"Tyap\0"
"Chewa\0"
;

static const uint language_name_index[] = {
     0, // Unused
     8, // C
    10, // Abkhazian
    20, // Afan
    25, // Afar
    30, // Afrikaans
    40, // Albanian
    49, // Amharic
    57, // Arabic
    64, // Armenian
    73, // Assamese
    82, // Aymara
    89, // Azerbaijani
   101, // Bashkir
   109, // Basque
   116, // Bengali
   124, // Bhutani
   132, // Bihari
   139, // Bislama
   147, // Breton
   154, // Bulgarian
   164, // Burmese
   172, // Byelorussian
   185, // Cambodian
   195, // Catalan
   203, // Chinese
   211, // Corsican
   220, // Croatian
   229, // Czech
   235, // Danish
   242, // Dutch
   248, // English
   256, // Esperanto
   266, // Estonian
   275, // Faroese
   283, // Fiji
   288, // Finnish
   296, // French
   303, // Frisian
   311, // Gaelic
   318, // Galician
   327, // Georgian
   336, // German
   343, // Greek
   349, // Greenlandic
   361, // Guarani
   369, // Gujarati
   378, // Hausa
   384, // Hebrew
   391, // Hindi
   397, // Hungarian
   407, // Icelandic
   417, // Indonesian
   428, // Interlingua
   440, // Interlingue
   452, // Inuktitut
   462, // Inupiak
   470, // Irish
   476, // Italian
   484, // Japanese
   493, // Javanese
   502, // Kannada
   510, // Kashmiri
   519, // Kazakh
   526, // Kinyarwanda
   538, // Kirghiz
   546, // Korean
   553, // Kurdish
   561, // Kurundi
   569, // Laothian
   578, // Latin
   584, // Latvian
   592, // Lingala
   600, // Lithuanian
   611, // Macedonian
   622, // Malagasy
   631, // Malay
   637, // Malayalam
   647, // Maltese
   655, // Maori
   661, // Marathi
   669, // Moldavian
   679, // Mongolian
   689, // Nauru
   695, // Nepali
   702, // Norwegian
   712, // Occitan
   720, // Oriya
   726, // Pashto
   733, // Persian
   741, // Polish
   748, // Portuguese
   759, // Punjabi
   767, // Quechua
   775, // RhaetoRomance
   789, // Romanian
   798, // Russian
   806, // Samoan
   813, // Sangho
   820, // Sanskrit
   829, // Serbian
   837, // SerboCroatian
   851, // Sesotho
   859, // Setswana
   868, // Shona
   874, // Sindhi
   881, // Singhalese
   892, // Siswati
   900, // Slovak
   907, // Slovenian
   917, // Somali
   924, // Spanish
   932, // Sundanese
   942, // Swahili
   950, // Swedish
   958, // Tagalog
   966, // Tajik
   972, // Tamil
   978, // Tatar
   984, // Telugu
   991, // Thai
   996, // Tibetan
  1004, // Tigrinya
  1013, // Tonga
  1019, // Tsonga
  1026, // Turkish
  1034, // Turkmen
  1042, // Twi
  1046, // Uigur
  1052, // Ukrainian
  1062, // Urdu
  1067, // Uzbek
  1073, // Vietnamese
  1084, // Volapuk
  1092, // Welsh
  1098, // Wolof
  1104, // Xhosa
  1110, // Yiddish
  1118, // Yoruba
  1125, // Zhuang
  1132, // Zulu
  1137, // Nynorsk
  1145, // Bosnian
  1153, // Divehi
  1160, // Manx
  1165, // Cornish
  1173, // Akan
  1178, // Konkani
  1186, // Ga
  1189, // Igbo
  1194, // Kamba
  1200, // Syriac
  1207, // Blin
  1212, // Geez
  1217, // Koro
  1222, // Sidamo
  1229, // Atsam
  1235, // Tigre
  1241, // Jju
  1245, // Friulian
  1254, // Venda
  1260, // Ewe
  1264, // Walamo
  1271, // Hawaiian
  1280, // Tyap
  1285, // Chewa
};

static const char country_name_list[] =
"Default\0"
"Afghanistan\0"
"Albania\0"
"Algeria\0"
"AmericanSamoa\0"
"Andorra\0"
"Angola\0"
"Anguilla\0"
"Antarctica\0"
"AntiguaAndBarbuda\0"
"Argentina\0"
"Armenia\0"
"Aruba\0"
"Australia\0"
"Austria\0"
"Azerbaijan\0"
"Bahamas\0"
"Bahrain\0"
"Bangladesh\0"
"Barbados\0"
"Belarus\0"
"Belgium\0"
"Belize\0"
"Benin\0"
"Bermuda\0"
"Bhutan\0"
"Bolivia\0"
"BosniaAndHerzegowina\0"
"Botswana\0"
"BouvetIsland\0"
"Brazil\0"
"BritishIndianOceanTerritory\0"
"BruneiDarussalam\0"
"Bulgaria\0"
"BurkinaFaso\0"
"Burundi\0"
"Cambodia\0"
"Cameroon\0"
"Canada\0"
"CapeVerde\0"
"CaymanIslands\0"
"CentralAfricanRepublic\0"
"Chad\0"
"Chile\0"
"China\0"
"ChristmasIsland\0"
"CocosIslands\0"
"Colombia\0"
"Comoros\0"
"DemocraticRepublicOfCongo\0"
"PeoplesRepublicOfCongo\0"
"CookIslands\0"
"CostaRica\0"
"IvoryCoast\0"
"Croatia\0"
"Cuba\0"
"Cyprus\0"
"CzechRepublic\0"
"Denmark\0"
"Djibouti\0"
"Dominica\0"
"DominicanRepublic\0"
"EastTimor\0"
"Ecuador\0"
"Egypt\0"
"ElSalvador\0"
"EquatorialGuinea\0"
"Eritrea\0"
"Estonia\0"
"Ethiopia\0"
"FalklandIslands\0"
"FaroeIslands\0"
"Fiji\0"
"Finland\0"
"France\0"
"MetropolitanFrance\0"
"FrenchGuiana\0"
"FrenchPolynesia\0"
"FrenchSouthernTerritories\0"
"Gabon\0"
"Gambia\0"
"Georgia\0"
"Germany\0"
"Ghana\0"
"Gibraltar\0"
"Greece\0"
"Greenland\0"
"Grenada\0"
"Guadeloupe\0"
"Guam\0"
"Guatemala\0"
"Guinea\0"
"GuineaBissau\0"
"Guyana\0"
"Haiti\0"
"HeardAndMcDonaldIslands\0"
"Honduras\0"
"HongKong\0"
"Hungary\0"
"Iceland\0"
"India\0"
"Indonesia\0"
"Iran\0"
"Iraq\0"
"Ireland\0"
"Israel\0"
"Italy\0"
"Jamaica\0"
"Japan\0"
"Jordan\0"
"Kazakhstan\0"
"Kenya\0"
"Kiribati\0"
"DemocraticRepublicOfKorea\0"
"RepublicOfKorea\0"
"Kuwait\0"
"Kyrgyzstan\0"
"Lao\0"
"Latvia\0"
"Lebanon\0"
"Lesotho\0"
"Liberia\0"
"LibyanArabJamahiriya\0"
"Liechtenstein\0"
"Lithuania\0"
"Luxembourg\0"
"Macau\0"
"Macedonia\0"
"Madagascar\0"
"Malawi\0"
"Malaysia\0"
"Maldives\0"
"Mali\0"
"Malta\0"
"MarshallIslands\0"
"Martinique\0"
"Mauritania\0"
"Mauritius\0"
"Mayotte\0"
"Mexico\0"
"Micronesia\0"
"Moldova\0"
"Monaco\0"
"Mongolia\0"
"Montserrat\0"
"Morocco\0"
"Mozambique\0"
"Myanmar\0"
"Namibia\0"
"Nauru\0"
"Nepal\0"
"Netherlands\0"
"NetherlandsAntilles\0"
"NewCaledonia\0"
"NewZealand\0"
"Nicaragua\0"
"Niger\0"
"Nigeria\0"
"Niue\0"
"NorfolkIsland\0"
"NorthernMarianaIslands\0"
"Norway\0"
"Oman\0"
"Pakistan\0"
"Palau\0"
"PalestinianTerritory\0"
"Panama\0"
"PapuaNewGuinea\0"
"Paraguay\0"
"Peru\0"
"Philippines\0"
"Pitcairn\0"
"Poland\0"
"Portugal\0"
"PuertoRico\0"
"Qatar\0"
"Reunion\0"
"Romania\0"
"RussianFederation\0"
"Rwanda\0"
"SaintKittsAndNevis\0"
"StLucia\0"
"StVincentAndTheGrenadines\0"
"Samoa\0"
"SanMarino\0"
"SaoTomeAndPrincipe\0"
"SaudiArabia\0"
"Senegal\0"
"Seychelles\0"
"SierraLeone\0"
"Singapore\0"
"Slovakia\0"
"Slovenia\0"
"SolomonIslands\0"
"Somalia\0"
"SouthAfrica\0"
"SouthGeorgiaAndTheSouthSandwichIslands\0"
"Spain\0"
"SriLanka\0"
"StHelena\0"
"StPierreAndMiquelon\0"
"Sudan\0"
"Suriname\0"
"SvalbardAndJanMayenIslands\0"
"Swaziland\0"
"Sweden\0"
"Switzerland\0"
"SyrianArabRepublic\0"
"Taiwan\0"
"Tajikistan\0"
"Tanzania\0"
"Thailand\0"
"Togo\0"
"Tokelau\0"
"Tonga\0"
"TrinidadAndTobago\0"
"Tunisia\0"
"Turkey\0"
"Turkmenistan\0"
"TurksAndCaicosIslands\0"
"Tuvalu\0"
"Uganda\0"
"Ukraine\0"
"UnitedArabEmirates\0"
"UnitedKingdom\0"
"UnitedStates\0"
"UnitedStatesMinorOutlyingIslands\0"
"Uruguay\0"
"Uzbekistan\0"
"Vanuatu\0"
"VaticanCityState\0"
"Venezuela\0"
"VietNam\0"
"BritishVirginIslands\0"
"USVirginIslands\0"
"WallisAndFutunaIslands\0"
"WesternSahara\0"
"Yemen\0"
"Yugoslavia\0"
"Zambia\0"
"Zimbabwe\0"
"SerbiaAndMontenegro\0"
;

static const uint country_name_index[] = {
     0, // AnyCountry
     8, // Afghanistan
    20, // Albania
    28, // Algeria
    36, // AmericanSamoa
    50, // Andorra
    58, // Angola
    65, // Anguilla
    74, // Antarctica
    85, // AntiguaAndBarbuda
   103, // Argentina
   113, // Armenia
   121, // Aruba
   127, // Australia
   137, // Austria
   145, // Azerbaijan
   156, // Bahamas
   164, // Bahrain
   172, // Bangladesh
   183, // Barbados
   192, // Belarus
   200, // Belgium
   208, // Belize
   215, // Benin
   221, // Bermuda
   229, // Bhutan
   236, // Bolivia
   244, // BosniaAndHerzegowina
   265, // Botswana
   274, // BouvetIsland
   287, // Brazil
   294, // BritishIndianOceanTerritory
   322, // BruneiDarussalam
   339, // Bulgaria
   348, // BurkinaFaso
   360, // Burundi
   368, // Cambodia
   377, // Cameroon
   386, // Canada
   393, // CapeVerde
   403, // CaymanIslands
   417, // CentralAfricanRepublic
   440, // Chad
   445, // Chile
   451, // China
   457, // ChristmasIsland
   473, // CocosIslands
   486, // Colombia
   495, // Comoros
   503, // DemocraticRepublicOfCongo
   529, // PeoplesRepublicOfCongo
   552, // CookIslands
   564, // CostaRica
   574, // IvoryCoast
   585, // Croatia
   593, // Cuba
   598, // Cyprus
   605, // CzechRepublic
   619, // Denmark
   627, // Djibouti
   636, // Dominica
   645, // DominicanRepublic
   663, // EastTimor
   673, // Ecuador
   681, // Egypt
   687, // ElSalvador
   698, // EquatorialGuinea
   715, // Eritrea
   723, // Estonia
   731, // Ethiopia
   740, // FalklandIslands
   756, // FaroeIslands
   769, // Fiji
   774, // Finland
   782, // France
   789, // MetropolitanFrance
   808, // FrenchGuiana
   821, // FrenchPolynesia
   837, // FrenchSouthernTerritories
   863, // Gabon
   869, // Gambia
   876, // Georgia
   884, // Germany
   892, // Ghana
   898, // Gibraltar
   908, // Greece
   915, // Greenland
   925, // Grenada
   933, // Guadeloupe
   944, // Guam
   949, // Guatemala
   959, // Guinea
   966, // GuineaBissau
   979, // Guyana
   986, // Haiti
   992, // HeardAndMcDonaldIslands
  1016, // Honduras
  1025, // HongKong
  1034, // Hungary
  1042, // Iceland
  1050, // India
  1056, // Indonesia
  1066, // Iran
  1071, // Iraq
  1076, // Ireland
  1084, // Israel
  1091, // Italy
  1097, // Jamaica
  1105, // Japan
  1111, // Jordan
  1118, // Kazakhstan
  1129, // Kenya
  1135, // Kiribati
  1144, // DemocraticRepublicOfKorea
  1170, // RepublicOfKorea
  1186, // Kuwait
  1193, // Kyrgyzstan
  1204, // Lao
  1208, // Latvia
  1215, // Lebanon
  1223, // Lesotho
  1231, // Liberia
  1239, // LibyanArabJamahiriya
  1260, // Liechtenstein
  1274, // Lithuania
  1284, // Luxembourg
  1295, // Macau
  1301, // Macedonia
  1311, // Madagascar
  1322, // Malawi
  1329, // Malaysia
  1338, // Maldives
  1347, // Mali
  1352, // Malta
  1358, // MarshallIslands
  1374, // Martinique
  1385, // Mauritania
  1396, // Mauritius
  1406, // Mayotte
  1414, // Mexico
  1421, // Micronesia
  1432, // Moldova
  1440, // Monaco
  1447, // Mongolia
  1456, // Montserrat
  1467, // Morocco
  1475, // Mozambique
  1486, // Myanmar
  1494, // Namibia
  1502, // Nauru
  1508, // Nepal
  1514, // Netherlands
  1526, // NetherlandsAntilles
  1546, // NewCaledonia
  1559, // NewZealand
  1570, // Nicaragua
  1580, // Niger
  1586, // Nigeria
  1594, // Niue
  1599, // NorfolkIsland
  1613, // NorthernMarianaIslands
  1636, // Norway
  1643, // Oman
  1648, // Pakistan
  1657, // Palau
  1663, // PalestinianTerritory
  1684, // Panama
  1691, // PapuaNewGuinea
  1706, // Paraguay
  1715, // Peru
  1720, // Philippines
  1732, // Pitcairn
  1741, // Poland
  1748, // Portugal
  1757, // PuertoRico
  1768, // Qatar
  1774, // Reunion
  1782, // Romania
  1790, // RussianFederation
  1808, // Rwanda
  1815, // SaintKittsAndNevis
  1834, // StLucia
  1842, // StVincentAndTheGrenadines
  1868, // Samoa
  1874, // SanMarino
  1884, // SaoTomeAndPrincipe
  1903, // SaudiArabia
  1915, // Senegal
  1923, // Seychelles
  1934, // SierraLeone
  1946, // Singapore
  1956, // Slovakia
  1965, // Slovenia
  1974, // SolomonIslands
  1989, // Somalia
  1997, // SouthAfrica
  2009, // SouthGeorgiaAndTheSouthSandwichIslands
  2048, // Spain
  2054, // SriLanka
  2063, // StHelena
  2072, // StPierreAndMiquelon
  2092, // Sudan
  2098, // Suriname
  2107, // SvalbardAndJanMayenIslands
  2134, // Swaziland
  2144, // Sweden
  2151, // Switzerland
  2163, // SyrianArabRepublic
  2182, // Taiwan
  2189, // Tajikistan
  2200, // Tanzania
  2209, // Thailand
  2218, // Togo
  2223, // Tokelau
  2231, // Tonga
  2237, // TrinidadAndTobago
  2255, // Tunisia
  2263, // Turkey
  2270, // Turkmenistan
  2283, // TurksAndCaicosIslands
  2305, // Tuvalu
  2312, // Uganda
  2319, // Ukraine
  2327, // UnitedArabEmirates
  2346, // UnitedKingdom
  2360, // UnitedStates
  2373, // UnitedStatesMinorOutlyingIslands
  2406, // Uruguay
  2414, // Uzbekistan
  2425, // Vanuatu
  2433, // VaticanCityState
  2450, // Venezuela
  2460, // VietNam
  2468, // BritishVirginIslands
  2489, // USVirginIslands
  2505, // WallisAndFutunaIslands
  2528, // WesternSahara
  2542, // Yemen
  2548, // Yugoslavia
  2559, // Zambia
  2566, // Zimbabwe
  2575, // SerbiaAndMontenegro
};

static const unsigned char language_code_list[] =
"  \0" // Unused
"  \0" // C
"ab\0" // Abkhazian
"om\0" // Afan
"aa\0" // Afar
"af\0" // Afrikaans
"sq\0" // Albanian
"am\0" // Amharic
"ar\0" // Arabic
"hy\0" // Armenian
"as\0" // Assamese
"ay\0" // Aymara
"az\0" // Azerbaijani
"ba\0" // Bashkir
"eu\0" // Basque
"bn\0" // Bengali
"dz\0" // Bhutani
"bh\0" // Bihari
"bi\0" // Bislama
"br\0" // Breton
"bg\0" // Bulgarian
"my\0" // Burmese
"be\0" // Byelorussian
"km\0" // Cambodian
"ca\0" // Catalan
"zh\0" // Chinese
"co\0" // Corsican
"hr\0" // Croatian
"cs\0" // Czech
"da\0" // Danish
"nl\0" // Dutch
"en\0" // English
"eo\0" // Esperanto
"et\0" // Estonian
"fo\0" // Faroese
"fj\0" // Fiji
"fi\0" // Finnish
"fr\0" // French
"fy\0" // Frisian
"gd\0" // Gaelic
"gl\0" // Galician
"ka\0" // Georgian
"de\0" // German
"el\0" // Greek
"kl\0" // Greenlandic
"gn\0" // Guarani
"gu\0" // Gujarati
"ha\0" // Hausa
"he\0" // Hebrew
"hi\0" // Hindi
"hu\0" // Hungarian
"is\0" // Icelandic
"id\0" // Indonesian
"ia\0" // Interlingua
"ie\0" // Interlingue
"iu\0" // Inuktitut
"ik\0" // Inupiak
"ga\0" // Irish
"it\0" // Italian
"ja\0" // Japanese
"jv\0" // Javanese
"kn\0" // Kannada
"ks\0" // Kashmiri
"kk\0" // Kazakh
"rw\0" // Kinyarwanda
"ky\0" // Kirghiz
"ko\0" // Korean
"ku\0" // Kurdish
"rn\0" // Kurundi
"lo\0" // Laothian
"la\0" // Latin
"lv\0" // Latvian
"ln\0" // Lingala
"lt\0" // Lithuanian
"mk\0" // Macedonian
"mg\0" // Malagasy
"ms\0" // Malay
"ml\0" // Malayalam
"mt\0" // Maltese
"mi\0" // Maori
"mr\0" // Marathi
"mo\0" // Moldavian
"mn\0" // Mongolian
"na\0" // Nauru
"ne\0" // Nepali
"nb\0" // Norwegian
"oc\0" // Occitan
"or\0" // Oriya
"ps\0" // Pashto
"fa\0" // Persian
"pl\0" // Polish
"pt\0" // Portuguese
"pa\0" // Punjabi
"qu\0" // Quechua
"rm\0" // RhaetoRomance
"ro\0" // Romanian
"ru\0" // Russian
"sm\0" // Samoan
"sg\0" // Sangho
"sa\0" // Sanskrit
"sr\0" // Serbian
"sh\0" // SerboCroatian
"st\0" // Sesotho
"tn\0" // Setswana
"sn\0" // Shona
"sd\0" // Sindhi
"si\0" // Singhalese
"ss\0" // Siswati
"sk\0" // Slovak
"sl\0" // Slovenian
"so\0" // Somali
"es\0" // Spanish
"su\0" // Sundanese
"sw\0" // Swahili
"sv\0" // Swedish
"tl\0" // Tagalog
"tg\0" // Tajik
"ta\0" // Tamil
"tt\0" // Tatar
"te\0" // Telugu
"th\0" // Thai
"bo\0" // Tibetan
"ti\0" // Tigrinya
"to\0" // Tonga
"ts\0" // Tsonga
"tr\0" // Turkish
"tk\0" // Turkmen
"tw\0" // Twi
"ug\0" // Uigur
"uk\0" // Ukrainian
"ur\0" // Urdu
"uz\0" // Uzbek
"vi\0" // Vietnamese
"vo\0" // Volapuk
"cy\0" // Welsh
"wo\0" // Wolof
"xh\0" // Xhosa
"yi\0" // Yiddish
"yo\0" // Yoruba
"za\0" // Zhuang
"zu\0" // Zulu
"nn\0" // Nynorsk
"bs\0" // Bosnian
"dv\0" // Divehi
"gv\0" // Manx
"kw\0" // Cornish
"ak\0" // Akan
"kok" // Konkani
"gaa" // Ga
"ig\0" // Igbo
"kam" // Kamba
"syr" // Syriac
"byn" // Blin
"gez" // Geez
"kfo" // Koro
"sid" // Sidamo
"cch" // Atsam
"tig" // Tigre
"kaj" // Jju
"fur" // Friulian
"ve\0" // Venda
"ee\0" // Ewe
"wa\0" // Walamo
"haw" // Hawaiian
"kcg" // Tyap
"ny\0" // Chewa
;

static const unsigned char country_code_list[] =
"  " // AnyCountry
"AF" // Afghanistan
"AL" // Albania
"DZ" // Algeria
"AS" // AmericanSamoa
"AD" // Andorra
"AO" // Angola
"AI" // Anguilla
"AQ" // Antarctica
"AG" // AntiguaAndBarbuda
"AR" // Argentina
"AM" // Armenia
"AW" // Aruba
"AU" // Australia
"AT" // Austria
"AZ" // Azerbaijan
"BS" // Bahamas
"BH" // Bahrain
"BD" // Bangladesh
"BB" // Barbados
"BY" // Belarus
"BE" // Belgium
"BZ" // Belize
"BJ" // Benin
"BM" // Bermuda
"BT" // Bhutan
"BO" // Bolivia
"BA" // BosniaAndHerzegowina
"BW" // Botswana
"BV" // BouvetIsland
"BR" // Brazil
"IO" // BritishIndianOceanTerritory
"BN" // BruneiDarussalam
"BG" // Bulgaria
"BF" // BurkinaFaso
"BI" // Burundi
"KH" // Cambodia
"CM" // Cameroon
"CA" // Canada
"CV" // CapeVerde
"KY" // CaymanIslands
"CF" // CentralAfricanRepublic
"TD" // Chad
"CL" // Chile
"CN" // China
"CX" // ChristmasIsland
"CC" // CocosIslands
"CO" // Colombia
"KM" // Comoros
"CD" // DemocraticRepublicOfCongo
"CG" // PeoplesRepublicOfCongo
"CK" // CookIslands
"CR" // CostaRica
"CI" // IvoryCoast
"HR" // Croatia
"CU" // Cuba
"CY" // Cyprus
"CZ" // CzechRepublic
"DK" // Denmark
"DJ" // Djibouti
"DM" // Dominica
"DO" // DominicanRepublic
"TL" // EastTimor
"EC" // Ecuador
"EG" // Egypt
"SV" // ElSalvador
"GQ" // EquatorialGuinea
"ER" // Eritrea
"EE" // Estonia
"ET" // Ethiopia
"FK" // FalklandIslands
"FO" // FaroeIslands
"FJ" // Fiji
"FI" // Finland
"FR" // France
"FX" // MetropolitanFrance
"GF" // FrenchGuiana
"PF" // FrenchPolynesia
"TF" // FrenchSouthernTerritories
"GA" // Gabon
"GM" // Gambia
"GE" // Georgia
"DE" // Germany
"GH" // Ghana
"GI" // Gibraltar
"GR" // Greece
"GL" // Greenland
"GD" // Grenada
"GP" // Guadeloupe
"GU" // Guam
"GT" // Guatemala
"GN" // Guinea
"GW" // GuineaBissau
"GY" // Guyana
"HT" // Haiti
"HM" // HeardAndMcDonaldIslands
"HN" // Honduras
"HK" // HongKong
"HU" // Hungary
"IS" // Iceland
"IN" // India
"ID" // Indonesia
"IR" // Iran
"IQ" // Iraq
"IE" // Ireland
"IL" // Israel
"IT" // Italy
"JM" // Jamaica
"JP" // Japan
"JO" // Jordan
"KZ" // Kazakhstan
"KE" // Kenya
"KI" // Kiribati
"KP" // DemocraticRepublicOfKorea
"KR" // RepublicOfKorea
"KW" // Kuwait
"KG" // Kyrgyzstan
"LA" // Lao
"LV" // Latvia
"LB" // Lebanon
"LS" // Lesotho
"LR" // Liberia
"LY" // LibyanArabJamahiriya
"LI" // Liechtenstein
"LT" // Lithuania
"LU" // Luxembourg
"MO" // Macau
"MK" // Macedonia
"MG" // Madagascar
"MW" // Malawi
"MY" // Malaysia
"MV" // Maldives
"ML" // Mali
"MT" // Malta
"MH" // MarshallIslands
"MQ" // Martinique
"MR" // Mauritania
"MU" // Mauritius
"YT" // Mayotte
"MX" // Mexico
"FM" // Micronesia
"MD" // Moldova
"MC" // Monaco
"MN" // Mongolia
"MS" // Montserrat
"MA" // Morocco
"MZ" // Mozambique
"MM" // Myanmar
"NA" // Namibia
"NR" // Nauru
"NP" // Nepal
"NL" // Netherlands
"AN" // NetherlandsAntilles
"NC" // NewCaledonia
"NZ" // NewZealand
"NI" // Nicaragua
"NE" // Niger
"NG" // Nigeria
"NU" // Niue
"NF" // NorfolkIsland
"MP" // NorthernMarianaIslands
"NO" // Norway
"OM" // Oman
"PK" // Pakistan
"PW" // Palau
"PS" // PalestinianTerritory
"PA" // Panama
"PG" // PapuaNewGuinea
"PY" // Paraguay
"PE" // Peru
"PH" // Philippines
"PN" // Pitcairn
"PL" // Poland
"PT" // Portugal
"PR" // PuertoRico
"QA" // Qatar
"RE" // Reunion
"RO" // Romania
"RU" // RussianFederation
"RW" // Rwanda
"KN" // SaintKittsAndNevis
"LC" // StLucia
"VC" // StVincentAndTheGrenadines
"WS" // Samoa
"SM" // SanMarino
"ST" // SaoTomeAndPrincipe
"SA" // SaudiArabia
"SN" // Senegal
"SC" // Seychelles
"SL" // SierraLeone
"SG" // Singapore
"SK" // Slovakia
"SI" // Slovenia
"SB" // SolomonIslands
"SO" // Somalia
"ZA" // SouthAfrica
"GS" // SouthGeorgiaAndTheSouthSandwichIslands
"ES" // Spain
"LK" // SriLanka
"SH" // StHelena
"PM" // StPierreAndMiquelon
"SD" // Sudan
"SR" // Suriname
"SJ" // SvalbardAndJanMayenIslands
"SZ" // Swaziland
"SE" // Sweden
"CH" // Switzerland
"SY" // SyrianArabRepublic
"TW" // Taiwan
"TJ" // Tajikistan
"TZ" // Tanzania
"TH" // Thailand
"TG" // Togo
"TK" // Tokelau
"TO" // Tonga
"TT" // TrinidadAndTobago
"TN" // Tunisia
"TR" // Turkey
"TM" // Turkmenistan
"TC" // TurksAndCaicosIslands
"TV" // Tuvalu
"UG" // Uganda
"UA" // Ukraine
"AE" // UnitedArabEmirates
"GB" // UnitedKingdom
"US" // UnitedStates
"UM" // UnitedStatesMinorOutlyingIslands
"UY" // Uruguay
"UZ" // Uzbekistan
"VU" // Vanuatu
"VA" // VaticanCityState
"VE" // Venezuela
"VN" // VietNam
"VG" // BritishVirginIslands
"VI" // USVirginIslands
"WF" // WallisAndFutunaIslands
"EH" // WesternSahara
"YE" // Yemen
"YU" // Yugoslavia
"ZM" // Zambia
"ZW" // Zimbabwe
"CS" // SerbiaAndMontenegro
;

QT_END_NAMESPACE

#endif
