/*
 * This file is part of the DOM implementation for KDE.
 *
 * Copyright (C) 2003 Lars Knoll (knoll@kde.org)
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

/* This file is mostly data generated by flex. Unfortunately flex
   can't handle 16bit strings directly, so we just copy the part of
   the code we need and modify it to our needs.

   Most of the defines below are to make sure we can easily use the
   flex generated code, using as little editing as possible.

   The flex syntax to generate the lexer are more or less directly
   copied from the CSS2.1 specs, with some fixes for comments and
   the important symbol.

   To regenerate, run flex on tokenizer.flex. After this, copy the
   data tables and the YY_DECL method over to this file. Remove the
   init code from YY_DECL and change the YY_END_OF_BUFFER to only call
   yyterminate().

*/

// --------- begin generated code -------------------


#include "CSSGrammar.h"

#define INITIAL 0
#define mediaquery 1
#define forkeyword 2

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L
#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t;
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */
#define YY_NUM_RULES 67
#define YY_END_OF_BUFFER 68
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[475] =
    {   0,
        0,    0,    0,    0,    0,    0,   68,   66,    2,    2,
       66,   66,   66,   66,   66,   66,   66,   66,   66,   55,
       66,   66,   15,   15,   15,   66,   66,   66,   66,   65,
       15,   15,   15,   64,   15,    2,    0,    0,    0,   14,
        0,    0,    0,   18,   18,    0,    8,    0,    0,    9,
        0,    0,   15,   15,   15,    0,   56,    0,   54,    0,
        0,   55,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   16,   53,   53,   50,    0,   53,    0,    0,   35,
       35,   35,   35,   35,   35,   35,    0,   61,   15,    0,
        0,   15,   15,    0,   15,   15,   15,    7,    6,    5,

       15,   15,   15,   15,    0,    0,    0,   14,    0,    0,
        0,   18,   18,    0,   18,   18,    0,    0,   14,    0,
        0,    4,   16,   15,    0,    0,   53,    0,   41,   53,
       37,   39,   53,   51,   43,   53,   42,   49,   53,   45,
       44,   40,   53,   53,   53,   53,    0,   35,   35,    0,
       35,   35,   35,   35,   35,   35,   35,   35,   15,   15,
       16,   15,   15,   62,   62,   15,   15,   12,   10,   15,
       13,    0,    0,    0,   17,   17,   18,   18,   18,    0,
        0,   15,    0,    1,   53,   53,   46,   53,   52,   16,
       47,   53,   53,    3,   35,   35,   35,   35,   35,   35,

       35,   35,   35,   35,   15,   57,    0,   62,   62,   62,
       61,   15,   11,    0,    0,    0,   18,   18,   18,    0,
       15,    0,    0,   53,   48,   53,   53,   35,   35,   35,
       35,   35,   35,   35,   20,   35,   15,   63,   62,   62,
       62,   62,    0,    0,    0,    0,   59,    0,   15,    0,
        0,    0,   18,   18,   18,    0,   15,   53,   53,   38,
       35,   35,   35,   35,   35,   21,   35,   35,   15,   63,
       62,   62,   62,   62,   62,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   59,    0,    0,   15,    0,    0,
       17,   17,   18,   18,    0,   15,   53,   53,   35,   35,

       35,   35,   19,   35,   35,   15,   63,   62,   62,   62,
       62,   62,   62,    0,   58,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,   15,    0,    0,   18,
       18,    0,   15,   53,   53,   35,   35,   23,   35,   35,
       35,   15,   63,   62,   62,   62,   62,   62,   62,   62,
        0,   58,    0,    0,    0,   58,    0,    0,    0,    0,
       18,   15,   53,   35,   35,   35,   35,   63,    0,    0,
        0,   36,   15,   35,   35,   35,   35,   35,   35,   22,
       24,   63,    0,    0,    0,   15,   35,   35,   35,   35,
       35,   35,    0,    0,    0,   61,   35,   35,   35,   35,

       35,   35,   35,   35,    0,    0,    0,    0,    0,    0,
       35,   35,   35,   35,   25,   35,   35,   35,    0,   60,
        0,    0,    0,    0,   26,   35,   35,   35,   35,   27,
       35,    0,    0,    0,    0,   31,   35,   35,   35,   35,
        0,    0,    0,   35,   35,   35,   35,    0,    0,   35,
       35,   29,   35,    0,    0,   35,   33,   35,   30,    0,
        0,   35,   28,   35,    0,   35,   35,   35,   35,   34,
       35,   35,   32,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    4,    5,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    6,    7,    8,    9,   10,   11,   12,   13,   14,
       15,   16,   17,   12,   18,   19,   20,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   12,   22,   23,
       24,   25,   26,   27,   28,   29,   30,   31,   32,   33,
       34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
       44,   45,   46,   47,   48,   49,   50,   51,   52,   53,
       12,   54,   12,   55,   56,   12,   57,   58,   59,   60,

       61,   62,   63,   64,   65,   37,   66,   67,   68,   69,
       70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
       80,   81,   82,   83,   12,   84,    1,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,

       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85
    } ;

static yyconst flex_int32_t yy_meta[86] =
    {   0,
        1,    2,    3,    4,    4,    5,    6,    7,    6,    6,
        6,    6,    7,    8,    9,    6,    6,   10,    6,    6,
       11,    6,    6,    6,    6,   12,    6,   13,   13,   13,
       13,   13,   13,   14,   14,   14,   14,   14,   14,   14,
       14,   14,   14,   14,   14,   14,   14,   14,   14,   14,
       14,   14,   14,   14,    6,   14,   13,   13,   13,   13,
       13,   13,   14,   14,   14,   14,   14,   14,   14,   14,
       14,   14,   14,   14,   14,   14,   14,   14,   14,   14,
       14,    6,    6,    6,   14
    } ;

static yyconst flex_int16_t yy_base[546] =
    {   0,
        0,    0,   64,   66,   54,   56, 1462, 6578,   93,   98,
      107,   83,  155, 1437,   77, 1416,   99, 1416, 1412,  207,
     1420,  275,  100,  108,  125,  326, 1401, 1382, 1375, 6578,
      141,  110,  151, 6578,  105,  197,  295,   89,  107, 6578,
      387,  120,    0,  429, 1315,  471, 6578,  117,  532, 6578,
     1326,  269,  137,  176,  281,  574,  283, 1325, 1327, 1282,
     1314,    0, 1268,  249,  135,  282,  276,  153,   91,  169,
      299,  308,  318,  266, 1267,  616,  102, 1285,  346, 1246,
      316,  127,  358,  349,  347,  348,  658, 6578,  208,  700,
     1276,  357,  352, 1253,  368,  314,  761, 6578, 6578, 6578,

      409,  418,  399,  422,  248,  371,  355,  420,  822,  883,
        0, 1224,  925,  967, 1210, 1028,  401,  426,  430, 1089,
     1150, 6578,  214,  423, 1244,  414, 1192, 1192, 1188,  278,
     1187, 1146,  414, 1139, 1135,  425, 1115, 1112,  400, 1111,
     1087, 1080,  451, 1054, 1253,  453, 1089,  462, 1050, 1295,
      470,  472,  467,  454,  500,  485, 1047, 1356,  442, 1417,
     1053,  501,  495,  193, 1047,  498, 1459,  503,  504,  528,
      529,  502,  512, 1520,    0, 1562, 1014, 1623, 1684,  543,
     1745,  533, 1051, 6578,  996, 1806,  955,  519,  935,  410,
      923, 1848,  527, 6578,  555,  913, 1909,  556,  523,  558,

      531,  589,  598, 1951, 2012, 6578,    0,  203,  924,  908,
      612, 2054,  597,  581, 2115,    0, 2157, 2218, 2279, 2340,
      627,  917,  558, 2401,  874, 2443,  599,  602, 2504,  611,
      601,  626,  641,  648,  856, 2546, 2607,    0,  288,  868,
      867,  864,  732,  793,  568,  610, 6578, 2668, 2710,  595,
     2771,    0, 2813, 2874, 2935, 2996, 3057, 3131, 3173, 3234,
      646, 3295,  651,  639,  649,  835,  654, 3337, 3398,    0,
      688,  841,  822,  819,  788,  766,  630,  829, 3459,  694,
     3520,  854,  894,  915,  920, 3581, 3642, 3684,  682, 3745,
     6578,  753, 3806, 3867, 3928, 3989, 4050, 4111,  699, 4172,

      702,  698,  734,  722, 4214, 4275,    0,  725,  747,  715,
      683,  549,  543,  834, 6578,  650,  775,  957, 4336, 4397,
      700,  926,  988, 4458, 4519, 4580,  859,  743, 1010, 4622,
     4664, 1042,  793, 4706, 4767,  606, 4828,  497,  750,  787,
     1017, 1033,    0,  452, 6578, 6578, 6578, 6578, 6578, 6578,
     1121,  898,  924, 4870, 1182,  963, 1049, 4912, 4973,  738,
      869,  850, 1002, 5005, 1074, 1009, 1011,    0, 5062, 5104,
     5146, 6578, 1036, 1021, 1051, 1052, 1083, 1079,  838,  397,
      340, 6578, 5188, 5230, 5272,  709, 1102,  851,  756,  897,
     1091, 1123, 5314, 5356, 1212, 1226, 1103, 1137,  948, 1138,

     1106, 1140, 1185, 1183, 1265, 1285, 1290, 1327, 1388, 5398,
     1152, 1193, 1264, 1012,  273, 1085, 1211, 1247, 1361, 6578,
     1428, 5440, 1449, 5501,  242, 1245, 1248, 1191, 1293,  173,
     1288, 1454, 5562, 1491, 5604,  170, 1280, 1295, 1328, 1341,
     1531, 5646, 5688, 1318, 1343, 1329, 1346, 5730, 5772, 1355,
     1351,  154, 1427, 5814, 5856, 1390,  112,  895,  884, 5898,
     1552, 1451,  109, 1145, 1557, 1372, 1453, 1477, 1382,   90,
     1444, 1456,   39, 6578, 5959, 5964, 5977, 5982, 5987, 5994,
     6004, 6017,  296, 6022, 6032, 6045, 6059,  648, 6064, 6074,
     6079, 6089, 6099, 6103,  462, 6112, 6125, 6138, 6152, 6166,

     6176, 6186, 6191, 6203,  731, 6217,  789, 6222, 6234, 6247,
      792, 6261,  957, 6266, 6278, 6291, 6304, 6317, 6330,  960,
     6335, 6348, 1086, 6353, 6365, 6378, 6391, 6404, 6417, 6430,
     6435, 6448, 1087, 6453, 6465, 6478, 6491, 6504, 6517, 1103,
     1227, 6530, 6543, 6553, 6563
    } ;

static yyconst flex_int16_t yy_def[546] =
    {   0,
      474,    1,    1,    1,    1,    1,  474,  474,  474,  474,
      474,  475,  476,  474,  477,  474,  478,  474,  474,  474,
      474,  479,  480,  480,  480,  481,  474,  474,  474,  474,
      480,  480,  480,  474,  480,  474,  474,  474,  475,  474,
      482,  476,  483,  484,  484,  485,  474,  477,  486,  474,
      474,  474,  480,  480,  480,  481,   20,  487,  474,  488,
      474,   20,  489,  489,  489,  489,  489,  489,  489,  489,
      489,  489,  489,  489,  489,  490,  489,  474,  479,  491,
      491,  491,  491,  491,  491,  491,  492,  474,  480,  493,
      474,  480,  480,  494,  480,  480,  480,  474,  474,  474,

      480,  480,  480,  480,  474,  475,  475,  475,  475,  482,
      495,  484,  484,  496,  484,  113,  497,  497,  497,  497,
      498,  474,  474,  480,  499,  500,  489,  501,  489,  489,
      489,  489,  489,  489,  489,  489,  489,  489,  489,  489,
      489,  489,  489,  489,  489,  489,  474,  491,  491,  502,
      491,  491,  491,  491,  491,  491,  491,  491,  480,   97,
      474,  480,  480,  503,  474,  480,   97,  480,  480,  480,
      480,  474,  504,  504,  505,  113,  484,  113,  113,  497,
      497,  480,  506,  474,  489,  145,  489,  489,  489,  489,
      489,  145,  489,  474,  491,  491,  158,  491,  491,  491,

      491,  491,  491,  158,   97,  474,  507,  508,  474,  474,
      509,   97,  480,  474,  510,  511,  113,  113,  113,  497,
      480,  506,  512,  145,  489,  145,  489,  491,  158,  491,
      491,  491,  491,  491,  491,  158,   97,  513,  514,  474,
      474,  474,  515,  515,  516,  517,  474,  518,   97,  474,
      519,  520,  521,  521,  254,  522,   97,  145,  145,  145,
      491,  158,  491,  491,  491,  491,  491,  158,   97,  523,
      524,  474,  474,  474,  474,  474,  516,  474,  525,  526,
      527,  528,  528,  528,  528,  528,  529,   97,  474,  530,
      474,  531,  531,  293,  532,   97,  145,  297,  491,  158,

      491,  491,  491,  491,  158,   97,  533,  534,  474,  474,
      474,  474,  474,  474,  474,  535,  535,  535,  535,  536,
      537,  537,  537,  537,  538,  539,  296,  474,  530,  293,
      294,  532,  296,  297,  297,  491,  158,  491,  491,  491,
      491,  296,  540,  474,  474,  474,  474,  474,  474,  474,
      535,  535,  535,  319,  537,  537,  537,  324,  539,  474,
      331,  296,  335,  491,  491,  491,  491,  541,  319,  324,
      359,  474,  296,  491,  491,  491,  491,  491,  491,  491,
      491,  474,  319,  324,  359,  296,  491,  491,  491,  491,
      491,  491,  319,  324,  539,  542,  491,  491,  491,  491,

      491,  491,  491,  491,  535,  537,  542,  542,  543,  544,
      491,  491,  491,  491,  491,  491,  491,  491,  474,  474,
      543,  545,  543,  543,  491,  491,  491,  491,  491,  491,
      491,  543,  424,  543,  424,  491,  491,  491,  491,  491,
      543,  433,  424,  491,  491,  491,  491,  433,  424,  491,
      491,  491,  491,  433,  424,  491,  491,  491,  491,  433,
      543,  491,  491,  491,  543,  491,  491,  491,  491,  491,
      491,  491,  491,    0,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,

      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474
    } ;

static yyconst flex_int16_t yy_nxt[6664] =
    {   0,
        8,    9,   10,    9,    9,    9,   11,   12,   13,   14,
        8,    8,   15,    8,    8,   16,    8,   17,   18,   19,
       20,    8,   21,    8,    8,    8,   22,   23,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
       24,   23,   23,   23,   23,   23,   23,   25,   23,   23,
       23,   23,   23,   26,   27,   23,   23,   23,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   24,   23,
       23,   23,   23,   23,   23,   25,   23,   23,   23,   23,
       23,    8,   28,   29,   23,   30,   35,   30,   35,   40,
       40,   31,  150,   31,   36,   36,   36,   36,   36,   36,

       36,   36,   36,   36,   32,   33,   32,   33,   37,   37,
       37,   37,   37,   88,   40,   35,   51,   35,   88,   52,
       31,   88,   31,   88,   91,   92,   91,   92,  105,   40,
       49,  135,   32,   33,   32,   33,   41,  474,   88,   54,
      474,   94,   38,  150,  128,   34,  104,   34,   55,   93,
       88,  102,   56,   90,   88,  128,  105,  146,   90,  135,
       41,   90,  150,   90,   88,  150,  130,   54,  152,   95,
       49,   38,   42,   46,  104,   43,   55,   93,   90,  102,
      150,  101,   44,   44,   44,   44,   44,   44,  128,   88,
       90,  103,   91,   92,   90,  130,  152,   95,   36,   36,

       36,   36,   36,  136,   90,  134,  128,  150,   46,  101,
      207,   44,   44,   44,   44,   44,   44,   59,  209,  103,
      207,   88,  128,  150,   60,   61,  150,   62,  240,   90,
       91,   91,  136,  134,   63,   63,   64,   65,   66,   63,
       67,   68,   69,   63,   70,   63,   71,   72,   63,   73,
       63,   74,   75,   63,   63,   63,   63,   63,   63,   63,
       76,   90,   77,   63,   63,   64,   65,   66,   63,   67,
       68,   69,   70,   63,   71,   72,   63,   73,   63,   74,
       75,   63,   63,   63,   63,   63,   63,   63,  129,   52,
      172,   63,   79,  143,   88,  150,   37,   37,   37,   37,

       37,  474,  128,   57,   81,  207,  111,   82,  111,  123,
       83,  187,  124,  272,   84,   85,  129,   86,  172,  128,
      133,  131,  143,   63,   91,  139,  150,   88,   87,  128,
       38,  128,  132,   81,   90,  128,   82,  123,  137,   83,
      187,  124,   84,   85,  138,   86,   97,  140,  133,  131,
      151,   63,  128,   97,   97,   97,   97,   97,   97,   38,
      132,  128,   40,  474,  141,   88,  137,   90,  142,  150,
       88,  128,  138,   39,  155,  156,  140,  162,   40,  151,
      154,   88,   97,   97,   97,   97,   97,   97,   39,   39,
       39,  106,  141,  150,  108,  148,  142,  153,  163,   87,

      150,  150,  150,  155,  156,   90,  166,  109,   41,  154,
       90,  150,   88,   40,  109,  109,  109,  109,  109,  109,
      190,   90,   88,  148,   41,  153,  163,   40,  474,  126,
      190,   88,  474,  184,  166,   88,   88,  170,   40,  168,
      110,  188,   40,  109,  109,  109,  109,  109,  109,  113,
      150,  182,   90,  128,   49,   88,  113,  113,  113,  113,
      113,  113,   90,  128,  169,  170,  171,  128,  168,  207,
      188,   90,  175,   41,  175,   90,   90,  189,  128,   49,
      182,  191,  114,   49,  201,  113,  113,  113,  113,  113,
      113,  116,  169,  195,  171,   90,  193,  198,  116,  116,

      116,  116,  116,  116,  128,  189,  128,  150,  206,  200,
      191,  211,  199,  201,   88,  150,   88,  206,  203,   40,
      150,  162,  195,  150,  193,  150,  198,  116,  116,  116,
      116,  116,  116,   48,   48,   48,  117,  200,  150,  202,
      199,   88,   88,  214,  119,  474,   88,  203,   90,  225,
      150,   90,  120,  150,   90,   40,   90,   90,  227,  120,
      120,  120,  120,  120,  120,   41,  233,  202,  350,  231,
      221,  214,  128,  223,  349,  278,  150,  184,  225,  213,
      128,   90,   90,  228,  150,  121,   90,  227,  120,  120,
      120,  120,  120,  120,   97,  233,   49,  231,  221,  232,

      230,   97,   97,   97,   97,   97,   97,  213,  150,  150,
       88,  150,  228,  243,  243,  243,  243,  243,  264,  245,
      234,  279,  278,  364,  246,  250,  247,  232,  230,  235,
       97,   97,   97,   97,   97,   97,  145,  278,  260,  261,
       88,  289,  150,  145,  145,  145,  145,  145,  145,  234,
       90,  150,  128,  250,  150,  150,  263,  278,  235,  150,
       63,   63,  257,  281,  150,  248,  260,  261,  266,  289,
      265,  302,  145,  145,  145,  145,  145,  145,  158,  150,
       90,  299,  301,  279,  263,  158,  158,  158,  158,  158,
      158,  257,  150,  267,  150,  303,  304,  266,  265,  150,

      302,  150,  150,  279,  150,  207,  278,  150,  348,  328,
      299,  301,  278,  309,  158,  158,  158,  158,  158,  158,
      160,  267,  396,  303,  304,  339,   89,  160,  160,  160,
      160,  160,  160,  243,  243,  243,  243,  243,  328,  245,
      347,  216,  207,  216,  246,  336,  247,  281,  338,  340,
      345,  150,  150,  281,  339,  150,  160,  160,  160,  160,
      160,  160,   96,   96,   96,   96,   96,  276,  276,  276,
      276,  276,  346,  336,   88,  150,  338,  474,  340,  366,
      247,  167,  278,  360,  372,  248,  400,  150,  167,  167,
      167,  167,  167,  167,  276,  276,  276,  276,  276,  238,

      474,  238,  252,  150,  252,  474,  114,  247,  366,  150,
       89,  360,  372,  313,   90,  400,  367,  167,  167,  167,
      167,  167,  167,  107,  173,  173,  173,  107,  279,   40,
      314,  314,  314,  314,  314,  314,  314,  314,  314,  314,
      150,  362,  174,  315,  312,  367,  248,  311,  315,  174,
      174,  174,  174,  174,  174,  276,  276,  276,  276,  276,
       96,   96,   96,   96,   96,  392,  310,   89,  247,  362,
      177,  177,  177,  177,  177,   41,   89,  373,  174,  174,
      174,  174,  174,  174,   39,   39,   39,  106,  150,  275,
      108,  150,  274,  273,  392,  276,  276,  276,  276,  276,

      474,  464,  399,  109,  150,  278,  373,  248,  247,  150,
      109,  109,  109,  109,  109,  109,  276,  276,  276,  276,
      276,  276,  276,  276,  276,  276,  474,  128,  474,  247,
      399,  278,  223,  242,  247,  401,  110,  150,  278,  109,
      109,  109,  109,  109,  109,  176,  463,  248,  150,  241,
      150,  279,  176,  176,  176,  176,  176,  176,  351,  314,
      314,  314,  351,  401,  278,  474,  150,  270,  248,  270,
      291,  352,  291,  248,  463,  278,  128,  279,  114,  281,
      413,  176,  176,  176,  176,  176,  176,  178,  128,  355,
      314,  314,  314,  355,  178,  178,  178,  178,  178,  178,

      278,  150,  356,  185,  185,  185,  185,  185,  128,  413,
      279,  107,  173,  173,  173,  107,  281,   40,  157,  157,
      157,  157,  157,  178,  178,  178,  178,  178,  178,  115,
      115,  115,  115,  115,  159,  159,  159,  159,  159,  428,
      380,  281,  381,  118,  180,  180,  180,  118,  179,  128,
       89,  474,  387,   89,   40,  179,  179,  179,  179,  179,
      179,  278,  150,   41,  150,  150,  223,  114,  428,  380,
      150,  381,  210,  161,  150,  196,  196,  196,  196,  196,
      386,  387,  388,  389,  179,  179,  179,  179,  179,  179,
      118,  180,  180,  180,  118,   49,  307,  343,  307,  343,

      150,   40,  281,  150,  150,  150,  194,  128,  386,  181,
      391,  388,  389,  368,  429,  368,  181,  181,  181,  181,
      181,  181,  351,  314,  314,  314,  351,  150,  278,  402,
      390,  397,  150,  128,  398,  352,  150,  415,  150,  391,
      128,  411,   49,  429,  150,  181,  181,  181,  181,  181,
      181,   48,   48,   48,  117,  150,  150,  402,  390,  150,
      397,  403,  119,  398,  128,  128,  415,  404,  128,  411,
      120,  416,  412,  414,  279,  467,  150,  120,  120,  120,
      120,  120,  120,  355,  314,  314,  314,  355,  128,  403,
      150,  150,  128,  150,  278,  404,  356,  425,  150,  128,

      416,  412,  414,  121,  467,  150,  120,  120,  120,  120,
      120,  120,  186,  282,  282,  282,  282,  282,  418,  186,
      186,  186,  186,  186,  186,  425,  247,  407,  407,  407,
      407,  407,  417,  426,  438,  281,  150,  382,  150,  382,
      128,  128,  430,  408,  150,  128,  150,  418,  186,  186,
      186,  186,  186,  186,  144,  144,  144,  144,  144,  126,
      417,  426,  438,  114,  150,  248,  317,  353,  353,  353,
      317,  430,  278,  192,  431,  437,  436,  114,  165,  410,
      192,  192,  192,  192,  192,  192,  322,  357,  357,  357,
      322,  407,  407,  407,  407,  407,  161,  278,  150,  150,

      150,  150,  147,  431,  437,  436,  128,  408,  427,  192,
      192,  192,  192,  192,  192,  197,  440,  150,  279,  444,
      128,  128,  197,  197,  197,  197,  197,  197,  474,  474,
      474,  474,  474,  150,   57,   76,  427,   59,  281,  439,
      126,  150,  445,  410,  474,  440,  150,  444,  150,  450,
      122,  197,  197,  197,  197,  197,  197,  157,  157,  157,
      157,  157,  419,  419,  419,  419,  419,  439,  114,  446,
      445,  150,  456,  452,  451,  420,  204,  453,  450,  447,
      410,  150,  150,  204,  204,  204,  204,  204,  204,  419,
      419,  419,  419,  419,  150,  458,  150,  446,  100,  150,

      457,  452,  420,  451,  150,   99,  453,  447,  150,  150,
      468,  471,  204,  204,  204,  204,  204,  204,  159,  159,
      159,  159,  159,  458,   98,  150,   78,   58,  457,  419,
      419,  419,  419,  419,  462,  150,   57,  205,  468,   50,
      471,  422,  420,  150,  205,  205,  205,  205,  205,  205,
      419,  419,  419,  419,  419,  419,  419,  419,  419,  419,
       47,  474,  462,  420,  474,  474,  474,  474,  420,  474,
      474,  474,  459,  205,  205,  205,  205,  205,  205,  212,
      150,  422,  472,  474,  469,  474,  212,  212,  212,  212,
      212,  212,  419,  419,  419,  419,  419,  150,  466,  474,

      459,  473,  422,  474,  150,  420,  150,  422,  470,  150,
      472,  474,  474,  469,  474,  212,  212,  212,  212,  212,
      212,  107,  173,  173,  173,  107,  466,   40,  474,  473,
      150,  474,  419,  419,  419,  419,  419,  470,  474,  474,
      215,  474,  474,  474,  422,  420,  474,  215,  215,  215,
      215,  215,  215,  434,  434,  434,  434,  434,  441,  441,
      441,  441,  441,  474,  474,  474,  420,  474,  474,  474,
      474,  420,  474,   41,  474,  474,  215,  215,  215,  215,
      215,  215,  217,  474,  422,  474,  474,  474,  474,  217,
      217,  217,  217,  217,  217,  474,  474,  474,  474,  474,

      474,  474,  474,  474,  474,  422,  474,  474,  474,  474,
      422,  474,  474,  474,  474,  474,  474,  474,  217,  217,
      217,  217,  217,  217,  177,  177,  177,  177,  177,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  218,  474,  474,  474,  474,  474,  474,
      218,  218,  218,  218,  218,  218,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  218,
      218,  218,  218,  218,  218,  115,  115,  115,  115,  115,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,

      474,  474,  474,  474,  219,  474,  474,  474,  474,  474,
      474,  219,  219,  219,  219,  219,  219,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      219,  219,  219,  219,  219,  219,  118,  180,  180,  180,
      118,  474,  474,  474,  474,  474,  474,   40,  474,  474,
      474,  474,  474,  474,  474,  220,  474,  474,  474,  474,
      474,  474,  220,  220,  220,  220,  220,  220,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,   49,  474,

      474,  220,  220,  220,  220,  220,  220,  185,  185,  185,
      185,  185,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  224,  474,  474,  474,
      474,  474,  474,  224,  224,  224,  224,  224,  224,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  224,  224,  224,  224,  224,  224,  226,  474,
      474,  474,  474,  474,  474,  226,  226,  226,  226,  226,
      226,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,

      474,  474,  474,  474,  226,  226,  226,  226,  226,  226,
      196,  196,  196,  196,  196,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  229,
      474,  474,  474,  474,  474,  474,  229,  229,  229,  229,
      229,  229,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  229,  229,  229,  229,  229,
      229,  236,  474,  474,  474,  474,  474,  474,  236,  236,
      236,  236,  236,  236,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,

      474,  474,  474,  474,  474,  474,  474,  236,  236,  236,
      236,  236,  236,  159,  159,  159,  159,  159,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  237,  474,  474,  474,  474,  474,  474,  237,
      237,  237,  237,  237,  237,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  237,  237,
      237,  237,  237,  237,  249,  474,  474,  474,  474,  474,
      474,  249,  249,  249,  249,  249,  249,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,

      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      249,  249,  249,  249,  249,  249,  107,  173,  173,  173,
      107,  474,   40,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  251,  474,  474,  474,  474,
      474,  474,  251,  251,  251,  251,  251,  251,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,   41,  474,
      474,  251,  251,  251,  251,  251,  251,  253,  474,  474,
      474,  474,  474,  474,  253,  253,  253,  253,  253,  253,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,

      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  253,  253,  253,  253,  253,  253,  177,
      177,  177,  177,  177,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  254,  474,
      474,  474,  474,  474,  474,  254,  254,  254,  254,  254,
      254,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  254,  254,  254,  254,  254,  254,
      115,  115,  115,  115,  115,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  255,

      474,  474,  474,  474,  474,  474,  255,  255,  255,  255,
      255,  255,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  255,  255,  255,  255,  255,
      255,  118,  180,  180,  180,  118,  474,  474,  474,  474,
      474,  474,   40,  474,  474,  474,  474,  474,  474,  474,
      256,  474,  474,  474,  474,  474,  474,  256,  256,  256,
      256,  256,  256,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,   49,  474,  474,  256,  256,  256,  256,

      256,  256,  185,  185,  185,  185,  185,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  258,  474,  474,  474,  474,  474,  474,  258,  258,
      258,  258,  258,  258,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  258,  258,  258,
      258,  258,  258,  259,  474,  474,  474,  474,  474,  474,
      259,  259,  259,  259,  259,  259,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  259,

      259,  259,  259,  259,  259,  196,  196,  196,  196,  196,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  262,  474,  474,  474,  474,  474,
      474,  262,  262,  262,  262,  262,  262,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      262,  262,  262,  262,  262,  262,  268,  474,  474,  474,
      474,  474,  474,  268,  268,  268,  268,  268,  268,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,

      474,  474,  268,  268,  268,  268,  268,  268,  159,  159,
      159,  159,  159,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  269,  474,  474,
      474,  474,  474,  474,  269,  269,  269,  269,  269,  269,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  269,  269,  269,  269,  269,  269,  276,
      276,  276,  276,  282,  474,  284,  474,  474,  474,  474,
      284,  284,  285,  474,  474,  474,  474,  474,  286,  474,
      474,  474,  474,  474,  474,  286,  286,  286,  286,  286,

      286,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  287,  474,  474,  286,  286,  286,  286,  286,  286,
      288,  474,  474,  474,  474,  474,  474,  288,  288,  288,
      288,  288,  288,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  288,  288,  288,  288,
      288,  288,  107,  173,  173,  173,  107,  474,   40,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  290,  474,  474,  474,  474,  474,  474,  290,  290,

      290,  290,  290,  290,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,   41,  474,  474,  290,  290,  290,
      290,  290,  290,  292,  474,  474,  474,  474,  474,  474,
      292,  292,  292,  292,  292,  292,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  114,  474,  474,  292,
      292,  292,  292,  292,  292,  177,  177,  177,  177,  177,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  293,  474,  474,  474,  474,  474,

      474,  293,  293,  293,  293,  293,  293,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  114,  474,  474,
      293,  293,  293,  293,  293,  293,  115,  115,  115,  115,
      115,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  294,  474,  474,  474,  474,
      474,  474,  294,  294,  294,  294,  294,  294,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  294,  294,  294,  294,  294,  294,  118,  180,  180,

      180,  118,  474,  474,  474,  474,  474,  474,   40,  474,
      474,  474,  474,  474,  474,  474,  295,  474,  474,  474,
      474,  474,  474,  295,  295,  295,  295,  295,  295,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,   49,
      474,  474,  295,  295,  295,  295,  295,  295,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,   89,  474,  474,
      474,  474,  474,  474,   89,   89,   89,   89,   89,   89,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,

      474,  474,  474,  296,  474,  474,  474,  474,  474,  474,
      474,  474,  474,   89,   89,   89,   89,   89,   89,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  296,  185,  185,  185,  185,  185,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  297,  474,  474,  474,  474,  474,  474,  297,  297,
      297,  297,  297,  297,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  297,  297,  297,
      297,  297,  297,  298,  474,  474,  474,  474,  474,  474,

      298,  298,  298,  298,  298,  298,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  298,
      298,  298,  298,  298,  298,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  127,  474,  474,  474,  474,  474,
      474,  127,  127,  127,  127,  127,  127,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      127,  127,  127,  127,  127,  127,  196,  196,  196,  196,

      196,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  300,  474,  474,  474,  474,
      474,  474,  300,  300,  300,  300,  300,  300,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  300,  300,  300,  300,  300,  300,  305,  474,  474,
      474,  474,  474,  474,  305,  305,  305,  305,  305,  305,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  305,  305,  305,  305,  305,  305,  159,

      159,  159,  159,  159,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  306,  474,
      474,  474,  474,  474,  474,  306,  306,  306,  306,  306,
      306,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  306,  306,  306,  306,  306,  306,
      277,  277,  277,  316,  474,  474,  318,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  319,
      474,  474,  474,  474,  474,  474,  319,  319,  319,  319,
      319,  319,  474,  474,  474,  474,  474,  474,  474,  474,

      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  320,  474,  474,  319,  319,  319,  319,  319,
      319,  280,  280,  280,  321,  474,  474,  474,  474,  474,
      474,  474,  323,  474,  474,  474,  474,  474,  474,  474,
      324,  474,  474,  474,  474,  474,  474,  324,  324,  324,
      324,  324,  324,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  325,  474,  474,  324,  324,  324,  324,
      324,  324,  282,  282,  282,  282,  282,  474,  474,  474,
      474,  474,  474,  474,  474,  247,  474,  474,  474,  474,

      474,  326,  474,  474,  474,  474,  474,  474,  326,  326,
      326,  326,  326,  326,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  248,  474,  474,  326,  326,  326,
      326,  326,  326,  276,  276,  276,  276,  282,  474,  284,
      474,  474,  474,  474,  284,  284,  285,  474,  474,  474,
      474,  474,  286,  474,  474,  474,  474,  474,  474,  286,
      286,  286,  286,  286,  286,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  287,  474,  474,  286,  286,

      286,  286,  286,  286,  327,  474,  474,  474,  474,  474,
      474,  327,  327,  327,  327,  327,  327,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      327,  327,  327,  327,  327,  327,  107,  173,  173,  173,
      107,  474,   40,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  329,  474,  474,  474,  474,
      474,  474,  329,  329,  329,  329,  329,  329,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,   41,  474,

      474,  329,  329,  329,  329,  329,  329,  177,  177,  177,
      177,  177,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  330,  474,  474,  474,
      474,  474,  474,  330,  330,  330,  330,  330,  330,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  114,
      474,  474,  330,  330,  330,  330,  330,  330,  115,  115,
      115,  115,  115,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  331,  474,  474,
      474,  474,  474,  474,  331,  331,  331,  331,  331,  331,

      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  331,  331,  331,  331,  331,  331,  118,
      180,  180,  180,  118,  474,  474,  474,  474,  474,  474,
       40,  474,  474,  474,  474,  474,  474,  474,  332,  474,
      474,  474,  474,  474,  474,  332,  332,  332,  332,  332,
      332,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,   49,  474,  474,  332,  332,  332,  332,  332,  332,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,

      474,  474,  474,  474,  474,  474,  333,  474,  474,   89,
      474,  474,  474,  474,  474,  474,   89,   89,   89,   89,
       89,   89,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,   89,   89,   89,   89,   89,
       89,  185,  185,  185,  185,  185,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      334,  474,  474,  474,  474,  474,  474,  334,  334,  334,
      334,  334,  334,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,

      474,  474,  474,  474,  474,  474,  334,  334,  334,  334,
      334,  334,  144,  144,  144,  144,  144,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  335,  474,  474,  474,  474,  474,  474,  335,  335,
      335,  335,  335,  335,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  335,  335,  335,
      335,  335,  335,  196,  196,  196,  196,  196,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  337,  474,  474,  474,  474,  474,  474,  337,

      337,  337,  337,  337,  337,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  337,  337,
      337,  337,  337,  337,  341,  474,  474,  474,  474,  474,
      474,  341,  341,  341,  341,  341,  341,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      341,  341,  341,  341,  341,  341,  159,  159,  159,  159,
      159,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  342,  474,  474,  474,  474,

      474,  474,  342,  342,  342,  342,  342,  342,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  342,  342,  342,  342,  342,  342,  317,  353,  353,
      353,  317,  474,  278,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  354,  474,  474,  474,
      474,  474,  474,  354,  354,  354,  354,  354,  354,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  279,
      474,  474,  354,  354,  354,  354,  354,  354,  277,  277,

      277,  316,  474,  474,  318,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  319,  474,  474,
      474,  474,  474,  474,  319,  319,  319,  319,  319,  319,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      320,  474,  474,  319,  319,  319,  319,  319,  319,  322,
      357,  357,  357,  322,  474,  474,  474,  474,  474,  474,
      278,  474,  474,  474,  474,  474,  474,  474,  358,  474,
      474,  474,  474,  474,  474,  358,  358,  358,  358,  358,
      358,  474,  474,  474,  474,  474,  474,  474,  474,  474,

      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  281,  474,  474,  358,  358,  358,  358,  358,  358,
      280,  280,  280,  321,  474,  474,  474,  474,  474,  474,
      474,  323,  474,  474,  474,  474,  474,  474,  474,  324,
      474,  474,  474,  474,  474,  474,  324,  324,  324,  324,
      324,  324,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  325,  474,  474,  324,  324,  324,  324,  324,
      324,  282,  282,  282,  282,  282,  474,  474,  474,  474,
      474,  474,  474,  474,  247,  474,  474,  474,  474,  474,

      359,  474,  474,  474,  474,  474,  474,  359,  359,  359,
      359,  359,  359,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  248,  474,  474,  359,  359,  359,  359,
      359,  359,  361,  474,  474,  474,  474,  474,  474,  361,
      361,  361,  361,  361,  361,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  361,  361,
      361,  361,  361,  361,  112,  474,  474,  474,  474,  474,
      474,  112,  112,  112,  112,  112,  112,  474,  474,  474,

      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      112,  112,  112,  112,  112,  112,  363,  474,  474,  474,
      474,  474,  474,  363,  363,  363,  363,  363,  363,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  363,  363,  363,  363,  363,  363,  144,  144,
      144,  144,  144,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  127,  474,  474,
      474,  474,  474,  474,  127,  127,  127,  127,  127,  127,

      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  127,  127,  127,  127,  127,  127,  196,
      196,  196,  196,  196,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  365,  474,
      474,  474,  474,  474,  474,  365,  365,  365,  365,  365,
      365,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  365,  365,  365,  365,  365,  365,
      369,  474,  474,  474,  474,  474,  474,  369,  369,  369,

      369,  369,  369,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  369,  369,  369,  369,
      369,  369,  370,  474,  474,  474,  474,  474,  474,  370,
      370,  370,  370,  370,  370,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  370,  370,
      370,  370,  370,  370,  282,  282,  282,  282,  282,  474,
      474,  474,  474,  474,  474,  474,  474,  247,  474,  474,
      474,  474,  474,  371,  474,  474,  474,  474,  474,  474,

      371,  371,  371,  371,  371,  371,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  248,  474,  474,  371,
      371,  371,  371,  371,  371,  374,  474,  474,  474,  474,
      474,  474,  375,  474,  376,  474,  474,  474,  474,  377,
      378,  474,  474,  379,  474,  474,  474,  474,  150,  474,
      474,  474,  474,  474,  374,  474,  474,  474,  474,  474,
      375,  474,  376,  474,  474,  474,  474,  377,  378,  474,
      474,  379,  383,  474,  474,  474,  474,  474,  474,  383,
      383,  383,  383,  383,  383,  474,  474,  474,  474,  474,

      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  383,  383,
      383,  383,  383,  383,  384,  474,  474,  474,  474,  474,
      474,  384,  384,  384,  384,  384,  384,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      384,  384,  384,  384,  384,  384,  385,  474,  474,  474,
      474,  474,  474,  385,  385,  385,  385,  385,  385,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,

      474,  474,  385,  385,  385,  385,  385,  385,  393,  474,
      474,  474,  474,  474,  474,  393,  393,  393,  393,  393,
      393,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  393,  393,  393,  393,  393,  393,
      394,  474,  474,  474,  474,  474,  474,  394,  394,  394,
      394,  394,  394,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  394,  394,  394,  394,
      394,  394,  395,  474,  474,  474,  474,  474,  474,  395,

      395,  395,  395,  395,  395,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  395,  395,
      395,  395,  395,  395,  405,  474,  474,  474,  474,  474,
      474,  405,  405,  405,  405,  405,  405,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      405,  405,  405,  405,  405,  405,  406,  474,  474,  474,
      474,  474,  474,  406,  406,  406,  406,  406,  406,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,

      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  406,  406,  406,  406,  406,  406,  424,  474,
      474,  474,  474,  474,  474,  424,  424,  424,  424,  424,
      424,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  424,  424,  424,  424,  424,  424,
      433,  474,  474,  474,  474,  474,  474,  433,  433,  433,
      433,  433,  433,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  433,  433,  433,  433,

      433,  433,  434,  434,  434,  434,  434,  474,  474,  474,
      474,  474,  474,  474,  474,  420,  474,  474,  474,  474,
      474,  435,  474,  474,  474,  474,  474,  474,  435,  435,
      435,  435,  435,  435,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  422,  474,  474,  435,  435,  435,
      435,  435,  435,  441,  441,  441,  441,  441,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  442,  474,  474,  474,  474,  474,  474,  442,
      442,  442,  442,  442,  442,  474,  474,  474,  474,  474,

      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  442,  442,
      442,  442,  442,  442,  443,  474,  474,  474,  474,  474,
      474,  443,  443,  443,  443,  443,  443,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      443,  443,  443,  443,  443,  443,  448,  474,  474,  474,
      474,  474,  474,  448,  448,  448,  448,  448,  448,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,

      474,  474,  448,  448,  448,  448,  448,  448,  449,  474,
      474,  474,  474,  474,  474,  449,  449,  449,  449,  449,
      449,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  449,  449,  449,  449,  449,  449,
      454,  474,  474,  474,  474,  474,  474,  454,  454,  454,
      454,  454,  454,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  454,  454,  454,  454,
      454,  454,  455,  474,  474,  474,  474,  474,  474,  455,

      455,  455,  455,  455,  455,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  455,  455,
      455,  455,  455,  455,  460,  474,  474,  474,  474,  474,
      474,  460,  460,  460,  460,  460,  460,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      460,  460,  460,  460,  460,  460,  461,  474,  474,  474,
      474,  474,  474,  461,  461,  461,  461,  461,  461,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,

      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  461,  461,  461,  461,  461,  461,  465,  474,
      474,  474,  474,  474,  474,  465,  465,  465,  465,  465,
      465,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  465,  465,  465,  465,  465,  465,
       39,  474,  474,   39,   39,   39,   39,   39,   39,   39,
       39,   39,   39,   45,   45,  474,   45,   45,   48,  474,
      474,   48,   48,   48,   48,   48,   48,   48,   48,   48,
       48,   53,   53,  474,   53,   53,   80,  474,  474,   80,

       80,   89,  474,   89,   89,  474,   89,   89,   96,   96,
       96,   96,   96,   96,   96,   96,   96,   96,  107,  107,
      107,  107,  107,  107,  107,  107,  107,  107,  107,  107,
      107,  112,  112,  474,  112,  112,  115,  115,  115,  115,
      115,  115,  115,  115,  115,  115,  118,  118,  118,  118,
      118,  118,  118,  118,  118,  118,  118,  118,  118,  125,
      125,  125,  125,  125,  125,  125,  125,  125,  125,  125,
      125,  125,  125,  127,  127,  474,  127,  127,  144,  144,
      144,  144,  144,  144,  144,  144,  144,  144,  149,  149,
      474,  149,  149,  157,  157,  157,  157,  157,  157,  157,

      157,  157,  157,  159,  159,  159,  159,  159,  159,  159,
      159,  159,  159,  164,  164,  164,  177,  177,  177,  177,
      177,  177,  177,  177,  177,  177,   48,   48,  474,   48,
       48,   48,   48,   48,   48,   48,   48,   48,   48,  118,
      118,  118,  118,  118,  118,  118,  118,  118,  118,  118,
      118,  118,  125,  125,  125,  125,  125,  125,  125,  125,
      125,  125,  125,  125,  125,  125,  183,  183,  183,  183,
      183,  183,  183,  183,  183,  183,  183,  183,  183,  183,
      185,  185,  185,  185,  185,  185,  185,  185,  185,  185,
      196,  196,  196,  196,  196,  196,  196,  196,  196,  196,

      208,  208,  208,  208,   39,  474,  474,   39,   39,   39,
       39,   39,   39,   39,   39,   39,   39,  222,  222,  222,
      222,  222,  222,  222,  222,  222,  222,  222,  222,  222,
      222,  239,  239,  239,  239,  244,  244,  244,  244,  244,
      244,  474,  244,  244,  244,  244,  244,  244,   39,   39,
       39,   39,   39,   39,   39,   39,   39,   39,   39,   39,
       39,  183,  183,  183,  183,  183,  183,  183,  183,  183,
      183,  183,  183,  183,  183,  271,  271,  271,  271,  244,
      244,  244,  244,  244,  244,  474,  244,  244,  244,  244,
      244,  244,  277,  474,  474,  277,  277,  277,  277,  277,

      277,  277,  277,  277,  277,  280,  474,  474,  280,  280,
      280,  280,  280,  280,  280,  280,  280,  280,  283,  283,
      283,  283,  283,  283,  283,  283,  283,  283,  283,  283,
      283,   39,   39,   39,   39,   39,   39,   39,   39,   39,
       39,   39,   39,   39,  112,  112,  474,  112,  112,   48,
       48,   48,   48,   48,   48,   48,   48,   48,   48,   48,
       48,   48,  308,  308,  308,  308,  317,  317,  317,  317,
      317,  317,  317,  317,  317,  317,  317,  317,  317,  280,
      474,  474,  280,  280,  280,  280,  280,  280,  280,  280,
      280,  280,  322,  322,  322,  322,  322,  322,  322,  322,

      322,  322,  322,  322,  322,  244,  244,  244,  244,  244,
      474,  474,  244,  244,  244,  244,  244,  244,  283,  283,
      283,  283,  283,  283,  283,  283,  283,  283,  283,  283,
      283,   39,   39,   39,   39,   39,   39,   39,   39,   39,
       39,   39,   39,   39,  112,  112,  474,  112,  112,   48,
       48,   48,   48,   48,   48,   48,   48,   48,   48,   48,
       48,   48,  344,  344,  344,  344,  277,  277,  474,  277,
      277,  277,  277,  277,  277,  277,  277,  277,  277,  317,
      317,  317,  317,  317,  317,  317,  317,  317,  317,  317,
      317,  317,  280,  280,  474,  280,  280,  280,  280,  280,

      280,  280,  280,  280,  280,  322,  322,  322,  322,  322,
      322,  322,  322,  322,  322,  322,  322,  322,  244,  244,
      244,  244,  244,  474,  474,  244,  244,  244,  244,  244,
      244,  409,  409,  409,  409,  474,  474,  474,  474,  409,
      474,  474,  409,  409,  421,  421,  421,  421,  474,  474,
      474,  421,  421,  421,  474,  421,  421,  423,  423,  423,
      423,  423,  423,  423,  423,  423,  423,  432,  432,  432,
      432,  432,  432,  432,  432,  432,  432,    7,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,

      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474
    } ;

static yyconst flex_int16_t yy_chk[6664] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    3,    5,    4,    6,   15,
       12,    3,  473,    4,    9,    9,    9,    9,    9,   10,

       10,   10,   10,   10,    3,    3,    4,    4,   11,   11,
       11,   11,   11,   23,   39,    5,   17,    6,   35,   17,
        3,   24,    4,   32,   24,   24,   32,   32,   38,   48,
       15,   69,    3,    3,    4,    4,   12,   42,   25,   17,
       42,   25,   11,  470,   69,    3,   35,    4,   17,   24,
       53,   32,   17,   23,   31,   77,   38,   77,   35,   69,
       39,   24,  463,   32,   33,  457,   65,   17,   82,   25,
       48,   11,   13,   42,   35,   13,   17,   24,   25,   32,
       82,   31,   13,   13,   13,   13,   13,   13,   65,   54,
       53,   33,   54,   54,   31,   65,   82,   25,   36,   36,

       36,   36,   36,   70,   33,   68,   68,  452,   13,   31,
      164,   13,   13,   13,   13,   13,   13,   20,  164,   33,
      208,   89,   70,  436,   20,   20,  430,   20,  208,   54,
      123,  123,   70,   68,   20,   20,   20,   20,   20,   20,
       20,   20,   20,   20,   20,   20,   20,   20,   20,   20,
       20,   20,   20,   20,   20,   20,   20,   20,   20,   20,
       20,   89,   20,   20,   20,   20,   20,   20,   20,   20,
       20,   20,   20,   20,   20,   20,   20,   20,   20,   20,
       20,   20,   20,   20,   20,   20,   20,   20,   64,   52,
      105,   20,   22,   74,   55,  425,   37,   37,   37,   37,

       37,   57,   64,   57,   22,  239,  483,   22,  483,   52,
       22,  130,   55,  239,   22,   22,   64,   22,  105,   74,
       67,   66,   74,   57,   72,   72,  415,   96,   22,   67,
       37,  130,   66,   22,   55,   66,   22,   52,   71,   22,
      130,   55,   22,   22,   71,   22,   26,   73,   67,   66,
       81,   57,   71,   26,   26,   26,   26,   26,   26,   37,
       66,   72,  107,   79,   73,   93,   71,   96,   73,   81,
       92,   73,   71,  106,   85,   86,   73,   92,  106,   81,
       84,   95,   26,   26,   26,   26,   26,   26,   41,   41,
       41,   41,   73,  381,   41,   79,   73,   83,   93,   79,

       85,   86,   84,   85,   86,   93,   95,   41,  107,   84,
       92,   83,  103,  117,   41,   41,   41,   41,   41,   41,
      139,   95,  101,   79,  106,   83,   93,  108,  118,  126,
      190,  102,  119,  126,   95,  104,  124,  103,  118,  101,
       41,  133,  119,   41,   41,   41,   41,   41,   41,   44,
      380,  124,  103,  139,  117,  159,   44,   44,   44,   44,
       44,   44,  101,  190,  102,  103,  104,  133,  101,  344,
      133,  102,  495,  108,  495,  104,  124,  136,  136,  118,
      124,  143,   44,  119,  154,   44,   44,   44,   44,   44,
       44,   46,  102,  148,  104,  159,  146,  151,   46,   46,

       46,   46,   46,   46,  143,  136,  146,  154,  163,  153,
      143,  166,  152,  154,  162,  148,  168,  169,  156,  173,
      153,  162,  148,  151,  146,  152,  151,   46,   46,   46,
       46,   46,   46,   49,   49,   49,   49,  153,  156,  155,
      152,  170,  171,  172,   49,  180,  182,  156,  163,  188,
      338,  166,   49,  155,  162,  180,  168,  169,  193,   49,
       49,   49,   49,   49,   49,  173,  201,  155,  313,  199,
      182,  172,  188,  223,  312,  245,  199,  223,  188,  170,
      193,  170,  171,  195,  201,   49,  182,  193,   49,   49,
       49,   49,   49,   49,   56,  201,  180,  199,  182,  200,

      198,   56,   56,   56,   56,   56,   56,  170,  195,  198,
      213,  200,  195,  211,  211,  211,  211,  211,  231,  211,
      202,  245,  246,  336,  211,  214,  211,  200,  198,  203,
       56,   56,   56,   56,   56,   56,   76,  277,  227,  228,
      221,  250,  202,   76,   76,   76,   76,   76,   76,  202,
      213,  203,  227,  214,  231,  228,  230,  316,  203,  336,
      488,  488,  221,  246,  230,  211,  227,  228,  233,  250,
      232,  264,   76,   76,   76,   76,   76,   76,   87,  232,
      221,  261,  263,  277,  230,   87,   87,   87,   87,   87,
       87,  221,  264,  234,  233,  265,  267,  233,  232,  261,

      264,  234,  265,  316,  263,  271,  280,  267,  311,  289,
      261,  263,  321,  271,   87,   87,   87,   87,   87,   87,
       90,  234,  386,  265,  267,  302,  386,   90,   90,   90,
       90,   90,   90,  243,  243,  243,  243,  243,  289,  243,
      310,  505,  308,  505,  243,  299,  243,  280,  301,  304,
      308,  302,  299,  321,  302,  301,   90,   90,   90,   90,
       90,   90,   97,   97,   97,   97,   97,  276,  276,  276,
      276,  276,  309,  299,   97,  304,  301,  317,  304,  339,
      276,   97,  317,  328,  360,  243,  389,  303,   97,   97,
       97,   97,   97,   97,  244,  244,  244,  244,  244,  507,

      244,  507,  511,  339,  511,  244,  292,  244,  339,  389,
      333,  328,  360,  275,   97,  389,  340,   97,   97,   97,
       97,   97,   97,  109,  109,  109,  109,  109,  317,  109,
      278,  278,  278,  278,  278,  314,  314,  314,  314,  314,
      340,  333,  109,  278,  274,  340,  244,  273,  314,  109,
      109,  109,  109,  109,  109,  282,  282,  282,  282,  282,
      327,  327,  327,  327,  327,  379,  272,  362,  282,  333,
      361,  361,  361,  361,  361,  109,  327,  362,  109,  109,
      109,  109,  109,  109,  110,  110,  110,  110,  266,  242,
      110,  379,  241,  240,  379,  283,  283,  283,  283,  283,

      352,  459,  388,  110,  388,  352,  362,  282,  283,  235,
      110,  110,  110,  110,  110,  110,  284,  284,  284,  284,
      284,  285,  285,  285,  285,  285,  353,  225,  322,  284,
      388,  353,  222,  210,  285,  390,  110,  459,  322,  110,
      110,  110,  110,  110,  110,  113,  458,  283,  458,  209,
      390,  352,  113,  113,  113,  113,  113,  113,  318,  318,
      318,  318,  318,  390,  318,  356,  196,  513,  284,  513,
      520,  318,  520,  285,  458,  356,  191,  353,  113,  322,
      399,  113,  113,  113,  113,  113,  113,  114,  189,  323,
      323,  323,  323,  323,  114,  114,  114,  114,  114,  114,

      323,  399,  323,  363,  363,  363,  363,  363,  187,  399,
      318,  329,  329,  329,  329,  329,  356,  329,  341,  341,
      341,  341,  341,  114,  114,  114,  114,  114,  114,  116,
      116,  116,  116,  116,  342,  342,  342,  342,  342,  414,
      366,  323,  367,  332,  332,  332,  332,  332,  116,  185,
      342,  357,  374,  373,  332,  116,  116,  116,  116,  116,
      116,  357,  366,  329,  367,  414,  183,  177,  414,  366,
      341,  367,  165,  161,  374,  365,  365,  365,  365,  365,
      373,  374,  375,  376,  116,  116,  116,  116,  116,  116,
      120,  120,  120,  120,  120,  332,  523,  533,  523,  533,

      157,  120,  357,  149,  375,  376,  147,  144,  373,  120,
      378,  375,  376,  540,  416,  540,  120,  120,  120,  120,
      120,  120,  351,  351,  351,  351,  351,  365,  351,  391,
      377,  387,  378,  142,  387,  351,  377,  401,  416,  378,
      141,  397,  120,  416,  391,  120,  120,  120,  120,  120,
      120,  121,  121,  121,  121,  387,  397,  391,  377,  401,
      387,  392,  121,  387,  140,  138,  401,  392,  137,  397,
      121,  402,  398,  400,  351,  464,  392,  121,  121,  121,
      121,  121,  121,  355,  355,  355,  355,  355,  135,  392,
      398,  400,  134,  402,  355,  392,  355,  411,  464,  132,

      402,  398,  400,  121,  464,  411,  121,  121,  121,  121,
      121,  121,  128,  395,  395,  395,  395,  395,  404,  128,
      128,  128,  128,  128,  128,  411,  395,  396,  396,  396,
      396,  396,  403,  412,  428,  355,  404,  541,  403,  541,
      131,  129,  417,  396,  428,  127,  412,  404,  128,  128,
      128,  128,  128,  128,  145,  145,  145,  145,  145,  125,
      403,  412,  428,  115,  417,  395,  405,  405,  405,  405,
      405,  417,  405,  145,  418,  427,  426,  112,   94,  396,
      145,  145,  145,  145,  145,  145,  406,  406,  406,  406,
      406,  407,  407,  407,  407,  407,   91,  406,  426,   80,

      418,  427,   78,  418,  427,  426,  145,  407,  413,  145,
      145,  145,  145,  145,  145,  150,  431,  413,  405,  437,
       75,   63,  150,  150,  150,  150,  150,  150,  408,  408,
      408,  408,  408,  437,   61,   60,  413,   59,  406,  429,
       58,  431,  438,  407,  408,  431,  429,  437,  438,  444,
       51,  150,  150,  150,  150,  150,  150,  158,  158,  158,
      158,  158,  419,  419,  419,  419,  419,  429,   45,  439,
      438,  444,  450,  446,  445,  419,  158,  447,  444,  440,
      408,  439,  446,  158,  158,  158,  158,  158,  158,  409,
      409,  409,  409,  409,  440,  451,  445,  439,   29,  447,

      450,  446,  409,  445,  451,   28,  447,  440,  450,  158,
      466,  469,  158,  158,  158,  158,  158,  158,  160,  160,
      160,  160,  160,  451,   27,  466,   21,   19,  450,  421,
      421,  421,  421,  421,  456,  469,   18,  160,  466,   16,
      469,  409,  421,  456,  160,  160,  160,  160,  160,  160,
      423,  423,  423,  423,  423,  432,  432,  432,  432,  432,
       14,    7,  456,  423,    0,    0,    0,    0,  432,    0,
        0,    0,  453,  160,  160,  160,  160,  160,  160,  167,
      453,  421,  471,    0,  467,    0,  167,  167,  167,  167,
      167,  167,  434,  434,  434,  434,  434,  471,  462,    0,

      453,  472,  423,    0,  462,  434,  467,  432,  468,  472,
      471,    0,    0,  467,    0,  167,  167,  167,  167,  167,
      167,  174,  174,  174,  174,  174,  462,  174,    0,  472,
      468,    0,  441,  441,  441,  441,  441,  468,    0,    0,
      174,    0,    0,    0,  434,  441,    0,  174,  174,  174,
      174,  174,  174,  461,  461,  461,  461,  461,  465,  465,
      465,  465,  465,    0,    0,    0,  461,    0,    0,    0,
        0,  465,    0,  174,    0,    0,  174,  174,  174,  174,
      174,  174,  176,    0,  441,    0,    0,    0,    0,  176,
      176,  176,  176,  176,  176,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,  461,    0,    0,    0,    0,
      465,    0,    0,    0,    0,    0,    0,    0,  176,  176,
      176,  176,  176,  176,  178,  178,  178,  178,  178,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  178,    0,    0,    0,    0,    0,    0,
      178,  178,  178,  178,  178,  178,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  178,
      178,  178,  178,  178,  178,  179,  179,  179,  179,  179,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,  179,    0,    0,    0,    0,    0,
        0,  179,  179,  179,  179,  179,  179,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      179,  179,  179,  179,  179,  179,  181,  181,  181,  181,
      181,    0,    0,    0,    0,    0,    0,  181,    0,    0,
        0,    0,    0,    0,    0,  181,    0,    0,    0,    0,
        0,    0,  181,  181,  181,  181,  181,  181,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  181,    0,

        0,  181,  181,  181,  181,  181,  181,  186,  186,  186,
      186,  186,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  186,    0,    0,    0,
        0,    0,    0,  186,  186,  186,  186,  186,  186,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  186,  186,  186,  186,  186,  186,  192,    0,
        0,    0,    0,    0,    0,  192,  192,  192,  192,  192,
      192,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,  192,  192,  192,  192,  192,  192,
      197,  197,  197,  197,  197,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  197,
        0,    0,    0,    0,    0,    0,  197,  197,  197,  197,
      197,  197,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  197,  197,  197,  197,  197,
      197,  204,    0,    0,    0,    0,    0,    0,  204,  204,
      204,  204,  204,  204,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,  204,  204,  204,
      204,  204,  204,  205,  205,  205,  205,  205,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  205,    0,    0,    0,    0,    0,    0,  205,
      205,  205,  205,  205,  205,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  205,  205,
      205,  205,  205,  205,  212,    0,    0,    0,    0,    0,
        0,  212,  212,  212,  212,  212,  212,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      212,  212,  212,  212,  212,  212,  215,  215,  215,  215,
      215,    0,  215,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  215,    0,    0,    0,    0,
        0,    0,  215,  215,  215,  215,  215,  215,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  215,    0,
        0,  215,  215,  215,  215,  215,  215,  217,    0,    0,
        0,    0,    0,    0,  217,  217,  217,  217,  217,  217,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  217,  217,  217,  217,  217,  217,  218,
      218,  218,  218,  218,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  218,    0,
        0,    0,    0,    0,    0,  218,  218,  218,  218,  218,
      218,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  218,  218,  218,  218,  218,  218,
      219,  219,  219,  219,  219,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  219,

        0,    0,    0,    0,    0,    0,  219,  219,  219,  219,
      219,  219,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  219,  219,  219,  219,  219,
      219,  220,  220,  220,  220,  220,    0,    0,    0,    0,
        0,    0,  220,    0,    0,    0,    0,    0,    0,    0,
      220,    0,    0,    0,    0,    0,    0,  220,  220,  220,
      220,  220,  220,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  220,    0,    0,  220,  220,  220,  220,

      220,  220,  224,  224,  224,  224,  224,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  224,    0,    0,    0,    0,    0,    0,  224,  224,
      224,  224,  224,  224,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  224,  224,  224,
      224,  224,  224,  226,    0,    0,    0,    0,    0,    0,
      226,  226,  226,  226,  226,  226,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  226,

      226,  226,  226,  226,  226,  229,  229,  229,  229,  229,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  229,    0,    0,    0,    0,    0,
        0,  229,  229,  229,  229,  229,  229,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      229,  229,  229,  229,  229,  229,  236,    0,    0,    0,
        0,    0,    0,  236,  236,  236,  236,  236,  236,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,  236,  236,  236,  236,  236,  236,  237,  237,
      237,  237,  237,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  237,    0,    0,
        0,    0,    0,    0,  237,  237,  237,  237,  237,  237,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  237,  237,  237,  237,  237,  237,  248,
      248,  248,  248,  248,    0,  248,    0,    0,    0,    0,
      248,  248,  248,    0,    0,    0,    0,    0,  248,    0,
        0,    0,    0,    0,    0,  248,  248,  248,  248,  248,

      248,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  248,    0,    0,  248,  248,  248,  248,  248,  248,
      249,    0,    0,    0,    0,    0,    0,  249,  249,  249,
      249,  249,  249,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  249,  249,  249,  249,
      249,  249,  251,  251,  251,  251,  251,    0,  251,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  251,    0,    0,    0,    0,    0,    0,  251,  251,

      251,  251,  251,  251,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  251,    0,    0,  251,  251,  251,
      251,  251,  251,  253,    0,    0,    0,    0,    0,    0,
      253,  253,  253,  253,  253,  253,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  253,    0,    0,  253,
      253,  253,  253,  253,  253,  254,  254,  254,  254,  254,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  254,    0,    0,    0,    0,    0,

        0,  254,  254,  254,  254,  254,  254,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  254,    0,    0,
      254,  254,  254,  254,  254,  254,  255,  255,  255,  255,
      255,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  255,    0,    0,    0,    0,
        0,    0,  255,  255,  255,  255,  255,  255,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  255,  255,  255,  255,  255,  255,  256,  256,  256,

      256,  256,    0,    0,    0,    0,    0,    0,  256,    0,
        0,    0,    0,    0,    0,    0,  256,    0,    0,    0,
        0,    0,    0,  256,  256,  256,  256,  256,  256,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  256,
        0,    0,  256,  256,  256,  256,  256,  256,  257,  257,
      257,  257,  257,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  257,    0,    0,
        0,    0,    0,    0,  257,  257,  257,  257,  257,  257,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,  257,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  257,  257,  257,  257,  257,  257,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  257,  258,  258,  258,  258,  258,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  258,    0,    0,    0,    0,    0,    0,  258,  258,
      258,  258,  258,  258,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  258,  258,  258,
      258,  258,  258,  259,    0,    0,    0,    0,    0,    0,

      259,  259,  259,  259,  259,  259,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  259,
      259,  259,  259,  259,  259,  260,  260,  260,  260,  260,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  260,    0,    0,    0,    0,    0,
        0,  260,  260,  260,  260,  260,  260,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      260,  260,  260,  260,  260,  260,  262,  262,  262,  262,

      262,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  262,    0,    0,    0,    0,
        0,    0,  262,  262,  262,  262,  262,  262,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  262,  262,  262,  262,  262,  262,  268,    0,    0,
        0,    0,    0,    0,  268,  268,  268,  268,  268,  268,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  268,  268,  268,  268,  268,  268,  269,

      269,  269,  269,  269,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  269,    0,
        0,    0,    0,    0,    0,  269,  269,  269,  269,  269,
      269,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  269,  269,  269,  269,  269,  269,
      279,  279,  279,  279,    0,    0,  279,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  279,
        0,    0,    0,    0,    0,    0,  279,  279,  279,  279,
      279,  279,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  279,    0,    0,  279,  279,  279,  279,  279,
      279,  281,  281,  281,  281,    0,    0,    0,    0,    0,
        0,    0,  281,    0,    0,    0,    0,    0,    0,    0,
      281,    0,    0,    0,    0,    0,    0,  281,  281,  281,
      281,  281,  281,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  281,    0,    0,  281,  281,  281,  281,
      281,  281,  286,  286,  286,  286,  286,    0,    0,    0,
        0,    0,    0,    0,    0,  286,    0,    0,    0,    0,

        0,  286,    0,    0,    0,    0,    0,    0,  286,  286,
      286,  286,  286,  286,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  286,    0,    0,  286,  286,  286,
      286,  286,  286,  287,  287,  287,  287,  287,    0,  287,
        0,    0,    0,    0,  287,  287,  287,    0,    0,    0,
        0,    0,  287,    0,    0,    0,    0,    0,    0,  287,
      287,  287,  287,  287,  287,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  287,    0,    0,  287,  287,

      287,  287,  287,  287,  288,    0,    0,    0,    0,    0,
        0,  288,  288,  288,  288,  288,  288,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      288,  288,  288,  288,  288,  288,  290,  290,  290,  290,
      290,    0,  290,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  290,    0,    0,    0,    0,
        0,    0,  290,  290,  290,  290,  290,  290,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  290,    0,

        0,  290,  290,  290,  290,  290,  290,  293,  293,  293,
      293,  293,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  293,    0,    0,    0,
        0,    0,    0,  293,  293,  293,  293,  293,  293,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  293,
        0,    0,  293,  293,  293,  293,  293,  293,  294,  294,
      294,  294,  294,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  294,    0,    0,
        0,    0,    0,    0,  294,  294,  294,  294,  294,  294,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  294,  294,  294,  294,  294,  294,  295,
      295,  295,  295,  295,    0,    0,    0,    0,    0,    0,
      295,    0,    0,    0,    0,    0,    0,    0,  295,    0,
        0,    0,    0,    0,    0,  295,  295,  295,  295,  295,
      295,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  295,    0,    0,  295,  295,  295,  295,  295,  295,
      296,  296,  296,  296,  296,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,  296,    0,    0,  296,
        0,    0,    0,    0,    0,    0,  296,  296,  296,  296,
      296,  296,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  296,  296,  296,  296,  296,
      296,  297,  297,  297,  297,  297,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      297,    0,    0,    0,    0,    0,    0,  297,  297,  297,
      297,  297,  297,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,  297,  297,  297,  297,
      297,  297,  298,  298,  298,  298,  298,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  298,    0,    0,    0,    0,    0,    0,  298,  298,
      298,  298,  298,  298,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  298,  298,  298,
      298,  298,  298,  300,  300,  300,  300,  300,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  300,    0,    0,    0,    0,    0,    0,  300,

      300,  300,  300,  300,  300,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  300,  300,
      300,  300,  300,  300,  305,    0,    0,    0,    0,    0,
        0,  305,  305,  305,  305,  305,  305,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      305,  305,  305,  305,  305,  305,  306,  306,  306,  306,
      306,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  306,    0,    0,    0,    0,

        0,    0,  306,  306,  306,  306,  306,  306,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  306,  306,  306,  306,  306,  306,  319,  319,  319,
      319,  319,    0,  319,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  319,    0,    0,    0,
        0,    0,    0,  319,  319,  319,  319,  319,  319,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  319,
        0,    0,  319,  319,  319,  319,  319,  319,  320,  320,

      320,  320,    0,    0,  320,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  320,    0,    0,
        0,    0,    0,    0,  320,  320,  320,  320,  320,  320,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      320,    0,    0,  320,  320,  320,  320,  320,  320,  324,
      324,  324,  324,  324,    0,    0,    0,    0,    0,    0,
      324,    0,    0,    0,    0,    0,    0,    0,  324,    0,
        0,    0,    0,    0,    0,  324,  324,  324,  324,  324,
      324,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  324,    0,    0,  324,  324,  324,  324,  324,  324,
      325,  325,  325,  325,    0,    0,    0,    0,    0,    0,
        0,  325,    0,    0,    0,    0,    0,    0,    0,  325,
        0,    0,    0,    0,    0,    0,  325,  325,  325,  325,
      325,  325,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  325,    0,    0,  325,  325,  325,  325,  325,
      325,  326,  326,  326,  326,  326,    0,    0,    0,    0,
        0,    0,    0,    0,  326,    0,    0,    0,    0,    0,

      326,    0,    0,    0,    0,    0,    0,  326,  326,  326,
      326,  326,  326,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  326,    0,    0,  326,  326,  326,  326,
      326,  326,  330,    0,    0,    0,    0,    0,    0,  330,
      330,  330,  330,  330,  330,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  330,  330,
      330,  330,  330,  330,  331,    0,    0,    0,    0,    0,
        0,  331,  331,  331,  331,  331,  331,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      331,  331,  331,  331,  331,  331,  334,    0,    0,    0,
        0,    0,    0,  334,  334,  334,  334,  334,  334,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  334,  334,  334,  334,  334,  334,  335,  335,
      335,  335,  335,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  335,    0,    0,
        0,    0,    0,    0,  335,  335,  335,  335,  335,  335,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  335,  335,  335,  335,  335,  335,  337,
      337,  337,  337,  337,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  337,    0,
        0,    0,    0,    0,    0,  337,  337,  337,  337,  337,
      337,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  337,  337,  337,  337,  337,  337,
      354,    0,    0,    0,    0,    0,    0,  354,  354,  354,

      354,  354,  354,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  354,  354,  354,  354,
      354,  354,  358,    0,    0,    0,    0,    0,    0,  358,
      358,  358,  358,  358,  358,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  358,  358,
      358,  358,  358,  358,  359,  359,  359,  359,  359,    0,
        0,    0,    0,    0,    0,    0,    0,  359,    0,    0,
        0,    0,    0,  359,    0,    0,    0,    0,    0,    0,

      359,  359,  359,  359,  359,  359,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  359,    0,    0,  359,
      359,  359,  359,  359,  359,  364,    0,    0,    0,    0,
        0,    0,  364,    0,  364,    0,    0,    0,    0,  364,
      364,    0,    0,  364,    0,    0,    0,    0,  364,    0,
        0,    0,    0,    0,  364,    0,    0,    0,    0,    0,
      364,    0,  364,    0,    0,    0,    0,  364,  364,    0,
        0,  364,  369,    0,    0,    0,    0,    0,    0,  369,
      369,  369,  369,  369,  369,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  369,  369,
      369,  369,  369,  369,  370,    0,    0,    0,    0,    0,
        0,  370,  370,  370,  370,  370,  370,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      370,  370,  370,  370,  370,  370,  371,    0,    0,    0,
        0,    0,    0,  371,  371,  371,  371,  371,  371,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,  371,  371,  371,  371,  371,  371,  383,    0,
        0,    0,    0,    0,    0,  383,  383,  383,  383,  383,
      383,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  383,  383,  383,  383,  383,  383,
      384,    0,    0,    0,    0,    0,    0,  384,  384,  384,
      384,  384,  384,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  384,  384,  384,  384,
      384,  384,  385,    0,    0,    0,    0,    0,    0,  385,

      385,  385,  385,  385,  385,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  385,  385,
      385,  385,  385,  385,  393,    0,    0,    0,    0,    0,
        0,  393,  393,  393,  393,  393,  393,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      393,  393,  393,  393,  393,  393,  394,    0,    0,    0,
        0,    0,    0,  394,  394,  394,  394,  394,  394,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  394,  394,  394,  394,  394,  394,  410,    0,
        0,    0,    0,    0,    0,  410,  410,  410,  410,  410,
      410,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  410,  410,  410,  410,  410,  410,
      422,    0,    0,    0,    0,    0,    0,  422,  422,  422,
      422,  422,  422,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  422,  422,  422,  422,

      422,  422,  424,  424,  424,  424,  424,    0,    0,    0,
        0,    0,    0,    0,    0,  424,    0,    0,    0,    0,
        0,  424,    0,    0,    0,    0,    0,    0,  424,  424,
      424,  424,  424,  424,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  424,    0,    0,  424,  424,  424,
      424,  424,  424,  433,  433,  433,  433,  433,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  433,    0,    0,    0,    0,    0,    0,  433,
      433,  433,  433,  433,  433,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  433,  433,
      433,  433,  433,  433,  435,    0,    0,    0,    0,    0,
        0,  435,  435,  435,  435,  435,  435,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      435,  435,  435,  435,  435,  435,  442,    0,    0,    0,
        0,    0,    0,  442,  442,  442,  442,  442,  442,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,  442,  442,  442,  442,  442,  442,  443,    0,
        0,    0,    0,    0,    0,  443,  443,  443,  443,  443,
      443,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  443,  443,  443,  443,  443,  443,
      448,    0,    0,    0,    0,    0,    0,  448,  448,  448,
      448,  448,  448,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  448,  448,  448,  448,
      448,  448,  449,    0,    0,    0,    0,    0,    0,  449,

      449,  449,  449,  449,  449,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  449,  449,
      449,  449,  449,  449,  454,    0,    0,    0,    0,    0,
        0,  454,  454,  454,  454,  454,  454,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      454,  454,  454,  454,  454,  454,  455,    0,    0,    0,
        0,    0,    0,  455,  455,  455,  455,  455,  455,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  455,  455,  455,  455,  455,  455,  460,    0,
        0,    0,    0,    0,    0,  460,  460,  460,  460,  460,
      460,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  460,  460,  460,  460,  460,  460,
      475,    0,    0,  475,  475,  475,  475,  475,  475,  475,
      475,  475,  475,  476,  476,    0,  476,  476,  477,    0,
        0,  477,  477,  477,  477,  477,  477,  477,  477,  477,
      477,  478,  478,    0,  478,  478,  479,    0,    0,  479,

      479,  480,    0,  480,  480,    0,  480,  480,  481,  481,
      481,  481,  481,  481,  481,  481,  481,  481,  482,  482,
      482,  482,  482,  482,  482,  482,  482,  482,  482,  482,
      482,  484,  484,    0,  484,  484,  485,  485,  485,  485,
      485,  485,  485,  485,  485,  485,  486,  486,  486,  486,
      486,  486,  486,  486,  486,  486,  486,  486,  486,  487,
      487,  487,  487,  487,  487,  487,  487,  487,  487,  487,
      487,  487,  487,  489,  489,    0,  489,  489,  490,  490,
      490,  490,  490,  490,  490,  490,  490,  490,  491,  491,
        0,  491,  491,  492,  492,  492,  492,  492,  492,  492,

      492,  492,  492,  493,  493,  493,  493,  493,  493,  493,
      493,  493,  493,  494,  494,  494,  496,  496,  496,  496,
      496,  496,  496,  496,  496,  496,  497,  497,    0,  497,
      497,  497,  497,  497,  497,  497,  497,  497,  497,  498,
      498,  498,  498,  498,  498,  498,  498,  498,  498,  498,
      498,  498,  499,  499,  499,  499,  499,  499,  499,  499,
      499,  499,  499,  499,  499,  499,  500,  500,  500,  500,
      500,  500,  500,  500,  500,  500,  500,  500,  500,  500,
      501,  501,  501,  501,  501,  501,  501,  501,  501,  501,
      502,  502,  502,  502,  502,  502,  502,  502,  502,  502,

      503,  503,  503,  503,  504,    0,    0,  504,  504,  504,
      504,  504,  504,  504,  504,  504,  504,  506,  506,  506,
      506,  506,  506,  506,  506,  506,  506,  506,  506,  506,
      506,  508,  508,  508,  508,  509,  509,  509,  509,  509,
      509,    0,  509,  509,  509,  509,  509,  509,  510,  510,
      510,  510,  510,  510,  510,  510,  510,  510,  510,  510,
      510,  512,  512,  512,  512,  512,  512,  512,  512,  512,
      512,  512,  512,  512,  512,  514,  514,  514,  514,  515,
      515,  515,  515,  515,  515,    0,  515,  515,  515,  515,
      515,  515,  516,    0,    0,  516,  516,  516,  516,  516,

      516,  516,  516,  516,  516,  517,    0,    0,  517,  517,
      517,  517,  517,  517,  517,  517,  517,  517,  518,  518,
      518,  518,  518,  518,  518,  518,  518,  518,  518,  518,
      518,  519,  519,  519,  519,  519,  519,  519,  519,  519,
      519,  519,  519,  519,  521,  521,    0,  521,  521,  522,
      522,  522,  522,  522,  522,  522,  522,  522,  522,  522,
      522,  522,  524,  524,  524,  524,  525,  525,  525,  525,
      525,  525,  525,  525,  525,  525,  525,  525,  525,  526,
        0,    0,  526,  526,  526,  526,  526,  526,  526,  526,
      526,  526,  527,  527,  527,  527,  527,  527,  527,  527,

      527,  527,  527,  527,  527,  528,  528,  528,  528,  528,
        0,    0,  528,  528,  528,  528,  528,  528,  529,  529,
      529,  529,  529,  529,  529,  529,  529,  529,  529,  529,
      529,  530,  530,  530,  530,  530,  530,  530,  530,  530,
      530,  530,  530,  530,  531,  531,    0,  531,  531,  532,
      532,  532,  532,  532,  532,  532,  532,  532,  532,  532,
      532,  532,  534,  534,  534,  534,  535,  535,    0,  535,
      535,  535,  535,  535,  535,  535,  535,  535,  535,  536,
      536,  536,  536,  536,  536,  536,  536,  536,  536,  536,
      536,  536,  537,  537,    0,  537,  537,  537,  537,  537,

      537,  537,  537,  537,  537,  538,  538,  538,  538,  538,
      538,  538,  538,  538,  538,  538,  538,  538,  539,  539,
      539,  539,  539,    0,    0,  539,  539,  539,  539,  539,
      539,  542,  542,  542,  542,    0,    0,    0,    0,  542,
        0,    0,  542,  542,  543,  543,  543,  543,    0,    0,
        0,  543,  543,  543,    0,  543,  543,  544,  544,  544,
      544,  544,  544,  544,  544,  544,  544,  545,  545,  545,
      545,  545,  545,  545,  545,  545,  545,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,

      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474
    } ;

#line 1 "<stdin>"
YY_DECL
{
	register yy_state_type yy_current_state;
	register UChar *yy_cp, *yy_bp;
	register int yy_act;
	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 475 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 6578 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 31 "<stdin>"
/* ignore comments */
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 33 "<stdin>"
{yyTok = WHITESPACE; return yyTok;}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 35 "<stdin>"
{yyTok = SGML_CD; return yyTok;}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 36 "<stdin>"
{yyTok = SGML_CD; return yyTok;}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 37 "<stdin>"
{yyTok = INCLUDES; return yyTok;}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 38 "<stdin>"
{yyTok = DASHMATCH; return yyTok;}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 39 "<stdin>"
{yyTok = BEGINSWITH; return yyTok;}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 40 "<stdin>"
{yyTok = ENDSWITH; return yyTok;}
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 41 "<stdin>"
{yyTok = CONTAINS; return yyTok;}
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 42 "<stdin>"
{yyTok = MEDIA_NOT; return yyTok;}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 43 "<stdin>"
{yyTok = MEDIA_ONLY; return yyTok;}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 44 "<stdin>"
{yyTok = MEDIA_AND; return yyTok;}
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 45 "<stdin>"
{BEGIN(mediaquery); yyTok = VARIABLES_FOR; return yyTok; }
	YY_BREAK
case 14:
/* rule 14 can match eol */
YY_RULE_SETUP
#line 47 "<stdin>"
{yyTok = STRING; return yyTok;}
	YY_BREAK
case 15:
/* rule 15 can match eol */
YY_RULE_SETUP
#line 48 "<stdin>"
{yyTok = IDENT; return yyTok;}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 49 "<stdin>"
{yyTok = NTH; return yyTok;}
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 51 "<stdin>"
{yyTok = HEX; return yyTok;}
	YY_BREAK
case 18:
/* rule 18 can match eol */
YY_RULE_SETUP
#line 52 "<stdin>"
{yyTok = IDSEL; return yyTok;}
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 54 "<stdin>"
{BEGIN(mediaquery); yyTok = IMPORT_SYM; return yyTok;}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 55 "<stdin>"
{yyTok = PAGE_SYM; return yyTok;}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 56 "<stdin>"
{BEGIN(mediaquery); yyTok = MEDIA_SYM; return yyTok;}
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 57 "<stdin>"
{yyTok = FONT_FACE_SYM; return yyTok;}
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 58 "<stdin>"
{yyTok = CHARSET_SYM; return yyTok;}
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 59 "<stdin>"
{yyTok = NAMESPACE_SYM; return yyTok; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 60 "<stdin>"
{yyTok = WEBKIT_RULE_SYM; return yyTok; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 61 "<stdin>"
{yyTok = WEBKIT_DECLS_SYM; return yyTok; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 62 "<stdin>"
{yyTok = WEBKIT_VALUE_SYM; return yyTok; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 63 "<stdin>"
{BEGIN(mediaquery); yyTok = WEBKIT_MEDIAQUERY_SYM; return yyTok; }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 64 "<stdin>"
{yyTok = WEBKIT_SELECTOR_SYM; return yyTok; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 65 "<stdin>"
{BEGIN(mediaquery); yyTok = WEBKIT_VARIABLES_SYM; return yyTok; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 66 "<stdin>"
{BEGIN(forkeyword); yyTok = WEBKIT_DEFINE_SYM; return yyTok; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 67 "<stdin>"
{ yyTok = WEBKIT_VARIABLES_DECLS_SYM; return yyTok; }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 68 "<stdin>"
{yyTok = WEBKIT_KEYFRAMES_SYM; return yyTok; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 69 "<stdin>"
{yyTok = WEBKIT_KEYFRAME_RULE_SYM; return yyTok; }
	YY_BREAK
case 35:
/* rule 35 can match eol */
YY_RULE_SETUP
#line 71 "<stdin>"
{yyTok = ATKEYWORD; return yyTok; }
	YY_BREAK
case 36:
/* rule 36 can match eol */
YY_RULE_SETUP
#line 73 "<stdin>"
{yyTok = IMPORTANT_SYM; return yyTok;}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 75 "<stdin>"
{yyTok = EMS; return yyTok;}
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 76 "<stdin>"
{yyTok = QEMS; return yyTok;} /* quirky ems */
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 77 "<stdin>"
{yyTok = EXS; return yyTok;}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 78 "<stdin>"
{yyTok = PXS; return yyTok;}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 79 "<stdin>"
{yyTok = CMS; return yyTok;}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 80 "<stdin>"
{yyTok = MMS; return yyTok;}
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 81 "<stdin>"
{yyTok = INS; return yyTok;}
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 82 "<stdin>"
{yyTok = PTS; return yyTok;}
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 83 "<stdin>"
{yyTok = PCS; return yyTok;}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 84 "<stdin>"
{yyTok = DEGS; return yyTok;}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 85 "<stdin>"
{yyTok = RADS; return yyTok;}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 86 "<stdin>"
{yyTok = GRADS; return yyTok;}
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 87 "<stdin>"
{yyTok = MSECS; return yyTok;}
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 88 "<stdin>"
{yyTok = SECS; return yyTok;}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 89 "<stdin>"
{yyTok = HERZ; return yyTok;}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 90 "<stdin>"
{yyTok = KHERZ; return yyTok;}
	YY_BREAK
case 53:
/* rule 53 can match eol */
YY_RULE_SETUP
#line 91 "<stdin>"
{yyTok = DIMEN; return yyTok;}
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 92 "<stdin>"
{yyTok = PERCENTAGE; return yyTok;}
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 93 "<stdin>"
{yyTok = INTEGER; return yyTok;}
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 94 "<stdin>"
{yyTok = FLOATTOKEN; return yyTok;}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 96 "<stdin>"
{yyTok = NOTFUNCTION; return yyTok;}
	YY_BREAK
case 58:
/* rule 58 can match eol */
YY_RULE_SETUP
#line 97 "<stdin>"
{yyTok = URI; return yyTok;}
	YY_BREAK
case 59:
/* rule 59 can match eol */
YY_RULE_SETUP
#line 98 "<stdin>"
{yyTok = URI; return yyTok;}
	YY_BREAK
case 60:
/* rule 60 can match eol */
YY_RULE_SETUP
#line 99 "<stdin>"
{ yyTok = VARCALL; return yyTok; }
	YY_BREAK
case 61:
/* rule 61 can match eol */
YY_RULE_SETUP
#line 100 "<stdin>"
{yyTok = FUNCTION; return yyTok;}
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 102 "<stdin>"
{yyTok = UNICODERANGE; return yyTok;}
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 103 "<stdin>"
{yyTok = UNICODERANGE; return yyTok;}
	YY_BREAK
case 64:
#line 106 "<stdin>"
case 65:
YY_RULE_SETUP
#line 106 "<stdin>"
{BEGIN(INITIAL); yyTok = *yytext; return yyTok; }
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 107 "<stdin>"
{yyTok = *yytext; return yyTok;}
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 109 "<stdin>"
ECHO;
	YY_BREAK
#line 2720 "<stdout>"
case YY_STATE_EOF(INITIAL):
case YY_END_OF_BUFFER:
case YY_STATE_EOF(mediaquery):
case YY_STATE_EOF(forkeyword):
	yyterminate();

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of yylex */
