/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(XPATH)

#include "JSXPathResult.h"

#include <wtf/GetPtr.h>

#include "JSNode.h"
#include "KURL.h"
#include "Node.h"
#include "XPathResult.h"

#include <kjs/Error.h>
#include <kjs/JSNumberCell.h>
#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSXPathResult)

/* Hash table */

static const HashTableValue JSXPathResultTableValues[9] =
{
    { "resultType", DontDelete|ReadOnly, (intptr_t)jsXPathResultResultType, (intptr_t)0 },
    { "numberValue", DontDelete|ReadOnly, (intptr_t)jsXPathResultNumberValue, (intptr_t)0 },
    { "stringValue", DontDelete|ReadOnly, (intptr_t)jsXPathResultStringValue, (intptr_t)0 },
    { "booleanValue", DontDelete|ReadOnly, (intptr_t)jsXPathResultBooleanValue, (intptr_t)0 },
    { "singleNodeValue", DontDelete|ReadOnly, (intptr_t)jsXPathResultSingleNodeValue, (intptr_t)0 },
    { "invalidIteratorState", DontDelete|ReadOnly, (intptr_t)jsXPathResultInvalidIteratorState, (intptr_t)0 },
    { "snapshotLength", DontDelete|ReadOnly, (intptr_t)jsXPathResultSnapshotLength, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsXPathResultConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSXPathResultTable = { 63, JSXPathResultTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSXPathResultConstructorTableValues[11] =
{
    { "ANY_TYPE", DontDelete|ReadOnly, (intptr_t)jsXPathResultANY_TYPE, (intptr_t)0 },
    { "NUMBER_TYPE", DontDelete|ReadOnly, (intptr_t)jsXPathResultNUMBER_TYPE, (intptr_t)0 },
    { "STRING_TYPE", DontDelete|ReadOnly, (intptr_t)jsXPathResultSTRING_TYPE, (intptr_t)0 },
    { "BOOLEAN_TYPE", DontDelete|ReadOnly, (intptr_t)jsXPathResultBOOLEAN_TYPE, (intptr_t)0 },
    { "UNORDERED_NODE_ITERATOR_TYPE", DontDelete|ReadOnly, (intptr_t)jsXPathResultUNORDERED_NODE_ITERATOR_TYPE, (intptr_t)0 },
    { "ORDERED_NODE_ITERATOR_TYPE", DontDelete|ReadOnly, (intptr_t)jsXPathResultORDERED_NODE_ITERATOR_TYPE, (intptr_t)0 },
    { "UNORDERED_NODE_SNAPSHOT_TYPE", DontDelete|ReadOnly, (intptr_t)jsXPathResultUNORDERED_NODE_SNAPSHOT_TYPE, (intptr_t)0 },
    { "ORDERED_NODE_SNAPSHOT_TYPE", DontDelete|ReadOnly, (intptr_t)jsXPathResultORDERED_NODE_SNAPSHOT_TYPE, (intptr_t)0 },
    { "ANY_UNORDERED_NODE_TYPE", DontDelete|ReadOnly, (intptr_t)jsXPathResultANY_UNORDERED_NODE_TYPE, (intptr_t)0 },
    { "FIRST_ORDERED_NODE_TYPE", DontDelete|ReadOnly, (intptr_t)jsXPathResultFIRST_ORDERED_NODE_TYPE, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSXPathResultConstructorTable = { 127, JSXPathResultConstructorTableValues, 0 };

class JSXPathResultConstructor : public DOMObject {
public:
    JSXPathResultConstructor(ExecState* exec)
        : DOMObject(JSXPathResultConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSXPathResultPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSXPathResultConstructor::s_info = { "XPathResultConstructor", 0, &JSXPathResultConstructorTable, 0 };

bool JSXPathResultConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXPathResultConstructor, DOMObject>(exec, &JSXPathResultConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSXPathResultPrototypeTableValues[13] =
{
    { "ANY_TYPE", DontDelete|ReadOnly, (intptr_t)jsXPathResultANY_TYPE, (intptr_t)0 },
    { "NUMBER_TYPE", DontDelete|ReadOnly, (intptr_t)jsXPathResultNUMBER_TYPE, (intptr_t)0 },
    { "STRING_TYPE", DontDelete|ReadOnly, (intptr_t)jsXPathResultSTRING_TYPE, (intptr_t)0 },
    { "BOOLEAN_TYPE", DontDelete|ReadOnly, (intptr_t)jsXPathResultBOOLEAN_TYPE, (intptr_t)0 },
    { "UNORDERED_NODE_ITERATOR_TYPE", DontDelete|ReadOnly, (intptr_t)jsXPathResultUNORDERED_NODE_ITERATOR_TYPE, (intptr_t)0 },
    { "ORDERED_NODE_ITERATOR_TYPE", DontDelete|ReadOnly, (intptr_t)jsXPathResultORDERED_NODE_ITERATOR_TYPE, (intptr_t)0 },
    { "UNORDERED_NODE_SNAPSHOT_TYPE", DontDelete|ReadOnly, (intptr_t)jsXPathResultUNORDERED_NODE_SNAPSHOT_TYPE, (intptr_t)0 },
    { "ORDERED_NODE_SNAPSHOT_TYPE", DontDelete|ReadOnly, (intptr_t)jsXPathResultORDERED_NODE_SNAPSHOT_TYPE, (intptr_t)0 },
    { "ANY_UNORDERED_NODE_TYPE", DontDelete|ReadOnly, (intptr_t)jsXPathResultANY_UNORDERED_NODE_TYPE, (intptr_t)0 },
    { "FIRST_ORDERED_NODE_TYPE", DontDelete|ReadOnly, (intptr_t)jsXPathResultFIRST_ORDERED_NODE_TYPE, (intptr_t)0 },
    { "iterateNext", DontDelete|Function, (intptr_t)jsXPathResultPrototypeFunctionIterateNext, (intptr_t)0 },
    { "snapshotItem", DontDelete|Function, (intptr_t)jsXPathResultPrototypeFunctionSnapshotItem, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSXPathResultPrototypeTable = { 127, JSXPathResultPrototypeTableValues, 0 };

const ClassInfo JSXPathResultPrototype::s_info = { "XPathResultPrototype", 0, &JSXPathResultPrototypeTable, 0 };

JSObject* JSXPathResultPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSXPathResult>(exec);
}

bool JSXPathResultPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSXPathResultPrototype, JSObject>(exec, &JSXPathResultPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSXPathResult::s_info = { "XPathResult", 0, &JSXPathResultTable , 0 };

JSXPathResult::JSXPathResult(PassRefPtr<StructureID> structure, PassRefPtr<XPathResult> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSXPathResult::~JSXPathResult()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSXPathResult::createPrototype(ExecState* exec)
{
    return new (exec) JSXPathResultPrototype(JSXPathResultPrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSXPathResult::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXPathResult, Base>(exec, &JSXPathResultTable, this, propertyName, slot);
}

JSValue* jsXPathResultResultType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    XPathResult* imp = static_cast<XPathResult*>(static_cast<JSXPathResult*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->resultType());
}

JSValue* jsXPathResultNumberValue(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    ExceptionCode ec = 0;
    XPathResult* imp = static_cast<XPathResult*>(static_cast<JSXPathResult*>(slot.slotBase())->impl());
    JSC::JSValue* result = jsNumber(exec, imp->numberValue(ec));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsXPathResultStringValue(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    ExceptionCode ec = 0;
    XPathResult* imp = static_cast<XPathResult*>(static_cast<JSXPathResult*>(slot.slotBase())->impl());
    JSC::JSValue* result = jsString(exec, imp->stringValue(ec));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsXPathResultBooleanValue(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    ExceptionCode ec = 0;
    XPathResult* imp = static_cast<XPathResult*>(static_cast<JSXPathResult*>(slot.slotBase())->impl());
    JSC::JSValue* result = jsBoolean(imp->booleanValue(ec));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsXPathResultSingleNodeValue(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    ExceptionCode ec = 0;
    XPathResult* imp = static_cast<XPathResult*>(static_cast<JSXPathResult*>(slot.slotBase())->impl());
    JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->singleNodeValue(ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsXPathResultInvalidIteratorState(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    XPathResult* imp = static_cast<XPathResult*>(static_cast<JSXPathResult*>(slot.slotBase())->impl());
    return jsBoolean(imp->invalidIteratorState());
}

JSValue* jsXPathResultSnapshotLength(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    ExceptionCode ec = 0;
    XPathResult* imp = static_cast<XPathResult*>(static_cast<JSXPathResult*>(slot.slotBase())->impl());
    JSC::JSValue* result = jsNumber(exec, imp->snapshotLength(ec));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsXPathResultConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSXPathResult*>(slot.slotBase())->getConstructor(exec);
}
JSValue* JSXPathResult::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSXPathResultConstructor>(exec);
}

JSValue* jsXPathResultPrototypeFunctionIterateNext(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSXPathResult::s_info))
        return throwError(exec, TypeError);
    JSXPathResult* castedThisObj = static_cast<JSXPathResult*>(thisValue);
    XPathResult* imp = static_cast<XPathResult*>(castedThisObj->impl());
    ExceptionCode ec = 0;


    JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->iterateNext(ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsXPathResultPrototypeFunctionSnapshotItem(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSXPathResult::s_info))
        return throwError(exec, TypeError);
    JSXPathResult* castedThisObj = static_cast<JSXPathResult*>(thisValue);
    XPathResult* imp = static_cast<XPathResult*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    unsigned index = args.at(exec, 0)->toInt32(exec);


    JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->snapshotItem(index, ec)));
    setDOMException(exec, ec);
    return result;
}

// Constant getters

JSValue* jsXPathResultANY_TYPE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue* jsXPathResultNUMBER_TYPE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue* jsXPathResultSTRING_TYPE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValue* jsXPathResultBOOLEAN_TYPE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(3));
}

JSValue* jsXPathResultUNORDERED_NODE_ITERATOR_TYPE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(4));
}

JSValue* jsXPathResultORDERED_NODE_ITERATOR_TYPE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(5));
}

JSValue* jsXPathResultUNORDERED_NODE_SNAPSHOT_TYPE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(6));
}

JSValue* jsXPathResultORDERED_NODE_SNAPSHOT_TYPE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(7));
}

JSValue* jsXPathResultANY_UNORDERED_NODE_TYPE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(8));
}

JSValue* jsXPathResultFIRST_ORDERED_NODE_TYPE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(9));
}

JSC::JSValue* toJS(JSC::ExecState* exec, XPathResult* object)
{
    return getDOMObjectWrapper<JSXPathResult>(exec, object);
}
XPathResult* toXPathResult(JSC::JSValue* val)
{
    return val->isObject(&JSXPathResult::s_info) ? static_cast<JSXPathResult*>(val)->impl() : 0;
}

}

#endif // ENABLE(XPATH)
