/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(XPATH)

#include "JSXPathEvaluator.h"

#include <wtf/GetPtr.h>

#include "JSCustomXPathNSResolver.h"
#include "JSNode.h"
#include "JSXPathExpression.h"
#include "JSXPathNSResolver.h"
#include "JSXPathResult.h"
#include "PlatformString.h"
#include "XPathEvaluator.h"
#include "XPathExpression.h"
#include "XPathNSResolver.h"
#include "XPathResult.h"

#include <kjs/Error.h>
#include <kjs/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSXPathEvaluator)

/* Hash table */

static const HashTableValue JSXPathEvaluatorTableValues[2] =
{
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsXPathEvaluatorConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSXPathEvaluatorTable = { 0, JSXPathEvaluatorTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSXPathEvaluatorConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSXPathEvaluatorConstructorTable = { 0, JSXPathEvaluatorConstructorTableValues, 0 };

class JSXPathEvaluatorConstructor : public DOMObject {
public:
    JSXPathEvaluatorConstructor(ExecState* exec)
        : DOMObject(JSXPathEvaluatorConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSXPathEvaluatorPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
    static JSObject* construct(ExecState* exec, JSObject*, const ArgList&)
    {
        return static_cast<JSObject*>(toJS(exec, XPathEvaluator::create()));
    }
    virtual ConstructType getConstructData(ConstructData& constructData)
    {
        constructData.native.function = construct;
        return ConstructTypeHost;
    }
};

const ClassInfo JSXPathEvaluatorConstructor::s_info = { "XPathEvaluatorConstructor", 0, &JSXPathEvaluatorConstructorTable, 0 };

bool JSXPathEvaluatorConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXPathEvaluatorConstructor, DOMObject>(exec, &JSXPathEvaluatorConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSXPathEvaluatorPrototypeTableValues[4] =
{
    { "createExpression", DontDelete|Function, (intptr_t)jsXPathEvaluatorPrototypeFunctionCreateExpression, (intptr_t)2 },
    { "createNSResolver", DontDelete|Function, (intptr_t)jsXPathEvaluatorPrototypeFunctionCreateNSResolver, (intptr_t)1 },
    { "evaluate", DontDelete|Function, (intptr_t)jsXPathEvaluatorPrototypeFunctionEvaluate, (intptr_t)5 },
    { 0, 0, 0, 0 }
};

static const HashTable JSXPathEvaluatorPrototypeTable = { 3, JSXPathEvaluatorPrototypeTableValues, 0 };

const ClassInfo JSXPathEvaluatorPrototype::s_info = { "XPathEvaluatorPrototype", 0, &JSXPathEvaluatorPrototypeTable, 0 };

JSObject* JSXPathEvaluatorPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSXPathEvaluator>(exec);
}

bool JSXPathEvaluatorPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSXPathEvaluatorPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSXPathEvaluator::s_info = { "XPathEvaluator", 0, &JSXPathEvaluatorTable , 0 };

JSXPathEvaluator::JSXPathEvaluator(PassRefPtr<StructureID> structure, PassRefPtr<XPathEvaluator> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSXPathEvaluator::~JSXPathEvaluator()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSXPathEvaluator::createPrototype(ExecState* exec)
{
    return new (exec) JSXPathEvaluatorPrototype(JSXPathEvaluatorPrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSXPathEvaluator::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXPathEvaluator, Base>(exec, &JSXPathEvaluatorTable, this, propertyName, slot);
}

JSValue* jsXPathEvaluatorConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSXPathEvaluator*>(slot.slotBase())->getConstructor(exec);
}
JSValue* JSXPathEvaluator::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSXPathEvaluatorConstructor>(exec);
}

JSValue* jsXPathEvaluatorPrototypeFunctionCreateExpression(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSXPathEvaluator::s_info))
        return throwError(exec, TypeError);
    JSXPathEvaluator* castedThisObj = static_cast<JSXPathEvaluator*>(thisValue);
    XPathEvaluator* imp = static_cast<XPathEvaluator*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& expression = args.at(exec, 0)->toString(exec);
    RefPtr<XPathNSResolver> customResolver;
    XPathNSResolver* resolver = toXPathNSResolver(args.at(exec, 1));
    if (!resolver) {
        customResolver = JSCustomXPathNSResolver::create(exec, args.at(exec, 1));
        if (exec->hadException())
            return jsUndefined();
        resolver = customResolver.get();
    }


    JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->createExpression(expression, resolver, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsXPathEvaluatorPrototypeFunctionCreateNSResolver(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSXPathEvaluator::s_info))
        return throwError(exec, TypeError);
    JSXPathEvaluator* castedThisObj = static_cast<JSXPathEvaluator*>(thisValue);
    XPathEvaluator* imp = static_cast<XPathEvaluator*>(castedThisObj->impl());
    Node* nodeResolver = toNode(args.at(exec, 0));


    JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->createNSResolver(nodeResolver)));
    return result;
}

JSValue* jsXPathEvaluatorPrototypeFunctionEvaluate(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSXPathEvaluator::s_info))
        return throwError(exec, TypeError);
    JSXPathEvaluator* castedThisObj = static_cast<JSXPathEvaluator*>(thisValue);
    XPathEvaluator* imp = static_cast<XPathEvaluator*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& expression = args.at(exec, 0)->toString(exec);
    Node* contextNode = toNode(args.at(exec, 1));
    RefPtr<XPathNSResolver> customResolver;
    XPathNSResolver* resolver = toXPathNSResolver(args.at(exec, 2));
    if (!resolver) {
        customResolver = JSCustomXPathNSResolver::create(exec, args.at(exec, 2));
        if (exec->hadException())
            return jsUndefined();
        resolver = customResolver.get();
    }
    unsigned short type = args.at(exec, 3)->toInt32(exec);
    XPathResult* inResult = toXPathResult(args.at(exec, 4));


    JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->evaluate(expression, contextNode, resolver, type, inResult, ec)));
    setDOMException(exec, ec);
    return result;
}

JSC::JSValue* toJS(JSC::ExecState* exec, XPathEvaluator* object)
{
    return getDOMObjectWrapper<JSXPathEvaluator>(exec, object);
}
XPathEvaluator* toXPathEvaluator(JSC::JSValue* val)
{
    return val->isObject(&JSXPathEvaluator::s_info) ? static_cast<JSXPathEvaluator*>(val)->impl() : 0;
}

}

#endif // ENABLE(XPATH)
