/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSWheelEvent.h"

#include <wtf/GetPtr.h>

#include "WheelEvent.h"

#include <kjs/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSWheelEvent)

/* Hash table */

static const HashTableValue JSWheelEventTableValues[17] =
{
    { "screenX", DontDelete|ReadOnly, (intptr_t)jsWheelEventScreenX, (intptr_t)0 },
    { "screenY", DontDelete|ReadOnly, (intptr_t)jsWheelEventScreenY, (intptr_t)0 },
    { "clientX", DontDelete|ReadOnly, (intptr_t)jsWheelEventClientX, (intptr_t)0 },
    { "clientY", DontDelete|ReadOnly, (intptr_t)jsWheelEventClientY, (intptr_t)0 },
    { "ctrlKey", DontDelete|ReadOnly, (intptr_t)jsWheelEventCtrlKey, (intptr_t)0 },
    { "shiftKey", DontDelete|ReadOnly, (intptr_t)jsWheelEventShiftKey, (intptr_t)0 },
    { "altKey", DontDelete|ReadOnly, (intptr_t)jsWheelEventAltKey, (intptr_t)0 },
    { "metaKey", DontDelete|ReadOnly, (intptr_t)jsWheelEventMetaKey, (intptr_t)0 },
    { "wheelDelta", DontDelete|ReadOnly, (intptr_t)jsWheelEventWheelDelta, (intptr_t)0 },
    { "wheelDeltaX", DontDelete|ReadOnly, (intptr_t)jsWheelEventWheelDeltaX, (intptr_t)0 },
    { "wheelDeltaY", DontDelete|ReadOnly, (intptr_t)jsWheelEventWheelDeltaY, (intptr_t)0 },
    { "offsetX", DontDelete|ReadOnly, (intptr_t)jsWheelEventOffsetX, (intptr_t)0 },
    { "offsetY", DontDelete|ReadOnly, (intptr_t)jsWheelEventOffsetY, (intptr_t)0 },
    { "x", DontDelete|ReadOnly, (intptr_t)jsWheelEventX, (intptr_t)0 },
    { "y", DontDelete|ReadOnly, (intptr_t)jsWheelEventY, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsWheelEventConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSWheelEventTable = { 127, JSWheelEventTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSWheelEventConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSWheelEventConstructorTable = { 0, JSWheelEventConstructorTableValues, 0 };

class JSWheelEventConstructor : public DOMObject {
public:
    JSWheelEventConstructor(ExecState* exec)
        : DOMObject(JSWheelEventConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSWheelEventPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSWheelEventConstructor::s_info = { "WheelEventConstructor", 0, &JSWheelEventConstructorTable, 0 };

bool JSWheelEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWheelEventConstructor, DOMObject>(exec, &JSWheelEventConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSWheelEventPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSWheelEventPrototypeTable = { 0, JSWheelEventPrototypeTableValues, 0 };

const ClassInfo JSWheelEventPrototype::s_info = { "WheelEventPrototype", 0, &JSWheelEventPrototypeTable, 0 };

JSObject* JSWheelEventPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSWheelEvent>(exec);
}

const ClassInfo JSWheelEvent::s_info = { "WheelEvent", &JSUIEvent::s_info, &JSWheelEventTable , 0 };

JSWheelEvent::JSWheelEvent(PassRefPtr<StructureID> structure, PassRefPtr<WheelEvent> impl)
    : JSUIEvent(structure, impl)
{
}

JSObject* JSWheelEvent::createPrototype(ExecState* exec)
{
    return new (exec) JSWheelEventPrototype(JSWheelEventPrototype::createStructureID(JSUIEventPrototype::self(exec)));
}

bool JSWheelEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWheelEvent, Base>(exec, &JSWheelEventTable, this, propertyName, slot);
}

JSValue* jsWheelEventScreenX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WheelEvent* imp = static_cast<WheelEvent*>(static_cast<JSWheelEvent*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->screenX());
}

JSValue* jsWheelEventScreenY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WheelEvent* imp = static_cast<WheelEvent*>(static_cast<JSWheelEvent*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->screenY());
}

JSValue* jsWheelEventClientX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WheelEvent* imp = static_cast<WheelEvent*>(static_cast<JSWheelEvent*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->clientX());
}

JSValue* jsWheelEventClientY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WheelEvent* imp = static_cast<WheelEvent*>(static_cast<JSWheelEvent*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->clientY());
}

JSValue* jsWheelEventCtrlKey(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WheelEvent* imp = static_cast<WheelEvent*>(static_cast<JSWheelEvent*>(slot.slotBase())->impl());
    return jsBoolean(imp->ctrlKey());
}

JSValue* jsWheelEventShiftKey(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WheelEvent* imp = static_cast<WheelEvent*>(static_cast<JSWheelEvent*>(slot.slotBase())->impl());
    return jsBoolean(imp->shiftKey());
}

JSValue* jsWheelEventAltKey(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WheelEvent* imp = static_cast<WheelEvent*>(static_cast<JSWheelEvent*>(slot.slotBase())->impl());
    return jsBoolean(imp->altKey());
}

JSValue* jsWheelEventMetaKey(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WheelEvent* imp = static_cast<WheelEvent*>(static_cast<JSWheelEvent*>(slot.slotBase())->impl());
    return jsBoolean(imp->metaKey());
}

JSValue* jsWheelEventWheelDelta(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WheelEvent* imp = static_cast<WheelEvent*>(static_cast<JSWheelEvent*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->wheelDelta());
}

JSValue* jsWheelEventWheelDeltaX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WheelEvent* imp = static_cast<WheelEvent*>(static_cast<JSWheelEvent*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->wheelDeltaX());
}

JSValue* jsWheelEventWheelDeltaY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WheelEvent* imp = static_cast<WheelEvent*>(static_cast<JSWheelEvent*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->wheelDeltaY());
}

JSValue* jsWheelEventOffsetX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WheelEvent* imp = static_cast<WheelEvent*>(static_cast<JSWheelEvent*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->offsetX());
}

JSValue* jsWheelEventOffsetY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WheelEvent* imp = static_cast<WheelEvent*>(static_cast<JSWheelEvent*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->offsetY());
}

JSValue* jsWheelEventX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WheelEvent* imp = static_cast<WheelEvent*>(static_cast<JSWheelEvent*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->x());
}

JSValue* jsWheelEventY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WheelEvent* imp = static_cast<WheelEvent*>(static_cast<JSWheelEvent*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->y());
}

JSValue* jsWheelEventConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSWheelEvent*>(slot.slotBase())->getConstructor(exec);
}
JSValue* JSWheelEvent::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSWheelEventConstructor>(exec);
}


}
