/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGPreserveAspectRatio.h"

#include <wtf/GetPtr.h>

#include "SVGPreserveAspectRatio.h"

#include <kjs/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGPreserveAspectRatio)

/* Hash table */

static const HashTableValue JSSVGPreserveAspectRatioTableValues[4] =
{
    { "align", DontDelete, (intptr_t)jsSVGPreserveAspectRatioAlign, (intptr_t)setJSSVGPreserveAspectRatioAlign },
    { "meetOrSlice", DontDelete, (intptr_t)jsSVGPreserveAspectRatioMeetOrSlice, (intptr_t)setJSSVGPreserveAspectRatioMeetOrSlice },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGPreserveAspectRatioTable = { 7, JSSVGPreserveAspectRatioTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSSVGPreserveAspectRatioConstructorTableValues[15] =
{
    { "SVG_PRESERVEASPECTRATIO_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_UNKNOWN, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_NONE", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_NONE, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMINYMIN", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMINYMIN, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMIDYMIN", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMIDYMIN, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMAXYMIN", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMAXYMIN, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMINYMID", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMINYMID, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMIDYMID", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMIDYMID, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMAXYMID", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMAXYMID, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMINYMAX", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMINYMAX, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMIDYMAX", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMIDYMAX, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMAXYMAX", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMAXYMAX, (intptr_t)0 },
    { "SVG_MEETORSLICE_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_MEETORSLICE_UNKNOWN, (intptr_t)0 },
    { "SVG_MEETORSLICE_MEET", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_MEETORSLICE_MEET, (intptr_t)0 },
    { "SVG_MEETORSLICE_SLICE", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_MEETORSLICE_SLICE, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGPreserveAspectRatioConstructorTable = { 127, JSSVGPreserveAspectRatioConstructorTableValues, 0 };

class JSSVGPreserveAspectRatioConstructor : public DOMObject {
public:
    JSSVGPreserveAspectRatioConstructor(ExecState* exec)
        : DOMObject(JSSVGPreserveAspectRatioConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSSVGPreserveAspectRatioPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSSVGPreserveAspectRatioConstructor::s_info = { "SVGPreserveAspectRatioConstructor", 0, &JSSVGPreserveAspectRatioConstructorTable, 0 };

bool JSSVGPreserveAspectRatioConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPreserveAspectRatioConstructor, DOMObject>(exec, &JSSVGPreserveAspectRatioConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSSVGPreserveAspectRatioPrototypeTableValues[15] =
{
    { "SVG_PRESERVEASPECTRATIO_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_UNKNOWN, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_NONE", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_NONE, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMINYMIN", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMINYMIN, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMIDYMIN", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMIDYMIN, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMAXYMIN", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMAXYMIN, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMINYMID", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMINYMID, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMIDYMID", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMIDYMID, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMAXYMID", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMAXYMID, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMINYMAX", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMINYMAX, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMIDYMAX", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMIDYMAX, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMAXYMAX", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMAXYMAX, (intptr_t)0 },
    { "SVG_MEETORSLICE_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_MEETORSLICE_UNKNOWN, (intptr_t)0 },
    { "SVG_MEETORSLICE_MEET", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_MEETORSLICE_MEET, (intptr_t)0 },
    { "SVG_MEETORSLICE_SLICE", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_MEETORSLICE_SLICE, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGPreserveAspectRatioPrototypeTable = { 127, JSSVGPreserveAspectRatioPrototypeTableValues, 0 };

const ClassInfo JSSVGPreserveAspectRatioPrototype::s_info = { "SVGPreserveAspectRatioPrototype", 0, &JSSVGPreserveAspectRatioPrototypeTable, 0 };

JSObject* JSSVGPreserveAspectRatioPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSVGPreserveAspectRatio>(exec);
}

bool JSSVGPreserveAspectRatioPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPreserveAspectRatioPrototype, JSObject>(exec, &JSSVGPreserveAspectRatioPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGPreserveAspectRatio::s_info = { "SVGPreserveAspectRatio", 0, &JSSVGPreserveAspectRatioTable , 0 };

JSSVGPreserveAspectRatio::JSSVGPreserveAspectRatio(PassRefPtr<StructureID> structure, PassRefPtr<SVGPreserveAspectRatio> impl, SVGElement* context)
    : DOMObject(structure)
    , m_context(context)
    , m_impl(impl)
{
}

JSSVGPreserveAspectRatio::~JSSVGPreserveAspectRatio()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSSVGPreserveAspectRatio::createPrototype(ExecState* exec)
{
    return new (exec) JSSVGPreserveAspectRatioPrototype(JSSVGPreserveAspectRatioPrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSSVGPreserveAspectRatio::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPreserveAspectRatio, Base>(exec, &JSSVGPreserveAspectRatioTable, this, propertyName, slot);
}

JSValue* jsSVGPreserveAspectRatioAlign(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGPreserveAspectRatio* imp = static_cast<SVGPreserveAspectRatio*>(static_cast<JSSVGPreserveAspectRatio*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->align());
}

JSValue* jsSVGPreserveAspectRatioMeetOrSlice(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGPreserveAspectRatio* imp = static_cast<SVGPreserveAspectRatio*>(static_cast<JSSVGPreserveAspectRatio*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->meetOrSlice());
}

JSValue* jsSVGPreserveAspectRatioConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSSVGPreserveAspectRatio*>(slot.slotBase())->getConstructor(exec);
}
void JSSVGPreserveAspectRatio::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSSVGPreserveAspectRatio, Base>(exec, propertyName, value, &JSSVGPreserveAspectRatioTable, this, slot);
}

void setJSSVGPreserveAspectRatioAlign(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    SVGPreserveAspectRatio* imp = static_cast<SVGPreserveAspectRatio*>(static_cast<JSSVGPreserveAspectRatio*>(thisObject)->impl());
    imp->setAlign(value->toInt32(exec));
    if (static_cast<JSSVGPreserveAspectRatio*>(thisObject)->context())
        static_cast<JSSVGPreserveAspectRatio*>(thisObject)->context()->svgAttributeChanged(static_cast<JSSVGPreserveAspectRatio*>(thisObject)->impl()->associatedAttributeName());
}

void setJSSVGPreserveAspectRatioMeetOrSlice(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    SVGPreserveAspectRatio* imp = static_cast<SVGPreserveAspectRatio*>(static_cast<JSSVGPreserveAspectRatio*>(thisObject)->impl());
    imp->setMeetOrSlice(value->toInt32(exec));
    if (static_cast<JSSVGPreserveAspectRatio*>(thisObject)->context())
        static_cast<JSSVGPreserveAspectRatio*>(thisObject)->context()->svgAttributeChanged(static_cast<JSSVGPreserveAspectRatio*>(thisObject)->impl()->associatedAttributeName());
}

JSValue* JSSVGPreserveAspectRatio::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSSVGPreserveAspectRatioConstructor>(exec);
}

// Constant getters

JSValue* jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_UNKNOWN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue* jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_NONE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue* jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMINYMIN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValue* jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMIDYMIN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(3));
}

JSValue* jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMAXYMIN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(4));
}

JSValue* jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMINYMID(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(5));
}

JSValue* jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMIDYMID(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(6));
}

JSValue* jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMAXYMID(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(7));
}

JSValue* jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMINYMAX(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(8));
}

JSValue* jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMIDYMAX(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(9));
}

JSValue* jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMAXYMAX(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(10));
}

JSValue* jsSVGPreserveAspectRatioSVG_MEETORSLICE_UNKNOWN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue* jsSVGPreserveAspectRatioSVG_MEETORSLICE_MEET(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue* jsSVGPreserveAspectRatioSVG_MEETORSLICE_SLICE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSC::JSValue* toJS(JSC::ExecState* exec, SVGPreserveAspectRatio* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGPreserveAspectRatio>(exec, object, context);
}
SVGPreserveAspectRatio* toSVGPreserveAspectRatio(JSC::JSValue* val)
{
    return val->isObject(&JSSVGPreserveAspectRatio::s_info) ? static_cast<JSSVGPreserveAspectRatio*>(val)->impl() : 0;
}

}

#endif // ENABLE(SVG)
