/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGLengthList.h"

#include <wtf/GetPtr.h>

#include "JSSVGLength.h"
#include "SVGLength.h"
#include "SVGLengthList.h"

#include <kjs/Error.h>
#include <kjs/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGLengthList)

/* Hash table */

static const HashTableValue JSSVGLengthListTableValues[2] =
{
    { "numberOfItems", DontDelete|ReadOnly, (intptr_t)jsSVGLengthListNumberOfItems, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGLengthListTable = { 0, JSSVGLengthListTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSSVGLengthListPrototypeTableValues[8] =
{
    { "clear", DontDelete|Function, (intptr_t)jsSVGLengthListPrototypeFunctionClear, (intptr_t)0 },
    { "initialize", DontDelete|Function, (intptr_t)jsSVGLengthListPrototypeFunctionInitialize, (intptr_t)1 },
    { "getItem", DontDelete|Function, (intptr_t)jsSVGLengthListPrototypeFunctionGetItem, (intptr_t)1 },
    { "insertItemBefore", DontDelete|Function, (intptr_t)jsSVGLengthListPrototypeFunctionInsertItemBefore, (intptr_t)2 },
    { "replaceItem", DontDelete|Function, (intptr_t)jsSVGLengthListPrototypeFunctionReplaceItem, (intptr_t)2 },
    { "removeItem", DontDelete|Function, (intptr_t)jsSVGLengthListPrototypeFunctionRemoveItem, (intptr_t)1 },
    { "appendItem", DontDelete|Function, (intptr_t)jsSVGLengthListPrototypeFunctionAppendItem, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGLengthListPrototypeTable = { 63, JSSVGLengthListPrototypeTableValues, 0 };

const ClassInfo JSSVGLengthListPrototype::s_info = { "SVGLengthListPrototype", 0, &JSSVGLengthListPrototypeTable, 0 };

JSObject* JSSVGLengthListPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSVGLengthList>(exec);
}

bool JSSVGLengthListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGLengthListPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGLengthList::s_info = { "SVGLengthList", 0, &JSSVGLengthListTable , 0 };

JSSVGLengthList::JSSVGLengthList(PassRefPtr<StructureID> structure, PassRefPtr<SVGLengthList> impl, SVGElement* context)
    : DOMObject(structure)
    , m_context(context)
    , m_impl(impl)
{
}

JSSVGLengthList::~JSSVGLengthList()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSSVGLengthList::createPrototype(ExecState* exec)
{
    return new (exec) JSSVGLengthListPrototype(JSSVGLengthListPrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSSVGLengthList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGLengthList, Base>(exec, &JSSVGLengthListTable, this, propertyName, slot);
}

JSValue* jsSVGLengthListNumberOfItems(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGLengthList* imp = static_cast<SVGLengthList*>(static_cast<JSSVGLengthList*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->numberOfItems());
}

JSValue* jsSVGLengthListPrototypeFunctionClear(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGLengthList::s_info))
        return throwError(exec, TypeError);
    JSSVGLengthList* castedThisObj = static_cast<JSSVGLengthList*>(thisValue);
    SVGLengthList* imp = static_cast<SVGLengthList*>(castedThisObj->impl());
    ExceptionCode ec = 0;

    imp->clear(ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsSVGLengthListPrototypeFunctionInitialize(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGLengthList::s_info))
        return throwError(exec, TypeError);
    JSSVGLengthList* castedThisObj = static_cast<JSSVGLengthList*>(thisValue);
    SVGLengthList* imp = static_cast<SVGLengthList*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    SVGLength item = toSVGLength(args.at(exec, 0));


    JSC::JSValue* result = toJS(exec, JSSVGStaticPODTypeWrapper<SVGLength>::create(imp->initialize(item, ec)).get(), castedThisObj->context());
    setDOMException(exec, ec);
    return result;
}

JSValue* jsSVGLengthListPrototypeFunctionGetItem(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGLengthList::s_info))
        return throwError(exec, TypeError);
    JSSVGLengthList* castedThisObj = static_cast<JSSVGLengthList*>(thisValue);
    SVGLengthList* imp = static_cast<SVGLengthList*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    unsigned index = args.at(exec, 0)->toInt32(exec);


    JSC::JSValue* result = toJS(exec, JSSVGStaticPODTypeWrapper<SVGLength>::create(imp->getItem(index, ec)).get(), castedThisObj->context());
    setDOMException(exec, ec);
    return result;
}

JSValue* jsSVGLengthListPrototypeFunctionInsertItemBefore(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGLengthList::s_info))
        return throwError(exec, TypeError);
    JSSVGLengthList* castedThisObj = static_cast<JSSVGLengthList*>(thisValue);
    SVGLengthList* imp = static_cast<SVGLengthList*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    SVGLength item = toSVGLength(args.at(exec, 0));
    unsigned index = args.at(exec, 1)->toInt32(exec);


    JSC::JSValue* result = toJS(exec, JSSVGStaticPODTypeWrapper<SVGLength>::create(imp->insertItemBefore(item, index, ec)).get(), castedThisObj->context());
    setDOMException(exec, ec);
    return result;
}

JSValue* jsSVGLengthListPrototypeFunctionReplaceItem(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGLengthList::s_info))
        return throwError(exec, TypeError);
    JSSVGLengthList* castedThisObj = static_cast<JSSVGLengthList*>(thisValue);
    SVGLengthList* imp = static_cast<SVGLengthList*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    SVGLength item = toSVGLength(args.at(exec, 0));
    unsigned index = args.at(exec, 1)->toInt32(exec);


    JSC::JSValue* result = toJS(exec, JSSVGStaticPODTypeWrapper<SVGLength>::create(imp->replaceItem(item, index, ec)).get(), castedThisObj->context());
    setDOMException(exec, ec);
    return result;
}

JSValue* jsSVGLengthListPrototypeFunctionRemoveItem(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGLengthList::s_info))
        return throwError(exec, TypeError);
    JSSVGLengthList* castedThisObj = static_cast<JSSVGLengthList*>(thisValue);
    SVGLengthList* imp = static_cast<SVGLengthList*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    unsigned index = args.at(exec, 0)->toInt32(exec);


    JSC::JSValue* result = toJS(exec, JSSVGStaticPODTypeWrapper<SVGLength>::create(imp->removeItem(index, ec)).get(), castedThisObj->context());
    setDOMException(exec, ec);
    return result;
}

JSValue* jsSVGLengthListPrototypeFunctionAppendItem(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGLengthList::s_info))
        return throwError(exec, TypeError);
    JSSVGLengthList* castedThisObj = static_cast<JSSVGLengthList*>(thisValue);
    SVGLengthList* imp = static_cast<SVGLengthList*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    SVGLength item = toSVGLength(args.at(exec, 0));


    JSC::JSValue* result = toJS(exec, JSSVGStaticPODTypeWrapper<SVGLength>::create(imp->appendItem(item, ec)).get(), castedThisObj->context());
    setDOMException(exec, ec);
    return result;
}

JSC::JSValue* toJS(JSC::ExecState* exec, SVGLengthList* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGLengthList>(exec, object, context);
}
SVGLengthList* toSVGLengthList(JSC::JSValue* val)
{
    return val->isObject(&JSSVGLengthList::s_info) ? static_cast<JSSVGLengthList*>(val)->impl() : 0;
}

}

#endif // ENABLE(SVG)
