/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGImageElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedPreserveAspectRatio.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGElement.h"
#include "SVGImageElement.h"
#include "SVGStringList.h"

#include <kjs/Error.h>
#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGImageElement)

/* Hash table */

static const HashTableValue JSSVGImageElementTableValues[18] =
{
    { "x", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementX, (intptr_t)0 },
    { "y", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementY, (intptr_t)0 },
    { "width", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementWidth, (intptr_t)0 },
    { "height", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementHeight, (intptr_t)0 },
    { "preserveAspectRatio", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementPreserveAspectRatio, (intptr_t)0 },
    { "href", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementHref, (intptr_t)0 },
    { "requiredFeatures", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementRequiredFeatures, (intptr_t)0 },
    { "requiredExtensions", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementRequiredExtensions, (intptr_t)0 },
    { "systemLanguage", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementSystemLanguage, (intptr_t)0 },
    { "xmllang", DontDelete, (intptr_t)jsSVGImageElementXmllang, (intptr_t)setJSSVGImageElementXmllang },
    { "xmlspace", DontDelete, (intptr_t)jsSVGImageElementXmlspace, (intptr_t)setJSSVGImageElementXmlspace },
    { "externalResourcesRequired", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementExternalResourcesRequired, (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementClassName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementStyle, (intptr_t)0 },
    { "transform", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementTransform, (intptr_t)0 },
    { "nearestViewportElement", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementNearestViewportElement, (intptr_t)0 },
    { "farthestViewportElement", DontDelete|ReadOnly, (intptr_t)jsSVGImageElementFarthestViewportElement, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGImageElementTable = { 1023, JSSVGImageElementTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSSVGImageElementPrototypeTableValues[7] =
{
    { "hasExtension", DontDelete|Function, (intptr_t)jsSVGImageElementPrototypeFunctionHasExtension, (intptr_t)1 },
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)jsSVGImageElementPrototypeFunctionGetPresentationAttribute, (intptr_t)1 },
    { "getBBox", DontDelete|Function, (intptr_t)jsSVGImageElementPrototypeFunctionGetBBox, (intptr_t)0 },
    { "getCTM", DontDelete|Function, (intptr_t)jsSVGImageElementPrototypeFunctionGetCTM, (intptr_t)0 },
    { "getScreenCTM", DontDelete|Function, (intptr_t)jsSVGImageElementPrototypeFunctionGetScreenCTM, (intptr_t)0 },
    { "getTransformToElement", DontDelete|Function, (intptr_t)jsSVGImageElementPrototypeFunctionGetTransformToElement, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGImageElementPrototypeTable = { 2047, JSSVGImageElementPrototypeTableValues, 0 };

const ClassInfo JSSVGImageElementPrototype::s_info = { "SVGImageElementPrototype", 0, &JSSVGImageElementPrototypeTable, 0 };

JSObject* JSSVGImageElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSVGImageElement>(exec);
}

bool JSSVGImageElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGImageElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGImageElement::s_info = { "SVGImageElement", &JSSVGElement::s_info, &JSSVGImageElementTable , 0 };

JSSVGImageElement::JSSVGImageElement(PassRefPtr<StructureID> structure, PassRefPtr<SVGImageElement> impl)
    : JSSVGElement(structure, impl)
{
}

JSObject* JSSVGImageElement::createPrototype(ExecState* exec)
{
    return new (exec) JSSVGImageElementPrototype(JSSVGImageElementPrototype::createStructureID(JSSVGElementPrototype::self(exec)));
}

bool JSSVGImageElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGImageElement, Base>(exec, &JSSVGImageElementTable, this, propertyName, slot);
}

JSValue* jsSVGImageElementX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGImageElementY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGImageElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGImageElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGImageElementPreserveAspectRatio(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedPreserveAspectRatio> obj = imp->preserveAspectRatioAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGImageElementHref(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedString> obj = imp->hrefAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGImageElementRequiredFeatures(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->requiredFeatures()), imp);
}

JSValue* jsSVGImageElementRequiredExtensions(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->requiredExtensions()), imp);
}

JSValue* jsSVGImageElementSystemLanguage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->systemLanguage()), imp);
}

JSValue* jsSVGImageElementXmllang(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->xmllang());
}

JSValue* jsSVGImageElementXmlspace(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->xmlspace());
}

JSValue* jsSVGImageElementExternalResourcesRequired(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGImageElementClassName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGImageElementStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->style()));
}

JSValue* jsSVGImageElementTransform(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedTransformList> obj = imp->transformAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGImageElementNearestViewportElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->nearestViewportElement()));
}

JSValue* jsSVGImageElementFarthestViewportElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->farthestViewportElement()));
}

void JSSVGImageElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSSVGImageElement, Base>(exec, propertyName, value, &JSSVGImageElementTable, this, slot);
}

void setJSSVGImageElementXmllang(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(thisObject)->impl());
    imp->setXmllang(value->toString(exec));
}

void setJSSVGImageElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    SVGImageElement* imp = static_cast<SVGImageElement*>(static_cast<JSSVGImageElement*>(thisObject)->impl());
    imp->setXmlspace(value->toString(exec));
}

JSValue* jsSVGImageElementPrototypeFunctionHasExtension(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGImageElement::s_info))
        return throwError(exec, TypeError);
    JSSVGImageElement* castedThisObj = static_cast<JSSVGImageElement*>(thisValue);
    SVGImageElement* imp = static_cast<SVGImageElement*>(castedThisObj->impl());
    const UString& extension = args.at(exec, 0)->toString(exec);


    JSC::JSValue* result = jsBoolean(imp->hasExtension(extension));
    return result;
}

JSValue* jsSVGImageElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGImageElement::s_info))
        return throwError(exec, TypeError);
    JSSVGImageElement* castedThisObj = static_cast<JSSVGImageElement*>(thisValue);
    SVGImageElement* imp = static_cast<SVGImageElement*>(castedThisObj->impl());
    const UString& name = args.at(exec, 0)->toString(exec);


    JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}

JSValue* jsSVGImageElementPrototypeFunctionGetBBox(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGImageElement::s_info))
        return throwError(exec, TypeError);
    JSSVGImageElement* castedThisObj = static_cast<JSSVGImageElement*>(thisValue);
    SVGImageElement* imp = static_cast<SVGImageElement*>(castedThisObj->impl());


    JSC::JSValue* result = toJS(exec, JSSVGStaticPODTypeWrapper<FloatRect>::create(imp->getBBox()).get(), imp);
    return result;
}

JSValue* jsSVGImageElementPrototypeFunctionGetCTM(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGImageElement::s_info))
        return throwError(exec, TypeError);
    JSSVGImageElement* castedThisObj = static_cast<JSSVGImageElement*>(thisValue);
    SVGImageElement* imp = static_cast<SVGImageElement*>(castedThisObj->impl());


    JSC::JSValue* result = toJS(exec, JSSVGStaticPODTypeWrapper<AffineTransform>::create(imp->getCTM()).get(), imp);
    return result;
}

JSValue* jsSVGImageElementPrototypeFunctionGetScreenCTM(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGImageElement::s_info))
        return throwError(exec, TypeError);
    JSSVGImageElement* castedThisObj = static_cast<JSSVGImageElement*>(thisValue);
    SVGImageElement* imp = static_cast<SVGImageElement*>(castedThisObj->impl());


    JSC::JSValue* result = toJS(exec, JSSVGStaticPODTypeWrapper<AffineTransform>::create(imp->getScreenCTM()).get(), imp);
    return result;
}

JSValue* jsSVGImageElementPrototypeFunctionGetTransformToElement(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGImageElement::s_info))
        return throwError(exec, TypeError);
    JSSVGImageElement* castedThisObj = static_cast<JSSVGImageElement*>(thisValue);
    SVGImageElement* imp = static_cast<SVGImageElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    SVGElement* element = toSVGElement(args.at(exec, 0));


    JSC::JSValue* result = toJS(exec, JSSVGStaticPODTypeWrapper<AffineTransform>::create(imp->getTransformToElement(element, ec)).get(), imp);
    setDOMException(exec, ec);
    return result;
}


}

#endif // ENABLE(SVG)
