/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGColor.h"

#include <wtf/GetPtr.h>

#include "JSRGBColor.h"
#include "SVGColor.h"

#include <kjs/Error.h>
#include <kjs/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGColor)

/* Hash table */

static const HashTableValue JSSVGColorTableValues[4] =
{
    { "colorType", DontDelete|ReadOnly, (intptr_t)jsSVGColorColorType, (intptr_t)0 },
    { "rgbColor", DontDelete|ReadOnly, (intptr_t)jsSVGColorRgbColor, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsSVGColorConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGColorTable = { 3, JSSVGColorTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSSVGColorConstructorTableValues[5] =
{
    { "SVG_COLORTYPE_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGColorSVG_COLORTYPE_UNKNOWN, (intptr_t)0 },
    { "SVG_COLORTYPE_RGBCOLOR", DontDelete|ReadOnly, (intptr_t)jsSVGColorSVG_COLORTYPE_RGBCOLOR, (intptr_t)0 },
    { "SVG_COLORTYPE_RGBCOLOR_ICCCOLOR", DontDelete|ReadOnly, (intptr_t)jsSVGColorSVG_COLORTYPE_RGBCOLOR_ICCCOLOR, (intptr_t)0 },
    { "SVG_COLORTYPE_CURRENTCOLOR", DontDelete|ReadOnly, (intptr_t)jsSVGColorSVG_COLORTYPE_CURRENTCOLOR, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGColorConstructorTable = { 3, JSSVGColorConstructorTableValues, 0 };

class JSSVGColorConstructor : public DOMObject {
public:
    JSSVGColorConstructor(ExecState* exec)
        : DOMObject(JSSVGColorConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSSVGColorPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSSVGColorConstructor::s_info = { "SVGColorConstructor", 0, &JSSVGColorConstructorTable, 0 };

bool JSSVGColorConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGColorConstructor, DOMObject>(exec, &JSSVGColorConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSSVGColorPrototypeTableValues[8] =
{
    { "SVG_COLORTYPE_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGColorSVG_COLORTYPE_UNKNOWN, (intptr_t)0 },
    { "SVG_COLORTYPE_RGBCOLOR", DontDelete|ReadOnly, (intptr_t)jsSVGColorSVG_COLORTYPE_RGBCOLOR, (intptr_t)0 },
    { "SVG_COLORTYPE_RGBCOLOR_ICCCOLOR", DontDelete|ReadOnly, (intptr_t)jsSVGColorSVG_COLORTYPE_RGBCOLOR_ICCCOLOR, (intptr_t)0 },
    { "SVG_COLORTYPE_CURRENTCOLOR", DontDelete|ReadOnly, (intptr_t)jsSVGColorSVG_COLORTYPE_CURRENTCOLOR, (intptr_t)0 },
    { "setRGBColor", DontDelete|Function, (intptr_t)jsSVGColorPrototypeFunctionSetRGBColor, (intptr_t)1 },
    { "setRGBColorICCColor", DontDelete|Function, (intptr_t)jsSVGColorPrototypeFunctionSetRGBColorICCColor, (intptr_t)2 },
    { "setColor", DontDelete|Function, (intptr_t)jsSVGColorPrototypeFunctionSetColor, (intptr_t)3 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGColorPrototypeTable = { 255, JSSVGColorPrototypeTableValues, 0 };

const ClassInfo JSSVGColorPrototype::s_info = { "SVGColorPrototype", 0, &JSSVGColorPrototypeTable, 0 };

JSObject* JSSVGColorPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSVGColor>(exec);
}

bool JSSVGColorPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSSVGColorPrototype, JSObject>(exec, &JSSVGColorPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGColor::s_info = { "SVGColor", &JSCSSValue::s_info, &JSSVGColorTable , 0 };

JSSVGColor::JSSVGColor(PassRefPtr<StructureID> structure, PassRefPtr<SVGColor> impl)
    : JSCSSValue(structure, impl)
{
}

JSObject* JSSVGColor::createPrototype(ExecState* exec)
{
    return new (exec) JSSVGColorPrototype(JSSVGColorPrototype::createStructureID(JSCSSValuePrototype::self(exec)));
}

bool JSSVGColor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGColor, Base>(exec, &JSSVGColorTable, this, propertyName, slot);
}

JSValue* jsSVGColorColorType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGColor* imp = static_cast<SVGColor*>(static_cast<JSSVGColor*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->colorType());
}

JSValue* jsSVGColorRgbColor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGColor* imp = static_cast<SVGColor*>(static_cast<JSSVGColor*>(slot.slotBase())->impl());
    return getJSRGBColor(exec, imp->rgbColor());
}

JSValue* jsSVGColorConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSSVGColor*>(slot.slotBase())->getConstructor(exec);
}
JSValue* JSSVGColor::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSSVGColorConstructor>(exec);
}

JSValue* jsSVGColorPrototypeFunctionSetRGBColor(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGColor::s_info))
        return throwError(exec, TypeError);
    JSSVGColor* castedThisObj = static_cast<JSSVGColor*>(thisValue);
    SVGColor* imp = static_cast<SVGColor*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& rgbColor = args.at(exec, 0)->toString(exec);

    imp->setRGBColor(rgbColor, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsSVGColorPrototypeFunctionSetRGBColorICCColor(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGColor::s_info))
        return throwError(exec, TypeError);
    JSSVGColor* castedThisObj = static_cast<JSSVGColor*>(thisValue);
    SVGColor* imp = static_cast<SVGColor*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& rgbColor = args.at(exec, 0)->toString(exec);
    const UString& iccColor = args.at(exec, 1)->toString(exec);

    imp->setRGBColorICCColor(rgbColor, iccColor, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsSVGColorPrototypeFunctionSetColor(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGColor::s_info))
        return throwError(exec, TypeError);
    JSSVGColor* castedThisObj = static_cast<JSSVGColor*>(thisValue);
    SVGColor* imp = static_cast<SVGColor*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    unsigned short colorType = args.at(exec, 0)->toInt32(exec);
    const UString& rgbColor = args.at(exec, 1)->toString(exec);
    const UString& iccColor = args.at(exec, 2)->toString(exec);

    imp->setColor(colorType, rgbColor, iccColor, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

// Constant getters

JSValue* jsSVGColorSVG_COLORTYPE_UNKNOWN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue* jsSVGColorSVG_COLORTYPE_RGBCOLOR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue* jsSVGColorSVG_COLORTYPE_RGBCOLOR_ICCCOLOR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValue* jsSVGColorSVG_COLORTYPE_CURRENTCOLOR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(3));
}


}

#endif // ENABLE(SVG)
