/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGAngle.h"

#include <wtf/GetPtr.h>

#include "KURL.h"
#include "SVGAngle.h"

#include <kjs/Error.h>
#include <kjs/JSNumberCell.h>
#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGAngle)

/* Hash table */

static const HashTableValue JSSVGAngleTableValues[6] =
{
    { "unitType", DontDelete|ReadOnly, (intptr_t)jsSVGAngleUnitType, (intptr_t)0 },
    { "value", DontDelete, (intptr_t)jsSVGAngleValue, (intptr_t)setJSSVGAngleValue },
    { "valueInSpecifiedUnits", DontDelete, (intptr_t)jsSVGAngleValueInSpecifiedUnits, (intptr_t)setJSSVGAngleValueInSpecifiedUnits },
    { "valueAsString", DontDelete, (intptr_t)jsSVGAngleValueAsString, (intptr_t)setJSSVGAngleValueAsString },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsSVGAngleConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGAngleTable = { 255, JSSVGAngleTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSSVGAngleConstructorTableValues[6] =
{
    { "SVG_ANGLETYPE_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGAngleSVG_ANGLETYPE_UNKNOWN, (intptr_t)0 },
    { "SVG_ANGLETYPE_UNSPECIFIED", DontDelete|ReadOnly, (intptr_t)jsSVGAngleSVG_ANGLETYPE_UNSPECIFIED, (intptr_t)0 },
    { "SVG_ANGLETYPE_DEG", DontDelete|ReadOnly, (intptr_t)jsSVGAngleSVG_ANGLETYPE_DEG, (intptr_t)0 },
    { "SVG_ANGLETYPE_RAD", DontDelete|ReadOnly, (intptr_t)jsSVGAngleSVG_ANGLETYPE_RAD, (intptr_t)0 },
    { "SVG_ANGLETYPE_GRAD", DontDelete|ReadOnly, (intptr_t)jsSVGAngleSVG_ANGLETYPE_GRAD, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGAngleConstructorTable = { 255, JSSVGAngleConstructorTableValues, 0 };

class JSSVGAngleConstructor : public DOMObject {
public:
    JSSVGAngleConstructor(ExecState* exec)
        : DOMObject(JSSVGAngleConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSSVGAnglePrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSSVGAngleConstructor::s_info = { "SVGAngleConstructor", 0, &JSSVGAngleConstructorTable, 0 };

bool JSSVGAngleConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAngleConstructor, DOMObject>(exec, &JSSVGAngleConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSSVGAnglePrototypeTableValues[8] =
{
    { "SVG_ANGLETYPE_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGAngleSVG_ANGLETYPE_UNKNOWN, (intptr_t)0 },
    { "SVG_ANGLETYPE_UNSPECIFIED", DontDelete|ReadOnly, (intptr_t)jsSVGAngleSVG_ANGLETYPE_UNSPECIFIED, (intptr_t)0 },
    { "SVG_ANGLETYPE_DEG", DontDelete|ReadOnly, (intptr_t)jsSVGAngleSVG_ANGLETYPE_DEG, (intptr_t)0 },
    { "SVG_ANGLETYPE_RAD", DontDelete|ReadOnly, (intptr_t)jsSVGAngleSVG_ANGLETYPE_RAD, (intptr_t)0 },
    { "SVG_ANGLETYPE_GRAD", DontDelete|ReadOnly, (intptr_t)jsSVGAngleSVG_ANGLETYPE_GRAD, (intptr_t)0 },
    { "newValueSpecifiedUnits", DontDelete|Function, (intptr_t)jsSVGAnglePrototypeFunctionNewValueSpecifiedUnits, (intptr_t)2 },
    { "convertToSpecifiedUnits", DontDelete|Function, (intptr_t)jsSVGAnglePrototypeFunctionConvertToSpecifiedUnits, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGAnglePrototypeTable = { 255, JSSVGAnglePrototypeTableValues, 0 };

const ClassInfo JSSVGAnglePrototype::s_info = { "SVGAnglePrototype", 0, &JSSVGAnglePrototypeTable, 0 };

JSObject* JSSVGAnglePrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSVGAngle>(exec);
}

bool JSSVGAnglePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSSVGAnglePrototype, JSObject>(exec, &JSSVGAnglePrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGAngle::s_info = { "SVGAngle", 0, &JSSVGAngleTable , 0 };

JSSVGAngle::JSSVGAngle(PassRefPtr<StructureID> structure, PassRefPtr<SVGAngle> impl, SVGElement* context)
    : DOMObject(structure)
    , m_context(context)
    , m_impl(impl)
{
}

JSSVGAngle::~JSSVGAngle()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSSVGAngle::createPrototype(ExecState* exec)
{
    return new (exec) JSSVGAnglePrototype(JSSVGAnglePrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSSVGAngle::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAngle, Base>(exec, &JSSVGAngleTable, this, propertyName, slot);
}

JSValue* jsSVGAngleUnitType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGAngle* imp = static_cast<SVGAngle*>(static_cast<JSSVGAngle*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->unitType());
}

JSValue* jsSVGAngleValue(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGAngle* imp = static_cast<SVGAngle*>(static_cast<JSSVGAngle*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->value());
}

JSValue* jsSVGAngleValueInSpecifiedUnits(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGAngle* imp = static_cast<SVGAngle*>(static_cast<JSSVGAngle*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->valueInSpecifiedUnits());
}

JSValue* jsSVGAngleValueAsString(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGAngle* imp = static_cast<SVGAngle*>(static_cast<JSSVGAngle*>(slot.slotBase())->impl());
    return jsString(exec, imp->valueAsString());
}

JSValue* jsSVGAngleConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSSVGAngle*>(slot.slotBase())->getConstructor(exec);
}
void JSSVGAngle::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSSVGAngle, Base>(exec, propertyName, value, &JSSVGAngleTable, this, slot);
}

void setJSSVGAngleValue(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    SVGAngle* imp = static_cast<SVGAngle*>(static_cast<JSSVGAngle*>(thisObject)->impl());
    imp->setValue(value->toFloat(exec));
    if (static_cast<JSSVGAngle*>(thisObject)->context())
        static_cast<JSSVGAngle*>(thisObject)->context()->svgAttributeChanged(static_cast<JSSVGAngle*>(thisObject)->impl()->associatedAttributeName());
}

void setJSSVGAngleValueInSpecifiedUnits(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    SVGAngle* imp = static_cast<SVGAngle*>(static_cast<JSSVGAngle*>(thisObject)->impl());
    imp->setValueInSpecifiedUnits(value->toFloat(exec));
    if (static_cast<JSSVGAngle*>(thisObject)->context())
        static_cast<JSSVGAngle*>(thisObject)->context()->svgAttributeChanged(static_cast<JSSVGAngle*>(thisObject)->impl()->associatedAttributeName());
}

void setJSSVGAngleValueAsString(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    SVGAngle* imp = static_cast<SVGAngle*>(static_cast<JSSVGAngle*>(thisObject)->impl());
    imp->setValueAsString(valueToStringWithNullCheck(exec, value));
    if (static_cast<JSSVGAngle*>(thisObject)->context())
        static_cast<JSSVGAngle*>(thisObject)->context()->svgAttributeChanged(static_cast<JSSVGAngle*>(thisObject)->impl()->associatedAttributeName());
}

JSValue* JSSVGAngle::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSSVGAngleConstructor>(exec);
}

JSValue* jsSVGAnglePrototypeFunctionNewValueSpecifiedUnits(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGAngle::s_info))
        return throwError(exec, TypeError);
    JSSVGAngle* castedThisObj = static_cast<JSSVGAngle*>(thisValue);
    SVGAngle* imp = static_cast<SVGAngle*>(castedThisObj->impl());
    unsigned short unitType = args.at(exec, 0)->toInt32(exec);
    float valueInSpecifiedUnits = args.at(exec, 1)->toFloat(exec);

    imp->newValueSpecifiedUnits(unitType, valueInSpecifiedUnits);
    return jsUndefined();
}

JSValue* jsSVGAnglePrototypeFunctionConvertToSpecifiedUnits(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGAngle::s_info))
        return throwError(exec, TypeError);
    JSSVGAngle* castedThisObj = static_cast<JSSVGAngle*>(thisValue);
    SVGAngle* imp = static_cast<SVGAngle*>(castedThisObj->impl());
    unsigned short unitType = args.at(exec, 0)->toInt32(exec);

    imp->convertToSpecifiedUnits(unitType);
    return jsUndefined();
}

// Constant getters

JSValue* jsSVGAngleSVG_ANGLETYPE_UNKNOWN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue* jsSVGAngleSVG_ANGLETYPE_UNSPECIFIED(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue* jsSVGAngleSVG_ANGLETYPE_DEG(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValue* jsSVGAngleSVG_ANGLETYPE_RAD(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(3));
}

JSValue* jsSVGAngleSVG_ANGLETYPE_GRAD(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(4));
}

JSC::JSValue* toJS(JSC::ExecState* exec, SVGAngle* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGAngle>(exec, object, context);
}
SVGAngle* toSVGAngle(JSC::JSValue* val)
{
    return val->isObject(&JSSVGAngle::s_info) ? static_cast<JSSVGAngle*>(val)->impl() : 0;
}

}

#endif // ENABLE(SVG)
