/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSSQLError.h"

#include <wtf/GetPtr.h>

#include "KURL.h"
#include "SQLError.h"

#include <kjs/JSNumberCell.h>
#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSQLError)

/* Hash table */

static const HashTableValue JSSQLErrorTableValues[3] =
{
    { "code", DontDelete|ReadOnly, (intptr_t)jsSQLErrorCode, (intptr_t)0 },
    { "message", DontDelete|ReadOnly, (intptr_t)jsSQLErrorMessage, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSQLErrorTable = { 3, JSSQLErrorTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSSQLErrorPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSSQLErrorPrototypeTable = { 0, JSSQLErrorPrototypeTableValues, 0 };

const ClassInfo JSSQLErrorPrototype::s_info = { "SQLErrorPrototype", 0, &JSSQLErrorPrototypeTable, 0 };

JSObject* JSSQLErrorPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSQLError>(exec);
}

const ClassInfo JSSQLError::s_info = { "SQLError", 0, &JSSQLErrorTable , 0 };

JSSQLError::JSSQLError(PassRefPtr<StructureID> structure, PassRefPtr<SQLError> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSSQLError::~JSSQLError()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSSQLError::createPrototype(ExecState* exec)
{
    return new (exec) JSSQLErrorPrototype(JSSQLErrorPrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSSQLError::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSQLError, Base>(exec, &JSSQLErrorTable, this, propertyName, slot);
}

JSValue* jsSQLErrorCode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SQLError* imp = static_cast<SQLError*>(static_cast<JSSQLError*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->code());
}

JSValue* jsSQLErrorMessage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SQLError* imp = static_cast<SQLError*>(static_cast<JSSQLError*>(slot.slotBase())->impl());
    return jsString(exec, imp->message());
}

JSC::JSValue* toJS(JSC::ExecState* exec, SQLError* object)
{
    return getDOMObjectWrapper<JSSQLError>(exec, object);
}
SQLError* toSQLError(JSC::JSValue* val)
{
    return val->isObject(&JSSQLError::s_info) ? static_cast<JSSQLError*>(val)->impl() : 0;
}

}
