/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSRangeException.h"

#include <wtf/GetPtr.h>

#include "KURL.h"
#include "RangeException.h"

#include <kjs/Error.h>
#include <kjs/JSNumberCell.h>
#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSRangeException)

/* Hash table */

static const HashTableValue JSRangeExceptionTableValues[5] =
{
    { "code", DontDelete|ReadOnly, (intptr_t)jsRangeExceptionCode, (intptr_t)0 },
    { "name", DontDelete|ReadOnly, (intptr_t)jsRangeExceptionName, (intptr_t)0 },
    { "message", DontDelete|ReadOnly, (intptr_t)jsRangeExceptionMessage, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsRangeExceptionConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSRangeExceptionTable = { 127, JSRangeExceptionTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSRangeExceptionConstructorTableValues[3] =
{
    { "BAD_BOUNDARYPOINTS_ERR", DontDelete|ReadOnly, (intptr_t)jsRangeExceptionBAD_BOUNDARYPOINTS_ERR, (intptr_t)0 },
    { "INVALID_NODE_TYPE_ERR", DontDelete|ReadOnly, (intptr_t)jsRangeExceptionINVALID_NODE_TYPE_ERR, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSRangeExceptionConstructorTable = { 1, JSRangeExceptionConstructorTableValues, 0 };

class JSRangeExceptionConstructor : public DOMObject {
public:
    JSRangeExceptionConstructor(ExecState* exec)
        : DOMObject(JSRangeExceptionConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSRangeExceptionPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSRangeExceptionConstructor::s_info = { "RangeExceptionConstructor", 0, &JSRangeExceptionConstructorTable, 0 };

bool JSRangeExceptionConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSRangeExceptionConstructor, DOMObject>(exec, &JSRangeExceptionConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSRangeExceptionPrototypeTableValues[4] =
{
    { "BAD_BOUNDARYPOINTS_ERR", DontDelete|ReadOnly, (intptr_t)jsRangeExceptionBAD_BOUNDARYPOINTS_ERR, (intptr_t)0 },
    { "INVALID_NODE_TYPE_ERR", DontDelete|ReadOnly, (intptr_t)jsRangeExceptionINVALID_NODE_TYPE_ERR, (intptr_t)0 },
    { "toString", DontDelete|DontEnum|Function, (intptr_t)jsRangeExceptionPrototypeFunctionToString, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSRangeExceptionPrototypeTable = { 3, JSRangeExceptionPrototypeTableValues, 0 };

const ClassInfo JSRangeExceptionPrototype::s_info = { "RangeExceptionPrototype", 0, &JSRangeExceptionPrototypeTable, 0 };

JSObject* JSRangeExceptionPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSRangeException>(exec);
}

bool JSRangeExceptionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSRangeExceptionPrototype, JSObject>(exec, &JSRangeExceptionPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSRangeException::s_info = { "RangeException", 0, &JSRangeExceptionTable , 0 };

JSRangeException::JSRangeException(PassRefPtr<StructureID> structure, PassRefPtr<RangeException> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSRangeException::~JSRangeException()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSRangeException::createPrototype(ExecState* exec)
{
    return new (exec) JSRangeExceptionPrototype(JSRangeExceptionPrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSRangeException::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSRangeException, Base>(exec, &JSRangeExceptionTable, this, propertyName, slot);
}

JSValue* jsRangeExceptionCode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    RangeException* imp = static_cast<RangeException*>(static_cast<JSRangeException*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->code());
}

JSValue* jsRangeExceptionName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    RangeException* imp = static_cast<RangeException*>(static_cast<JSRangeException*>(slot.slotBase())->impl());
    return jsString(exec, imp->name());
}

JSValue* jsRangeExceptionMessage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    RangeException* imp = static_cast<RangeException*>(static_cast<JSRangeException*>(slot.slotBase())->impl());
    return jsString(exec, imp->message());
}

JSValue* jsRangeExceptionConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSRangeException*>(slot.slotBase())->getConstructor(exec);
}
JSValue* JSRangeException::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSRangeExceptionConstructor>(exec);
}

JSValue* jsRangeExceptionPrototypeFunctionToString(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSRangeException::s_info))
        return throwError(exec, TypeError);
    JSRangeException* castedThisObj = static_cast<JSRangeException*>(thisValue);
    RangeException* imp = static_cast<RangeException*>(castedThisObj->impl());


    JSC::JSValue* result = jsString(exec, imp->toString());
    return result;
}

// Constant getters

JSValue* jsRangeExceptionBAD_BOUNDARYPOINTS_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue* jsRangeExceptionINVALID_NODE_TYPE_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSC::JSValue* toJS(JSC::ExecState* exec, RangeException* object)
{
    return getDOMObjectWrapper<JSRangeException>(exec, object);
}
RangeException* toRangeException(JSC::JSValue* val)
{
    return val->isObject(&JSRangeException::s_info) ? static_cast<JSRangeException*>(val)->impl() : 0;
}

}
