/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSMimeType.h"

#include <wtf/GetPtr.h>

#include "JSPlugin.h"
#include "KURL.h"
#include "MimeType.h"
#include "Plugin.h"

#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSMimeType)

/* Hash table */

static const HashTableValue JSMimeTypeTableValues[5] =
{
    { "type", DontDelete|ReadOnly, (intptr_t)jsMimeTypeType, (intptr_t)0 },
    { "suffixes", DontDelete|ReadOnly, (intptr_t)jsMimeTypeSuffixes, (intptr_t)0 },
    { "description", DontDelete|ReadOnly, (intptr_t)jsMimeTypeDescription, (intptr_t)0 },
    { "enabledPlugin", DontDelete|ReadOnly, (intptr_t)jsMimeTypeEnabledPlugin, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSMimeTypeTable = { 7, JSMimeTypeTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSMimeTypePrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSMimeTypePrototypeTable = { 0, JSMimeTypePrototypeTableValues, 0 };

const ClassInfo JSMimeTypePrototype::s_info = { "MimeTypePrototype", 0, &JSMimeTypePrototypeTable, 0 };

JSObject* JSMimeTypePrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSMimeType>(exec);
}

const ClassInfo JSMimeType::s_info = { "MimeType", 0, &JSMimeTypeTable , 0 };

JSMimeType::JSMimeType(PassRefPtr<StructureID> structure, PassRefPtr<MimeType> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSMimeType::~JSMimeType()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSMimeType::createPrototype(ExecState* exec)
{
    return new (exec) JSMimeTypePrototype(JSMimeTypePrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSMimeType::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMimeType, Base>(exec, &JSMimeTypeTable, this, propertyName, slot);
}

JSValue* jsMimeTypeType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MimeType* imp = static_cast<MimeType*>(static_cast<JSMimeType*>(slot.slotBase())->impl());
    return jsString(exec, imp->type());
}

JSValue* jsMimeTypeSuffixes(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MimeType* imp = static_cast<MimeType*>(static_cast<JSMimeType*>(slot.slotBase())->impl());
    return jsString(exec, imp->suffixes());
}

JSValue* jsMimeTypeDescription(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MimeType* imp = static_cast<MimeType*>(static_cast<JSMimeType*>(slot.slotBase())->impl());
    return jsString(exec, imp->description());
}

JSValue* jsMimeTypeEnabledPlugin(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MimeType* imp = static_cast<MimeType*>(static_cast<JSMimeType*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->enabledPlugin()));
}

JSC::JSValue* toJS(JSC::ExecState* exec, MimeType* object)
{
    return getDOMObjectWrapper<JSMimeType>(exec, object);
}
MimeType* toMimeType(JSC::JSValue* val)
{
    return val->isObject(&JSMimeType::s_info) ? static_cast<JSMimeType*>(val)->impl() : 0;
}

}
