/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSJavaScriptCallFrame_h
#define JSJavaScriptCallFrame_h

#include "JSDOMBinding.h"
#include <kjs/JSGlobalObject.h>
#include <kjs/ObjectPrototype.h>

namespace WebCore {

class JavaScriptCallFrame;

class JSJavaScriptCallFrame : public DOMObject {
    typedef DOMObject Base;
public:
    JSJavaScriptCallFrame(PassRefPtr<JSC::StructureID>, PassRefPtr<JavaScriptCallFrame>);
    virtual ~JSJavaScriptCallFrame();
    static JSC::JSObject* createPrototype(JSC::ExecState*);
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertySlot&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;


    // Custom attributes
    JSC::JSValue* scopeChain(JSC::ExecState*) const;
    JSC::JSValue* thisObject(JSC::ExecState*) const;
    JSC::JSValue* type(JSC::ExecState*) const;

    // Custom functions
    JSC::JSValue* evaluate(JSC::ExecState*, const JSC::ArgList&);
    JavaScriptCallFrame* impl() const { return m_impl.get(); }

private:
    RefPtr<JavaScriptCallFrame> m_impl;
};

JSC::JSValue* toJS(JSC::ExecState*, JavaScriptCallFrame*);
JavaScriptCallFrame* toJavaScriptCallFrame(JSC::JSValue*);

class JSJavaScriptCallFramePrototype : public JSC::JSObject {
public:
    static JSC::JSObject* self(JSC::ExecState*);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    JSJavaScriptCallFramePrototype(PassRefPtr<JSC::StructureID> structure) : JSC::JSObject(structure) { }
};

// Functions

JSC::JSValue* jsJavaScriptCallFramePrototypeFunctionEvaluate(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
// Attibutes

JSC::JSValue* jsJavaScriptCallFrameCaller(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsJavaScriptCallFrameSourceID(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsJavaScriptCallFrameLine(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsJavaScriptCallFrameScopeChain(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsJavaScriptCallFrameThisObject(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsJavaScriptCallFrameFunctionName(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsJavaScriptCallFrameType(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);

} // namespace WebCore

#endif
