/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(VIDEO)

#include "JSHTMLVideoElement.h"

#include <wtf/GetPtr.h>

#include "HTMLVideoElement.h"
#include "KURL.h"

#include <kjs/JSNumberCell.h>
#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLVideoElement)

/* Hash table */

static const HashTableValue JSHTMLVideoElementTableValues[7] =
{
    { "width", DontDelete, (intptr_t)jsHTMLVideoElementWidth, (intptr_t)setJSHTMLVideoElementWidth },
    { "height", DontDelete, (intptr_t)jsHTMLVideoElementHeight, (intptr_t)setJSHTMLVideoElementHeight },
    { "videoWidth", DontDelete|ReadOnly, (intptr_t)jsHTMLVideoElementVideoWidth, (intptr_t)0 },
    { "videoHeight", DontDelete|ReadOnly, (intptr_t)jsHTMLVideoElementVideoHeight, (intptr_t)0 },
    { "poster", DontDelete, (intptr_t)jsHTMLVideoElementPoster, (intptr_t)setJSHTMLVideoElementPoster },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLVideoElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLVideoElementTable = { 31, JSHTMLVideoElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLVideoElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLVideoElementConstructorTable = { 0, JSHTMLVideoElementConstructorTableValues, 0 };

class JSHTMLVideoElementConstructor : public DOMObject {
public:
    JSHTMLVideoElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLVideoElementConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLVideoElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLVideoElementConstructor::s_info = { "HTMLVideoElementConstructor", 0, &JSHTMLVideoElementConstructorTable, 0 };

bool JSHTMLVideoElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLVideoElementConstructor, DOMObject>(exec, &JSHTMLVideoElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLVideoElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLVideoElementPrototypeTable = { 0, JSHTMLVideoElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLVideoElementPrototype::s_info = { "HTMLVideoElementPrototype", 0, &JSHTMLVideoElementPrototypeTable, 0 };

JSObject* JSHTMLVideoElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSHTMLVideoElement>(exec);
}

const ClassInfo JSHTMLVideoElement::s_info = { "HTMLVideoElement", &JSHTMLMediaElement::s_info, &JSHTMLVideoElementTable , 0 };

JSHTMLVideoElement::JSHTMLVideoElement(PassRefPtr<StructureID> structure, PassRefPtr<HTMLVideoElement> impl)
    : JSHTMLMediaElement(structure, impl)
{
}

JSObject* JSHTMLVideoElement::createPrototype(ExecState* exec)
{
    return new (exec) JSHTMLVideoElementPrototype(JSHTMLVideoElementPrototype::createStructureID(JSHTMLMediaElementPrototype::self(exec)));
}

bool JSHTMLVideoElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLVideoElement, Base>(exec, &JSHTMLVideoElementTable, this, propertyName, slot);
}

JSValue* jsHTMLVideoElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(static_cast<JSHTMLVideoElement*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->width());
}

JSValue* jsHTMLVideoElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(static_cast<JSHTMLVideoElement*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->height());
}

JSValue* jsHTMLVideoElementVideoWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(static_cast<JSHTMLVideoElement*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->videoWidth());
}

JSValue* jsHTMLVideoElementVideoHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(static_cast<JSHTMLVideoElement*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->videoHeight());
}

JSValue* jsHTMLVideoElementPoster(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(static_cast<JSHTMLVideoElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->poster());
}

JSValue* jsHTMLVideoElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLVideoElement*>(slot.slotBase())->getConstructor(exec);
}
void JSHTMLVideoElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLVideoElement, Base>(exec, propertyName, value, &JSHTMLVideoElementTable, this, slot);
}

void setJSHTMLVideoElementWidth(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(static_cast<JSHTMLVideoElement*>(thisObject)->impl());
    imp->setWidth(value->toInt32(exec));
}

void setJSHTMLVideoElementHeight(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(static_cast<JSHTMLVideoElement*>(thisObject)->impl());
    imp->setHeight(value->toInt32(exec));
}

void setJSHTMLVideoElementPoster(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(static_cast<JSHTMLVideoElement*>(thisObject)->impl());
    imp->setPoster(valueToStringWithNullCheck(exec, value));
}

JSValue* JSHTMLVideoElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLVideoElementConstructor>(exec);
}


}

#endif // ENABLE(VIDEO)
