/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLOptGroupElement.h"

#include <wtf/GetPtr.h>

#include "HTMLOptGroupElement.h"
#include "KURL.h"

#include <kjs/JSNumberCell.h>
#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLOptGroupElement)

/* Hash table */

static const HashTableValue JSHTMLOptGroupElementTableValues[4] =
{
    { "disabled", DontDelete, (intptr_t)jsHTMLOptGroupElementDisabled, (intptr_t)setJSHTMLOptGroupElementDisabled },
    { "label", DontDelete, (intptr_t)jsHTMLOptGroupElementLabel, (intptr_t)setJSHTMLOptGroupElementLabel },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLOptGroupElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLOptGroupElementTable = { 63, JSHTMLOptGroupElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLOptGroupElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLOptGroupElementConstructorTable = { 0, JSHTMLOptGroupElementConstructorTableValues, 0 };

class JSHTMLOptGroupElementConstructor : public DOMObject {
public:
    JSHTMLOptGroupElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLOptGroupElementConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLOptGroupElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLOptGroupElementConstructor::s_info = { "HTMLOptGroupElementConstructor", 0, &JSHTMLOptGroupElementConstructorTable, 0 };

bool JSHTMLOptGroupElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLOptGroupElementConstructor, DOMObject>(exec, &JSHTMLOptGroupElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLOptGroupElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLOptGroupElementPrototypeTable = { 0, JSHTMLOptGroupElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLOptGroupElementPrototype::s_info = { "HTMLOptGroupElementPrototype", 0, &JSHTMLOptGroupElementPrototypeTable, 0 };

JSObject* JSHTMLOptGroupElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSHTMLOptGroupElement>(exec);
}

const ClassInfo JSHTMLOptGroupElement::s_info = { "HTMLOptGroupElement", &JSHTMLElement::s_info, &JSHTMLOptGroupElementTable , 0 };

JSHTMLOptGroupElement::JSHTMLOptGroupElement(PassRefPtr<StructureID> structure, PassRefPtr<HTMLOptGroupElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLOptGroupElement::createPrototype(ExecState* exec)
{
    return new (exec) JSHTMLOptGroupElementPrototype(JSHTMLOptGroupElementPrototype::createStructureID(JSHTMLElementPrototype::self(exec)));
}

bool JSHTMLOptGroupElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLOptGroupElement, Base>(exec, &JSHTMLOptGroupElementTable, this, propertyName, slot);
}

JSValue* jsHTMLOptGroupElementDisabled(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLOptGroupElement* imp = static_cast<HTMLOptGroupElement*>(static_cast<JSHTMLOptGroupElement*>(slot.slotBase())->impl());
    return jsBoolean(imp->disabled());
}

JSValue* jsHTMLOptGroupElementLabel(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLOptGroupElement* imp = static_cast<HTMLOptGroupElement*>(static_cast<JSHTMLOptGroupElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->label());
}

JSValue* jsHTMLOptGroupElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLOptGroupElement*>(slot.slotBase())->getConstructor(exec);
}
void JSHTMLOptGroupElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLOptGroupElement, Base>(exec, propertyName, value, &JSHTMLOptGroupElementTable, this, slot);
}

void setJSHTMLOptGroupElementDisabled(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLOptGroupElement* imp = static_cast<HTMLOptGroupElement*>(static_cast<JSHTMLOptGroupElement*>(thisObject)->impl());
    imp->setDisabled(value->toBoolean(exec));
}

void setJSHTMLOptGroupElementLabel(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLOptGroupElement* imp = static_cast<HTMLOptGroupElement*>(static_cast<JSHTMLOptGroupElement*>(thisObject)->impl());
    imp->setLabel(valueToStringWithNullCheck(exec, value));
}

JSValue* JSHTMLOptGroupElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLOptGroupElementConstructor>(exec);
}


}
